/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.DbUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.DifPlaceEnum;
import com.kingdee.eas.fi.cas.IsMergencyEnum;
import com.kingdee.eas.fi.cas.PaymentBillCollection;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.SettleFeeTypeEnum;
import com.kingdee.eas.fm.be.BankInterfaceTypeEnum;
import com.kingdee.eas.fm.be.BankPayingBillCollection;
import com.kingdee.eas.fm.be.BankPayingBillInfo;
import com.kingdee.eas.fm.be.BankPayingBillStateEnum;
import com.kingdee.eas.fm.be.BillTypeEnum;
import com.kingdee.eas.fm.be.DifBankEnum;
import com.kingdee.eas.fm.be.IBankPayBillBuilder;
import com.kingdee.eas.fm.be.IBankPayBillCollectionBuilder;
import com.kingdee.eas.fm.be.app.service.beServiceHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PaymentBill2BankPayBillBuilder
implements IBankPayBillBuilder,
IBankPayBillCollectionBuilder {
    public BankPayingBillInfo getBankPayBillInfo(Context ctx, String billId) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(billId);
        return this.getBankPayBillCollection(ctx, idSet).get(0);
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("payerAccountBank.id"));
        sic.add(new SelectorItemInfo("payerAccountBank.*"));
        sic.add(new SelectorItemInfo("settlementType.*"));
        sic.add(new SelectorItemInfo("payBillType.*"));
        sic.add(new SelectorItemInfo("actRecAccountBank.*"));
        sic.add(new SelectorItemInfo("payerInAcctID.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("payeeAccountBankO.acctName"));
        sic.add(new SelectorItemInfo("payeeArea.province"));
        sic.add(new SelectorItemInfo("payeeArea.name"));
        return sic;
    }

    public BankPayingBillCollection getBankPayBillCollection(Context ctx, Set idSet) throws BOSException, EASBizException {
        HashMap<String, String> tm108 = new HashMap<String, String>();
        HashMap<String, Integer> be007 = new HashMap<String, Integer>();
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo f = new FilterInfo();
        f.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        env.setFilter(f);
        env.setSelector(this.getSelector());
        PaymentBillCollection payColl = PaymentBillFactory.getLocalInstance(ctx).getPaymentBillCollection(env);
        UserInfo user = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Timestamp time = new Timestamp(Calendar.getInstance().getTimeInMillis());
        BankPayingBillCollection bpColl = new BankPayingBillCollection();
        Iterator it = payColl.iterator();
        while (it.hasNext()) {
            int descriptionMaxLength;
            PaymentBillInfo info = (PaymentBillInfo)it.next();
            BankPayingBillInfo bankPayInfo = new BankPayingBillInfo();
            bankPayInfo.setIsCBPay(info.isIsCBPay());
            bankPayInfo.setCbPayInfo(info.getCbPayInfo());
            if (info.isIsCBPay()) {
                bankPayInfo.setSrcBillType(BillTypeEnum.CBPayment_Bill);
            } else {
                bankPayInfo.setSrcBillType(BillTypeEnum.PAYMENT_BILL);
            }
            bankPayInfo.setSrcBillNumber(info.getNumber());
            bankPayInfo.setCompany(info.getCompany());
            bankPayInfo.setUnitCompany(info.getCompany());
            bankPayInfo.setBizDate(info.getBizDate());
            bankPayInfo.setExpectTransTime((Date)(info.getExpectDealTime() == null ? time : info.getExpectDealTime()));
            bankPayInfo.setPayAccountBank(info.getPayerAccountBank());
            bankPayInfo.setCurrency(info.getCurrency());
            bankPayInfo.setPayAmount(info.getActPayAmt());
            bankPayInfo.setRecBank(info.getPayeeBank());
            if (EmptyUtil.isEmpty((String)info.getBankAcctName())) {
                bankPayInfo.setRecCompany(info.getPayeeName());
            } else {
                bankPayInfo.setRecCompany(info.getBankAcctName());
            }
            bankPayInfo.setBankNumber(info.getBankNumber());
            if (info.getPayBillType().isIsFinanceTranUp()) {
                if (!FMHelper.isEmpty((CoreBaseInfo)info.getActRecAccountBank())) {
                    bankPayInfo.setRecAccountBank(info.getActRecAccountBank().getBankAccountNumber());
                } else {
                    bankPayInfo.setRecAccountBank(info.getPayeeAccountBank());
                }
            } else {
                bankPayInfo.setRecAccountBank(info.getPayeeAccountBank());
            }
            String recBank = info.getPayeeBank();
            BankInterfaceTypeEnum bankInterfaceType = info.getPayerAccountBank().getBankInterfaceType();
            bankPayInfo.setRecBankNo(info.getBankNumber());
            bankPayInfo.setUsage(info.getUsage());
            if (info.getSettlementType() != null) {
                bankPayInfo.setIsPersonPay(info.getSettlementType().isIsPersonPay());
                bankPayInfo.setIsAgencyPersonPay(info.getSettlementType().isIsAgencyPersonPay());
            }
            bankPayInfo.setHandler(user);
            bankPayInfo.setBankInterfaceType(bankInterfaceType);
            bankPayInfo.setDescription(info.getUsage());
            if (be007.keySet().contains(info.getCompany().getId().toString())) {
                descriptionMaxLength = (Integer)be007.get(info.getCompany().getId().toString());
            } else {
                descriptionMaxLength = ContextHelperFactory.getLocalInstance((Context)ctx).getIntParam("BE007", (IObjectPK)new ObjectUuidPK(info.getCompany().getId().toString()));
                be007.put(info.getCompany().getId().toString(), descriptionMaxLength);
            }
            if (descriptionMaxLength > 0 && bankPayInfo.getDescription() != null && bankPayInfo.getDescription().length() > descriptionMaxLength) {
                bankPayInfo.setDescription(bankPayInfo.getDescription().substring(0, descriptionMaxLength));
            }
            bankPayInfo.setLastUpdateUser(user);
            if (IsMergencyEnum.mergercy == info.getIsEmergency()) {
                bankPayInfo.setIsEmergency(true);
            } else {
                bankPayInfo.setIsEmergency(false);
            }
            bankPayInfo.setRemitAccountBank(info.getRemitAccountBank());
            String fnumber = info.getNumber();
            if (!EmptyUtil.isEmpty((String)fnumber)) {
                fnumber = fnumber.replaceAll("[^a-z^A-Z^0-9]", "");
            }
            if (!EmptyUtil.isEmpty((String)fnumber) && fnumber.length() >= 4) {
                bankPayInfo.setSerialNumber(beServiceHelper.getSerialNumber((int)1)[0] + fnumber.substring(fnumber.length() - 4, fnumber.length()));
            } else {
                bankPayInfo.setSerialNumber(beServiceHelper.getSerialNumber((int)1)[0]);
            }
            bankPayInfo.setSourceBillId(info.getId().toString());
            String strValue = null;
            if (tm108.keySet().contains(info.getCompany().getId().toString())) {
                strValue = (String)tm108.get(info.getCompany().getId().toString());
            } else {
                strValue = ContextHelperFactory.getLocalInstance((Context)ctx).getStringParam("TM018", (IObjectPK)new ObjectUuidPK(info.getCompany().getId()));
                tm108.put(info.getCompany().getId().toString(), strValue);
            }
            if (strValue == null || "0".equals(strValue)) {
                bankPayInfo.setState(BankPayingBillStateEnum.OS);
                bankPayInfo.setSubmitTime(time);
                if (info.getIsSmart() != null && info.getIsSmart().getValue() == 5) {
                    bankPayInfo.setPriorityPay(false);
                } else {
                    bankPayInfo.setPriorityPay(true);
                }
            } else {
                bankPayInfo.setState(BankPayingBillStateEnum.OP);
                bankPayInfo.setPriorityPay(true);
            }
            bankPayInfo.setCreateTime(time);
            bankPayInfo.setFRecCountry(info.getFRecCountry());
            bankPayInfo.setRecProvinceStr(info.getRecProvince());
            bankPayInfo.setRecCityStr(info.getRecCity());
            if (DifPlaceEnum.difPlace == info.getIsDifferPlace()) {
                bankPayInfo.setIsDifferPlace(true);
            } else {
                bankPayInfo.setIsDifferPlace(false);
            }
            if (bankPayInfo.getPayAccountBank() != null && bankPayInfo.getPayAccountBank().getAgencyCompany() != null) {
                bankPayInfo.setAgencCompany(bankPayInfo.getPayAccountBank().getAgencyCompany());
            } else {
                bankPayInfo.setAgencCompany(bankPayInfo.getCompany());
            }
            bankPayInfo.setPayApplicationUnit(info.getCompany().getName());
            bankPayInfo.setRecOpenArea(info.getPayeeArea());
            bankPayInfo.setIsDifBank(DifBankEnum.getEnum((int)info.getIsDifBank().getValue()));
            if (info.getSettleFeeType() == null) {
                info.setSettleFeeType(SettleFeeTypeEnum.PayerPay);
                String sql = "UPDATE T_CAS_PaymentBill SET FSettleFeeType =1 WHERE FID = ? ";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{info.getId().toString()});
            }
            bankPayInfo.setSettleFeeMode(info.getSettleFeeType().getAlias());
            if (info.getSwiftcode() != null) {
                bankPayInfo.setSwiftCode(info.getSwiftcode());
            }
            bankPayInfo.setIsForceManual(info.isIsLanding());
            if (!EmptyUtil.isEmpty((String)info.getEmail())) {
                bankPayInfo.setEmail(info.getEmail());
            }
            if (!EmptyUtil.isEmpty((String)info.getTradingCode()) && !EmptyUtil.isEmpty((String)info.getTradingCode().trim())) {
                String tradingCode = info.getTradingCode().replace(" ", "");
                bankPayInfo.setTradingCode(tradingCode);
            }
            if (!EmptyUtil.isEmpty((String)info.getInvoiceNumber()) && !EmptyUtil.isEmpty((String)info.getInvoiceNumber().trim())) {
                String invoiceNumber = info.getInvoiceNumber().replace(" ", "");
                bankPayInfo.setInvoiceNumber(invoiceNumber);
            }
            bankPayInfo.setIsCmbForeignUser(info.isIsCmbForeignUser());
            bpColl.add(bankPayInfo);
        }
        return bpColl;
    }
}

