/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.IPaymentBill;
import com.kingdee.eas.fi.cas.PaymentBillFactory;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.fp.FPMonitorException;
import com.kingdee.eas.fm.fp.FPMonitorParamCollection;
import com.kingdee.eas.fm.fp.FPMonitorParamInfo;
import com.kingdee.eas.fm.fp.IFPItemParse;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;

public class PaymentBillParse
implements IFPItemParse {
    public FPMonitorParamCollection getParameters(Context ctx, String billId) throws BOSException, EASBizException {
        String currencyId;
        FPMonitorParamCollection coll = new FPMonitorParamCollection();
        IPaymentBill iPaymentBill = PaymentBillFactory.getLocalInstance(ctx);
        PaymentBillInfo info = iPaymentBill.getPaymentBillInfo((IObjectPK)new ObjectUuidPK(billId));
        FPMonitorParamInfo paramInfo = new FPMonitorParamInfo();
        String companyId = info.getCompany().getId().toString();
        if (!this.isExistFPItem(ctx, companyId, currencyId = info.getCurrency().getId().toString(), DateHelper.getDayBegin())) {
            return coll;
        }
        if (info.getFpItem() == null || info.getFpItem().getId() == null) {
            throw new FPMonitorException(FPMonitorException.CHECK_FINANCEPLAN);
        }
        paramInfo.setSrcBillID(info.getId().toString());
        paramInfo.setSrcBillNumber(info.getNumber());
        paramInfo.setCompanyID(companyId);
        paramInfo.setCurrencyID(currencyId);
        paramInfo.setAmount(info.getActPayAmt());
        paramInfo.setFpItemID(info.getFpItem().getId().toString());
        paramInfo.setBizDate(info.getBizDate());
        coll.add(paramInfo);
        return coll;
    }

    private boolean isExistFPItem(Context ctx, String companyId, String currencyId, Date bizDate) throws BOSException {
        ResultSet rs;
        PreparedStatement pstmt;
        Connection conn;
        block4: {
            boolean bl;
            StringBuffer sql = new StringBuffer();
            sql.append("SELECT T_FP_FPFormEntry.FID  FROM T_FP_FPFormEntry").append(" INNER JOIN T_FP_FPForm ON T_FP_FPFormEntry.FFpFormID = T_FP_FPForm.FID").append(" INNER JOIN T_FP_CycleRange ON T_FP_FPFormEntry.FCycleRangeID = T_FP_CycleRange.FID").append(" WHERE T_FP_FPForm.FState = 10").append(" AND (T_FP_FPFormEntry.FType in (2,-2,3,-3,4,-4))").append(" AND (T_FP_FPForm.FCompanyID = ?)").append(" AND (T_FP_FPForm.FCurrencyID=?)").append(" AND (? BETWEEN T_FP_CycleRange.FBeginDate AND T_FP_CycleRange.FEndDate)");
            conn = null;
            pstmt = null;
            rs = null;
            boolean count = false;
            try {
                conn = EJBFactory.getConnection((Context)ctx);
                pstmt = conn.prepareStatement(sql.toString());
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)1, (String)companyId);
                DbUtil.prepareVarcharParam((PreparedStatement)pstmt, (int)2, (String)currencyId);
                pstmt.setDate(3, TypeConversionUtils.objToDate((Object)bizDate));
                rs = pstmt.executeQuery();
                if (!rs.next()) break block4;
                bl = true;
            }
            catch (SQLException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return false;
    }
}

