/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.cas.IPaymentDisposer;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fm.bond.BondInterestInfo;
import com.kingdee.eas.fm.bond.CashSettleInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fee.BusinessFeeInfo;
import com.kingdee.eas.fm.fin.FinancingFeeBillInfo;
import com.kingdee.eas.fm.fin.RepaymentInfo;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.TransUpBillInfo;
import com.kingdee.eas.fm.ivt.FinancingAccountApplyInfo;
import com.kingdee.eas.fm.ivt.FinancingAccountInfo;
import com.kingdee.eas.fm.nt.ChequeInfo;
import com.kingdee.eas.fm.nt.DiscountBillInfo;
import com.kingdee.eas.fm.nt.EndorsementBillInfo;
import com.kingdee.eas.fm.nt.PayableBillInfo;
import com.kingdee.eas.fm.nt.ReturnBillInfo;
import com.kingdee.eas.fm.sl.LoanContractInterestInfo;
import com.kingdee.eas.fm.sl.LoanContractRepayInfo;

public class PaymentDisposerFactory {
    public static IPaymentDisposer getInstance(Context ctx, String bizBillId) throws BOSException {
        if (FMHelper.isEmpty((String)bizBillId)) {
            return null;
        }
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        BOSObjectType bosType = BOSUuid.read((String)bizBillId).getType();
        EntityObjectInfo entity = loader.getEntity(bosType);
        String disposerName = entity.getExtendedProperty("DisposerForPayment");
        if (bosType.equals((Object)BOSObjectType.create((String)"48DA3A71")) || bosType.equals((Object)BOSObjectType.create((String)"FC910EF3"))) {
            disposerName = "com.kingdee.eas.fi.ap.OtherBillDisposer";
        } else if (bosType.equals((Object)BOSObjectType.create((String)"8110AAB2"))) {
            disposerName = "com.kingdee.eas.cp.bc.BizPayBillReBack";
        } else if (bosType.equals((Object)new SettlementBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.fs.SettlementPaymentDisposer";
        } else if (bosType.equals((Object)BOSObjectType.create((String)"3171BFAD"))) {
            disposerName = "com.kingdee.eas.scm.sm.pur.PurOrderDisposer";
        } else if (bosType.equals((Object)BOSObjectType.create((String)"58C9DFCC"))) {
            disposerName = "com.kingdee.eas.scm.sm.pur.PurInvoiceDisposer";
        } else if (bosType.equals((Object)new ChequeInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.nt.ChequeDisposer";
        } else if (bosType.equals((Object)BOSObjectType.create((String)"78B50853"))) {
            disposerName = "com.kingdee.eas.scm.sm.pur.PurContractDisposer";
        } else if (bosType.equals((Object)new EndorsementBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.nt.EndorsementDisposer";
        } else if (bosType.equals((Object)new ReturnBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.nt.ReturnBillDisposer";
        } else if (bosType.equals((Object)new PayableBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.nt.PayableDisposer";
        } else if (bosType.equals((Object)new DiscountBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.nt.DiscountDisposer";
        } else if (bosType.equals((Object)new TransUpBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.fs.TransUpDisposer";
        } else if (bosType.equals((Object)RepaymentInfo.BOSTYPE)) {
            disposerName = "com.kingdee.eas.fm.fin.RepaymentDisposer";
        } else if (BOSObjectType.create((String)"F99EE589").equals((Object)bosType)) {
            disposerName = "com.kingdee.eas.scm.sm.sc.SubContractOrderDisposer";
        } else if (bosType.equals((Object)BOSObjectType.create((String)"D001019A"))) {
            disposerName = "com.kingdee.eas.fi.ap.PayRequestBillDisposer";
        } else if (bosType.equals((Object)new PaymentBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fi.cas.AgentPaymentBillDisposer";
        } else if (bosType.equals((Object)new CashSettleInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.bond.CashSettleDisposer";
        } else if (bosType.equals((Object)new BondInterestInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.bond.BondInterestDisposer";
        } else if (bosType.equals((Object)new LoanContractRepayInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.sl.LoanContractRepayDisposer";
        } else if (bosType.equals((Object)new LoanContractInterestInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.sl.LoanContractInterestDisposer";
        } else if (bosType.equals((Object)new FinancingFeeBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.fin.FinancingFeeBillDisposer";
        } else if (bosType.equals((Object)new BusinessFeeInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.fee.BusinessFeeDisposer";
        } else if (bosType.equals((Object)new FinancingAccountInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.ivt.FinancingaccountDisposer";
        } else if (bosType.equals((Object)new FinancingAccountApplyInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.ivt.FinanAccountApplyDisposer";
        } else if (bosType.equals((Object)BOSObjectType.create((String)"FDB9FA00"))) {
            disposerName = "com.kingdee.eas.fm.ps.app.service.PsBillDisposer";
        }
        if (disposerName == null) {
            return null;
        }
        try {
            return (IPaymentDisposer)Class.forName(disposerName).newInstance();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

