/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.appframework.databinding.BindingUtility;
import com.kingdee.bos.appframework.databinding.Field;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.OwnPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.metadata.entity.RelationshipType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class PropertySynchronizer {
    private ArrayList properties = null;
    private boolean isSyncOnlyTheseProps = true;
    private Context ctx;
    private EntityObjectInfo entity;

    public PropertySynchronizer(Context ctx, BOSObjectType bosType, ArrayList properties) {
        this.ctx = ctx;
        this.properties = properties;
        this.entity = this.getEntityObjectInfo(bosType);
    }

    public PropertySynchronizer(Context ctx, BOSObjectType bosType) {
        this.ctx = ctx;
        this.entity = this.getEntityObjectInfo(bosType);
    }

    public void reverse() {
        this.isSyncOnlyTheseProps = !this.isSyncOnlyTheseProps;
    }

    public void syncProperties(CoreBaseInfo fromInfo, CoreBaseInfo toInfo) throws EASBizException, BOSException {
        boolean sync = false;
        if (fromInfo == null || toInfo == null || !fromInfo.getBOSType().equals((Object)toInfo.getBOSType())) {
            return;
        }
        if (this.isSyncOnlyTheseProps) {
            this.syncAppointProperties(fromInfo, toInfo);
        } else {
            this.syncOtherProperties(fromInfo, toInfo);
        }
    }

    private EntityObjectInfo getEntityObjectInfo(BOSObjectType bosType) {
        IMetaDataLoader loader = null;
        loader = this.ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)this.ctx);
        EntityObjectInfo entity = loader.getEntity(bosType);
        return entity;
    }

    private void syncOtherProperties(CoreBaseInfo fromInfo, CoreBaseInfo toInfo) throws EASBizException, BOSException {
        CoreBaseInfo oldValue = this.getOldValue((IObjectPK)new ObjectUuidPK(fromInfo.getId().toString()));
        Set changedSet = this.getChangedProperties(fromInfo, oldValue);
        for (String propertyName : changedSet) {
            if (this.properties.contains(propertyName)) continue;
            Object vo = BindingUtility.getValue((IObjectValue)fromInfo, (Field)new Field(propertyName));
            BindingUtility.setValue((IObjectValue)toInfo, (Field)new Field(propertyName), (Object)vo);
        }
    }

    private void syncAppointProperties(CoreBaseInfo fromInfo, CoreBaseInfo toInfo) throws EASBizException, BOSException {
        CoreBaseInfo oldValue = this.getOldValue((IObjectPK)new ObjectUuidPK(fromInfo.getId().toString()));
        Set changedSet = this.getChangedProperties(fromInfo, oldValue);
        for (int i = 0; i < this.properties.size(); ++i) {
            String propertyName = (String)this.properties.get(i);
            if (!changedSet.contains(propertyName)) continue;
            Object vo = BindingUtility.getValue((IObjectValue)fromInfo, (Field)new Field(propertyName));
            BindingUtility.setValue((IObjectValue)toInfo, (Field)new Field(propertyName), (Object)vo);
        }
    }

    public Set getChangedProperties(CoreBaseInfo fromInfo, CoreBaseInfo compareValue) throws EASBizException, BOSException {
        HashSet set = new HashSet();
        PropertyCollection pc = this.entity.getInheritedNoDuplicatedProperties();
        for (PropertyInfo prop : pc) {
            Set changed = this.getChangedProperties(fromInfo, compareValue, prop);
            if (changed.size() <= 0) continue;
            set.addAll(changed);
        }
        return set;
    }

    private Set getChangedProperties(CoreBaseInfo fromInfo, CoreBaseInfo oldValue, PropertyInfo prop) {
        RelationshipInfo relation;
        HashSet<String> set = new HashSet<String>();
        String name = prop.getName();
        Object vo = BindingUtility.getValue((IObjectValue)fromInfo, (Field)new Field(name));
        Object oldVO = BindingUtility.getValue((IObjectValue)oldValue, (Field)new Field(name));
        if (FMHelper.isEmpty((Object)vo) && !FMHelper.isEmpty((Object)oldVO) || !FMHelper.isEmpty((Object)vo) && FMHelper.isEmpty((Object)oldVO)) {
            set.add(name);
            return set;
        }
        if (FMHelper.isEmpty((Object)vo) && FMHelper.isEmpty((Object)oldVO)) {
            return set;
        }
        if (prop instanceof OwnPropertyInfo) {
            OwnPropertyInfo ownProp = (OwnPropertyInfo)prop;
            if (ownProp.getDataType().isValidBasicType()) {
                if (vo instanceof Boolean) {
                    if (!vo.equals(oldVO)) {
                        set.add(name);
                    }
                } else {
                    Comparable compareAbleVO = (Comparable)vo;
                    Comparable compareAbleOldVO = (Comparable)oldVO;
                    if (compareAbleVO.compareTo(compareAbleOldVO) != 0) {
                        set.add(name);
                    }
                }
            } else if (!vo.equals(oldVO)) {
                set.add(name);
            }
        } else if (prop instanceof LinkPropertyInfo && (relation = ((LinkPropertyInfo)prop).getRelationship()).getType() == RelationshipType.ASSOCIATION) {
            CoreBaseInfo voInfo = (CoreBaseInfo)vo;
            CoreBaseInfo oldVOInfo = (CoreBaseInfo)oldVO;
            if (!voInfo.getId().equals((Object)oldVOInfo.getId())) {
                set.add(name);
            }
        }
        return set;
    }

    protected CoreBaseInfo getOldValue(IObjectPK pk) throws EASBizException, BOSException {
        BOSObjectType type = BOSUuid.read((String)pk.toString()).getType();
        if (this.ctx != null) {
            return (CoreBaseInfo)DynamicObjectFactory.getLocalInstance((Context)this.ctx).getValue(type, pk);
        }
        return (CoreBaseInfo)DynamicObjectFactory.getRemoteInstance().getValue(type, pk);
    }
}

