/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.fi.cas.IReceivingDisposer;
import com.kingdee.eas.fm.bond.BondReleaseReportInfo;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.fs.SettlementBillInfo;
import com.kingdee.eas.fm.fs.TransDownBillInfo;
import com.kingdee.eas.fm.im.AccrualBillInfo;
import com.kingdee.eas.fm.nt.AssureAmountReturnBillInfo;
import com.kingdee.eas.fm.nt.DiscountBillInfo;
import com.kingdee.eas.fm.nt.ReceivableBillInfo;
import com.kingdee.eas.fm.nt.ReturnBillInfo;
import com.kingdee.eas.fm.sl.LoanFetchInfo;
import com.kingdee.eas.fm.td.IntReceivedBillInfo;

public class ReceivingDisposerFactory {
    public static IReceivingDisposer getInstance(Context ctx, String bizBillId) throws BOSException {
        if (FMHelper.isEmpty((String)bizBillId)) {
            return null;
        }
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        BOSObjectType bosType = BOSUuid.read((String)bizBillId).getType();
        EntityObjectInfo entity = loader.getEntity(bosType);
        String disposerName = entity.getExtendedProperty("DisposerForReceiving");
        if (bosType.equals((Object)BOSObjectType.create((String)"FC910EF3")) || bosType.equals((Object)BOSObjectType.create((String)"48DA3A71"))) {
            disposerName = "com.kingdee.eas.fi.ar.OtherBillDisposer";
        } else if (bosType.equals((Object)new SettlementBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.fs.SettlementReceivingDisposer";
        } else if (bosType.equals((Object)BOSObjectType.create((String)"C48A423A"))) {
            disposerName = "com.kingdee.eas.scm.sd.sale.SaleOrderDisposer";
        } else if (bosType.equals((Object)BOSObjectType.create((String)"87CBF319"))) {
            disposerName = "com.kingdee.eas.scm.sd.sale.SaleInvoiceDisposer";
        } else if (bosType.equals((Object)new ReceivableBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.nt.ReceivableDisposer";
        } else if (bosType.equals((Object)new DiscountBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.nt.DiscountDisposer";
        } else if (bosType.equals((Object)new ReturnBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.nt.ReturnBillDisposer";
        } else if (bosType.equals((Object)new TransDownBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.fs.TransDownDisposer";
        } else if (bosType.equals((Object)new AccrualBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.im.AccuralBillDisposer";
        } else if (bosType.equals((Object)BOSObjectType.create((String)"29F55EA6"))) {
            disposerName = "com.kingdee.eas.scm.sd.sale.SaleContractDisposer";
        } else if (bosType.equals((Object)new AssureAmountReturnBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.nt.AssureAmountReturnBillDisposer";
        } else if (bosType.equals((Object)new LoanFetchInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.sl.LoanFetchDisposer";
        } else if (bosType.equals((Object)new BondReleaseReportInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.bond.BondReleaseReportDisposer";
        } else if (bosType.equals((Object)BOSObjectType.create((String)"0B104F5C"))) {
            disposerName = "com.kingdee.eas.cp.bc.RePayBillReBack";
        } else if (bosType.equals((Object)BOSObjectType.create((String)"B49593FD"))) {
            disposerName = "com.kingdee.eas.fm.ivt.FinanRedeemDisposer";
        } else if (bosType.equals((Object)BOSObjectType.create((String)"FA44FD5B"))) {
            disposerName = "com.kingdee.eas.fi.ar.ArRefundBillDisposer";
        } else if (bosType.equals((Object)BOSObjectType.create((String)"65873F29"))) {
            disposerName = "com.kingdee.eas.sscbusiness.contract.BizReceivingBillReBack";
        } else if (bosType.equals((Object)new IntReceivedBillInfo().getBOSType())) {
            disposerName = "com.kingdee.eas.fm.td.IntReceivedBillDisposer";
        }
        if (disposerName == null) {
            return null;
        }
        try {
            return (IReceivingDisposer)Class.forName(disposerName).newInstance();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

