/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.BookNotifyException;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CasException;
import com.kingdee.eas.fi.cas.CasRecPayUtil;
import com.kingdee.eas.fi.cas.DefaultBookNotifyBuilder;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.gl.EntryDC;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherAssistRecordCollection;
import com.kingdee.eas.fi.gl.VoucherAssistRecordInfo;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherEntryCollection;
import com.kingdee.eas.fi.gl.VoucherEntryInfo;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.UserOptionFactory;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.util.DateTimeUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class VoucherBookNotifyBuilder
extends DefaultBookNotifyBuilder {
    public static final String BOOK_DATE_NAME = "dpkBookDate";
    public static final String BOOK_APPOINT_DATE_UI_NAME = "com.kingdee.eas.fi.cas.client.BookAppointDateUI";
    public static final String BY_BILLTIME_BUTTON_NAME = "kDRadioButtonBillTime";
    private static final String IS_ACCOUNT_BUTTON_NAME = "kDRadioButtonAccount";
    public static final String IS_CASH_BUTTON_NAME = "kDRadioButtonCash";
    protected static final String BOOK_USER_OPTION_UI = "com.kingdee.eas.fi.cas.client.BookUserOptionUI";
    public int dealNoAssistType = 0;

    protected SelectorItemCollection getVoucherSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("period.*"));
        sic.add(new SelectorItemInfo("voucherType.id"));
        sic.add(new SelectorItemInfo("voucherType.name"));
        sic.add(new SelectorItemInfo("entries.account.*"));
        sic.add(new SelectorItemInfo("entries.account.number"));
        sic.add(new SelectorItemInfo("entries.account.isCash"));
        sic.add(new SelectorItemInfo("entries.account.isBank"));
        sic.add(new SelectorItemInfo("entries.currency.id"));
        sic.add(new SelectorItemInfo("entries.currency.name"));
        sic.add(new SelectorItemInfo("entries.*"));
        sic.add(new SelectorItemInfo("entries.assistRecords.*"));
        sic.add(new SelectorItemInfo("entries.assistRecords.settlementType.*"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.*"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.bankAccount.*"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.bankAccount.name"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.bankAccount.account.*"));
        sic.add(new SelectorItemInfo("entries.assistRecords.assGrp.bankAccount.account.name"));
        return sic;
    }

    protected Map getBookOptionMap(Context ctx, String uiName, CompanyOrgUnitInfo company) throws BOSException, EASBizException {
        Map map = UserOptionFactory.getLocalInstance((Context)ctx).getUserOptionMap(null, company.getId().toString(), uiName, null);
        return map;
    }

    protected Map getBookOptionMap(Context ctx, String uiName) throws BOSException, EASBizException {
        Map map = UserOptionFactory.getLocalInstance((Context)ctx).getUserOptionMap(uiName);
        return map;
    }

    private VoucherEntryCollection getOppVoucherEntry(Context ctx, VoucherEntryCollection entryCollection) throws BOSException, EASBizException {
        VoucherEntryInfo voucherEntryInfo = null;
        VoucherEntryCollection oppVoucherEntry = new VoucherEntryCollection();
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            voucherEntryInfo = entryCollection.get(i);
            AccountViewInfo accountViewInfo = voucherEntryInfo.getAccount();
            if (accountViewInfo.isIsCash() || accountViewInfo.isIsBank()) continue;
            oppVoucherEntry.add(voucherEntryInfo);
        }
        if (oppVoucherEntry.size() == 0) {
            oppVoucherEntry.add(entryCollection.get(0));
        }
        return oppVoucherEntry;
    }

    private VoucherEntryCollection getCashOrBankVoucherEntry(Context ctx, VoucherEntryCollection entryCollection) {
        VoucherEntryInfo voucherEntryInfo = null;
        VoucherEntryCollection cashOrBankVoucherEntry = new VoucherEntryCollection();
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            voucherEntryInfo = entryCollection.get(i);
            AccountViewInfo accountViewInfo = voucherEntryInfo.getAccount();
            if (!accountViewInfo.isIsCash() && !accountViewInfo.isIsBank()) continue;
            cashOrBankVoucherEntry.add(voucherEntryInfo);
        }
        return cashOrBankVoucherEntry;
    }

    private JournalCollection getJournalCollByOppAccount(Context ctx, VoucherInfo voucherInfo, VoucherEntryCollection cashOrBankVoucherEntry, VoucherEntryCollection oppVoucherEntry) throws BOSException, EASBizException {
        JournalCollection journalCollection = new JournalCollection();
        if (cashOrBankVoucherEntry.size() == oppVoucherEntry.size() && oppVoucherEntry.size() == 1) {
            JournalCollection journalCollection11;
            AccountViewInfo oppAccount = oppVoucherEntry.get(0).getAccount();
            JournalCollection journalCollection1 = journalCollection11 = this.createOneByOne(ctx, voucherInfo, cashOrBankVoucherEntry, oppAccount);
            return journalCollection1;
        }
        boolean isOneToMulti = true;
        VoucherEntryInfo casBankvoucherEntryInfo = cashOrBankVoucherEntry.get(0);
        EntryDC dc = casBankvoucherEntryInfo.getEntryDC();
        int size = oppVoucherEntry.size();
        for (int k = 0; k < size; ++k) {
            if (!oppVoucherEntry.get(k).getEntryDC().equals((Object)dc)) continue;
            isOneToMulti = false;
        }
        if (!isOneToMulti && cashOrBankVoucherEntry.size() > 1) {
            AccountViewInfo oppAccount = oppVoucherEntry.get(0).getAccount();
            JournalCollection journalCollection11 = new JournalCollection();
            int size2 = cashOrBankVoucherEntry.size();
            for (int i = 0; i < size2; ++i) {
                VoucherEntryInfo voucherEntryInfo = cashOrBankVoucherEntry.get(i);
                AccountViewInfo accountViewInfo = voucherEntryInfo.getAccount();
                JournalInfo journalInfo = this.createBaseJournalInfo(ctx, voucherInfo);
                if (accountViewInfo.isIsBank()) {
                    journalInfo.setType(JournalTypeEnum.BANK);
                } else if (accountViewInfo.isIsCash()) {
                    journalInfo.setType(JournalTypeEnum.CASH);
                }
                journalInfo.setCurrency(voucherEntryInfo.getCurrency());
                journalInfo.setAccountView(voucherEntryInfo.getAccount());
                journalInfo.setBillEntryID(voucherEntryInfo.getId().toString());
                journalInfo.setDescription(voucherEntryInfo.getDescription());
                journalInfo.setOppAccountView(oppAccount);
                if (voucherEntryInfo.getEntryDC().equals((Object)EntryDC.CREDIT)) {
                    journalInfo.setCreditAmount(voucherEntryInfo.getOriginalAmount());
                } else if (voucherEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                    journalInfo.setDebitAmount(voucherEntryInfo.getOriginalAmount());
                }
                if (accountViewInfo.isIsBank()) {
                    journalCollection11.addCollection(this.createBankJournalByEntry(ctx, voucherEntryInfo, accountViewInfo, journalInfo));
                    continue;
                }
                if (!accountViewInfo.isIsCash()) continue;
                journalCollection11.add(journalInfo);
            }
            JournalCollection journalCollection1 = journalCollection11;
            return journalCollection1;
        }
        if (cashOrBankVoucherEntry.size() == 1 && oppVoucherEntry.size() > 1) {
            if (casBankvoucherEntryInfo.getAccount().isIsBank() && this.isHaveMultiBankAccount(casBankvoucherEntryInfo.getAssistRecords())) {
                JournalCollection journalCollection11;
                AccountViewInfo oppAccount = oppVoucherEntry.get(0).getAccount();
                JournalCollection journalCollection1 = journalCollection11 = this.createOneByOne(ctx, voucherInfo, cashOrBankVoucherEntry, oppAccount);
                return journalCollection1;
            }
            VoucherEntryInfo voucherEntryInfo = null;
            BigDecimal amount = CasConstants.ZERO;
            BigDecimal exchange = CasConstants.ZERO;
            BigDecimal oppExanchange = CasConstants.ZERO;
            CurrencyInfo currencyId = casBankvoucherEntryInfo.getCurrency();
            exchange = casBankvoucherEntryInfo.getLocalExchangeRate();
            if (exchange == null) {
                exchange = CasConstants.ONE;
            }
            BOSUuid oppCurrencyId = null;
            int size3 = oppVoucherEntry.size();
            for (int i = 0; i < size3; ++i) {
                voucherEntryInfo = oppVoucherEntry.get(i);
                JournalInfo bookNotifyInfo = this.createBaseJournalInfo(ctx, voucherInfo);
                if (casBankvoucherEntryInfo.getAccount().isIsBank()) {
                    bookNotifyInfo.setType(JournalTypeEnum.BANK);
                } else if (casBankvoucherEntryInfo.getAccount().isIsCash()) {
                    bookNotifyInfo.setType(JournalTypeEnum.CASH);
                }
                oppCurrencyId = voucherEntryInfo.getCurrency().getId();
                bookNotifyInfo.setCurrency(currencyId);
                bookNotifyInfo.setAccountView(casBankvoucherEntryInfo.getAccount());
                bookNotifyInfo.setBillEntryID(casBankvoucherEntryInfo.getId().toString());
                bookNotifyInfo.setDescription(voucherEntryInfo.getDescription());
                bookNotifyInfo.setOppAccountView(oppVoucherEntry.get(i).getAccount());
                amount = voucherEntryInfo.getLocalAmount();
                if (amount == null) {
                    amount = CasConstants.ZERO;
                }
                if (!currencyId.equals((Object)oppCurrencyId)) {
                    ExchangeRateInfo exchangeRateInfo = CasRecPayUtil.getExchangeRate(ctx, voucherInfo.getCompany(), currencyId.getId().toString(), null, voucherInfo.getBizDate());
                    boolean isIndirectExRate = false;
                    if (exchangeRateInfo != null) {
                        isIndirectExRate = CasRecPayUtil.isIndirectExRate(exchangeRateInfo);
                    }
                    amount = isIndirectExRate ? amount.multiply(exchange) : amount.divide(exchange, 4, 4);
                }
                if (voucherEntryInfo.getEntryDC().equals((Object)EntryDC.CREDIT)) {
                    bookNotifyInfo.setDebitAmount(amount);
                } else if (voucherEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                    bookNotifyInfo.setCreditAmount(amount);
                }
                AccountViewInfo viewInfo = casBankvoucherEntryInfo.getAccount();
                if (viewInfo.isIsBank()) {
                    AccountBankInfo bankAcct = this.getBankAccountFromBankEntry(ctx, casBankvoucherEntryInfo);
                    if (EmptyUtil.isEmpty((CoreBaseInfo)bankAcct)) continue;
                    bookNotifyInfo.setAccountBank(bankAcct);
                }
                journalCollection.add(bookNotifyInfo);
            }
        }
        return journalCollection;
    }

    private AccountBankInfo getBankAccountFromBankEntry(Context ctx, VoucherEntryInfo bankEntryInfo) throws BOSException, EASBizException {
        AccountViewInfo accountViewInfo = bankEntryInfo.getAccount();
        String accountId = accountViewInfo.getId().toString();
        VoucherAssistRecordCollection voucherAssistRecordCollection = bankEntryInfo.getAssistRecords();
        if (voucherAssistRecordCollection == null || voucherAssistRecordCollection.size() == 0) {
            return this.getBankAccountOnNoAssist(ctx, accountId, accountViewInfo.getNumber());
        }
        if (voucherAssistRecordCollection.size() > 1) {
            return null;
        }
        VoucherAssistRecordInfo assistRecordInfo = voucherAssistRecordCollection.get(0);
        AssistantHGInfo assistantHGInfo = assistRecordInfo.getAssGrp();
        AccountBankInfo accountBankInfo = null;
        if (assistantHGInfo != null) {
            accountBankInfo = assistantHGInfo.getBankAccount();
        }
        if (accountBankInfo == null) {
            accountBankInfo = this.getBankAccountOnNoAssist(ctx, accountId, accountViewInfo.getNumber());
        }
        return accountBankInfo;
    }

    private JournalCollection createOneByOne(Context ctx, VoucherInfo voucherInfo, VoucherEntryCollection cashOrBankVoucherEntry, AccountViewInfo oppAccount) throws BOSException, EASBizException {
        JournalCollection journalCollection11 = new JournalCollection();
        int size = cashOrBankVoucherEntry.size();
        for (int i = 0; i < size; ++i) {
            VoucherEntryInfo voucherEntryInfo1 = cashOrBankVoucherEntry.get(i);
            AccountViewInfo accountViewInfo = voucherEntryInfo1.getAccount();
            JournalInfo journalInfo = this.createBaseJournalInfo(ctx, voucherInfo);
            if (accountViewInfo.isIsBank()) {
                journalInfo.setType(JournalTypeEnum.BANK);
            } else if (accountViewInfo.isIsCash()) {
                journalInfo.setType(JournalTypeEnum.CASH);
            }
            journalInfo.setCurrency(voucherEntryInfo1.getCurrency());
            journalInfo.setAccountView(voucherEntryInfo1.getAccount());
            journalInfo.setBillEntryID(voucherEntryInfo1.getId().toString());
            journalInfo.setDescription(voucherEntryInfo1.getDescription());
            journalInfo.setOppAccountView(oppAccount);
            if (voucherEntryInfo1.getEntryDC().equals((Object)EntryDC.CREDIT)) {
                journalInfo.setCreditAmount(voucherEntryInfo1.getOriginalAmount());
            } else if (voucherEntryInfo1.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                journalInfo.setDebitAmount(voucherEntryInfo1.getOriginalAmount());
            }
            if (accountViewInfo.isIsBank()) {
                journalCollection11.addCollection(this.createBankJournalByEntry(ctx, voucherEntryInfo1, accountViewInfo, journalInfo));
                continue;
            }
            if (!accountViewInfo.isIsCash()) continue;
            journalCollection11.add(journalInfo);
        }
        return journalCollection11;
    }

    private JournalCollection createBankJournalByEntry(Context ctx, VoucherEntryInfo voucherEntryInfo, AccountViewInfo accountViewInfo, JournalInfo tempJournal) throws BOSException, EASBizException {
        JournalCollection journalColl = new JournalCollection();
        String accountId = accountViewInfo.getId().toString();
        VoucherAssistRecordCollection voucherAssistRecordCollection = voucherEntryInfo.getAssistRecords();
        if (voucherAssistRecordCollection == null || voucherAssistRecordCollection.size() == 0) {
            JournalInfo journalInfo = new JournalInfo();
            journalInfo.putAll((IObjectValue)tempJournal);
            AccountBankInfo bankAcct = this.getBankAccountOnNoAssist(ctx, accountId, accountViewInfo.getNumber());
            if (!EmptyUtil.isEmpty((CoreBaseInfo)bankAcct)) {
                journalInfo.setAccountBank(bankAcct);
                journalColl.add(journalInfo);
            }
        } else {
            for (int j = 0; j < voucherAssistRecordCollection.size(); ++j) {
                VoucherAssistRecordInfo assistRecordInfo = voucherAssistRecordCollection.get(j);
                AssistantHGInfo assistantHGInfo = assistRecordInfo.getAssGrp();
                AccountBankInfo accountBankInfo = null;
                if (assistantHGInfo != null) {
                    accountBankInfo = assistantHGInfo.getBankAccount();
                }
                if (accountBankInfo == null && (accountBankInfo = this.getBankAccountOnNoAssist(ctx, accountId, accountViewInfo.getNumber())) == null) continue;
                JournalInfo journalInfo = new JournalInfo();
                journalInfo.putAll((IObjectValue)tempJournal);
                journalInfo.setAccountBank(accountBankInfo);
                if (accountBankInfo != null && accountBankInfo.getAccount() != null) {
                    journalInfo.setAccountView(accountBankInfo.getAccount());
                }
                if (assistRecordInfo.getSettlementType() != null) {
                    journalInfo.setSettlementType(assistRecordInfo.getSettlementType());
                }
                journalInfo.setSettlementNumber(assistRecordInfo.getSettlementCode());
                if (assistRecordInfo.getDescription() != null) {
                    String desc = assistRecordInfo.getDescription();
                    journalInfo.setDescription(desc);
                }
                if (voucherEntryInfo.getEntryDC().equals((Object)EntryDC.CREDIT)) {
                    journalInfo.setCreditAmount(assistRecordInfo.getOriginalAmount());
                } else if (voucherEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                    journalInfo.setDebitAmount(assistRecordInfo.getOriginalAmount());
                }
                Map map = this.getBookOptionMap(ctx, BOOK_USER_OPTION_UI, journalInfo.getCompany());
                if (map == null) {
                    throw new BookNotifyException(BookNotifyException.SETOPTION);
                }
                boolean isByAppointTime = new Boolean((String)map.get("kDRadioButtonAppointTime"));
                boolean isByBizTime = new Boolean((String)map.get("kDRadioButtonBizTime"));
                if (!isByAppointTime && isByBizTime) {
                    journalInfo.setBizDate(assistRecordInfo.getBizDate());
                    journalInfo.setCreateDate(assistRecordInfo.getBizDate());
                }
                journalColl.add(journalInfo);
            }
        }
        return journalColl;
    }

    private JournalInfo createBaseJournalInfo(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        JournalInfo journalInfo = new JournalInfo();
        journalInfo.setCompany(voucherInfo.getCompany());
        journalInfo.setSource(JournalSourceEnum.BYVOUCHER);
        journalInfo.setBizDate(DateTimeUtils.truncateDate((Date)voucherInfo.getBizDate()));
        journalInfo.setVoucherType(voucherInfo.getVoucherType());
        journalInfo.setVoucherNumber(voucherInfo.getNumber());
        journalInfo.setBillType(BillTypeEnum.voucher);
        journalInfo.setBillNumber(voucherInfo.getNumber());
        Date bookDate = this.getBookDate(ctx, voucherInfo);
        journalInfo.setCreateDate(bookDate);
        PeriodInfo bookPeriodInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)bookDate, (CompanyOrgUnitInfo)voucherInfo.getCompany());
        journalInfo.setPeriod(bookPeriodInfo);
        return journalInfo;
    }

    private Date getBookDate(Context ctx, VoucherInfo voucherInfo) throws BOSException, EASBizException {
        PeriodInfo currPeriod;
        Map map = this.getBookOptionMap(ctx, BOOK_USER_OPTION_UI, voucherInfo.getCompany());
        if (map == null) {
            throw new BookNotifyException(BookNotifyException.SETOPTION);
        }
        boolean isBySystemTime = new Boolean((String)map.get("kDRadioButtonSystemTime"));
        boolean isByBillTime = new Boolean((String)map.get(BY_BILLTIME_BUTTON_NAME));
        boolean isByBizTime = new Boolean((String)map.get("kDRadioButtonBizTime"));
        boolean isByAppointTime = new Boolean((String)map.get("kDRadioButtonAppointTime"));
        Date bookDate = null;
        if (isBySystemTime) {
            bookDate = DateHelper.getDayBegin();
        } else if (isByBillTime) {
            bookDate = voucherInfo.getBookedDate();
        } else if (isByAppointTime) {
            Map bookDateMap = this.getBookOptionMap(ctx, BOOK_APPOINT_DATE_UI_NAME, voucherInfo.getCompany());
            if (bookDateMap != null && bookDateMap.get(BOOK_DATE_NAME) != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("MM-dd-yyyy");
                bookDate = DateHelper.stringToDate((String)((String)bookDateMap.get(BOOK_DATE_NAME)));
            } else {
                bookDate = voucherInfo.getBookedDate();
            }
        } else if (isByBizTime && (bookDate = voucherInfo.getBizDate()).before((currPeriod = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)voucherInfo.getCompany())).getBeginDate())) {
            bookDate = currPeriod.getBeginDate();
        }
        return bookDate;
    }

    private boolean isHaveMultiBankAccount(VoucherAssistRecordCollection voucherAssistRecordCollection) {
        if (voucherAssistRecordCollection == null || voucherAssistRecordCollection.size() == 0) {
            return false;
        }
        if (voucherAssistRecordCollection.size() == 1) {
            return false;
        }
        for (int j = 0; j < voucherAssistRecordCollection.size(); ++j) {
            VoucherAssistRecordInfo assistRecordInfo = voucherAssistRecordCollection.get(j);
            AssistantHGInfo assistantHGInfo = assistRecordInfo.getAssGrp();
            if (assistantHGInfo == null || assistantHGInfo.getBankAccount() == null) continue;
            return true;
        }
        return false;
    }

    protected AccountBankInfo getBankAccountOnNoAssist(Context ctx, String accountId, String acctNumber) throws BOSException, EASBizException {
        AccountBankInfo accountBankInfo = null;
        IAccountBank accountBank = AccountBankFactory.getLocalInstance((Context)ctx);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentCompany();
        fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId()));
        fi.getFilterItems().add(new FilterItemInfo("account.id", (Object)accountId));
        evi.setFilter(fi);
        evi.getSelector().add("*");
        evi.getSelector().add("account.*");
        AccountBankCollection accountBankCollection = accountBank.getAccountBankCollection(evi);
        if (acctNumber == null) {
            acctNumber = "";
        }
        if (accountBankCollection == null || accountBankCollection.size() == 0) {
            return accountBankInfo;
        }
        if (accountBankCollection.size() > 1) {
            if (this.dealNoAssistType == 0) {
                throw new BookNotifyException(BookNotifyException.MULTI_ACCOUNT, new Object[]{acctNumber});
            }
            accountBankInfo = accountBankCollection.get(0);
        } else {
            accountBankInfo = accountBankCollection.get(0);
        }
        return accountBankInfo;
    }

    @Override
    public JournalCollection getJournalColl(Context ctx, String billId) throws BOSException, EASBizException {
        HashSet<String> set = new HashSet<String>();
        set.add(billId);
        return this.getJournalColl(ctx, set);
    }

    @Override
    public JournalCollection getJournalColl(Context ctx, Set set) throws BOSException, EASBizException {
        IVoucher voucher = VoucherFactory.getLocalInstance((Context)ctx);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)set, CompareType.INCLUDE));
        ev.setFilter(filter);
        ev.getSelector().addObjectCollection((IObjectCollection)this.getVoucherSelector());
        VoucherCollection voucherCollection = voucher.getVoucherCollection(ev);
        JournalCollection journalCollection = new JournalCollection();
        for (int i = 0; i < voucherCollection.size(); ++i) {
            VoucherInfo srcInfo = voucherCollection.get(i);
            Map map = this.getBookOptionMap(ctx, BOOK_USER_OPTION_UI, srcInfo.getCompany());
            if (map == null || map.get(IS_CASH_BUTTON_NAME) == null) {
                throw new BookNotifyException(BookNotifyException.SETOPTION);
            }
            boolean isByCash = new Boolean((String)map.get(IS_CASH_BUTTON_NAME));
            JournalCollection destColl = this.getJouranlCollByVoucher(ctx, isByCash, srcInfo);
            journalCollection.addCollection(destColl);
        }
        return journalCollection;
    }

    protected JournalCollection getJouranlCollByVoucher(Context ctx, boolean isByCash, VoucherInfo srcInfo) throws BOSException, EASBizException {
        JournalCollection journalCollection1 = new JournalCollection();
        VoucherEntryCollection entryCollection = srcInfo.getEntries();
        VoucherEntryCollection cashOrBankVoucherEntry = this.getCashOrBankVoucherEntry(ctx, entryCollection);
        VoucherEntryCollection oppVoucherEntry = this.getOppVoucherEntry(ctx, entryCollection);
        boolean mustByCash = false;
        if (cashOrBankVoucherEntry.size() > 1 || oppVoucherEntry.size() <= 1) {
            mustByCash = true;
        }
        if (isByCash || mustByCash) {
            AccountViewInfo oppAccount = oppVoucherEntry.get(0).getAccount();
            journalCollection1 = this.createJournalByAccount(ctx, srcInfo, cashOrBankVoucherEntry, oppAccount);
        } else {
            journalCollection1 = this.getJournalCollByOppAccount(ctx, srcInfo, cashOrBankVoucherEntry, oppVoucherEntry);
        }
        UserInfo userInfo = ContextHelperFactory.getLocalInstance((Context)ctx).getCurrentUser();
        Set srcBillSet = FMHelper.getSrcBillIdSet((Context)ctx, (String)srcInfo.getId().toString());
        int size = journalCollection1.size();
        for (int i1 = 0; i1 < size; ++i1) {
            AccountViewInfo opp;
            JournalInfo journalInfo = journalCollection1.get(i1);
            journalInfo.setBillId(srcInfo.getId().toString());
            journalInfo.setVoucherId(srcInfo.getId().toString());
            journalInfo.setVoucherNumber(srcInfo.getNumber());
            journalInfo.setVoucherType(srcInfo.getVoucherType());
            journalInfo.setCashier(userInfo);
            journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
            if (journalInfo.getDebitAmount() == null) {
                journalInfo.setDebitAmount(FMConstants.ZERO);
            }
            if (journalInfo.getCreditAmount() == null) {
                journalInfo.setCreditAmount(FMConstants.ZERO);
            }
            if (journalInfo.getDebitAmount().signum() != 0) {
                journalInfo.setIsDebit(true);
            } else {
                journalInfo.setIsDebit(false);
            }
            if (!isByCash && !mustByCash || (opp = this.getOppAccountView(ctx, srcInfo.getEntries(), journalInfo)) == null) continue;
            journalInfo.setOppAccountView(opp);
        }
        JournalCollection destColl = journalCollection1;
        return destColl;
    }

    private AccountViewInfo getOppAccountView(Context ctx, VoucherEntryCollection entries, JournalInfo journalInfo) {
        AccountViewInfo rst = null;
        for (int i = 0; i < entries.size(); ++i) {
            VoucherEntryInfo entry = entries.get(i);
            if (!entry.getCurrency().getId().equals((Object)journalInfo.getCurrency().getId())) continue;
            if (journalInfo.isIsDebit() && entry.getEntryDC() == EntryDC.CREDIT) {
                if (!journalInfo.getDebitAmount().equals(entry.getOriginalAmount())) continue;
                rst = entry.getAccount();
                break;
            }
            if (journalInfo.isIsDebit() || entry.getEntryDC() != EntryDC.DEBIT) continue;
            if (!journalInfo.getCreditAmount().equals(entry.getOriginalAmount())) break;
            rst = entry.getAccount();
            break;
        }
        return rst;
    }

    private JournalCollection createJournalByAccount(Context ctx, VoucherInfo srcInfo, VoucherEntryCollection cashOrBankVoucherEntry, AccountViewInfo oppAccount) throws BOSException, EASBizException {
        JournalCollection journalCollection11 = new JournalCollection();
        int size = cashOrBankVoucherEntry.size();
        for (int i1 = 0; i1 < size; ++i1) {
            VoucherEntryInfo voucherEntryInfo = cashOrBankVoucherEntry.get(i1);
            AccountViewInfo accountViewInfo = voucherEntryInfo.getAccount();
            JournalInfo journalInfo = this.createBaseJournalInfo(ctx, srcInfo);
            if (accountViewInfo.isIsBank()) {
                journalInfo.setType(JournalTypeEnum.BANK);
            } else if (accountViewInfo.isIsCash()) {
                journalInfo.setType(JournalTypeEnum.CASH);
            }
            journalInfo.setCurrency(voucherEntryInfo.getCurrency());
            journalInfo.setAccountView(voucherEntryInfo.getAccount());
            journalInfo.setBillEntryID(voucherEntryInfo.getId().toString());
            journalInfo.setDescription(voucherEntryInfo.getDescription());
            journalInfo.setOppAccountView(oppAccount);
            if (voucherEntryInfo.getEntryDC().equals((Object)EntryDC.CREDIT)) {
                journalInfo.setCreditAmount(voucherEntryInfo.getOriginalAmount());
            } else if (voucherEntryInfo.getEntryDC().equals((Object)EntryDC.DEBIT)) {
                journalInfo.setDebitAmount(voucherEntryInfo.getOriginalAmount());
            }
            if (accountViewInfo.isIsBank()) {
                boolean CS115 = ContextHelperFactory.getLocalInstance((Context)ctx).getBooleanParam("CS115", (IObjectPK)new ObjectUuidPK(srcInfo.getCompany().getId()));
                journalCollection11.addCollection(this.createBankJournalByEntry(ctx, voucherEntryInfo, accountViewInfo, journalInfo));
                if (!FMHelper.isEmpty((AbstractObjectCollection)journalCollection11) || CS115) continue;
                throw new CasException(CasException.BANKACCT_NULL);
            }
            if (!accountViewInfo.isIsCash()) continue;
            journalCollection11.add(journalInfo);
        }
        return journalCollection11;
    }
}

