/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.AsstAccountInfo;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CashMgtInitFacadeFactory;
import com.kingdee.eas.fi.cas.ICashMgtInitFacade;
import com.kingdee.eas.fi.cas.JournalBalanceCollection;
import com.kingdee.eas.fi.cas.JournalBalanceInfo;
import com.kingdee.eas.fi.cas.client.AccountStatementInitHandler;
import com.kingdee.eas.fi.cas.client.BankAccountInitHandler;
import com.kingdee.eas.fi.cas.client.CashAccountInitHandler;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class AbstractCashMgtInitHandler {
    private ICellEditor numberEditor;
    private CurrencyInfo currency;
    private CompanyOrgUnitInfo companyInfo;
    private PeriodInfo periodInfo;
    private AccountTypeEnum accountType;
    private boolean isDisplayImport;
    private JournalBalanceCollection journalBalCollection;
    private boolean isImportChanged;
    public static final int scPrecision = 2;
    public static final int fcPrecision = 2;
    public static final Color KDTABLE_NOEDIT_BG_COLOR = new Color(0xF6F6B6);
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final String resPath = "com.kingdee.eas.fi.cas.CasResource";
    public static final String SAVESUCCESS = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"saveSuccess");
    public final String CASHACCOUNT = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"cashAcct");
    public final String BANKACCOUNT = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"bankAcct");
    public final String BANKACCOUNT_NUM = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"bankAcctNum");
    public final String BANKACCOUNT_ACCTNUM = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"bankAcctAcctNum");
    public final String BANKDEPOSITACCOUNT = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"bankDepositAcct");
    public final String YEARDEBITAMOUNT = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"yearDebitAmount");
    public final String YEARCREDITAMOUNT = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"yearCreditAmount");
    public final String BEGINBALANCE = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"beginBalance");
    public final String ASBALANCE = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"asBalance");
    public final String ADJUSTASBALANCE = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"adjustASBalance");
    public final String JOURNALBALANCE = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"journalBalance");
    public final String ADJUSTJOURNALBALANCE = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"adjustJournalBalance");
    public final String ISBALANCED = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"isBalanced");
    public static final String DEB_COL = "yearDebitAmt";
    public static final String CRE_COL = "yearCreditAmt";
    public static final String BAL_COL = "beginBalance";
    public static final String ADJUSTJOURNALBAL_COL = "adjustJournalBalance";
    public static final String ADJUSTASBAL_COL = "adjustASBalance";
    public static final String ISBAL_COL = "isBalanced";

    public static AbstractCashMgtInitHandler getInstance(AccountTypeEnum accType) {
        if (accType.equals((Object)AccountTypeEnum.CASHACCOUNT)) {
            return new CashAccountInitHandler();
        }
        if (accType.equals((Object)AccountTypeEnum.BANKACCOUNT)) {
            return new BankAccountInitHandler();
        }
        if (accType.equals((Object)AccountTypeEnum.ACCTSTATEMENT)) {
            return new AccountStatementInitHandler();
        }
        return new CashAccountInitHandler();
    }

    public void setColumnColor(IColumn column) {
        column.getStyleAttributes().setLocked(true);
        column.getStyleAttributes().setBackground(KDTABLE_NOEDIT_BG_COLOR);
    }

    public BigDecimal getBigDecimal(BigDecimal big) {
        return big == null ? ZERO : big;
    }

    public BigDecimal getBigDecimal(Object obj) {
        BigDecimal value = null;
        if (obj == null || obj.toString().length() == 0) {
            value = ZERO;
        } else if (obj instanceof BigDecimal) {
            value = (BigDecimal)obj;
        } else if (FMClientHelper.verifyIsNumber((String)obj.toString())) {
            value = new BigDecimal(obj.toString());
        } else {
            throw new IllegalArgumentException("object is not BigDecimal type!");
        }
        return value;
    }

    public BigDecimal getBigDecimalByScale(BigDecimal big, int scale) {
        BigDecimal newBig = this.getBigDecimal(big);
        newBig = newBig.setScale(scale, 4);
        return newBig;
    }

    public static boolean isZERO(BigDecimal o) {
        return o == null || o.compareTo(Constants.ZERO) == 0;
    }

    public static boolean isNull(Object obj) {
        return obj == null;
    }

    public boolean isRowNotValid(IRow row) {
        Object debitObj = row.getCell(DEB_COL).getValue();
        Object creditObj = row.getCell(CRE_COL).getValue();
        Object balanceObj = row.getCell(BAL_COL).getValue();
        boolean isDebitNotValid = AbstractCashMgtInitHandler.isNull(debitObj);
        boolean isCreditNotValid = AbstractCashMgtInitHandler.isNull(creditObj);
        boolean isBalanceNotValid = AbstractCashMgtInitHandler.isNull(balanceObj);
        boolean isRowNotValid = isDebitNotValid && isCreditNotValid && isBalanceNotValid;
        return isRowNotValid;
    }

    public void initTable(KDTable table) {
    }

    public boolean isImportChanged() {
        return this.isImportChanged;
    }

    public void setIsImportChanged(boolean isImportChanged) {
        this.isImportChanged = isImportChanged;
    }

    public AccountTypeEnum getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountTypeEnum accountType) {
        this.accountType = accountType;
    }

    public CurrencyInfo getCurrency() {
        return this.currency;
    }

    public void setCurrency(CurrencyInfo currency) {
        this.currency = currency;
    }

    public CompanyOrgUnitInfo getCompanyInfo() {
        return this.companyInfo;
    }

    public void setCompanyInfo(CompanyOrgUnitInfo companyInfo) {
        this.companyInfo = companyInfo;
    }

    public PeriodInfo getPeriodInfo() {
        return this.periodInfo;
    }

    public void setPeriodInfo(PeriodInfo periodInfo) {
        this.periodInfo = periodInfo;
    }

    public ICellEditor getNumberEditor() {
        return this.numberEditor;
    }

    public void setNumberEditor(ICellEditor numberEditor) {
        this.numberEditor = numberEditor;
    }

    public boolean isDisplayImport() {
        return this.isDisplayImport;
    }

    public void setIsDisplayImport(boolean isDisplayImport) {
        this.isDisplayImport = isDisplayImport;
    }

    public void initTable(KDTable table, boolean isFirstPeriod) {
        String strCurrencyId = this.getCurrency().getId().toString();
        FMClientHelper.setNumberFormat((KDTable)table, (String)DEB_COL, (String)strCurrencyId);
        FMClientHelper.setNumberFormat((KDTable)table, (String)CRE_COL, (String)strCurrencyId);
        FMClientHelper.setNumberFormat((KDTable)table, (String)BAL_COL, (String)strCurrencyId);
        table.getColumn(DEB_COL).setWidth(110);
        table.getColumn(CRE_COL).setWidth(110);
        table.getColumn(BAL_COL).setWidth(110);
        if (table.getColumn(DEB_COL).getEditor() == null) {
            table.getColumn(DEB_COL).setEditor(this.getNumberEditor());
        }
        if (table.getColumn(CRE_COL).getEditor() == null) {
            table.getColumn(CRE_COL).setEditor(this.getNumberEditor());
        }
        if (table.getColumn(BAL_COL).getEditor() == null) {
            table.getColumn(BAL_COL).setEditor(this.getNumberEditor());
        }
        if (isFirstPeriod) {
            table.getColumn(DEB_COL).getStyleAttributes().setHided(true);
            table.getColumn(CRE_COL).getStyleAttributes().setHided(true);
        }
        this.initKDTableFormatter(table);
    }

    public abstract void initKDTableFormatter(KDTable var1);

    public void loadField(KDTable table) throws Exception {
        JournalBalanceCollection coll;
        CompanyOrgUnitInfo companyInfo = this.getCompanyInfo();
        String strCompanyId = companyInfo.getId().toString();
        CurrencyInfo currencyInfo = this.getCurrency();
        String strCurrencyId = currencyInfo.getId().toString();
        PeriodInfo periodInfo = this.getPeriodInfo();
        String strPeriodId = periodInfo.getId().toString();
        ICashMgtInitFacade iCashMgtInitFacade = CashMgtInitFacadeFactory.getRemoteInstance();
        this.journalBalCollection = coll = iCashMgtInitFacade.getInitCollection(this.getAccountType(), strCompanyId, strCurrencyId, strPeriodId);
        this.loadCollectionToTable(coll, table);
    }

    public void loadCollectionToTable(JournalBalanceCollection coll, KDTable table) throws Exception {
        int size = 0;
        this.setIsDisplayImport(false);
        if (coll != null && (size = coll.size()) > 0) {
            this.setIsDisplayImport(true);
        }
        boolean isBankUnReached = true;
        boolean isEnterpriseUnReached = true;
        boolean isExistOppData = true;
        for (int i = 0; i < size; ++i) {
            JournalBalanceInfo cashJournalInitInfo = coll.get(i);
            if (!this.getAccountType().equals((Object)AccountTypeEnum.CASHACCOUNT)) {
                isExistOppData = (Boolean)cashJournalInitInfo.get("isExistOppData");
            }
            if (cashJournalInitInfo.getId() == null && AbstractCashMgtInitHandler.isZERO(cashJournalInitInfo.getDebitStartAmt()) && AbstractCashMgtInitHandler.isZERO(cashJournalInitInfo.getCreditStartAmt()) && AbstractCashMgtInitHandler.isZERO(cashJournalInitInfo.getMonthStartAmt())) {
                cashJournalInitInfo.setDebitStartAmt(CasConstants.ZERO);
                cashJournalInitInfo.setCreditStartAmt(CasConstants.ZERO);
                cashJournalInitInfo.setMonthStartAmt(CasConstants.ZERO);
                if (this.getAccountType().equals((Object)AccountTypeEnum.BANKACCOUNT)) {
                    if (isExistOppData) {
                        isBankUnReached = false;
                    } else {
                        isBankUnReached = false;
                        isEnterpriseUnReached = false;
                    }
                }
                if (this.getAccountType().equals((Object)AccountTypeEnum.ACCTSTATEMENT)) {
                    if (isExistOppData) {
                        isEnterpriseUnReached = false;
                    } else {
                        isBankUnReached = false;
                        isEnterpriseUnReached = false;
                    }
                }
                if (this.getAccountType().equals((Object)AccountTypeEnum.BANKACCOUNT) && !isExistOppData && AbstractCashMgtInitHandler.isZERO(cashJournalInitInfo.getAcctStatementMonthStartAmt()) && AbstractCashMgtInitHandler.isZERO(cashJournalInitInfo.getAdjustedASMonthStartAmt()) && AbstractCashMgtInitHandler.isZERO(cashJournalInitInfo.getAdjustedJournalMonthStartAmt()) || this.getAccountType().equals((Object)AccountTypeEnum.ACCTSTATEMENT) && !isExistOppData && AbstractCashMgtInitHandler.isZERO(cashJournalInitInfo.getJournalMonthStartAmt()) && AbstractCashMgtInitHandler.isZERO(cashJournalInitInfo.getAdjustedASMonthStartAmt()) && AbstractCashMgtInitHandler.isZERO(cashJournalInitInfo.getAdjustedJournalMonthStartAmt())) {
                    cashJournalInitInfo.setAcctStatementMonthStartAmt(CasConstants.ZERO);
                    cashJournalInitInfo.setJournalMonthStartAmt(CasConstants.ZERO);
                    cashJournalInitInfo.setAdjustedASMonthStartAmt(CasConstants.ZERO);
                    cashJournalInitInfo.setAdjustedJournalMonthStartAmt(CasConstants.ZERO);
                }
            } else {
                if (this.getAccountType().equals((Object)AccountTypeEnum.BANKACCOUNT) && !isExistOppData) {
                    isEnterpriseUnReached = false;
                }
                if (this.getAccountType().equals((Object)AccountTypeEnum.ACCTSTATEMENT) && !isExistOppData) {
                    isBankUnReached = false;
                }
            }
            cashJournalInitInfo.put("isBankUnReached", new Boolean(isBankUnReached));
            cashJournalInitInfo.put("isEnterpriseUnReached", new Boolean(isEnterpriseUnReached));
            isBankUnReached = true;
            isEnterpriseUnReached = true;
            IRow row = table.addRow();
            row.setUserObject((Object)cashJournalInitInfo);
            this.loadLineFields(row, cashJournalInitInfo);
        }
    }

    protected abstract void loadLineFields(IRow var1, JournalBalanceInfo var2);

    public void storeField(KDTable table) throws Exception {
    }

    public void storeData(JournalBalanceCollection journalBalCol, JournalBalanceInfo paramInfo) throws Exception {
        if (paramInfo == null) {
            return;
        }
        ICashMgtInitFacade iCashMgtInitFacade = CashMgtInitFacadeFactory.getRemoteInstance();
        iCashMgtInitFacade.save(journalBalCol, paramInfo);
    }

    public void importFromGLToInit(KDTable table, String strPeriodId) throws Exception {
        table.removeRows();
        CompanyOrgUnitInfo companyInfo = this.getCompanyInfo();
        String strCompanyId = companyInfo.getId().toString();
        CurrencyInfo currencyInfo = this.getCurrency();
        String strCurrencyId = currencyInfo.getId().toString();
        ICashMgtInitFacade iCashMgtInitFacade = CashMgtInitFacadeFactory.getRemoteInstance();
        JournalBalanceCollection coll = (JournalBalanceCollection)iCashMgtInitFacade.getInitCollectionFromGL(this.getAccountType(), strCompanyId, strCurrencyId, strPeriodId);
        if (coll == null && this.journalBalCollection == null) {
            this.isImportChanged = false;
        } else if (coll == null && this.journalBalCollection != null && this.journalBalCollection.size() != 0 || coll != null && this.journalBalCollection == null && coll.size() != 0) {
            this.isImportChanged = true;
        } else if (coll != null && this.journalBalCollection != null && coll.size() != this.journalBalCollection.size()) {
            this.isImportChanged = false;
        } else {
            String key;
            JournalBalanceInfo journalBalInfo;
            HashMap<String, JournalBalanceInfo> indexMap = new HashMap<String, JournalBalanceInfo>();
            for (int i = 0; i < this.journalBalCollection.size(); ++i) {
                journalBalInfo = this.journalBalCollection.get(i);
                key = null;
                key = this.getAccountType().equals((Object)AccountTypeEnum.CASHACCOUNT) ? journalBalInfo.getAccountView().getId().toString() : journalBalInfo.getAccountBank().getId().toString();
                indexMap.put(key, journalBalInfo);
            }
            for (int j = 0; j < coll.size(); ++j) {
                journalBalInfo = coll.get(j);
                key = null;
                key = this.getAccountType().equals((Object)AccountTypeEnum.CASHACCOUNT) ? journalBalInfo.getAccountView().getId().toString() : journalBalInfo.getAccountBank().getId().toString();
                if (indexMap.containsKey(key)) {
                    this.isImportChanged = this.compareTwoInfoValue(journalBalInfo, (JournalBalanceInfo)indexMap.get(key));
                }
                if (this.isImportChanged) break;
            }
        }
        this.loadCollectionToTable(coll, table);
        if (this.getAccountType().equals((Object)AccountTypeEnum.BANKACCOUNT)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyInfo.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("account.isBank", (Object)Constants.TRUE));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)strCurrencyId));
            view.getSorter().add(new SorterItemInfo("bankAccountNumber"));
            ArrayList<AccountBankInfo> acctBankList = new ArrayList<AccountBankInfo>();
            StringBuffer desNumber = new StringBuffer();
            AccountBankCollection accountBanks = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
            for (int i = 0; i < accountBanks.size(); ++i) {
                AccountBankInfo accountBank = accountBanks.get(i);
                if (this.hasAssistant(accountBank)) continue;
                acctBankList.add(accountBank);
                if (i != 0) {
                    desNumber.append(",");
                }
                desNumber.append(accountBank.getBankAccountNumber());
            }
            if (acctBankList.size() != 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)resPath, (String)"AccountBankImportZero") + desNumber));
            }
        }
    }

    public boolean hasAssistant(AccountBankInfo accountBank) throws EASBizException, BOSException {
        AccountViewInfo acctViewInfo = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountBank.getAccount().getId()));
        if (acctViewInfo.getGAA() != null || acctViewInfo.getCAA() != null) {
            AsstAccountInfo asstAcctInfo = new AsstAccountInfo();
            if (acctViewInfo.getGAA() != null) {
                asstAcctInfo = acctViewInfo.getGAA();
            }
            if (acctViewInfo.getCAA() != null) {
                asstAcctInfo = acctViewInfo.getCAA();
            }
            IAssistantHG assistantHG = AssistantHGFactory.getRemoteInstance();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)accountBank.getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("asstAccount.id", (Object)asstAcctInfo.getId().toString()));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            evi.getSelector().addObjectCollection((IObjectCollection)selector);
            evi.setFilter(fi);
            AssistantHGCollection assistantHGColl = assistantHG.getAssistantHGCollection(evi);
            return assistantHGColl != null && assistantHGColl.size() != 0;
        }
        return !FMHelper.isExistMultiBankAcct((String)accountBank.getCompany().getId().toString(), (String)accountBank.getAccount().getId().toString());
    }

    private boolean compareTwoInfoValue(JournalBalanceInfo firstInfo, JournalBalanceInfo secondInfo) {
        return firstInfo.getMonthBalance() != secondInfo.getMonthBalance() || firstInfo.getDebitStartAmt() != secondInfo.getDebitStartAmt() || firstInfo.getCreditStartAmt() != secondInfo.getCreditStartAmt();
    }

    public void loadImportCollectionToTable(JournalBalanceCollection coll, KDTable table) throws Exception {
        int size = 0;
        if (coll != null) {
            size = coll.size();
        }
        for (int i = 0; i < size; ++i) {
            JournalBalanceInfo cashJournalInitInfo = coll.get(i);
            if (AbstractCashMgtInitHandler.isZERO(cashJournalInitInfo.getDebitStartAmt()) && AbstractCashMgtInitHandler.isZERO(cashJournalInitInfo.getCreditStartAmt()) && AbstractCashMgtInitHandler.isZERO(cashJournalInitInfo.getMonthStartAmt())) {
                cashJournalInitInfo.setDebitStartAmt(null);
                cashJournalInitInfo.setCreditStartAmt(null);
                cashJournalInitInfo.setMonthStartAmt(null);
            }
            IRow row = table.addRow();
            row.setUserObject((Object)cashJournalInitInfo);
            this.loadLineFields(row, cashJournalInitInfo);
        }
    }
}

