/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.CellTextRender;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.SettlementTypeCollection;
import com.kingdee.eas.basedata.assistant.SettlementTypeFactory;
import com.kingdee.eas.basedata.assistant.VoucherTypeCollection;
import com.kingdee.eas.basedata.assistant.VoucherTypeFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.client.BankUnreachedInitJournalHandler;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.EnterpriseUnreachedInitBankStmtHandler;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public abstract class AbstractCashMgtInitJournalHandler {
    protected KDTable table;
    protected Date beginDate;
    protected AccountBankInfo accountBank;
    protected CurrencyInfo currency;
    protected AccountViewInfo accountView;
    private final String DATE_FORMAT_STR = "%r{yyyy-M-d}t";
    public static final String COL_CREATEDATE = "createDate";
    public static final String COL_ASSISDATE = "assisDate";
    public static final String COL_DESCRIPTION = "description";
    public static final String COL_VOUCHERTYPE = "voucherType";
    public static final String COL_VOUCHERNUMBER = "voucherNumber";
    public static final String COL_BILLTYPE = "billType";
    public static final String COL_BILLNUMBER = "billNumber";
    public static final String COL_SETTLEMENTTYPE = "settlementType";
    public static final String COL_SETTLEMENTNUMBER = "settlementNumber";
    public static final String COL_DEBITAMT = "debitAmt";
    public static final String COL_CREDITAMT = "creditAmt";
    protected CellTextRender numRender;

    public static AbstractCashMgtInitJournalHandler getInstance(boolean isBankUnreached) {
        if (isBankUnreached) {
            return new BankUnreachedInitJournalHandler();
        }
        return new EnterpriseUnreachedInitBankStmtHandler();
    }

    public void initTable(String currencyId) throws Exception {
        this.table.checkParsed();
        KDDatePicker datePicker = new KDDatePicker();
        KDTDefaultCellEditor dateEditor = new KDTDefaultCellEditor(datePicker);
        this.table.getColumn(COL_CREATEDATE).setEditor((ICellEditor)dateEditor);
        this.table.getColumn(COL_ASSISDATE).setEditor((ICellEditor)dateEditor);
        this.table.getColumn(COL_CREATEDATE).getStyleAttributes().setNumberFormat("%r{yyyy-M-d}t");
        this.table.getColumn(COL_ASSISDATE).getStyleAttributes().setNumberFormat("%r{yyyy-M-d}t");
        KDComboBox voucherTypeCombox = new KDComboBox();
        EntityViewInfo viewInfo = new EntityViewInfo();
        BOSUuid pk = SysContext.getSysContext().getCurrentCtrlUnit().getId();
        FilterInfo filter = VoucherTypeFactory.getRemoteInstance().getDatabaseDFilter((IObjectPK)new ObjectUuidPK(pk.toString()), "id", "adminCU.id");
        viewInfo.setFilter(filter);
        VoucherTypeCollection colVoucherType = VoucherTypeFactory.getRemoteInstance().getVoucherTypeCollection(viewInfo);
        voucherTypeCombox.addItems(colVoucherType.toArray());
        KDTDefaultCellEditor voucherTypeEditor = new KDTDefaultCellEditor((JComboBox)voucherTypeCombox);
        this.table.getColumn(COL_VOUCHERTYPE).setEditor((ICellEditor)voucherTypeEditor);
        KDComboBox billTypeCombox = new KDComboBox();
        billTypeCombox.addItem((Object)BillTypeEnum.paymentBill);
        billTypeCombox.addItem((Object)BillTypeEnum.receiveBill);
        billTypeCombox.addItem((Object)BillTypeEnum.settlementBill);
        KDTDefaultCellEditor billTypeEditor = new KDTDefaultCellEditor((JComboBox)billTypeCombox);
        this.table.getColumn(COL_BILLTYPE).setEditor((ICellEditor)billTypeEditor);
        KDComboBox settTypeCombox = new KDComboBox();
        SettlementTypeCollection settlementTypes = SettlementTypeFactory.getRemoteInstance().getSettlementTypeCollection();
        settTypeCombox.addItems(settlementTypes.toArray());
        KDTDefaultCellEditor settTypeEditor = new KDTDefaultCellEditor((JComboBox)settTypeCombox);
        this.table.getColumn(COL_SETTLEMENTTYPE).setEditor((ICellEditor)settTypeEditor);
        BOSUuid currencyUuid = BOSUuid.read((String)currencyId);
        FMClientHelper.currencyFormat((BOSUuid)currencyUuid, (IColumn)this.table.getColumn(COL_DEBITAMT));
        FMClientHelper.currencyFormat((BOSUuid)currencyUuid, (IColumn)this.table.getColumn(COL_CREDITAMT));
        CashClientHelper.setNumberFormat(this.table, COL_DEBITAMT, currencyId);
        CashClientHelper.setNumberFormat(this.table, COL_CREDITAMT, currencyId);
        KDTextField txtField = new KDTextField();
        txtField.setMaxLength(80);
        KDTDefaultCellEditor txtCellEditor = new KDTDefaultCellEditor((JTextField)txtField);
        this.table.getColumn(COL_DESCRIPTION).setEditor((ICellEditor)txtCellEditor);
        this.table.getColumn(COL_VOUCHERNUMBER).setEditor((ICellEditor)txtCellEditor);
        this.table.getColumn(COL_BILLNUMBER).setEditor((ICellEditor)txtCellEditor);
        this.table.getColumn(COL_SETTLEMENTNUMBER).setEditor((ICellEditor)txtCellEditor);
    }

    public void storeFields() throws Exception {
    }

    public void loadFields() throws Exception {
    }

    public void setTable(KDTable table) {
        this.table = table;
    }

    protected FilterInfo getFilterInfo() {
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        FilterItemInfo createDateCond = new FilterItemInfo(COL_CREATEDATE, (Object)this.beginDate, CompareType.LESS);
        FilterItemInfo accountViewCond = new FilterItemInfo("accountView.id", (Object)this.accountView.getId().toString());
        FilterItemInfo currencyCond = new FilterItemInfo("currency.id", (Object)this.currency.getId().toString());
        FilterItemInfo accountBankCond = new FilterItemInfo("accountBank.id", (Object)this.accountBank.getId().toString());
        FilterItemInfo companyCond = new FilterItemInfo("company.id", (Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId().toString());
        fic.add(createDateCond);
        fic.add(accountViewCond);
        fic.add(currencyCond);
        fic.add(accountBankCond);
        fic.add(companyCond);
        return fi;
    }

    public void setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
    }

    public void setAccountBank(AccountBankInfo accountBank) {
        this.accountBank = accountBank;
    }

    public void setAccountView(AccountViewInfo accountView) {
        this.accountView = accountView;
    }

    public void setCurrency(CurrencyInfo currency) {
        this.currency = currency;
    }

    protected SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(COL_CREATEDATE);
        selectors.add(COL_DESCRIPTION);
        selectors.add("settleType.id");
        selectors.add("settleType.name");
        selectors.add("settleNumber");
        selectors.add("debitAmount");
        selectors.add("creditAmount");
        selectors.add("creditAmount");
        selectors.add("verifyStatus");
        return selectors;
    }
}

