/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.AbstractAgentPayBillFilterUI;
import com.kingdee.eas.fi.cas.client.AgentPayBillFilterParam;
import com.kingdee.eas.fi.cas.client.ISharedOrgSupport;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.framework.FrameWorkUtils;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Date;
import org.apache.log4j.Logger;

public class AgentPayBillFilterUI
extends AbstractAgentPayBillFilterUI
implements ISharedOrgSupport {
    private static final long serialVersionUID = 5146650115733219614L;
    private static final Logger logger = CoreUIObject.getLogger(AgentPayBillFilterUI.class);
    private Context mainOrgContext = new Context();
    private boolean isSharedOrg = false;
    CompanyOrgUnitCollection orgRang;

    public AgentPayBillFilterUI() throws Exception {
        UserInfo user = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        this.mainOrgContext.put((Object)"UserInfo", (Object)user);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.orgRang = FMHelper.getUserOrgRangesWithRange(null, (String)this.getPermissionItem());
    }

    protected void init() throws Exception {
        super.init();
        this.btnCompanySelect.setVisible(false);
        CashHelper.initCombCurrency(this.comboCurrency, false);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        this.initBillStatus(this.comboBillStatus);
        this.pkDateFrom.setValue((Object)DateHelper.getDayBegin());
        this.pkDateTo.setValue((Object)DateHelper.getDayBegin());
        this.pkDateFrom.setSupportedEmpty(false);
        this.pkDateTo.setSupportedEmpty(false);
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            if (this.orgRang == null) {
                this.prmtCompany.setValue((Object)this.currentCompany);
            } else {
                for (int i = 0; i < this.orgRang.size(); ++i) {
                    CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.orgRang.getObject(i);
                    if (!company.isIsBizUnit() || company.isIsOUSealUp()) continue;
                    this.prmtCompany.setValue((Object)company);
                    break;
                }
            }
        } else {
            this.prmtCompany.setValue((Object)this.currentCompany);
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getData();
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)company.getBaseCurrency());
        FMClientHelper.setSelectObject((KDComboBox)this.comboBillStatus, (Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    private void initBillStatus(KDComboBox combo) {
        combo.removeAllItems();
        combo.addItem((Object)BillStatusEnum.SAVE);
        combo.addItem((Object)BillStatusEnum.SUBMIT);
        combo.addItem((Object)BillStatusEnum.AUDITED);
        combo.addItem((Object)BillStatusEnum.PAYED);
        combo.addItem((Object)FMSysDefinedEnum.ALL_ITEMS);
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public Object getParam() {
        AgentPayBillFilterParam paramInfo = new AgentPayBillFilterParam();
        if (this.comboCurrency.getSelectedItem() == FMSysDefinedEnum.ALL_ITEMS) {
            paramInfo.setCurrencyInfo(null);
        } else {
            paramInfo.setCurrencyInfo((CurrencyInfo)this.comboCurrency.getSelectedItem());
        }
        if (this.comboBillStatus.getSelectedItem().equals(FMSysDefinedEnum.ALL_ITEMS)) {
            paramInfo.setBillStatus(999);
        } else {
            paramInfo.setBillStatus(((BillStatusEnum)((Object)this.comboBillStatus.getSelectedItem())).getValue());
        }
        paramInfo.setStartDate((java.util.Date)this.pkDateFrom.getValue());
        paramInfo.setEndDate((java.util.Date)this.pkDateTo.getValue());
        paramInfo.setCompany((CompanyOrgUnitInfo)this.prmtCompany.getData());
        return paramInfo;
    }

    public void setParam(Object param) {
        AgentPayBillFilterParam paramInfo = (AgentPayBillFilterParam)param;
        if (paramInfo.getCurrencyInfo() == null) {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)paramInfo.getCurrencyInfo());
        }
        if (paramInfo.getBillStatus() == 999) {
            this.comboBillStatus.setSelectedItem((Object)FMSysDefinedEnum.ALL_ITEMS);
        } else {
            this.comboBillStatus.setSelectedItem((Object)BillStatusEnum.getEnum(paramInfo.getBillStatus()));
        }
        this.pkDateTo.setValue((Object)paramInfo.getEndDate());
        this.pkDateFrom.setValue((Object)paramInfo.getStartDate());
        this.prmtCompany.setValue((Object)paramInfo.getCompany());
    }

    public boolean verify() {
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (java.util.Date)((java.util.Date)this.pkDateFrom.getValue()), (java.util.Date)((java.util.Date)this.pkDateTo.getValue()));
        Date startDate = this.pkDateFrom.getSqlDate();
        Date endDate = this.pkDateTo.getSqlDate();
        FMClientVerifyHelper.verifyBeginEndDateRel((CoreUIObject)this, (java.util.Date)startDate, (java.util.Date)endDate);
        if (FMHelper.isEmpty((Object)this.prmtCompany.getData())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"231_AgentPayBillFilterUI"));
            SysUtil.abort();
        }
        return super.verify();
    }

    protected Class getParamClass() {
        return AgentPayBillFilterParam.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        super.afterMainOrgChanged(chgVo);
        CompanyOrgUnitInfo company = null;
        if (chgVo.getNewOrg() instanceof Object[]) {
            Object[] companys = (Object[])chgVo.getNewOrg();
            if (companys.length == 0) return;
            company = (CompanyOrgUnitInfo)companys[0];
        } else {
            company = (CompanyOrgUnitInfo)chgVo.getNewOrg();
        }
        try {
            FrameWorkUtils.switchOrg((Context)this.mainOrgContext, (String)company.getId().toString());
            return;
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            logger.error((Object)e);
        }
    }

    public String getPermissionItem() {
        return "agentPaybill_view";
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public boolean isSupportMultiOrgs() {
        return this.isSharedOrg();
    }

    @Override
    public void setIsSharedOrg(boolean value) {
        this.isSharedOrg = value;
    }

    @Override
    public boolean isSharedOrg() {
        return this.isSharedOrg;
    }
}

