/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.google.common.collect.Sets;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDComponent;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDMenu;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.ormapping.Utils;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.framework.cache.ActionCache;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.uiframe.client.VersionUtil;
import com.kingdee.eas.base.wssc.BillImageFacadeFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PaymentTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.IArApBillFacade;
import com.kingdee.eas.fi.cas.ArApRecPayException;
import com.kingdee.eas.fi.cas.BillStatusEnum;
import com.kingdee.eas.fi.cas.CasForArApException;
import com.kingdee.eas.fi.cas.CasForArApUtil;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.RecPayBillFacadeFactory;
import com.kingdee.eas.fi.cas.RecPayBillInfo;
import com.kingdee.eas.fi.cas.SourceTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractArApRecPayBillBaseEditUI;
import com.kingdee.eas.fi.cas.client.ArApRecPayHelper;
import com.kingdee.eas.fi.cas.client.ArApRecPayLogic;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fi.cas.client.util.BillUIUtil;
import com.kingdee.eas.fi.cas.utils.AsstActHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;

public class ArApRecPayBillBaseEditUI
extends AbstractArApRecPayBillBaseEditUI {
    private static final Logger logger = CoreUIObject.getLogger(ArApRecPayBillBaseEditUI.class);
    protected ArApRecPayHelper arapHelper = new ArApRecPayHelper();
    protected ArApRecPayLogic arapLogic = new ArApRecPayLogic();
    protected static final int defaultLength = 80;
    protected CompanyOrgUnitInfo companyInfo;
    protected UserInfo userInfo = null;
    protected SourceTypeEnum sourceType = null;
    protected boolean isFirstLoad = true;
    protected boolean isIndirectExRate = false;
    protected boolean isAssocatedAdd = false;
    protected DataChangeListener personListener;
    protected DataChangeListener adminOrgUnitListener;
    protected DataChangeListener prmtSettlementTypeListener;
    protected DataChangeListener prmtCompanyListener;
    protected DataChangeListener prmtCurrencyListener;
    protected boolean isSubmitedAddNew;
    protected AsstActTypeInfo oldSelectedItem;
    protected IKDComponent[] uiComponents = null;
    protected boolean isInitBill = false;
    protected PeriodInfo startPeriod = null;
    protected boolean isTransPreRecPrePay = true;
    protected CompanyOrgUnitInfo currentCompany;
    protected CurrencyInfo baseCurrency;
    protected UserInfo userinfo;
    protected ArApSysParamInfo cache = null;
    protected IArApBillFacade iBillFacade;
    protected static final String Arap_RecPayResource = "com.kingdee.eas.fi.ar.ARRecPayResource";
    protected String CashSaleflag = "cd54aa9f-03a4-459c-9c5a-5489dce5f0676BCA0AB5";
    protected String CashPurflag = "40b75328-7f57-463f-8d19-280574ef24bf6BCA0AB5";
    protected boolean DAPCheckAccount = false;
    protected Map<String, BigDecimal> srcBillUnlockAmtMap = new HashMap<String, BigDecimal>();
    public List paramList = new ArrayList();
    private Map<String, PaymentTypeInfo> paymentTypeCache = new HashMap<String, PaymentTypeInfo>();
    protected Map<String, BigDecimal> maxAmtMap = new HashMap<String, BigDecimal>();

    public ArApRecPayBillBaseEditUI() throws Exception {
        this.currentCompany = SysContext.getSysContext().getCurrentFIUnit();
        this.userinfo = SysContext.getSysContext().getCurrentUserInfo();
        this.iBillFacade = ArApBillFacadeFactory.getRemoteInstance();
    }

    protected HashMap getUIParam() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        IObjectValue billInfo = null;
        try {
            billInfo = Utils.newObjectValueInstance((EntityObjectInfo)this.getBOSEntity());
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        map.put("billInfo", billInfo);
        map.put("sysEnum", this.getSysEnum());
        map.put("isSCM", new Boolean(false));
        map.put("isInit", this.isInitBill);
        map.put("permissionItem", this.getPermissionItem(this.getOprtState()));
        map.put("isFromWorkflow", this.getUIContext().get("isFromWorkflow"));
        map.put("billId", this.getUIContext().get("ID"));
        return map;
    }

    private boolean idEquals(CoreBaseInfo obj1, CoreBaseInfo obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.getId().equals((Object)obj2.getId());
    }

    protected void updateInfoByCompany(RecPayBillInfo info) throws Exception {
        if (info.getCompany() == null && this.cache.getCompany() == null) {
            this.cache = this.iBillFacade.getSysParams(null, this.getUIParam());
        } else if (info.getCompany() == null) {
            info.setCompany(this.cache.getCompany());
        }
        if (this.cache.getCompany() == null || !this.idEquals((CoreBaseInfo)this.cache.getCompany(), (CoreBaseInfo)info.getCompany())) {
            this.cache = this.iBillFacade.getSysParams(info.getCompany(), this.getUIParam());
        }
        this.initCompany();
        if (info.getCurrency() == null) {
            info.setCurrency(this.cache.getBaseCurrency());
        }
        this.baseCurrency = this.cache.getBaseCurrency();
        this.DAPCheckAccount = this.cache.isDAPCheckAccount();
    }

    public EntityObjectInfo getBOSEntity() throws Exception {
        return MetaDataLoaderFactory.getRemoteMetaDataLoader().getEntity(this.getBizType());
    }

    public void afterActionPerformed() throws Exception {
        this.setOprtState("VIEW");
        if (this.editData.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(this.editData.getId());
            this.setDataObject(this.getValue((IObjectPK)pk));
            this.loadFields();
        }
    }

    protected void initCompany() throws EASBizException, BOSException {
        if (this.cache.getCompany() == null) {
            this.cache = this.iBillFacade.getSysParams(null, this.getUIParam());
        }
    }

    protected void setBillAsstType() {
    }

    protected void setCompanyF7() {
        long begin = System.currentTimeMillis();
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, this.getPermissionItem(this.getOprtState()));
        this.getMainBizOrg().setRequired(true);
        this.getMainBizOrg().setEditFormat("$number$");
        this.getMainBizOrg().setFilterInfoProducer((IFilterInfoProducer)iProducer);
        logger.info((Object)("setCompanyF7 : " + (System.currentTimeMillis() - begin) + "ms"));
    }

    protected String getPermissionItem(String status) {
        return null;
    }

    protected void initPeriod() throws EASBizException, BOSException {
        if (this.getOprtState() == null || this.companyInfo == null) {
            return;
        }
        if (!("AUDIT".equals(this.getOprtState()) || "REC".equals(this.getOprtState()) || "PAY".equals(this.getOprtState()) || "FINDVIEW".equals(this.getOprtState()))) {
            this.arapLogic.checkStartPeriod((Component)((Object)this), this.companyInfo, this.sourceType);
        }
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.initPeriod();
        this.unLockUI();
        this.setOprtState(OprtState.VIEW);
        this.lockUIForViewStatus();
        super.doFieldPermission();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.initPeriod();
        this.unLockUI();
        this.setOprtState(OprtState.VIEW);
        this.lockUIForViewStatus();
        super.doFieldPermission();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.initPeriod();
        this.unLockUI();
        this.setOprtState(OprtState.VIEW);
        this.lockUIForViewStatus();
        super.doFieldPermission();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.initPeriod();
        this.unLockUI();
        this.setOprtState(OprtState.VIEW);
        this.lockUIForViewStatus();
        super.doFieldPermission();
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getDetailTable() {
        return null;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getDetailTable() != null) {
            this.getDetailTable().getActionMap().remove("AddRow");
            this.getDetailTable().getActionMap().remove("RemoveRow");
            this.getDetailTable().getActionMap().remove("Delete");
        }
        this.getMainStatusBar().setPerTitle(FMClientHelper.getPeriodString((PeriodInfo)this.cache.getCurrentPeriod(this.getSysEnum())));
        FMClientHelper.addSqlMenu((CoreUIObject)this, (KDMenu)this.menuEdit);
        FMClientHelper.clearSeparatorOnToolBar((KDToolBar)this.toolBar);
        if (this.isSetPrecisionAuto()) {
            this.setPrecision();
        }
        if (this.isNeedAddToolMenus()) {
            FMClientHelper.addToolsMenu((CoreUIObject)this);
        }
        this.chkMenuItemSubmitAndAddNew.setVisible(true);
    }

    protected boolean isNeedAddToolMenus() {
        return true;
    }

    protected boolean isSetPrecisionAuto() {
        return false;
    }

    protected int getBaseCurrencyPrecision() {
        return this.baseCurrency.getPrecision();
    }

    protected void setPrecision() throws BOSException, EASBizException {
        FMClientHelper.setCompontDisplayFormat((CoreUIObject)this, (CurrencyInfo)this.getSelectCurrency());
        this.resetPrecisionForLocalAmt();
        this.resetPrecisionForOtherComponent();
    }

    protected void resetPrecisionForLocalAmt() {
    }

    protected CurrencyInfo getSelectCurrency() {
        if (this.baseCurrency == null) {
            this.baseCurrency = SysContext.getSysContext().getCurrentFIUnit().getBaseCurrency();
        }
        return this.baseCurrency;
    }

    protected void resetPrecisionForOtherComponent() {
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.menuItemSave.setVisible(false);
        this.menuItemViewPreImage.setEnabled(true);
        this.btnViewImage.addAssistMenuItem((JMenuItem)this.menuItemViewPreImage);
        this.getMainBizOrg().setCommitFormat("$number$;$name$;$code$");
    }

    protected SystemEnum getSystemEnumForOA() {
        return FMClientHelper.getSystemEnum((CoreUI)this);
    }

    @Override
    public void setOprtState(String oprtType) {
        super.setOprtState(oprtType);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if ("EDIT".equals(this.getOprtState())) {
            BOSUuid id = this.editData.getId();
            if (id == null) {
                throw new EASBizException(EASBizException.CHECKBLANK, new Object[]{EASResource.getString((String)Arap_RecPayResource, (String)"Edit_Save") + ",id"});
            }
            ObjectUuidPK pk = new ObjectUuidPK(id);
            if (!this.getBizInterface().exists((IObjectPK)pk)) {
                throw new EASBizException(EASBizException.CHECKEXIST);
            }
        }
    }

    protected void doAfterSave(IObjectPK pk) throws Exception {
        if (pk == null) {
            return;
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            int size = this.idList.size();
            this.idList.add(size, pk.toString());
        }
        this.setOprtState(OprtState.EDIT);
        ActionCache.clear();
        this.setDataObject(this.getValue(pk));
        this.showMessageForStatus();
        this.showSaveSuccess();
        if (this.wfContext.isBindWorkFlow()) {
            this.wfContext.addToDataMap((Object)pk.toString(), (IObjectValue)this.editData);
        }
        this.setSave(true);
        this.setSaved(true);
        this.actionCopy.setEnabled(true);
        this.initOldData((IObjectValue)this.editData);
        if (super.isSave()) {
            this.createFeed();
        }
    }

    protected void afterSubmitEdit(IObjectPK pk) {
        this.setOprtState(OprtState.EDIT);
        try {
            if (this.isSubmitLoad()) {
                if ((IObjectValue)this.getUIContext().get("InitDataObject") != null) {
                    this.setDataObject((IObjectValue)this.getUIContext().get("InitDataObject"));
                } else {
                    this.setDataObject(this.getValue(pk));
                }
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    protected void doBeforeSubmit(ActionEvent e) throws Exception {
        super.doBeforeSubmit(e);
        if (this.editData.getId() == null) {
            IObjectValue info = (IObjectValue)this.editData.clone();
            this.getUIContext().put("CURRENT.VO", info);
        }
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        RecPayBillInfo editData;
        RecPayBillInfo info = (RecPayBillInfo)dataObject;
        if (info != null) {
            info.setOldNumber(info.getNumber());
            try {
                this.updateInfoByCompany(info);
            }
            catch (Exception e) {
                logger.error((Object)e);
                this.handUIExceptionAndAbort(e);
            }
        }
        if (OprtState.EDIT.equals(this.getOprtState()) && info != null) {
            try {
                if (info.isIsImport() && !this.cache.isImportBillModifiable()) {
                    throw new CasForArApException(CasForArApException.IMPORTBILL);
                }
            }
            catch (Exception e) {
                this.handUIExceptionAndAbort(e);
            }
        }
        super.setDataObject((IObjectValue)info);
        if (dataObject != null && (editData = (RecPayBillInfo)dataObject).getId() != null) {
            try {
                int count = CasForArApUtil.updateAccessoryAmt(null, editData.getId().toString());
                editData.setSyncOldValue(true);
                editData.setAccessoryAmt(count);
            }
            catch (Exception e) {
                super.handleException(e);
            }
        }
    }

    protected SystemEnum getSysEnum() {
        return null;
    }

    protected void multiBillView() {
        if (this.editData instanceof PaymentBillInfo && ((PaymentBillInfo)this.editData).getBillStatus() == null) {
            ((PaymentBillInfo)this.editData).setBillStatus(BillStatusEnum.SAVE);
        }
        if (this.editData instanceof RecPayBillInfo && ((RecPayBillInfo)this.editData).getBillStatus() == null) {
            ((RecPayBillInfo)this.editData).setBillStatus(BillStatusEnum.SAVE);
        }
        if (this.editData instanceof PaymentBillInfo && ((PaymentBillInfo)this.editData).getBillStatus().getValue() == 12) {
            return;
        }
        if (this.editData instanceof RecPayBillInfo && ((RecPayBillInfo)this.editData).getBillStatus().getValue() >= 12) {
            FMClientHelper.setCompEnable((IKDComponent[])this.uiComponents, (boolean)false);
            if (this.getDetailTable() != null) {
                this.getDetailTable().setEditable(false);
            }
            this.actionEdit.setEnabled(false);
            this.actionSave.setEnabled(false);
            this.actionSubmit.setEnabled(false);
            this.actionAddLine.setEnabled(false);
            this.actionCopyLine.setEnabled(false);
        }
    }

    protected void removeByPK(IObjectPK pk) throws Exception {
        super.removeByPK((IObjectPK)new ObjectUuidPK(this.editData.getId()));
        if (this.getAsstActComp() != null) {
            this.getAsstActComp().setValue(null);
        }
    }

    protected KDBizPromptBox getAsstActComp() {
        return null;
    }

    protected void showMessage(String resource, String messageItem) {
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resource, (String)messageItem));
        SysUtil.abort();
    }

    public void actionVoucher_actionPerformed(ActionEvent e) throws Exception {
        super.actionVoucher_actionPerformed(e);
    }

    protected void showSuccessMsg(String msg) {
        this.setShowMessagePolicy(2);
        this.setMessageText(msg);
        this.setIsShowTextOnly(false);
        this.setMessageBgcolor(SHOW_MESSAGE_BG_OK);
        this.setMessageIcon(SHOW_MESSAGE_ICON_OK);
        this.showMessage();
    }

    @Override
    public void actionViewImage_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() != null) {
            try {
                String navUrl = BillImageFacadeFactory.getRemoteInstance().getImageURL(this.editData.getBOSType().toString(), this.editData.getId().toString());
                if (navUrl == null) {
                    throw new ArApRecPayException(ArApRecPayException.IMAGENOTREADY);
                }
                VersionUtil.gotoSite((String)navUrl, (boolean)true);
            }
            catch (Exception ex) {
                throw new ArApRecPayException(ArApRecPayException.IMAGENOTREADY);
            }
        }
    }

    @Override
    public void actionViewPreImage_actionPerformed(ActionEvent e) throws Exception {
        if (this.editData.getId() == null) {
            return;
        }
        String srcImgUrl = BillUIUtil.getSourceBillImageUrl(this.getMainOrgContext(), Sets.newHashSet((Object[])new String[]{this.editData.getId().toString()}), this.getMainOrgContext().getUserName());
        VersionUtil.gotoSite((String)srcImgUrl, (boolean)true);
    }

    protected void preProcessOpAcctF7(final KDBizPromptBox promptOpptAccountEntry, final boolean isAr) {
        promptOpptAccountEntry.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        promptOpptAccountEntry.setVisible(true);
        promptOpptAccountEntry.setEditable(true);
        promptOpptAccountEntry.setDisplayFormat("$number$ $name$");
        promptOpptAccountEntry.setEditFormat("$number$");
        promptOpptAccountEntry.setCommitFormat("$number$;$name$");
        promptOpptAccountEntry.addCommitListener(new CommitListener(){

            public void willCommit(CommitEvent e) {
                try {
                    ArApRecPayBillBaseEditUI.this.setEntryOppAcctEvi(promptOpptAccountEntry, false, isAr);
                }
                catch (Exception exc) {
                    ArApRecPayBillBaseEditUI.this.handUIException(exc);
                }
            }
        });
        promptOpptAccountEntry.addSelectorListener(new SelectorListener(){

            public void willShow(SelectorEvent e) {
                try {
                    ArApRecPayBillBaseEditUI.this.setEntryOppAcctEvi(promptOpptAccountEntry, false, isAr);
                }
                catch (Exception exc) {
                    ArApRecPayBillBaseEditUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void setEntryOppAcctEvi(KDBizPromptBox prmtOppAccountEntry, boolean showCashAndBank, boolean isAr) throws EASBizException, BOSException, ParserException {
        String companyId = this.currentCompany.getId().toString();
        String cuId = null;
        if (this.currentCompany.getCU() != null) {
            cuId = this.currentCompany.getCU().getId().toString();
        }
        String currencyId = this.getCurrencyId();
        prmtOppAccountEntry.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi(cuId, companyId, currencyId, false, showCashAndBank);
        EntityViewInfo evi = new EntityViewInfo(treeevi.toString());
        FilterInfo filterIsLeaf = new FilterInfo();
        filterIsLeaf.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)"1"));
        evi.getFilter().mergeFilter(filterIsLeaf, "and");
        AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.currentCompany, treeevi.getFilter(), false, true, showCashAndBank);
        prmtOppAccountEntry.setSelector((KDPromptSelector)opseelect);
        prmtOppAccountEntry.setEntityViewInfo(evi);
    }

    protected String getCurrencyId() {
        return null;
    }

    protected void setOppAcctEvi(KDBizPromptBox oppF7, boolean initBill) throws EASBizException, BOSException {
        if (!initBill) {
            String companyId = this.cache.getCompanyId();
            String accountTable = this.cache.getCompany().getAccountTable().getId().toString();
            oppF7.getQueryAgent().resetRuntimeEntityView();
            EntityViewInfo evi = this.arapHelper.getCustomAcctEvi(companyId, accountTable);
            AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.cache.getCompany(), evi.getFilter(), false, true);
            oppF7.setEntityViewInfo(evi);
            oppF7.setSelector((KDPromptSelector)opseelect);
            if (!this.DAPCheckAccount) {
                oppF7.setRequired(true);
            }
        } else {
            oppF7.setDisplayFormat("$number$ $name$");
            CasForArApUtil.setContrastAccountF7((IUIObject)this, oppF7, this.cache.getCompany(), true, this.startPeriod);
        }
    }

    protected void setEntryOppAcctEvi(boolean isAr, KDBizPromptBox oppF7, boolean initBill) throws EASBizException, BOSException {
        if (this.cache == null || this.cache.getCompany() == null) {
            this.cache = this.iBillFacade.getSysParams(null, this.getUIParam());
        }
        oppF7.setQueryInfo("com.kingdee.eas.basedata.master.account.app.F7AccountViewQuery");
        oppF7.setEditFormat("$number$");
        oppF7.setCommitFormat("$number$;$name$");
        if (!initBill) {
            String companyId = this.cache.getCompanyId();
            String accountTable = this.cache.getCompany().getAccountTable().getId().toString();
            oppF7.getQueryAgent().resetRuntimeEntityView();
            EntityViewInfo evi = this.arapHelper.getCustomAcctEvi(companyId, accountTable);
            AccountPromptBox opseelect = new AccountPromptBox((IUIObject)this, this.cache.getCompany(), evi.getFilter(), false, true);
            oppF7.setEntityViewInfo(evi);
            oppF7.setSelector((KDPromptSelector)opseelect);
            if (!this.DAPCheckAccount) {
                oppF7.setRequired(true);
            }
        } else {
            oppF7.setDisplayFormat("$number$ $name$");
            CasForArApUtil.setContrastAccountF7((IUIObject)this, oppF7, this.cache.getCompany(), isAr, this.startPeriod);
        }
    }

    protected void setCostCenterF7() throws EASBizException, BOSException {
        String cuID = null;
        String companyID = null;
        if (this.getCompanyOrgUnitF7().getValue() != null) {
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getCompanyOrgUnitF7().getValue();
            if (company.getCU() == null) {
                SelectorItemCollection sic = new SelectorItemCollection();
                sic.add(new SelectorItemInfo("cu.id"));
                company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(company.getId().toString()), sic);
            }
            cuID = company.getCU().getId().toString();
            companyID = company.getId().toString();
        } else {
            cuID = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
            companyID = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        }
        CasForArApUtil.setNewCostCenterF7(this.getCostCenterF7(), cuID, companyID);
        KDBizPromptBox prmtEntryCostCenter = new KDBizPromptBox();
        prmtEntryCostCenter.setDisplayFormat("$name$");
        prmtEntryCostCenter.setEditFormat("$number$");
        prmtEntryCostCenter.setCommitFormat("$number$");
        prmtEntryCostCenter.setQueryInfo("com.kingdee.eas.basedata.org.app.CostCenterItemQuery");
        prmtEntryCostCenter.setEditable(true);
        CasForArApUtil.setNewCostCenterF7(prmtEntryCostCenter, cuID, companyID);
        KDTable detailTable = this.getDetailTable();
        detailTable.getColumn("costCenter").setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)prmtEntryCostCenter));
    }

    protected void initSrcBillUnlockAmt(boolean isIsTransBill, boolean isFromPayBill) throws BOSException, EASBizException {
        KDTable kdtEntries = this.getDetailTable();
        int rowCount = kdtEntries.getRowCount();
        IDynamicObject iObjectInstance = DynamicObjectFactory.getRemoteInstance();
        for (int index = 0; index < rowCount; ++index) {
            BigDecimal destLockAmt;
            IObjectValue srcEntryInfo;
            IRow row = kdtEntries.getRow(index);
            String id = null;
            if (row.getCell("sourceBillEntryID").getValue() instanceof BOSUuid) {
                id = ((BOSUuid)row.getCell("sourceBillEntryID").getValue()).toString();
            } else if (row.getCell("sourceBillEntryID").getValue() instanceof String) {
                id = (String)row.getCell("sourceBillEntryID").getValue();
            }
            if (null == id || this.srcBillUnlockAmtMap.get(id) != null) continue;
            BigDecimal amount = BigDecimal.ZERO;
            BOSObjectType srcBillBosType = BOSUuid.read((String)id).getType();
            String srcBillBosTypeStr = srcBillBosType.toString();
            boolean isSrcBillReqBill = false;
            if ("C84206F8".equals(srcBillBosTypeStr)) {
                srcEntryInfo = iObjectInstance.getValue(srcBillBosType, "select id,auditAmount,totalPayAmt where id = '" + id + "'");
                BigDecimal auditAmount = (BigDecimal)srcEntryInfo.get("auditAmount");
                BigDecimal totalPayAmt = (BigDecimal)srcEntryInfo.get("totalPayAmt");
                amount = auditAmount.subtract(totalPayAmt);
                isSrcBillReqBill = true;
            } else if ("ED4DBC81".equals(srcBillBosTypeStr)) {
                srcEntryInfo = iObjectInstance.getValue(srcBillBosType, "select lockUnVerifyAmt where id = '" + id + "'");
                amount = (BigDecimal)srcEntryInfo.get("lockUnVerifyAmt");
            } else if ("BC91693F".equals(srcBillBosTypeStr)) {
                srcEntryInfo = iObjectInstance.getValue(srcBillBosType, "select lockUnVerifyAmt where id = '" + id + "'");
                amount = (BigDecimal)srcEntryInfo.get("lockUnVerifyAmt");
            } else if ("299A3BD7".equals(srcBillBosTypeStr) && isIsTransBill) {
                srcEntryInfo = iObjectInstance.getValue(srcBillBosType, "select unLockAmt where id = '" + id + "'");
                amount = ((BigDecimal)srcEntryInfo.get("unLockAmt")).abs();
            } else if ("299A3BD7".equals(srcBillBosTypeStr) || "92F9B271".equals(srcBillBosTypeStr)) {
                srcEntryInfo = iObjectInstance.getValue(srcBillBosType, "select unLockAmt where id = '" + id + "'");
                amount = ((BigDecimal)srcEntryInfo.get("unLockAmt")).abs();
            }
            if (amount == null) {
                amount = SysConstant.BIGZERO;
            }
            BigDecimal payLockAmt = null;
            payLockAmt = isFromPayBill ? (BigDecimal)row.getCell("payAmt").getValue() : (BigDecimal)row.getCell("recAmt").getValue();
            if (null == payLockAmt) {
                payLockAmt = SysConstant.BIGZERO;
            }
            if ((destLockAmt = (BigDecimal)row.getCell("lockAmt").getValue()) == null) {
                destLockAmt = SysConstant.BIGZERO;
            }
            if (!isSrcBillReqBill && destLockAmt.compareTo(SysConstant.BIGZERO) != 0) {
                amount = amount.abs().add(payLockAmt.abs());
            }
            this.srcBillUnlockAmtMap.put(id, amount);
        }
    }

    protected KDBizPromptBox getCompanyOrgUnitF7() {
        return null;
    }

    protected KDBizPromptBox getCostCenterF7() {
        return null;
    }

    protected KDBizPromptBox getPrmtPaymentTypeF7() {
        return null;
    }

    protected String getCurrentCompanyID() {
        String companyId = null;
        CompanyOrgUnitInfo companyOrgUnitInfo = null;
        if (this.getCompanyOrgUnitF7().getValue() != null) {
            companyOrgUnitInfo = (CompanyOrgUnitInfo)this.getCompanyOrgUnitF7().getValue();
        }
        if (companyOrgUnitInfo == null) {
            companyOrgUnitInfo = this.cache.getCompany();
        }
        if (companyOrgUnitInfo == null) {
            companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        }
        if (companyOrgUnitInfo != null && companyOrgUnitInfo.getId() != null) {
            companyId = companyOrgUnitInfo.getId().toString();
        }
        return companyId;
    }

    protected void resetPaymentTypeByCustomerOrSupplier(DataBaseInfo currentAsstact) throws EASBizException, BOSException {
        boolean isAR;
        if (this.isAssoGen() || null == currentAsstact) {
            return;
        }
        boolean bl = isAR = SystemEnum.ACCOUNTSRECEIVABLE == this.getSysEnum();
        if (isAR && currentAsstact instanceof CustomerInfo || !isAR && currentAsstact instanceof SupplierInfo) {
            PaymentTypeInfo paymentType = null;
            String assActId = currentAsstact.getId().toString();
            if (this.paymentTypeCache.containsKey(assActId)) {
                paymentType = this.paymentTypeCache.get(assActId);
            } else {
                String companyId = this.getCurrentCompanyID();
                paymentType = isAR ? AsstActHelper.getCustomerPaymentTypeInfo(null, assActId, companyId) : AsstActHelper.getSupplierPaymentTypeInfo(null, assActId, companyId);
                this.paymentTypeCache.put(assActId, paymentType);
            }
            if (null != paymentType && !this.cache.getPaymentTypeCredit().getId().equals((Object)paymentType.getId()) && !this.cache.getPaymentTypeCurrency().getId().equals((Object)paymentType.getId())) {
                paymentType = null;
                this.paymentTypeCache.put(assActId, paymentType);
            }
            if (null == paymentType) {
                paymentType = this.cache.getPaymentTypeCredit();
            }
            if (this.getPrmtPaymentTypeF7().isEnabled()) {
                this.getPrmtPaymentTypeF7().setData((Object)paymentType);
            }
        }
    }

    protected boolean isAssoGen() {
        return false;
    }

    protected void clearVerifyAmt(KDTable kdtEntries, int rowIndex, boolean isRec) {
        BigDecimal verifyAmt;
        BigDecimal bigDecimal = verifyAmt = null == kdtEntries.getCell(rowIndex, "verifiedAmt").getValue() ? BigDecimal.ZERO : (BigDecimal)kdtEntries.getCell(rowIndex, "verifiedAmt").getValue();
        if (verifyAmt.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        String amtFiledName = isRec ? "recAmt" : "payAmt";
        String localAmtFiledName = isRec ? "recLocAmt" : "payLocAmt";
        BigDecimal amt = (BigDecimal)kdtEntries.getCell(rowIndex, amtFiledName).getValue();
        BigDecimal amtLoc = (BigDecimal)kdtEntries.getCell(rowIndex, localAmtFiledName).getValue();
        kdtEntries.getCell(rowIndex, "verifiedAmt").setValue((Object)BigDecimal.ZERO);
        kdtEntries.getCell(rowIndex, "verifiedAmtLoc").setValue((Object)BigDecimal.ZERO);
        kdtEntries.getCell(rowIndex, "unVerifiedAmt").setValue((Object)amt);
        kdtEntries.getCell(rowIndex, "unVerifiedAmtLoc").setValue((Object)amtLoc);
        kdtEntries.getCell(rowIndex, "lockAmt").setValue((Object)BigDecimal.ZERO);
        kdtEntries.getCell(rowIndex, "unLockAmt").setValue((Object)amt);
    }

    protected void checkObjectExists(String boId) throws Exception {
        if (StringUtils.isEmpty((String)boId)) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)boId)))) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    protected KDBizPromptBox getPrmtPersonF7() {
        return null;
    }

    protected KDBizPromptBox getPrmtAdminOrgUnitF7() {
        return null;
    }

    protected void addCommonListener() {
        if (this.getPrmtPersonF7() != null) {
            if (this.personListener == null) {
                this.personListener = new DataChangeListener(){

                    public void dataChanged(DataChangeEvent e) {
                        try {
                            ArApRecPayBillBaseEditUI.this.prmtPerson_dataChanged(e);
                        }
                        catch (Exception exc) {
                            ArApRecPayBillBaseEditUI.this.handUIException(exc);
                        }
                    }
                };
            }
            this.getPrmtPersonF7().addDataChangeListener(this.personListener);
        }
    }

    protected void removeCommonListener() {
        if (null != this.getPrmtPersonF7() && null != this.personListener) {
            this.getPrmtPersonF7().removeDataChangeListener(this.personListener);
        }
    }

    protected void prmtPerson_dataChanged(DataChangeEvent e) throws Exception {
        if (null == e.getNewValue() || !(e.getNewValue() instanceof PersonInfo)) {
            return;
        }
        PersonInfo oldValue = e.getOldValue() == null ? null : (!(e.getOldValue() instanceof PersonInfo) ? null : (PersonInfo)e.getOldValue());
        PersonInfo newValue = (PersonInfo)e.getNewValue();
        if (null != oldValue && newValue.getId().equals((Object)oldValue.getId())) {
            return;
        }
        IObjectValue object = RecPayBillFacadeFactory.getRemoteInstance().getUserPrimaryPositionAdminOrg(newValue.getId().toString());
        if (null != object) {
            AdminOrgUnitInfo adminOrg = (AdminOrgUnitInfo)object;
            if (null != this.getPrmtAdminOrgUnitF7()) {
                this.getPrmtAdminOrgUnitF7().setData((Object)adminOrg);
            }
        }
    }

    protected String[] getCommonRows() {
        return null;
    }

    public void allocateEntry(Map<String, IRow> groupKeyMap, Map<String, List> entryKeyMap, Integer allocateFlag) throws Exception {
        int discountIndex;
        KDTable kdtEntries = this.getDetailTable();
        String[] commonRows = this.getCommonRows();
        String colKey = "recAmt";
        if (kdtEntries.getColumn("recAmt") == null) {
            colKey = "payAmt";
        }
        int amtIndex = kdtEntries.getColumnIndex(colKey);
        int commissionIndex = discountIndex = kdtEntries.getColumnIndex("rebateAmt");
        if (kdtEntries.getColumn("commission") != null) {
            commissionIndex = kdtEntries.getColumnIndex("commission");
        }
        ArrayList<Integer> deleteEntries = new ArrayList<Integer>();
        for (String key : groupKeyMap.keySet()) {
            BigDecimal entryAmt;
            IRow entry;
            int i;
            IRow sumRow = groupKeyMap.get(key);
            List entryList = entryKeyMap.get(key);
            if (entryList == null) continue;
            int precision = ((BigDecimal)sumRow.getCell(amtIndex).getValue()).scale();
            BigDecimal totalAmt = BigDecimal.ZERO;
            BigDecimal sumTotalAmt = (BigDecimal)sumRow.getCell(amtIndex).getValue();
            BigDecimal allocateAmt = (BigDecimal)sumRow.getCell(amtIndex).getValue();
            BigDecimal sumTotalDiscount = (BigDecimal)sumRow.getCell(discountIndex).getValue();
            BigDecimal sumTotalCommission = (BigDecimal)sumRow.getCell(commissionIndex).getValue();
            for (i = 0; i < entryList.size(); ++i) {
                entry = (IRow)entryList.get(i);
                entryAmt = (BigDecimal)entry.getCell(amtIndex).getValue();
                entryAmt = entryAmt == null ? BigDecimal.ZERO : entryAmt;
                totalAmt = totalAmt.add(entryAmt);
            }
            for (i = 0; i < entryList.size(); ++i) {
                entry = (IRow)entryList.get(i);
                if (allocateAmt.compareTo(BigDecimal.ZERO) == 0) {
                    deleteEntries.add(entry.getRowIndex());
                    continue;
                }
                entryAmt = BigDecimal.ZERO;
                BigDecimal entryDiscount = BigDecimal.ZERO;
                BigDecimal entryCommission = BigDecimal.ZERO;
                if (allocateFlag == 0) {
                    entryAmt = (BigDecimal)entry.getCell(amtIndex).getValue();
                    if (entryAmt.abs().compareTo(allocateAmt.abs()) < 0) {
                        entryDiscount = sumTotalDiscount.multiply(entryAmt).divide(sumTotalAmt, precision, 4);
                        entryCommission = sumTotalCommission.multiply(entryAmt).divide(sumTotalAmt, precision, 4);
                        allocateAmt = allocateAmt.subtract(entryAmt);
                    } else {
                        entryAmt = (BigDecimal)sumRow.getCell(amtIndex).getValue();
                        entryDiscount = (BigDecimal)sumRow.getCell(discountIndex).getValue();
                        entryCommission = (BigDecimal)sumRow.getCell(commissionIndex).getValue();
                        allocateAmt = BigDecimal.ZERO;
                    }
                } else if (allocateFlag == 1) {
                    if (i == entryList.size() - 1) {
                        entryAmt = (BigDecimal)sumRow.getCell(amtIndex).getValue();
                        entryDiscount = (BigDecimal)sumRow.getCell(discountIndex).getValue();
                        entryCommission = (BigDecimal)sumRow.getCell(commissionIndex).getValue();
                    } else {
                        entryAmt = sumTotalAmt.multiply((BigDecimal)entry.getCell(amtIndex).getValue()).divide(totalAmt, precision, 4);
                        entryDiscount = sumTotalDiscount.multiply(entryAmt).divide(sumTotalAmt, precision, 4);
                        entryCommission = sumTotalCommission.multiply(entryAmt).divide(sumTotalAmt, precision, 4);
                    }
                }
                entry.getCell(amtIndex).setValue((Object)entryAmt);
                entry.getCell(discountIndex).setValue((Object)entryDiscount);
                entry.getCell(commissionIndex).setValue((Object)entryCommission);
                for (int j = 0; j < commonRows.length; ++j) {
                    String field = commonRows[j];
                    if (sumRow.getCell(field) == null || sumRow.getCell(field).getValue() == null || entry.getCell(field) == null || entry.getCell(field).getValue() == null) continue;
                    BigDecimal subValue = ((BigDecimal)sumRow.getCell(field).getValue()).subtract((BigDecimal)entry.getCell(field).getValue());
                    sumRow.getCell(field).setValue((Object)subValue);
                }
                KDTEditEvent amtEvent = new KDTEditEvent((Object)kdtEntries);
                amtEvent.setRowIndex(entry.getRowIndex());
                amtEvent.setColIndex(amtIndex);
                amtEvent.setValue((Object)entryAmt);
                amtEvent.setOldValue((Object)BigDecimal.ZERO);
                this.editStop_quickInput(amtEvent);
                KDTEditEvent discountEvent = new KDTEditEvent((Object)kdtEntries);
                discountEvent.setRowIndex(entry.getRowIndex());
                discountEvent.setColIndex(discountIndex);
                discountEvent.setValue((Object)entryDiscount);
                discountEvent.setOldValue((Object)BigDecimal.ZERO);
                this.editStop_quickInput(discountEvent);
            }
        }
        deleteEntries.sort(new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return o2 - o1;
            }
        });
        for (int i = 0; i < deleteEntries.size(); ++i) {
            kdtEntries.removeRow(((Integer)deleteEntries.get(i)).intValue());
        }
    }

    public void editStop_quickInput(KDTEditEvent e) throws Exception {
    }

    public void calcEntry_quickInput(KDTEditEvent e, Map paramMap) throws Exception {
        KDTable entry = this.getDetailTable();
        IRow row = (IRow)paramMap.get("row");
        Set groupFields = (Set)paramMap.get("groupFields");
        String colKey = "recAmt";
        if (row.getCell("recAmt") == null) {
            colKey = "payAmt";
        }
        String key = ArApRecPayHelper.getKeyByGroup(row, groupFields, colKey);
        if (e == null) {
            this.maxAmtMap.put(key, (BigDecimal)row.getCell(colKey).getValue());
            return;
        }
        if (e.getColIndex() == entry.getColumnIndex("recAmt") || e.getColIndex() == entry.getColumnIndex("payAmt")) {
            BigDecimal maxValue = this.maxAmtMap.get(key);
            BigDecimal newValue = (BigDecimal)e.getValue();
            BigDecimal oldValue = (BigDecimal)e.getOldValue();
            if (newValue == null || maxValue != null && maxValue.abs().compareTo(newValue.abs()) < 0 || oldValue != null && oldValue.multiply(newValue).compareTo(BigDecimal.ZERO) <= 0) {
                entry.getCell(entry.getRowCount() - 1, e.getColIndex()).setValue(e.getOldValue());
                return;
            }
        }
        this.editStop_quickInput(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        RecPayBillInfo info = (RecPayBillInfo)this.getEditData();
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String boID = this.getSelectBOID();
        if (boID == null || OprtState.ADDNEW.equals(this.getOprtState())) {
            super.actionAttachment_actionPerformed(e);
        } else if (BillStatusEnum.SAVE.equals((Object)info.getBillStatus()) || BillStatusEnum.SUBMIT.equals((Object)info.getBillStatus())) {
            acm.showAttachmentListUIByBoID(boID, (Object)this, true, true, true);
        } else {
            acm.showAttachmentListUIByBoID(boID, (Object)this, true, false, false);
        }
    }

    @Override
    public void actionSelectCloudInvoice_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"action", (Object)"selectCloudInvoice");
        if (this.editData.getId() == null) {
            this.editData.setId(BOSUuid.create((BOSObjectType)this.editData.getBOSType()));
        }
        uiContext.put((Object)"bill", (Object)this.editData);
        uiContext.put((Object)"Owner", (Object)this);
        this.storeFields();
        Method openFpzsInvoicesUI = null;
        try {
            Class<?> clazz = Class.forName("com.kingdee.eas.base.wssc.client.InvoiceBillHelper");
            openFpzsInvoicesUI = clazz.getMethod("openFpzsInvoicesUI", UIContext.class);
        }
        catch (Exception clazz) {
            // empty catch block
        }
        if (null == openFpzsInvoicesUI) {
            try {
                IUIWindow iuiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.base.wssc.client.InvoiceBillViewUI", (Map)uiContext, null, OprtState.VIEW);
                if (iuiWindow != null) {
                    iuiWindow.show();
                }
            }
            catch (Exception e1) {
                logger.error((Object)e1.getMessage());
                this.handUIException(e1);
                SysUtil.abort();
            }
        } else {
            openFpzsInvoicesUI.invoke(null, uiContext);
        }
    }

    protected void initDataStatus() {
        super.initDataStatus();
        RecPayBillInfo billInfo = (RecPayBillInfo)this.editData;
        if (this.getOprtState().equals(OprtState.ADDNEW)) {
            this.actionSelectCloudInvoice.setEnabled(false);
        } else {
            this.actionSelectCloudInvoice.setEnabled(true);
        }
        if (billInfo != null && !BillStatusEnum.SUBMIT.equals((Object)billInfo.getBillStatus()) && !BillStatusEnum.SAVE.equals((Object)billInfo.getBillStatus())) {
            this.actionSelectCloudInvoice.setEnabled(false);
        }
        this.actionSelectCloudInvoice.setVisible(false);
    }

    public void actionCreateTo_actionPerformed(ActionEvent e) throws Exception {
        CoreBillBaseInfo bill = this.editData;
        if (bill.getId() == null) {
            return;
        }
        ObjectUuidPK pk = new ObjectUuidPK(bill.getId());
        bill = (CoreBillBaseInfo)this.getBizInterface().getValue((IObjectPK)pk, this.getSelectors());
        this.getBillEdit().CreateTo(bill);
    }

    public boolean useScrollPane() {
        return true;
    }

    public int getVerticalScrollPolicy() {
        return 20;
    }

    public int getHorizontalScrollPolicy() {
        return 30;
    }

    protected void afterMainOrgChanged(String oldOrgId, String newOrgId) {
        super.afterMainOrgChanged(oldOrgId, newOrgId);
        try {
            super.doFieldPermission();
        }
        catch (Exception e) {
            this.handUIException(e.getCause());
        }
    }
}

