/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeInfo;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupFactory;
import com.kingdee.eas.basedata.master.auxacct.GeneralAsstActTypeGroupInfo;
import com.kingdee.eas.basedata.master.auxacct.IGeneralAsstActType;
import com.kingdee.eas.basedata.master.auxacct.ShareTacticEnum;
import com.kingdee.eas.basedata.master.auxacct.client.GeneralAuxacctPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class AuxAccountUtils {
    private static Logger logger = Logger.getLogger((String)AuxAccountUtils.class.getName());
    private static final String FILTERFIELD_CUID = "CU.id";
    private static final String FILTERFIELD_CULONGNUMBER = "CU.longNumber";

    public static CtrlUnitInfo getSysCU() {
        CtrlUnitInfo rootCU = new CtrlUnitInfo();
        rootCU.setId(BOSUuid.read((String)"11111111-1111-1111-1111-111111111111CCE7AED4"));
        return rootCU;
    }

    public static void assignGeneralBizPromptBox(KDBizPromptBox bizPromptBox, AsstActTypeInfo asstActTypeInfo, boolean isUnUse, CoreUIObject ui, CompanyOrgUnitInfo company) {
        EntityViewInfo v;
        GeneralAsstActTypeGroupInfo info = asstActTypeInfo.getGlAsstActTypeGrp();
        String groupID = info.getId().toString();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("group.id", (Object)groupID));
        if (!isUnUse) {
            filterInfo.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)new Integer(1)));
        }
        GeneralAuxacctPromptBox gapb = new GeneralAuxacctPromptBox((IUIObject)ui, groupID, filterInfo, company.getCU());
        bizPromptBox.setSelector((KDPromptSelector)gapb);
        ShareTacticEnum share = ShareTacticEnum.S2;
        if (info != null) {
            share = info.getShareTactic();
        }
        FilterInfo fi = AuxAccountUtils.getDefaultFilterForQuery(groupID, info, company);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)groupID));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Integer(1)));
        if (share.equals((Object)ShareTacticEnum.S2) || share.equals((Object)ShareTacticEnum.B1)) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)AuxAccountUtils.getGeneralCollection(null, company, groupID), CompareType.NOTINCLUDE));
            if (!isUnUse) {
                filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)new Integer(1)));
                filter.setMaskString("#0 and (#1 or #2) and #3");
            } else {
                filter.setMaskString("#0 and (#1 or #2)");
            }
        } else if (!isUnUse) {
            filter.getFilterItems().add(new FilterItemInfo("isEnabled", (Object)new Integer(1)));
            filter.setMaskString("#0 and #1 and #2");
        } else {
            filter.setMaskString("#0 and #1 ");
        }
        if (fi != null && fi.getFilterItems().size() != 0) {
            try {
                fi.mergeFilter(filter, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        if ((v = bizPromptBox.getEntityViewInfo()) == null) {
            v = new EntityViewInfo();
            bizPromptBox.setEntityViewInfo(v);
        }
        v.setFilter(fi);
        SelectorItemCollection sic = bizPromptBox.getSelectorCollection();
        if (sic == null) {
            sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("number"));
            sic.add(new SelectorItemInfo("name"));
            bizPromptBox.setSelectorCollection(sic);
        }
        sic.add(new SelectorItemInfo("displayName"));
        sic.add(new SelectorItemInfo("measureUnit.name"));
        sic.add(new SelectorItemInfo("measureUnit.number"));
        sic.add(new SelectorItemInfo("measureUnitGroup.name"));
    }

    public static String getGeneralCollection(Context ctx, CompanyOrgUnitInfo company, String groupid) {
        String par = "";
        try {
            IGeneralAsstActType iGAAT;
            CtrlUnitInfo CU = null;
            if (ctx == null) {
                iGAAT = GeneralAsstActTypeFactory.getRemoteInstance();
                if (company == null) {
                    company = SysContext.getSysContext().getCurrentFIUnit();
                }
                CU = company.getCU();
            } else {
                iGAAT = GeneralAsstActTypeFactory.getLocalInstance((Context)ctx);
                if (company == null) {
                    company = ContextUtil.getCurrentFIUnit((Context)ctx);
                }
                CU = company.getCU();
            }
            String currentCUID = CU.getId().toString();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("groupID", groupid);
            map.put("cuID", currentCUID);
            String currentCompanyID = company.getId().toString();
            map.put("companyID", currentCompanyID);
            par = iGAAT.f7getCollection(map);
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
        }
        if (par.length() == 0) {
            par = "00000000-0000-0000-0000-000000000000F90B0133";
        }
        return par;
    }

    private static GeneralAsstActTypeGroupInfo getGeneralAsstActTypeGroupInfo(String generalAsstActTypeGroup) {
        GeneralAsstActTypeGroupInfo info = null;
        try {
            info = GeneralAsstActTypeGroupFactory.getRemoteInstance().getGeneralAsstActTypeGroupInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)generalAsstActTypeGroup)));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return info;
    }

    public static FilterInfo getDefaultFilterForQuery(String generalAsstActTypeGroup, GeneralAsstActTypeGroupInfo info, CompanyOrgUnitInfo company) {
        CtrlUnitInfo CU = company.getCU();
        if (FMHelper.isEmpty((String)CU.getLongNumber())) {
            try {
                CU = CtrlUnitFactory.getRemoteInstance().getCtrlUnitInfo((IObjectPK)new ObjectUuidPK(company.getCU().getId()));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                logger.error((Object)e);
            }
        }
        String currentCUID = CU.getId().toString();
        String currentCULongNumber = CU.getLongNumber();
        FilterInfo fi = new FilterInfo();
        FilterItemCollection fic = fi.getFilterItems();
        fic.add(new FilterItemInfo(FILTERFIELD_CUID, (Object)currentCUID));
        if (generalAsstActTypeGroup != null && info != null) {
            if (info.getShareTactic().equals((Object)ShareTacticEnum.S3)) {
                fi.setMaskString("#0 ");
            } else {
                String ln = currentCULongNumber;
                String[] lnSecs = ln.split("!");
                int size = lnSecs.length;
                HashSet<String> lnUps = new HashSet<String>();
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < size - 1; ++i) {
                    if (i != 0) {
                        sb.append("!");
                    }
                    sb.append(lnSecs[i]);
                    lnUps.add(sb.toString());
                }
                if (lnUps.size() != 0) {
                    fic.add(new FilterItemInfo(FILTERFIELD_CULONGNUMBER, lnUps, CompareType.INCLUDE));
                    fi.setMaskString("#0 or #1");
                }
            }
        } else {
            fi.setMaskString("#0 ");
        }
        return fi;
    }
}

