/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fi.cas.XTable;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BSReportHelper {
    public static XTable createBSDataTable(PeriodCollection periodCol, String[] companyIds, String[] bankIds, CurrencyInfo currency) throws EASBizException, BOSException {
        XTable balanceTable = BSReportHelper.createBSBalanceTable(periodCol.get(0), companyIds, bankIds, currency);
        XTable sumTable = BSReportHelper.createBSSumTable(periodCol, companyIds, bankIds, new String[]{currency.getId().toString()});
        for (int i = 0; i < periodCol.size(); ++i) {
            PeriodInfo curPeriod = periodCol.get(i);
            String[] rowKeys = balanceTable.getRowKeys();
            for (int j = 0; j < rowKeys.length; ++j) {
                String rowKey = rowKeys[j];
                Map balanceRow = balanceTable.getRow(rowKey);
                PeriodInfo period = (PeriodInfo)balanceRow.get("period");
                if (!curPeriod.getId().toString().equals(period.getId().toString())) continue;
                Map sumRow = sumTable.getRow(rowKey);
                if (sumRow != null) {
                    BigDecimal debitAmount = (BigDecimal)sumRow.get("debitamount");
                    BigDecimal creditAmount = (BigDecimal)sumRow.get("creditamount");
                    if (debitAmount == null) {
                        debitAmount = FMConstants.ZERO;
                    }
                    if (creditAmount == null) {
                        creditAmount = FMConstants.ZERO;
                    }
                    balanceRow.put("debitAmount", debitAmount);
                    balanceRow.put("creditAmount", creditAmount);
                } else {
                    balanceRow.put("debitAmount", FMConstants.ZERO);
                    balanceRow.put("creditAmount", FMConstants.ZERO);
                }
                if (i == periodCol.size() - 1) continue;
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)balanceRow.get("company");
                BankInfo bank = (BankInfo)balanceRow.get("bank");
                CurrencyInfo currencyInfo = (CurrencyInfo)balanceRow.get("currency");
                AccountBankInfo accountBank = (AccountBankInfo)balanceRow.get("accountBank");
                BigDecimal balance = (BigDecimal)balanceRow.get("balance");
                BigDecimal debitAmount = (BigDecimal)balanceRow.get("debitAmount");
                BigDecimal creditAmount = (BigDecimal)balanceRow.get("creditAmount");
                Map nextPeriodRow = balanceTable.addRow(periodCol.get(i + 1).getId().toString() + company.getId().toString() + bank.getId().toString() + currencyInfo.getId().toString() + accountBank.getId().toString());
                nextPeriodRow.put("period", periodCol.get(i + 1));
                nextPeriodRow.put("company", company);
                nextPeriodRow.put("bank", bank);
                nextPeriodRow.put("currency", currencyInfo);
                nextPeriodRow.put("accountBank", accountBank);
                nextPeriodRow.put("balance", balance.add(creditAmount).subtract(debitAmount));
                nextPeriodRow.put("debitAmount", FMConstants.ZERO);
                nextPeriodRow.put("creditAmount", FMConstants.ZERO);
            }
        }
        return balanceTable;
    }

    private static XTable createBSBalanceTable(PeriodInfo period, String[] companyIds, String[] bankIds, CurrencyInfo currency) throws EASBizException, BOSException {
        XTable bsTable = new XTable();
        bsTable = new XTable();
        bsTable.addColumn("period");
        bsTable.addColumn("company");
        bsTable.addColumn("bank");
        bsTable.addColumn("accountBank");
        bsTable.addColumn("balance");
        bsTable.addColumn("debitAmount");
        bsTable.addColumn("creditAmount");
        BSReportHelper.fillBSBalanceReport_New(bsTable, period, companyIds, bankIds, currency);
        return bsTable;
    }

    private static Set createSetByArray(String[] array) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < array.length; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    private static void fillBSBalanceReport_New(XTable bsTable, PeriodInfo period, String[] companyIds, String[] bankIds, CurrencyInfo currency) throws BOSException, EASBizException {
        AccountBankCollection col = CashHelper.getAccountBankCollection(companyIds, bankIds, false);
        ICashManagement iCash = CashManagementFactory.getRemoteInstance();
        Map hmBalance = iCash.getBStateData2Map(col, currency.getId().toString(), period.getBeginDate(), period.getBeginDate(), CashDataTypeEnum.C, false, null);
        for (int i = 0; i < col.size(); ++i) {
            AccountBankInfo accountBank = col.get(i);
            String rowKey = period.getId().toString() + accountBank.getCompany().getId().toString() + accountBank.getBank().getId().toString() + currency.getId().toString() + accountBank.getId().toString();
            Map map = bsTable.addRow(rowKey);
            BigDecimal balance = BSReportHelper.getBalanceFromCache(accountBank, period, currency, hmBalance);
            map.put("period", period);
            map.put("company", accountBank.getCompany());
            map.put("bank", accountBank.getBank());
            map.put("currency", currency);
            map.put("accountBank", accountBank);
            map.put("balance", balance);
            map.put("debitAmount", FMConstants.ZERO);
            map.put("creditAmount", FMConstants.ZERO);
        }
    }

    private static BigDecimal getBalanceFromCache(AccountBankInfo accountBank, PeriodInfo period, CurrencyInfo currency, Map hmBalance) {
        String currencyId;
        String accountBankId;
        String companyId = accountBank.getCompany().getId().toString();
        String key = BSReportHelper.genKey(companyId, accountBankId = accountBank.getId().toString(), currencyId = currency.getId().toString(), period.getBeginDate(), period.getBeginDate());
        Object banlanc = hmBalance.get(key);
        return banlanc == null ? FMConstants.ZERO : (BigDecimal)banlanc;
    }

    private static String genKey(String companyId, String accountBankId, String currencyId, Date beginDate, Date endDate) {
        StringBuffer sb = new StringBuffer();
        sb.append(companyId).append(accountBankId).append(currencyId).append(beginDate.toString()).append(endDate.toString());
        return sb.toString();
    }

    private static void fillBSBalanceReport(XTable bsTable, PeriodInfo period, String[] companyIds, String[] bankIds, CurrencyInfo currency) throws BOSException, EASBizException {
        AccountBankCollection col = CashHelper.getAccountBankCollection(companyIds, bankIds, false);
        ICashManagement iCash = CashManagementFactory.getRemoteInstance();
        for (int i = 0; i < col.size(); ++i) {
            AccountBankInfo accountBank = col.get(i);
            String rowKey = period.getId().toString() + accountBank.getCompany().getId().toString() + accountBank.getBank().getId().toString() + currency.getId().toString() + accountBank.getId().toString();
            Map map = bsTable.addRow(rowKey);
            BigDecimal balance = iCash.getBStateData(accountBank.getCompany().getId().toString(), accountBank.getId().toString(), currency.getId().toString(), period.getBeginDate(), period.getBeginDate(), CashDataTypeEnum.C, false);
            map.put("period", period);
            map.put("company", accountBank.getCompany());
            map.put("bank", accountBank.getBank());
            map.put("currency", currency);
            map.put("accountBank", accountBank);
            map.put("balance", balance);
            map.put("debitAmount", FMConstants.ZERO);
            map.put("creditAmount", FMConstants.ZERO);
        }
    }

    private static XTable createBSSumTable(PeriodCollection periodCol, String[] companyIds, String[] bankIds, String[] currencyIds) throws BOSException {
        String sumSql = BSReportHelper.getBSSumSQL(periodCol, companyIds, bankIds, currencyIds);
        IRowSet sumRS = SQLExecutorFactory.getRemoteInstance((String)sumSql).executeSQL();
        XTable xSumTable = new XTable(sumRS, new String[]{"period", "company", "bank", "currency", "accountBank"});
        return xSumTable;
    }

    private static String getBSSumSQL(PeriodCollection periodCol, String[] companyIds, String[] bankIds, String[] currencyIds) {
        int i;
        String select = "Select FPeriodID as period,t1.FCompanyID as company,FBank as bank,t1.FCurrencyID as currency,FAccountBankId as accountBank,sum(FDebitAmount) as debitAmount,sum(FCreditAmount) as creditAmount";
        String from = " From t_cas_bankStatement t1 left join t_bd_accountBanks t2 on t1.faccountbankid=t2.fid";
        String groupBy = " Group By FPeriodID,t1.FCompanyID,FBank,t1.FCurrencyID,FAccountBankId";
        StringBuffer where = new StringBuffer();
        where.append(" where 1=1 ");
        if (periodCol != null) {
            where.append(" And t1.FPeriodID in ('").append(periodCol.get(0).getId().toString()).append("'");
            for (i = 1; i < periodCol.size(); ++i) {
                where.append(",'").append(periodCol.get(i).getId().toString()).append("'");
            }
            where.append(")");
        }
        if (companyIds != null && companyIds.length != 0) {
            where.append(" And t1.FcompanyId in ('").append(companyIds[0]).append("'");
            for (i = 1; i < companyIds.length; ++i) {
                where.append(",'").append(companyIds[i]).append("'");
            }
            where.append(")");
        }
        if (bankIds != null && bankIds.length != 0) {
            where.append(" And  FBank in ('").append(bankIds[0]).append("'");
            for (i = 1; i < bankIds.length; ++i) {
                where.append(",'").append(bankIds[i]).append("'");
            }
            where.append(")");
        }
        if (currencyIds != null && currencyIds.length != 0) {
            where.append(" And  t1.FCurrencyID in ('").append(currencyIds[0]).append("'");
            for (i = 1; i < currencyIds.length; ++i) {
                where.append(",'").append(currencyIds[i]).append("'");
            }
            where.append(")");
        }
        String sql = select + from + where + groupBy;
        return sql;
    }
}

