/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.JournalBalanceCollection;
import com.kingdee.eas.fi.cas.JournalBalanceInfo;
import com.kingdee.eas.fi.cas.client.AbstractCashMgtInitHandler;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import java.math.BigDecimal;

public class BankAccountInitHandler
extends AbstractCashMgtInitHandler {
    public final String BANKACCT_NAME_COL = "bankAcct";
    public final String BANKACCT_NUMBER_COL = "bankAcctNum";
    public final String BANKACCT_ACCTNUM_COL = "bankAcctAcctNum";
    public final String BANKDEPTACCT_COL = "bankDepositAcct";
    public final String DEB_COL = "yearDebitAmt";
    public final String CRE_COL = "yearCreditAmt";
    public final String BAL_COL = "beginBalance";
    public final String ASBAL_COL = "asBalance";
    public final String[] noEditColumns = new String[]{"bankAcct", "bankAcctNum", "bankAcctAcctNum", "bankDepositAcct", "asBalance", "adjustJournalBalance", "adjustASBalance", "isBalanced"};

    @Override
    public void initTable(KDTable table, boolean isFirstPeriod) {
        String[] columnKeys = new String[]{"bankAcct", "bankAcctNum", "bankAcctAcctNum", "bankDepositAcct", "yearDebitAmt", "yearCreditAmt", "beginBalance", "asBalance", "adjustJournalBalance", "adjustASBalance", "isBalanced"};
        String[] columnNames = new String[]{this.BANKACCOUNT, this.BANKACCOUNT_NUM, this.BANKACCOUNT_ACCTNUM, this.BANKDEPOSITACCOUNT, this.YEARDEBITAMOUNT, this.YEARCREDITAMOUNT, this.BEGINBALANCE, this.ASBALANCE, this.ADJUSTJOURNALBALANCE, this.ADJUSTASBALANCE, this.ISBALANCED};
        table.addColumns(columnKeys.length);
        IRow hRow = table.addHeadRow();
        for (int i = 0; i < columnKeys.length; ++i) {
            table.getColumn(i).setKey(columnKeys[i]);
            hRow.getCell(i).setValue((Object)columnNames[i]);
        }
        IColumn column = table.getColumn("bankDepositAcct");
        if (column != null) {
            column.setWidth(180);
        }
        super.initTable(table, isFirstPeriod);
    }

    @Override
    public void initKDTableFormatter(KDTable table) {
        for (int i = 0; i < this.noEditColumns.length; ++i) {
            IColumn column = table.getColumn(this.noEditColumns[i]);
            this.setColumnColor(column);
        }
        table.getColumn("asBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("adjustJournalBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("adjustASBalance").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        FMClientHelper.setNumberFormat((KDTable)table, (String)"asBalance", (String)this.getCurrency().getId().toString());
        FMClientHelper.setNumberFormat((KDTable)table, (String)"adjustJournalBalance", (String)this.getCurrency().getId().toString());
        FMClientHelper.setNumberFormat((KDTable)table, (String)"adjustASBalance", (String)this.getCurrency().getId().toString());
        table.getColumn("adjustJournalBalance").setWidth(130);
        table.getColumn("adjustASBalance").setWidth(130);
    }

    @Override
    public void loadField(KDTable table) throws Exception {
        super.loadField(table);
    }

    @Override
    public void loadLineFields(IRow row, JournalBalanceInfo obj) {
        CurrencyInfo currencyInfo = super.getCurrency();
        int scale = currencyInfo.getPrecision();
        JournalBalanceInfo initInfo = obj;
        AccountBankInfo accountBank = initInfo.getAccountBank();
        row.getCell("bankAcct").setValue((Object)accountBank);
        row.getCell("bankAcct").setUserObject((Object)accountBank);
        if (accountBank != null) {
            row.getCell("bankDepositAcct").setValue((Object)initInfo.getAccountView());
            row.getCell("bankDepositAcct").setUserObject((Object)initInfo.getAccountView());
            row.getCell("bankAcctNum").setValue((Object)accountBank.getNumber());
            row.getCell("bankAcctAcctNum").setValue((Object)accountBank.getBankAccountNumber());
        } else {
            row.getCell("bankDepositAcct").setValue(null);
            row.getCell("bankDepositAcct").setUserObject(null);
        }
        BigDecimal debitStartAmt = initInfo.getDebitStartAmt();
        if (debitStartAmt == null) {
            debitStartAmt = CasConstants.ZERO;
        }
        if (debitStartAmt != null) {
            debitStartAmt = this.getBigDecimalByScale(debitStartAmt, scale);
        }
        row.getCell("yearDebitAmt").setValue((Object)debitStartAmt);
        BigDecimal creditStartAmt = initInfo.getCreditStartAmt();
        if (creditStartAmt == null) {
            creditStartAmt = CasConstants.ZERO;
        }
        if (creditStartAmt != null) {
            creditStartAmt = this.getBigDecimalByScale(creditStartAmt, scale);
        }
        row.getCell("yearCreditAmt").setValue((Object)creditStartAmt);
        BigDecimal monthStartAmt = initInfo.getMonthStartAmt();
        if (monthStartAmt == null) {
            monthStartAmt = CasConstants.ZERO;
        }
        if (monthStartAmt != null) {
            monthStartAmt = this.getBigDecimalByScale(monthStartAmt, scale);
        }
        row.getCell("beginBalance").setValue((Object)monthStartAmt);
        BigDecimal acctStatStartAmt = initInfo.getAcctStatementMonthStartAmt();
        if (acctStatStartAmt == null) {
            acctStatStartAmt = CasConstants.ZERO;
        }
        if (acctStatStartAmt != null) {
            acctStatStartAmt = this.getBigDecimalByScale(acctStatStartAmt, scale);
        }
        row.getCell("asBalance").setValue((Object)acctStatStartAmt);
        BigDecimal adjustJournalStartAmt = initInfo.getAdjustedJournalMonthStartAmt();
        if (adjustJournalStartAmt == null) {
            adjustJournalStartAmt = CasConstants.ZERO;
        }
        if (adjustJournalStartAmt != null) {
            adjustJournalStartAmt = this.getBigDecimalByScale(adjustJournalStartAmt, scale);
        }
        row.getCell("adjustJournalBalance").setValue((Object)adjustJournalStartAmt);
        BigDecimal adjustASStartAmt = initInfo.getAdjustedASMonthStartAmt();
        if (adjustASStartAmt == null) {
            adjustASStartAmt = CasConstants.ZERO;
        }
        if (adjustASStartAmt != null) {
            adjustASStartAmt = this.getBigDecimalByScale(adjustASStartAmt, scale);
        }
        row.getCell("adjustASBalance").setValue((Object)adjustASStartAmt);
        Boolean blnObj = new Boolean(initInfo.isIsBalanced());
        row.getCell("isBalanced").setValue((Object)blnObj);
    }

    @Override
    public void storeField(KDTable table) throws Exception {
        table.getEditManager().stopEditing();
        int rowCount = table.getRowCount();
        JournalBalanceCollection journalBalCol = null;
        JournalBalanceInfo tmpJournalBalInfo = null;
        if (rowCount > 0) {
            journalBalCol = new JournalBalanceCollection();
            for (int i = 0; i < rowCount; ++i) {
                IRow row = table.getRow(i);
                if (i == 0) {
                    tmpJournalBalInfo = (JournalBalanceInfo)row.getUserObject();
                    tmpJournalBalInfo.setCompany(this.getCompanyInfo());
                    tmpJournalBalInfo.setCurrency(this.getCurrency());
                    tmpJournalBalInfo.setPeriod(this.getPeriodInfo());
                    tmpJournalBalInfo.setType(AccountTypeEnum.BANKACCOUNT);
                }
                if (this.isRowNotValid(row)) continue;
                JournalBalanceInfo journalBalInfo = (JournalBalanceInfo)row.getUserObject();
                journalBalInfo.setIsInit(true);
                journalBalInfo.setCompany(this.getCompanyInfo());
                journalBalInfo.setCurrency(this.getCurrency());
                journalBalInfo.setPeriod(this.getPeriodInfo());
                journalBalInfo.setType(AccountTypeEnum.BANKACCOUNT);
                journalBalInfo.setAccountBank((AccountBankInfo)row.getCell("bankAcct").getValue());
                journalBalInfo.setDebitStartAmt(this.getBigDecimal(row.getCell("yearDebitAmt").getValue()));
                journalBalInfo.setCreditStartAmt(this.getBigDecimal(row.getCell("yearCreditAmt").getValue()));
                journalBalInfo.setMonthStartAmt(this.getBigDecimal(row.getCell("beginBalance").getValue()));
                journalBalInfo.setYearStartAmt(this.getBigDecimal(row.getCell("beginBalance").getValue()));
                journalBalCol.add(journalBalInfo);
            }
        }
        super.storeData(journalBalCol, tmpJournalBalInfo);
    }
}

