/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.util.CommonPrintIntegrationDataProvider;
import com.kingdee.eas.basedata.assistant.util.MultiDataSourceDataProviderProxy;
import com.kingdee.eas.basedata.assistant.util.PrintIntegrationManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BankBalanceAdjustCollection;
import com.kingdee.eas.fi.cas.BankBalanceAdjustFactory;
import com.kingdee.eas.fi.cas.BankBalanceAdjustInfo;
import com.kingdee.eas.fi.cas.BankBalanceCondition;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.client.AbstractBankBalanceAdjustEditUI;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustFilterParam;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.utils.common.tdprint.BankBalanceAdjustWebDataProvider;
import com.kingdee.eas.fi.cas.utils.kdtable.CASAbstractKDTableAdapter;
import com.kingdee.eas.fm.common.client.FMKDTableHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class BankBalanceAdjustEditUI
extends AbstractBankBalanceAdjustEditUI {
    private static final long serialVersionUID = -3932853559613750440L;
    private static final Logger logger = CoreUIObject.getLogger(BankBalanceAdjustEditUI.class);
    public static final String BANKBALANCEADJUST_FILENAME = "/FI/CAS/BANKBALANCEADJUST";
    private boolean shouldReloadPrintVar = true;
    private int sort_Bank = 0;
    private int sort_Entp = 0;
    private boolean isFristSort_Bank = true;
    private boolean isFristSort_Entp = true;
    private KDTSortManager sm_Bank = null;
    private KDTSortManager sm_Entp = null;

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.checkBoxViewDetails.setEnabled(true);
        this.txtjournalBalAmt.setHorizontalAlignment(4);
        this.txtbankGotAmt.setHorizontalAlignment(4);
        this.txtbankPayedAmt.setHorizontalAlignment(4);
        this.txtadjustJournalAmt.setHorizontalAlignment(4);
        this.txtstatmntBalAmt.setHorizontalAlignment(4);
        this.txtentprGotAmt.setHorizontalAlignment(4);
        this.txtentprPayedAmt.setHorizontalAlignment(4);
        this.txtadjustStatementAmt.setHorizontalAlignment(4);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        int precision = this.editData.getCurrency().getPrecision();
        this.setReportToUI(this.editData, precision);
    }

    private void setReportToUI(BankBalanceAdjustInfo rptInfo, int scale) {
        if (rptInfo == null) {
            return;
        }
        BigDecimal oJournalEndAmount = rptInfo.getJournalBalAmt();
        BigDecimal oStatmntEndAmount = rptInfo.getStatmntBalAmt();
        BigDecimal oBankGotAmount = rptInfo.getBankGotAmt();
        BigDecimal oBankPayedAmount = rptInfo.getBankPayedAmt();
        BigDecimal oEntprGotAmount = rptInfo.getEntprGotAmt();
        BigDecimal oEntprPayedAmount = rptInfo.getEntprPayedAmt();
        BigDecimal oAdjustedJournalAmount = rptInfo.getAdjustJournalAmt();
        BigDecimal oAdjustedStatmntAmount = rptInfo.getAdjustStatementAmt();
        oJournalEndAmount = oJournalEndAmount == null ? Constants.ZERO : oJournalEndAmount;
        oBankGotAmount = oBankGotAmount == null ? Constants.ZERO : oBankGotAmount;
        oBankPayedAmount = oBankPayedAmount == null ? Constants.ZERO : oBankPayedAmount;
        oAdjustedJournalAmount = oJournalEndAmount.add(oBankGotAmount).subtract(oBankPayedAmount);
        oStatmntEndAmount = oStatmntEndAmount == null ? Constants.ZERO : oStatmntEndAmount;
        oEntprGotAmount = oEntprGotAmount == null ? Constants.ZERO : oEntprGotAmount;
        oEntprPayedAmount = oEntprPayedAmount == null ? Constants.ZERO : oEntprPayedAmount;
        oAdjustedStatmntAmount = oStatmntEndAmount.add(oEntprGotAmount).subtract(oEntprPayedAmount);
        this.txtjournalBalAmt.setText(ClientUtils.formatDecimal(oJournalEndAmount, scale));
        this.txtbankPayedAmt.setText(ClientUtils.formatDecimal(oBankPayedAmount, scale));
        this.txtbankGotAmt.setText(ClientUtils.formatDecimal(oBankGotAmount, scale));
        this.txtstatmntBalAmt.setText(ClientUtils.formatDecimal(oStatmntEndAmount, scale));
        this.txtentprGotAmt.setText(ClientUtils.formatDecimal(oEntprGotAmount, scale));
        this.txtentprPayedAmt.setText(ClientUtils.formatDecimal(oEntprPayedAmount, scale));
        this.txtadjustJournalAmt.setText(ClientUtils.formatDecimal(oAdjustedJournalAmount, scale));
        this.txtadjustStatementAmt.setText(ClientUtils.formatDecimal(oAdjustedStatmntAmount, scale));
        if (rptInfo.getPeriod() == null) {
            this.contperiod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"320_BankBalanceAdjustEditUI"));
            this.prmtperiod.setValue((Object)rptInfo.getBizDate().toString());
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BankBalanceAdjustFactory.getRemoteInstance();
    }

    protected IObjectValue createNewDetailData(KDTable table) {
        return null;
    }

    @Override
    protected IObjectValue createNewData() {
        BankBalanceAdjustInfo objectValue = new BankBalanceAdjustInfo();
        return objectValue;
    }

    @Override
    protected void checkBoxViewDetails_actionPerformed(ActionEvent e) throws Exception {
        super.checkBoxViewDetails_actionPerformed(e);
        KDCheckBox viewDetails = (KDCheckBox)e.getSource();
        if (viewDetails.isSelected()) {
            this.splitPaneDetail.setDividerLocation(0.5);
            Set defaultValue = BankBalanceAdjustFactory.getRemoteInstance().getBalanceAdjustPageInitData(this.editData.getId().toString());
            Iterator it = defaultValue.iterator();
            BankBalanceAdjustKDTableAdapter adapter = null;
            while (it.hasNext()) {
                Map bankBalanceMap = (Map)it.next();
                JournalCollection bankUnreachedColl = (JournalCollection)bankBalanceMap.get("bankUnreachedColl");
                BankStatementCollection entprUnreachedColl = (BankStatementCollection)((Object)bankBalanceMap.get("entprUnreachedColl"));
                adapter = new BankBalanceAdjustKDTableAdapter(this.tblBankUnreachedDetails, this.editData.getCurrency().getPrecision());
                ((CASAbstractKDTableAdapter)adapter).fillTable((IObjectCollection)bankUnreachedColl);
                adapter = new BankBalanceAdjustKDTableAdapter(this.tblEntprUnreachedDetails, this.editData.getCurrency().getPrecision());
                ((CASAbstractKDTableAdapter)adapter).fillTable((IObjectCollection)entprUnreachedColl);
            }
            this.splitPaneDetail.setVisible(true);
        } else {
            this.splitPaneDetail.setVisible(false);
        }
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.editData.getId().toString());
        if (idList == null || idList.size() == 0) {
            return;
        }
        MultiDataSourceDataProviderProxy data = new MultiDataSourceDataProviderProxy();
        KDNoteHelper appHlp = new KDNoteHelper();
        BankBalanceAdjustWebDataProvider imdata = new BankBalanceAdjustWebDataProvider(idList);
        data.put("MainQuery", (BOSQueryDelegate)imdata);
        CommonPrintIntegrationDataProvider printQueryData = new CommonPrintIntegrationDataProvider(new PaymentBillInfo().getBOSType().toString(), PrintIntegrationManager.getPrintQueryPK());
        data.put("PrintQuery", (BOSQueryDelegate)printQueryData);
        PrintIntegrationManager.initPrint((KDNoteHelper)appHlp, (BOSObjectType)new BankBalanceAdjustInfo().getBOSType(), idList, (String)BANKBALANCEADJUST_FILENAME, (String)"", (boolean)true);
        appHlp.print(BANKBALANCEADJUST_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(this.editData.getId().toString());
        if (idList == null || idList.size() == 0) {
            return;
        }
        MultiDataSourceDataProviderProxy data = new MultiDataSourceDataProviderProxy();
        KDNoteHelper appHlp = new KDNoteHelper();
        BankBalanceAdjustWebDataProvider imdata = new BankBalanceAdjustWebDataProvider(idList);
        data.put("MainQuery", (BOSQueryDelegate)imdata);
        CommonPrintIntegrationDataProvider printQueryData = new CommonPrintIntegrationDataProvider(new PaymentBillInfo().getBOSType().toString(), PrintIntegrationManager.getPrintQueryPK());
        data.put("PrintQuery", (BOSQueryDelegate)printQueryData);
        PrintIntegrationManager.initPrint((KDNoteHelper)appHlp, (BOSObjectType)new BankBalanceAdjustInfo().getBOSType(), idList, (String)BANKBALANCEADJUST_FILENAME, (String)"", (boolean)true);
        appHlp.printPreview(BANKBALANCEADJUST_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        FMKDTableHelper.mergeTable((KDTable)this.kDTable4, (KDTable)this.tblEntprUnreachedDetails, (KDTable)this.tblBankUnreachedDetails, (int)0);
        this.kDTable4.getStyleAttributes().setHided(false);
        this.kDTable4.getHeadStyleAttributes().setHided(false);
        if (!this.checkBoxViewDetails.isSelected() || this.checkBoxViewDetails.isSelected() && this.tblBankUnreachedDetails.getRowCount() == 0 && this.tblEntprUnreachedDetails.getRowCount() == 0) {
            if (this.kDTable4.getRowCount() == 0) {
                this.kDTable4.addRow();
            }
            this.kDTable4.removeHeadRows();
            this.kDTable4.getStyleAttributes().setHided(true);
            this.kDTable4.getHeadStyleAttributes().setHided(true);
        }
        this.preparePrintPage(this.kDTable4);
        this.kDTable4.getPrintManager().print();
    }

    @Override
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        FMKDTableHelper.mergeTable((KDTable)this.kDTable4, (KDTable)this.tblEntprUnreachedDetails, (KDTable)this.tblBankUnreachedDetails, (int)0);
        this.kDTable4.getStyleAttributes().setHided(false);
        this.kDTable4.getHeadStyleAttributes().setHided(false);
        if (!this.checkBoxViewDetails.isSelected() || this.checkBoxViewDetails.isSelected() && this.tblBankUnreachedDetails.getRowCount() == 0 && this.tblEntprUnreachedDetails.getRowCount() == 0) {
            if (this.kDTable4.getRowCount() == 0) {
                this.kDTable4.addRow();
            }
            this.kDTable4.removeHeadRows();
            this.kDTable4.getStyleAttributes().setHided(true);
            this.kDTable4.getHeadStyleAttributes().setHided(true);
        }
        this.preparePrintPage(this.kDTable4);
        this.kDTable4.getPrintManager().printPreview();
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        String sBank = this.contbankAccount.getBoundLabelText() + " &[Bank]";
        String sCurrency = this.contcurrency.getBoundLabelText() + " &[Currency]";
        String sAccount = this.lbAccount.getBoundLabelText() + " &[BankAccount] ";
        String sPeriod = this.contperiod.getBoundLabelText() + " &[Period]";
        headerModel.addRow(sBank + "&|" + sCurrency + "&|" + sAccount);
        headerModel.addRow(sPeriod + "&| &|");
        String sEntprPane = ((TitledBorder)this.kDPanel1.getBorder()).getTitle();
        String sBankPane = ((TitledBorder)this.kDPanel2.getBorder()).getTitle();
        headerModel.addRow(sEntprPane + "&| &|" + sBankPane);
        String sJournalAmt = this.contjournalBalAmt.getBoundLabelText() + " &[JornalAmount]";
        String sBankGotAmt = this.contbankGotAmt.getBoundLabelText() + "  &[BankGot]";
        String sBankPayedAmt = this.contbankPayedAmt.getBoundLabelText() + "  &[BankPayed]";
        String sJournalAdjAmt = this.contadjustJournalAmt.getBoundLabelText() + "  &[AdjustedJournalAmount]";
        String sStmtAmt = this.contstatmntBalAmt.getBoundLabelText() + " &[StatmntAmount]";
        String sEntprGotAmt = this.contentprGotAmt.getBoundLabelText() + " &[EntprGot]";
        String sEntprPayedAmt = this.contentprPayedAmt.getBoundLabelText() + " &[EntprPayed]";
        String sStmtAdjAmt = this.contadjustStatementAmt.getBoundLabelText() + "   &[AdjustedStatmntAmount]";
        headerModel.addRow(sJournalAmt + "&| &|" + sStmtAmt);
        headerModel.addRow(sBankGotAmt + "&| &|" + sEntprGotAmt);
        headerModel.addRow(sBankPayedAmt + "&| &|" + sEntprPayedAmt);
        headerModel.addRow(sJournalAdjAmt + "&| &|" + sStmtAdjAmt);
        if (this.checkBoxViewDetails.isSelected()) {
            headerModel.addRow(this.containerEntpr.getTitle() + ":&| " + this.containerBank.getTitle() + ":");
        }
    }

    protected KDTable getTableForPrintSetting() {
        return this.kDTable4;
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        class MyExtVarProvider
        implements ExtVarProvider {
            Map varMap = null;

            MyExtVarProvider() {
                this.initVarMap();
            }

            private void initVarMap() {
                this.varMap = BankBalanceAdjustEditUI.this.preparePrintVariantMap();
            }

            public Variant requestVarData(String varName) {
                if (BankBalanceAdjustEditUI.this.shouldReloadPrintVar) {
                    this.initVarMap();
                }
                if (this.varMap == null) {
                    return null;
                }
                Object obj = this.varMap.get(varName);
                if (!(obj instanceof Variant)) {
                    Variant v = new Variant();
                    v.setObject(obj);
                    return v;
                }
                return (Variant)obj;
            }
        }
        return new MyExtVarProvider();
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        map.put("Bank", this.prmtbankAccount.getText());
        map.put("Currency", this.prmtcurrency.getText());
        map.put("BankAccount", this.prmtAccount.getText());
        map.put("Period", this.prmtperiod.getText());
        map.put("JornalAmount", this.txtjournalBalAmt.getText());
        map.put("BankGot", this.txtbankGotAmt.getText());
        map.put("BankPayed", this.txtbankPayedAmt.getText());
        map.put("AdjustedJournalAmount", this.txtadjustJournalAmt.getText());
        map.put("StatmntAmount", this.txtstatmntBalAmt.getText());
        map.put("EntprGot", this.txtentprGotAmt.getText());
        map.put("EntprPayed", this.txtentprPayedAmt.getText());
        map.put("AdjustedStatmntAmount", this.txtadjustStatementAmt.getText());
        map.put("CurrencyUser", ContextHelperFactory.getRemoteInstance().getCurrentUser().getName());
        return map;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = super.getSelectors();
        selectors.add(new SelectorItemInfo("bankAccount.account.*"));
        selectors.add(new SelectorItemInfo("bizDate"));
        return selectors;
    }

    public static void showDialogUI(IUIObject ui, BankBalanceAdjustFilterParam param) throws UIException {
        EntityViewInfo view;
        UIContext uiContext = new UIContext((Object)ui);
        if (param.isForInit()) {
            view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)param.getCompanys(), CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)param.getCurrencyId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)param.getPeriodId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)param.getBankAcctIds(), CompareType.INCLUDE));
            view.getSelector().add(new SelectorItemInfo("id"));
            try {
                BankBalanceAdjustEditUI.genBankBalance(param);
                BankBalanceAdjustCollection bankBalanceAdjustCollection = BankBalanceAdjustFactory.getRemoteInstance().getBankBalanceAdjustCollection(view);
                if (bankBalanceAdjustCollection != null && bankBalanceAdjustCollection.size() > 0) {
                    String fid = bankBalanceAdjustCollection.get(0).getId().toString();
                    uiContext.put((Object)"ID", (Object)fid);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        } else {
            BankBalanceAdjustEditUI.genBankBalance(param);
            view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)param.getCompanys(), CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)param.getCurrencyId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)param.getPeriodId(), CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)param.getBankAcctIds(), CompareType.INCLUDE));
            view.getSelector().add(new SelectorItemInfo("id"));
            try {
                BankBalanceAdjustCollection bankBalanceAdjustCollection = BankBalanceAdjustFactory.getRemoteInstance().getBankBalanceAdjustCollection(view);
                if (bankBalanceAdjustCollection != null && bankBalanceAdjustCollection.size() > 0) {
                    String fid = bankBalanceAdjustCollection.get(0).getId().toString();
                    uiContext.put((Object)"ID", (Object)fid);
                }
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
        uiContext.put((Object)"filterParam", (Object)param);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIUtil.getEditUIMode((CoreUIObject)((CoreUIObject)ui))).create(BankBalanceAdjustEditUI.class.getName(), (Map)uiContext, null, "EDIT");
        uiWindow.show();
    }

    private static void genBankBalance(BankBalanceAdjustFilterParam param) {
        try {
            Set condition = BankBalanceAdjustEditUI.genConditions(param);
            BankBalanceAdjustFactory.getRemoteInstance().genBankBalance(condition);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    protected static Set genConditions(BankBalanceAdjustFilterParam param) throws EASBizException, BOSException {
        AccountBankCollection bankAccts;
        FilterInfo filter;
        EntityViewInfo view;
        HashSet<BankBalanceCondition> conSet = new HashSet<BankBalanceCondition>();
        if (param.getBankAcctIds() == null || param.getBankAcctIds().size() <= 0) {
            Set idsSet = param.getCompanys();
            view = new EntityViewInfo();
            filter = new FilterInfo();
            view.setFilter(filter);
            if (!param.isDestroyed()) {
                filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
            }
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)idsSet, CompareType.INCLUDE));
            bankAccts = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
            param.setBankAccts(bankAccts.toArray());
        } else {
            Set bankAccountId = param.getBankAcctIds();
            view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("currency.*"));
            view.getSelector().add(new SelectorItemInfo("company.*"));
            view.getSelector().add(new SelectorItemInfo("shareAcct.shareBalanceOfAcctCompany.id"));
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)bankAccountId, CompareType.INCLUDE));
            view.setFilter(filter);
            bankAccts = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
            param.setBankAccts(bankAccts.toArray());
        }
        if (param.getBankAccts().length > 0) {
            Object[] bankAccts2 = param.getBankAccts();
            for (int index = 0; index < bankAccts2.length; ++index) {
                AccountBankInfo info = (AccountBankInfo)bankAccts2[index];
                if (EmptyUtil.isEmpty((CoreBaseInfo)info.getCurrency())) {
                    info = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(info.getId()));
                }
                if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getCurrency())) {
                    BankBalanceCondition condition = new BankBalanceCondition();
                    condition.setIsForInit(param.isForInit());
                    condition.setCompanyInfo(info.getCompany());
                    condition.setBankId(info.getId().toString());
                    condition.setPeriodId(param.getPeriodId());
                    condition.setCurrencyId(info.getCurrency().getId().toString());
                    conSet.add(condition);
                    continue;
                }
                Set curSet = BankBalanceAdjustEditUI.getAccountCurrency(info.getId().toString());
                Iterator it = curSet.iterator();
                while (it.hasNext()) {
                    BankBalanceCondition condition = new BankBalanceCondition();
                    condition.setIsForInit(param.isForInit());
                    condition.setCompanyInfo(info.getCompany());
                    condition.setBankId(info.getId().toString());
                    condition.setPeriodId(param.getPeriodId());
                    condition.setCurrencyId((String)it.next());
                    conSet.add(condition);
                }
            }
        }
        return conSet;
    }

    private static Set getAccountCurrency(String bankAcctId) {
        HashSet<String> idSet = new HashSet<String>();
        try {
            String sSQL = "Select FCurrencyId From T_Cas_Journal Where FAccountBankId = '" + bankAcctId + "' union Select FCurrencyId From T_Cas_BankStatement Where FAccountBankId = '" + bankAcctId + "'";
            ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sSQL);
            IRowSet rs = exec.executeSQL();
            while (rs.next()) {
                idSet.add(rs.getString("FCurrencyId"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return idSet;
    }

    @Override
    protected void tblBankUnreachedDetails1_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            this.OrderByForTable(this.tblBankUnreachedDetails, e);
            return;
        }
    }

    @Override
    protected void tblEntprUnreachedDetails1_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            this.OrderByForTable(this.tblEntprUnreachedDetails, e);
            return;
        }
    }

    protected boolean isCanOrderTable() {
        return true;
    }

    protected Set getOrderColumns(KDTable table) {
        HashSet<String> colSet = new HashSet<String>();
        if (table == null) {
            return colSet;
        }
        if (table.equals(this.tblEntprUnreachedDetails)) {
            colSet.add("createDate");
            colSet.add("settleNumber");
        }
        if (table.equals(this.tblBankUnreachedDetails)) {
            colSet.add("createDate");
            colSet.add("voucherNumber");
            colSet.add("settlementNumber");
        }
        return colSet;
    }

    private void OrderByForTable(KDTable table, KDTMouseEvent e) throws Exception {
        if (!this.isCanOrderTable()) {
            return;
        }
        if (e.getType() == 0) {
            String columnName = table.getColumn(e.getColIndex()).getKey();
            table.getColumn(e.getColIndex()).setSortable(true);
            Set colSet = this.getOrderColumns(table);
            if (!colSet.contains(columnName)) {
                return;
            }
            if (table != null && table == this.tblBankUnreachedDetails) {
                if (this.isFristSort_Bank) {
                    this.sm_Bank = new KDTSortManager(table);
                    this.isFristSort_Bank = false;
                }
                this.sort_Bank = this.sort_Bank == 0 ? 1 : 0;
                this.sm_Bank.setSortAuto(true);
                this.sm_Bank.sort(e.getColIndex(), this.sort_Bank);
                table.repaint();
                this.sm_Bank.setSortAuto(false);
            }
            if (table != null && table == this.tblEntprUnreachedDetails) {
                if (this.isFristSort_Entp) {
                    this.sm_Entp = new KDTSortManager(table);
                    this.isFristSort_Entp = false;
                }
                this.sort_Entp = this.sort_Entp == 0 ? 1 : 0;
                this.sm_Entp.setSortAuto(true);
                this.sm_Entp.sort(e.getColIndex(), this.sort_Entp);
                table.repaint();
                this.sm_Entp.setSortAuto(false);
            }
        }
    }

    class BankBalanceAdjustKDTableAdapter
    extends CASAbstractKDTableAdapter {
        public BankBalanceAdjustKDTableAdapter(KDTable table) {
            super(table);
        }

        public BankBalanceAdjustKDTableAdapter(KDTable table, int precision) {
            super(table, precision);
        }

        @Override
        public void fillTable(IObjectCollection collection) {
            KDTable table = this.getTable();
            table.removeRows();
            if (collection != null && collection.size() > 0) {
                table.setUserObject((Object)collection);
                int n = collection.size();
                for (int i = 0; i < n; ++i) {
                    IObjectValue obj = collection.getObject(i);
                    IRow row = table.addRow(i);
                    this.setLineFields(table, row, obj);
                }
            }
            table.setEnabled(false);
        }
    }
}

