/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.impl.BOSQueryDelegate;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.util.CommonPrintIntegrationDataProvider;
import com.kingdee.eas.basedata.assistant.util.MultiDataSourceDataProviderProxy;
import com.kingdee.eas.basedata.assistant.util.PrintIntegrationManager;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.BankBalanceAdjustFactory;
import com.kingdee.eas.fi.cas.BankBalanceAdjustInfo;
import com.kingdee.eas.fi.cas.BankBalanceAdjustmentUIFacadeFactory;
import com.kingdee.eas.fi.cas.BankBalanceCondition;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.PaymentBillInfo;
import com.kingdee.eas.fi.cas.client.AbstractBankBalanceAdjustForDateListUI;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjFilterParam;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustEditUI;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustFilterParam;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustListUI;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustQueryProcessor;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustmentBFilterUI;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustmentCFilterUI;
import com.kingdee.eas.fi.cas.client.export.CASExportExcelHelper;
import com.kingdee.eas.fi.cas.utils.common.tdprint.BankBalanceAdjustWebDataProvider;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BankBalanceAdjustForDateListUI
extends AbstractBankBalanceAdjustForDateListUI {
    private static final Logger logger = CoreUIObject.getLogger(BankBalanceAdjustListUI.class);
    private Map paramMap = new HashMap();
    private BankBalanceAdjustmentCFilterUI filterUIA = null;
    private BankBalanceAdjustmentBFilterUI filterUIB = null;
    private Boolean isHideTransDetail = true;
    private BankBalanceAdjustFilterParam bankBalanceAdjustFilterParam = null;
    public static final String BANKBALANCEADJUST_FILENAME = "/FI/CAS/BANKBALANCEADJUST";

    public void onLoad() throws Exception {
        this.prepare();
        super.onLoad();
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.tblMain.getColumn("journalBalAmt").getStyleAttributes().setBackground(new Color(209, 205, 205));
        this.tblMain.getColumn("statmntBalAmt").getStyleAttributes().setBackground(new Color(209, 205, 205));
        this.tblMain.getColumn("adjustStatementAmt").getStyleAttributes().setBackground(new Color(209, 205, 205));
        this.tblMain.getColumn("adjustJournalAmt").getStyleAttributes().setBackground(new Color(209, 205, 205));
        this.tblMain.getColumn("transDetailAmt").getStyleAttributes().setHided(this.isHideTransDetail.booleanValue());
        this.tblMain.getColumn("journalDifferenceAmt").getStyleAttributes().setHided(this.isHideTransDetail.booleanValue());
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        FMFilterBaseUI multiOrgSupport = null;
        try {
            multiOrgSupport = this.getFilterUI();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            e.printStackTrace();
        }
        return multiOrgSupport;
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUIA == null) {
            this.filterUIA = new BankBalanceAdjustmentCFilterUI(this.paramMap, true);
        }
        return this.filterUIA;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new BankBalanceAdjustQueryProcessor((IUIObject)this);
    }

    @Override
    protected String getEditUIName() {
        return BankBalanceAdjustEditUI.class.getName();
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.checkSelected();
        HashSet<String> idSet = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        int success = 0;
        int error = 0;
        int[] tableSelectRows = this.getTableSelectRows(this.tblMain);
        for (int j = 0; j < tableSelectRows.length; ++j) {
            ICell cell = this.tblMain.getRow(tableSelectRows[j]).getCell("auditTime");
            if (cell.getValue() == null) {
                idSet.add(this.tblMain.getRow(tableSelectRows[j]).getCell("id").getValue().toString());
                ++success;
                continue;
            }
            if (sb.length() == 0) {
                sb.append(this.tblMain.getRow(tableSelectRows[j]).getCell("bankAccount.bankNumber").getValue().toString());
            } else {
                sb.append(", " + this.tblMain.getRow(tableSelectRows[j]).getCell("bankAccount.bankNumber").getValue().toString());
            }
            ++error;
        }
        if (idSet.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"321_BankBalanceAdjustForDateListUI"));
            SysUtil.abort();
        }
        if ((i = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"322_BankBalanceAdjustForDateListUI"))) != 0) {
            return;
        }
        try {
            String[] ids = new String[idSet.size()];
            Object[] array = idSet.toArray();
            for (int j = 0; j < array.length; ++j) {
                ids[j] = array[j].toString();
            }
            if (ids == null || ids.length == 0) {
                return;
            }
            BankBalanceAdjustFactory.getRemoteInstance().audit(ids);
            this.refreshList();
            sb2.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"231_PaymentBillControllerBean") + success + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"323_BankBalanceAdjustForDateListUI") + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"324_BankBalanceAdjustForDateListUI") + error + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"325_BankBalanceAdjustForDateListUI"));
            if (sb.length() > 0) {
                sb2.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"326_BankBalanceAdjustForDateListUI"));
                sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"327_BankBalanceAdjustForDateListUI"));
                sb2.append(sb);
            }
            MsgBox.showInfo((String)sb2.toString());
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            throw e1;
        }
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        HashSet<String> idSet = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        StringBuffer sb2 = new StringBuffer();
        int[] tableSelectRows = this.getTableSelectRows(this.tblMain);
        int success = 0;
        int error = 0;
        for (int j = 0; j < tableSelectRows.length; ++j) {
            ICell cell = this.tblMain.getRow(tableSelectRows[j]).getCell("auditTime");
            if (cell.getValue() != null) {
                idSet.add(this.tblMain.getRow(tableSelectRows[j]).getCell("id").getValue().toString());
                ++success;
                continue;
            }
            if (sb.length() == 0) {
                sb.append(this.tblMain.getRow(tableSelectRows[j]).getCell("bankAccount.bankNumber").getValue().toString());
            } else {
                sb.append(", " + this.tblMain.getRow(tableSelectRows[j]).getCell("bankAccount.bankNumber").getValue().toString());
            }
            ++error;
        }
        if (idSet.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"328_BankBalanceAdjustForDateListUI"));
            SysUtil.abort();
        }
        try {
            String[] ids = new String[idSet.size()];
            Object[] array = idSet.toArray();
            for (int j = 0; j < array.length; ++j) {
                ids[j] = array[j].toString();
            }
            if (ids == null || ids.length == 0) {
                return;
            }
            BankBalanceAdjustFactory.getRemoteInstance().antiAudit(ids);
            this.refreshList();
            sb2.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"231_PaymentBillControllerBean") + success + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"323_BankBalanceAdjustForDateListUI") + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"324_BankBalanceAdjustForDateListUI") + error + EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"325_BankBalanceAdjustForDateListUI"));
            if (sb.length() > 0) {
                sb2.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"326_BankBalanceAdjustForDateListUI"));
                sb.append(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"329_BankBalanceAdjustForDateListUI"));
                sb2.append(sb);
            }
            MsgBox.showInfo((String)sb2.toString());
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            throw e1;
        }
    }

    @Override
    public void actionExportDetail_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.getSelectedIdValues();
        CASExportExcelHelper helper = new CASExportExcelHelper((CoreUI)this, this.tblMain);
        helper.createExportConfigUI();
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            while (rowSet.next()) {
                rowSet.updateString("bankAccount.bankAccountNumber", rowSet.getString("bankAccount.bankAccountNumber") + " ");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                rowSet.beforeFirst();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionView.setVisible(true);
        this.actionAttachment.setVisible(false);
        this.actionAuditResult.setVisible(false);
        this.actionAudit.setEnabled(true);
        this.actionAntiAudit.setEnabled(true);
        this.actionExport.setEnabled(true);
        this.actionExportDetail.setEnabled(true);
        this.actionPrint.setEnabled(false);
        this.actionPrint.setVisible(false);
        this.actionTDPrintPreview.setEnabled(true);
        this.actionAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_audit"));
        this.actionAntiAudit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_unaudit"));
        this.actionPrint.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_print"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionTDPrintPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_credenceprint"));
        this.actionExportDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_output"));
        this.actionExport.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_output"));
    }

    private void prepare() {
        if (this.getUIContext().get("filterParam") instanceof BankBalanceAdjFilterParam) {
            BankBalanceAdjustFilterParam param = (BankBalanceAdjustFilterParam)this.getUIContext().get("filterParam");
            String companyId = (String)param.getCompanys().toArray()[0];
            this.paramMap.put("paramCompanyID", companyId);
        }
        this.paramMap.put("CS018", new Integer(-1));
        try {
            this.paramMap = BankBalanceAdjustmentUIFacadeFactory.getRemoteInstance().fetchData(this.paramMap);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    public void executeQuery(FilterParam param) throws BOSException {
        this.bankBalanceAdjustFilterParam = (BankBalanceAdjustFilterParam)param;
        this.genBankBalance((BankBalanceAdjustFilterParam)param);
        super.executeQuery(param);
    }

    protected void execQuery() {
        if (this.mainQuery != null) {
            FilterItemCollection filterItems = this.mainQuery.getFilter().getFilterItems();
            for (FilterItemInfo auditTimeInfo : filterItems) {
                if (!auditTimeInfo.getPropertyName().equals("auditTime") || auditTimeInfo.getCompareType() != CompareType.EQUALS) continue;
                Timestamp time = (Timestamp)auditTimeInfo.getCompareValue();
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(new Date(time.getTime()));
                calendar.add(5, 1);
                Date date = calendar.getTime();
                Timestamp time2 = new Timestamp(date.getTime());
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("auditTime", (Object)time, CompareType.GREATER_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("auditTime", (Object)time2, CompareType.LESS));
                filter.setMaskString("#0 AND #1");
                BankBalanceAdjustForDateListUI.replaceItem2FilterInfo(this.mainQuery.getFilter(), auditTimeInfo, filter);
                break;
            }
        }
        super.execQuery();
    }

    private void genBankBalance(BankBalanceAdjustFilterParam param) {
        try {
            Set condition = this.genConditions(param);
            this.isHideTransDetail = !param.getIncludeTransDetail();
            BankBalanceAdjustFactory.getRemoteInstance().genBankBalance(condition);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    protected Set genConditions(BankBalanceAdjustFilterParam param) throws EASBizException, BOSException {
        AccountBankCollection bankAccts;
        FilterInfo filter;
        EntityViewInfo view;
        HashSet<BankBalanceCondition> conSet = new HashSet<BankBalanceCondition>();
        int differenceDay = 0;
        Date fromDate = new Date();
        if (param.getBankAcctIds() == null || param.getBankAcctIds().size() <= 0) {
            Set idsSet = param.getCompanys();
            view = new EntityViewInfo();
            filter = new FilterInfo();
            view.setFilter(filter);
            if (!param.isDestroyed()) {
                filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
            }
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)idsSet, CompareType.INCLUDE));
            bankAccts = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
            param.setBankAccts(bankAccts.toArray());
        }
        if (param.getBeginDate() != null && param.getEndDate() != null) {
            differenceDay = BankBalanceAdjustForDateListUI.differentDays(param.getBeginDate(), param.getEndDate());
            fromDate = param.getBeginDate();
        }
        if ((param.getBankAccts() == null || param.getBankAccts().length == 0) && param.getBankAcctIds() != null) {
            Set bankAccountId = param.getBankAcctIds();
            view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("id"));
            view.getSelector().add(new SelectorItemInfo("currency.*"));
            view.getSelector().add(new SelectorItemInfo("company.*"));
            view.getSelector().add(new SelectorItemInfo("shareAcct.shareBalanceOfAcctCompany.id"));
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)bankAccountId, CompareType.INCLUDE));
            view.setFilter(filter);
            bankAccts = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
            param.setBankAccts(bankAccts.toArray());
        }
        if (param.getBankAccts().length > 0) {
            Object[] bankAccts2 = param.getBankAccts();
            for (int index = 0; index < bankAccts2.length; ++index) {
                AccountBankInfo info = (AccountBankInfo)bankAccts2[index];
                for (int i = 0; i <= differenceDay; ++i) {
                    BankBalanceCondition condition;
                    if (!EmptyUtil.isEmpty((CoreBaseInfo)info.getCurrency())) {
                        BankBalanceCondition condition2 = new BankBalanceCondition();
                        condition2.setIsForInit(false);
                        if (info.getShareType().getValue() == 1) {
                            info = CashHelper.getShareBalanceOfAcct(null, info, null);
                            condition2.setCompanyInfo(info.getShareAcct().getShareBalanceOfAcctCompany());
                        } else {
                            condition2.setCompanyInfo(info.getCompany());
                        }
                        condition2.setBankId(info.getId().toString());
                        condition2.setEndDate(this.afterDays(param.getBeginDate(), i));
                        condition2.setFromDate(this.afterDays(param.getBeginDate(), i));
                        condition2.setCurrencyId(info.getCurrency().getId().toString());
                        condition2.setIncludeTranDetail(param.getIncludeTransDetail());
                        conSet.add(condition2);
                        continue;
                    }
                    Set curSet = this.getAccountCurrency(info.getId().toString());
                    Iterator it = curSet.iterator();
                    while (it.hasNext()) {
                        condition = new BankBalanceCondition();
                        condition.setIsForInit(false);
                        condition.setCompanyInfo(info.getCompany());
                        condition.setBankId(info.getId().toString());
                        condition.setEndDate(this.afterDays(param.getBeginDate(), i));
                        condition.setFromDate(this.afterDays(param.getBeginDate(), i));
                        condition.setCurrencyId((String)it.next());
                        condition.setIncludeTranDetail(param.getIncludeTransDetail());
                        conSet.add(condition);
                    }
                    if (curSet != null && curSet.size() != 0) continue;
                    condition = new BankBalanceCondition();
                    condition.setIsForInit(false);
                    condition.setCompanyInfo(info.getCompany());
                    condition.setBankId(info.getId().toString());
                    condition.setEndDate(this.afterDays(param.getBeginDate(), i));
                    condition.setFromDate(this.afterDays(param.getBeginDate(), i));
                    CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
                    condition.setCurrencyId(company.getBaseCurrency().getId().toString());
                    condition.setIncludeTranDetail(param.getIncludeTransDetail());
                    conSet.add(condition);
                }
            }
        }
        return conSet;
    }

    private Set getAccountCurrency(String bankAcctId) {
        HashSet<String> idSet = new HashSet<String>();
        try {
            String sSQL = "Select FCurrencyId From T_Cas_Journal Where FAccountBankId = '" + bankAcctId + "' union Select FCurrencyId From T_Cas_BankStatement Where FAccountBankId = '" + bankAcctId + "'";
            ISQLExecutor exec = SQLExecutorFactory.getRemoteInstance((String)sSQL);
            IRowSet rs = exec.executeSQL();
            while (rs.next()) {
                idSet.add(rs.getString("FCurrencyId"));
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return idSet;
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        MultiDataSourceDataProviderProxy data = new MultiDataSourceDataProviderProxy();
        KDNoteHelper appHlp = new KDNoteHelper();
        BankBalanceAdjustWebDataProvider imdata = new BankBalanceAdjustWebDataProvider(idList);
        data.put("MainQuery", (BOSQueryDelegate)imdata);
        CommonPrintIntegrationDataProvider printQueryData = new CommonPrintIntegrationDataProvider(new PaymentBillInfo().getBOSType().toString(), PrintIntegrationManager.getPrintQueryPK());
        data.put("PrintQuery", (BOSQueryDelegate)printQueryData);
        PrintIntegrationManager.initPrint((KDNoteHelper)appHlp, (BOSObjectType)new BankBalanceAdjustInfo().getBOSType(), (List)idList, (String)BANKBALANCEADJUST_FILENAME, (String)"", (boolean)true);
        appHlp.print(BANKBALANCEADJUST_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList idList = super.getSelectedIdValues();
        if (idList == null || idList.size() == 0) {
            return;
        }
        MultiDataSourceDataProviderProxy data = new MultiDataSourceDataProviderProxy();
        KDNoteHelper appHlp = new KDNoteHelper();
        BankBalanceAdjustWebDataProvider imdata = new BankBalanceAdjustWebDataProvider(idList);
        data.put("MainQuery", (BOSQueryDelegate)imdata);
        CommonPrintIntegrationDataProvider printQueryData = new CommonPrintIntegrationDataProvider(new PaymentBillInfo().getBOSType().toString(), PrintIntegrationManager.getPrintQueryPK());
        data.put("PrintQuery", (BOSQueryDelegate)printQueryData);
        PrintIntegrationManager.initPrint((KDNoteHelper)appHlp, (BOSObjectType)new BankBalanceAdjustInfo().getBOSType(), (List)idList, (String)BANKBALANCEADJUST_FILENAME, (String)"", (boolean)true);
        appHlp.printPreview(BANKBALANCEADJUST_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    protected String getTDFileName() {
        return "/fi/cas/BankBalanceAdjust";
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return BankBalanceAdjustFactory.getRemoteInstance();
    }

    @Override
    protected IObjectValue createNewData() {
        BankBalanceAdjustInfo objectValue = new BankBalanceAdjustInfo();
        return objectValue;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"330_BankBalanceAdjustForDateListUI");
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.actionEdit_actionPerformed(e);
    }

    public void refreshList() throws Exception {
        super.refreshList();
        this.tblMain.getColumn("transDetailAmt").getStyleAttributes().setHided(this.isHideTransDetail.booleanValue());
        this.tblMain.getColumn("journalDifferenceAmt").getStyleAttributes().setHided(this.isHideTransDetail.booleanValue());
    }

    protected void refresh(ActionEvent e) throws Exception {
        if (this.bankBalanceAdjustFilterParam != null) {
            this.genBankBalance(this.bankBalanceAdjustFilterParam);
        }
        super.refresh(e);
        this.initDapButtons();
        this.initPCDapButtons();
    }

    private static FilterInfo replaceItem2FilterInfo(FilterInfo oriFilter, FilterItemInfo replaceItem, FilterInfo insertFilter) {
        int x;
        int ind = oriFilter.getFilterItems().indexOf((IObjectValue)replaceItem);
        String insertMask = insertFilter.getMaskString();
        int insertFilterSize = insertFilter.getFilterItems().size();
        for (int x2 = 0; x2 < insertFilterSize; ++x2) {
            insertMask = BankBalanceAdjustForDateListUI.reverseString(BankBalanceAdjustForDateListUI.reverseString(insertMask).replaceFirst("" + x2, "" + (x2 + ind)));
        }
        String oriMask = oriFilter.getMaskString();
        for (x = ind + 1; x < oriFilter.getFilterItems().size(); ++x) {
            oriMask = BankBalanceAdjustForDateListUI.reverseString(BankBalanceAdjustForDateListUI.reverseString(oriMask).replaceFirst("" + x, "" + (x + insertFilterSize - 1)));
        }
        oriMask = oriMask.replaceFirst("#" + ind, "(" + insertMask + ")");
        for (x = ind; x < ind + insertFilterSize; ++x) {
            oriFilter.getFilterItems().insertObject(x, (IObjectValue)insertFilter.getFilterItems().get(x - ind));
        }
        oriFilter.getFilterItems().remove(replaceItem);
        oriFilter.setMaskString(oriMask);
        return oriFilter;
    }

    private static String reverseString(String str) {
        if (str == null) {
            return str;
        }
        byte[] a = str.getBytes();
        int asize = a.length;
        byte[] b = new byte[asize];
        for (int i = 0; i < asize; ++i) {
            b[i] = a[asize - i - 1];
        }
        return new String(b);
    }

    private static int differentDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }

    private Date afterDays(Date date, int after) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, after);
        return calendar.getTime();
    }

    private Date fromDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, -1);
        calendar.set(5, 1);
        return calendar.getTime();
    }
}

