/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasContrastGLHelper;
import com.kingdee.eas.fi.cas.client.AbstractBankBalanceAdjustmentBFilterUI;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustFilterParam;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.ISharedOrgSupport;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.util.HashSet;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BankBalanceAdjustmentBFilterUI
extends AbstractBankBalanceAdjustmentBFilterUI
implements ISharedOrgSupport {
    private static Logger logger = Logger.getLogger((String)BankBalanceAdjustmentBFilterUI.class.getName());
    private BankBalanceAdjustFilterParam param = null;
    private CompanyOrgUnitInfo companyInfo = null;
    private AccountBankCollection acctBankColl = null;
    private String acctTableId = null;
    private boolean isSharedOrg = false;
    private Map paramMap = null;

    public BankBalanceAdjustmentBFilterUI() throws Exception {
        this(null, null);
    }

    public BankBalanceAdjustmentBFilterUI(Map paramMap) throws Exception {
        this(null, paramMap);
    }

    public BankBalanceAdjustmentBFilterUI(CompanyOrgUnitInfo companyInfo) throws Exception {
        this(companyInfo, null);
    }

    public BankBalanceAdjustmentBFilterUI(CompanyOrgUnitInfo companyInfo, Map paramMap) throws Exception {
        this.companyInfo = companyInfo != null ? companyInfo : ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (paramMap != null) {
            this.paramMap = paramMap;
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public String getUITitle() {
        return EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BalanceAdjustementUITitle") + " - " + EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"QueryUITitle");
    }

    protected void init() throws Exception {
        this.initMainOrgF7();
        this.companyInfo = this.getCompanyOrgUnitInfoByUserPermisson();
        this.prmtCompany.setValue((Object)this.companyInfo);
        if (this.companyInfo == null) {
            this.companyInfo = ClientUtils.getCurrLoginCompany();
        }
        ClientUtils.setBankListIncludeShared(this.prmtBankAccount, this.companyInfo.getId().toString(), false);
        String strCompanyId = this.companyInfo.getId().toString();
        this.acctBankColl = CashClientHelper.getSharedAcctAccountBankCollection(strCompanyId, this.chkDestroyed.isSelected());
        if (this.acctBankColl != null) {
            this.prmtBankAccount.setValue((Object)this.acctBankColl.get(0));
        }
        FMClientHelper.initComboCurrency((KDComboBox)this.comboCurrency, (boolean)true);
        PeriodHelper.initPeriodSpinner(this.companyInfo, this.spPeriodYear, this.spPeriodNum);
        ClientUtils.setSelectedItem(this.comboCurrency, this.companyInfo.getBaseCurrency().getId().toString());
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson() throws EASBizException, BOSException {
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        CompanyOrgUnitCollection coll = FMHelper.getUserOrgRangesWithRange(null, (String)"cas_bankbalanceagjtable_01view");
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo tmp;
            CompanyOrgUnitInfo info = coll.get(i);
            if (!info.isIsBizUnit() || info.isIsOUSealUp() || info.isIsAssistantOrg()) continue;
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info);
            if (null != startPeriod) {
                companyColl.add(info);
            }
            if (!(tmp = ContextHelperFactory.getRemoteInstance().getCurrentCompany()).getId().toString().equals(info.getId().toString())) continue;
            return info;
        }
        if (companyColl.size() > 0) {
            return companyColl.get(0);
        }
        return null;
    }

    public Object getParam() {
        AccountBankInfo[] bankAccts;
        BankBalanceAdjustFilterParam param = new BankBalanceAdjustFilterParam();
        Object[] companys = (Object[])this.prmtCompany.getData();
        if (companys != null && companys.length > 0) {
            HashSet<String> idSet = new HashSet<String>();
            for (int index = 0; index < companys.length; ++index) {
                CompanyOrgUnitInfo org = (CompanyOrgUnitInfo)companys[index];
                idSet.add(org.getId().toString());
            }
            param.setCompanys(idSet);
        }
        if ((bankAccts = (AccountBankInfo[])this.prmtBankAccount.getValue()) != null && bankAccts.length > 0) {
            HashSet<String> idSet = new HashSet<String>();
            for (int index = 0; index < bankAccts.length; ++index) {
                idSet.add(bankAccts[index].getId().toString());
            }
            param.setBankAcctIds(idSet);
        }
        Integer periodYear = (Integer)this.spPeriodYear.getValue();
        Integer periodNum = (Integer)this.spPeriodNum.getValue();
        param.setPeriodYear(periodYear);
        param.setPeriodNum(periodNum);
        try {
            PeriodInfo periodInfo = PeriodUtils.getPeriodInfo(null, (int)periodYear, (int)periodNum, (CompanyOrgUnitInfo)this.companyInfo);
            param.setPeriodId(periodInfo.getId().toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        param.setDestroyed(this.chkDestroyed.isSelected());
        if (this.rdAudit.isSelected()) {
            param.setAudit(param.Audit);
        } else if (this.rdNoAudit.isSelected()) {
            param.setAudit(param.NoAudit);
        } else {
            param.setAudit(param.All);
        }
        return param;
    }

    public void clear() {
        super.clear();
        try {
            if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
                CompanyOrgUnitInfo orgRang = this.getCompanyOrgUnitInfoByUserPermisson();
                if (!EmptyUtil.isEmpty((CoreBaseInfo)orgRang)) {
                    this.companyInfo = orgRang;
                    this.prmtCompany.setValue((Object)this.companyInfo);
                }
            } else {
                this.prmtCompany.setValue((Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
            }
            PeriodHelper.initPeriodSpinner(this.companyInfo, this.spPeriodYear, this.spPeriodNum);
            this.chkDestroyed.setSelected(false);
            ClientUtils.setSelectedItem(this.comboCurrency, this.companyInfo.getBaseCurrency().getId().toString());
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void setParam(Object obj) {
        this.param = (BankBalanceAdjustFilterParam)obj;
        this.setParamToUI();
    }

    public void loadData(EntityViewInfo entityViewInfo) {
        this.setParamToUI();
    }

    private void setParamToUI() {
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.param.getBankAcctIds(), CompareType.INCLUDE));
            AccountBankCollection bank = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
            this.prmtBankAccount.setData((Object)bank.toArray());
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            evi.setFilter(fi);
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)this.param.getCompanys(), CompareType.INCLUDE));
            CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(evi);
            this.prmtCompany.setData((Object)companys.toArray());
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.spPeriodYear.setValue((Object)this.param.getPeriodYear());
        this.spPeriodNum.setValue((Object)this.param.getPeriodNum());
        this.chkDestroyed.setSelected(this.param.isDestroyed());
        if (this.param.getAudit() == this.param.Audit) {
            this.rdAudit.setSelected(true);
        } else if (this.param.getAudit() == this.param.NoAudit) {
            this.rdNoAudit.setSelected(true);
        } else {
            this.rbAll.setSelected(true);
        }
    }

    @Override
    protected void spPeriodYear_stateChanged(ChangeEvent e) throws Exception {
        PeriodHelper.setPeriodNum(this.companyInfo, this.spPeriodNum, (Integer)this.spPeriodYear.getValue());
    }

    @Override
    protected void chkDestroyed_itemStateChanged(ItemEvent e) throws Exception {
        ClientUtils.setBankListIncludeShared(this.prmtBankAccount, this.companyInfo.getId().toString(), this.chkDestroyed.isSelected());
        String strCompanyId = this.companyInfo.getId().toString();
        this.acctBankColl = CashClientHelper.getSharedAcctAccountBankCollection(strCompanyId, this.chkDestroyed.isSelected());
        if (this.acctBankColl != null) {
            this.prmtBankAccount.setValue((Object)this.acctBankColl.get(0));
        }
    }

    public boolean verify() {
        if (this.prmtBankAccount.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"NoBanks_Alert"));
            return false;
        }
        if (this.comboCurrency.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"NoCurrencys_Alert"));
            return false;
        }
        int beginYear = AccessHelper.getSpiValue((KDSpinner)this.spPeriodYear);
        int beginMonth = AccessHelper.getSpiValue((KDSpinner)this.spPeriodNum);
        int endYear = AccessHelper.getSpiValue((KDSpinner)this.spPeriodYear);
        int endMonth = AccessHelper.getSpiValue((KDSpinner)this.spPeriodNum);
        this.acctTableId = FMClientHelper.getActualAcctTable((String)this.companyInfo.getId().toString(), (int)beginYear, (int)beginMonth, (int)endYear, (int)endMonth);
        return true;
    }

    @Override
    protected void prmtBankAccount_willCommit(CommitEvent e) throws Exception {
        super.prmtBankAccount_willCommit(e);
        this.bankAccountQueryInfo();
    }

    @Override
    protected void prmtBankAccount_dataChanged(DataChangeEvent e) throws Exception {
        super.prmtBankAccount_dataChanged(e);
        AccountBankInfo bankInfo = (AccountBankInfo)this.prmtBankAccount.getValue();
        if (bankInfo == null) {
            return;
        }
        CurrencyInfo currency = null;
        if (bankInfo.isIsByCurrency()) {
            currency = bankInfo.getCurrency();
            this.comboCurrency.setEnabled(false);
        } else {
            currency = this.companyInfo.getBaseCurrency();
            this.comboCurrency.setEnabled(true);
        }
        UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
        this.bankAccountQueryInfo();
    }

    @Override
    protected void prmtBankAccount_willShow(SelectorEvent e) throws Exception {
        super.prmtBankAccount_willShow(e);
        this.bankAccountQueryInfo();
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtCompany.getValue() != null && e.getNewValue() == e.getOldValue()) {
            return;
        }
        if (this.prmtCompany.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"432_BankBalanceAdjustmentBFilterUI"));
            this.prmtCompany.setData(e.getOldValue());
            SysUtil.abort();
        }
        this.companyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getData();
        PeriodHelper.initPeriodSpinner(this.companyInfo, this.spPeriodYear, this.spPeriodNum);
        String strCompanyId = this.companyInfo.getId().toString();
        this.acctBankColl = CashClientHelper.getSharedAcctAccountBankCollection(strCompanyId, this.chkDestroyed.isSelected());
        CasContrastGLHelper.initComboCurrency(this.comboCurrency, true, this.companyInfo);
        if (this.acctBankColl != null) {
            this.prmtBankAccount.setValue((Object)this.acctBankColl.get(0));
        }
    }

    protected Class getParamClass() {
        return BankBalanceAdjustFilterParam.class;
    }

    public void bankAccountQueryInfo() throws Exception {
        ClientUtils.setBankListIncludeShared(this.prmtBankAccount, this.companyInfo.getId().toString(), this.chkDestroyed.isSelected());
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public boolean isSupportMultiOrgs() {
        this.prmtCompany.setEnabled(this.isSharedOrg());
        return false;
    }

    public String getPermissionItem() {
        return "cas_bankbalanceagjtable_01view";
    }

    @Override
    public void setIsSharedOrg(boolean value) {
        this.isSharedOrg = value;
    }

    @Override
    public boolean isSharedOrg() {
        return this.isSharedOrg;
    }
}

