/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BankBalanceAdjustmentFactory;
import com.kingdee.eas.fi.cas.BankBalanceCondition;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.BankStmtBookReportInfo;
import com.kingdee.eas.fi.cas.IBankBalanceAdjustment;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.client.AbstractBankBalanceAdjustmentBUI;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjFilterParam;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustmentBFilterUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BankBalanceAdjustmentBUI
extends AbstractBankBalanceAdjustmentBUI {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = CoreUIObject.getLogger(BankBalanceAdjustmentBUI.class);
    public static final String INIT = "init";
    private IBankBalanceAdjustment iAdjustment = null;
    private CompanyOrgUnitInfo companyInfo = null;
    private AccountBankInfo bankInfo = null;
    private CurrencyInfo currencyInfo = null;
    private PeriodInfo periodInfo = null;
    private ObjectUuidPK companyPK = null;
    private ObjectUuidPK bankPK = null;
    private ObjectUuidPK currencyPK = null;
    private ObjectUuidPK periodPK = null;
    private boolean _bInitial = true;
    private CommonQueryDialog _dialog = null;
    private BankBalanceAdjustmentBFilterUI _filterUI = null;
    private BankBalanceCondition condition = null;
    private boolean isFirstLoad = true;
    private boolean isSharedOrg = false;
    public static final String col_Aamount = "AAmount";
    public static final String col_Bamount = "BAmount";
    public static final String col_Adesc = "Adescription";
    public static final String col_Bdesc = "Bdescription";
    public static final String col_BVoucherType = "BVoucherType";
    public static final String col_BVoucherNumber = "BVoucherNumber";
    public static final String col_AcreateDate = "AcreateDate";
    public static final String col_BcreateDate = "BcreateDate";
    public static final String col_AsettleType = "AsettleType";
    public static final String col_BsettleType = "BsettleType";
    public static final String col_AsettleNumber = "AsettleNumber";
    public static final String col_BsettleNumber = "BsettleNumber";
    public static final String col_Company = "company";
    private boolean shouldReloadPrintVar = true;
    public static final String CASH_FILENAME = "/FI/CAS/BANKBALANCEADJUST";

    public BankBalanceAdjustmentBUI() throws Exception {
        this.windowTitle = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BalanceAdjustementUITitle");
    }

    public void onShow() throws Exception {
        super.onShow();
    }

    public boolean destroyWindow() {
        if (this.isSharedOrg) {
            CashClientHelper.releaseSharedOrgLicense();
        }
        return super.destroyWindow();
    }

    public void onLoad() throws Exception {
        this.isSharedOrg = CashClientHelper.hasSharedOrgUIParam((CoreUIObject)this);
        if (this.isSharedOrg) {
            CashClientHelper.processSharedOrgLicense(this);
        }
        this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.tblMain.checkParsed();
        if ("FINDVIEW".equalsIgnoreCase(this.getOprtState()) && this.getUIContext().get("filterParam") != null && this.getUIContext().get("filterParam") instanceof BankBalanceAdjFilterParam) {
            BankBalanceAdjFilterParam param = (BankBalanceAdjFilterParam)this.getUIContext().get("filterParam");
            String companyId = param.getCompanyId();
            this.companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        }
        super.onLoad();
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
        this.setDisplayFormat();
        KDTableHelper.setEnterKeyJumpOrientation((KDTable)this.tblMain, (int)2);
        if (this.isInitReport()) {
            this.btnQuery.setVisible(false);
            this.btnQuery.setEnabled(false);
            this.btnRefresh.setVisible(false);
            this.btnRefresh.setEnabled(false);
            this.lblPeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BalanceAdjustement_Date"));
            this.showInitReport();
        } else {
            this.actionQuery_actionPerformed(null);
        }
        if (this.isSharedOrg) {
            CashClientHelper.processSharedOrgFilterUI(this._filterUI);
        }
    }

    private boolean isInitReport() {
        String uiParam;
        return this.getUIContext().get("UIClassParam") != null && (uiParam = (String)this.getUIContext().get("UIClassParam")).equals(INIT);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPreview);
        this.actionPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
        this.actionPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionQuery.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_filter"));
        this.actionRefresh.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_refresh"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
        this.actionTDPrintPreView.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionTDPrint.setVisible(false);
        this.actionTDPrintPreView.setVisible(false);
    }

    private void setDisplayFormat() {
        this.txtBankAccount.setHorizontalAlignment(2);
        this.txtCurrency.setHorizontalAlignment(2);
        this.txtBank.setHorizontalAlignment(2);
        this.txtPeriod.setHorizontalAlignment(2);
        this.tblMain.getColumn(col_Aamount).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(col_Bamount).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void showInitReport() throws Exception {
        this._bInitial = true;
        this.initParams();
        this.generateReport();
    }

    private void initParams() throws BOSException, EASBizException {
        Map map = this.getUIContext();
        Object bank = map.get("bank");
        Object currency = map.get("currency");
        Object period = map.get("period");
        if (bank == null || currency == null || period == null) {
            return;
        }
        if (((PropertyContainer)bank).get("Id") == null) {
            return;
        }
        if (((PropertyContainer)currency).get("Id") == null) {
            return;
        }
        if (((PropertyContainer)period).get("Id") == null) {
            return;
        }
        this.bankInfo = (AccountBankInfo)bank;
        this.currencyInfo = (CurrencyInfo)currency;
        this.periodInfo = (PeriodInfo)period;
        this.condition = new BankBalanceCondition();
        this.condition.setCompanyInfo(this.companyInfo);
        this.condition.setBankId(this.bankInfo.getId().toString());
        this.condition.setCurrencyId(this.currencyInfo.getId().toString());
        this.condition.setPeriodId(this.periodInfo.getId().toString());
        this.condition.setIsForInit(true);
        this.bankPK = new ObjectUuidPK(this.bankInfo.getId());
        this.periodPK = new ObjectUuidPK(this.periodInfo.getId());
        this.currencyPK = new ObjectUuidPK(this.currencyInfo.getId());
    }

    protected void generateReport() throws Exception {
        IRow row;
        BankStatementInfo obj;
        int i;
        BankStatementInfo obj2;
        int i2;
        IRow row2;
        BankStatementInfo obj3;
        int i3;
        BankStatementInfo obj4;
        int i4;
        if (this.companyPK == null) {
            this.companyPK = new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId());
        }
        if (!this.hasNotNullParam((IObjectPK)this.companyPK, (IObjectPK)this.bankPK, (IObjectPK)this.currencyPK, (IObjectPK)this.periodPK)) {
            logger.error((Object)("query param is not complete, company:" + this.companyPK + ", bank:" + this.bankPK + ", currency:" + this.currencyPK + ", period:" + this.periodPK));
            SysUtil.abort();
        }
        this.setAmtColsFormat();
        this.setReportHeadInfos();
        long begin = System.currentTimeMillis();
        this.iAdjustment = BankBalanceAdjustmentFactory.getRemoteInstance();
        BankStmtBookReportInfo rptInfo = this.iAdjustment.getBalanceReport(this.condition);
        logger.info((Object)("Balance cost:" + (System.currentTimeMillis() - begin)));
        int scale = this.currencyInfo.getPrecision();
        if (rptInfo == null) {
            this.abort();
        }
        BigDecimal oJournalEndAmount = rptInfo.getBankBookAmt();
        BigDecimal oStatmntEndAmount = rptInfo.getBankStmtAmt();
        BigDecimal oBankGotAmount = rptInfo.getBankGotAmt();
        BigDecimal oBankPayedAmount = rptInfo.getBankPayedAmt();
        BigDecimal oEntprGotAmount = rptInfo.getEntprGotAmt();
        BigDecimal oEntprPayedAmount = rptInfo.getEntprPayedAmt();
        BigDecimal oAdjustedJournalAmount = null;
        BigDecimal oAdjustedStatmntAmount = null;
        oJournalEndAmount = oJournalEndAmount == null ? FMConstants.ZERO : oJournalEndAmount;
        oBankGotAmount = oBankGotAmount == null ? FMConstants.ZERO : oBankGotAmount;
        oBankPayedAmount = oBankPayedAmount == null ? FMConstants.ZERO : oBankPayedAmount;
        oAdjustedJournalAmount = oJournalEndAmount.add(oBankGotAmount).subtract(oBankPayedAmount);
        oStatmntEndAmount = oStatmntEndAmount == null ? FMConstants.ZERO : oStatmntEndAmount;
        oEntprGotAmount = oEntprGotAmount == null ? FMConstants.ZERO : oEntprGotAmount;
        oEntprPayedAmount = oEntprPayedAmount == null ? FMConstants.ZERO : oEntprPayedAmount;
        oAdjustedStatmntAmount = oStatmntEndAmount.add(oEntprGotAmount).subtract(oEntprPayedAmount);
        StringBuffer sFormat = new StringBuffer(25);
        sFormat.append("###,###,###,###,##0.");
        for (int i1 = 0; i1 < scale; ++i1) {
            sFormat.append("0");
        }
        this.tblMain.removeRows();
        NumberFormat formatter = null;
        formatter = NumberFormat.getNumberInstance();
        IRow row0 = this.tblMain.addRow();
        row0.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row0.getCell(col_Adesc).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"249_BankBalanceAdjustmentBUI"));
        row0.getCell(col_Aamount).setValue((Object)oJournalEndAmount);
        row0.getCell(col_Bdesc).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"250_BankBalanceAdjustmentBUI"));
        row0.getCell(col_Bamount).setValue((Object)oStatmntEndAmount);
        IRow row1 = this.tblMain.addRow();
        row1.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row1.getCell(col_Adesc).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"251_BankBalanceAdjustmentBUI"));
        row1.getCell(col_Aamount).setValue((Object)oBankGotAmount);
        row1.getCell(col_Bdesc).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"252_BankBalanceAdjustmentBUI"));
        row1.getCell(col_Bamount).setValue((Object)oEntprGotAmount);
        IObjectCollection bankUnreachedColl = null;
        IObjectCollection entprUnreachedColl = null;
        if (this._bInitial) {
            bankUnreachedColl = this.iAdjustment.getUnreachedBankCollection((IObjectPK)this.companyPK, (IObjectPK)this.bankPK, (IObjectPK)this.currencyPK, (IObjectPK)this.periodPK);
            entprUnreachedColl = this.iAdjustment.getUnreachedEntprCollection((IObjectPK)this.companyPK, (IObjectPK)this.bankPK, (IObjectPK)this.currencyPK, (IObjectPK)this.periodPK);
        } else {
            entprUnreachedColl = this.iAdjustment.getUnmatchedBankStatementCollection((IObjectPK)this.companyPK, (IObjectPK)this.bankPK, (IObjectPK)this.currencyPK, (IObjectPK)this.periodPK);
            bankUnreachedColl = this.iAdjustment.getUnmatchedBankJournalCollection((IObjectPK)this.companyPK, (IObjectPK)this.bankPK, (IObjectPK)this.currencyPK, (IObjectPK)this.periodPK);
        }
        int asize = 0;
        int bsize = 0;
        for (i4 = 0; i4 < entprUnreachedColl.size(); ++i4) {
            obj4 = (BankStatementInfo)entprUnreachedColl.getObject(i4);
            if (obj4.isIsDebit()) continue;
            ++asize;
        }
        for (i4 = 0; i4 < bankUnreachedColl.size(); ++i4) {
            obj4 = (JournalInfo)bankUnreachedColl.getObject(i4);
            if (!obj4.isIsDebit()) continue;
            ++bsize;
        }
        int size1 = asize > bsize ? asize : bsize;
        this.tblMain.addRows(size1);
        int index = 2;
        for (i3 = 0; i3 < entprUnreachedColl.size(); ++i3) {
            obj3 = (BankStatementInfo)entprUnreachedColl.getObject(i3);
            if (obj3.isIsDebit()) continue;
            row2 = this.tblMain.getRow(index);
            row2.getCell(col_AcreateDate).setValue((Object)obj3.getCreateDate());
            row2.getCell(col_Aamount).setValue((Object)obj3.getCreditAmount());
            row2.getCell(col_Adesc).setValue((Object)obj3.getDescription());
            row2.getCell(col_AsettleNumber).setValue((Object)obj3.getSettleNumber());
            row2.getCell(col_AsettleType).setValue((Object)obj3.getSettleType());
            ++index;
        }
        index = 2;
        for (i3 = 0; i3 < bankUnreachedColl.size(); ++i3) {
            obj3 = (JournalInfo)bankUnreachedColl.getObject(i3);
            if (!obj3.isIsDebit()) continue;
            row2 = this.tblMain.getRow(index);
            row2.getCell(col_Company).setValue((Object)obj3.getCompany().getName());
            row2.getCell(col_BcreateDate).setValue((Object)obj3.getCreateDate());
            row2.getCell(col_Bamount).setValue((Object)obj3.getDebitAmount());
            row2.getCell(col_Bdesc).setValue((Object)obj3.getDescription());
            row2.getCell(col_BVoucherType).setValue((Object)obj3.getVoucherType());
            row2.getCell(col_BVoucherNumber).setValue((Object)obj3.getVoucherNumber());
            row2.getCell(col_BsettleNumber).setValue((Object)obj3.getSettlementNumber());
            row2.getCell(col_BsettleType).setValue((Object)obj3.getSettlementType());
            ++index;
        }
        IRow row3 = this.tblMain.addRow();
        row3.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row3.getCell(col_Adesc).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"253_BankBalanceAdjustmentBUI"));
        row3.getCell(col_Aamount).setValue((Object)oBankPayedAmount);
        row3.getCell(col_Bdesc).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"254_BankBalanceAdjustmentBUI"));
        row3.getCell(col_Bamount).setValue((Object)oEntprPayedAmount);
        asize = 0;
        for (i2 = 0; i2 < entprUnreachedColl.size(); ++i2) {
            obj2 = (BankStatementInfo)entprUnreachedColl.getObject(i2);
            if (!obj2.isIsDebit()) continue;
            ++asize;
        }
        bsize = 0;
        for (i2 = 0; i2 < bankUnreachedColl.size(); ++i2) {
            obj2 = (JournalInfo)bankUnreachedColl.getObject(i2);
            if (obj2.isIsDebit()) continue;
            ++bsize;
        }
        int size2 = asize > bsize ? asize : bsize;
        this.tblMain.addRows(size2);
        index = 3 + size1;
        for (i = 0; i < entprUnreachedColl.size(); ++i) {
            obj = (BankStatementInfo)entprUnreachedColl.getObject(i);
            if (!obj.isIsDebit()) continue;
            row = this.tblMain.getRow(index);
            row.getCell(col_AcreateDate).setValue((Object)obj.getCreateDate());
            row.getCell(col_Aamount).setValue((Object)obj.getDebitAmount());
            row.getCell(col_Adesc).setValue((Object)obj.getDescription());
            row.getCell(col_AsettleNumber).setValue((Object)obj.getSettleNumber());
            row.getCell(col_AsettleType).setValue((Object)obj.getSettleType());
            ++index;
        }
        index = 3 + size1;
        for (i = 0; i < bankUnreachedColl.size(); ++i) {
            obj = (JournalInfo)bankUnreachedColl.getObject(i);
            if (obj.isIsDebit()) continue;
            row = this.tblMain.getRow(index);
            row.getCell(col_Company).setValue((Object)obj.getCompany());
            row.getCell(col_BcreateDate).setValue((Object)obj.getCreateDate());
            row.getCell(col_Bamount).setValue((Object)obj.getCreditAmount());
            row.getCell(col_Bdesc).setValue((Object)obj.getDescription());
            row.getCell(col_BsettleNumber).setValue((Object)obj.getSettlementNumber());
            row.getCell(col_BsettleType).setValue((Object)obj.getSettlementType());
            row.getCell(col_BVoucherType).setValue((Object)obj.getVoucherType());
            row.getCell(col_BVoucherNumber).setValue((Object)obj.getVoucherNumber());
            ++index;
        }
        IRow row4 = this.tblMain.addRow();
        row4.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row4.getCell(col_Adesc).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"255_BankBalanceAdjustmentBUI"));
        row4.getCell(col_Aamount).setValue((Object)oAdjustedJournalAmount);
        row4.getCell(col_Bdesc).setValue((Object)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"256_BankBalanceAdjustmentBUI"));
        row4.getCell(col_Bamount).setValue((Object)oAdjustedStatmntAmount);
    }

    private boolean hasNotNullParam(IObjectPK companyPK, IObjectPK bankPK, IObjectPK currencyPK, IObjectPK periodPK) {
        return companyPK != null && bankPK != null && currencyPK != null && periodPK != null;
    }

    private void setAmtColsFormat() {
        int scale = 2;
        if (this.currencyInfo != null) {
            scale = this.currencyInfo.getPrecision();
        }
        String format = FMClientHelper.getNumberFtm((int)scale);
        this.tblMain.getColumn(col_Aamount).getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn(col_Bamount).getStyleAttributes().setNumberFormat(format);
    }

    private void setReportHeadInfos() throws BOSException, EASBizException {
        this.txtBank.setText(this.bankInfo.getNumber() + " - " + this.bankInfo.getName() + " - " + this.bankInfo.getBankAccountNumber());
        this.txtCurrency.setText(this.currencyInfo.getName());
        String acctTableId = FMHelper.getActualAcctTable(null, (String)this.companyInfo.getId().toString(), (java.util.Date)this.periodInfo.getBeginDate(), (java.util.Date)this.periodInfo.getEndDate());
        this.bankInfo = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankInfo)this.bankInfo, null, (String)acctTableId);
        this.txtBankAccount.setText(this.bankInfo.getAccount().toString());
        if (this._bInitial) {
            this.txtPeriod.setText(new Date(this.periodInfo.getBeginDate().getTime()).toString());
            String lbl_startAmt = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BalanceAdj_PeriodStartAmt");
            String string = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BalanceAdj_AdjustedStartAmt");
        } else {
            Object[] args = new String[]{String.valueOf(this.periodInfo.getPeriodYear()), String.valueOf(this.periodInfo.getPeriodNumber())};
            String sPeriod = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"), args);
            this.txtPeriod.setText(sPeriod);
        }
    }

    private void setLineFields(KDTable table, IRow row, IObjectValue obj) {
        row.setUserObject((Object)obj);
        Object val = null;
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String bindField = table.getColumn(i).getKey();
            if (StringUtils.isEmpty((String)bindField) || obj.get(bindField) == null) continue;
            if (obj.get(bindField) instanceof Timestamp) {
                row.getCell(i).setValue((Object)obj.getDate(bindField));
                continue;
            }
            if (obj.get(bindField) instanceof BigDecimal) {
                BigDecimal amt = (BigDecimal)obj.get(bindField);
                logger.info((Object)(bindField + " " + amt));
                if (amt.compareTo(FMConstants.ZERO) == 0) continue;
                row.getCell(i).setValue((Object)amt);
                continue;
            }
            val = obj.get(bindField);
            if (val == null || String.valueOf(val) == null) continue;
            row.getCell(i).setValue(val);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        IPermission ipermission = PermissionFactory.getRemoteInstance();
        ipermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)this.companyPK, "cas_bankbalanceagjtable_02print");
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    @Override
    public void actionPreview_actionPerformed(ActionEvent e) throws Exception {
        IPermission ipermission = PermissionFactory.getRemoteInstance();
        ipermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)this.companyPK, "cas_bankbalanceagjtable_02print");
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    public static void showDialogUI(IUIObject ui, BankBalanceAdjFilterParam param) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
        uiContext.put((Object)"filterParam", (Object)param);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)FMClientHelper.getEditUIMode((CoreUIObject)((CoreUIObject)ui))).create(BankBalanceAdjustmentBUI.class.getName(), (Map)uiContext, null, "FINDVIEW");
        uiWindow.show();
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        String sBank = this.lblBank.getBoundLabelText() + " &[Bank]";
        String sCurrency = this.lblCurrency.getBoundLabelText() + " &[Currency]";
        String sAccount = this.lblBankAccount.getBoundLabelText() + " &[BankAccount] ";
        String sPeriod = this.lblPeriod.getBoundLabelText() + " &[Period]";
        headerModel.addRow(sBank + "&|" + sCurrency);
        headerModel.addRow(sAccount + "&|" + sPeriod);
    }

    private CommonQueryDialog getQueryDialog() throws Exception {
        if (this._dialog == null) {
            MetaDataPK mockQuery = new MetaDataPK("com.kingdee.eas.fi.cas", "BankStatementQuery");
            if (this._filterUI == null) {
                this._filterUI = new BankBalanceAdjustmentBFilterUI(this.companyInfo);
            }
            if (this.isSharedOrg) {
                CashClientHelper.processSharedOrgFilterUI(this._filterUI);
            }
            this._dialog = new CommonQueryDialog();
            this._dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this._dialog.setOwner((Component)this.getUIContext().get("Owner"));
            this._dialog.setShowFilter(false);
            this._dialog.setShowSorter(false);
            this._dialog.setEntityViewInfo(new EntityViewInfo());
            this._dialog.setQueryObjectPK((IMetaDataPK)mockQuery);
            this._dialog.addUserPanel((KDPanel)this._filterUI);
            this._dialog.setWidth(400);
            this._dialog.setHeight(250);
            this._dialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BalanceAdjustementUITitle") + " - " + EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"QueryUITitle"));
        }
        return this._dialog;
    }

    private void clearPreQueryParams() {
        this.bankInfo = null;
        this.bankPK = null;
        this.currencyInfo = null;
        this.currencyPK = null;
        this.periodInfo = null;
        this.periodPK = null;
        this.condition = null;
        this.txtBankAccount.setText(null);
        this.txtCurrency.setText(null);
        this.txtBank.setText(null);
        this.txtPeriod.setText(null);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        Boolean isDirectShow;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        boolean hasDefaultQuery = iQuery.hasDefaultSolution(((Object)((Object)this)).getClass().getName(), "com.kingdee.eas.fi.cas.BankStatementQuery");
        CommonQueryDialog queryDialog = this.getQueryDialog();
        if (this.isFirstLoad && hasDefaultQuery) {
            isDirectShow = (Boolean)this.getUIContext().get("isDirectShow");
            FilterParam obj = null;
            if (isDirectShow != null && isDirectShow.equals(Boolean.TRUE)) {
                obj = (FilterParam)this.getUIContext().get("filterParam");
                if (this._filterUI != null) {
                    this._filterUI.onLoad();
                    this._filterUI.setParam(obj);
                }
                this.getUIContext().put("isDirectShow", null);
                this.isFirstLoad = false;
            } else {
                QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), "com.kingdee.eas.fi.cas.BankStatementQuery");
                QueryPanelCollection queryPanels = solution.getQueryPanelInfo();
                QueryPanelInfo queryPanelInfo = queryPanels.get(0);
                this._filterUI.onLoad();
                if (queryPanelInfo.getCustomerParams() != null) {
                    CustomerParams cp = CustomerParams.getCustomerParams2((String)queryPanelInfo.getCustomerParams());
                    if (cp == null) {
                        return;
                    }
                    String paramValue = cp.getCustomerParam("fmcustomer");
                    if (FMHelper.isEmpty((String)paramValue)) {
                        return;
                    }
                    byte[] bytes = FMHelper.decode((byte[])paramValue.getBytes());
                    this._filterUI.setParam(CommonUtil.getObject((byte[])bytes));
                }
                this.isFirstLoad = false;
            }
        } else {
            isDirectShow = (Boolean)this.getUIContext().get("isDirectShow");
            FilterParam obj = null;
            if (isDirectShow != null && isDirectShow.equals(Boolean.TRUE)) {
                obj = (FilterParam)this.getUIContext().get("filterParam");
                if (this._filterUI != null) {
                    this._filterUI.onLoad();
                    this._filterUI.setParam(obj);
                }
                this.getUIContext().put("isDirectShow", null);
            } else if (!queryDialog.show()) {
                SysUtil.abort();
            }
        }
        this.clearPreQueryParams();
        BankBalanceAdjFilterParam param = (BankBalanceAdjFilterParam)this._filterUI.getParam();
        if (this.condition == null) {
            this.condition = new BankBalanceCondition();
        }
        this.companyPK = new ObjectUuidPK(param.getCompanyId());
        this.companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)this.companyPK);
        this.condition.setCompanyInfo(this.companyInfo);
        this.condition.setBankId(param.getBankId());
        this.condition.setCurrencyId(param.getCurrencyId());
        this.condition.setPeriodId(param.getPeriodId());
        this.condition.setIsDetail(true);
        this.bankPK = new ObjectUuidPK(param.getBankId());
        this.periodPK = new ObjectUuidPK(param.getPeriodId());
        this.currencyPK = new ObjectUuidPK(param.getCurrencyId());
        if (this._filterUI.prmtBankAccount.getValue() != null) {
            this.bankInfo = (AccountBankInfo)this._filterUI.prmtBankAccount.getValue();
        }
        this.bankInfo = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankInfo)this.bankInfo, null, (String)param.getAcctTableId());
        if (this._filterUI.comboCurrency.getSelectedItem() != null) {
            this.currencyInfo = (CurrencyInfo)this._filterUI.comboCurrency.getSelectedItem();
        }
        this.periodInfo = param.getPeriodInfo();
        this._bInitial = false;
        this.generateReport();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.generateReport();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        map.put("Bank", this.txtBank.getText());
        map.put("Currency", this.txtCurrency.getText());
        map.put("BankAccount", this.txtBankAccount.getText());
        map.put("Period", this.txtPeriod.getText());
        map.put("CurrencyUser", ContextHelperFactory.getRemoteInstance().getCurrentUser().getName());
        return map;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        class MyExtVarProvider
        implements ExtVarProvider {
            Map varMap = null;

            MyExtVarProvider() {
                this.initVarMap();
            }

            private void initVarMap() {
                this.varMap = BankBalanceAdjustmentBUI.this.preparePrintVariantMap();
            }

            public Variant requestVarData(String varName) {
                if (BankBalanceAdjustmentBUI.this.shouldReloadPrintVar) {
                    this.initVarMap();
                }
                if (this.varMap == null) {
                    return null;
                }
                Object obj = this.varMap.get(varName);
                if (!(obj instanceof Variant)) {
                    Variant v = new Variant();
                    v.setObject(obj);
                    return v;
                }
                return (Variant)obj;
            }
        }
        return new MyExtVarProvider();
    }
}

