/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BankBalanceAdjustmentFactory;
import com.kingdee.eas.fi.cas.BankBalanceAdjustmentUIFacadeFactory;
import com.kingdee.eas.fi.cas.BankBalanceCondition;
import com.kingdee.eas.fi.cas.BankStmtBookReportInfo;
import com.kingdee.eas.fi.cas.IBankBalanceAdjustment;
import com.kingdee.eas.fi.cas.client.AbstractBankBalanceAdjustmentUI;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjFilterParam;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustmentBUI;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustmentDataProvider;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustmentFilterUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMKDTableHelper;
import com.kingdee.eas.fm.common.client.query.QuerySolutionConvert;
import com.kingdee.eas.fm.common.util.UserDefineColumnCollection;
import com.kingdee.eas.fm.common.util.UserDefineColumnInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import org.apache.log4j.Logger;

public class BankBalanceAdjustmentUI
extends AbstractBankBalanceAdjustmentUI {
    private static final Logger logger = CoreUIObject.getLogger(BankBalanceAdjustmentUI.class);
    public static final String INIT = "init";
    private IBankBalanceAdjustment iAdjustment = null;
    private CompanyOrgUnitInfo companyInfo = null;
    private AccountBankInfo bankInfo = null;
    private CurrencyInfo currencyInfo = null;
    private PeriodInfo periodInfo = null;
    private ObjectUuidPK companyPK = null;
    private ObjectUuidPK bankPK = null;
    private ObjectUuidPK currencyPK = null;
    private ObjectUuidPK periodPK = null;
    private boolean _bInitial = true;
    private boolean fHasLoadedDtl = false;
    private CommonQueryDialog _dialog = null;
    private BankBalanceAdjustmentFilterUI _filterUI = null;
    private BankBalanceCondition condition = null;
    private boolean isFirstLoad = true;
    public static final String CS018 = "CS018";
    private Map paramMap = new HashMap();
    private boolean isSharedOrg = false;
    private static String printDateMsg = "Print_date";
    private static String printPersonMsg = "Print_person";
    private static String printPageCountMsg = "Print_pageCount";
    private boolean shouldReloadPrintVar = true;
    public static final String CASH_FILENAME = "/FI/CAS/BANKBALANCEADJUST";
    private int sort_Bank = 0;
    private int sort_Entp = 0;
    private boolean isFristSort_Bank = true;
    private boolean isFristSort_Entp = true;
    private KDTSortManager sm_Bank = null;
    private KDTSortManager sm_Entp = null;

    public BankBalanceAdjustmentUI() throws Exception {
        this.windowTitle = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BalanceAdjustementUITitle");
    }

    public void onShow() throws Exception {
        super.onShow();
        this.splitPaneDetail.setDividerLocation(this.splitPaneDetail.getWidth() / 2);
    }

    public boolean destroyWindow() {
        if (this.isSharedOrg) {
            CashClientHelper.releaseSharedOrgLicense();
        }
        return super.destroyWindow();
    }

    public void onLoad() throws Exception {
        this.isSharedOrg = CashClientHelper.hasSharedOrgUIParam((CoreUIObject)this);
        if (this.isSharedOrg) {
            CashClientHelper.processSharedOrgLicense(this);
        }
        this.companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.companyInfo)) {
            FMClientHelper.checkPeriod((CoreUI)this);
        }
        this.tbl.checkParsed();
        if ("FINDVIEW".equalsIgnoreCase(this.getOprtState()) && this.getUIContext().get("filterParam") != null && this.getUIContext().get("filterParam") instanceof BankBalanceAdjFilterParam) {
            BankBalanceAdjFilterParam param = (BankBalanceAdjFilterParam)this.getUIContext().get("filterParam");
            String companyId = param.getCompanyId();
            this.companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.companyInfo)) {
                PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.companyInfo);
                PeriodInfo startPeriodInfo = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.companyInfo);
                if (currPeriodInfo == null || startPeriodInfo == null) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"StartPeriod_NullMsg"));
                    SysUtil.abort();
                }
            }
        }
        super.onLoad();
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
        this.checkBoxViewDetails.setSelected(true);
        this.tblEntprUnreachedDetails.checkParsed();
        this.tblBankUnreachedDetails.checkParsed();
        this.setDisplayFormat();
        KDTableHelper.setEnterKeyJumpOrientation((KDTable)this.tblEntprUnreachedDetails, (int)2);
        KDTableHelper.setEnterKeyJumpOrientation((KDTable)this.tblBankUnreachedDetails, (int)2);
        this.tblEntprUnreachedDetails.getSelectManager().setSelectMode(10);
        this.tblBankUnreachedDetails.getSelectManager().setSelectMode(10);
        this.tblEntprUnreachedDetails.getStyleAttributes().setLocked(true);
        this.tblBankUnreachedDetails.getStyleAttributes().setLocked(true);
        this.tblBankUnreachedDetails.getColumn("createDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        this.tblEntprUnreachedDetails.getColumn("createDate").getStyleAttributes().setNumberFormat(FMHelper.getDateFormatString());
        if (this.isInitReport()) {
            this.btnQuery.setVisible(false);
            this.btnQuery.setEnabled(false);
            this.btnRefresh.setVisible(false);
            this.btnRefresh.setEnabled(false);
            this.lblPeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BalanceAdjustement_Date"));
            this.showInitReport();
        } else {
            this.actionQuery_actionPerformed(null);
        }
        if (this.isSharedOrg) {
            CashClientHelper.processSharedOrgFilterUI(this._filterUI);
        }
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    private String getTitle() {
        PeriodInfo curP = (PeriodInfo)this.paramMap.get("currPeriodInfo");
        return EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"PeriodTitle") + curP.getPeriodYear() + EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"year") + curP.getPeriodNumber() + EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"period");
    }

    private boolean isInitReport() {
        String uiParam;
        return this.getUIContext().get("UIClassParam") != null && (uiParam = (String)this.getUIContext().get("UIClassParam")).equals(INIT);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.setButtonDefaultStyl(this.btnQuery);
        this.setButtonDefaultStyl(this.btnRefresh);
        this.setButtonDefaultStyl(this.btnPrint);
        this.setButtonDefaultStyl(this.btnPreview);
        this.actionPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
        this.actionPreview.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
        this.actionQuery.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_filter"));
        this.actionRefresh.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_refresh"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
        this.actionTDPrintPreView.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    private void setDisplayFormat() {
        this.txtBankAccount.setHorizontalAlignment(2);
        this.txtCurrency.setHorizontalAlignment(2);
        this.txtBank.setHorizontalAlignment(2);
        this.txtPeriod.setHorizontalAlignment(2);
        this.txtJornalAmount.setHorizontalAlignment(4);
        this.txtStatmntAmount.setHorizontalAlignment(4);
        this.txtAdjustedJournalAmount.setHorizontalAlignment(4);
        this.txtAdjustedStatmntAmount.setHorizontalAlignment(4);
        this.txtBankGot.setHorizontalAlignment(4);
        this.txtBankPayed.setHorizontalAlignment(4);
        this.txtEntprGot.setHorizontalAlignment(4);
        this.txtEntprPayed.setHorizontalAlignment(4);
        int colDebit = 5;
        int colCredit = 6;
        this.tblEntprUnreachedDetails.getColumn(colDebit).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblEntprUnreachedDetails.getColumn(colDebit).setWidth(120);
        this.tblEntprUnreachedDetails.getColumn(colCredit).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblEntprUnreachedDetails.getColumn(colCredit).setWidth(120);
        int colBankDebit = 7;
        int colBankCredit = 8;
        this.tblBankUnreachedDetails.getColumn(colBankDebit).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBankUnreachedDetails.getColumn(colBankDebit).setWidth(120);
        this.tblBankUnreachedDetails.getColumn(colBankCredit).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBankUnreachedDetails.getColumn(colBankCredit).setWidth(120);
    }

    private void showInitReport() throws Exception {
        this._bInitial = true;
        this.initParams();
        this.generateReport();
    }

    private void initParams() throws BOSException, EASBizException {
        Map map = this.getUIContext();
        Object bank = map.get("bank");
        Object currency = map.get("currency");
        Object period = map.get("period");
        if (bank == null || currency == null || period == null) {
            return;
        }
        if (((PropertyContainer)bank).get("Id") == null) {
            return;
        }
        if (((PropertyContainer)currency).get("Id") == null) {
            return;
        }
        if (((PropertyContainer)period).get("Id") == null) {
            return;
        }
        this.bankInfo = (AccountBankInfo)bank;
        this.currencyInfo = (CurrencyInfo)currency;
        this.periodInfo = (PeriodInfo)period;
        this.condition = new BankBalanceCondition();
        if (this.bankInfo.getShareType().getValue() == 1) {
            this.condition.setCompanyInfo(this.bankInfo.getCompany());
        } else {
            this.condition.setCompanyInfo(this.companyInfo);
        }
        this.condition.setBankId(this.bankInfo.getId().toString());
        this.condition.setCurrencyId(this.currencyInfo.getId().toString());
        this.condition.setPeriodId(this.periodInfo.getId().toString());
        this.condition.setIsForInit(true);
        this.bankPK = new ObjectUuidPK(this.bankInfo.getId());
        this.periodPK = new ObjectUuidPK(this.periodInfo.getId());
        this.currencyPK = new ObjectUuidPK(this.currencyInfo.getId());
    }

    protected void generateReport() throws Exception {
        if (this.companyPK == null) {
            this.companyPK = new ObjectUuidPK(ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId());
        }
        if (!this.hasNotNullParam((IObjectPK)this.companyPK, (IObjectPK)this.bankPK, (IObjectPK)this.currencyPK, (IObjectPK)this.periodPK)) {
            logger.error((Object)("query param is not complete, company:" + this.companyPK + ", bank:" + this.bankPK + ", currency:" + this.currencyPK + ", period:" + this.periodPK));
            SysUtil.abort();
        }
        this.setAmtColsFormat();
        this.setReportHeadInfos();
        this.condition.setIsDetail(this.checkBoxViewDetails.isSelected());
        long begin = System.currentTimeMillis();
        this.iAdjustment = BankBalanceAdjustmentFactory.getRemoteInstance();
        BankStmtBookReportInfo rptInfo = this.iAdjustment.getBalanceReport(this.condition);
        logger.info((Object)("Balance cost:" + (System.currentTimeMillis() - begin)));
        int scale = this.currencyInfo.getPrecision();
        this.setReportToUI(rptInfo, scale);
        if (this.checkBoxViewDetails.isSelected()) {
            this.showDetails(rptInfo);
        }
    }

    private boolean hasNotNullParam(IObjectPK companyPK, IObjectPK bankPK, IObjectPK currencyPK, IObjectPK periodPK) {
        return companyPK != null && bankPK != null && currencyPK != null && periodPK != null;
    }

    private void setAmtColsFormat() {
        int scale = 2;
        if (this.currencyInfo != null) {
            scale = this.currencyInfo.getPrecision();
        }
        String format = ClientUtils.getNumberFormat(scale, true);
        int colDebit = 5;
        int colCredit = 6;
        this.tblEntprUnreachedDetails.getColumn(colDebit).getStyleAttributes().setNumberFormat(format);
        this.tblEntprUnreachedDetails.getColumn(colCredit).getStyleAttributes().setNumberFormat(format);
        int colBankDebit = 7;
        int colBankCredit = 8;
        this.tblBankUnreachedDetails.getColumn(colBankDebit).getStyleAttributes().setNumberFormat(format);
        this.tblBankUnreachedDetails.getColumn(colBankCredit).getStyleAttributes().setNumberFormat(format);
    }

    private void setReportHeadInfos() throws BOSException, EASBizException {
        this.txtBank.setText(this.bankInfo.getNumber() + " - " + this.bankInfo.getName() + " - " + this.bankInfo.getBankAccountNumber());
        this.txtCurrency.setText(this.currencyInfo.getName());
        String acctTableId = "";
        if (this._filterUI != null && ((BankBalanceAdjFilterParam)this._filterUI.getParam()).getAcctTableId() != null) {
            BankBalanceAdjFilterParam param = (BankBalanceAdjFilterParam)this._filterUI.getParam();
            acctTableId = param.getAcctTableId();
        } else {
            acctTableId = FMHelper.getActualAcctTable(null, (String)this.companyInfo.getId().toString(), (Date)this.periodInfo.getBeginDate(), (Date)this.periodInfo.getEndDate());
        }
        this.bankInfo = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankInfo)this.bankInfo, null, (String)acctTableId);
        this.txtBankAccount.setText(this.bankInfo.getAccount().toString());
        if (this._bInitial) {
            this.txtPeriod.setText(FMHelper.getDateFormat().format(new java.sql.Date(this.periodInfo.getBeginDate().getTime())));
            String lbl_startAmt = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BalanceAdj_PeriodStartAmt");
            String lbl_adjAmt = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BalanceAdj_AdjustedStartAmt");
            this.lblJournalAmount.setBoundLabelText(lbl_startAmt);
            this.lblStatmntAmount.setBoundLabelText(lbl_startAmt);
            this.lblAdjustedJournalAmount.setBoundLabelText(lbl_adjAmt);
            this.lblAdjustedStatmntAmount.setBoundLabelText(lbl_adjAmt);
        } else {
            Object[] args = new String[]{String.valueOf(this.periodInfo.getPeriodYear()), String.valueOf(this.periodInfo.getPeriodNumber())};
            String sPeriod = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"), args);
            this.txtPeriod.setText(sPeriod);
        }
    }

    private void setReportToUI(BankStmtBookReportInfo rptInfo, int scale) {
        if (rptInfo == null) {
            return;
        }
        BigDecimal oJournalEndAmount = rptInfo.getBankBookAmt();
        BigDecimal oStatmntEndAmount = rptInfo.getBankStmtAmt();
        BigDecimal oBankGotAmount = rptInfo.getBankGotAmt();
        BigDecimal oBankPayedAmount = rptInfo.getBankPayedAmt();
        BigDecimal oEntprGotAmount = rptInfo.getEntprGotAmt();
        BigDecimal oEntprPayedAmount = rptInfo.getEntprPayedAmt();
        BigDecimal oAdjustedJournalAmount = null;
        BigDecimal oAdjustedStatmntAmount = null;
        oJournalEndAmount = oJournalEndAmount == null ? Constants.ZERO : oJournalEndAmount;
        oBankGotAmount = oBankGotAmount == null ? Constants.ZERO : oBankGotAmount;
        oBankPayedAmount = oBankPayedAmount == null ? Constants.ZERO : oBankPayedAmount;
        oAdjustedJournalAmount = oJournalEndAmount.add(oBankGotAmount).subtract(oBankPayedAmount);
        oStatmntEndAmount = oStatmntEndAmount == null ? Constants.ZERO : oStatmntEndAmount;
        oEntprGotAmount = oEntprGotAmount == null ? Constants.ZERO : oEntprGotAmount;
        oEntprPayedAmount = oEntprPayedAmount == null ? Constants.ZERO : oEntprPayedAmount;
        oAdjustedStatmntAmount = oStatmntEndAmount.add(oEntprGotAmount).subtract(oEntprPayedAmount);
        this.txtJornalAmount.setText(ClientUtils.formatDecimal(oJournalEndAmount, scale));
        this.txtBankPayed.setText(ClientUtils.formatDecimal(oBankPayedAmount, scale));
        this.txtBankGot.setText(ClientUtils.formatDecimal(oBankGotAmount, scale));
        this.txtStatmntAmount.setText(ClientUtils.formatDecimal(oStatmntEndAmount, scale));
        this.txtEntprGot.setText(ClientUtils.formatDecimal(oEntprGotAmount, scale));
        this.txtEntprPayed.setText(ClientUtils.formatDecimal(oEntprPayedAmount, scale));
        this.txtAdjustedJournalAmount.setText(ClientUtils.formatDecimal(oAdjustedJournalAmount, scale));
        this.txtAdjustedStatmntAmount.setText(ClientUtils.formatDecimal(oAdjustedStatmntAmount, scale));
    }

    private void showDetails(BankStmtBookReportInfo rptInfo) throws Exception {
        IObjectCollection bankUnreachedColl = null;
        IObjectCollection entprUnreachedColl = null;
        if (rptInfo != null) {
            bankUnreachedColl = rptInfo.getBanks();
            entprUnreachedColl = rptInfo.getEntprs();
        } else if (this._bInitial) {
            bankUnreachedColl = this.iAdjustment.getUnreachedBankCollection((IObjectPK)this.companyPK, (IObjectPK)this.bankPK, (IObjectPK)this.currencyPK, (IObjectPK)this.periodPK);
            entprUnreachedColl = this.iAdjustment.getUnreachedEntprCollection((IObjectPK)this.companyPK, (IObjectPK)this.bankPK, (IObjectPK)this.currencyPK, (IObjectPK)this.periodPK);
        } else {
            entprUnreachedColl = this.iAdjustment.getUnmatchedBankStatementCollection((IObjectPK)this.companyPK, (IObjectPK)this.bankPK, (IObjectPK)this.currencyPK, (IObjectPK)this.periodPK);
            bankUnreachedColl = this.iAdjustment.getUnmatchedBankJournalCollection((IObjectPK)this.companyPK, (IObjectPK)this.bankPK, (IObjectPK)this.currencyPK, (IObjectPK)this.periodPK);
        }
        this.showTheDetails(this.tblEntprUnreachedDetails, entprUnreachedColl);
        this.showTheDetails(this.tblBankUnreachedDetails, bankUnreachedColl);
        this.fHasLoadedDtl = true;
    }

    private void showTheDetails(KDTable table, IObjectCollection collection) throws Exception {
        table.removeRows();
        if (collection != null && collection.size() > 0) {
            table.setUserObject((Object)collection);
            int n = collection.size();
            for (int i = 0; i < n; ++i) {
                IObjectValue obj = collection.getObject(i);
                IRow row = table.addRow(i);
                this.setLineFields(table, row, obj);
            }
        }
    }

    private void setLineFields(KDTable table, IRow row, IObjectValue obj) {
        row.setUserObject((Object)obj);
        Object val = null;
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            String bindField = table.getColumn(i).getKey();
            if (StringUtils.isEmpty((String)bindField) || obj.get(bindField) == null) continue;
            if (obj.get(bindField) instanceof Timestamp) {
                row.getCell(i).setValue((Object)obj.getDate(bindField));
                continue;
            }
            if (obj.get(bindField) instanceof BigDecimal) {
                BigDecimal amt = (BigDecimal)obj.get(bindField);
                logger.info((Object)(bindField + " " + amt));
                if (amt.compareTo(Constants.ZERO) == 0) continue;
                row.getCell(i).setValue((Object)amt);
                continue;
            }
            val = obj.get(bindField);
            if (val == null || String.valueOf(val) == null) continue;
            row.getCell(i).setValue(val);
        }
    }

    private void setAmountToTxt(KDTextField txt, BigDecimal amount, int scale) {
        txt.setText(amount.setScale(scale, 4).toString());
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void checkBoxViewDetails_actionPerformed(ActionEvent e) throws Exception {
        if (this.checkBoxViewDetails.isSelected()) {
            this.splitPaneDetail.setVisible(true);
            if (!this.fHasLoadedDtl) {
                this.showDetails(null);
            }
        } else {
            this.splitPaneDetail.setVisible(false);
        }
    }

    @Override
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        IPermission ipermission = PermissionFactory.getRemoteInstance();
        ipermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)this.companyPK, "cas_bankbalanceagjtable_02print");
        FMKDTableHelper.mergeTable((KDTable)this.tbl, (KDTable)this.tblEntprUnreachedDetails, (KDTable)this.tblBankUnreachedDetails, (int)0);
        this.tbl.getStyleAttributes().setHided(false);
        this.tbl.getHeadStyleAttributes().setHided(false);
        if (!this.checkBoxViewDetails.isSelected() || this.checkBoxViewDetails.isSelected() && this.tblBankUnreachedDetails.getRowCount() == 0 && this.tblEntprUnreachedDetails.getRowCount() == 0) {
            if (this.tbl.getRowCount() == 0) {
                this.tbl.addRow();
            }
            this.tbl.removeHeadRows();
            this.tbl.getStyleAttributes().setHided(true);
            this.tbl.getHeadStyleAttributes().setHided(true);
        }
        this.preparePrintPage(this.tbl);
        this.tbl.getPrintManager().print();
    }

    @Override
    public void actionPreview_actionPerformed(ActionEvent e) throws Exception {
        IPermission ipermission = PermissionFactory.getRemoteInstance();
        ipermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)this.companyPK, "cas_bankbalanceagjtable_02print");
        FMKDTableHelper.mergeTable((KDTable)this.tbl, (KDTable)this.tblEntprUnreachedDetails, (KDTable)this.tblBankUnreachedDetails, (int)0);
        this.tbl.getStyleAttributes().setHided(false);
        this.tbl.getHeadStyleAttributes().setHided(false);
        if (!this.checkBoxViewDetails.isSelected() || this.checkBoxViewDetails.isSelected() && this.tblBankUnreachedDetails.getRowCount() == 0 && this.tblEntprUnreachedDetails.getRowCount() == 0) {
            if (this.tbl.getRowCount() == 0) {
                this.tbl.addRow();
            }
            this.tbl.removeHeadRows();
            this.tbl.getStyleAttributes().setHided(true);
            this.tbl.getHeadStyleAttributes().setHided(true);
        }
        this.preparePrintPage(this.tbl);
        this.tbl.getPrintManager().printPreview();
    }

    public static void showDialogUI(IUIObject ui, BankBalanceAdjFilterParam param) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
        uiContext.put((Object)"filterParam", (Object)param);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIUtil.getEditUIMode((CoreUIObject)((CoreUIObject)ui))).create(BankBalanceAdjustmentUI.class.getName(), (Map)uiContext, null, "FINDVIEW");
        uiWindow.show();
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        String sBank = this.lblBank.getBoundLabelText() + " &[Bank]";
        String sCurrency = this.lblCurrency.getBoundLabelText() + " &[Currency]";
        String sAccount = this.lblBankAccount.getBoundLabelText() + " &[BankAccount] ";
        String sPeriod = this.lblPeriod.getBoundLabelText() + " &[Period]";
        headerModel.addRow(sBank + "&|" + sCurrency + "&|" + sAccount);
        headerModel.addRow(sPeriod + "&| &|");
        String sEntprPane = ((TitledBorder)this.kdPaneJournal.getBorder()).getTitle();
        String sBankPane = ((TitledBorder)this.kdPaneBankStatmnt.getBorder()).getTitle();
        headerModel.addRow(sEntprPane + "&| &|" + sBankPane);
        String sJournalAmt = this.lblJournalAmount.getBoundLabelText() + " &[JornalAmount]";
        String sBankGotAmt = this.lblBankGot.getBoundLabelText() + "  &[BankGot]";
        String sBankPayedAmt = this.lblBankPayed.getBoundLabelText() + "  &[BankPayed]";
        String sJournalAdjAmt = this.lblAdjustedJournalAmount.getBoundLabelText() + "  &[AdjustedJournalAmount]";
        String sStmtAmt = this.lblStatmntAmount.getBoundLabelText() + " &[StatmntAmount]";
        String sEntprGotAmt = this.lblEntprGot.getBoundLabelText() + " &[EntprGot]";
        String sEntprPayedAmt = this.lblEntprPayed.getBoundLabelText() + " &[EntprPayed]";
        String sStmtAdjAmt = this.lblAdjustedStatmntAmount.getBoundLabelText() + "   &[AdjustedStatmntAmount]";
        headerModel.addRow(sJournalAmt + "&| &|" + sStmtAmt);
        headerModel.addRow(sBankGotAmt + "&| &|" + sEntprGotAmt);
        headerModel.addRow(sBankPayedAmt + "&| &|" + sEntprPayedAmt);
        headerModel.addRow(sJournalAdjAmt + "&| &|" + sStmtAdjAmt);
        if (this.checkBoxViewDetails.isSelected()) {
            headerModel.addRow(this.containerEntpr.getTitle() + ":&| " + this.containerBank.getTitle() + ":");
        }
    }

    private CommonQueryDialog getQueryDialog() throws Exception {
        if (this._dialog == null) {
            MetaDataPK mockQuery = new MetaDataPK("com.kingdee.eas.fi.cas", "BankStatementQuery");
            if (this._filterUI == null) {
                // empty if block
            }
            if (this.isSharedOrg) {
                CashClientHelper.processSharedOrgFilterUI(this._filterUI);
            }
            this._dialog = new CommonQueryDialog();
            this._dialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this._dialog.setOwner((Component)this.getUIContext().get("Owner"));
            this._dialog.setShowFilter(false);
            this._dialog.setShowSorter(false);
            this._dialog.setEntityViewInfo(new EntityViewInfo());
            this._dialog.setQueryObjectPK((IMetaDataPK)mockQuery);
            this._dialog.addUserPanel((KDPanel)this._filterUI);
            this._dialog.setWidth(400);
            this._dialog.setHeight(250);
            this._dialog.setTitle(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BalanceAdjustementUITitle") + " - " + EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"QueryUITitle"));
        }
        return this._dialog;
    }

    private void clearPreQueryParams() {
        this.bankInfo = null;
        this.bankPK = null;
        this.currencyInfo = null;
        this.currencyPK = null;
        this.periodInfo = null;
        this.periodPK = null;
        this.condition = null;
        this.txtBankAccount.setText(null);
        this.txtCurrency.setText(null);
        this.txtBank.setText(null);
        this.txtPeriod.setText(null);
        this.txtAdjustedJournalAmount.setText(null);
        this.txtAdjustedStatmntAmount.setText(null);
        this.txtBankGot.setText(null);
        this.txtBankPayed.setText(null);
        this.txtEntprGot.setText(null);
        this.txtEntprPayed.setText(null);
        this.txtJornalAmount.setText(null);
        this.txtStatmntAmount.setText(null);
    }

    @Override
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        FilterParam obj;
        Boolean isDirectShow;
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        boolean hasDefaultQuery = iQuery.hasDefaultSolution(((Object)((Object)this)).getClass().getName(), "com.kingdee.eas.fi.cas.BankStatementQuery");
        CommonQueryDialog queryDialog = this.getQueryDialog();
        if (this.isFirstLoad && hasDefaultQuery) {
            isDirectShow = (Boolean)this.getUIContext().get("isDirectShow");
            obj = null;
            if (isDirectShow != null && isDirectShow.equals(Boolean.TRUE)) {
                obj = (FilterParam)this.getUIContext().get("filterParam");
                if (this._filterUI != null) {
                    this._filterUI.onLoad();
                    this._filterUI.setParam(obj);
                }
                this.getUIContext().put("isDirectShow", null);
                this.isFirstLoad = false;
            } else {
                QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), "com.kingdee.eas.fi.cas.BankStatementQuery");
                QueryPanelCollection queryPanels = solution.getQueryPanelInfo();
                QueryPanelInfo queryPanelInfo = queryPanels.get(0);
                this._filterUI.onLoad();
                if (queryPanelInfo != null && queryPanelInfo.getCustomerParams() != null) {
                    CustomerParams cp = CustomerParams.getCustomerParams2((String)queryPanelInfo.getCustomerParams());
                    if (cp == null) {
                        return;
                    }
                    String paramValue = cp.getCustomerParam("fmcustomer");
                    if (EmptyUtil.isEmpty((String)paramValue)) {
                        if (this.isNewQuerySolution(cp)) {
                            QuerySolutionConvert convert = new QuerySolutionConvert();
                            Object param = convert.convertToBizParams(BankBalanceAdjFilterParam.class, cp);
                            this._filterUI.setParam(param);
                        }
                    } else {
                        byte[] bytes = FMHelper.decode((byte[])paramValue.getBytes());
                        this._filterUI.setParam(CommonUtil.getObject((byte[])bytes));
                    }
                }
                this.isFirstLoad = false;
            }
        } else {
            isDirectShow = (Boolean)this.getUIContext().get("isDirectShow");
            obj = null;
            if (isDirectShow != null && isDirectShow.equals(Boolean.TRUE)) {
                obj = (FilterParam)this.getUIContext().get("filterParam");
                if (this._filterUI != null) {
                    this._filterUI.onLoad();
                    this._filterUI.setParam(obj);
                }
                this.getUIContext().put("isDirectShow", null);
            } else if (!queryDialog.show()) {
                SysUtil.abort();
            }
        }
        this.clearPreQueryParams();
        BankBalanceAdjFilterParam param = (BankBalanceAdjFilterParam)this._filterUI.getParam();
        if (this.condition == null) {
            this.condition = new BankBalanceCondition();
        }
        CompanyOrgUnitInfo tmpCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(param.getCompanyId()));
        this.condition.setCompanyInfo(tmpCompany);
        this.condition.setBankId(param.getBankId());
        this.condition.setCurrencyId(param.getCurrencyId());
        this.condition.setPeriodId(param.getPeriodId());
        this.bankPK = new ObjectUuidPK(param.getBankId());
        this.periodPK = new ObjectUuidPK(param.getPeriodId());
        this.currencyPK = new ObjectUuidPK(param.getCurrencyId());
        if (this._filterUI.prmtBankAccount.getValue() != null) {
            this.bankInfo = (AccountBankInfo)this._filterUI.prmtBankAccount.getValue();
        }
        this.bankInfo = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankInfo)this.bankInfo, null, (String)param.getAcctTableId());
        if (this._filterUI.comboCurrency.getSelectedItem() != null) {
            this.currencyInfo = (CurrencyInfo)this._filterUI.comboCurrency.getSelectedItem();
        }
        this.periodInfo = param.getPeriodInfo();
        this._bInitial = false;
        this.generateReport();
    }

    protected boolean isNewQuerySolution(CustomerParams cp) {
        return cp.getCustomerParam(QuerySolutionConvert.FM_NEW_QUERY_SULUTION) != null;
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.generateReport();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        map.put("Bank", this.txtBank.getText());
        map.put("Currency", this.txtCurrency.getText());
        map.put("BankAccount", this.txtBankAccount.getText());
        map.put("Period", this.txtPeriod.getText());
        map.put("JornalAmount", this.txtJornalAmount.getText());
        map.put("BankGot", this.txtBankGot.getText());
        map.put("BankPayed", this.txtBankPayed.getText());
        map.put("AdjustedJournalAmount", this.txtAdjustedJournalAmount.getText());
        map.put("StatmntAmount", this.txtStatmntAmount.getText());
        map.put("EntprGot", this.txtEntprGot.getText());
        map.put("EntprPayed", this.txtEntprPayed.getText());
        map.put("AdjustedStatmntAmount", this.txtAdjustedStatmntAmount.getText());
        map.put("CurrencyUser", ContextHelperFactory.getRemoteInstance().getCurrentUser().getName());
        return map;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tbl;
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        class MyExtVarProvider
        implements ExtVarProvider {
            Map varMap = null;

            MyExtVarProvider() {
                this.initVarMap();
            }

            private void initVarMap() {
                this.varMap = BankBalanceAdjustmentUI.this.preparePrintVariantMap();
            }

            public Variant requestVarData(String varName) {
                if (BankBalanceAdjustmentUI.this.shouldReloadPrintVar) {
                    this.initVarMap();
                }
                if (this.varMap == null) {
                    return null;
                }
                Object obj = this.varMap.get(varName);
                if (!(obj instanceof Variant)) {
                    Variant v = new Variant();
                    v.setObject(obj);
                    return v;
                }
                return (Variant)obj;
            }
        }
        return new MyExtVarProvider();
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        UserDefineColumnCollection udcc = this.getUserDefineColumnCollection();
        BankBalanceAdjustmentDataProvider data = new BankBalanceAdjustmentDataProvider(this.getKDTable(), udcc);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print(CASH_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPrintPreView_actionPerformed(ActionEvent e) throws Exception {
        UserDefineColumnCollection udcc = this.getUserDefineColumnCollection();
        BankBalanceAdjustmentDataProvider data = new BankBalanceAdjustmentDataProvider(this.getKDTable(), udcc);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview(CASH_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    private Map getKDTable() {
        HashMap<String, KDTable> hm = new HashMap<String, KDTable>();
        hm.put("entprUnreachedDetails", this.tblEntprUnreachedDetails);
        hm.put("bankUnreachedDetails", this.tblBankUnreachedDetails);
        return hm;
    }

    private UserDefineColumnCollection getUserDefineColumnCollection() {
        UserDefineColumnCollection udcc = new UserDefineColumnCollection();
        this.getInfoCommon(udcc);
        this.getInfoEntBankJounral(udcc);
        this.getInfoBankStatmnt(udcc);
        return udcc;
    }

    private void getInfoBankStatmnt(UserDefineColumnCollection udcc) {
        UserDefineColumnInfo info = null;
        TitledBorder tb = (TitledBorder)this.kdPaneBankStatmnt.getBorder();
        String title = tb.getTitle() + ".";
        info = new UserDefineColumnInfo();
        info.setName("statmntAmount");
        info.setDescription(title + this.lblStatmntAmount.getBoundLabelText());
        info.setAlias(title + this.lblStatmntAmount.getBoundLabelText());
        info.setColumnValue(this.txtStatmntAmount.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("entprGot");
        info.setDescription(title + this.lblEntprGot.getBoundLabelText());
        info.setAlias(title + this.lblEntprGot.getBoundLabelText());
        info.setColumnValue(this.txtEntprGot.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("entprPayed");
        info.setDescription(title + this.lblEntprPayed.getBoundLabelText());
        info.setAlias(title + this.lblEntprPayed.getBoundLabelText());
        info.setColumnValue(this.txtEntprPayed.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("adjustedStatmntAmount");
        info.setDescription(title + this.lblAdjustedStatmntAmount.getBoundLabelText());
        info.setAlias(title + this.lblAdjustedStatmntAmount.getBoundLabelText());
        info.setColumnValue(this.txtAdjustedStatmntAmount.getText());
        udcc.add((Object)info);
    }

    private void getInfoEntBankJounral(UserDefineColumnCollection udcc) {
        UserDefineColumnInfo info = null;
        TitledBorder tb = (TitledBorder)this.kdPaneJournal.getBorder();
        String title = tb.getTitle() + ".";
        info = new UserDefineColumnInfo();
        info.setName("jornalAmount");
        info.setDescription(title + this.lblJournalAmount.getBoundLabelText());
        info.setAlias(title + this.lblJournalAmount.getBoundLabelText());
        info.setColumnValue(this.txtJornalAmount.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankGot");
        info.setDescription(title + this.lblBankGot.getBoundLabelText());
        info.setAlias(title + this.lblBankGot.getBoundLabelText());
        info.setColumnValue(this.txtBankGot.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankPayed");
        info.setDescription(title + this.lblBankPayed.getBoundLabelText());
        info.setAlias(title + this.lblBankPayed.getBoundLabelText());
        info.setColumnValue(this.txtBankPayed.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("adjustedJournalAmount");
        info.setDescription(title + this.lblAdjustedJournalAmount.getBoundLabelText());
        info.setAlias(title + this.lblAdjustedJournalAmount.getBoundLabelText());
        info.setColumnValue(this.txtAdjustedJournalAmount.getText());
        udcc.add((Object)info);
    }

    private void getInfoCommon(UserDefineColumnCollection udcc) {
        UserDefineColumnInfo info = null;
        info = new UserDefineColumnInfo();
        info.setName("bankAccount");
        info.setDescription(this.lblBank.getBoundLabelText());
        info.setAlias(this.lblBank.getBoundLabelText());
        info.setColumnValue(this.txtBank.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankAccountNumber");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"257_BankBalanceAdjustmentUI"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"257_BankBalanceAdjustmentUI"));
        info.setColumnValue(this.bankInfo.getBankAccountNumber());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("currency");
        info.setDescription(this.lblCurrency.getBoundLabelText());
        info.setAlias(this.lblCurrency.getBoundLabelText());
        info.setColumnValue(this.txtCurrency.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankAccountView");
        info.setDescription(this.lblBankAccount.getBoundLabelText());
        info.setAlias(this.lblBankAccount.getBoundLabelText());
        info.setColumnValue(this.txtBankAccount.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("intTerm");
        info.setDescription(this.lblPeriod.getBoundLabelText());
        info.setAlias(this.lblPeriod.getBoundLabelText());
        info.setColumnValue(this.txtPeriod.getText());
        udcc.add((Object)info);
    }

    public IUIObject getInstance(Map uiContext) {
        int type = -1;
        if (this.paramMap.get(CS018) == null) {
            BOSUuid orgPK = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getId();
            type = ContextHelperFactory.getRemoteInstance().getIntParam(CS018, (IObjectPK)new ObjectUuidPK(orgPK));
        } else {
            type = (Integer)this.paramMap.get(CS018);
        }
        if (type == 1) {
            try {
                return new BankBalanceAdjustmentBUI();
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }
        return super.getInstance(uiContext);
    }

    private void prepare() {
        if (this.getUIContext().get("filterParam") instanceof BankBalanceAdjFilterParam) {
            BankBalanceAdjFilterParam param = (BankBalanceAdjFilterParam)this.getUIContext().get("filterParam");
            String companyId = param.getCompanyId();
            this.paramMap.put("paramCompanyID", companyId);
        }
        this.paramMap.put(CS018, new Integer(-1));
        try {
            this.paramMap = BankBalanceAdjustmentUIFacadeFactory.getRemoteInstance().fetchData(this.paramMap);
        }
        catch (Exception e) {
            logger.error((Object)e);
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort((Throwable)e);
        }
    }

    protected Set getOrderColumns(KDTable table) {
        HashSet<String> colSet = new HashSet<String>();
        if (table == null) {
            return colSet;
        }
        if (table.equals(this.tblEntprUnreachedDetails)) {
            colSet.add("createDate");
            colSet.add("settleNumber");
        }
        if (table.equals(this.tblBankUnreachedDetails)) {
            colSet.add("createDate");
            colSet.add("voucherNumber");
            colSet.add("settlementNumber");
        }
        return colSet;
    }

    @Override
    protected void tblBankUnreachedDetails_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            this.OrderByForTable(this.tblBankUnreachedDetails, e);
            return;
        }
    }

    @Override
    protected void tblEntprUnreachedDetails_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 1) {
            this.OrderByForTable(this.tblEntprUnreachedDetails, e);
            return;
        }
    }

    protected boolean isCanOrderTable() {
        return true;
    }

    private void OrderByForTable(KDTable table, KDTMouseEvent e) throws Exception {
        if (!this.isCanOrderTable()) {
            return;
        }
        if (e.getType() == 0) {
            String columnName = table.getColumn(e.getColIndex()).getKey();
            table.getColumn(e.getColIndex()).setSortable(true);
            Set colSet = this.getOrderColumns(table);
            if (!colSet.contains(columnName)) {
                return;
            }
            if (table != null && table == this.tblBankUnreachedDetails) {
                if (this.isFristSort_Bank) {
                    this.sm_Bank = new KDTSortManager(table);
                    this.isFristSort_Bank = false;
                }
                this.sort_Bank = this.sort_Bank == 0 ? 1 : 0;
                this.sm_Bank.setSortAuto(true);
                this.sm_Bank.sort(e.getColIndex(), this.sort_Bank);
                table.repaint();
                this.sm_Bank.setSortAuto(false);
            }
            if (table != null && table == this.tblEntprUnreachedDetails) {
                if (this.isFristSort_Entp) {
                    this.sm_Entp = new KDTSortManager(table);
                    this.isFristSort_Entp = false;
                }
                this.sort_Entp = this.sort_Entp == 0 ? 1 : 0;
                this.sm_Entp.setSortAuto(true);
                this.sm_Entp.sort(e.getColIndex(), this.sort_Entp);
                table.repaint();
                this.sm_Entp.setSortAuto(false);
            }
        }
    }
}

