/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BankJournalFetchParamFacadeFactory;
import com.kingdee.eas.fi.cas.CashAccountTool;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.client.AbstractBankJournalFilterUI;
import com.kingdee.eas.fi.cas.client.BankJournalFilterParam;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.ISharedOrgSupport;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.sql.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class BankJournalFilterUI
extends AbstractBankJournalFilterUI
implements ISharedOrgSupport {
    private static Logger logger = Logger.getLogger((String)BankJournalFilterUI.class.getName());
    public static final String RESOURCEPATH = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    PeriodInfo currentPeriod = CashClientHelper.getCurrentPeriod(this.companyInfo);
    String actualAcctTableId = null;
    private Map paramMap;
    private Map verifyMap;
    private boolean isSharedOrg = false;

    public BankJournalFilterUI(Map paramMap1) throws Exception {
        this.paramMap = paramMap1;
        this.initStartPeriod(this.paramMap);
    }

    protected void initStartPeriod(Map paramMap) throws Exception {
        PeriodCollection colls = PeriodHelper.getPeriodc(this.currentCompany);
        PeriodInfo startPeriod = (PeriodInfo)paramMap.get("startPeriod");
        PeriodInfo currentPeriod = (PeriodInfo)paramMap.get("currentPeriod");
        PeriodInfo tempPeriod = colls.get(0);
        for (int index = 0; index < colls.size(); ++index) {
            PeriodInfo period = colls.get(index);
            if (!PeriodUtils.PeriodCompare((PeriodInfo)tempPeriod, (PeriodInfo)period)) continue;
            tempPeriod = period;
        }
        if (EmptyUtil.isEmpty(paramMap.get("currentCompany"))) {
            paramMap.put("currentCompany", this.currentCompany);
        }
        if (!EmptyUtil.isEmpty((CoreBaseInfo)startPeriod) && !EmptyUtil.isEmpty((CoreBaseInfo)currentPeriod)) {
            if (PeriodUtils.PeriodCompare((PeriodInfo)tempPeriod, (PeriodInfo)startPeriod)) {
                startPeriod = tempPeriod;
            }
            if (PeriodUtils.PeriodCompare((PeriodInfo)startPeriod, (PeriodInfo)currentPeriod)) {
                currentPeriod = startPeriod;
            }
        }
        paramMap.put("startPeriod", startPeriod);
        paramMap.put("currentPeriod", currentPeriod);
    }

    @Override
    protected void btnByPeriod_stateChanged(ChangeEvent e) throws Exception {
        this.pnlByDate.setVisible(false);
        this.pnlByPeriod.setVisible(false);
        if (this.btnByPeriod.isSelected()) {
            this.pnlByPeriod.setVisible(true);
        } else {
            this.pnlByDate.setVisible(true);
        }
    }

    @Override
    public Object getParam() {
        BankJournalFilterParam para = new BankJournalFilterParam();
        para.setToDate(this.dtpToDate.getSqlDate());
        para.setFromDate(this.dtpFromDate.getSqlDate());
        para.setShowCancelAccount(this.chkIsShowCancleAccount.isSelected());
        para.setShowBeginBalance(this.chkIsShowBeginBalance.isSelected());
        para.setShowDayTotal(this.chkIsShowDayTotal.isSelected());
        para.setShowMonthTotal(this.chkIsShowMonthTotal.isSelected());
        para.setShowYearTotal(this.chkIsShowYearTotal.isSelected());
        para.setByDay(this.btnByDate.isSelected());
        if (AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth) == -1) {
            para.setBeginMonth(this.getCurrentPeriodNumber());
        } else {
            para.setBeginMonth(AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth));
        }
        if (AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth) == -1) {
            para.setEndMonth(this.getCurrentPeriodNumber());
        } else {
            para.setEndMonth(AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth));
        }
        para.setBeginYear(AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear));
        para.setEndYear(AccessHelper.getSpiValue((KDSpinner)this.spiEndYear));
        if (this.actualAcctTableId == null) {
            this.getAcctTableID();
        }
        para.setAcctTableId(this.actualAcctTableId);
        para.setCompanyId(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString());
        if (this.prmtAccountBank.getData() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fm.be.beResourse", (String)"CheckAccountBank"));
            SysUtil.abort();
        }
        para.setAccountBankId(((AccountBankInfo)this.prmtAccountBank.getData()).getId().toString());
        return para;
    }

    protected void init() throws Exception {
        this.companyInfo = (CompanyOrgUnitInfo)this.paramMap.get("currentCompany");
        if (!this.companyInfo.isIsBizUnit()) {
            return;
        }
        PeriodEntity pe = new PeriodEntity(CashManagementFactory.getRemoteInstance().getPeriodRange(this.companyInfo, SystemEnum.CASHMANAGEMENT));
        SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth, (boolean)false, (boolean)false);
        if (this.paramMap.get("currentCompany") == null && this.paramMap.get("currentPeriod") == null && this.paramMap.get("startPeriod") == null) {
            PeriodHelper.initPeriodSpinner(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
        } else {
            PeriodHelper.initPeriodSpinner((CompanyOrgUnitInfo)this.paramMap.get("currentCompany"), (PeriodInfo)this.paramMap.get("currentPeriod"), (PeriodInfo)this.paramMap.get("startPeriod"), this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
            CompanyOrgUnitCollection orgRang = (CompanyOrgUnitCollection)this.paramMap.get("UserOrgRanges");
            for (int i = 0; i < orgRang.size(); ++i) {
                CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)orgRang.getObject(i);
                if (!company.isIsBizUnit() || company.isIsOUSealUp() || company.isIsAssistantOrg()) continue;
                this.prmtCompany.setValue((Object)company);
                break;
            }
        } else {
            this.prmtCompany.setValue((Object)this.currentCompany);
        }
        PeriodInfo period = (PeriodInfo)this.paramMap.get("currentPeriod");
        this.spiBeginYear.setValue((Object)new Integer(period.getPeriodYear()));
        this.spiBeginMonth.setValue((Object)new Integer(period.getPeriodNumber()));
        this.spiEndYear.setValue((Object)new Integer(period.getPeriodYear()));
        this.spiEndMonth.setValue((Object)new Integer(period.getPeriodNumber()));
        CashHelper.setBankF7(this.prmtAccountBank, this.companyInfo, this.chkIsShowCancleAccount.isSelected());
    }

    public void clear() {
        block7: {
            super.clear();
            try {
                if (this.currentCompany != null && this.currentCompany.isIsBizUnit()) {
                    PeriodHelper.initPeriodSpinner((CompanyOrgUnitInfo)this.paramMap.get("currentCompany"), (PeriodInfo)this.paramMap.get("currentPeriod"), (PeriodInfo)this.paramMap.get("startPeriod"), this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
                }
                this.dtpToDate.setValue((Object)DateHelper.getDayBegin());
                this.dtpFromDate.setValue((Object)DateHelper.getDayBegin());
                this.btnByDate.setSelected(true);
                this.btnByPeriod.setSelected(true);
                this.chkIsShowForbiddenAccount.setSelected(false);
                this.chkIsShowCancleAccount.setSelected(false);
                this.chkIsShowBeginBalance.setSelected(true);
                this.chkIsShowDayTotal.setSelected(true);
                this.chkIsShowMonthTotal.setSelected(true);
                this.chkIsShowYearTotal.setSelected(true);
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
                    CompanyOrgUnitCollection orgRang = (CompanyOrgUnitCollection)this.paramMap.get("UserOrgRanges");
                    for (int i = 0; i < orgRang.size(); ++i) {
                        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)orgRang.getObject(i);
                        if (!company.isIsBizUnit() || company.isIsOUSealUp() || company.isIsAssistantOrg()) continue;
                        this.prmtCompany.setValue((Object)company);
                        break block7;
                    }
                    break block7;
                }
                this.prmtCompany.setValue((Object)ContextHelperFactory.getRemoteInstance().getCurrentCompany());
            }
            catch (NumberFormatException e) {
                logger.error((Object)e);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
    }

    @Override
    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        BankJournalFilterParam filterParam = (BankJournalFilterParam)param;
        this.dtpToDate.setValue((Object)filterParam.getToDate());
        this.dtpFromDate.setValue((Object)filterParam.getFromDate());
        this.btnByDate.setSelected(filterParam.isByDay());
        this.btnByPeriod.setSelected(!filterParam.isByDay());
        this.spiBeginYear.setValue((Object)new Integer(filterParam.getBeginYear()));
        this.spiBeginMonth.setValue((Object)new Integer(filterParam.getBeginMonth()));
        this.spiEndYear.setValue((Object)new Integer(filterParam.getEndYear()));
        this.spiEndMonth.setValue((Object)new Integer(filterParam.getEndMonth()));
        this.chkIsShowCancleAccount.setSelected(filterParam.isShowCancelAccount());
        this.chkIsShowBeginBalance.setSelected(filterParam.isShowBeginBalance());
        this.chkIsShowDayTotal.setSelected(filterParam.isShowDayTotal());
        this.chkIsShowMonthTotal.setSelected(filterParam.isShowMonthTotal());
        this.chkIsShowYearTotal.setSelected(filterParam.isShowYearTotal());
        try {
            if (!EmptyUtil.isEmpty((String)filterParam.getCompanyId())) {
                this.companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(filterParam.getCompanyId()));
            }
            this.prmtCompany.setValue((Object)this.companyInfo);
            if (!EmptyUtil.isEmpty((String)filterParam.getAccountBankId())) {
                AccountBankInfo accountBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(filterParam.getAccountBankId()));
                this.prmtAccountBank.setValue((Object)accountBankInfo);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean verify() {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        CashClientHelper.verifyEmpty((CoreUIObject)this, RESOURCEPATH, this.dtpToDate, "cm63");
        CashClientHelper.verifyEmpty((CoreUIObject)this, RESOURCEPATH, this.dtpFromDate, "cm63");
        if (this.btnByPeriod.isSelected()) {
            if (AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear) * 100 + AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth) > AccessHelper.getSpiValue((KDSpinner)this.spiEndYear) * 100 + AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth)) {
                this.spiBeginYear.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"EndPeriodBeforeBeginPeriod"));
                SysUtil.abort();
            }
        } else {
            if (DateTimeUtils.truncateDate((java.util.Date)this.dtpToDate.getSqlDate()).before(DateTimeUtils.truncateDate((java.util.Date)this.dtpFromDate.getSqlDate()))) {
                this.dtpFromDate.requestFocus(true);
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"EndDateBeforeBeginDate"));
                SysUtil.abort();
            }
            try {
                PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)this.prmtCompany.getValue()));
                if (DateTimeUtils.truncateDate((java.util.Date)this.dtpToDate.getSqlDate()).before(startPeriod.getBeginDate())) {
                    this.dtpToDate.requestFocus(true);
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"EndDateBeforeStartPeriod"));
                    SysUtil.abort();
                }
                java.util.Date startDate = this.dtpFromDate.getSqlDate();
                Date endDate = this.dtpToDate.getSqlDate();
                if (DateTimeUtils.dayBefore((java.util.Date)startDate, (java.util.Date)startPeriod.getBeginDate())) {
                    startDate = new java.util.Date(startPeriod.getBeginDate().getTime());
                    this.dtpFromDate.setValue((Object)startDate);
                }
                if (DateTimeUtils.dayBefore((java.util.Date)endDate, (java.util.Date)startDate)) {
                    this.dtpToDate.setValue((Object)startDate);
                }
            }
            catch (Exception e) {
                SysUtil.abort();
            }
        }
        boolean beginYear = false;
        boolean beginMonth = false;
        boolean endYear = false;
        boolean endMonth = false;
        this.verifyMap = new HashMap();
        this.verifyMap.put("btnByPeriod", this.btnByPeriod.isSelected());
        this.verifyMap.put("beginYear", (Integer)this.spiBeginYear.getValue());
        this.verifyMap.put("endYear", (Integer)this.spiEndYear.getValue());
        this.verifyMap.put("beginPeriod", (Integer)this.spiBeginMonth.getValue());
        this.verifyMap.put("endPeriod", (Integer)this.spiEndMonth.getValue());
        this.verifyMap.put("btnByDate", this.btnByDate.isSelected());
        this.verifyMap.put("dateFrom", DateTimeUtils.truncateDate((java.util.Date)this.dtpFromDate.getSqlDate()));
        this.verifyMap.put("dateTo", DateTimeUtils.truncateDate((java.util.Date)this.dtpToDate.getSqlDate()));
        this.verifyMap.put("company", this.prmtCompany.getValue());
        try {
            this.verifyMap = BankJournalFetchParamFacadeFactory.getRemoteInstance().fetchParamForFilterUIVerify(this.verifyMap);
        }
        catch (EASBizException e) {
            this.handUIException(e);
            e.printStackTrace();
        }
        catch (BOSException e) {
            this.handUIException(e);
            e.printStackTrace();
        }
        this.getAcctTableID();
        this.paramMap.put("actualAcctTableId", this.verifyMap.get("actualAcctTableId"));
        this.paramMap.put("beginPeriodParam", this.verifyMap.get("beginPeriodParam"));
        this.paramMap.put("endPeriodParam", this.verifyMap.get("endPeriodParam"));
        return true;
    }

    private void getAcctTableID() {
        if (this.btnByPeriod.isSelected()) {
            int beginYear = AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear);
            int beginMonth = AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth);
            int endYear = AccessHelper.getSpiValue((KDSpinner)this.spiEndYear);
            int endMonth = AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth);
            try {
                String company = null;
                if (this.prmtCompany.getValue() != null) {
                    company = ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString();
                }
                this.actualAcctTableId = CashAccountTool.getDisplayAcctTable(company, null, beginYear, beginMonth, endYear, endMonth);
            }
            catch (EASBizException e) {
                this.handUIException(e);
                e.printStackTrace();
            }
            catch (BOSException e) {
                this.handUIException(e);
                e.printStackTrace();
            }
        }
        if (this.btnByDate.isSelected()) {
            java.util.Date beginDate = DateTimeUtils.truncateDate((java.util.Date)this.dtpFromDate.getSqlDate());
            java.util.Date endDate = DateTimeUtils.truncateDate((java.util.Date)this.dtpToDate.getSqlDate());
            String company = null;
            if (this.prmtCompany.getValue() != null) {
                company = ((CompanyOrgUnitInfo)this.prmtCompany.getValue()).getId().toString();
            }
            this.actualAcctTableId = FMClientHelper.getActualAcctTable(company, (java.util.Date)beginDate, (java.util.Date)endDate);
        }
    }

    public int getCurrentPeriodNumber() {
        int periodNumber = 1;
        try {
            periodNumber = CashClientHelper.getCurrentPeriod(this.companyInfo).getPeriodNumber();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return periodNumber;
    }

    protected Class getParamClass() {
        return BankJournalFilterParam.class;
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public String getPermissionItem() {
        return "cas_bankbook_01view";
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        block5: {
            super.afterMainOrgChanged(chgVo);
            if (null == chgVo.getNewOrg()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"436_BankJournalFilterUI"));
                SysUtil.abort();
            }
            this.currentCompany = (CompanyOrgUnitInfo)chgVo.getNewOrg();
            try {
                PeriodHelper.initPeriodSpinner((CompanyOrgUnitInfo)this.paramMap.get("currentCompany"), (PeriodInfo)this.paramMap.get("currentPeriod"), (PeriodInfo)this.paramMap.get("startPeriod"), this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.currentCompany)) {
                    CompanyOrgUnitCollection orgRang = (CompanyOrgUnitCollection)this.paramMap.get("UserOrgRanges");
                    for (int i = 0; i < orgRang.size(); ++i) {
                        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)orgRang.getObject(i);
                        if (!company.isIsBizUnit() || company.isIsOUSealUp() || company.isIsAssistantOrg()) continue;
                        this.prmtCompany.setValue((Object)company);
                        break block5;
                    }
                    break block5;
                }
                this.prmtCompany.setValue((Object)this.currentCompany);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
    }

    public boolean isSupportMultiOrgs() {
        this.prmtCompany.setEnabled(this.isSharedOrg());
        return false;
    }

    @Override
    public void setIsSharedOrg(boolean value) {
        this.isSharedOrg = value;
    }

    @Override
    public boolean isSharedOrg() {
        return this.isSharedOrg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CustomerParams getCustomerParams() {
        Object param = this.getParam();
        if (param == null) {
            throw new RuntimeException(EASResource.getString((String)"com.kingdee.eas.fm.common.COMMONAutoGenerateResource", (String)"138_FMFilterBaseUI"));
        }
        CustomerParams cp = new CustomerParams();
        ObjectOutputStream objectOs = null;
        try {
            ByteOutputStream byteOs = new ByteOutputStream();
            objectOs = new ObjectOutputStream((OutputStream)byteOs);
            objectOs.writeObject(param);
            byte[] bytes = byteOs.getBytes();
            String paramValue = new String(FMHelper.encode((byte[])bytes));
            cp.addCustomerParam("fmcustomer", paramValue);
            FMHelper.close((ObjectOutputStream)objectOs);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        finally {
            FMHelper.close(objectOs);
        }
        return cp;
    }

    @Override
    protected void chkIsShowCancleAccount_actionPerformed(ActionEvent e) throws Exception {
        CashHelper.setBankF7(this.prmtAccountBank, this.companyInfo, this.chkIsShowCancleAccount.isSelected());
    }
}

