/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctFactory;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashManagementCashMethod;
import com.kingdee.eas.fi.cas.CashManagementCashMethodParam;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.client.BankJournalFilterParam;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.JournalHandler;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankJournalHandler
extends JournalHandler {
    private Logger logger = Logger.getLogger(this.getClass());
    private static final String COL_SETTNUMBER = "settNumber";
    private static final String COL_SETTTYPE = "settType";
    public static final String resourcePath = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    private static final String BEGIN_BALANCE = EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"BeginBalance");
    private boolean isHide = true;

    public AccountViewCollection getBankAcct(CompanyOrgUnitInfo company, boolean isFreeze) {
        AccountViewCollection bankAcct = null;
        try {
            bankAcct = FMHelper.getAcctViewCollection((String)company.getId().toString(), null, (AccountTypeEnum)AccountTypeEnum.BANKACCOUNT);
        }
        catch (BOSException e) {
            this.logger.error((Object)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            this.logger.error((Object)e);
            SysUtil.abort();
        }
        return bankAcct;
    }

    public AccountBankCollection getAccountBank(CompanyOrgUnitInfo company) {
        AccountBankCollection accountBank = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)company.getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)Constants.TRUE));
            filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)FMConstants.FALSE));
            try {
                ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
                ObjectUuidPK orgPK = new ObjectUuidPK(company.getId().toString());
                String sql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
                if (!EmptyUtil.isEmpty((String)sql.trim())) {
                    filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
                }
            }
            catch (Exception e) {
                this.logger.info((Object)e);
            }
            view.setFilter(filter);
            view.getSorter().add(new SorterItemInfo("bankaccountnumber"));
            accountBank = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        }
        catch (BOSException e) {
            this.logger.error((Object)e);
        }
        return accountBank;
    }

    public void initCombAccountBank(KDComboBox cboBankAcct, CompanyOrgUnitInfo company) {
        cboBankAcct.removeAllItems();
        AccountBankCollection accountBankCollection = this.getAccountBank(company);
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)accountBankCollection)) {
            cboBankAcct.addItems(accountBankCollection.toArray());
        }
    }

    public void initCombAccountBank(KDComboBox cboBankAcct, String companyId, String acctTableId, boolean isIncludeClosed) throws BOSException {
        ActionListener[] actionListener = cboBankAcct.getActionListeners();
        for (int i = 0; i < actionListener.length; ++i) {
            cboBankAcct.removeActionListener(actionListener[i]);
        }
        cboBankAcct.removeAllItems();
        AccountBankCollection acctBankCol = CashClientHelper.getAccountBankCollection(companyId, isIncludeClosed);
        if (!EmptyUtil.isEmpty((String)acctTableId)) {
            acctBankCol = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankCollection)acctBankCol, null, (String)acctTableId);
        }
        cboBankAcct.addItems(acctBankCol.toArray());
        for (int i = 0; i < actionListener.length; ++i) {
            cboBankAcct.addActionListener(actionListener[i]);
        }
    }

    public void initCombAccountBank(KDComboBox cboBankAcct, String companyId, String acctTableId, boolean isIncludeClosed, AccountBankCollection col) throws BOSException {
        if (col != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                col.get(i).setDisplayFormat("$number$ - $name$");
            }
        }
        ActionListener[] actionListener = cboBankAcct.getActionListeners();
        for (int i = 0; i < actionListener.length; ++i) {
            cboBankAcct.removeActionListener(actionListener[i]);
        }
        cboBankAcct.removeAllItems();
        AccountBankCollection acctBankCol = null;
        acctBankCol = col == null ? CashClientHelper.getAccountBankCollection(companyId, isIncludeClosed) : this.getCol(col, isIncludeClosed);
        if (!EmptyUtil.isEmpty((String)acctTableId)) {
            acctBankCol = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankCollection)acctBankCol, null, (String)acctTableId);
        }
        cboBankAcct.addItems(acctBankCol.toArray());
        for (int i = 0; i < actionListener.length; ++i) {
            cboBankAcct.addActionListener(actionListener[i]);
        }
    }

    private AccountBankCollection getCol(AccountBankCollection col, boolean isIncludeClosed) {
        AccountBankCollection acctBankColReturn = null;
        if (isIncludeClosed) {
            acctBankColReturn = col;
        } else {
            acctBankColReturn = new AccountBankCollection();
            for (int i = 0; i < col.size(); ++i) {
                AccountBankInfo info = col.get(i);
                if (info.isIsClosed()) continue;
                acctBankColReturn.add(info);
            }
        }
        return acctBankColReturn;
    }

    public IRowSet getRowset(IMetaDataPK mainQueryPK, EntityViewInfo mainQuery, String currencyId, Set accountBankSet, Set accountSet, Set cashierIDSet, BankJournalFilterParam p) throws BOSException {
        EntityViewInfo mainQueryTemp = new EntityViewInfo();
        mainQueryTemp = (EntityViewInfo)mainQuery.clone();
        FilterInfo filterHead = new FilterInfo();
        filterHead.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        filterHead.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)accountBankSet, CompareType.INCLUDE));
        filterHead.getFilterItems().add(new FilterItemInfo("accountView.id", (Object)accountSet, CompareType.INCLUDE));
        if (cashierIDSet != null && cashierIDSet.size() != 0) {
            filterHead.getFilterItems().add(new FilterItemInfo("cashier.id", (Object)cashierIDSet, CompareType.INCLUDE));
        }
        mainQueryTemp.getFilter().mergeFilter(filterHead, "AND");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        EntityViewInfo ev = (EntityViewInfo)mainQueryTemp.clone();
        ev.getSorter().add(new SorterItemInfo("createTime"));
        ev.getSorter().add(new SorterItemInfo("lineNo"));
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        String sql = exec.getSQL();
        this.logger.info((Object)sql);
        return rs;
    }

    protected void fillOneJournalRow(KDTable tblMain, IRowSet rs, BigDecimal exchange, boolean isCurEqualsBasecur, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, ConvertModeEnum convertMode, BalanceDirectionEnum dc) throws SQLException {
        IRow row = tblMain.addRow();
        row.getCell("id").setValue((Object)rs.getString("ID"));
        row.getCell("company").setValue((Object)rs.getString("company.name"));
        row.getCell("bizDate").setValue((Object)Constants.FORMAT_DAY.format(rs.getDate("bizDate")));
        row.getCell("createDate").setValue((Object)Constants.FORMAT_DAY.format(rs.getDate("createDate")));
        row.getCell("voucherType").setValue((Object)rs.getString("voucherType"));
        row.getCell("voucherNumber").setValue((Object)rs.getString("voucherNumber"));
        String oppAccount = rs.getString("oppAccountViewNumber");
        if (oppAccount != null) {
            oppAccount = oppAccount + " " + rs.getString("oppAccountViewName");
        }
        row.getCell("oppAccountNumber").setValue((Object)oppAccount);
        row.getCell("billType").setValue((Object)BillTypeEnum.getEnum(rs.getInt("billType")));
        row.getCell("billNumber").setValue((Object)rs.getString("billNumber"));
        row.getCell("description").setValue((Object)rs.getString("description"));
        row.getCell(COL_SETTTYPE).setValue((Object)rs.getString("settlementType"));
        row.getCell(COL_SETTNUMBER).setValue((Object)rs.getString("settlementNumber"));
        if (debitAmt.compareTo(CasConstants.ZERO) != 0) {
            row.getCell("debit").setValue((Object)debitAmt);
        }
        if (creditAmt.compareTo(CasConstants.ZERO) != 0) {
            row.getCell("credit").setValue((Object)creditAmt);
        }
        row.getCell("balance").setValue((Object)balance.abs());
        row.getCell("exchange").setValue((Object)exchange);
        row.getCell("source").setValue((Object)JournalSourceEnum.getEnum((int)rs.getInt("source")));
        row.getCell("periodYear").setValue(rs.getObject("periodYear"));
        row.getCell("periodNumber").setValue(rs.getObject("periodNumber"));
        row.getCell("cash").setValue((Object)rs.getString("cashier"));
        row.getCell("oppUnit").setValue((Object)rs.getString("oppUnit"));
        row.getCell("oppAcctNumber").setValue((Object)rs.getString("oppAcctNumber"));
        row.getCell("oppBank").setValue((Object)rs.getString("oppBank"));
        row.getCell("batchNo").setValue((Object)rs.getString("batchNo"));
        VerifyScopeEnum verifyScope = VerifyScopeEnum.getEnum((int)rs.getInt("verifyStatus"));
        if (verifyScope.equals((Object)VerifyScopeEnum.NOVA)) {
            row.getCell("verify").setValue((Object)Boolean.FALSE);
        } else {
            row.getCell("verify").setValue((Object)Boolean.TRUE);
        }
        this.fillLocalCurrencyData(row, exchange, debitAmt, creditAmt, balance, isCurEqualsBasecur, convertMode, dc);
    }

    public void fillData_New(KDTable tblMain, IRowSet rs, CurrencyInfo sourceCurrency, String accountBankNumber, String accountBankId, String accountNumber, BankJournalFilterParam para, CashDataSourceEnum type, Map paramMap, Set cashierIDSet, BalanceDirectionEnum dc, boolean chkMulUnionQuery) throws SQLException, EASBizException, BOSException {
        PeriodInfo cPeriod;
        BigDecimal exchange;
        Timestamp tempDate;
        PeriodInfo period;
        BigDecimal exchange2;
        PeriodInfo Period;
        int endPeriod;
        int endYear;
        int beginPeriod;
        int beginYear;
        java.util.Date beginDate;
        boolean isShowBeginBalance = para.isShowBeginBalance();
        boolean isShowDayTotal = para.isShowDayTotal();
        boolean isShowPeriodTotal = para.isShowMonthTotal();
        boolean isShowYearTotal = para.isShowYearTotal();
        PeriodInfo beginPeriodInfo = null;
        PeriodInfo endPeriodInfo = null;
        String currencyNumber = sourceCurrency.getNumber();
        CompanyOrgUnitInfo companyInfo = (CompanyOrgUnitInfo)paramMap.get("currentCompany");
        boolean isStart = false;
        isStart = paramMap.get("isStart") != null ? (Boolean)paramMap.get("isStart") : SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo startPeriod = PeriodHelper.getCashStartPeriod(companyInfo);
        if (startPeriod == null) {
            return;
        }
        int startPeriodYear = startPeriod.getPeriodYear();
        boolean isByDay = para.isByDay();
        if (isByDay) {
            if (para.getFromDate().before(startPeriod.getBeginDate())) {
                beginPeriodInfo = startPeriod;
                beginDate = beginPeriodInfo.getBeginDate();
            } else {
                beginPeriodInfo = PeriodHelper.getPeriodInfo(para.getFromDate(), companyInfo);
                beginDate = para.getFromDate();
            }
            if (para.getToDate().before(startPeriod.getBeginDate())) {
                return;
            }
            endPeriodInfo = PeriodHelper.getPeriodInfo(para.getToDate(), companyInfo);
            if (endPeriodInfo == null) {
                endPeriodInfo = PeriodHelper.getLastPeriodInfo(companyInfo);
            }
            beginYear = beginPeriodInfo.getPeriodYear();
            beginPeriod = beginPeriodInfo.getPeriodNumber();
            endYear = endPeriodInfo.getPeriodYear();
            endPeriod = endPeriodInfo.getPeriodNumber();
        } else {
            beginYear = para.getBeginYear();
            beginPeriod = para.getBeginMonth();
            endYear = para.getEndYear();
            endPeriod = para.getEndMonth();
            beginPeriodInfo = PeriodHelper.getPeriodInfo(beginYear, beginPeriod, companyInfo);
            if (beginPeriodInfo == null) {
                beginPeriodInfo = CashClientHelper.getStartPeriod(companyInfo);
            }
            endPeriodInfo = PeriodHelper.getPeriodInfo(endYear, endPeriod, companyInfo);
            beginDate = beginPeriodInfo.getBeginDate();
        }
        AccountTableInfo accountTable = null;
        accountTable = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(para.getAcctTableId()));
        String acctTableNumber = accountTable.getNumber();
        ConvertModeEnum convertMode = this.getExchangeConvertMode(companyInfo, sourceCurrency, null);
        boolean isCurEqualsBasecur = sourceCurrency.getId().equals((Object)companyInfo.getBaseCurrency().getId());
        boolean isShowLocalCurrency = false;
        isShowLocalCurrency = paramMap.get("isShowLocalCurrency") == null ? CashHelper.isShowLocalCurrency(companyInfo.getId().toString()) : (Boolean)paramMap.get("isShowLocalCurrency");
        BigDecimal exchange1 = CashHelper.getExchange(companyInfo, sourceCurrency, null, beginDate);
        this.isHide = true;
        this.isHide = isCurEqualsBasecur || !isShowLocalCurrency || !isCurEqualsBasecur && exchange1.compareTo(Constants.ONE) == 0;
        this.setLocalColumnHided(tblMain, this.isHide);
        IRow row = null;
        BigDecimal debitAmt = null;
        BigDecimal creditAmt = null;
        BigDecimal balance = null;
        BigDecimal tmpDayDebitTotal = CasConstants.ZERO;
        BigDecimal tmpDayCreditTotal = CasConstants.ZERO;
        BigDecimal tmpMonthDebitTotal = CasConstants.ZERO;
        BigDecimal tmpMonthCreditTotal = CasConstants.ZERO;
        BigDecimal tmpYearDebitTotal = CasConstants.ZERO;
        BigDecimal tmpYearCreditTotal = CasConstants.ZERO;
        BigDecimal yearDebitAmt = CasConstants.ZERO;
        BigDecimal yearCreditAmt = CasConstants.ZERO;
        if (isStart && beginYear == startPeriodYear) {
            yearDebitAmt = CashHelper.getYearStartAmount(type, companyInfo.getId().toString(), null, accountBankId, sourceCurrency.getId().toString(), CashDataTypeEnum.JF);
            yearCreditAmt = CashHelper.getYearStartAmount(type, companyInfo.getId().toString(), null, accountBankId, sourceCurrency.getId().toString(), CashDataTypeEnum.DF);
        }
        CashManagementCashMethod cm = new CashManagementCashMethod();
        CashManagementCashMethodParam pm6 = new CashManagementCashMethodParam(companyInfo.getNumber(), type, acctTableNumber, null, accountBankNumber, currencyNumber, beginDate, beginDate, CashDataTypeEnum.C, false, chkMulUnionQuery);
        CashManagementCashMethodParam pm7 = new CashManagementCashMethodParam(companyInfo.getNumber(), type, acctTableNumber, null, accountBankNumber, currencyNumber, startPeriod.getBeginDate(), startPeriod.getBeginDate(), CashDataTypeEnum.C, false, chkMulUnionQuery);
        CashManagementCashMethodParam pm8 = new CashManagementCashMethodParam(companyInfo.getNumber(), type, acctTableNumber, null, accountBankNumber, currencyNumber, beginDate, beginDate, CashDataTypeEnum.C, false, chkMulUnionQuery);
        cm.addParam(pm6);
        cm.addParam(pm7);
        cm.addParam(pm8);
        CashManagementCashMethodParam pm1 = new CashManagementCashMethodParam(companyInfo.getNumber(), CashDataSourceEnum.B, acctTableNumber, null, accountBankNumber, currencyNumber, beginPeriodInfo.getBeginDate(), DateHelper.getBeforeDay((java.util.Date)para.getFromDate()), CashDataTypeEnum.JF, false, chkMulUnionQuery);
        CashManagementCashMethodParam pm2 = new CashManagementCashMethodParam(companyInfo.getNumber(), CashDataSourceEnum.B, acctTableNumber, null, accountBankNumber, currencyNumber, beginPeriodInfo.getBeginDate(), DateHelper.getBeforeDay((java.util.Date)para.getFromDate()), CashDataTypeEnum.DF, false, chkMulUnionQuery);
        cm.addParam(pm1);
        cm.addParam(pm2);
        cm.fetchAllData();
        balance = isByDay ? cm.getValue(pm6) : this.getBeginBalance(companyInfo, acctTableNumber, currencyNumber, accountNumber, accountBankNumber, beginPeriodInfo, type, chkMulUnionQuery);
        BigDecimal beginYearDebitTotal = this.getYearTotal(companyInfo, acctTableNumber, currencyNumber, accountNumber, accountBankNumber, beginYear, beginPeriod, type, CashDataTypeEnum.JF, chkMulUnionQuery);
        BigDecimal beginYearCreditTotal = this.getYearTotal(companyInfo, acctTableNumber, currencyNumber, accountNumber, accountBankNumber, beginYear, beginPeriod, type, CashDataTypeEnum.DF, chkMulUnionQuery);
        ICashManagement cashInacct = CashManagementFactory.getRemoteInstance();
        BigDecimal adebitTotal = FMConstants.ZERO;
        BigDecimal acreditTotal = FMConstants.ZERO;
        if (isByDay && para.getFromDate().compareTo(beginPeriodInfo.getBeginDate()) > 0) {
            adebitTotal = cm.getValue(pm1);
            acreditTotal = cm.getValue(pm2);
            if (cashierIDSet == null) {
                tmpMonthDebitTotal = adebitTotal;
                tmpMonthCreditTotal = acreditTotal;
            }
        }
        if (beginYear == startPeriod.getPeriodYear() && beginPeriod == startPeriod.getPeriodNumber()) {
            row = tblMain.addRow();
            BigDecimal yearBeginBalance = CasConstants.ZERO;
            if (isStart) {
                if (isByDay) {
                    BigDecimal b = cm.getValue(pm7);
                    if (b == null) {
                        b = CasConstants.ZERO;
                    }
                    yearBeginBalance = b.add(yearCreditAmt).subtract(yearDebitAmt);
                } else {
                    yearBeginBalance = balance.add(yearCreditAmt).subtract(yearDebitAmt);
                }
            }
            PeriodInfo period2 = PeriodHelper.getPeriodInfo(beginYear, beginPeriod, companyInfo);
            Timestamp tempDate2 = period2.getEndDate();
            BigDecimal exchange3 = CashHelper.getExchange(companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((java.util.Date)tempDate2));
            this.fillBalance(companyInfo, beginYear, beginPeriod, row, exchange3, yearBeginBalance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc);
        }
        if (rs == null || rs.size() == 0) {
            adebitTotal = CasConstants.ZERO;
            acreditTotal = CasConstants.ZERO;
            if (beginYear == startPeriodYear) {
                tmpYearDebitTotal = beginYearDebitTotal.add(yearDebitAmt);
                tmpYearCreditTotal = beginYearCreditTotal.add(yearCreditAmt);
            } else {
                tmpYearDebitTotal = beginYearDebitTotal;
                tmpYearCreditTotal = beginYearCreditTotal;
            }
            if (isByDay && para.getFromDate().compareTo(beginPeriodInfo.getBeginDate()) > 0) {
                tmpYearDebitTotal = tmpYearDebitTotal.add(adebitTotal);
                tmpYearCreditTotal = tmpYearCreditTotal.add(acreditTotal);
            }
            if (isByDay) {
                this.fillAdjustRow_NewDay(adebitTotal, acreditTotal, tmpYearDebitTotal, tmpYearCreditTotal, tblMain, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, para.getFromDate(), para.getToDate(), sourceCurrency, dc);
            } else {
                this.fillAdjustRow_New(adebitTotal, acreditTotal, tmpYearDebitTotal, tmpYearCreditTotal, tblMain, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, sourceCurrency, dc);
            }
            return;
        }
        Date date = null;
        int year = beginYear;
        int periodNumber = beginPeriod;
        int tmpYear = beginYear;
        int tmpPeriodNumber = beginPeriod;
        java.util.Date tmpdate = null;
        if (rs.next()) {
            date = rs.getDate("createDate");
            year = rs.getInt("periodyear");
            periodNumber = rs.getInt("periodnumber");
            tmpYear = rs.getInt("periodyear");
            tmpPeriodNumber = rs.getInt("periodnumber");
            tmpdate = rs.getDate("createDate");
            rs.beforeFirst();
        }
        if (beginYear < year || beginYear == year && beginPeriod < periodNumber) {
            endPeriodInfo = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
            endPeriodInfo = PeriodHelper.getPrePeriodInfo(companyInfo, endPeriodInfo);
            if (beginYear == startPeriodYear) {
                tmpYearDebitTotal = beginYearDebitTotal.add(yearDebitAmt);
                tmpYearCreditTotal = beginYearCreditTotal.add(yearCreditAmt);
            } else {
                tmpYearDebitTotal = beginYearDebitTotal;
                tmpYearCreditTotal = beginYearCreditTotal;
            }
            this.fillAdjustRow_New(CasConstants.ZERO, CasConstants.ZERO, tmpYearDebitTotal, tmpYearCreditTotal, tblMain, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, sourceCurrency, dc);
        }
        if (isShowBeginBalance) {
            row = tblMain.addRow();
            PeriodInfo period3 = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
            Timestamp tempDate3 = period3.getEndDate();
            BigDecimal exchange4 = CashHelper.getExchange(companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((java.util.Date)tempDate3));
            this.fillBalance(companyInfo, year, periodNumber, row, exchange4, balance, isCurEqualsBasecur, BEGIN_BALANCE, convertMode, dc);
        }
        BigDecimal dayBalance = balance;
        if (isByDay && rs != null && rs.size() != 0) {
            dayBalance = balance = cm.getValue(pm8);
        }
        if (year == startPeriodYear) {
            tmpYearDebitTotal = beginYearDebitTotal.add(yearDebitAmt);
            tmpYearCreditTotal = beginYearCreditTotal.add(yearCreditAmt);
        } else {
            tmpYearDebitTotal = beginYearDebitTotal;
            tmpYearCreditTotal = beginYearCreditTotal;
        }
        tmpYear = beginYear;
        while (rs.next()) {
            year = rs.getInt("periodyear");
            periodNumber = rs.getInt("periodnumber");
            date = rs.getDate("createDate");
            debitAmt = rs.getBigDecimal("debitAmount");
            creditAmt = rs.getBigDecimal("creditAmount");
            if (debitAmt == null) {
                debitAmt = CasConstants.ZERO;
            }
            if (creditAmt == null) {
                creditAmt = CasConstants.ZERO;
            }
            if (date.compareTo(tmpdate) == 0 && tmpPeriodNumber == periodNumber) {
                tmpDayDebitTotal = tmpDayDebitTotal.add(debitAmt);
                tmpDayCreditTotal = tmpDayCreditTotal.add(creditAmt);
            }
            if (date.compareTo(tmpdate) != 0 || tmpPeriodNumber != periodNumber) {
                if (isShowDayTotal) {
                    row = tblMain.addRow();
                    if (tmpdate == null) {
                        Period = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                        tmpdate = Period.getEndDate();
                    }
                    exchange2 = CashHelper.getExchange(companyInfo, sourceCurrency, null, tmpdate);
                    this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, tmpdate, row, exchange2, tmpDayDebitTotal, tmpDayCreditTotal, balance, isCurEqualsBasecur, DAY_TOTAL, convertMode, dc);
                }
                tmpMonthDebitTotal = tmpMonthDebitTotal.add(tmpDayDebitTotal);
                tmpMonthCreditTotal = tmpMonthCreditTotal.add(tmpDayCreditTotal);
                tmpDayDebitTotal = debitAmt;
                tmpDayCreditTotal = creditAmt;
            }
            if (tmpPeriodNumber != periodNumber) {
                if (isShowPeriodTotal) {
                    row = tblMain.addRow();
                    period = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                    tempDate = period.getEndDate();
                    exchange = CashHelper.getExchange(companyInfo, sourceCurrency, null, tempDate);
                    if (cashierIDSet == null) {
                        this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpMonthDebitTotal.subtract(adebitTotal), tmpMonthCreditTotal.subtract(acreditTotal), balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc);
                        tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal).subtract(adebitTotal);
                        tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal).subtract(acreditTotal);
                    } else {
                        this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc);
                        tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
                        tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
                    }
                } else if (cashierIDSet == null) {
                    tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal).subtract(adebitTotal);
                    tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal).subtract(acreditTotal);
                } else {
                    tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
                    tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
                }
                if (isShowYearTotal) {
                    row = tblMain.addRow();
                    period = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                    tempDate = period.getEndDate();
                    exchange = CashHelper.getExchange(companyInfo, sourceCurrency, null, tempDate);
                    this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc);
                    if (tmpYear < endYear || tmpYear == endYear && tmpPeriodNumber < endPeriod) {
                        beginPeriodInfo = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                        PeriodInfo temNextPeriodInfo = PeriodHelper.getNextPeriodInfo(companyInfo, beginPeriodInfo);
                        if (temNextPeriodInfo == null) {
                            return;
                        }
                        if ((temNextPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temNextPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temNextPeriodInfo.getPeriodNumber()) && beginPeriodInfo.getPeriodYear() < temNextPeriodInfo.getPeriodYear()) {
                            row = tblMain.addRow();
                            PeriodInfo period2 = PeriodHelper.getPeriodInfo(temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), companyInfo);
                            Timestamp tempDate2 = period2.getEndDate();
                            BigDecimal exchange22 = CashHelper.getExchange(companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((java.util.Date)tempDate2));
                            this.fillBalance(companyInfo, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), row, exchange22, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc);
                            tmpYearDebitTotal = CasConstants.ZERO;
                            tmpYearCreditTotal = CasConstants.ZERO;
                        }
                    }
                }
                beginPeriodInfo = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                beginPeriodInfo = PeriodHelper.getNextPeriodInfo(companyInfo, beginPeriodInfo);
                endPeriodInfo = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
                if ((endPeriodInfo = PeriodHelper.getPrePeriodInfo(companyInfo, endPeriodInfo)) == null) {
                    endPeriodInfo = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
                }
                this.fillAdjustRow_New(CasConstants.ZERO, CasConstants.ZERO, tmpYearDebitTotal, tmpYearCreditTotal, tblMain, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, sourceCurrency, dc);
                tmpMonthDebitTotal = CasConstants.ZERO;
                tmpMonthCreditTotal = CasConstants.ZERO;
            }
            if (tmpYear != year) {
                tmpYearDebitTotal = CasConstants.ZERO;
                tmpYearCreditTotal = CasConstants.ZERO;
            }
            period = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
            tempDate = period.getEndDate();
            exchange = CashHelper.getExchange(companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((java.util.Date)tempDate));
            if (tmpYear != year) {
                row = tblMain.addRow();
                this.fillBalance(companyInfo, year, periodNumber, row, exchange, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc);
            }
            if (tmpPeriodNumber != periodNumber && isShowBeginBalance) {
                row = tblMain.addRow();
                this.fillBalance(companyInfo, year, periodNumber, row, exchange, balance, isCurEqualsBasecur, BEGIN_BALANCE, convertMode, dc);
            }
            balance = balance.add(debitAmt).subtract(creditAmt);
            BigDecimal exchange23 = CashHelper.getExchange(companyInfo, sourceCurrency, null, new java.util.Date(rs.getDate("bizDate").getTime()));
            this.fillOneJournalRow(tblMain, rs, exchange23, isCurEqualsBasecur, debitAmt, creditAmt, balance, convertMode, dc);
            tmpdate = date;
            tmpYear = year;
            tmpPeriodNumber = periodNumber;
        }
        if (isShowDayTotal) {
            row = tblMain.addRow();
            if (tmpdate == null) {
                Period = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                tmpdate = Period.getEndDate();
            }
            exchange2 = CashHelper.getExchange(companyInfo, sourceCurrency, null, tmpdate);
            this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, date, row, exchange2, tmpDayDebitTotal, tmpDayCreditTotal, balance, isCurEqualsBasecur, DAY_TOTAL, convertMode, dc);
        }
        if (isByDay) {
            period = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
            java.util.Date endDate = new java.util.Date(period.getEndDate().getTime());
            if (endDate.after(para.getToDate())) {
                endDate = para.getToDate();
            }
            CashManagementCashMethodParam pm3 = new CashManagementCashMethodParam(companyInfo.getNumber(), type, acctTableNumber, null, accountBankNumber, currencyNumber, period.getBeginDate(), endDate, CashDataTypeEnum.Y, false, chkMulUnionQuery);
            CashManagementCashMethodParam pm4 = new CashManagementCashMethodParam(companyInfo.getNumber(), type, acctTableNumber, null, accountBankNumber, currencyNumber, period.getBeginDate(), endDate, CashDataTypeEnum.JF, false, chkMulUnionQuery);
            CashManagementCashMethodParam pm5 = new CashManagementCashMethodParam(companyInfo.getNumber(), type, acctTableNumber, null, accountBankNumber, currencyNumber, period.getBeginDate(), endDate, CashDataTypeEnum.DF, false, chkMulUnionQuery);
            cm.addParam(pm3);
            cm.addParam(pm4);
            cm.addParam(pm5);
            cm.fetchAllData();
            tmpMonthDebitTotal = tmpMonthDebitTotal.add(tmpDayDebitTotal);
            tmpMonthCreditTotal = tmpMonthCreditTotal.add(tmpDayCreditTotal);
            if (!beginPeriodInfo.isIsAdjustPeriod() || beginPeriodInfo.isIsAdjustPeriod() && !endPeriodInfo.equals((Object)beginPeriodInfo)) {
                tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal).subtract(adebitTotal);
                tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal).subtract(acreditTotal);
            }
        } else {
            tmpMonthDebitTotal = tmpMonthDebitTotal.add(tmpDayDebitTotal);
            tmpMonthCreditTotal = tmpMonthCreditTotal.add(tmpDayCreditTotal);
            tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
            tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
        }
        if (isShowPeriodTotal) {
            row = tblMain.addRow();
            period = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
            tempDate = period.getEndDate();
            exchange = CashHelper.getExchange(companyInfo, sourceCurrency, null, tempDate);
            if (isByDay) {
                cPeriod = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                if (cPeriod.getEndDate().compareTo(new Timestamp(para.getToDate().getTime())) > 0) {
                    if (CashHelper.isTheSameMonth(para.getFromDate(), para.getToDate())) {
                        this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, para.getToDate(), row, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc);
                    } else {
                        this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, para.getToDate(), row, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc);
                    }
                } else if (CashHelper.isTheSameMonth(para.getFromDate(), para.getToDate())) {
                    this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, para.getToDate(), row, exchange, tmpMonthDebitTotal.subtract(adebitTotal), tmpMonthCreditTotal.subtract(acreditTotal), balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc);
                } else {
                    this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc);
                }
            } else {
                this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc);
            }
        }
        if (isShowYearTotal) {
            row = tblMain.addRow();
            period = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
            tempDate = period.getEndDate();
            exchange = CashHelper.getExchange(companyInfo, sourceCurrency, null, tempDate);
            if (isByDay) {
                cPeriod = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                if (cPeriod.getEndDate().compareTo(new Timestamp(para.getToDate().getTime())) > 0) {
                    this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, para.getToDate(), row, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc);
                } else {
                    this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc);
                }
            } else {
                this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc);
            }
        }
        if (isShowYearTotal && (year < endYear || year == endYear && periodNumber < endPeriod)) {
            beginPeriodInfo = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
            PeriodInfo temNextPeriodInfo = PeriodHelper.getNextPeriodInfo(companyInfo, beginPeriodInfo);
            if (temNextPeriodInfo == null) {
                return;
            }
            if (temNextPeriodInfo.getPeriodYear() < endYear || temNextPeriodInfo.getPeriodYear() == endYear && endPeriod >= temNextPeriodInfo.getPeriodNumber()) {
                PeriodInfo period4 = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                Timestamp tempDate4 = period4.getEndDate();
                BigDecimal exchange5 = CashHelper.getExchange(companyInfo, sourceCurrency, null, tempDate4);
                if (beginPeriodInfo.getPeriodYear() < temNextPeriodInfo.getPeriodYear()) {
                    row = tblMain.addRow();
                    this.fillBalance(companyInfo, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), row, exchange5, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc);
                    tmpYearDebitTotal = CasConstants.ZERO;
                    tmpYearCreditTotal = CasConstants.ZERO;
                }
            }
        }
        if (year < endYear || year == endYear && periodNumber < endPeriod) {
            beginPeriodInfo = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
            beginPeriodInfo = PeriodHelper.getNextPeriodInfo(companyInfo, beginPeriodInfo);
            endPeriodInfo = PeriodHelper.getPeriodInfo(endYear, endPeriod, companyInfo);
            if (isByDay && !para.getToDate().equals(endPeriodInfo.getEndDate())) {
                endPeriodInfo = PeriodHelper.getPrePeriodInfo(companyInfo, endPeriodInfo);
            }
            this.fillAdjustRow_New(CasConstants.ZERO, CasConstants.ZERO, tmpYearDebitTotal, tmpYearCreditTotal, tblMain, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, sourceCurrency, dc);
        }
        exchange2 = CashHelper.getExchange(companyInfo, sourceCurrency, null, beginDate);
        this.setBeginBalanceRowDisc(tblMain, beginDate, isByDay, exchange2, isCurEqualsBasecur, dayBalance, convertMode, dc);
    }

    protected void setLocalColumnHide(KDTable tblMain) {
        this.setLocalColumnHided(tblMain, this.isHide);
    }

    protected BigDecimal fetchCashManagementCashValue(CompanyOrgUnitInfo companyInfo, String acctTableNumber, String accountBankNumber, String currencyNumber, java.util.Date beginDate, CashDataSourceEnum type, PeriodInfo startPeriod, PeriodInfo beginPeriodInfo, BankJournalFilterParam para, boolean isMulUnionQuery) throws EASBizException, BOSException {
        CashManagementCashMethod cm = new CashManagementCashMethod();
        CashManagementCashMethodParam pm6 = new CashManagementCashMethodParam(companyInfo.getNumber(), type, acctTableNumber, null, accountBankNumber, currencyNumber, beginDate, beginDate, CashDataTypeEnum.C, false, isMulUnionQuery);
        CashManagementCashMethodParam pm7 = new CashManagementCashMethodParam(companyInfo.getNumber(), type, acctTableNumber, null, accountBankNumber, currencyNumber, startPeriod.getBeginDate(), startPeriod.getBeginDate(), CashDataTypeEnum.C, false, isMulUnionQuery);
        CashManagementCashMethodParam pm8 = new CashManagementCashMethodParam(companyInfo.getNumber(), type, acctTableNumber, null, accountBankNumber, currencyNumber, beginDate, beginDate, CashDataTypeEnum.C, false, isMulUnionQuery);
        cm.addParam(pm6);
        cm.addParam(pm7);
        cm.addParam(pm8);
        CashManagementCashMethodParam pm1 = new CashManagementCashMethodParam(companyInfo.getNumber(), CashDataSourceEnum.B, acctTableNumber, null, accountBankNumber, currencyNumber, beginPeriodInfo.getBeginDate(), DateHelper.getBeforeDay((java.util.Date)para.getFromDate()), CashDataTypeEnum.JF, false, isMulUnionQuery);
        CashManagementCashMethodParam pm2 = new CashManagementCashMethodParam(companyInfo.getNumber(), CashDataSourceEnum.B, acctTableNumber, null, accountBankNumber, currencyNumber, beginPeriodInfo.getBeginDate(), DateHelper.getBeforeDay((java.util.Date)para.getFromDate()), CashDataTypeEnum.DF, false, isMulUnionQuery);
        cm.addParam(pm1);
        cm.addParam(pm2);
        cm.fetchAllData();
        return cm.getValue(pm6);
    }

    protected static SharedAcctCollection getSharedBankAcctSet(String number, String companyid) throws BOSException {
        SharedAcctCollection coll = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        view.setSelector(sic);
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyid));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("shareType"));
        sic.add(new SelectorItemInfo("shareAcct.id"));
        sic.add(new SelectorItemInfo("account.number"));
        AccountBankCollection colls = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
        if (colls.size() > 0) {
            String id;
            AccountBankInfo accountBank = colls.get(0);
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            evi.setFilter(fi);
            if (2 == accountBank.getShareType().getValue()) {
                id = accountBank.getShareAcct().getId().toString();
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)id));
            } else if (1 == accountBank.getShareType().getValue()) {
                id = accountBank.getId().toString();
                fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)id));
            }
            SelectorItemCollection sicc = new SelectorItemCollection();
            evi.setSelector(sicc);
            sicc.add(new SelectorItemInfo("id"));
            sicc.add(new SelectorItemInfo("bankAccount.number"));
            sicc.add(new SelectorItemInfo("bankAccount.account.number"));
            sicc.add(new SelectorItemInfo("entries.accountBank.number"));
            sicc.add(new SelectorItemInfo("entries.accountBank.company.*"));
            sicc.add(new SelectorItemInfo("entries.accountBank.account.number"));
            sicc.add(new SelectorItemInfo("entries.accountBank.account.accountTableID.number"));
            coll = SharedAcctFactory.getRemoteInstance().getSharedAcctCollection(evi);
        }
        return coll;
    }
}

