/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.IJournalBackup;
import com.kingdee.eas.fi.cas.JournalBackupCollection;
import com.kingdee.eas.fi.cas.JournalBackupFactory;
import com.kingdee.eas.fi.cas.JournalBaseCollection;
import com.kingdee.eas.fi.cas.JournalBaseInfo;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.fs.TransUpDownBillHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;

public class BankJournalUIHelper {
    private static void showJournalDetail(CoreUIObject owner, JournalBaseCollection journals, CompanyOrgUnitInfo company) throws Exception {
        HashSet<String> billIdSet = new HashSet<String>();
        int size = journals.size();
        block4: for (int i = 0; i < size; ++i) {
            JournalBaseInfo journalBaseInfo = journals.get(i);
            switch (journalBaseInfo.getSource().getValue()) {
                case 3: {
                    String billId = CashClientHelper.getBillIdByNumber(journalBaseInfo);
                    if (EmptyUtil.isEmpty((String)billId)) continue block4;
                    billIdSet.add(billId);
                    continue block4;
                }
                case 2: {
                    billIdSet.addAll(CashClientHelper.getBillIdSetByID(journalBaseInfo));
                    continue block4;
                }
                default: {
                    billIdSet.add(journalBaseInfo.getBillId());
                }
            }
        }
        if (EmptyUtil.isEmpty(billIdSet)) {
            JournalBaseInfo journalBaseInfo = journals.get(0);
            String info = journalBaseInfo.getSource().equals((Object)JournalSourceEnum.BYHAND) ? EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"CreateByHand") : EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"No_Match");
            MsgBox.showInfo((Component)owner, (String)info);
            SysUtil.abort();
        }
        Object[] objects = billIdSet.toArray();
        String[] billIds = new String[objects.length];
        System.arraycopy(objects, 0, billIds, 0, objects.length);
        if (billIds.length == 1) {
            String id = TransUpDownBillHelper.changeTransBillId((String)billIds[0]);
            FMClientHelper.viewDetailBill((CoreUIObject)owner, (String)id, (CompanyOrgUnitInfo)company);
        } else {
            for (int index = 0; index < billIds.length; ++index) {
                String id = billIds[index];
                billIds[index] = id = TransUpDownBillHelper.changeTransBillId((String)id);
            }
            FMClientHelper.viewDetailBill((CoreUIObject)owner, (String[])billIds, (CompanyOrgUnitInfo)company);
        }
    }

    private static boolean showMergeJournalDetail(CoreUIObject owner, JournalInfo journalInfo) throws Exception {
        if (journalInfo.getBatchNo() != null) {
            HashSet<String> batchNoSet = new HashSet<String>();
            batchNoSet.add(journalInfo.getBatchNo());
            IJournalBackup iJournalBackup = JournalBackupFactory.getRemoteInstance();
            JournalBackupCollection journalBackups = iJournalBackup.getCollectionByBatchNo(batchNoSet);
            if (journalBackups.size() > 0) {
                JournalBaseCollection journals = new JournalBaseCollection();
                journals.addObjectCollection((IObjectCollection)journalBackups);
                BankJournalUIHelper.showJournalDetail(owner, journals, journalInfo.getCompany());
                return true;
            }
        }
        return false;
    }

    public static void showBillByJournalId(CoreUIObject owner, String journalId) throws Exception {
        JournalInfo journalInfo = JournalFactory.getRemoteInstance().getJournalInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)journalId)));
        JournalBaseCollection journals = new JournalBaseCollection();
        journals.add((JournalBaseInfo)journalInfo);
        if (BankJournalUIHelper.showMergeJournalDetail(owner, journalInfo)) {
            return;
        }
        BankJournalUIHelper.showJournalDetail(owner, journals, journalInfo.getCompany());
    }
}

