/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.swing.KDFileChooser;
import com.kingdee.bos.ctrl.swing.util.SimpleFileFilter;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BankStatementCollection;
import com.kingdee.eas.fi.cas.BankStatementException;
import com.kingdee.eas.fi.cas.client.AbstractBankStatementImportUI;
import com.kingdee.eas.fi.cas.client.BankStatementHandler;
import com.kingdee.eas.fi.cas.client.BankStatementOptionUI;
import com.kingdee.eas.fm.common.FileUtils;
import com.kingdee.eas.fm.common.IUserOption;
import com.kingdee.eas.fm.common.UserOptionCollection;
import com.kingdee.eas.fm.common.UserOptionFactory;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Map;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

public class BankStatementImportUI
extends AbstractBankStatementImportUI {
    private CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private BankStatementCollection bankStatementCollection;
    private final String PATH_STORE_FILENAME = "eas_bankStatementUploadPath";
    private String defalutDirectoryPath = FileSystemView.getFileSystemView().getDefaultDirectory().getPath();

    public BankStatementImportUI() throws Exception {
        if (this.defalutDirectoryPath == null || "".equals(this.defalutDirectoryPath)) {
            this.defalutDirectoryPath = System.getProperty("user.dir");
        }
    }

    public BankStatementCollection getBankStatementCollection() {
        return this.bankStatementCollection;
    }

    public void setBankStatementCollection(BankStatementCollection bankStatementCollection) {
        this.bankStatementCollection = bankStatementCollection;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        String bankAccountId = (String)this.getUIContext().get("bankAccountId");
        this.companyInfo = (CompanyOrgUnitInfo)this.getUIContext().get("company");
        String name = this.getUserOptionNameByBankAccount(bankAccountId);
        this.txtUserOptionName.setText(name);
        this.txtUserOptionName.setEditable(false);
        this.chkDC.setVisible(false);
        this.txtFilePath.setText(FileUtils.readFileContent((String)(this.defalutDirectoryPath + System.getProperty("file.separator") + "eas_bankStatementUploadPath")).trim());
    }

    private String getUserOptionNameByBankAccount(String bankAccountId) throws Exception {
        String name = null;
        IUserOption userOption = UserOptionFactory.getRemoteInstance();
        UserOptionCollection userOptionCollection = userOption.getCollection("prmtBankAccount", bankAccountId, BankStatementOptionUI.class.getName(), null, this.companyInfo.getId().toString());
        if (userOptionCollection == null || userOptionCollection.size() == 0) {
            throw new BankStatementException(BankStatementException.NONE_BANKACCOUNT_OPTION);
        }
        name = userOptionCollection.get(0).getName();
        return name;
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    @Override
    protected void btnViewFile_actionPerformed(ActionEvent e) throws Exception {
        super.btnViewFile_actionPerformed(e);
        String filePath = FileUtils.readFileContent((String)(this.defalutDirectoryPath + System.getProperty("file.separator") + "eas_bankStatementUploadPath")).trim();
        KDFileChooser fileChooser = new KDFileChooser();
        if (!"".equals(filePath)) {
            fileChooser.setSelectedFile(new File(filePath));
        }
        fileChooser.setFileFilter((FileFilter)new SimpleFileFilter("txt"));
        fileChooser.setFileFilter((FileFilter)new SimpleFileFilter("xls"));
        fileChooser.setFileFilter((FileFilter)new SimpleFileFilter("xlsx"));
        if (fileChooser.showOpenDialog((Component)((Object)this)) != 0) {
            return;
        }
        filePath = fileChooser.getSelectedFile().getPath();
        this.txtFilePath.setText(filePath);
        FileUtils.newFile((String)this.defalutDirectoryPath, (String)"eas_bankStatementUploadPath", (String)filePath);
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        BankStatementCollection bankStatementCollection = BankStatementHandler.importData(this.txtFilePath.getText(), this.txtUserOptionName.getText(), this.chkDC.isSelected(), this.companyInfo.getId().toString());
        if (bankStatementCollection == null || bankStatementCollection.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"265_BankStatementImportUI"));
            SysUtil.abort();
        }
        this.setBankStatementCollection(bankStatementCollection);
        this.disposeUIWindow();
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    public static BankStatementCollection showDialogWindows(IUIObject ui, String bankAccountId, CompanyOrgUnitInfo companyInfo) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"bankAccountId", (Object)bankAccountId);
        uiContext.put((Object)"company", (Object)companyInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BankStatementImportUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        BankStatementImportUI bankStatementImportUI = (BankStatementImportUI)uiWindow.getUIObject();
        return bankStatementImportUI.getBankStatementCollection();
    }
}

