/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.uiframe.client.NewMainFrame;
import com.kingdee.eas.base.uiframe.client.UIFactoryHelper;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementUIFacadeFactory;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.DownLoadBankParam;
import com.kingdee.eas.fi.cas.IBankStatement;
import com.kingdee.eas.fi.cas.InnerCashFacadeFactory;
import com.kingdee.eas.fi.cas.client.AbstractBankStatementListUI;
import com.kingdee.eas.fi.cas.client.BankStatementDataProvider;
import com.kingdee.eas.fi.cas.client.BankStatementFilterParam;
import com.kingdee.eas.fi.cas.client.BankStatementFilterUI;
import com.kingdee.eas.fi.cas.client.BankStatementOptionUI;
import com.kingdee.eas.fi.cas.client.BankStatementUI;
import com.kingdee.eas.fi.cas.client.BankStmtListDataLoader;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.DownLoadBankStatementUI;
import com.kingdee.eas.fi.cas.client.DownLoadFSDataUI;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.util.UserDefineColumnCollection;
import com.kingdee.eas.fm.common.util.UserDefineColumnInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.framework.client.RealModeIDList;
import com.kingdee.eas.framework.client.context.IDelegationSupport;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class BankStatementListUI
extends AbstractBankStatementListUI
implements IDelegationSupport {
    private static final Logger logger = Logger.getLogger(BankStatementListUI.class);
    public static final String BANK = "BANK";
    public static final String CURRENCY = "currency";
    public static final String COL_DATE = "createDate";
    public static final String COL_DESC = "description";
    public static final String COL_DEBIT = "debitAmount";
    public static final String COL_CREDIT = "creditAmount";
    public static final String COL_BALANCE = "balance";
    public static final String COL_VERIFY = "verifyStatus";
    public static final String COL_SOURCE = "source";
    private static final String COL_ID = "id";
    public static final String COL_TRANSDETAIL_SOURCE = "transdetailSource";
    private BankStatementFilterUI _filterUI = null;
    public static final String resourcePath = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    public static final String CASH_FILENAME = "/FI/CAS/BANKSTATEMENT";
    private BankStmtListDataLoader loader = null;
    private CompanyOrgUnitInfo companyInfo = null;
    private AccountViewInfo acctOfBankAccount;
    private IPermission iPermission = PermissionFactory.getRemoteInstance();
    private Map paramMap;
    private boolean isSharedOrg = false;

    public void checkSelected() {
        super.checkSelected();
        String objId = this.getSelectedKeyValue();
        if (StringUtils.isEmpty((String)objId)) {
            SysUtil.abort();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionDownFSData.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_importcyclostyle"));
        this.actionAddLine.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_addsinglefile"));
        this.actionAddRows.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_copyline"));
        this.actionImportOptionUI.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_BZinput"));
        this.actionDownFromTransDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_downbill"));
    }

    private void setColumnsRender() {
        KDCheckBox chkBox = new KDCheckBox();
        chkBox.setEnabled(false);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JCheckBox)chkBox);
        this.tblMain.getColumn(COL_VERIFY).setEditor((ICellEditor)cellEditor);
        this.tblMain.getColumn(COL_ID).getStyleAttributes().setHided(true);
    }

    private void prepare() throws Exception {
        this.paramMap = new HashMap();
        this.paramMap.put("currentCompany", null);
        this.paramMap.put("currencyCollection", null);
        this.paramMap.put("startPeriod", null);
        this.paramMap.put("currentPeriod", null);
        this.paramMap = BankStatementUIFacadeFactory.getRemoteInstance().fetchData(this.paramMap);
    }

    protected boolean isAutoSetTitle() {
        return false;
    }

    protected String getTitle() throws Exception {
        PeriodInfo curP = (PeriodInfo)this.paramMap.get("currentPeriod");
        if (curP == null) {
            return null;
        }
        return EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"PeriodTitle") + curP.getPeriodYear() + EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"year") + curP.getPeriodNumber() + EASResource.getString((String)"com.kingdee.eas.fm.common.client.FMCommonClientResource", (String)"period");
    }

    public boolean destroyWindow() {
        if (this.isSharedOrg) {
            CashClientHelper.releaseSharedOrgLicense();
        }
        return super.destroyWindow();
    }

    public void onLoad() throws Exception {
        this.prepare();
        this.isSharedOrg = CashClientHelper.hasSharedOrgUIParam((CoreUIObject)this);
        if (this.isSharedOrg) {
            CashClientHelper.processSharedOrgFilterUI(this.getFilterUI());
            CashClientHelper.processSharedOrgLicense((CoreUI)this);
        }
        this.tblMain.getViewManager().setFreezeView(0, 2);
        CurrencyCollection currencyColl = (CurrencyCollection)this.paramMap.get("currencyCollection");
        if (currencyColl == null) {
            CashHelper.initCombCurrency(this.comboCurrency, false);
        } else {
            CashHelper.initCombCurrency(this.comboCurrency, currencyColl, false);
        }
        super.onLoad();
        AccountBankInfo bankInfo = (AccountBankInfo)this.prmtBank.getValue();
        CurrencyInfo currency = null;
        if (bankInfo.isIsByCurrency()) {
            currency = bankInfo.getCurrency();
            this.comboCurrency.setEnabled(false);
        } else {
            currency = this.companyInfo.getBaseCurrency();
            this.comboCurrency.setEnabled(true);
        }
        UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
        this.actionDownFSData.setEnabled(true);
        this.tblMain.getColumn(COL_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(COL_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblMain.getColumn(COL_BALANCE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.setColumnsRender();
        this.btnAddNew.setTextIconDisStyle((short)3);
        this.menuItemLocate.setVisible(false);
        this.kDMenuItemFirst.setVisible(false);
        this.kDMenuItemEnd.setVisible(false);
        this.kDMenuItemPrev.setVisible(false);
        this.kDMenuItemNext.setVisible(false);
        if (this.prmtBank.getValue() == null) {
            return;
        }
        this.setAcctOfBankAccount(this.txtBankAccount, (AccountBankInfo)this.prmtBank.getValue());
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.tblMain.getColumn(COL_DATE).getStyleAttributes().setNumberFormat(ClientUtils.getDateFormatString());
    }

    protected void checkUnion() {
        this.companyInfo = (CompanyOrgUnitInfo)this.paramMap.get("currentCompany");
        ClientUtils.checkCompany((Component)((Object)this), this.companyInfo);
    }

    @Override
    public void initUIMenuBarLayout() {
        super.initUIMenuBarLayout();
    }

    protected String getEditUIName() {
        return "com.kingdee.eas.fi.cas.client.BankStatement_RowUI";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BankStatementFactory.getRemoteInstance();
    }

    public void execQuery() {
        FilterParam obj = this.getFilterParam();
        BankStatementFilterParam filterParams = (BankStatementFilterParam)obj;
        try {
            filterParams.setAcctTableId(this.getAcctTableId(filterParams));
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        this.companyInfo = ClientUtils.getCurrLoginCompany();
        try {
            CompanyOrgUnitInfo prmtCompanyInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
            String prmtCompanyInfoId = "";
            if (!EmptyUtil.isEmpty((CoreBaseInfo)prmtCompanyInfo)) {
                prmtCompanyInfoId = prmtCompanyInfo.getId().toString();
            }
            this.companyInfo = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(filterParams.getCompanyId()));
            if (!EmptyUtil.isEmpty((CoreBaseInfo)this.companyInfo) && !this.companyInfo.getId().toString().equals(prmtCompanyInfoId)) {
                this.prmtBank.setValue(null);
            }
            CashHelper.setBankF7IncludeShared(this.prmtBank, this.companyInfo, filterParams.isDestroyed());
        }
        catch (Exception e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
        this.prmtCompany.setValue((Object)this.companyInfo);
        if (filterParams.getAccountBankId() != null) {
            try {
                AccountBankInfo accountBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(filterParams.getAccountBankId()));
                this.setAcctOfBankAccount(this.txtBankAccount, accountBankInfo);
                this.loader = new BankStmtListDataLoader(filterParams, accountBankInfo.getId().toString(), ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString(), this.tblMain);
                this.prmtBank.setValue((Object)accountBankInfo);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        if (this.prmtBank.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"266_BankStatementListUI"));
            SysUtil.abort();
        } else if (this.loader == null) {
            this.loader = new BankStmtListDataLoader(filterParams, ((AccountBankInfo)this.prmtBank.getValue()).getId().toString(), ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString(), this.tblMain);
        }
        this.initQueryRangeDesc(filterParams);
        AccountBankInfo bankInfo = (AccountBankInfo)this.prmtBank.getValue();
        this.setAcctOfBankAccount(this.txtBankAccount, bankInfo);
        try {
            this.fillData();
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            SysUtil.abort((Throwable)e1);
        }
    }

    private String getAcctTableId(BankStatementFilterParam param) throws EASBizException, BOSException {
        if (!FMHelper.isEmpty((String)param.getAcctTableId())) {
            return param.getAcctTableId();
        }
        String acctTableId = null;
        if (param.isByDate()) {
            java.sql.Date beginDate = param.getBeginDate();
            java.sql.Date endDate = param.getEndDate();
            acctTableId = FMClientHelper.getActualAcctTable((Date)beginDate, (Date)endDate);
            acctTableId = InnerCashFacadeFactory.getRemoteInstance().getActualAcctTableID(null, beginDate, endDate);
        } else {
            int beginYear = param.getStartPeriodYear();
            int beginMonth = param.getStartPeriodNum();
            int endYear = param.getEndPeriodYear();
            int endMonth = param.getEndPeriodNum();
            acctTableId = InnerCashFacadeFactory.getRemoteInstance().getActualAcctTableID(null, beginYear, beginMonth, endYear, endMonth);
        }
        return acctTableId;
    }

    private boolean isValidQuery() {
        return true;
    }

    private void clearPreQueryData() {
        this.mainQuery = null;
        this.txtBankAccount.setText(null);
        this.txtPeriod.setText(null);
    }

    private void initQueryRangeDesc(BankStatementFilterParam filterParams) {
        if (filterParams.isByDate()) {
            this.lblPeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Lbl_Date"));
            this.txtPeriod.setText(filterParams.getBeginDate() + EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_To") + filterParams.getEndDate());
        } else {
            this.lblPeriod.setBoundLabelText(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Lbl_PeriodDesc"));
            int startYear = filterParams.getStartPeriodYear();
            int start = filterParams.getStartPeriodNum();
            int endYear = filterParams.getEndPeriodYear();
            int end = filterParams.getEndPeriodNum();
            Object[] args = new String[]{String.valueOf(startYear), String.valueOf(start), String.valueOf(endYear), String.valueOf(end)};
            String sPeriodRange = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_PeriodRange"), args);
            this.txtPeriod.setText(sPeriodRange);
        }
    }

    protected IIDList getSelectedKeyValues() {
        RealModeIDList idList = new RealModeIDList();
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            ICell cell = this.tblMain.getRow(i).getCell(this.getKeyFieldName());
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if (cell.getValue() == null) continue;
            String id = cell.getValue().toString();
            idList.add(id);
        }
        idList.setCurrentIndex(0);
        return idList;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        if (this.prmtBank.getValue() != null) {
            AccountBankInfo _bankInfo = (AccountBankInfo)this.prmtBank.getValue();
            uiContext.put((Object)BANK, (Object)_bankInfo);
        }
        if (this.comboCurrency.getSelectedItem() != null) {
            CurrencyInfo _currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            uiContext.put((Object)CURRENCY, (Object)_currencyInfo);
        }
    }

    @Override
    public void actionAddRows_actionPerformed(ActionEvent e) throws Exception {
        this.iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString()), "cas_bankstatement_02addNew");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"accountBank", this.prmtBank.getValue());
        uiContext.put((Object)CURRENCY, this.comboCurrency.getSelectedItem());
        uiContext.put((Object)"company", (Object)this.companyInfo);
        this.prepareUIContext(uiContext, e);
        String UIName = "com.kingdee.eas.fi.cas.client.BankStatementUI";
        IUIWindow uiWindow = null;
        Frame frame = UIFactoryHelper.getMainFrame((Map)uiContext);
        Object mainUI = null;
        mainUI = frame instanceof NewMainFrame ? ((NewMainFrame)frame).getMainUI() : UIFactoryHelper.getMainUIObject((Map)uiContext);
        boolean flag = false;
        int index = mainUI.getBodyUI().getCurTabIndex();
        IUIObject uiObject = mainUI.getUiManager().findUIObject(UIName, (Map)uiContext, this.dataObjects, OprtState.ADDNEW);
        if (!(uiObject == null || UIName != null && UIName.equals("com.kingdee.eas.base.uiframe.client.DefaultSysTabUI"))) {
            uiWindow = uiObject.getUIWindow();
        }
        if (uiWindow != null) {
            String parentBankId = "";
            String parentCurrencyId = "";
            String bankId = "";
            String currencyId = "";
            int count = 0;
            if (this.prmtBank.getValue() != null) {
                parentBankId = this.prmtBank.getValue().toString();
            }
            if (this.comboCurrency.getSelectedItem() != null) {
                parentCurrencyId = this.comboCurrency.getSelectedItem().toString();
            }
            if (((BankStatementUI)uiWindow.getUIObject()).comboCurrency.getSelectedItem() != null) {
                currencyId = ((BankStatementUI)uiWindow.getUIObject()).comboCurrency.getSelectedItem().toString();
            }
            if (((BankStatementUI)uiWindow.getUIObject()).prmtBank.getValue() != null) {
                bankId = ((BankStatementUI)uiWindow.getUIObject()).prmtBank.getValue().toString();
            }
            if (!(EmptyUtil.isEmpty((String)parentBankId) || EmptyUtil.isEmpty((String)bankId) || parentBankId.equals(bankId))) {
                ++count;
            }
            if (!(EmptyUtil.isEmpty((String)parentCurrencyId) || EmptyUtil.isEmpty((String)currencyId) || parentCurrencyId.equals(currencyId))) {
                ++count;
            }
            if (count > 0) {
                boolean modifyStatus = ((BankStatementUI)uiWindow.getUIObject()).isModify();
                if (modifyStatus) {
                    flag = uiWindow.close();
                    mainUI.getBodyUI().setCurTabIndex(index);
                } else {
                    ((BankStatementUI)uiWindow.getUIObject()).prmtBank.setValue((Object)((AccountBankInfo)this.prmtBank.getValue()));
                    ((BankStatementUI)uiWindow.getUIObject()).comboCurrency.setSelectedItem(this.comboCurrency.getSelectedItem());
                }
            }
            if (!flag) {
                IUIWindow rowsUI = UIFactory.createUIFactory((String)this.getEditUIModal()).create(UIName, (Map)uiContext, null, OprtState.ADDNEW);
                rowsUI.show();
                if (((EditUI)rowsUI.getUIObject()).isSave()) {
                    this.actionRefresh_actionPerformed(e);
                }
                this.refreshList();
            }
        } else {
            IUIWindow rowsUI = UIFactory.createUIFactory((String)this.getEditUIModal()).create(UIName, (Map)uiContext, null, OprtState.ADDNEW);
            rowsUI.show();
            if (((EditUI)rowsUI.getUIObject()).isSave()) {
                this.actionRefresh_actionPerformed(e);
            }
            this.refreshList();
        }
    }

    @Override
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString()), "cas_bankstatement_02addNew");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"accountBank", this.prmtBank.getValue());
        uiContext.put((Object)CURRENCY, this.comboCurrency.getSelectedItem());
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"company", (Object)this.companyInfo);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = null;
        uiWindow = SwingUtilities.getWindowAncestor((Component)((Object)this)) != null && SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof JDialog ? UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW) : UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        this.iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString()), "cas_bankstatement_04remove");
        PeriodInfo periodInfo = ClientUtils.getCurrentPeriod((Component)((Object)this), this.companyInfo);
        KDTSelectBlock selectBlock = null;
        IRow row = null;
        boolean isAllowRemove = ContextHelperFactory.getRemoteInstance().getBooleanParam("CS080", (IObjectPK)new ObjectStringPK(this.companyInfo.getId().toString()));
        for (int i = 0; i < this.tblMain.getSelectManager().size(); ++i) {
            selectBlock = this.tblMain.getSelectManager().get(i);
            for (int j = selectBlock.getTop(); j <= selectBlock.getBottom(); ++j) {
                row = this.tblMain.getRow(j);
                String id = (String)row.getCell(COL_ID).getValue();
                Date createDate = (Date)row.getCell(COL_DATE).getValue();
                if (!isAllowRemove && DateHelper.dateDiff((Date)periodInfo.getBeginDate(), (Date)createDate) < 0L) {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"267_BankStatementListUI"));
                    return;
                }
                if (id != null) continue;
                MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"SelectValidRecord"));
                return;
            }
        }
        try {
            this.setOprtState("REMOVE");
            this.pubFireVOChangeListener(this.getSelectedKeyValue());
        }
        catch (Throwable ex) {
            this.handUIException(ex);
            this.abort();
        }
        this.checkSelected();
        if (this.confirmRemove()) {
            BankStatementFactory.getRemoteInstance().batchDelete(new HashSet(this.getSelectedIdValues()));
            this.refresh(e);
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this._filterUI == null) {
            this._filterUI = new BankStatementFilterUI(this.paramMap);
        }
        return this._filterUI;
    }

    protected CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog _queryDialog = super.getQueryDlg();
        _queryDialog.setShowFilter(false);
        _queryDialog.setShowSorter(false);
        _queryDialog.setHeight(300);
        _queryDialog.setWidth(420);
        return _queryDialog;
    }

    protected boolean isOrderForClickTableHead() {
        return false;
    }

    private void setAcctOfBankAccount(KDTextField txtBankAccount, AccountBankInfo bankInfo) {
        if (bankInfo == null) {
            logger.error((Object)"has not the bank, can't execute the query!");
            SysUtil.abort();
        }
        if (bankInfo.getAccount() == null) {
            logger.error((Object)"bankaccount has not acctview, can't execute the query!");
            SysUtil.abort();
        }
        this.acctOfBankAccount = new AccountViewInfo();
        try {
            BankStatementFilterParam para = (BankStatementFilterParam)this.getFilterParam();
            AccountBankCollection acctBankColl = new AccountBankCollection();
            acctBankColl.add(bankInfo);
            acctBankColl = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankCollection)acctBankColl, null, (String)para.getAcctTableId());
            bankInfo = acctBankColl.get(0);
            this.acctOfBankAccount = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccount().getId().toString()));
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.handUIExceptionAndAbort(e);
        }
        txtBankAccount.setText(this.acctOfBankAccount.toString());
    }

    private void setQueryCurrency() {
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        if (currencyInfo == null) {
            logger.error((Object)"has not the currency, cannot execute the query!");
            SysUtil.abort();
        }
        int scale = 2;
        scale = currencyInfo.getPrecision();
        String format = ClientUtils.getNumberFormat(scale, true);
        this.tblMain.getColumn(COL_DEBIT).getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn(COL_CREDIT).getStyleAttributes().setNumberFormat(format);
        this.tblMain.getColumn(COL_BALANCE).getStyleAttributes().setNumberFormat(format);
    }

    protected void checkAssignment(ItemAction act) {
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        String sAcct = this.lblBankAccount.getBoundLabelText() + " &[BankAccount] ";
        String sBank = this.lblBank.getBoundLabelText() + " &[Bank] ";
        String sPeriod = this.lblPeriod.getBoundLabelText() + " &[Period] ";
        String sCurr = this.lblCurrency.getBoundLabelText() + " &[Currency] ";
        StyleAttributes sb = Styles.getDefaultSA();
        headerModel.addRow(sBank + "&|" + sCurr + "&|" + sPeriod + "&|", sb);
        headerModel.addRow(sAcct + "&| &| &| ", sb);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Company", this.companyInfo.getName());
        map.put("BankAccount", this.txtBankAccount.getText());
        map.put("Bank", this.prmtBank.getValue());
        map.put("Period", this.txtPeriod.getText());
        map.put("Currency", this.comboCurrency.getSelectedItem());
        return map;
    }

    @Override
    protected void prmtBank_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtBank.getValue() == null) {
            return;
        }
        if (this.comboCurrency.getSelectedItem() == null) {
            return;
        }
        AccountBankInfo bankInfo = (AccountBankInfo)this.prmtBank.getValue();
        CurrencyInfo currency = null;
        if (bankInfo.isIsByCurrency()) {
            currency = bankInfo.getCurrency();
            this.comboCurrency.setEnabled(false);
        } else {
            currency = this.companyInfo.getBaseCurrency();
            this.comboCurrency.setEnabled(true);
        }
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
        if (bankInfo.isIsClosed()) {
            this.setCtrlEnable(false);
        } else {
            this.setCtrlEnable(true);
        }
        this.setAcctOfBankAccount(this.txtBankAccount, bankInfo);
        FilterParam obj = this.getFilterParam();
        BankStatementFilterParam filterParams = (BankStatementFilterParam)obj;
        this.loader = new BankStmtListDataLoader(filterParams, ((AccountBankInfo)this.prmtBank.getValue()).getId().toString(), ((CurrencyInfo)this.comboCurrency.getSelectedItem()).getId().toString(), this.tblMain);
        this.fillData();
    }

    private void setCtrlEnable(boolean enable) {
        this.actionAddNew.setEnabled(enable);
        this.actionAddRows.setEnabled(enable);
        this.actionEdit.setEnabled(enable);
        this.actionRemove.setEnabled(enable);
        this.actionImportData.setEnabled(enable);
        this.actionImportOptionUI.setEnabled(enable);
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.comboCurrency_actionPerformed(e);
        if (this.prmtBank.getValue() == null) {
            return;
        }
        if (this.comboCurrency.getSelectedItem() == null) {
            return;
        }
        this.fillData();
    }

    private void fillData() throws BOSException, EASBizException {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.mainQueryPK);
        if (this.mainQuery == null) {
            return;
        }
        EntityViewInfo ev = (EntityViewInfo)this.mainQuery.clone();
        String bankId = AccessHelper.getF7Id((KDBizPromptBox)this.prmtBank);
        String currencyId = AccessHelper.getCboId((KDComboBox)this.comboCurrency);
        ev.setFilter(this.getFilterEntiryViewInfo());
        ev.getFilter().mergeFilter(this.getFilter(bankId, currencyId), "AND");
        exec.setObjectView(ev);
        if (this.prmtBank.getValue() == null) {
            return;
        }
        try {
            IRowSet rs = exec.executeQuery();
            this.tblMain.removeRows();
            AccountBankInfo acctInfo = (AccountBankInfo)this.prmtBank.getValue();
            CompanyOrgUnitInfo acctCompany = CashClientHelper.getAcctMainSharedAcct(acctInfo);
            this.loader.loadDataToTable(rs, bankId, currencyId, this.acctOfBankAccount.getId().toString(), acctCompany.getId().toString());
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        this.setColumnFormat(this.tblMain, currencyId);
    }

    private FilterInfo getFilterEntiryViewInfo() throws EASBizException, BOSException {
        BankStatementFilterParam filterParam = (BankStatementFilterParam)this.getFilterParam();
        FilterInfo filter = new FilterInfo();
        boolean isByDate = filterParam.isByDate();
        java.sql.Date beginDate = filterParam.getBeginDate();
        java.sql.Date endDate = filterParam.getEndDate();
        int startPeriodYear = filterParam.getStartPeriodYear();
        int startPeriodNum = filterParam.getStartPeriodNum();
        int endPeriodYear = filterParam.getEndPeriodYear();
        int endPeriodNum = filterParam.getEndPeriodNum();
        AccountBankInfo acctInfo = (AccountBankInfo)this.prmtBank.getValue();
        CompanyOrgUnitInfo acctCompany = CashClientHelper.getAcctMainSharedAcct(acctInfo);
        if (isByDate) {
            if (beginDate != null) {
                filter.getFilterItems().add(new FilterItemInfo(COL_DATE, (Object)DateTimeUtils.truncateDate((Date)beginDate), CompareType.GREATER_EQUALS));
            }
            if (endDate != null) {
                filter.getFilterItems().add(new FilterItemInfo(COL_DATE, (Object)DateTimeUtils.truncateDate((Date)endDate), CompareType.LESS_EQUALS));
            }
        } else {
            try {
                String periodTypeId = this.companyInfo.getAccountPeriodType().getId().toString();
                String sql = PeriodHelper.getPeriodCollSQL(periodTypeId, startPeriodYear, startPeriodNum, endPeriodYear, endPeriodNum);
                filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)sql, CompareType.INNER));
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        FilterItemInfo itemInfo = new FilterItemInfo("company.id", (Object)acctCompany.getId().toString());
        filter.getFilterItems().add(itemInfo);
        return filter;
    }

    private FilterInfo getFilter(String accountBankId, String currencyId) {
        FilterInfo filter = new FilterInfo();
        if (!StringUtils.isEmpty((String)accountBankId)) {
            filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)accountBankId));
        }
        if (!StringUtils.isEmpty((String)currencyId)) {
            filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        }
        if (this.acctOfBankAccount != null) {
            filter.getFilterItems().add(new FilterItemInfo("accountView.id", (Object)this.acctOfBankAccount.getId()));
        }
        return filter;
    }

    public void initDefaultQuery(String name) throws Exception {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        super.initDefaultQuery(name);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString()), "cas_bankstatement_03edit");
        this.checkSelected();
        try {
            this.setOprtState("REMOVE");
            this.pubFireVOChangeListener(this.getSelectedKeyValue());
        }
        catch (Throwable ex) {
            this.handUIException(ex);
            this.abort();
        }
        this.getBizInterface().canUpdate((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())));
        super.actionEdit_actionPerformed(e);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{COL_DATE, COL_DESC, "settleType.name", "settleNumber", "sequenceNumber", "tradeNumber", "cashier", "oppAccountNumber", "voucherNumber", COL_DEBIT, COL_CREDIT, COL_BALANCE, "fPItem.name"};
        return locateNames;
    }

    public void setColumnFormat(KDTable tblMain, String currencyId) {
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
        tblMain.getColumn(COL_DEBIT).getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn(COL_CREDIT).getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn(COL_BALANCE).getStyleAttributes().setNumberFormat(numberFtm);
        tblMain.getColumn(COL_DEBIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn(COL_CREDIT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblMain.getColumn(COL_BALANCE).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    @Override
    public void actionDownFSData_actionPerformed(ActionEvent e) throws Exception {
        super.actionDownFSData_actionPerformed(e);
        DownLoadFSDataUI.showDialogWindow((IUIObject)this, this.companyInfo);
        this.actionRefresh_actionPerformed(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionDownFromTransDetail_actionPerformed(ActionEvent e) throws Exception {
        DownLoadBankParam downParam = DownLoadBankStatementUI.showDialogWindows((IUIObject)this, this.companyInfo, this.isSharedOrg);
        if (downParam != null) {
            ArrayList<String> appliedList = new ArrayList<String>();
            Set bankAcctSet = downParam.getBankAccountIdSet();
            ArrayList allList = new ArrayList(bankAcctSet);
            IMutexServiceControl iMutex = MutexServiceControlFactory.getRemoteInstance();
            try {
                Map requestResult = iMutex.batchRequestBizObjIDForUpdate(allList);
                boolean boolResult = false;
                for (String id : requestResult.keySet()) {
                    boolResult = (Boolean)requestResult.get(id);
                    if (!boolResult) continue;
                    appliedList.add(id);
                }
                downParam.setBankAccountIdSet(FMHelper.list2Set(appliedList));
                IBankStatement ibs = BankStatementFactory.getRemoteInstance();
                int count = ibs.downloadBankState(downParam);
                String info = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.BankStatementResource", (String)"downBankStatement"), new Integer(count));
                MsgBox.showInfo((Component)((Object)this), (String)info);
            }
            finally {
                if (appliedList.size() > 0) {
                    iMutex.batchReleaseObjIDForUpdate(appliedList);
                }
            }
        }
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionImportOptionUI_actionPerformed(ActionEvent e) throws Exception {
        BankStatementOptionUI.showDialogWindows((IUIObject)this, this.companyInfo);
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.fillData();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        super.tblMain_tableClicked(e);
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.actionAddNew_actionPerformed(e);
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(true);
        this.actionRefresh_actionPerformed(e);
    }

    @Override
    public void actionTDPreView_actionPerformed(ActionEvent e) throws Exception {
        this.tdPrint(false);
        this.actionRefresh_actionPerformed(e);
    }

    private void tdPrint(boolean isPrint) throws EASBizException, BOSException {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtBank);
        UserDefineColumnCollection udcc = this.getUserDefineColumnCollection();
        BankStatementDataProvider data = null;
        data = new BankStatementDataProvider(this.tblMain, udcc);
        KDNoteHelper appHlp = new KDNoteHelper();
        if (isPrint) {
            appHlp.print(CASH_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        } else {
            appHlp.printPreview(CASH_FILENAME, (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        }
    }

    private UserDefineColumnCollection getUserDefineColumnCollection() throws EASBizException, BOSException {
        UserDefineColumnCollection udcc = new UserDefineColumnCollection();
        UserDefineColumnInfo info = null;
        info = new UserDefineColumnInfo();
        info.setName("bankAccount");
        info.setDescription(this.lblBank.getBoundLabelText());
        info.setAlias(this.lblBank.getBoundLabelText());
        info.setColumnValue(this.prmtBank.getValue().toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName(CURRENCY);
        info.setDescription(this.lblCurrency.getBoundLabelText());
        info.setAlias(this.lblCurrency.getBoundLabelText());
        info.setColumnValue(this.comboCurrency.getSelectedItem().toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("bankAccountView");
        info.setDescription(this.lblBankAccount.getBoundLabelText());
        info.setAlias(this.lblBankAccount.getBoundLabelText());
        info.setColumnValue(this.txtBankAccount.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("intTerm");
        info.setDescription(this.lblPeriod.getBoundLabelText());
        info.setAlias(this.lblPeriod.getBoundLabelText());
        info.setColumnValue(this.txtPeriod.getText());
        udcc.add((Object)info);
        Date fromDate = null;
        Timestamp toDate = null;
        BankStatementFilterParam para = (BankStatementFilterParam)this.getFilterParam();
        PeriodInfo beginPeriod = null;
        PeriodInfo endPeriod = null;
        Calendar ca = Calendar.getInstance();
        ca.setTime(para.getBeginDate());
        beginPeriod = PeriodHelper.getPeriodInfo(ca.get(1), ca.get(2) + 1, this.companyInfo);
        ca.setTime(para.getEndDate());
        endPeriod = PeriodHelper.getPeriodInfo(ca.get(1), ca.get(2) + 1, this.companyInfo);
        fromDate = beginPeriod.getBeginDate();
        toDate = endPeriod.getEndDate();
        info = new UserDefineColumnInfo();
        info.setName("startPeriod");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"259_BankJournalListUI"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"259_BankJournalListUI"));
        info.setColumnValue(fromDate.toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("endPeriod");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"260_BankJournalListUI"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"260_BankJournalListUI"));
        info.setColumnValue(((Date)toDate).toString());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("company");
        info.setDescription(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"58_CASAccountCheckBalance"));
        info.setAlias(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"58_CASAccountCheckBalance"));
        info.setColumnValue(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getName());
        udcc.add((Object)info);
        return udcc;
    }

    public String getPropertyOfBizOrg(OrgType orgType) {
        return "company.id";
    }

    public String[] getPropertyOfCopOrg() {
        return null;
    }

    protected IMultiOrgSupport getMainCustomerQueryPanel() {
        FMFilterBaseUI multiOrgSupport = null;
        try {
            multiOrgSupport = this.getFilterUI();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
            e.printStackTrace();
        }
        return multiOrgSupport;
    }

    protected ArrayList getImportParam() {
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.fi.cas.BankStatement";
        param.alias = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"333_BankStatementListUI");
        ArrayList<DatataskParameter> paramList = new ArrayList<DatataskParameter>();
        paramList.add(param);
        return paramList;
    }
}

