/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.IAccountBank;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctCollection;
import com.kingdee.eas.basedata.assistant.SharedAcctFactory;
import com.kingdee.eas.basedata.assistant.SharedAcctInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.calc.CalculatorDialog;
import com.kingdee.eas.common.calc.CalculatorF7Binder;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.BSSourceEnum;
import com.kingdee.eas.fi.cas.BankStatementFactory;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.AbstractBankStatement_RowUI;
import com.kingdee.eas.fi.cas.client.BankStatementHandler;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.framework.client.context.OrgChangeVO;
import com.kingdee.eas.framework.client.context.f7.DefaultF7ContextManager;
import com.kingdee.eas.framework.client.context.f7.IF7ContextChange;
import com.kingdee.eas.framework.client.context.f7.IF7Register;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BankStatement_RowUI
extends AbstractBankStatement_RowUI
implements IMultiOrgSupport {
    private static Logger logger = Logger.getLogger((String)BankStatement_RowUI.class.getName());
    private static final String casResourcePath = "com.kingdee.eas.fi.cas.CasResource";
    private CompanyOrgUnitInfo _companyInfo = null;
    private PeriodInfo _startPeriod = null;
    private boolean _fDebit = false;
    private CalculatorDialog calc = null;
    private boolean canAddPreviousBill = true;
    private CompanyOrgUnitInfo company = null;
    private IContextHelper context = ContextHelperFactory.getRemoteInstance();
    private DefaultF7ContextManager F7ContextManager = null;
    PeriodInfo casPeriod = null;

    @Override
    public void loadFields() {
        PeriodInfo periodInfo;
        super.loadFields();
        this._fDebit = this.entityBankStatement.isIsDebit();
        if (this.entityBankStatement.getAccountBank() != null) {
            this.prmtBank.setValue((Object)this.entityBankStatement.getAccountBank());
        }
        if (this.entityBankStatement.getCurrency() != null) {
            ClientUtils.setSelectedItem(this.comboCurrency, this.entityBankStatement.getCurrency().getId().toString());
            int scale = FMClientHelper.getPrecOfCurrency((BOSUuid)this.entityBankStatement.getCurrency().getId());
            this.txtDebitAmount.setPrecision(scale);
            this.txtCreditAmount.setPrecision(scale);
        }
        if ((periodInfo = this.entityBankStatement.getPeriod()) == null) {
            periodInfo = this.casPeriod;
        }
        if (periodInfo != null) {
            Object[] args = new String[]{String.valueOf(periodInfo.getPeriodYear()), String.valueOf(periodInfo.getPeriodNumber())};
            this.txtPeriod.setText(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"), args));
        }
        if (this.entityBankStatement.getCreateDate() == null) {
            Date date = new Date();
            if (date.after(this.casPeriod.getEndDate())) {
                date = this.casPeriod.getEndDate();
            }
            if (date.before(this.casPeriod.getBeginDate())) {
                date = this.casPeriod.getBeginDate();
            }
            this.pkBizDate.setValue((Object)date);
        } else {
            this.pkBizDate.setValue((Object)this.entityBankStatement.getCreateDate());
        }
        this.txtDesc.setText(this.entityBankStatement.getDescription());
        this.txtSettlementNumber.setText(this.entityBankStatement.getSettleNumber());
        this.txtSequenceNumber.setText(this.entityBankStatement.getSequenceNumber());
        this.txtTradeNumber.setText(this.entityBankStatement.getTradeNumber());
        this.txtCashier.setText(this.entityBankStatement.getCashier());
        this.txtOppUnit.setText(this.entityBankStatement.getOppUnit());
        this.txtOppAccountNumber.setText(this.entityBankStatement.getOppAccountNumber());
        this.txtVoucherNumber.setText(this.entityBankStatement.getVoucherNumber());
        if (!this.oprtState.equals(OprtState.ADDNEW)) {
            this.pkBizDate.setValue((Object)this.entityBankStatement.getCreateDate());
        }
        if (this.entityBankStatement.getSettleType() != null) {
            ClientUtils.setSelectedItem(this.comboSettlement, this.entityBankStatement.getSettleType().getId().toString());
        } else {
            this.comboSettlement.setSelectedIndex(-1);
        }
        if (this.entityBankStatement.getDebitAmount() != null && this.entityBankStatement.getDebitAmount().compareTo(CasConstants.ZERO) != 0) {
            this.txtDebitAmount.setValue((Object)this.entityBankStatement.getDebitAmount());
            this._fDebit = true;
        } else {
            this.txtDebitAmount.setValue(null);
            this._fDebit = false;
        }
        if (this.entityBankStatement.getCreditAmount() != null && this.entityBankStatement.getCreditAmount().compareTo(CasConstants.ZERO) != 0) {
            this.txtCreditAmount.setValue((Object)this.entityBankStatement.getCreditAmount());
        } else {
            this.txtCreditAmount.setValue(null);
        }
        if (this.entityBankStatement.getCompany() != null) {
            try {
                this.company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(this.entityBankStatement.getCompany().getId().toString()));
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            this.prmtCompany.setValue((Object)this.company);
        }
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            Date bizDate = DateTimeUtils.truncateDate((Date)this.pkBizDate.getSqlDate());
            CompanyOrgUnitInfo cUnitInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
            AccountBankInfo accountBankInfo = (AccountBankInfo)this.prmtBank.getValue();
            if (null != bizDate && null != cUnitInfo && null != accountBankInfo) {
                AccountViewInfo accountViewInfo = this.getAccountView(bizDate, cUnitInfo, accountBankInfo);
                if (EmptyUtil.isEmpty((CoreBaseInfo)accountViewInfo)) {
                    accountViewInfo = this.entityBankStatement.getAccountView();
                }
                this.txtAccount.setText(accountViewInfo.toString());
                this.txtAccount.setUserObject((Object)accountViewInfo);
            }
        } else if (this.entityBankStatement.getAccountView() != null) {
            this.txtAccount.setText(this.entityBankStatement.getAccountView().toString());
            this.txtAccount.setUserObject((Object)this.entityBankStatement.getAccountView());
        }
    }

    private AccountViewInfo getAccountView(Date bizDate, CompanyOrgUnitInfo cUnitInfo, AccountBankInfo accountBankInfo) {
        String acctTableId = FMClientHelper.getActualAcctTable((String)cUnitInfo.getId().toString(), (Date)bizDate, (Date)bizDate);
        HashSet<String> idSet = new HashSet<String>();
        String accountBankId = accountBankInfo.getId().toString();
        idSet.add(accountBankId);
        try {
            Map map = FMHelper.getJBAcctBankAcctViewMap(null, idSet, null, (String)acctTableId);
            AccountViewInfo acctOfBankAccount = (AccountViewInfo)map.get(accountBankInfo.getId().toString());
            if (null != acctOfBankAccount) {
                return acctOfBankAccount;
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return null;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        super.setDataObject(dataObject);
        this.entityBankStatement = (BankStatementInfo)dataObject;
    }

    @Override
    public void storeFields() {
        SettlementTypeInfo settleInfo;
        super.storeFields();
        if (this.entityBankStatement == null) {
            return;
        }
        this.entityBankStatement.setAccountView((AccountViewInfo)this.txtAccount.getUserObject());
        this.entityBankStatement.setAccountBank((AccountBankInfo)this.prmtBank.getValue());
        this.entityBankStatement.setCurrency((CurrencyInfo)this.comboCurrency.getSelectedItem());
        Date date = (Date)this.pkBizDate.getValue();
        PeriodInfo periodInfo = (PeriodInfo)this.txtPeriod.getUserObject();
        if (periodInfo == null) {
            try {
                if (this._companyInfo == null) {
                    this._companyInfo = ClientUtils.getCurrLoginCompany();
                }
                periodInfo = PeriodUtils.getPeriodInfo((Date)date, (CompanyOrgUnitInfo)this._companyInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                SysUtil.abort();
            }
            catch (BOSException e) {
                logger.error((Object)e);
                SysUtil.abort();
            }
        }
        this.entityBankStatement.setPeriod(periodInfo);
        Date createDate = (Date)this.pkBizDate.getValue();
        createDate = DateTimeUtils.truncateDate((Date)createDate);
        this.entityBankStatement.setCreateDate(createDate);
        this.entityBankStatement.remove("description");
        if (!StringUtils.isEmpty((String)this.txtDesc.getText())) {
            this.entityBankStatement.setDescription(this.txtDesc.getText());
        }
        if ((settleInfo = (SettlementTypeInfo)this.comboSettlement.getSelectedItem()) != null && !"blank".equals(settleInfo.get("id"))) {
            this.entityBankStatement.setSettleType((SettlementTypeInfo)this.comboSettlement.getSelectedItem());
        } else {
            this.entityBankStatement.setSettleType(null);
        }
        this.entityBankStatement.setSettleNumber(this.txtSettlementNumber.getText());
        this.entityBankStatement.setSequenceNumber(this.txtSequenceNumber.getText());
        this.entityBankStatement.setTradeNumber(this.txtTradeNumber.getText());
        this.entityBankStatement.setCashier(this.txtCashier.getText());
        this.entityBankStatement.setOppAccountNumber(this.txtOppAccountNumber.getText());
        this.entityBankStatement.setVoucherNumber(this.txtVoucherNumber.getText());
        this.entityBankStatement.setOppUnit(this.txtOppUnit.getText());
        this.entityBankStatement.remove("creditAmount");
        this.entityBankStatement.remove("debitAmount");
        this.entityBankStatement.setCreditAmount(null);
        this.entityBankStatement.setDebitAmount(null);
        this.entityBankStatement.setIsDebit(this._fDebit);
        if (this._fDebit) {
            this.entityBankStatement.setDebitAmount(this.txtDebitAmount.getBigDecimalValue());
            this.entityBankStatement.setCreditAmount(SysConstant.BIGZERO);
        } else {
            this.entityBankStatement.setCreditAmount(this.txtCreditAmount.getBigDecimalValue());
            this.entityBankStatement.setDebitAmount(SysConstant.BIGZERO);
        }
    }

    private void clearUI() {
        this.pkBizDate.setValue((Object)new Date());
        this.txtDesc.setText("");
        this.txtSettlementNumber.setText("");
        this.comboSettlement.setSelectedIndex(-1);
        this.txtDebitAmount.setText("");
        this.txtCreditAmount.setText("");
    }

    public void onLoad() throws Exception {
        if (this.oprtState.equals(OprtState.ADDNEW)) {
            this.company = (CompanyOrgUnitInfo)this.getUIContext().get("company");
            this.casPeriod = CashClientHelper.getCurrentPeriod(this.company);
            this.initViewControl();
            AccountBankInfo bankInfo = (AccountBankInfo)this.getUIContext().get("accountBank");
            this.prmtBank.setValue((Object)bankInfo);
            if (bankInfo != null && bankInfo.isIsByCurrency()) {
                this.comboCurrency.setSelectedItem((Object)bankInfo.getCurrency());
                this.comboCurrency.setEnabled(false);
            } else {
                CurrencyInfo localCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.company);
                this.comboCurrency.setSelectedItem((Object)localCurrency);
            }
            AccountViewInfo acctInfo = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccount().getId()));
            this.txtAccount.setUserObject((Object)acctInfo);
        }
        super.onLoad();
        if (!this.oprtState.equals(OprtState.ADDNEW)) {
            this.company = this.entityBankStatement.getCompany();
            this.casPeriod = CashClientHelper.getCurrentPeriod(this.company);
            this.initViewControl();
            this.loadFields();
        }
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
        FMClientHelper.updateUITitle((CoreUIObject)this, (String)this.resHelper.getString("this.title"));
        if (this.oprtState.equals(OprtState.EDIT)) {
            AccountBankInfo accountBankInfo = (AccountBankInfo)this.prmtBank.getValue();
            AccountBankInfo newAccountBankInfo = null;
            if (accountBankInfo != null) {
                IAccountBank iAccountBank = AccountBankFactory.getRemoteInstance();
                newAccountBankInfo = iAccountBank.getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getId()));
            }
            if (newAccountBankInfo != null && newAccountBankInfo.isIsByCurrency()) {
                this.comboCurrency.setEnabled(false);
            }
            this.prmtCompany.setEnabled(false);
        }
        this.pkBizDate_dataChanged(new DataChangeEvent((Object)this, this.pkBizDate.getValue(), (Object)this._startPeriod.getBeginDate()));
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    private void initViewControl() throws Exception {
        if (CheckUtils.sameIn((Object)this.oprtState, (Object[])new Object[]{OprtState.ADDNEW, OprtState.EDIT})) {
            this.prmtCompany.setValue((Object)this.company);
        }
        this.canAddPreviousBill = ContextHelperFactory.getRemoteInstance().getBooleanParam("CS046", (IObjectPK)new ObjectUuidPK(this.company.getId()));
        this.initUI();
        CashHelper.initCombCurrency(this.comboCurrency, false, this.company);
    }

    private void initUI() throws Exception {
        try {
            if (this.oprtState.equals(OprtState.ADDNEW)) {
                this.setBankF7(this.prmtBank, this.company, false);
            } else {
                this.setBankF7(this.prmtBank, this.entityBankStatement.getCompany(), false);
            }
        }
        catch (BOSException e) {
            this.handUIExceptionAndAbort((Exception)((Object)e));
        }
        this._startPeriod = ClientUtils.getStartPeriodInfo((Component)((Object)this), this.company);
        ClientUtils.setCurrencyList(this.comboCurrency, false);
        ClientUtils.setSettleTypeList(this.comboSettlement);
        this.txtSettlementNumber.setMaxLength(80);
        this.txtOppAccountNumber.setMaxLength(80);
        this.txtSequenceNumber.setMaxLength(80);
        this.txtVoucherNumber.setMaxLength(80);
        this.txtCashier.setMaxLength(80);
        this.txtCreditAmount.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                BigDecimal credit = BankStatement_RowUI.this.txtCreditAmount.getBigDecimalValue();
                if (credit != null) {
                    if (credit.compareTo(Constants.MAX_VALUE) == 1) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
                        BankStatement_RowUI.this.txtCreditAmount.setValue((Object)Constants.ZERO);
                        SysUtil.abort();
                    }
                    BankStatement_RowUI.this._fDebit = false;
                    if (BankStatement_RowUI.this.txtDebitAmount.getBigDecimalValue() != null) {
                        BankStatement_RowUI.this.txtDebitAmount.setValue(null);
                    }
                }
            }
        });
        this.txtCreditAmount.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                BigDecimal credit = BankStatement_RowUI.this.txtCreditAmount.getBigDecimalValue();
                if (credit != null) {
                    BankStatement_RowUI.this._fDebit = false;
                    if (BankStatement_RowUI.this.txtDebitAmount.getBigDecimalValue() != null) {
                        BankStatement_RowUI.this.txtDebitAmount.setValue(null);
                    }
                }
            }
        });
        this.txtDebitAmount.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent e) {
                BigDecimal debit = BankStatement_RowUI.this.txtDebitAmount.getBigDecimalValue();
                if (debit != null) {
                    if (debit.compareTo(Constants.MAX_VALUE) == 1) {
                        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
                        BankStatement_RowUI.this.txtDebitAmount.setValue((Object)Constants.ZERO);
                        SysUtil.abort();
                    }
                    BankStatement_RowUI.this._fDebit = true;
                    if (BankStatement_RowUI.this.txtCreditAmount.getBigDecimalValue() != null) {
                        BankStatement_RowUI.this.txtCreditAmount.setValue(null);
                    }
                }
            }
        });
        this.txtDebitAmount.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                BigDecimal debit = BankStatement_RowUI.this.txtDebitAmount.getBigDecimalValue();
                if (debit != null) {
                    BankStatement_RowUI.this._fDebit = true;
                    if (BankStatement_RowUI.this.txtCreditAmount.getBigDecimalValue() != null) {
                        BankStatement_RowUI.this.txtCreditAmount.setValue(null);
                    }
                }
            }
        });
        CalculatorF7Binder calcF7 = new CalculatorF7Binder((Container)this.getUIContext().get("Owner"));
        calcF7.bindF7Key((JComponent)this.txtCreditAmount, 6, true);
        calcF7.bindF7Key((JComponent)this.txtDebitAmount, 6, true);
        this.btnCalculator.setIcon(EASResource.getIcon((String)"imgTbtn_counter"));
        this.txtDebitAmount.setCommitsOnValidEdit(true);
        this.txtDebitAmount.setSelectAllOnFocus(true);
        this.txtDebitAmount.setHorizontalAlignment(4);
        this.txtDebitAmount.setSupportedEmpty(true);
        this.txtDebitAmount.setRemoveingZeroInDispaly(false);
        this.txtCreditAmount.setCommitsOnValidEdit(true);
        this.txtCreditAmount.setSelectAllOnFocus(true);
        this.txtCreditAmount.setHorizontalAlignment(4);
        this.txtCreditAmount.setSupportedEmpty(true);
        this.txtCreditAmount.setRemoveingZeroInDispaly(false);
        this.txtDesc.setMaxLength(255);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionNext.setVisible(false);
        this.actionPre.setVisible(false);
    }

    protected IObjectValue createNewData() {
        BankStatementInfo info = new BankStatementInfo();
        info.setCompany(this.company);
        Date date = (Date)this.pkBizDate.getValue();
        try {
            if (!EmptyUtil.isEmpty((CoreBaseInfo)this.company)) {
                this.casPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (date.after(this.casPeriod.getEndDate())) {
            date = this.casPeriod.getEndDate();
        }
        if (date.before(this.casPeriod.getBeginDate())) {
            date = this.casPeriod.getBeginDate();
        }
        this.pkBizDate.setValue((Object)date);
        Timestamp ts = new Timestamp(date.getTime());
        info.setBizTime(ts);
        try {
            info.setPeriod(PeriodUtils.getPeriodInfo((Date)DateHelper.getDayBegin(), (CompanyOrgUnitInfo)this._companyInfo));
        }
        catch (EASBizException e1) {
            this.handUIException(e1);
        }
        catch (BOSException e1) {
            this.handUIException(e1);
        }
        info.setVerifyStatus(VerifyScopeEnum.NOVA);
        info.setSource(BSSourceEnum.MANUAL);
        Map uiCtx = this.getUIContext();
        if (this.entityBankStatement != null && this.entityBankStatement.getAccountBank() != null) {
            info.setAccountBank(this.entityBankStatement.getAccountBank());
            info.setAccountView(this.entityBankStatement.getAccountView());
        } else if (uiCtx.get("BANK") != null) {
            AccountBankInfo bankInfo = (AccountBankInfo)uiCtx.get("BANK");
            info.setAccountBank(bankInfo);
            try {
                AccountViewInfo acctInfo = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccount().getId()));
                info.setAccountView(acctInfo);
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        if (this.prmtBank.getValue() != null) {
            info.setAccountBank((AccountBankInfo)this.prmtBank.getValue());
        } else {
            info.setAccountBank((AccountBankInfo)this.getUIContext().get("accountBank"));
        }
        info.setDebitAmount(Constants.ZERO);
        info.setCreditAmount(Constants.ZERO);
        return info;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BankStatementFactory.getRemoteInstance();
    }

    @Override
    protected void comboCurrency_itemStateChanged(ItemEvent e) throws Exception {
        if (e.getStateChange() != 1 || this.comboCurrency.getSelectedItem() == null) {
            return;
        }
        CurrencyInfo currencyInfo = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        int scale = FMClientHelper.getPrecOfCurrency((BOSUuid)currencyInfo.getId());
        this.txtCreditAmount.setPrecision(scale);
        this.txtDebitAmount.setPrecision(scale);
    }

    @Override
    protected void prmtBank_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtBank.getValue() == null) {
            this.txtAccount.setText(null);
            this.txtAccount.setUserObject(null);
            return;
        }
        AccountBankInfo bankInfo = (AccountBankInfo)this.prmtBank.getValue();
        if (bankInfo.getCompany() == null) {
            bankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(((AccountBankInfo)this.prmtBank.getValue()).getId().toString()));
        }
        this._companyInfo = this.company;
        CurrencyInfo localCurrency = null;
        localCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.company);
        if (bankInfo != null && bankInfo.isIsByCurrency()) {
            CurrencyInfo currencyInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(bankInfo.getCurrency().getId().toString()));
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currencyInfo);
            this.comboCurrency.setEnabled(false);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)localCurrency);
            this.comboCurrency.setEnabled(true);
        }
        Date bizDate = DateTimeUtils.truncateDate((Date)this.pkBizDate.getSqlDate());
        CompanyOrgUnitInfo cUnitInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        if (null != bizDate && null != cUnitInfo && null != bankInfo) {
            AccountViewInfo accountViewInfo = this.getAccountView(bizDate, cUnitInfo, bankInfo);
            if (!EmptyUtil.isEmpty((CoreBaseInfo)accountViewInfo)) {
                this.txtAccount.setText(accountViewInfo.toString());
                this.txtAccount.setUserObject((Object)accountViewInfo);
            } else {
                bankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(bankInfo.getId().toString()));
                accountViewInfo = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(bankInfo.getAccount().getId()));
                this.txtAccount.setText(accountViewInfo.toString());
                this.txtAccount.setUserObject((Object)accountViewInfo);
            }
        }
    }

    @Override
    protected void pkBizDate_dataChanged(DataChangeEvent e) throws Exception {
        if (this._companyInfo == null) {
            return;
        }
        Date date = (Date)this.pkBizDate.getValue();
        if (date == null || this._startPeriod != null && this._startPeriod.getBeginDate() != null && DateTimeUtils.dayBefore((Date)date, (Date)this._startPeriod.getBeginDate())) {
            this.txtPeriod.setUserObject(null);
            this.txtPeriod.setText(null);
            this.pkBizDate.setValue((Object)this._startPeriod.getBeginDate());
            return;
        }
        PeriodInfo periodInfo = PeriodUtils.getPeriodInfo((Date)date, (CompanyOrgUnitInfo)this._companyInfo);
        if (periodInfo != null && periodInfo.getId() != null) {
            this.txtPeriod.setUserObject((Object)periodInfo);
            Object[] args = new String[]{String.valueOf(periodInfo.getPeriodYear()), String.valueOf(periodInfo.getPeriodNumber())};
            this.txtPeriod.setText(MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"), args));
        } else {
            this.pkBizDate.setValue(e.getOldValue());
        }
        Date bizDate = DateTimeUtils.truncateDate((Date)this.pkBizDate.getSqlDate());
        CompanyOrgUnitInfo cUnitInfo = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        AccountBankInfo accountBankInfo = (AccountBankInfo)this.prmtBank.getValue();
        if (null != bizDate && null != cUnitInfo && null != accountBankInfo) {
            AccountViewInfo accountViewInfo = this.getAccountView(bizDate, cUnitInfo, accountBankInfo);
            if (!EmptyUtil.isEmpty((CoreBaseInfo)accountViewInfo)) {
                this.txtAccount.setText(accountViewInfo.toString());
                this.txtAccount.setUserObject((Object)accountViewInfo);
            } else {
                accountBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getId().toString()));
                accountViewInfo = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountBankInfo.getAccount().getId()));
                this.txtAccount.setText(accountViewInfo.toString());
                this.txtAccount.setUserObject((Object)accountViewInfo);
            }
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.prmtBank.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Bank_NullMsg"));
            SysUtil.abort();
        } else {
            AccountBankInfo bankInfo = (AccountBankInfo)this.prmtBank.getData();
            if (bankInfo.isIsClosed()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"434_BankJournalAddBatchUI"));
                SysUtil.abort();
            }
        }
        if (this.comboCurrency.getSelectedItem() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"Currency_NullMsg"));
            SysUtil.abort();
        }
        BigDecimal credit = this.txtCreditAmount.getBigDecimalValue();
        BigDecimal debit = this.txtDebitAmount.getBigDecimalValue();
        this.txtDebitAmount.requestFocusInWindow();
        BankStatementHandler.verfiyCreditDebit((Component)((Object)this), credit, debit);
        PeriodInfo periodInfo = ClientUtils.getCurrentPeriod((Component)((Object)this), this.company);
        Date beginDate = periodInfo.getBeginDate();
        java.sql.Date bizDate = this.pkBizDate.getSqlDate();
        if (!this.canAddPreviousBill && bizDate.compareTo(beginDate) < 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"cannotAddPervioursBill"));
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("company.id"));
        selectors.add(new SelectorItemInfo("company.number"));
        selectors.add(new SelectorItemInfo("company.name"));
        selectors.add(new SelectorItemInfo("accountBank.id"));
        selectors.add(new SelectorItemInfo("accountBank.name"));
        selectors.add(new SelectorItemInfo("accountBank.number"));
        selectors.add(new SelectorItemInfo("accountBank.account.id"));
        selectors.add(new SelectorItemInfo("accountBank.account.number"));
        selectors.add(new SelectorItemInfo("accountBank.account.name"));
        selectors.add(new SelectorItemInfo("accountBank.shareType"));
        selectors.add(new SelectorItemInfo("currency.id"));
        selectors.add(new SelectorItemInfo("currency.name"));
        selectors.add(new SelectorItemInfo("currency.precision"));
        selectors.add(new SelectorItemInfo("period.periodYear"));
        selectors.add(new SelectorItemInfo("period.periodNumber"));
        selectors.add(new SelectorItemInfo("accountView.id"));
        selectors.add(new SelectorItemInfo("accountView.name"));
        selectors.add(new SelectorItemInfo("accountView.number"));
        selectors.add(new SelectorItemInfo("*"));
        return selectors;
    }

    @Override
    public void actionCalc_actionPerformed(ActionEvent e) throws Exception {
        boolean fDebit = this.txtDebitAmount.hasFocus();
        boolean fCredit = this.txtCreditAmount.hasFocus();
        if (this.calc == null) {
            this.calc = new CalculatorDialog((Container)this.getUIContext().get("Owner"));
        }
        this.calc.setInitValue(null);
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        int pre = 2;
        if (currency != null) {
            pre = currency.getPrecision();
        }
        BigDecimal value = this.calc.showDialog(pre, true);
        if (fDebit) {
            this.txtDebitAmount.setValue((Object)value);
        }
        if (fCredit) {
            this.txtCreditAmount.setValue((Object)value);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent arg0) throws Exception {
        String param;
        Object[] objects;
        String msg;
        int result;
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(((CompanyOrgUnitInfo)this.prmtCompany.getData()).getId().toString()), "cas_bankstatement_02addNew");
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)this.pkBizDate.getValue());
        AccountBankInfo acctInfo = (AccountBankInfo)this.prmtBank.getValue();
        CompanyOrgUnitInfo acctCompany = CashClientHelper.getAcctMainSharedAcct(acctInfo);
        PeriodInfo curPeriod = CashClientHelper.getCurrentPeriod(acctCompany);
        String currentYear = String.valueOf(curPeriod.getPeriodYear());
        String currentMonth = String.valueOf(curPeriod.getNumber()).substring(4);
        boolean isPeriod = CashHelper.isDatePeriod(calendar.getTime(), curPeriod, this.company);
        if (!isPeriod && (result = MsgBox.showConfirm2((Component)((Object)this), (String)MessageFormat.format(msg = EASResource.getString((String)casResourcePath, (String)"oneDateNotPeriod"), objects = new Object[]{DateFormat.getDateInstance().format(calendar.getTime()), currentYear, currentMonth}))) == 2) {
            SysUtil.abort();
        }
        if ((param = this.context.getStringParam("CS114", (IObjectPK)new ObjectUuidPK(this.company.getId()))) != null && param.toString().equals("1")) {
            ObjectUuidPK acctBankPK = new ObjectUuidPK(((AccountBankInfo)this.prmtBank.getValue()).getId());
            AccountBankInfo acctBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)acctBankPK);
            if (acctBank.isIsSetBankInterface()) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.BankStatementResource", (String)"notAllowBankInterface"));
                return;
            }
        }
        ((BankStatementInfo)this.editData).setCompany(this.company);
        super.actionSubmit_actionPerformed(arg0);
        this.storeFields();
        this.initOldData((IObjectValue)this.editData);
    }

    public void afterMainOrgChanged(OrgChangeVO chgVo) {
        if (chgVo == null || !chgVo.isDiffrent()) {
            return;
        }
        if (chgVo.getNewOrg() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"433_BankJournalAddBatchUI"));
            SysUtil.abort();
        }
        try {
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)chgVo.getNewOrg()));
            PeriodInfo currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)chgVo.getNewOrg()));
            if (null == startPeriod) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"435_BankJournalAddBatchUI"));
                this.prmtCompany.setValue(chgVo.getOldOrg());
                return;
            }
            Context mainContext = this.orgContextManager.getMainOrgContext();
            this.context = ContextHelperFactory.getRemoteInstanceWithContext((Context)mainContext);
            this.company = this.context.getCurrentCompany();
            this.entityBankStatement.setCompany(this.company);
            this.initViewControl();
            this.pkBizDate.setValue((Object)currentPeriod.getEndDate());
            String[] args = new String[]{String.valueOf(currentPeriod.getPeriodYear()), String.valueOf(currentPeriod.getPeriodNumber())};
            MessageFormat mf = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"));
            String result = mf.format(args);
            this.txtPeriod.setText(result);
            this.setBankF7(this.prmtBank, this.company, false);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public IF7ContextChange getF7ContextManager() {
        if (this.F7ContextManager == null) {
            this.F7ContextManager = new DefaultF7ContextManager((Component)((Object)this), OrgType.Company, ContextTypeEnum.INQUERYING, 0);
            return this.F7ContextManager;
        }
        return this.F7ContextManager;
    }

    public IF7Register getF7Register() {
        if (this.F7ContextManager == null) {
            this.F7ContextManager = new DefaultF7ContextManager((Component)((Object)this), OrgType.Company, ContextTypeEnum.INQUERYING, 0);
            return this.F7ContextManager;
        }
        return this.F7ContextManager;
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public String getMainOrgKeyForCustomerParams(OrgType orgType) {
        return null;
    }

    public OrgType getMainOrgType() {
        return OrgType.Company;
    }

    public String getPermissionItem() {
        return "cas_bankstatement_02addNew";
    }

    public boolean isSupportMultiOrgs() {
        return false;
    }

    public boolean isSupportVirturalOrgs() {
        return false;
    }

    private void setBankF7(KDBizPromptBox prmt, CompanyOrgUnitInfo info, boolean isClosed) throws BOSException, EASBizException {
        int i;
        ClientUtils.setBankListIncludeShared(prmt, info.getId().toString(), isClosed);
        String companyId = info.getId().toString();
        FilterInfo fi = new FilterInfo();
        if (!EmptyUtil.isEmpty((String)companyId)) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId));
        }
        if (!isClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        fi.getFilterItems().add(new FilterItemInfo("isBank", (Object)FMConstants.TRUE));
        fi.getFilterItems().add(new FilterItemInfo("shareType", (Object)0, CompareType.EQUALS));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("shareBalanceOfAcctCompany.id", (Object)companyId, CompareType.EQUALS));
        view.setFilter(filter);
        SharedAcctCollection coll = SharedAcctFactory.getRemoteInstance().getSharedAcctCollection(view);
        HashSet<String> sharedAcctSet = new HashSet<String>();
        for (int i2 = 0; i2 < coll.size(); ++i2) {
            SharedAcctInfo sharedAcct = coll.get(i2);
            sharedAcctSet.add(sharedAcct.getBankAccount().getId().toString());
        }
        if (!EmptyUtil.isEmpty(sharedAcctSet)) {
            fi.getFilterItems().add(new FilterItemInfo("id", sharedAcctSet, CompareType.INCLUDE));
            if (!isClosed) {
                fi.setMaskString("((#0 and #1 and #2 and #3) or #4)");
            } else {
                fi.setMaskString("((#0 and #1 and #2) or #3)");
            }
        }
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            ObjectUuidPK orgPK = new ObjectUuidPK(info.getId().toString());
            String sql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
            if (!EmptyUtil.isEmpty((String)sql.trim())) {
                FilterInfo filt = new FilterInfo();
                filt.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
                fi.mergeFilter(filt, "AND");
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("*");
        selectors.add("bank.*");
        selectors.add("account.*");
        evi.getSorter().add(new SorterItemInfo("number"));
        try {
            ObjectUuidPK userPK = new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString());
            ObjectUuidPK orgPK = new ObjectUuidPK(this.company.getId().toString());
            String sql = PermissionFactory.getRemoteInstance().getQueryPermissionSQL((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
            if (!EmptyUtil.isEmpty((String)sql.trim())) {
                fi.getFilterItems().add(new FilterItemInfo("id", (Object)sql, CompareType.INNER));
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
        AccountBankCollection acctBankCol = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        prmt.setEntityViewInfo(evi);
        EventListener[] el = prmt.getListeners(DataChangeListener.class);
        for (i = 0; i < el.length; ++i) {
            prmt.removeDataChangeListener((DataChangeListener)el[i]);
        }
        for (i = 0; i < el.length; ++i) {
            prmt.addDataChangeListener((DataChangeListener)el[i]);
        }
        prmt.setValue((Object)acctBankCol.get(0));
    }
}

