/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BSSourceEnum;
import com.kingdee.eas.fi.cas.BankStatementInfo;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fi.cas.client.BankStatementFilterParam;
import com.kingdee.eas.fi.cas.client.BankStatementHandler;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.be.TransdetailSourceEnum;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class BankStmtListDataLoader {
    protected static final String LBL_DAY = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_Day");
    protected static final String LBL_DAYSTART = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_DayStart");
    protected static final String LBL_PERIOD = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_Period");
    protected static final String LBL_START = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_PeriodStart");
    protected static final String LBL_YEAR = EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"BankStmt_Year");
    private static final Logger logger = Logger.getLogger(BankStmtListDataLoader.class);
    private BigDecimal curBal = SysConstant.BIGZERO;
    private Date curDate = null;
    private BigDecimal dayCredit = SysConstant.BIGZERO;
    private BigDecimal dayDebit = SysConstant.BIGZERO;
    private BankStatementFilterParam filterParams = null;
    private BigDecimal periodCredit = SysConstant.BIGZERO;
    private BigDecimal periodDebit = SysConstant.BIGZERO;
    private int periodIndex = 0;
    private int periodSize = 0;
    private Date preDate = null;
    private PeriodCollection qryPeriods = null;
    private KDTable tblMain = null;
    private String accountBankId = null;
    private String currencyId = null;

    public BankStmtListDataLoader(BankStatementFilterParam filters, String accountBankId, String currencyId, KDTable tbl) {
        this.accountBankId = accountBankId;
        this.currencyId = currencyId;
        this.filterParams = filters;
        this.tblMain = tbl;
    }

    private void appendDataAndStatistics(IRowSet rs, BankStatementInfo startInfo) throws SQLException {
        boolean fHasDayStart;
        PeriodInfo curPeriod = null;
        PeriodInfo prePeriod = null;
        BigDecimal yearDebit = startInfo.getBigDecimal("yeardebit");
        BigDecimal yearCredit = startInfo.getBigDecimal("yearcreadit");
        this.curBal = startInfo.getBigDecimal("balance");
        boolean bl = fHasDayStart = this.filterParams.isByDate() && this.filterParams.isMonthStart();
        if (fHasDayStart) {
            this.appendStatisticRow(this.filterParams.getBeginDate(), LBL_DAYSTART, null, null, this.curBal, ClientUtils.PERIOD_TOTAL_COLOR);
        }
        rs.beforeFirst();
        while (rs.next()) {
            int periodChange;
            this.curDate = rs.getDate("createDate");
            String periodId = rs.getString("period.id");
            if (this.preDate != null && prePeriod != null && !periodId.equals(prePeriod.getId().toString()) && this.periodIndex + 1 < this.periodSize) {
                ++this.periodIndex;
            }
            curPeriod = this.qryPeriods.get(this.periodIndex);
            if (this.filterParams.isDaySum() && this.preDate != null && !ClientUtils.isSameDay(this.curDate, this.preDate)) {
                this.appendStatisticRow(this.preDate, LBL_DAY, this.dayDebit, this.dayCredit, this.curBal, ClientUtils.DAY_SUM_COLOR);
                this.dayDebit = SysConstant.BIGZERO;
                this.dayCredit = SysConstant.BIGZERO;
            }
            if ((periodChange = this.periodCompare(prePeriod, curPeriod)) == -1 || periodChange == 1) {
                if (this.preDate != null && prePeriod != null) {
                    Date prePeriodEnd = new Date(prePeriod.getEndDate().getTime());
                    if (this.filterParams.isMonthSum()) {
                        this.appendStatisticRow(prePeriodEnd, LBL_PERIOD, this.periodDebit, this.periodCredit, this.curBal, ClientUtils.PERIOD_TOTAL_COLOR);
                    }
                    if (this.filterParams.isYearSum()) {
                        this.appendStatisticRow(prePeriodEnd, LBL_YEAR, yearDebit, yearCredit, this.curBal, ClientUtils.YEAR_TOTAL_COLOR);
                    }
                    this.periodDebit = SysConstant.BIGZERO;
                    this.periodCredit = SysConstant.BIGZERO;
                }
                if (!periodId.equals(curPeriod.getId().toString())) {
                    PeriodCollection noDataPeriods = new PeriodCollection();
                    do {
                        noDataPeriods.add(curPeriod);
                        if (this.periodIndex + 1 >= this.periodSize) break;
                        ++this.periodIndex;
                    } while (!periodId.equals((curPeriod = this.qryPeriods.get(this.periodIndex)).getId().toString()));
                    BankStatementInfo statInfo = new BankStatementInfo();
                    statInfo.setBigDecimal("yeardebit", yearDebit);
                    statInfo.setBigDecimal("yearcreadit", yearCredit);
                    statInfo.put("balance", this.curBal);
                    this.appendStatisticForNullData(noDataPeriods, statInfo);
                }
                if (this.filterParams.isMonthStart()) {
                    boolean fHasRow;
                    boolean bl2 = fHasRow = !this.filterParams.isByDate() || this.filterParams.isByDate() && !ClientUtils.isInSamePeriod(this.filterParams.getBeginDate(), curPeriod);
                    if (fHasRow) {
                        Date periodStartDay = new Date(curPeriod.getBeginDate().getTime());
                        this.appendStatisticRow(periodStartDay, LBL_START, null, null, this.curBal, ClientUtils.PERIOD_START_COLOR);
                    }
                }
            }
            if (prePeriod != null && curPeriod.getPeriodYear() != prePeriod.getPeriodYear()) {
                yearDebit = SysConstant.BIGZERO;
                yearCredit = SysConstant.BIGZERO;
            }
            BigDecimal debit = rs.getBigDecimal("debitAmount");
            BigDecimal credit = rs.getBigDecimal("creditAmount");
            if (debit == null) {
                debit = SysConstant.BIGZERO;
            }
            if (credit == null) {
                credit = SysConstant.BIGZERO;
            }
            this.dayDebit = this.dayDebit.add(debit);
            this.dayCredit = this.dayCredit.add(credit);
            this.periodDebit = this.periodDebit.add(debit);
            this.periodCredit = this.periodCredit.add(credit);
            yearDebit = yearDebit.add(debit);
            yearCredit = yearCredit.add(credit);
            this.curBal = this.curBal.add(credit).subtract(debit);
            this.loadDataToRow(rs, this.curBal);
            this.preDate = this.curDate;
            prePeriod = curPeriod;
        }
        if (this.filterParams.isDaySum()) {
            this.appendStatisticRow(this.preDate, LBL_DAY, this.dayDebit, this.dayCredit, this.curBal, ClientUtils.DAY_SUM_COLOR);
        }
        if (this.hasPeriodSumRow(curPeriod)) {
            Date endDate = new Date(curPeriod.getEndDate().getTime());
            if (this.filterParams.isByDate() && endDate.after(this.filterParams.getEndDate())) {
                endDate = this.filterParams.getEndDate();
            }
            if (this.filterParams.isMonthSum()) {
                this.appendStatisticRow(endDate, LBL_PERIOD, this.periodDebit, this.periodCredit, this.curBal, ClientUtils.PERIOD_TOTAL_COLOR);
            }
            if (this.filterParams.isYearSum()) {
                this.appendStatisticRow(endDate, LBL_YEAR, yearDebit, yearCredit, this.curBal, ClientUtils.YEAR_TOTAL_COLOR);
            }
        }
        if (this.periodIndex + 1 < this.periodSize) {
            PeriodCollection noDataPeriods = new PeriodCollection();
            while (this.periodIndex + 1 < this.periodSize) {
                ++this.periodIndex;
                curPeriod = this.qryPeriods.get(this.periodIndex);
                noDataPeriods.add(curPeriod);
            }
            startInfo.setBigDecimal("yeardebit", yearDebit);
            startInfo.setBigDecimal("yearcreadit", yearCredit);
            startInfo.put("balance", this.curBal);
            this.appendStatisticForNullData(noDataPeriods, startInfo);
        }
    }

    private void appendStatisticForNullData(PeriodCollection periods, BankStatementInfo startInfo) {
        if (!this.hasStatisticRows()) {
            return;
        }
        if (periods.size() == 0) {
            return;
        }
        BigDecimal balance = startInfo.getBigDecimal("balance");
        BigDecimal yearDebit = startInfo.getBigDecimal("yeardebit");
        BigDecimal yearCredit = startInfo.getBigDecimal("yearcreadit");
        if (periods.get(0).getPeriodNumber() == 1) {
            yearDebit = FMConstants.ZERO;
            yearCredit = FMConstants.ZERO;
        }
        PeriodInfo prePeriod = null;
        int n = periods.size();
        for (int i = 0; i < n; ++i) {
            PeriodInfo curPeriod = periods.get(i);
            if (prePeriod != null && curPeriod.getPeriodYear() != prePeriod.getPeriodYear()) {
                yearDebit = SysConstant.BIGZERO;
                yearCredit = SysConstant.BIGZERO;
            }
            Date startDate = new Date(curPeriod.getBeginDate().getTime());
            Date periodEndDate = new Date(curPeriod.getEndDate().getTime());
            boolean fHasPeriodSum = this.hasPeriodSumRow(curPeriod);
            if (this.filterParams.isMonthStart() && this.hasPeriodStartRow(curPeriod)) {
                this.appendStatisticRow(startDate, LBL_START, null, null, balance, ClientUtils.PERIOD_TOTAL_COLOR);
            }
            if (this.filterParams.isMonthSum() && fHasPeriodSum) {
                this.appendStatisticRow(periodEndDate, LBL_PERIOD, null, null, balance, ClientUtils.PERIOD_TOTAL_COLOR);
            }
            if (this.filterParams.isYearSum() && fHasPeriodSum) {
                this.appendStatisticRow(periodEndDate, LBL_YEAR, yearDebit, yearCredit, balance, ClientUtils.YEAR_TOTAL_COLOR);
            }
            prePeriod = curPeriod;
        }
    }

    private void appendStatisticRow(Date dispDate, String lblDesc, BigDecimal debitAmount, BigDecimal creditAmount, BigDecimal balance, Color rowColor) {
        IRow row = this.tblMain.addRow();
        row.getCell("createDate").setValue((Object)dispDate);
        row.getCell("description").setValue((Object)lblDesc);
        if (debitAmount != null && debitAmount.signum() != 0) {
            row.getCell("debitAmount").setValue((Object)debitAmount);
        }
        if (creditAmount != null && creditAmount.signum() != 0) {
            row.getCell("creditAmount").setValue((Object)creditAmount);
        }
        if (balance != null) {
            row.getCell("balance").setValue((Object)balance);
        }
        logger.debug((Object)(dispDate + ", " + lblDesc + ", " + balance));
        row.getStyleAttributes().setBackground(rowColor);
    }

    private boolean hasPeriodStartRow(PeriodInfo period) {
        boolean fHasRow = !this.filterParams.isByDate();
        fHasRow = fHasRow || this.filterParams.isByDate() && !ClientUtils.isInSamePeriod(this.filterParams.getBeginDate(), period);
        return fHasRow;
    }

    private boolean hasPeriodSumRow(PeriodInfo period) {
        boolean fHasRow = !this.filterParams.isByDate();
        fHasRow = fHasRow || this.filterParams.isByDate();
        return fHasRow;
    }

    private boolean hasStatisticRows() {
        return this.filterParams.isMonthStart() || this.filterParams.isMonthSum() || this.filterParams.isYearSum() || this.filterParams.isDaySum();
    }

    private void initPeriods() throws BOSException, EASBizException {
        this.qryPeriods = BankStatementHandler.getQryPeriods(this.filterParams);
    }

    private void loadDataToRow(IRowSet rs, BigDecimal balance) {
        IRow row = this.tblMain.addRow();
        row.getStyleAttributes().setBackground(ClientUtils.NORMAL_COLOR);
        int n = this.tblMain.getColumnCount();
        for (int i = 0; i < n; ++i) {
            ICell cell = row.getCell(i);
            String colField = this.tblMain.getColumn(i).getKey();
            if (colField.equals("balance")) {
                cell.setValue((Object)balance);
                continue;
            }
            try {
                if (rs.getObject(colField) == null) continue;
                if (colField.equals("verifyStatus")) {
                    cell.setValue((Object)rs.getBoolean(colField));
                    continue;
                }
                if (colField.equals("source")) {
                    cell.setValue((Object)BSSourceEnum.getEnum(rs.getInt(colField)));
                    continue;
                }
                if (colField.equals("debitAmount") || colField.equals("creditAmount")) {
                    BigDecimal amt = rs.getBigDecimal(colField);
                    if (amt.signum() == 0) continue;
                    cell.setValue((Object)amt);
                    continue;
                }
                if (colField.equals("transdetailSource")) {
                    cell.setValue((Object)TransdetailSourceEnum.getEnum((int)rs.getInt(colField)));
                    continue;
                }
                cell.setValue(rs.getObject(colField));
                continue;
            }
            catch (SQLException ex) {
                logger.error((Object)("while load fields:" + colField));
            }
        }
        logger.debug((Object)balance);
    }

    public void loadDataToTable(IRowSet rs, String bankId, String currencyId, String accountId, String companyId) throws BOSException, EASBizException, SQLException {
        this.resetProperties();
        this.initPeriods();
        if (this.qryPeriods == null || this.qryPeriods.size() == 0) {
            return;
        }
        if (this.filterParams.isByDate()) {
            java.util.Date firstDate = DateHelper.getFirstDayOfMonth((java.util.Date)this.filterParams.getBeginDate());
            if (this.filterParams.getBeginDate().compareTo(firstDate) > 0) {
                java.util.Date startDate = firstDate;
                java.util.Date periodEndDate = DateHelper.getBeforeDay((java.util.Date)this.filterParams.getBeginDate());
                ICashManagement cashInacct = CashManagementFactory.getRemoteInstance();
                BigDecimal debit = cashInacct.getBStateData(companyId, this.accountBankId, currencyId, startDate, periodEndDate, CashDataTypeEnum.JF, true);
                BigDecimal credit = cashInacct.getBStateData(companyId, this.accountBankId, currencyId, startDate, periodEndDate, CashDataTypeEnum.DF, true);
                this.periodDebit = this.periodDebit.add(debit);
                this.periodCredit = this.periodCredit.add(credit);
            }
        }
        this.periodSize = this.qryPeriods.size();
        logger.debug((Object)("table row size: " + this.tblMain.getRowCount() + ",  " + System.currentTimeMillis()));
        this.tblMain.setRefresh(false);
        BankStatementInfo startInfo = BankStatementHandler.getStartAmts(this.filterParams, bankId, currencyId, accountId, companyId);
        if (rs == null || rs.size() == 0) {
            boolean fHasDayStart;
            boolean bl = fHasDayStart = this.filterParams.isByDate() && this.filterParams.isMonthStart();
            if (fHasDayStart) {
                this.appendStatisticRow(this.filterParams.getBeginDate(), LBL_DAYSTART, null, null, startInfo.getBigDecimal("balance"), ClientUtils.PERIOD_TOTAL_COLOR);
                PeriodInfo curPeriod = this.qryPeriods.get(0);
                this.qryPeriods.remove(curPeriod);
                Date periodEndDate = new Date(curPeriod.getEndDate().getTime());
                this.curBal = startInfo.getBigDecimal("balance");
                BigDecimal yearDebit = startInfo.getBigDecimal("yeardebit");
                BigDecimal yearCredit = startInfo.getBigDecimal("yearcreadit");
                if (this.filterParams.isMonthSum()) {
                    this.appendStatisticRow(periodEndDate, LBL_PERIOD, this.periodDebit, this.periodCredit, this.curBal, ClientUtils.PERIOD_TOTAL_COLOR);
                }
                if (this.filterParams.isYearSum()) {
                    this.appendStatisticRow(periodEndDate, LBL_YEAR, yearDebit, yearCredit, this.curBal, ClientUtils.YEAR_TOTAL_COLOR);
                }
            }
            this.appendStatisticForNullData(this.qryPeriods, startInfo);
        } else {
            if (this.filterParams.isByDate()) {
                java.util.Date firstDate = DateHelper.getFirstDayOfMonth((java.util.Date)this.filterParams.getBeginDate());
                if (this.filterParams.getBeginDate().compareTo(firstDate) > 0) {
                    // empty if block
                }
            }
            if (this.filterParams.isByDate()) {
                // empty if block
            }
            this.appendDataAndStatistics(rs, startInfo);
        }
        this.tblMain.setRefresh(true);
        this.tblMain.reLayoutAndPaint();
    }

    private int periodCompare(PeriodInfo periodA, PeriodInfo periodB) {
        boolean fChange = false;
        if (periodA == null || periodB == null) {
            return -1;
        }
        fChange = periodA.getPeriodYear() != periodB.getPeriodYear();
        fChange = fChange || periodA.getPeriodYear() == periodB.getPeriodYear() && periodA.getPeriodNumber() != periodB.getPeriodNumber();
        return fChange ? 1 : 0;
    }

    private void resetProperties() {
        this.periodIndex = 0;
        this.periodSize = 0;
        this.curDate = null;
        this.preDate = null;
        this.dayCredit = SysConstant.BIGZERO;
        this.dayDebit = SysConstant.BIGZERO;
        this.periodDebit = SysConstant.BIGZERO;
        this.periodCredit = SysConstant.BIGZERO;
        this.curBal = SysConstant.BIGZERO;
    }

    public void setFilterParams(BankStatementFilterParam filters) {
        this.filterParams = filters;
    }
}

