/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.SettlementTypeInfo;
import com.kingdee.eas.basedata.assistant.VoucherTypeInfo;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CashMgtInitFacadeFactory;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractCashMgtInitJournalHandler;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.util.Date;

public class BankUnreachedInitJournalHandler
extends AbstractCashMgtInitJournalHandler {
    @Override
    public void initTable(String currencyId) throws Exception {
        super.initTable(currencyId);
    }

    private JournalCollection getJournalCollection() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(this.getFilterInfo());
        SelectorItemCollection selectors = viewInfo.getSelector();
        selectors.addObjectCollection((IObjectCollection)this.getSelectors());
        selectors.add("assisDate");
        selectors.add("settlementType.name");
        selectors.add("settlementNumber");
        selectors.add("voucherType.id");
        selectors.add("voucherType.name");
        selectors.add("voucherNumber");
        selectors.add("billType");
        selectors.add("billNumber");
        selectors.add("verifyStatus");
        JournalCollection journals = JournalFactory.getRemoteInstance().getJournalCollection(viewInfo);
        return journals;
    }

    @Override
    public void loadFields() throws Exception {
        super.loadFields();
        JournalCollection journals = this.getJournalCollection();
        IRow row = null;
        for (JournalInfo journalInfo : journals) {
            row = this.table.addRow();
            row.getCell("createDate").setValue((Object)journalInfo.getCreateDate());
            row.getCell("description").setValue((Object)journalInfo.getDescription());
            row.getCell("settlementType").setValue((Object)journalInfo.getSettlementType());
            row.getCell("settlementNumber").setValue((Object)journalInfo.getSettlementNumber());
            row.getCell("debitAmt").setValue((Object)journalInfo.getDebitAmount());
            row.getCell("creditAmt").setValue((Object)journalInfo.getCreditAmount());
            row.getCell("assisDate").setValue((Object)journalInfo.getAssisDate());
            row.getCell("voucherType").setValue((Object)journalInfo.getVoucherType());
            row.getCell("voucherNumber").setValue((Object)journalInfo.getVoucherNumber());
            row.getCell("billType").setValue((Object)journalInfo.getBillType());
            row.getCell("billNumber").setValue((Object)journalInfo.getBillNumber());
            row.setUserObject((Object)journalInfo);
            if (journalInfo == null || !journalInfo.getVerifyStatus().equals((Object)VerifyScopeEnum.WHOLE)) continue;
            row.getStyleAttributes().setLocked(true);
        }
    }

    @Override
    public void storeFields() throws Exception {
        super.storeFields();
        JournalCollection journals = new JournalCollection();
        int rowCount = this.table.getRowCount();
        IRow row = null;
        JournalInfo journalInfo = null;
        BigDecimal debitAmt = null;
        BigDecimal creditAmt = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.table.getRow(i);
            journalInfo = (JournalInfo)row.getUserObject();
            if (journalInfo == null) {
                journalInfo = new JournalInfo();
            }
            journalInfo.setCreateDate((Date)TypeConversionUtils.objToDate((Object)row.getCell("createDate").getValue()));
            journalInfo.setDescription((String)row.getCell("description").getValue());
            journalInfo.setSettlementType((SettlementTypeInfo)row.getCell("settlementType").getValue());
            journalInfo.setSettlementNumber((String)row.getCell("settlementNumber").getValue());
            debitAmt = TypeConversionUtils.objToBigDecimal((Object)row.getCell("debitAmt").getValue());
            journalInfo.setDebitAmount(debitAmt == null ? CasConstants.ZERO : debitAmt);
            creditAmt = TypeConversionUtils.objToBigDecimal((Object)row.getCell("creditAmt").getValue());
            journalInfo.setCreditAmount(creditAmt == null ? CasConstants.ZERO : creditAmt);
            journalInfo.setAssisDate((Date)TypeConversionUtils.objToDate((Object)row.getCell("assisDate").getValue()));
            journalInfo.setVoucherType((VoucherTypeInfo)row.getCell("voucherType").getValue());
            journalInfo.setVoucherNumber((String)row.getCell("voucherNumber").getValue());
            if (row.getCell("billType").getValue() != null) {
                journalInfo.setBillType((BillTypeEnum)((Object)row.getCell("billType").getValue()));
            } else {
                journalInfo.setBillType(BillTypeEnum.other);
            }
            journalInfo.setBillNumber((String)row.getCell("billNumber").getValue());
            if (journalInfo.getDebitAmount().signum() > 0) {
                journalInfo.setIsDebit(true);
            } else {
                journalInfo.setIsDebit(false);
            }
            journalInfo.setAccountBank(this.accountBank);
            journalInfo.setAccountView(this.accountView);
            journalInfo.setCurrency(this.currency);
            journalInfo.setCompany(ContextHelperFactory.getRemoteInstance().getCurrentCompany());
            journalInfo.setType(JournalTypeEnum.BANK);
            if (journalInfo.get("verifyStatus") == null) {
                journalInfo.setVerifyStatus(VerifyScopeEnum.NOVA);
            }
            journalInfo.setSource(JournalSourceEnum.BYHAND);
            journalInfo.setHasEffected(false);
            journalInfo.setBizDate(journalInfo.getAssisDate());
            journals.add(journalInfo);
        }
        CashMgtInitFacadeFactory.getRemoteInstance().saveBankUnreachInit(this.getFilterInfo(), journals);
    }
}

