/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexLockType;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.Uuid;
import java.math.BigDecimal;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class BankVCHelper {
    private static Logger logger = Logger.getLogger((String)BankVCHelper.class.getName());
    private static String BANKVC_MUTEX_LOCK = "BANKVC_Mutex_Lock";
    private static String loc;

    public static String getBankStatSQL() {
        loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        StringBuffer sbBankStatement = new StringBuffer();
        sbBankStatement.append("SELECT BANKSTATEMENT.FID AS \"ID\", BANKSTATEMENT.FCreateDate AS CREATEDATE, BANKSTATEMENT.FDescription AS \"DESCRIPTION\", SETTLETYPE.FName_").append(loc).append("  AS \"SETTLETYPE.NAME\", ");
        sbBankStatement.append("BANKSTATEMENT.FSettleNumber AS SETTLENUMBER, BANKSTATEMENT.FDebitAmount AS DEBITAMOUNT, BANKSTATEMENT.FCreditAmount AS CREDITAMOUNT, BANKSTATEMENT.FVerifyStatus AS VERIFYSTATUS, ");
        sbBankStatement.append("BANKSTATEMENT.FSequenceNumber AS SEQUENCENUMBER, BANKSTATEMENT.FTradeNumber AS TRADENUMBER, BANKSTATEMENT.FCashier AS CASHIER, BANKSTATEMENT.FOppAccountNumber AS OPPACCOUNTNUMBER, ");
        sbBankStatement.append("BANKSTATEMENT.FVoucherNumber AS VOUCHERNUMBER, ");
        sbBankStatement.append("COMPANY.FID AS \"COMPANY.ID\", ");
        sbBankStatement.append("COMPANY.FName_L2 AS COMPANY_NAME ");
        sbBankStatement.append("FROM T_CAS_BankStatement AS BANKSTATEMENT ");
        sbBankStatement.append("LEFT OUTER JOIN T_BD_AccountBanks AS ACCOUNTBANK ON BANKSTATEMENT.FAccountBankID = ACCOUNTBANK.FID ");
        sbBankStatement.append("LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON BANKSTATEMENT.FCurrencyId = CURRENCY.FID ");
        sbBankStatement.append("LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTVIEW ON BANKSTATEMENT.FAccountViewId = ACCOUNTVIEW.FID ");
        sbBankStatement.append("LEFT OUTER JOIN T_BD_SettlementType AS SETTLETYPE ON BANKSTATEMENT.FSettleTypeID = SETTLETYPE.FID ");
        sbBankStatement.append("LEFT OUTER JOIN T_ORG_Company AS COMPANY ON BANKSTATEMENT.FCompanyID = COMPANY.FID ");
        sbBankStatement.append("where BANKSTATEMENT.FID IN ");
        String sqlBankStatement = sbBankStatement.toString();
        return sqlBankStatement;
    }

    public static String getJournalSQL() {
        StringBuffer sbJournal = new StringBuffer();
        loc = LocaleUtils.getLocaleString((Locale)SysContext.getSysContext().getLocale());
        sbJournal.append("SELECT JOURNAL.FBillNumber AS BILLNUMBER , JOURNAL.FBillType AS BILLTYPE, JOURNAL.FCreateDate AS CREATEDATE, JOURNAL.FBizDate AS BIZDATE,JOURNAL.FVoucherNumber AS VOUCHERNUMBER, JOURNAL.FSettlementNumber AS SETTLEMENTNUMBER, JOURNAL.FDebitAmount AS DEBITAMOUNT, ");
        sbJournal.append("JOURNAL.FCreditAmount AS CREDITAMOUNT, JOURNAL.FDescription AS DESCRIPTION, JOURNAL.FHasEffected AS HASEFFECTED, SETTLEMENTTYPE.FName_").append(loc).append("  AS \"SETTLEMENTTYPE.NAME\", ");
        sbJournal.append("VOUCHERTYPE.FName_").append(loc).append("  AS \"VOUCHERTYPE.NAME\", OPPACCOUNTVIEW.FNumber AS \"OPPACCOUNTVIEW.NUMBER\", ACCOUNTBANK.FName_").append(loc).append("  AS \"ACCOUNTBANK.NAME\", ");
        sbJournal.append("ACCOUNTVIEW.FLongNumber AS \"ACCOUNTVIEW.LONGNUMBER\", ACCOUNTBANK.FNumber AS \"ACCOUNTBANK.NUMBER\", CASHIER.FName_").append(loc).append("  AS \"CASHIER.NAME\", ");
        sbJournal.append("CURRENCY.FID AS \"CURRENCY.ID\", COMPANY.FID AS \"COMPANY.ID\", JOURNAL.FAccountBankID AS BANKACCOUNTID, JOURNAL.FAccountViewID AS ACCOUNTVIEWID, JOURNAL.FID AS \"ID\", ");
        sbJournal.append("COMPANY.FNAME_L2 AS COMPANY_NAME ");
        sbJournal.append("FROM T_CAS_Journal AS JOURNAL ");
        sbJournal.append("LEFT OUTER JOIN T_BD_SettlementType AS SETTLEMENTTYPE ON JOURNAL.FSettlementTypeId = SETTLEMENTTYPE.FID ");
        sbJournal.append("LEFT OUTER JOIN T_BD_VoucherTypes AS VOUCHERTYPE ON JOURNAL.FVoucherTypeID = VOUCHERTYPE.FID ");
        sbJournal.append("LEFT OUTER JOIN T_BD_AccountView AS OPPACCOUNTVIEW ON JOURNAL.FOppAccountViewId = OPPACCOUNTVIEW.FID ");
        sbJournal.append("LEFT OUTER JOIN T_BD_Currency AS CURRENCY ON JOURNAL.FCurrencyID = CURRENCY.FID ");
        sbJournal.append("LEFT OUTER JOIN T_BD_AccountBanks AS ACCOUNTBANK ON JOURNAL.FAccountBankID = ACCOUNTBANK.FID ");
        sbJournal.append("LEFT OUTER JOIN T_BD_AccountView AS ACCOUNTVIEW ON JOURNAL.FAccountViewID = ACCOUNTVIEW.FID ");
        sbJournal.append("LEFT OUTER JOIN T_ORG_Company AS COMPANY ON JOURNAL.FCompanyID = COMPANY.FID ");
        sbJournal.append("LEFT OUTER JOIN T_PM_User AS CASHIER ON JOURNAL.FCashierId = CASHIER.FID ");
        sbJournal.append("where JOURNAL.FID in ");
        String sqlJournal = sbJournal.toString();
        return sqlJournal;
    }

    public static IRowSet getBankRowsetBySQL(Set idSet, int scale) {
        return BankVCHelper.getRowsetBySQL(new StringBuffer(BankVCHelper.getBankStatSQL()), idSet, scale);
    }

    public static IRowSet getJournalRowsetBySQL(Set idSet, int scale) {
        return BankVCHelper.getRowsetBySQL(new StringBuffer(BankVCHelper.getJournalSQL()), idSet, scale);
    }

    public static IRowSet getRowsetBySQL(StringBuffer sb, Set idSet, int scale) {
        Object[] vecId = idSet.toArray();
        sb.append(" ( '' ");
        for (int i = 0; i < vecId.length; ++i) {
            sb.append(", '");
            sb.append(vecId[i]);
            sb.append("'");
        }
        sb.append(" ) ");
        IRowSet rs = null;
        ISQLExecutor sqlExe = SQLExecutorFactory.getRemoteInstance((String)sb.toString());
        try {
            rs = sqlExe.executeSQL();
            BigDecimal debitAmount = SysConstant.BIGZERO;
            BigDecimal creditAmount = SysConstant.BIGZERO;
            if (rs.size() > 0) {
                while (rs.next()) {
                    debitAmount = BankVCHelper.getBigDecimal(rs.getBigDecimal("debitAmount"));
                    debitAmount = debitAmount.setScale(scale, 5);
                    rs.updateBigDecimal("debitAmount", debitAmount);
                    creditAmount = BankVCHelper.getBigDecimal(rs.getBigDecimal("creditAmount"));
                    creditAmount = creditAmount.setScale(scale, 5);
                    rs.updateBigDecimal("creditAmount", creditAmount);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex);
        }
        return rs;
    }

    public static BigDecimal getBigDecimal(BigDecimal big) {
        return big == null ? SysConstant.BIGZERO : big;
    }

    public static MutexParameter setMutexParameter(Uuid uuid, String actionName) {
        MutexParameter param = new MutexParameter();
        String dcName = SysContext.getSysContext().getDcName() != null ? SysContext.getSysContext().getDcName() : "";
        param.setDcName(dcName);
        param.setRequestId(uuid);
        param.setMutexName(BANKVC_MUTEX_LOCK);
        param.setActionName(actionName);
        param.setUserID(SysContext.getSysContext().getCurrentUserInfo().getId());
        param.setOrgUnitID(SysContext.getSysContext().getCurrentFIUnit().getId());
        param.setMutexLockType(MutexLockType.EXCLUSIVE_LOCK);
        return param;
    }

    public static boolean requestMutex(MutexParameter param) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        return mutexService.requestMutex(param);
    }

    public static void releaseMutex(Uuid id) throws BOSException, EASBizException {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        mutexService.releaseMutex(id);
    }

    public static Map getMutexList() {
        IMutexServiceControl mutexService = MutexServiceControlFactory.getRemoteInstance();
        return mutexService.getMutexList();
    }
}

