/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetListener;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.ISortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTFocusChangeAction;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTActiveCellEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.common.client.CommonUtil;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.CommonQueryProcessor;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.IProcessor;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.netctrl.MutexParameter;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.vc.VcMatchConditionCollection;
import com.kingdee.eas.base.vc.VcMatchConditionInfo;
import com.kingdee.eas.base.vc.VcResultCollection;
import com.kingdee.eas.base.vc.client.BankVcResultUI;
import com.kingdee.eas.base.vc.client.VcVerifyUI;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BankVCFilterParam;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractBankVcCheckUI;
import com.kingdee.eas.fi.cas.client.BankVCFilterUI;
import com.kingdee.eas.fi.cas.client.BankVcCheckResultUI;
import com.kingdee.eas.fi.cas.client.BankVcCheckSettingUI;
import com.kingdee.eas.fi.cas.client.CasJournalQueryProcessor;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.UserOptionFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class BankVcCheckUI
extends AbstractBankVcCheckUI {
    private static Logger logger = Logger.getLogger((String)BankVcCheckUI.class.getName());
    private static final String SELECT = "select";
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CasResources";
    private CommonQueryDialog queryDialog;
    private BankVCFilterUI filterUI;
    private BankVCFilterParam param;
    private int scale = 2;
    private Map journalMap;
    private Map bankMap;
    private Set cashSet;
    private Set bankSet;
    private String numberFmt = "00.00";
    private IUIWindow historyUI = null;
    private PeriodInfo startPeriodInfo = null;
    private boolean isAutoSearch = false;
    private boolean isSearched = true;
    private Object defaultQueryParam;
    IMetaDataPK mainQueryPK;
    private EntityViewInfo defaultEntityView;
    private boolean isDefaulted = false;
    private String currentSearchRowId = null;
    private BigDecimal bankDebitTotal = Constants.ZERO;
    private BigDecimal bankCreditTotal = Constants.ZERO;
    private BigDecimal journalDebitTotal = Constants.ZERO;
    private BigDecimal journalCreditTotal = Constants.ZERO;
    private boolean selectAllState = false;
    protected IUIWindow popUI = null;
    private IPermission iPermission = PermissionFactory.getRemoteInstance();
    private int jouranlCurIndex = 0;
    private int bankCurIndex = 0;
    private boolean autoSearchResult = false;
    private boolean isSharedOrg = false;
    Action focusToJournalTable = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BankVcCheckUI.this.getBankTable().getSelectManager().removeAll();
            BankVcCheckUI.this.setFocusForTable(BankVcCheckUI.this.getJournalTable());
        }
    };
    Action focusToBankTable = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            BankVcCheckUI.this.getJournalTable().getSelectManager().removeAll();
            BankVcCheckUI.this.setFocusForTable(BankVcCheckUI.this.getBankTable());
        }
    };
    Action selectChkForJournalTable = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object s = e.getSource();
            if (s instanceof KDTable) {
                KDTable tbl = (KDTable)s;
                if (tbl.getName().equals("tblBank")) {
                    KDTable table = BankVcCheckUI.this.getBankTable();
                    BankVcCheckUI.this.selectChkForTable(table);
                } else if (tbl.getName().equals("tblJournal")) {
                    KDTable table = BankVcCheckUI.this.getJournalTable();
                    BankVcCheckUI.this.selectChkForTable(table);
                }
            }
        }
    };
    Action selectChkForBankTable = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Object s = e.getSource();
            if (s instanceof KDTable) {
                KDTable tbl = (KDTable)s;
                if (tbl.getName().equals("tblBank")) {
                    KDTable table = BankVcCheckUI.this.getBankTable();
                    BankVcCheckUI.this.selectChkForTable(table);
                } else if (tbl.getName().equals("tblJournal")) {
                    KDTable table = BankVcCheckUI.this.getJournalTable();
                    BankVcCheckUI.this.selectChkForTable(table);
                }
            }
        }
    };
    private boolean isFristSortTable_Bank = true;
    private boolean isFristSortTable_Journal = true;
    private ISortManager sm_Bank = null;
    private ISortManager sm_Journal = null;
    private int sort_Bank = 0;
    private int sort_Journal = 0;
    private SorterItemInfo pre_order_Bank = new SorterItemInfo("createDate");
    private SorterItemInfo pre_order_Journal = new SorterItemInfo("createDate");
    private SorterItemInfo current_order_Bank = (SorterItemInfo)this.pre_order_Bank.clone();
    private SorterItemInfo current_order_Journal = (SorterItemInfo)this.pre_order_Journal.clone();

    private IRow getRow(KDTable table, String key) {
        for (int i = 0; i < table.getRowCount3(); ++i) {
            IRow row = table.getRow(i);
            if (!key.equals(row.getCell("id").getValue())) continue;
            return row;
        }
        return null;
    }

    protected FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new BankVCFilterUI();
            this.filterUI.onLoad();
        }
        this.filterUI.setListUI((IUIObject)this);
        return this.filterUI;
    }

    public BankVcCheckUI() throws Exception {
        this.addBindings();
    }

    public boolean destroyWindow() {
        if (this.isSharedOrg) {
            CashClientHelper.releaseSharedOrgLicense();
        }
        return super.destroyWindow();
    }

    public void onLoad() throws Exception {
        Map map;
        this.isSharedOrg = CashClientHelper.hasSharedOrgUIParam((CoreUIObject)this);
        if (this.isSharedOrg) {
            CashClientHelper.processSharedOrgFilterUI(this.getFilterUI());
            CashClientHelper.processSharedOrgLicense((CoreUI)this);
        }
        super.onLoad();
        this.getMainStatusBar().setPerTitle(FMClientHelper.getSysStatusBarTitle((CoreUI)this));
        this.initTable();
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.fi.cas", "BankVCFilterQuery");
        Object[] ids = (String[])this.getUIContext().get("IDList");
        if (FMHelper.isEmpty((Object[])ids)) {
            this.initDefaultQuery(this.mainQueryPK.getFullName());
            if ("FINDVIEW".equalsIgnoreCase(this.getOprtState()) && this.getUIContext().get("filterParam") != null) {
                this.defaultQueryParam = this.getUIContext().get("filterParam");
            }
            if (this.defaultQueryParam == null) {
                super.actionFilter_actionPerformed(null);
            }
            if (this.defaultQueryParam != null) {
                block9: {
                    try {
                        this.param = (BankVCFilterParam)this.defaultQueryParam;
                    }
                    catch (Exception e) {
                        Object tempObject = CommonUtil.getObject((byte[])((byte[])this.defaultQueryParam));
                        if (!(tempObject instanceof BankVCFilterParam)) break block9;
                        this.defaultQueryParam = (BankVCFilterParam)tempObject;
                    }
                }
                this.param = (BankVCFilterParam)this.defaultQueryParam;
            }
            this.isDefaulted = true;
            super.actionFilter_actionPerformed(null);
            this.isDefaulted = false;
        }
        this.setBizMatchConditionColl(this.getCheckOutConfig());
        this.curCompany = this.param.getCompany();
        this.prmtCompany.setValue((Object)this.curCompany);
        this.getUIContext().put(OrgType.Company, this.curCompany);
        this.getUIContext().put("ORG.PK", new ObjectUuidPK(this.curCompany.getId()));
        this.startPeriodInfo = ClientUtils.getStartPeriodInfo((Component)((Object)this), this.curCompany);
        if (this.startPeriodInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"StartPeriod_NullMsg"));
            SysUtil.abort();
        }
        if ((map = this.getUIOptionMap()) == null || map.size() == 0) {
            this.splitVC.setOrientation(0);
            this.splitVC.setDividerLocation((this.getHeight() - 60) / 2);
        }
        this.tblBank.setColumnMoveable(true);
        this.tblJournal.setColumnMoveable(true);
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemFilter.setAccelerator(KeyStroke.getKeyStroke("ctrl F"));
        this.menuItemRefresh.setAccelerator(KeyStroke.getKeyStroke("F5"));
    }

    protected void initTable() {
        this.tblBank.checkParsed();
        this.tblJournal.checkParsed();
        this.tblBank.getStyleAttributes().setLocked(true);
        this.tblJournal.getStyleAttributes().setLocked(true);
        this.tblBank.getSelectManager().setSelectMode(2);
        this.tblJournal.getSelectManager().setSelectMode(2);
        this.tblBank.getDataRequestManager().setDataRequestMode(1);
        this.tblJournal.getDataRequestManager().setDataRequestMode(1);
        this.tblBank.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                BankVcCheckUI.this.tblBank_doRequestRowSet(e);
            }
        });
        this.tblJournal.addRequestRowSetListener(new RequestRowSetListener(){

            public void doRequestRowSet(RequestRowSetEvent e) {
                BankVcCheckUI.this.tblJournal_doRequestRowSet(e);
            }
        });
        this.tblBank.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                BankVcCheckUI.this.afterFillBankStatementTable(e);
            }
        });
        this.tblJournal.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                BankVcCheckUI.this.afterFillJournalTable(e);
            }
        });
        this.tblBank.requestFocus();
        FMClientHelper.setTableAutoSorter((KDTable)this.tblJournal);
        FMClientHelper.setTableAutoSorter((KDTable)this.tblBank);
        String dformat = ClientUtils.getDateFormatString();
        this.tblBank.getColumn("date").getStyleAttributes().setNumberFormat(dformat);
        this.tblJournal.getColumn("date").getStyleAttributes().setNumberFormat(dformat);
        this.tblJournal.getColumn("bizDate").getStyleAttributes().setNumberFormat(dformat);
    }

    @Override
    protected void tblBank_doRequestRowSet(RequestRowSetEvent e) {
        super.tblBank_doRequestRowSet(e);
    }

    @Override
    protected void tblJournal_doRequestRowSet(RequestRowSetEvent e) {
        super.tblJournal_doRequestRowSet(e);
    }

    protected void afterFillBankStatementTable(KDTDataRequestEvent e) {
        String bankID;
        Iterator it;
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        IRow row = null;
        for (int i = firstRow; i <= lastRow; ++i) {
            row = this.tblBank.getRow(i);
            if (this.selectAllState) {
                row.getCell(SELECT).setValue((Object)Boolean.TRUE);
                continue;
            }
            row.getCell(SELECT).setValue((Object)Boolean.FALSE);
        }
        this.scale = FMClientHelper.getPrecOfCurrency((BOSUuid)this.param.getCurrency().getId());
        this.tblBank.getColumn("debitAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)this.scale));
        this.tblBank.getColumn("creditAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)this.scale));
        if (this.bankSet == null) {
            List bankList = (List)this.mapAll.get("com.kingdee.eas.fi.cas.app.BankStatement");
            this.bankSet = new HashSet();
            this.bankSet.addAll(bankList);
        }
        if (this.bankSet.size() == 1 && (it = this.bankSet.iterator()).hasNext() && "RockAllDay".equals(bankID = (String)it.next())) {
            this.tblBank.setRowCount(0);
            return;
        }
        this.tblBank.setRowCount(this.bankSet.size());
    }

    protected void afterFillJournalTable(KDTDataRequestEvent e) {
        String journalID;
        Iterator it;
        int firstRow = e.getFirstRow();
        int lastRow = e.getLastRow();
        IRow row = null;
        for (int i = firstRow; i <= lastRow; ++i) {
            row = this.tblJournal.getRow(i);
            if (this.selectAllState) {
                row.getCell(SELECT).setValue((Object)Boolean.TRUE);
            } else {
                row.getCell(SELECT).setValue((Object)Boolean.FALSE);
            }
            row.getCell("billType").setValue((Object)BillTypeEnum.getEnum((Integer)row.getCell("billType").getValue()));
        }
        this.scale = FMClientHelper.getPrecOfCurrency((BOSUuid)this.param.getCurrency().getId());
        this.numberFmt = FMClientHelper.getNumberFtm((BOSUuid)this.param.getCurrency().getId());
        this.tblJournal.getColumn("debitAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)this.scale));
        this.tblJournal.getColumn("creditAmount").getStyleAttributes().setNumberFormat(FMClientHelper.getKDTNumFormat((int)this.scale));
        if (this.cashSet == null) {
            List cashList = (List)this.mapAll.get("com.kingdee.eas.fi.cas.app.Journal");
            this.cashSet = new HashSet();
            this.cashSet.addAll(cashList);
        }
        if (this.cashSet.size() == 1 && (it = this.cashSet.iterator()).hasNext() && "RockAllDay".equals(journalID = (String)it.next())) {
            this.tblJournal.setRowCount(0);
            return;
        }
        this.tblJournal.setRowCount(this.cashSet.size());
    }

    protected void checkUnion() {
        CompanyOrgUnitInfo companyInfo = ClientUtils.getCurrLoginCompany();
        ClientUtils.checkCompany((Component)((Object)this), companyInfo);
    }

    protected void unLockUIAndAction() {
        super.unLockUIAndAction();
        this.cboAccountView.setEditable(false);
        this.cboBankAccount.setEditable(false);
        this.cboCurrency.setEditable(false);
    }

    protected boolean checkBeforeWindowClosing() {
        return super.checkBeforeWindowClosing();
    }

    public void initDefaultQuery(String queryName) throws Exception {
        if (this.defaultQueryParam != null) {
            return;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        QuerySolutionInfo ds = iQuery.getDefaultSolution(((Object)((Object)this)).getClass().getName(), queryName);
        if (ds != null) {
            EntityViewInfo evi = (EntityViewInfo)iQuery.getDefaultFilterInfo(((Object)((Object)this)).getClass().getName(), queryName);
            if (!EmptyUtil.isEmpty((Object)evi)) {
                this.defaultEntityView = evi;
            } else {
                this.defaultEntityView = new EntityViewInfo();
                this.defaultEntityView.setFilter(new FilterInfo());
            }
            QueryPanelCollection queryPanelInfo = ds.getQueryPanelInfo();
            this.getFilterUI();
            if (queryPanelInfo.size() > 0) {
                for (int i = 0; i < queryPanelInfo.size(); ++i) {
                    String filterUICName = this.filterUI.getMetaDataPK().getFullName();
                    if (!filterUICName.equals(queryPanelInfo.get(i).getPanelClassName())) continue;
                    CustomerParams cp = CustomerParams.getCustomerParams2((String)queryPanelInfo.get(i).getCustomerParams());
                    if (cp == null) break;
                    String paramValue = cp.getCustomerParam("fmcustomer");
                    this.defaultQueryParam = this.filterUI.getFilterParamFromCP(cp);
                }
            }
            if (this.defaultQueryParam == null) {
                this.defaultQueryParam = this.getDefaultQueryParam();
            }
        }
    }

    private byte[] getDefaultQueryParam() {
        BankVCFilterParam param = (BankVCFilterParam)this.filterUI.getParam();
        return CommonUtil.getBytes((Object)param);
    }

    protected void addBindings() {
        KeyStroke keyTab = KeyStroke.getKeyStroke(9, 0);
        KeyStroke keySpace = KeyStroke.getKeyStroke(32, 0);
        InputMap inputMapBank = this.tblBank.getInputMap(0);
        ActionMap actionMapBank = this.tblBank.getActionMap();
        inputMapBank.put(keyTab, "focusToJournalTable");
        inputMapBank.put(keySpace, "selectChkForJournalTable");
        actionMapBank.put("focusToJournalTable", this.focusToJournalTable);
        actionMapBank.put("selectChkForJournalTable", this.selectChkForJournalTable);
        InputMap inputMapJournal = this.tblJournal.getInputMap(0);
        ActionMap actionMapJournal = this.tblJournal.getActionMap();
        inputMapJournal.put(keyTab, "focusToBankTable");
        inputMapJournal.put(keySpace, "selectChkForBankTable");
        actionMapJournal.put("focusToBankTable", this.focusToBankTable);
        actionMapJournal.put("selectChkForBankTable", this.selectChkForBankTable);
    }

    private void setFocusForTable(KDTable table) {
        table.requestFocus();
        if (table.getRowCount3() > 0) {
            table.getSelectManager().select(0, 0);
            table.getSelectManager().setActiveRowIndex(0);
        }
    }

    private void selectChkForTable(KDTable table) {
        int row = table.getSelectManager().getActiveRowIndex();
        if (row >= 0) {
            boolean bln = (Boolean)table.getRow(row).getCell(SELECT).getValue();
            if (bln) {
                table.getRow(row).getCell(SELECT).setValue((Object)Boolean.FALSE);
            } else {
                table.getRow(row).getCell(SELECT).setValue((Object)Boolean.TRUE);
            }
        }
    }

    protected KDTable getBankTable() {
        return this.tblBank;
    }

    protected KDTable getJournalTable() {
        return this.tblJournal;
    }

    public static void setTabKeyJumpOrientation(KDTable table, int orientation) {
        ActionMap actionMap = table.getActionMap();
        actionMap.put("FocusOutOfTable", (Action)new KDTFocusChangeAction(table, 0, false));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.contBank.setTitleStyle(1);
        this.contBank.setEnableActive(false);
        this.contBank.setFocusable(false);
        this.contJournal.setTitleStyle(1);
        this.contJournal.setEnableActive(false);
        this.contJournal.setFocusable(false);
        this.btnShowVerified.setVisible(false);
        this.btnShowNotVerify.setVisible(false);
        this.btnShowAll.setVisible(false);
        this.btnSearch.setVisible(false);
        this.separator3.setVisible(false);
        this.btnClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.btnSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.actionSelectAll.setEnabled(true);
        this.actionClearAll.setEnabled(true);
        this.btnHistory.setIcon(EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
        this.actionConfig.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_duizsetting"));
        this.actionManual.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_handworkcollate"));
        this.actionAuto.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_autocollate"));
        this.actionHistory.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
        this.actionRefresh.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_refresh"));
        this.menuItemClearAll.setIcon(EASResource.getIcon((String)"imgTbtn_deleteall"));
        this.menuItemSelectAll.setIcon(EASResource.getIcon((String)"imgTbtn_selectall"));
        this.menuItemHistory.setIcon(EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
        this.menuItemFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.actionExitCurrent.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_quit"));
        this.actionSendMessage.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_sendmessage"));
        this.btnHistory.setIcon(EASResource.getIcon((String)"imgTbtn_demandcollateresult"));
    }

    protected HashMap getBizFilter() throws Exception {
        if (this.isDefaulted && this.param != null) {
            this.getFilterUI();
            this.filterUI.setParam(this.param);
            return this.getOQL();
        }
        HashMap map = new HashMap();
        boolean isShow = false;
        try {
            isShow = this.getQueryDialog().show();
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        if (isShow) {
            map = this.getOQL();
        } else {
            SysUtil.abort();
        }
        return map;
    }

    private HashMap getOQL() throws BOSException, EASBizException {
        HashMap<String, String> map = new HashMap<String, String>();
        this.param = (BankVCFilterParam)this.filterUI.getParam();
        if (null == this.queryDialog) {
            try {
                this.queryDialog = this.getQueryDialog();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        FilterInfo comfilter = this.queryDialog.getCommonFilter();
        boolean isshareAcctCompany = CashClientHelper.isShareBalanceOfAcctCompany(this.param.getAccountBank(), this.param.getCompany().getId().toString());
        HashSet<String> accountBankSet = new HashSet<String>();
        HashSet<String> companySet = new HashSet<String>();
        if (isshareAcctCompany || this.param.getAccountBank().getShareType().getValue() != 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bankAccountNumber", (Object)this.param.getAccountBank().getBankAccountNumber(), CompareType.EQUALS));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("name"));
            selector.add(new SelectorItemInfo("number"));
            selector.add(new SelectorItemInfo("company.id"));
            selector.add(new SelectorItemInfo("company.name"));
            selector.add(new SelectorItemInfo("company.number"));
            view.setSelector(selector);
            view.setFilter(filter);
            AccountBankCollection acctColl = AccountBankFactory.getRemoteInstance().getAccountBankCollection(view);
            for (int i = 0; i < acctColl.size(); ++i) {
                AccountBankInfo info = acctColl.get(i);
                accountBankSet.add(info.getId().toString());
                companySet.add(info.getCompany().getId().toString());
            }
        }
        StringBuffer oqlA = new StringBuffer();
        if (this.param.getAccountBank().getShareType().getValue() != 0) {
            oqlA.append(" WHERE ").append(FMHelper.buildIn((String)"company.id", (Object[])companySet.toArray())).append(" AND currency.id = '").append(this.param.getCurrency().getId().toString()).append("' AND ").append(FMHelper.buildIn((String)"accountBank.id", (Object[])accountBankSet.toArray()));
        } else {
            oqlA.append(" WHERE company.id = '").append(this.param.getCompany().getId().toString()).append("' AND currency.id = '").append(this.param.getCurrency().getId().toString()).append("' AND accountBank.id = '").append(this.param.getAccountBank().getId().toString()).append("'");
        }
        if (comfilter != null && comfilter.getFilterItems().size() > 0) {
            FilterInfo bankState = (FilterInfo)comfilter.clone();
            for (int i = 0; i < bankState.getFilterItems().size(); ++i) {
                FilterItemInfo filterItem = bankState.getFilterItems().get(i);
                if (filterItem.getPropertyName().equalsIgnoreCase("BILLNUMBER")) {
                    filterItem.setPropertyName("id");
                    filterItem.setCompareType(CompareType.NOTEQUALS);
                    filterItem.setCompareValue((Object)" ");
                }
                if (filterItem.getPropertyName().equalsIgnoreCase("VOUCHERNUMBER")) {
                    filterItem.setPropertyName("id");
                    filterItem.setCompareType(CompareType.NOTEQUALS);
                    filterItem.setCompareValue((Object)" ");
                }
                if (filterItem.getPropertyName().equalsIgnoreCase("AMOUNT")) {
                    BigDecimal bigDecimal = new BigDecimal(filterItem.getCompareValue().toString());
                    filterItem.setCompareValue((Object)bigDecimal);
                    filterItem.setPropertyName(" FDebitAmount + FcreditAmount ");
                }
                if (!filterItem.getPropertyName().equalsIgnoreCase("settlementNumber")) continue;
                filterItem.setPropertyName("settleNumber");
            }
            String comFilter = bankState.toString().replaceAll("settlementNumber", "settleNumber").replaceAll("[(]", "( ").replaceAll("[)]", ") ");
            oqlA.append(" AND ( ").append(comFilter).append(" )");
        }
        if (this.param.getBeginDate() != null) {
            oqlA.append(" AND createDate >= {").append(this.param.getBeginDate()).append("}");
        }
        oqlA.append(" AND createDate <= {").append(this.param.getEndDate()).append("}");
        this.vcBankStatementQuery = new EntityViewInfo();
        FilterInfo bankFilter = new FilterInfo();
        if (this.param.getAccountBank().getShareType().getValue() != 0) {
            bankFilter.getFilterItems().add(new FilterItemInfo("company.id", companySet, CompareType.INCLUDE));
            bankFilter.getFilterItems().add(new FilterItemInfo("accountBank.id", accountBankSet, CompareType.INCLUDE));
        } else {
            bankFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.param.getCompany().getId().toString()));
            bankFilter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)this.param.getAccountBank().getId().toString()));
        }
        bankFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.param.getCurrency().getId().toString()));
        bankFilter.getFilterItems().add(new FilterItemInfo("verifyStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        if (this.param.getBeginDate() != null) {
            bankFilter.getFilterItems().add(new FilterItemInfo("createDate", (Object)this.param.getBeginDate(), CompareType.GREATER_EQUALS));
        }
        bankFilter.getFilterItems().add(new FilterItemInfo("createDate", (Object)this.param.getEndDate(), CompareType.LESS_EQUALS));
        if (comfilter != null && comfilter.getFilterItems().size() > 0) {
            FilterInfo bankState = (FilterInfo)comfilter.clone();
            for (int i = 0; i < bankState.getFilterItems().size(); ++i) {
                FilterItemInfo filterItem = bankState.getFilterItems().get(i);
                if (filterItem.getPropertyName().equalsIgnoreCase("BILLNUMBER")) {
                    filterItem.setPropertyName("id");
                    filterItem.setCompareType(CompareType.NOTEQUALS);
                    filterItem.setCompareValue((Object)" ");
                }
                if (filterItem.getPropertyName().equalsIgnoreCase("VOUCHERNUMBER")) {
                    filterItem.setPropertyName("id");
                    filterItem.setCompareType(CompareType.NOTEQUALS);
                    filterItem.setCompareValue((Object)" ");
                }
                if (filterItem.getPropertyName().equalsIgnoreCase("AMOUNT")) {
                    BigDecimal bigDecimal = new BigDecimal(filterItem.getCompareValue().toString());
                    filterItem.setCompareValue((Object)bigDecimal);
                    filterItem.setPropertyName(" debitAmount + creditAmount ");
                }
                if (!filterItem.getPropertyName().equalsIgnoreCase("settlementNumber")) continue;
                filterItem.setPropertyName("settleNumber");
            }
            try {
                bankFilter.mergeFilter(bankState, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        this.vcBankStatementQuery.setFilter(bankFilter);
        SorterItemCollection bankSorter = new SorterItemCollection();
        bankSorter.add(this.current_order_Bank);
        if (this.pre_order_Bank != null && !this.pre_order_Bank.getPropertyName().equals(this.current_order_Bank.getPropertyName())) {
            bankSorter.add(this.pre_order_Bank);
        }
        bankSorter.add(new SorterItemInfo("id"));
        this.vcBankStatementQuery.setSorter(bankSorter);
        map.put("com.kingdee.eas.fi.cas.app.BankStatement", oqlA.toString());
        StringBuffer oqlB = new StringBuffer();
        if (isshareAcctCompany) {
            oqlB.append(" WHERE ").append(FMHelper.buildIn((String)"company.id", (Object[])companySet.toArray())).append(" AND currency.id = '").append(this.param.getCurrency().getId().toString()).append("' AND ").append(FMHelper.buildIn((String)"accountBank.id", (Object[])accountBankSet.toArray()));
        } else {
            oqlB.append(" WHERE company.id = '").append(this.param.getCompany().getId().toString()).append("' AND currency.id = '").append(this.param.getCurrency().getId().toString()).append("' AND accountBank.id = '").append(this.param.getAccountBank().getId().toString()).append("'");
        }
        if (comfilter != null && comfilter.getFilterItems().size() > 0) {
            FilterInfo bankState = (FilterInfo)comfilter.clone();
            for (int i = 0; i < bankState.getFilterItems().size(); ++i) {
                FilterItemInfo filterItem = bankState.getFilterItems().get(i);
                if (!filterItem.getPropertyName().equalsIgnoreCase("AMOUNT")) continue;
                BigDecimal bigDecimal = new BigDecimal(filterItem.getCompareValue().toString());
                filterItem.setCompareValue((Object)bigDecimal);
                filterItem.setPropertyName(" FDebitAmount + FcreditAmount ");
            }
            String comFilter = bankState.toString().replaceAll("[(]", "( ").replaceAll("[)]", ") ");
            oqlB.append(" AND ( ").append(comFilter).append(" )");
        }
        if (this.param.getBeginDate() != null) {
            oqlB.append(" AND createDate >= {").append(this.param.getBeginDate()).append("}");
        }
        oqlB.append(" AND createDate <= {").append(this.param.getEndDate()).append("} AND type = ").append(2);
        this.vcJournalQuery = new EntityViewInfo();
        FilterInfo journalFilter = new FilterInfo();
        if (isshareAcctCompany) {
            journalFilter.getFilterItems().add(new FilterItemInfo("company.id", companySet, CompareType.INCLUDE));
            journalFilter.getFilterItems().add(new FilterItemInfo("accountBank.id", accountBankSet, CompareType.INCLUDE));
        } else {
            journalFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.param.getCompany().getId().toString()));
            journalFilter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)this.param.getAccountBank().getId().toString()));
        }
        journalFilter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)this.param.getCurrency().getId().toString()));
        journalFilter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(2)));
        journalFilter.getFilterItems().add(new FilterItemInfo("verifyStatus", (Object)new Integer(2), CompareType.NOTEQUALS));
        if (this.param.getBeginDate() != null) {
            journalFilter.getFilterItems().add(new FilterItemInfo("createDate", (Object)this.param.getBeginDate(), CompareType.GREATER_EQUALS));
        }
        journalFilter.getFilterItems().add(new FilterItemInfo("createDate", (Object)this.param.getEndDate(), CompareType.LESS_EQUALS));
        if (comfilter != null && comfilter.getFilterItems().size() > 0) {
            FilterInfo bankState = (FilterInfo)comfilter.clone();
            for (int i = 0; i < bankState.getFilterItems().size(); ++i) {
                FilterItemInfo filterItem = bankState.getFilterItems().get(i);
                if (!filterItem.getPropertyName().equalsIgnoreCase("AMOUNT")) continue;
                BigDecimal bigDecimal = new BigDecimal(filterItem.getCompareValue().toString());
                filterItem.setCompareValue((Object)bigDecimal);
                filterItem.setPropertyName(" debitAmount + creditAmount ");
            }
            try {
                journalFilter.mergeFilter(bankState, "AND");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        this.vcJournalQuery.setFilter(journalFilter);
        SorterItemCollection journalSorter = new SorterItemCollection();
        journalSorter.add(this.current_order_Journal);
        if (this.pre_order_Journal != null && !this.pre_order_Journal.getPropertyName().equals(this.current_order_Journal.getPropertyName())) {
            journalSorter.add(this.pre_order_Journal);
        }
        journalSorter.add(new SorterItemInfo("id"));
        this.vcJournalQuery.setSorter(journalSorter);
        map.put("com.kingdee.eas.fi.cas.app.Journal", oqlB.toString());
        if (this.autoSearchResult) {
            FilterInfo filterBank = this.vcBankStatementQuery.getFilter();
            FilterInfo filterBankNew = new FilterInfo();
            filterBankNew.getFilterItems().add(new FilterItemInfo("id", (Object)this.bankSet, CompareType.INCLUDE));
            filterBank.mergeFilter(filterBankNew, "AND");
            this.vcBankStatementQuery.setFilter(filterBank);
            FilterInfo filterJournal = this.vcJournalQuery.getFilter();
            FilterInfo filterJournalNew = new FilterInfo();
            filterJournalNew.getFilterItems().add(new FilterItemInfo("id", (Object)this.cashSet, CompareType.INCLUDE));
            filterJournal.mergeFilter(filterJournalNew, "AND");
            this.vcJournalQuery.setFilter(filterJournal);
        }
        return map;
    }

    private static String reverseString(String str) {
        if (str == null) {
            return str;
        }
        byte[] a = str.getBytes();
        int asize = a.length;
        byte[] b = new byte[asize];
        for (int i = 0; i < asize; ++i) {
            b[i] = a[asize - i - 1];
        }
        return new String(b);
    }

    private static FilterInfo replaceItem2FilterInfo(FilterInfo oriFilter, FilterItemInfo replaceItem, FilterInfo insertFilter) {
        int x;
        int ind = oriFilter.getFilterItems().indexOf((IObjectValue)replaceItem);
        String insertMask = insertFilter.getMaskString();
        int insertFilterSize = insertFilter.getFilterItems().size();
        for (int x2 = 0; x2 < insertFilterSize; ++x2) {
            insertMask = BankVcCheckUI.reverseString(BankVcCheckUI.reverseString(insertMask).replaceFirst("" + x2, "" + (x2 + ind)));
        }
        String oriMask = oriFilter.getMaskString();
        for (x = ind + 1; x < oriFilter.getFilterItems().size(); ++x) {
            oriMask = BankVcCheckUI.reverseString(BankVcCheckUI.reverseString(oriMask).replaceFirst("" + x, "" + (x + insertFilterSize - 1)));
        }
        oriMask = oriMask.replaceFirst("#" + ind, "(" + insertMask + ")");
        for (x = ind; x < ind + insertFilterSize; ++x) {
            oriFilter.getFilterItems().insertObject(x, (IObjectValue)insertFilter.getFilterItems().get(x - ind));
        }
        oriFilter.getFilterItems().remove(replaceItem);
        oriFilter.setMaskString(oriMask);
        return oriFilter;
    }

    protected VcMatchConditionCollection getMatchConditionByBiz() {
        UIContext uiContext = new UIContext((Object)this);
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        if (company != null) {
            uiContext.put((Object)"company", (Object)company);
        }
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow settingUI = uiFactory.create(BankVcCheckSettingUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            settingUI.show();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return this.getCheckOutConfig();
    }

    public VcMatchConditionCollection getCheckOutConfig() {
        Map map = this.getUIOptionMap();
        if (map == null || map.size() == 0) {
            return null;
        }
        boolean isUpAndDown = Boolean.valueOf((String)map.get("btnUpAndDown"));
        if (isUpAndDown) {
            this.splitVC.setOrientation(0);
            this.splitVC.setDividerLocation((this.getHeight() - 60) / 2);
        } else {
            this.splitVC.setOrientation(1);
            this.splitVC.setDividerLocation(this.getWidth() / 2);
        }
        this.validate();
        this.isAutoSearch = Boolean.valueOf((String)map.get("chkAutoSearch"));
        boolean isDateEquals = Boolean.valueOf((String)map.get("chkDateEqual"));
        boolean isDescriptionEquals = Boolean.valueOf((String)map.get("chkDescriptionEqual"));
        boolean isOppUnitEquals = Boolean.valueOf((String)map.get("checkOppUnitEqual"));
        boolean isSettTypeEquals = Boolean.valueOf((String)map.get("chkSettTypeEqual"));
        boolean isSettNumberEquals = Boolean.valueOf((String)map.get("chkSettNumberEqual"));
        boolean isMulSettNumberEquals = Boolean.valueOf((String)map.get("chkMulSettNumberEqual"));
        boolean[] blnArray = new boolean[]{isDateEquals, isDescriptionEquals, isSettTypeEquals, isSettNumberEquals, isMulSettNumberEquals, isOppUnitEquals};
        String[] strArray = new String[]{"FCreateDate", "FDescription", "FSettleTypeID", "FSettleNumber", "FSettleNumber_m", "FOppUnit"};
        VcMatchConditionCollection vcColl = new VcMatchConditionCollection();
        VcMatchConditionInfo vcInfo = null;
        for (int i = 0; i < blnArray.length; ++i) {
            if (!blnArray[i]) continue;
            vcInfo = new VcMatchConditionInfo();
            String AND = EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource", (String)"AND");
            vcInfo.setPropName(strArray[i]);
            vcInfo.setAndor(AND);
            vcColl.add(vcInfo);
        }
        return vcColl;
    }

    private Map getUIOptionMap() {
        Map map = null;
        try {
            String companyId = this.param.getCompany().getId().toString();
            map = UserOptionFactory.getRemoteInstance().getUserOptionMap(null, companyId, "com.kingdee.eas.fi.cas.client.BankVcCheckSettingUI", null);
        }
        catch (Exception e1) {
            this.handUIExceptionAndAbort(e1);
            SysUtil.abort();
        }
        return map;
    }

    protected HashMap getBizSelected() {
        HashMap<Object, List> selectedMap = new HashMap<Object, List>();
        if (this.selectAllState) {
            List casIdListNot = this.getNotSelectedIdList(this.tblJournal);
            List bankIdListNot = this.getNotSelectedIdList(this.tblBank);
            Object[] vecKey = this.mapNotVerify.keySet().toArray();
            for (int i = 0; i < vecKey.length; ++i) {
                ArrayList idList = (ArrayList)this.mapNotVerify.get(vecKey[i]);
                if (idList == null) continue;
                ArrayList tmpIdList = new ArrayList(idList);
                if ("com.kingdee.eas.fi.cas.app.Journal".equals(vecKey[i])) {
                    tmpIdList.removeAll(casIdListNot);
                    selectedMap.put(vecKey[i], tmpIdList);
                    continue;
                }
                if (!"com.kingdee.eas.fi.cas.app.BankStatement".equals(vecKey[i])) continue;
                tmpIdList.removeAll(bankIdListNot);
                selectedMap.put(vecKey[i], tmpIdList);
            }
        } else {
            List casIdList = this.getSelectedIdList(this.tblJournal);
            List bankIdList = this.getSelectedIdList(this.tblBank);
            selectedMap.put("com.kingdee.eas.fi.cas.app.Journal", casIdList);
            selectedMap.put("com.kingdee.eas.fi.cas.app.BankStatement", bankIdList);
        }
        return selectedMap;
    }

    private List getSelectedIdList(KDTable table) {
        ArrayList<Object> selectedIdList = new ArrayList<Object>();
        int rowCount = table.getRowCount3();
        for (int i = 0; i < rowCount; ++i) {
            boolean isSelected;
            IRow row = table.getRow2(i);
            if (row == null || !(isSelected = Boolean.TRUE.equals((Boolean)row.getCell(SELECT).getValue()))) continue;
            selectedIdList.add(row.getCell("id").getValue());
        }
        return selectedIdList;
    }

    private List getNotSelectedIdList(KDTable table) {
        ArrayList<Object> selectedIdList = new ArrayList<Object>();
        int rowCount = table.getRowCount3();
        for (int i = 0; i < rowCount; ++i) {
            boolean isSelected;
            IRow row = table.getRow2(i);
            if (row == null || (isSelected = ((Boolean)row.getCell(SELECT).getValue()).equals(Boolean.TRUE))) continue;
            selectedIdList.add(row.getCell("id").getValue());
        }
        return selectedIdList;
    }

    protected void displayBizObj(HashMap map) {
        if (this.param == null) {
            this.disposeUIWindow();
            SysUtil.abort();
        }
        List bankList = (List)map.get("com.kingdee.eas.fi.cas.app.BankStatement");
        List cashList = (List)map.get("com.kingdee.eas.fi.cas.app.Journal");
        this.cashSet = new HashSet();
        if (cashList != null) {
            this.cashSet.addAll(cashList);
        } else {
            this.cashSet.add("RockAllDay");
        }
        this.bankSet = new HashSet();
        if (bankList != null) {
            this.bankSet.addAll(bankList);
        } else {
            this.bankSet.add("RockAllDay");
        }
        if (this.param.getAccountBank() != null) {
            this.cboBankAccount.setText(this.param.getAccountBank().toString());
            if (this.param.getAccountBank().getAccount() != null) {
                this.cboAccountView.setText(this.param.getAccountBank().getAccount().toString());
            }
        }
        if (this.param.getCurrency() != null) {
            this.cboCurrency.setText(this.param.getCurrency().toString());
        }
        if (this.param.getType() == 3) {
            this.lblPeriod.setBoundLabelText(EASResource.getString((String)resourcePath, (String)"Lbl_Date"));
            this.txtPeriod.setText(this.param.getBeginDate() + "\u2014" + this.param.getEndDate());
        } else {
            String[] args = new String[]{String.valueOf(this.param.getPeriodYear()), String.valueOf(this.param.getPeriodNum())};
            MessageFormat mf = new MessageFormat(EASResource.getString((String)resourcePath, (String)"LBL_Period"));
            String result = mf.format(args);
            this.txtPeriod.setText(result);
        }
        try {
            this.scale = FMClientHelper.getPrecOfCurrency((BOSUuid)this.param.getCurrency().getId());
            this.numberFmt = FMClientHelper.getNumberFtm((BOSUuid)this.param.getCurrency().getId());
            if (map.get("filterID") != null) {
                this.autoSearchResult = true;
                this.getOQL();
                this.refresh();
            } else {
                this.autoSearchResult = false;
            }
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        this.tblJournal.getColumn("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblJournal.getColumn("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBank.getColumn("debitAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.tblBank.getColumn("creditAmount").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.isSearched = true;
    }

    public BigDecimal getBigDecimal(BigDecimal big) {
        return big == null ? SysConstant.BIGZERO : big;
    }

    protected CommonQueryProcessor getQueryProcessor() {
        return new CasJournalQueryProcessor((IUIObject)this);
    }

    private CommonQueryDialog getQueryDialog() throws Exception {
        if (this.queryDialog == null) {
            IMetaDataPK mockQuery = this.mainQueryPK;
            this.queryDialog = new CommonQueryDialog();
            this.queryDialog.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.queryDialog.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDialog.setShowFilter(true);
            this.queryDialog.setShowSorter(true);
            this.queryDialog.setQueryObjectPK(mockQuery);
            this.queryDialog.addUserPanel((KDPanel)this.getFilterUI());
            this.queryDialog.setTitle(EASResource.getString((String)resourcePath, (String)"FilterDialogTitle"));
            this.queryDialog.setHeight(300);
            this.queryDialog.setWidth(420);
            this.queryDialog.setProcessor((IProcessor)this.getQueryProcessor());
            if (this.queryDialog.getWindow() == null) {
                this.queryDialog.init();
            }
            this.queryDialog.getCommonQueryParam().setDirty(false);
            this.queryDialog.getCommonqueryPanel().disVisiableRowCount();
        }
        return this.queryDialog;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void getBizObj(HashMap mapAll) {
        if (this.param == null) {
            this.disposeUIWindow();
            SysUtil.abort();
        }
        if (this.param.getAccountBank() != null) {
            this.cboBankAccount.setText(this.param.getAccountBank().toString());
            if (this.param.getAccountBank().getAccount() != null) {
                this.cboAccountView.setText(this.param.getAccountBank().getAccount().toString());
            }
        }
        if (this.param.getCurrency() != null) {
            this.cboCurrency.setText(this.param.getCurrency().toString());
        }
        this.txtPeriod.setText(this.param.getPeriodYear() + EASResource.getString((String)"com.kingdee.eas.fi.cas.CheckoutResource", (String)"CHECHOUT_year") + this.param.getPeriodNum() + EASResource.getString((String)"com.kingdee.eas.fi.cas.CheckoutResource", (String)"CHECKOUT_period"));
    }

    @Override
    public void actionHistory_actionPerformed(ActionEvent e) throws Exception {
        this.displayVcVerifyHistory(null);
    }

    protected void displayVcVerifyHistory(VcResultCollection vcResult) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        PeriodInfo periodInfo = new PeriodInfo();
        periodInfo.setPeriodYear(this.param.getPeriodYear());
        periodInfo.setPeriodNumber(this.param.getPeriodNum());
        uiContext.put((Object)"bankAcct", (Object)this.param.getAccountBank());
        uiContext.put((Object)"currency", (Object)this.param.getCurrency());
        uiContext.put((Object)"period", (Object)periodInfo);
        uiContext.put((Object)"type", (Object)new Integer(this.param.getType()));
        uiContext.put((Object)"beginDate", (Object)this.param.getBeginDate());
        uiContext.put((Object)"endDate", (Object)this.param.getEndDate());
        uiContext.put((Object)"PARAM_VC_FILTER_PARAM", (Object)this.param);
        uiContext.put((Object)"METADATA.PK", (Object)new MetaDataPK("com.kingdee.eas.base.vc.client", "BankVcResultUI"));
        HashMap mapOQL2 = this.getOQL();
        uiContext.put((Object)"mapOQL", (Object)mapOQL2);
        String model = "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
        if (!EmptyUtil.isEmpty((AbstractObjectCollection)vcResult)) {
            uiContext.put((Object)"vcResult", (Object)vcResult);
            uiContext.put((Object)"isDirectShow", (Object)true);
        }
        this.historyUI = UIFactory.createUIFactory((String)model).create(BankVcResultUI.class.getName(), (Map)uiContext, null, OprtState.EDIT);
        BankVcResultUI resultUI = (BankVcResultUI)this.historyUI.getUIObject();
        resultUI.getUIContext().putAll(uiContext);
        this.historyUI.show();
    }

    private void refreshResultUI() {
    }

    @Override
    public void actionClearAll_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.selectAllState = false;
        super.actionClearAll_actionPerformed(e);
        int bankRowCount = this.tblBank.getRowCount3();
        int journalRowCount = this.tblJournal.getRowCount3();
        if (bankRowCount <= 0 && journalRowCount <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CheckoutResource", (String)"RecordNullMsg"));
            return;
        }
        for (i = 0; i < bankRowCount; ++i) {
            if (this.tblBank.getRow2(i) == null) continue;
            this.tblBank.getRow2(i).getCell(SELECT).setValue((Object)Boolean.FALSE);
        }
        for (i = 0; i < journalRowCount; ++i) {
            if (this.tblJournal.getRow2(i) == null) continue;
            this.tblJournal.getRow2(i).getCell(SELECT).setValue((Object)Boolean.FALSE);
        }
        this.bankDebitTotal = Constants.ZERO;
        this.bankCreditTotal = Constants.ZERO;
        this.journalDebitTotal = Constants.ZERO;
        this.journalCreditTotal = Constants.ZERO;
        this.calBankTotal(null, false);
        this.calJournalTotal(null, false);
    }

    @Override
    public void actionSelectAll_actionPerformed(ActionEvent e) throws Exception {
        int i;
        this.selectAllState = true;
        super.actionSelectAll_actionPerformed(e);
        int bankRowCount = this.tblBank.getRowCount3();
        int journalRowCount = this.tblJournal.getRowCount3();
        if (bankRowCount <= 0 && journalRowCount <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CheckoutResource", (String)"RecordNullMsg"));
            return;
        }
        for (i = 0; i < bankRowCount; ++i) {
            if (this.tblBank.getRow2(i) == null) continue;
            this.tblBank.getRow2(i).getCell(SELECT).setValue((Object)Boolean.TRUE);
        }
        for (i = 0; i < journalRowCount; ++i) {
            if (this.tblJournal.getRow2(i) == null) continue;
            this.tblJournal.getRow2(i).getCell(SELECT).setValue((Object)Boolean.TRUE);
        }
        this.bankCreditTotal = (BigDecimal)this.mapAll.get("BankStatementCreditAmt");
        if (this.bankCreditTotal == null || this.autoSearchResult) {
            this.bankCreditTotal = Constants.ZERO;
        }
        this.bankDebitTotal = (BigDecimal)this.mapAll.get("BankStatementDebitAmt");
        if (this.bankDebitTotal == null || this.autoSearchResult) {
            this.bankDebitTotal = Constants.ZERO;
        }
        this.journalCreditTotal = (BigDecimal)this.mapAll.get("JournalCreditAmt");
        if (this.journalCreditTotal == null || this.autoSearchResult) {
            this.journalCreditTotal = Constants.ZERO;
        }
        this.journalDebitTotal = (BigDecimal)this.mapAll.get("JournalDebitAmt");
        if (this.journalDebitTotal == null || this.autoSearchResult) {
            this.journalDebitTotal = Constants.ZERO;
        }
        if (this.autoSearchResult) {
            IRow srow;
            for (i = 0; i < this.tblBank.getRowCount(); ++i) {
                srow = this.tblBank.getRow(i);
                this.bankDebitTotal = FMHelper.add((BigDecimal)this.bankDebitTotal, (BigDecimal)((BigDecimal)srow.getCell("debitAmount").getValue()));
                this.bankCreditTotal = FMHelper.add((BigDecimal)this.bankCreditTotal, (BigDecimal)((BigDecimal)srow.getCell("creditAmount").getValue()));
            }
            for (i = 0; i < this.tblJournal.getRowCount(); ++i) {
                srow = this.tblJournal.getRow(i);
                this.journalDebitTotal = FMHelper.add((BigDecimal)this.journalDebitTotal, (BigDecimal)((BigDecimal)srow.getCell("debitAmount").getValue()));
                this.journalCreditTotal = FMHelper.add((BigDecimal)this.journalCreditTotal, (BigDecimal)((BigDecimal)srow.getCell("creditAmount").getValue()));
            }
        }
        this.calBankTotal(null, true);
        this.calJournalTotal(null, true);
    }

    private void refreshOwnerUI() throws Exception {
        Object owner = this.getUIContext().get("Owner");
        if (owner != null && owner instanceof VcVerifyUI) {
            ((VcVerifyUI)owner).actionRefresh_actionPerformed(null);
        }
    }

    @Override
    public void actionAuto_actionPerformed(ActionEvent e) throws Exception {
        this.iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(this.curCompany.getId().toString()), "cas_bankVcCheck_02contrast");
        super.actionAuto_actionPerformed(e);
        VcResultCollection vcResult = this.getBankVcResult();
        if (vcResult.size() == 0) {
            MsgBox.showWarning((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"No_Match"));
            SysUtil.abort();
        }
        SimpleTimer timer = new SimpleTimer();
        this.displayVcVerifyHistory(vcResult);
        System.out.println("display Result time: " + timer.getTime() + "-------------------------------");
        timer = new SimpleTimer();
        this.actionRefresh_actionPerformed(null);
        System.out.println("Refresh time: " + timer.getTime() + "-------------------------------");
    }

    public void displayVerifyResult() throws Exception {
        this.actionRefresh_actionPerformed(null);
        this.refreshOwnerUI();
    }

    @Override
    public void actionManual_actionPerformed(ActionEvent e) throws Exception {
        this.saveCurrentLocation();
        this.iPermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(this.curCompany.getId().toString()), "cas_bankVcCheck_02contrast");
        HashMap mapSelectedIdList = this.getBizSelected();
        if (mapSelectedIdList == null || ((List)mapSelectedIdList.get("com.kingdee.eas.fi.cas.app.Journal")).size() <= 0 && ((List)mapSelectedIdList.get("com.kingdee.eas.fi.cas.app.BankStatement")).size() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"SelectCheckoutMsg"));
            SysUtil.abort();
        }
        super.actionManual_actionPerformed(e);
        this.currentSearchRowId = null;
        this.actionRefresh_actionPerformed(null);
        this.refreshOwnerUI();
        if (this.tblJournal.getRow(this.jouranlCurIndex) != null) {
            this.tblJournal.getSelectManager().select(this.jouranlCurIndex, 0);
            this.tblJournal.getLayoutManager().scrollRowToShow(this.jouranlCurIndex);
        }
        if (this.tblBank.getRow(this.bankCurIndex) != null) {
            this.tblBank.getSelectManager().select(this.bankCurIndex, 0);
            this.tblBank.getLayoutManager().scrollRowToShow(this.bankCurIndex);
        }
    }

    protected void saveCurrentLocation() {
        KDTSelectBlock selectBlock = this.tblJournal.getSelectManager().get();
        this.jouranlCurIndex = selectBlock != null ? selectBlock.getTop() : 0;
        KDTSelectBlock selectBlockbank = this.tblBank.getSelectManager().get();
        this.bankCurIndex = selectBlockbank != null ? selectBlockbank.getTop() : 0;
    }

    @Override
    public void actionFilter_actionPerformed(ActionEvent e) throws Exception {
        this.autoSearchResult = false;
        super.actionFilter_actionPerformed(e);
        if (this.popUI != null) {
            BankVcCheckResultUI resultUI = (BankVcCheckResultUI)this.popUI.getUIObject();
            if (resultUI.isShowing()) {
                resultUI.destroyWindow();
                this.popUI.close();
            }
            this.popUI = null;
        }
        this.refresh();
    }

    @Override
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        if (this.popUI != null) {
            BankVcCheckResultUI resultUI = (BankVcCheckResultUI)this.popUI.getUIObject();
            if (resultUI.isShowing()) {
                resultUI.destroyWindow();
                this.popUI.close();
            }
            this.popUI = null;
        }
        this.currentSearchRowId = null;
        this.getOQL();
        this.refresh();
    }

    protected void refresh() {
        this.refreshJournalTable();
        this.refreshBankTable();
        if (this.param.getCompany() != null) {
            this.prmtCompany.setValue((Object)this.param.getCompany());
            this.curCompany = this.param.getCompany();
        }
    }

    protected void refreshBankTable() {
        if (this.selectAllState) {
            this.selectAllState = false;
            this.refreshJournalTable();
        }
        this.tblBank.repaint();
        this.tblBank.removeRows();
        this.bankDebitTotal = Constants.ZERO;
        this.bankCreditTotal = Constants.ZERO;
        this.calBankTotal(null, true);
        this.currentSearchRowId = null;
    }

    protected void refreshJournalTable() {
        if (this.selectAllState) {
            this.selectAllState = false;
            this.refreshBankTable();
        }
        this.tblJournal.repaint();
        this.tblJournal.removeRows();
        this.journalDebitTotal = Constants.ZERO;
        this.journalCreditTotal = Constants.ZERO;
        this.calJournalTotal(null, true);
        this.currentSearchRowId = null;
    }

    protected String getSubSysName() {
        return "com.kingdee.eas.fi.cas";
    }

    @Override
    protected void tblBank_activeCellChanged(KDTActiveCellEvent e) throws Exception {
        super.tblBank_activeCellChanged(e);
    }

    @Override
    protected void tblJournal_activeCellChanged(KDTActiveCellEvent e) throws Exception {
    }

    @Override
    protected void tblBank_editStopped(KDTEditEvent e) throws Exception {
        super.tblBank_editStopped(e);
    }

    @Override
    protected void tblBank_editStopping(KDTEditEvent e) throws Exception {
        super.tblBank_editStopping(e);
    }

    @Override
    protected void tblBank_tableClicked(KDTMouseEvent e) throws Exception {
        int column;
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 2) {
            this.orderByForTable_Bank(e);
            return;
        }
        int selectColumn = this.tblBank.getSelectManager().getActiveColumnIndex();
        if (selectColumn != (column = this.tblBank.getColumnIndex(SELECT))) {
            return;
        }
        int activeRowIndex = this.tblBank.getSelectManager().getActiveRowIndex();
        IRow row = this.tblBank.getRow(activeRowIndex);
        boolean isSelected = (Boolean)row.getCell(SELECT).getValue();
        if (!this.isAutoSearch) {
            row.getCell(SELECT).setValue((Object)new Boolean(!isSelected));
            this.calBankTotal(row, !isSelected);
            return;
        }
        if (isSelected) {
            if (this.currentSearchRowId != null && row.getCell("id").getValue().equals(this.currentSearchRowId)) {
                if (this.autoSearchResult) {
                    this.autoSearchResult = false;
                    this.getOQL();
                    this.actionRefresh_actionPerformed(null);
                } else {
                    this.calBankTotal(row, !isSelected);
                }
                this.currentSearchRowId = null;
            } else {
                this.calBankTotal(row, !isSelected);
            }
            row.getCell(SELECT).setValue((Object)Boolean.FALSE);
            return;
        }
        if (this.currentSearchRowId == null && !this.selectAllState && this.getSelectedIdList(this.tblJournal).size() == 0) {
            row.getCell(SELECT).setValue((Object)Boolean.TRUE);
            this.actionSearch_actionPerformed(null);
            this.currentSearchRowId = (String)row.getCell("id").getValue();
            if (this.autoSearchResult) {
                this.getRow(this.tblBank, this.currentSearchRowId).getCell(SELECT).setValue((Object)Boolean.TRUE);
            }
            row.getStyleAttributes().setHided(false);
        } else {
            row.getCell(SELECT).setValue((Object)Boolean.TRUE);
        }
        this.calBankTotal(row, !isSelected);
    }

    protected String[] getNotOrderColumns_Bank() {
        return null;
    }

    protected String[] getNotOrderColumns_Journal() {
        return null;
    }

    private void orderByForTable_Bank(KDTMouseEvent e) throws Exception {
        String columnName;
        if (this.isFristSortTable_Bank) {
            this.sm_Bank = new KDTSortManager(this.tblBank);
            this.isFristSortTable_Bank = false;
        }
        if ((columnName = this.tblBank.getColumn(e.getColIndex()).getFieldName()) == null) {
            return;
        }
        if (this.getNotOrderColumns_Bank() != null && this.getNotOrderColumns_Bank().length > 0) {
            for (int i = 0; i < this.getNotOrderColumns_Bank().length; ++i) {
                if (!this.getNotOrderColumns_Bank()[i].equalsIgnoreCase(columnName) && columnName.indexOf("attacheMentId") < 0) continue;
                return;
            }
        }
        this.sort_Bank = this.sort_Bank == 0 ? 1 : 0;
        this.sm_Bank.sort(e.getColIndex(), this.sort_Bank);
        SorterItemInfo sortName = new SorterItemInfo(this.tblBank.getColumn(e.getColIndex()).getFieldName());
        sortName.setSortType(this.sort_Bank == 0 ? SortType.ASCEND : SortType.DESCEND);
        if (this.pre_order_Bank == null) {
            this.pre_order_Bank = (SorterItemInfo)sortName.clone();
            this.current_order_Bank = (SorterItemInfo)sortName.clone();
        } else if (this.current_order_Bank != null && !this.current_order_Bank.getPropertyName().equals(sortName.getPropertyName())) {
            this.pre_order_Bank = (SorterItemInfo)this.current_order_Bank.clone();
            this.current_order_Bank = (SorterItemInfo)sortName.clone();
        } else if (this.current_order_Bank != null && this.current_order_Bank.getPropertyName().equals(sortName.getPropertyName())) {
            this.current_order_Bank = (SorterItemInfo)sortName.clone();
        }
        this.getOQL();
        this.refreshBankTable();
    }

    private void orderByForTable_Journal(KDTMouseEvent e) throws Exception {
        String columnName;
        if (this.isFristSortTable_Journal) {
            this.sm_Journal = new KDTSortManager(this.tblJournal);
            this.isFristSortTable_Journal = false;
        }
        if ((columnName = this.tblJournal.getColumn(e.getColIndex()).getFieldName()) == null) {
            return;
        }
        if (this.getNotOrderColumns_Journal() != null && this.getNotOrderColumns_Journal().length > 0) {
            for (int i = 0; i < this.getNotOrderColumns_Journal().length; ++i) {
                if (!this.getNotOrderColumns_Journal()[i].equalsIgnoreCase(columnName) && columnName.indexOf("attacheMentId") < 0) continue;
                return;
            }
        }
        this.sort_Journal = this.sort_Journal == 0 ? 1 : 0;
        this.sm_Journal.sort(e.getColIndex(), this.sort_Journal);
        SorterItemInfo sortName = new SorterItemInfo(this.tblJournal.getColumn(e.getColIndex()).getFieldName());
        sortName.setSortType(this.sort_Journal == 0 ? SortType.ASCEND : SortType.DESCEND);
        if (this.pre_order_Journal == null) {
            this.pre_order_Journal = (SorterItemInfo)sortName.clone();
            this.current_order_Journal = (SorterItemInfo)sortName.clone();
        } else if (this.current_order_Journal != null && !this.current_order_Journal.getPropertyName().equals(sortName.getPropertyName())) {
            this.pre_order_Journal = (SorterItemInfo)this.current_order_Journal.clone();
            this.current_order_Journal = (SorterItemInfo)sortName.clone();
        } else if (this.current_order_Journal != null && this.current_order_Journal.getPropertyName().equals(sortName.getPropertyName())) {
            this.current_order_Journal = (SorterItemInfo)sortName.clone();
        }
        this.getOQL();
        this.refreshJournalTable();
    }

    private void calBankTotal(IRow row, boolean select) {
        if (row != null) {
            if (select) {
                this.bankDebitTotal = FMHelper.add((BigDecimal)this.bankDebitTotal, (BigDecimal)((BigDecimal)row.getCell("debitAmount").getValue()));
                this.bankCreditTotal = FMHelper.add((BigDecimal)this.bankCreditTotal, (BigDecimal)((BigDecimal)row.getCell("creditAmount").getValue()));
            } else {
                this.bankDebitTotal = FMHelper.subtract((BigDecimal)this.bankDebitTotal, (BigDecimal)((BigDecimal)row.getCell("debitAmount").getValue()));
                this.bankCreditTotal = FMHelper.subtract((BigDecimal)this.bankCreditTotal, (BigDecimal)((BigDecimal)row.getCell("creditAmount").getValue()));
            }
        }
        NumberFormat fm = NumberFormat.getInstance();
        fm.setGroupingUsed(true);
        int scale = FMClientHelper.getPrecOfCurrency((BOSUuid)this.param.getCurrency().getId());
        String msgStr = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"134_BankVcCheckUI"), ClientUtils.formatDecimal(this.bankDebitTotal.setScale(scale, 4)), ClientUtils.formatDecimal(this.bankCreditTotal.setScale(scale, 4)));
        this.contBank.setTitle(msgStr);
    }

    private void calJournalTotal(IRow row, boolean select) {
        if (row != null) {
            if (select) {
                this.journalDebitTotal = FMHelper.add((BigDecimal)this.journalDebitTotal, (BigDecimal)((BigDecimal)row.getCell("debitAmount").getValue()));
                this.journalCreditTotal = FMHelper.add((BigDecimal)this.journalCreditTotal, (BigDecimal)((BigDecimal)row.getCell("creditAmount").getValue()));
            } else {
                this.journalDebitTotal = FMHelper.subtract((BigDecimal)this.journalDebitTotal, (BigDecimal)((BigDecimal)row.getCell("debitAmount").getValue()));
                this.journalCreditTotal = FMHelper.subtract((BigDecimal)this.journalCreditTotal, (BigDecimal)((BigDecimal)row.getCell("creditAmount").getValue()));
            }
        }
        int scale = FMClientHelper.getPrecOfCurrency((BOSUuid)this.param.getCurrency().getId());
        String msgStr = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"135_BankVcCheckUI"), ClientUtils.formatDecimal(this.journalDebitTotal.setScale(scale, 4)), ClientUtils.formatDecimal(this.journalCreditTotal.setScale(scale, 4)));
        this.contJournal.setTitle(msgStr);
    }

    @Override
    protected void tblJournal_tableClicked(KDTMouseEvent e) throws Exception {
        int column;
        if (e.getType() == 0 && e.getButton() == 1 && e.getClickCount() == 2) {
            this.orderByForTable_Journal(e);
            return;
        }
        int selectColumn = this.tblJournal.getSelectManager().getActiveColumnIndex();
        if (selectColumn != (column = this.tblJournal.getColumnIndex(SELECT))) {
            return;
        }
        int activeRowIndex = this.tblJournal.getSelectManager().getActiveRowIndex();
        IRow row = this.tblJournal.getRow(activeRowIndex);
        boolean isSelected = (Boolean)row.getCell(SELECT).getValue();
        if (!this.isAutoSearch) {
            row.getCell(SELECT).setValue((Object)new Boolean(!isSelected));
            this.calJournalTotal(row, !isSelected);
            return;
        }
        if (isSelected) {
            if (this.currentSearchRowId != null && row.getCell("id").getValue().equals(this.currentSearchRowId)) {
                if (this.autoSearchResult) {
                    this.autoSearchResult = false;
                    this.getOQL();
                    this.actionRefresh_actionPerformed(null);
                } else {
                    this.calJournalTotal(row, !isSelected);
                }
                this.currentSearchRowId = null;
            } else {
                this.calJournalTotal(row, !isSelected);
            }
            row.getCell(SELECT).setValue((Object)Boolean.FALSE);
            return;
        }
        if (this.currentSearchRowId == null && !this.selectAllState && this.getSelectedIdList(this.tblBank).size() == 0) {
            row.getCell(SELECT).setValue((Object)Boolean.TRUE);
            this.actionSearch_actionPerformed(null);
            this.currentSearchRowId = (String)row.getCell("id").getValue();
            if (this.autoSearchResult) {
                this.getRow(this.tblJournal, this.currentSearchRowId).getCell(SELECT).setValue((Object)Boolean.TRUE);
            }
            row.getStyleAttributes().setHided(false);
        } else {
            row.getCell(SELECT).setValue((Object)Boolean.TRUE);
        }
        this.calJournalTotal(row, !isSelected);
    }

    @Override
    protected void tblBank_editValueChanged(KDTEditEvent e) throws Exception {
    }

    protected void prepareMutexParameter(ActionEvent e, MutexParameter param) {
        CompanyOrgUnitInfo company = ClientUtils.getCurrLoginCompany();
        param.setOrgUnitID(company.getId());
        super.prepareMutexParameter(e, param);
    }

    @Override
    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.contBank.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 408, 448));
        this.contBank.getContentPane().add((Component)this.tblBank, new KDLayout.Constraints(0, 0, 408, 448, 31));
        this.contJournal.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 405, 445));
        this.contJournal.getContentPane().add((Component)this.tblJournal, new KDLayout.Constraints(0, 0, 405, 445, 31));
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        if (clientHanlder != null) {
            RequestContext request = (RequestContext)clientHanlder.getRequestContext();
            request.put("company", (Object)SysContext.getSysContext().getCurrentFIUnit());
        }
        return clientHanlder;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

