/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.ThreadPool;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.SimpleTimer;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.vc.VcMatchConditionCollection;
import com.kingdee.eas.base.vc.VcMatchConditionInfo;
import com.kingdee.eas.base.vc.client.BankVcResultUI;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SharedAcctInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.BankVCFilterParam;
import com.kingdee.eas.fi.cas.BankVcCheckFacadeFactory;
import com.kingdee.eas.fi.cas.IBankVcCheckFacade;
import com.kingdee.eas.fi.cas.client.AbstractBankVcMultiCompanyCheckUI;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjFilterParam;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustmentUI;
import com.kingdee.eas.fi.cas.client.BankVcCheckSettingUI;
import com.kingdee.eas.fi.cas.client.BankVcCheckUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.DynamicUtils;
import com.kingdee.eas.fm.common.UserOptionFactory;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BankVcMultiCompanyCheckUI
extends AbstractBankVcMultiCompanyCheckUI {
    private static final String PERMITEM_VCCHECK_02CONTRAST = "cas_bankVcCheck_02contrast";
    private static final String OPRT_FINDVIEW = "FINDVIEW";
    private static final String CHECKOUT_RESOURCE = "com.kingdee.eas.fi.cas.CheckoutResource";
    private static final String CAPITAL_VC_SUMMARY_RESOURCE = "com.kingdee.eas.fi.cas.CapitalVcSummaryResource";
    private static final String ENTITY_BANK_STATEMENT = "com.kingdee.eas.fi.cas.app.BankStatement";
    private static final String ENTITY_JOURNAL = "com.kingdee.eas.fi.cas.app.Journal";
    private static final String COL_RELATED_BIZ_DATE = "FRelatedBizDateId";
    private static final String COL_VERIFY_STATUS = "FVerifyStatus";
    private static final String COL_CURRENCY_NAME = "FCurrencyName";
    private static final String COL_CURRENCY_ID = "FCurrencyId";
    private static final String COL_BANK_ACCOUNT_NUMBER = "FBankAccountNumber";
    private static final String COL_ACCOUNT_BANK_NAME = "FAccountBankName";
    private static final String COL_ACCOUNT_BANK_ID = "FAccountBankId";
    private static final String COL_PERIOD_END_DATE = "FPeriodEndDate";
    private static final String COL_PERIOD_NUMBER = "FPeriodNumber";
    private static final String COL_PERIOD_ID = "FPeriodId";
    private static final String COL_COMPANY_NAME = "FCompanyName";
    private static final String COL_COMPANY_ID = "FCompanyId";
    private static final String COL_ISSELECT = "isSelect";
    private static final Color SELECTED_COLOR = new Color(0, 112, 192);
    private static final Color NOT_BALANCE_COLOR = new Color(255, 100, 100);
    private static final String balanceTitle = EASResource.getString((String)"com.kingdee.eas.fi.cas.CapitalVcSummaryResource", (String)"ping");
    private static final String notBalanceTitle = EASResource.getString((String)"com.kingdee.eas.fi.cas.CapitalVcSummaryResource", (String)"buping");
    private boolean isSharedOrg = false;
    private Set<String> selecteAccountIdSet = new HashSet<String>();
    private Map<String, IRow> rowMap = new HashMap<String, IRow>();
    private static IBankVcCheckFacade bankVcCheckFacade;
    private static final Logger logger;

    public BankVcMultiCompanyCheckUI() throws Exception {
        this.actionBalanceAdjust.setDaemonRun(true);
        this.actionManual.setDaemonRun(true);
        this.actionHistory.setDaemonRun(true);
        this.actionRefresh.setDaemonRun(true);
    }

    private IBankVcCheckFacade getBankVcCheckFacade() throws BOSException {
        if (bankVcCheckFacade == null) {
            bankVcCheckFacade = BankVcCheckFacadeFactory.getRemoteInstance();
        }
        return bankVcCheckFacade;
    }

    protected String getSubSysName() {
        return "com.kingdee.eas.fi.cas";
    }

    private void setButtoneIsEnabled(IRowSet rowset) {
        boolean isEnabled = rowset.size() > 0;
        this.btnSelectAll.setEnabled(isEnabled);
        this.btnClearAll.setEnabled(isEnabled);
        this.actionAuto.setEnabled(isEnabled);
        this.actionManual.setEnabled(isEnabled);
        this.actionBalanceAdjust.setEnabled(isEnabled);
        this.actionHistory.setEnabled(isEnabled);
    }

    protected void setIcon() {
        super.setIcon();
        this.menuItemRefresh.setIcon(this.btnRefresh.getIcon());
    }

    private String getCellValue(IRow row, String cellName) {
        Object value = row.getCell(cellName).getValue();
        if (value != null) {
            return value.toString();
        }
        return null;
    }

    private void updateVerifyStatusAndDate(IRowSet rowset, IRow row) throws SQLException {
        ICell cell = row.getCell(COL_VERIFY_STATUS);
        if (rowset.getInt(COL_VERIFY_STATUS) == 4) {
            row.getCell(COL_VERIFY_STATUS).setValue((Object)balanceTitle);
            cell.getStyleAttributes().setBackground(Color.WHITE);
        } else {
            cell.setValue((Object)notBalanceTitle);
            cell.getStyleAttributes().setBackground(NOT_BALANCE_COLOR);
        }
        row.getCell(COL_RELATED_BIZ_DATE).setValue((Object)rowset.getDate("FRelatedBizDate"));
    }

    private void updateTableData(boolean isAntiVerify) throws BOSException, EASBizException, SQLException {
        Set<String> selecteAccountIds;
        if (isAntiVerify) {
            selecteAccountIds = new HashSet<String>();
            selecteAccountIds.add(this.getCellValue(this.getSelectActiveRow(), COL_ACCOUNT_BANK_ID));
        } else {
            selecteAccountIds = this.selecteAccountIdSet;
        }
        if (selecteAccountIds == null || selecteAccountIds.size() == 0) {
            return;
        }
        HashMap<String, Set<String>> selectedMap = new HashMap<String, Set<String>>();
        selectedMap.put("accoutnBankIdSet", selecteAccountIds);
        IRowSet rowset = this.getBankVcCheckFacade().getMultiOrgBankStatement(selectedMap);
        rowset.beforeFirst();
        while (rowset.next()) {
            String key = rowset.getString(COL_ACCOUNT_BANK_ID) + rowset.getString(COL_CURRENCY_ID);
            IRow row = this.rowMap.get(key);
            if (row == null) continue;
            this.updateVerifyStatusAndDate(rowset, row);
        }
    }

    private IRowSet initTableRowSet() throws BOSException, EASBizException, SQLException {
        this.tblMain.removeRows(false);
        IRowSet rowset = BankVcCheckFacadeFactory.getRemoteInstance().getMultiOrgBankStatement(null);
        String yearTitle = EASResource.getString((String)CHECKOUT_RESOURCE, (String)"CHECHOUT_year");
        String periodTitle = EASResource.getString((String)CHECKOUT_RESOURCE, (String)"CHECKOUT_period");
        rowset.beforeFirst();
        while (rowset.next()) {
            IRow row = this.tblMain.addRow();
            row.getCell(COL_ISSELECT).setValue((Object)Boolean.FALSE);
            row.getCell(COL_COMPANY_ID).setValue((Object)rowset.getString(COL_COMPANY_ID));
            row.getCell(COL_COMPANY_NAME).setValue((Object)rowset.getString(COL_COMPANY_NAME));
            row.getCell(COL_PERIOD_ID).setValue((Object)rowset.getString(COL_PERIOD_ID));
            String periodNumber = rowset.getString(COL_PERIOD_NUMBER);
            row.getCell(COL_PERIOD_NUMBER).setValue((Object)(periodNumber.substring(0, 4) + yearTitle + periodNumber.substring(4) + periodTitle));
            row.getCell(COL_PERIOD_END_DATE).setValue((Object)rowset.getString(COL_PERIOD_END_DATE));
            String accountBankId = rowset.getString(COL_ACCOUNT_BANK_ID);
            row.getCell(COL_ACCOUNT_BANK_ID).setValue((Object)accountBankId);
            String accountName = rowset.getString(COL_ACCOUNT_BANK_NAME) + "-" + rowset.getString(COL_BANK_ACCOUNT_NUMBER);
            row.getCell(COL_ACCOUNT_BANK_NAME).setValue((Object)accountName);
            String currencyId = rowset.getString(COL_CURRENCY_ID);
            row.getCell(COL_CURRENCY_ID).setValue((Object)currencyId);
            row.getCell(COL_CURRENCY_NAME).setValue((Object)rowset.getString(COL_CURRENCY_NAME));
            this.updateVerifyStatusAndDate(rowset, row);
            this.rowMap.put(accountBankId + currencyId, row);
        }
        return rowset;
    }

    private void initTableData(boolean isUpdateAll, boolean isAntiVerify) {
        SimpleTimer timer = new SimpleTimer();
        try {
            ThreadPool.setBackgroundRunButtonEnabled((boolean)false);
            if (isUpdateAll) {
                IRowSet rowset = this.initTableRowSet();
                this.setButtoneIsEnabled(rowset);
            } else {
                this.updateTableData(isAntiVerify);
            }
        }
        catch (Exception e1) {
            this.handUIExceptionAndAbort(e1);
        }
        this.refreshBySelectActiveRow();
        logger.info((Object)("initTableData spent seconds: " + (double)timer.getTime() / 1000.0));
    }

    public void onLoad() throws Exception {
        this.isSharedOrg = CashClientHelper.hasSharedOrgUIParam((CoreUIObject)this);
        if (this.isSharedOrg) {
            CashClientHelper.processSharedOrgLicense((CoreUI)this);
        }
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(1);
        super.onLoad();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.btnRefresh.doClick();
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        if (e != null && (e.getSource() == this.btnRefresh || e.getSource() == this.menuItemRefresh)) {
            this.initTableData(true, false);
        } else {
            this.initTableData(false, true);
        }
    }

    public boolean destroyWindow() {
        if (this.isSharedOrg) {
            CashClientHelper.releaseSharedOrgLicense();
        }
        return super.destroyWindow();
    }

    protected void displayBizObj(HashMap map) {
    }

    private void setAllRowSelected(boolean isSelected) {
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            row.getCell(COL_ISSELECT).setValue((Object)isSelected);
            this.setRowColor(row, isSelected);
        }
    }

    private void setRowColor(IRow row, boolean isSelected) {
        if (isSelected) {
            row.getStyleAttributes().setFontColor(SELECTED_COLOR);
        } else {
            row.getStyleAttributes().setFontColor(Color.BLACK);
        }
    }

    @Override
    protected void btnSelectAll_actionPerformed(ActionEvent e) throws Exception {
        this.setAllRowSelected(true);
    }

    @Override
    protected void btnClearAll_actionPerformed(ActionEvent e) throws Exception {
        this.setAllRowSelected(false);
    }

    private IRow getSelectActiveRow() {
        return this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
    }

    @Override
    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        IRow row = this.getSelectActiveRow();
        int activeColumnIndex = this.tblMain.getSelectManager().getActiveColumnIndex();
        if (activeColumnIndex == this.tblMain.getColumnIndex(COL_ISSELECT)) {
            boolean isSelected = !this.isSelected(row);
            row.getCell(COL_ISSELECT).setValue((Object)isSelected);
            this.setRowColor(row, isSelected);
        }
        this.refreshBySelectActiveRow();
    }

    private void refreshBySelectActiveRow() {
    }

    private Map getUIOptionMap() {
        Map map = null;
        try {
            String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
            map = UserOptionFactory.getRemoteInstance().getUserOptionMap(null, companyId, "com.kingdee.eas.fi.cas.client.BankVcCheckSettingUI", null);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
        return map;
    }

    private VcMatchConditionInfo createVcMatchConditionInfo(String propName, String bizObjectName, int seq, String AND) {
        VcMatchConditionInfo info = new VcMatchConditionInfo();
        info.setSeq(seq);
        info.setPropFullName(bizObjectName + "." + propName);
        info.setPropName(propName);
        info.setBizObjectName(bizObjectName);
        info.setAndor(AND);
        return info;
    }

    private VcMatchConditionCollection getCheckOutConfig() {
        Map map = this.getUIOptionMap();
        if (map == null || map.size() == 0) {
            return null;
        }
        boolean isDateEquals = Boolean.valueOf((String)map.get("chkDateEqual"));
        boolean isDescriptionEquals = Boolean.valueOf((String)map.get("chkDescriptionEqual"));
        boolean isSettTypeEquals = Boolean.valueOf((String)map.get("chkSettTypeEqual"));
        boolean isSettNumberEquals = Boolean.valueOf((String)map.get("chkSettNumberEqual"));
        boolean isMulSettNumberEquals = Boolean.valueOf((String)map.get("chkMulSettNumberEqual"));
        boolean[] blnArray = new boolean[]{isDateEquals, isDescriptionEquals, isSettTypeEquals, isSettNumberEquals, isMulSettNumberEquals};
        String[] journalArray = new String[]{"bizDate", "description", "settlementType", "settlementNumber", "settlementNumber_m"};
        String[] bankArray = new String[]{"createDate", "description", "settleType", "settleNumber", "settleNumber_m"};
        VcMatchConditionCollection vcColl = new VcMatchConditionCollection();
        int serial = 10;
        String AND = EASResource.getString((String)"com.kingdee.eas.base.vc.VcResource", (String)"AND");
        int length = blnArray.length;
        for (int i = 0; i < length; ++i) {
            if (blnArray[i]) {
                vcColl.add(this.createVcMatchConditionInfo(journalArray[i], ENTITY_JOURNAL, serial, AND));
                vcColl.add(this.createVcMatchConditionInfo(bankArray[i], ENTITY_BANK_STATEMENT, serial, AND));
            }
            ++serial;
        }
        return vcColl;
    }

    protected VcMatchConditionCollection getMatchConditionByBiz() {
        UIContext uiContext = new UIContext((Object)this);
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
            IUIWindow settingUI = uiFactory.create(BankVcCheckSettingUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            BankVcCheckSettingUI checkSettingUI = (BankVcCheckSettingUI)settingUI.getUIObject();
            checkSettingUI.paneMain.remove((Component)checkSettingUI.paneManualCheckSetting);
            checkSettingUI.paneMain.remove((Component)checkSettingUI.paneTableSetting);
            settingUI.show();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
        return this.getCheckOutConfig();
    }

    private boolean isSelected(IRow row) {
        return (Boolean)row.getCell(COL_ISSELECT).getValue();
    }

    public boolean isTableSelected(boolean isChecked) {
        if (isChecked) {
            int count = this.tblMain.getRowCount();
            for (int i = 0; i < count; ++i) {
                if (!this.isSelected(this.tblMain.getRow(i))) continue;
                return true;
            }
        } else {
            return this.tblMain.getRowCount() > 0 && this.tblMain.getSelectManager().size() > 0;
        }
        return false;
    }

    private void checkSelected(boolean isChecked) {
        if (!this.isTableSelected(isChecked)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    private void setBankStatementAndJournalFilter(IRow row, StringBuilder bankStatementFilter, StringBuilder journalFilter) {
        StringBuilder filterBuilder = new StringBuilder();
        filterBuilder.append("(currency = '").append(this.getCellValue(row, COL_CURRENCY_ID)).append("'");
        filterBuilder.append(" AND accountBank = '").append(this.getCellValue(row, COL_ACCOUNT_BANK_ID)).append("'");
        filterBuilder.append(" AND createDate <= {").append(this.getCellValue(row, COL_PERIOD_END_DATE)).append("}");
        if (bankStatementFilter.length() > 0) {
            bankStatementFilter.append(" OR ");
        }
        bankStatementFilter.append(filterBuilder.toString()).append(")");
        if (journalFilter.length() > 0) {
            journalFilter.append(" OR ");
        }
        journalFilter.append(filterBuilder.toString());
        journalFilter.append(" AND type = ").append(2).append(")");
    }

    protected HashMap<String, String> getBizFilter() throws Exception {
        StringBuilder bankStatementFilter = new StringBuilder();
        StringBuilder journalFilter = new StringBuilder();
        this.selecteAccountIdSet.clear();
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            if (!this.isSelected(row)) continue;
            this.setBankStatementAndJournalFilter(row, bankStatementFilter, journalFilter);
            this.selecteAccountIdSet.add(this.getCellValue(row, COL_ACCOUNT_BANK_ID));
        }
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put(ENTITY_BANK_STATEMENT, bankStatementFilter.toString());
        resultMap.put(ENTITY_JOURNAL, journalFilter.toString());
        return resultMap;
    }

    @Override
    public void actionAuto_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected(true);
        this.setBizMatchConditionColl(this.getCheckOutConfig());
        this.filterBizObj(this.getBizFilter());
        super.actionAuto_actionPerformed(e);
    }

    private BankBalanceAdjFilterParam getQueryFilterParam() throws BOSException, EASBizException {
        IRow row = this.getSelectActiveRow();
        BankBalanceAdjFilterParam param = new BankBalanceAdjFilterParam();
        String companyId = this.getCellValue(row, COL_COMPANY_ID);
        param.setCompanyId(companyId);
        String acctBankId = this.getCellValue(row, COL_ACCOUNT_BANK_ID);
        SharedAcctInfo sAcct = (SharedAcctInfo)DynamicUtils.getInfo(SharedAcctInfo.class, (Object[])new Object[]{ConvertUtils.OQL((String)("select sharebalanceofacctcompany.id where bankaccount ='" + acctBankId + "'"))});
        if (CheckUtils.exist((Object)sAcct) && !CheckUtils.same((Object)ConvertUtils.IDSTR((Object)sAcct.getShareBalanceOfAcctCompany()), (Object)companyId)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)CHECKOUT_RESOURCE, (String)"78_BankVcMultiCompanyCheckUI"));
            SysUtil.abort();
        }
        param.setBankId(acctBankId);
        param.setCurrencyId(this.getCellValue(row, COL_CURRENCY_ID));
        String periodId = this.getCellValue(row, COL_PERIOD_ID);
        param.setPeriodId(periodId);
        PeriodInfo periodInfo = PeriodFactory.getRemoteInstance().getPeriodInfo((IObjectPK)new ObjectUuidPK(periodId));
        param.setPeriodYear(periodInfo.getPeriodYear());
        param.setPeriodNum(periodInfo.getPeriodNumber());
        return param;
    }

    private void checkPermission(String permItemName) throws BOSException, EASBizException {
        this.checkSelected(false);
        String companyId = this.getCellValue(this.getSelectActiveRow(), COL_COMPANY_ID);
        PermissionFactory.getRemoteInstance().checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(companyId), permItemName);
    }

    private BankVCFilterParam getBankVCFilterParam() throws BOSException, EASBizException {
        BankBalanceAdjFilterParam param = this.getQueryFilterParam();
        BankVCFilterParam filterParam = new BankVCFilterParam();
        filterParam.setCompany(CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(param.getCompanyId())));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("account.name");
        selector.add("account.number");
        filterParam.setAccountBank(AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(param.getBankId()), selector));
        filterParam.setCurrency(CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(param.getCurrencyId())));
        filterParam.setPeriodYear(param.getPeriodYear());
        filterParam.setPeriodNum(param.getPeriodNum());
        PeriodInfo periodInfo = param.getPeriodInfo();
        filterParam.setBeginDate(periodInfo.getBeginDate());
        filterParam.setEndDate(periodInfo.getEndDate());
        filterParam.setPeriodInfo(periodInfo);
        return filterParam;
    }

    @Override
    public void actionManual_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(PERMITEM_VCCHECK_02CONTRAST);
        ThreadPool.setBackgroundRunButtonEnabled((boolean)false);
        UIContext uiContext = new UIContext((Object)this);
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
            BankVCFilterParam filterParam = this.getBankVCFilterParam();
            filterParam.setType(4);
            uiContext.put((Object)"filterParam", (Object)filterParam);
            if (this.isSharedOrg) {
                uiContext.put((Object)"UIClassParam", (Object)"sharedorg=1");
            }
            IUIWindow settingUI = uiFactory.create(BankVcCheckUI.class.getName(), (Map)uiContext, null, OPRT_FINDVIEW);
            settingUI.show();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    @Override
    public void actionBalanceAdjust_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission("cas_bankbalanceagjtable_01view");
        ThreadPool.setBackgroundRunButtonEnabled((boolean)false);
        UIContext uiContext = new UIContext((Object)this);
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
            BankBalanceAdjFilterParam param = this.getQueryFilterParam();
            uiContext.put((Object)"filterParam", (Object)param);
            uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
            if (this.isSharedOrg) {
                uiContext.put((Object)"UIClassParam", (Object)"sharedorg=1");
            }
            IUIWindow settingUI = uiFactory.create(BankBalanceAdjustmentUI.class.getName(), (Map)uiContext, null, OPRT_FINDVIEW);
            settingUI.show();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    public void actionHistory_actionPerformed(ActionEvent e) throws Exception {
        this.checkPermission(PERMITEM_VCCHECK_02CONTRAST);
        ThreadPool.setBackgroundRunButtonEnabled((boolean)false);
        UIContext uiContext = new UIContext((Object)this);
        try {
            IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory");
            BankVCFilterParam filterParam = this.getBankVCFilterParam();
            String relatedBizDateString = this.getCellValue(this.getSelectActiveRow(), COL_RELATED_BIZ_DATE);
            if (relatedBizDateString != null) {
                filterParam.setBeginDate(DateUtil.getFirstYearDate((Date)DateUtil.stringToDate((String)relatedBizDateString)));
            } else {
                filterParam.setBeginDate(DateUtil.getFirstYearDate((Date)filterParam.getEndDate()));
            }
            filterParam.setType(4);
            this.setContextParam(uiContext, filterParam);
            IUIWindow settingUI = uiFactory.create(BankVcResultUI.class.getName(), (Map)uiContext, null, OPRT_FINDVIEW);
            settingUI.show();
        }
        catch (Exception ex) {
            this.handUIException(ex);
        }
    }

    private void setContextParam(UIContext uiContext, BankVCFilterParam filterParam) {
        int selectedRow = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(selectedRow);
        StringBuilder bankStatementFilter = new StringBuilder();
        StringBuilder journalFilter = new StringBuilder();
        this.setBankStatementAndJournalFilter(row, bankStatementFilter, journalFilter);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put(ENTITY_BANK_STATEMENT, bankStatementFilter.toString());
        resultMap.put(ENTITY_JOURNAL, journalFilter.toString());
        uiContext.put((Object)"mapOQL", resultMap);
        uiContext.put((Object)"bankInfo", (Object)filterParam.getAccountBank());
        uiContext.put((Object)"currencyInfo", (Object)filterParam.getCurrency());
        uiContext.put((Object)"periodInfo", (Object)filterParam.getPeriodInfo());
        uiContext.put((Object)"type", (Object)new Integer(filterParam.getType()));
        uiContext.put((Object)"beginDate", (Object)filterParam.getBeginDate());
        uiContext.put((Object)"endDate", (Object)filterParam.getEndDate());
    }

    static {
        logger = CoreUIObject.getLogger(BankVcMultiCompanyCheckUI.class);
    }
}

