/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.InnerCashFacadeFactory;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class CapitalSubLegerFilterParam
implements FilterParam {
    private static final long serialVersionUID = 6779040133840219238L;
    private static Logger logger = Logger.getLogger((String)CapitalSubLegerFilterParam.class.getName());
    private String acctTableId;
    private String periodTypeId;
    private String[] companyIds;
    private String currencyId;
    private int beginYear;
    private int endYear;
    private int beginMonth;
    private int endMonth;
    private Date fromDate;
    private Date toDate;
    private boolean isIncludeUnSettBill;
    private boolean isIncludeCash;
    private boolean isShowTotal;
    private String periodId;
    private Date beginQueryDate;
    private Date endQueryDate;

    public String getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(String periodId) {
        this.periodId = periodId;
    }

    public boolean isByDay() {
        return false;
    }

    public Date getBeginQueryDate() {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (this.beginYear == 0) {
            throw new IllegalArgumentException("year is " + this.beginYear);
        }
        if (this.beginMonth == 0) {
            throw new IllegalArgumentException("number is " + this.beginMonth);
        }
        GregorianCalendar beginDate = new GregorianCalendar();
        if (this.isByDay()) {
            beginDate.setTime(this.getFromDate());
        } else {
            PeriodInfo beginPeriod = null;
            try {
                beginPeriod = CashHelper.getPeriodInfo(this.beginYear, this.beginMonth, companyInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                SysUtil.abort();
            }
            catch (BOSException e) {
                logger.error((Object)e);
                SysUtil.abort();
            }
            if (beginPeriod == null) {
                SysUtil.abort();
            }
            beginDate.setTime(beginPeriod.getBeginDate());
        }
        return beginDate.getTime();
    }

    public Date getEndQueryDate() {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (this.endYear == 0) {
            throw new IllegalArgumentException("year is " + this.endYear);
        }
        if (this.endMonth == 0) {
            throw new IllegalArgumentException("number is " + this.endMonth);
        }
        GregorianCalendar endDate = new GregorianCalendar();
        if (this.isByDay()) {
            endDate.setTime(this.getToDate());
        } else {
            PeriodInfo endPeriod = null;
            try {
                endPeriod = CashHelper.getPeriodInfo(this.endYear, this.endMonth, companyInfo);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                SysUtil.abort((Throwable)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
                SysUtil.abort((Throwable)e);
            }
            if (endPeriod == null) {
                SysUtil.abort();
            }
            endDate.setTime(endPeriod.getEndDate());
        }
        return endDate.getTime();
    }

    public String getCurrencyId() {
        return this.currencyId;
    }

    public String getAcctTableId() {
        return this.acctTableId;
    }

    public void setAcctTableId(String acctTableId) {
        this.acctTableId = acctTableId;
    }

    public String getPeriodTypeId() {
        return this.periodTypeId;
    }

    public void setPeriodTypeId(String periodTypeId) {
        this.periodTypeId = periodTypeId;
    }

    public void setCurrencyId(String currencyId) {
        this.currencyId = currencyId;
    }

    public boolean isShowTotal() {
        return this.isShowTotal;
    }

    public void setShowTotal(boolean isShowTotal) {
        this.isShowTotal = isShowTotal;
    }

    public String[] getCompanyIds() {
        return this.companyIds;
    }

    public void setCompanyIds(String[] companyIds) {
        this.companyIds = companyIds;
    }

    public int getBeginMonth() {
        return this.beginMonth;
    }

    public void setBeginMonth(int beginMonth) {
        this.beginMonth = beginMonth;
    }

    public int getBeginYear() {
        return this.beginYear;
    }

    public void setBeginYear(int beginYear) {
        this.beginYear = beginYear;
    }

    public int getEndMonth() {
        return this.endMonth;
    }

    public void setEndMonth(int endMonth) {
        this.endMonth = endMonth;
    }

    public int getEndYear() {
        return this.endYear;
    }

    public void setEndYear(int endYear) {
        this.endYear = endYear;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public boolean isIncludeCash() {
        return this.isIncludeCash;
    }

    public void setIncludeCash(boolean isIncludeCash) {
        this.isIncludeCash = isIncludeCash;
    }

    public boolean isIncludeUnSettBill() {
        return this.isIncludeUnSettBill;
    }

    public void setIncludeUnSettBill(boolean isIncludeUnSettBill) {
        this.isIncludeUnSettBill = isIncludeUnSettBill;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public FilterInfo getFilter() {
        FilterInfo filterInfo = new FilterInfo();
        if (!FMHelper.isEmpty((Object[])this.companyIds)) {
            HashSet<String> list = new HashSet<String>(this.companyIds.length);
            for (int i = 0; i < this.companyIds.length; ++i) {
                list.add(this.companyIds[i]);
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("company.id", list, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("createDate", (Object)this.getBeginQueryDate(), CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("createDate", (Object)this.getEndQueryDate(), CompareType.LESS_EQUALS));
        if (!this.isIncludeUnSettBill) {
            filterInfo.getFilterItems().add(new FilterItemInfo("hasEffected", (Object)Boolean.TRUE));
        }
        String acctTableID = null;
        if (FMHelper.isEmpty((String)this.getAcctTableId())) {
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            try {
                acctTableID = InnerCashFacadeFactory.getRemoteInstance().getActualAcctTableID(companyInfo.getId().toString(), this.getBeginQueryDate(), this.getEndQueryDate());
            }
            catch (Exception e) {
                ExceptionHandler.handle((Throwable)e);
                logger.error((Object)e);
            }
        }
        if (!FMHelper.isEmpty(acctTableID)) {
            this.setAcctTableId(acctTableID);
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("accountView.accountTableID.id", (Object)this.getAcctTableId()));
        return filterInfo;
    }

    public SorterItemCollection getSorterItems() {
        return null;
    }

    public void setBeginQueryDate(Date beginQueryDate) {
        this.beginQueryDate = beginQueryDate;
    }

    public void setEndQueryDate(Date endQueryDate) {
        this.endQueryDate = endQueryDate;
    }
}

