/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ctrl.swing.KDSpinner;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodTypeCollection;
import com.kingdee.eas.basedata.assistant.PeriodTypeFactory;
import com.kingdee.eas.basedata.assistant.PeriodTypeInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableCollection;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CapitalSubLegerFecthParamFacadeFactory;
import com.kingdee.eas.fi.cas.CashAccountTool;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.client.AbstractCapitalSubLegerFilterUI;
import com.kingdee.eas.fi.cas.client.CapitalSubLegerFilterParam;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.cas.utils.PeriodRange;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.CompanyTreeSelectUI;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.report.util.PeriodEntity;
import com.kingdee.eas.framework.report.util.SpinnerUtil;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JDialog;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class CapitalSubLegerFilterUI
extends AbstractCapitalSubLegerFilterUI {
    private static Logger logger = Logger.getLogger((String)CapitalSubLegerFilterUI.class.getName());
    public static final String RESOURCEPATH = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    TreeMap result = new TreeMap();
    String actualAcctTableId = null;
    private Map paramMapFromMainUI;
    private String[] companyIds2;

    public CapitalSubLegerFilterUI(Map parmaMap) throws Exception {
        this.paramMapFromMainUI = parmaMap;
    }

    public void enableBtnCompany(boolean isEnabled) {
        this.btnCompanySelect.setEnabled(isEnabled);
    }

    protected void init() throws Exception {
        super.init();
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.company)) {
            AccountTableInfo accountTableInfo = null;
            accountTableInfo = this.paramMapFromMainUI.get("accountTable") == null ? AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.currentCompany.getAccountTable().getId().toString()))) : (AccountTableInfo)this.paramMapFromMainUI.get("accountTable");
            this.comboAcctTable.addItem((Object)accountTableInfo);
            PeriodTypeInfo periodTypeInfo = null;
            periodTypeInfo = this.paramMapFromMainUI.get("periodTypeInfo") == null ? PeriodTypeFactory.getRemoteInstance().getPeriodTypeInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.currentCompany.getAccountPeriodType().getId().toString()))) : (PeriodTypeInfo)this.paramMapFromMainUI.get("periodTypeInfo");
            this.comboPeriodType.addItem((Object)periodTypeInfo);
        } else {
            AccountTableCollection accountTables = null;
            accountTables = this.paramMapFromMainUI.get("accountTableCol") == null ? CashHelper.getAccountViewTable(this.currentCompany) : (AccountTableCollection)this.paramMapFromMainUI.get("accountTableCol");
            this.comboAcctTable.addItems(accountTables.toArray());
            PeriodTypeCollection periodTypes = null;
            periodTypes = this.paramMapFromMainUI.get("periodTypeCol") == null ? PeriodTypeFactory.getRemoteInstance().getPeriodTypeCollection() : (PeriodTypeCollection)this.paramMapFromMainUI.get("periodTypeCol");
            this.comboPeriodType.addItems(periodTypes.toArray());
        }
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.company)) {
            if (this.paramMapFromMainUI.get("currentCompany") == null && this.paramMapFromMainUI.get("currentPeriod") == null && this.paramMapFromMainUI.get("startPeriod") == null) {
                PeriodHelper.initPeriodSpinner(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
            } else {
                PeriodHelper.initPeriodSpinner((CompanyOrgUnitInfo)this.paramMapFromMainUI.get("currentCompany"), (PeriodInfo)this.paramMapFromMainUI.get("currentPeriod"), (PeriodInfo)this.paramMapFromMainUI.get("startPeriod"), this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
            }
            PeriodEntity pe = new PeriodEntity(CashManagementFactory.getRemoteInstance().getPeriodRange(this.company, SystemEnum.CASHMANAGEMENT));
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth, (boolean)false, (boolean)false);
        } else {
            PeriodCollection pc = null;
            if (this.paramMapFromMainUI.get("periodCol_TypeID") == null) {
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)this.currentCompany.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
                evi.getSorter().add(new SorterItemInfo("periodYear"));
                evi.getSorter().add(new SorterItemInfo("periodNumber"));
                evi.setFilter(filter);
                pc = PeriodFactory.getRemoteInstance().getPeriodCollection(evi);
            } else {
                pc = (PeriodCollection)this.paramMapFromMainUI.get("periodCol_TypeID");
            }
            for (PeriodInfo pi : pc) {
                PeriodCollection periodSubCo;
                Integer year = new Integer(pi.getPeriodYear());
                if (!this.result.containsKey(year)) {
                    periodSubCo = new PeriodCollection();
                    periodSubCo.add(pi);
                    this.result.put(year, periodSubCo);
                    continue;
                }
                periodSubCo = (PeriodCollection)this.result.get(year);
                periodSubCo.add(pi);
            }
            int beginYear = (Integer)this.result.firstKey();
            int endYear = (Integer)this.result.lastKey();
            SpinnerNumberModel yearMo1 = new SpinnerNumberModel(beginYear, beginYear, endYear, 1);
            this.spiBeginYear.setModel((SpinnerModel)yearMo1);
            SpinnerNumberModel yearMo2 = new SpinnerNumberModel(beginYear, beginYear, endYear, 1);
            this.spiEndYear.setModel((SpinnerModel)yearMo2);
            this.setMonthModel(this.spiBeginMonth, beginYear);
            this.setMonthModel(this.spiEndMonth, beginYear);
            String str = (String)this.getUIContext().get("companyIds");
            this.company.setDescription(str);
            PeriodEntity pe = PeriodEntity.requestPeriodEntity((CompanyOrgUnitInfo)this.company);
            SpinnerUtil.managePeriodRange((PeriodEntity)pe, (KDSpinner)this.spiBeginYear, (KDSpinner)this.spiBeginMonth, (KDSpinner)this.spiEndYear, (KDSpinner)this.spiEndMonth, (boolean)true, (boolean)false);
        }
        this.clear();
        int beginYear = 0;
        int beginMonth = 0;
        int endYear = 0;
        int endMonth = 0;
        beginYear = AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear);
        beginMonth = AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth);
        endYear = AccessHelper.getSpiValue((KDSpinner)this.spiEndYear);
        endMonth = AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth);
        Map hm = new HashMap<String, Integer>();
        hm.put("beginYear", new Integer(beginYear));
        hm.put("beginMonth", new Integer(beginMonth));
        hm.put("endYear", new Integer(endYear));
        hm.put("endMonth", new Integer(endMonth));
        hm = CapitalSubLegerFecthParamFacadeFactory.getRemoteInstance().fetchParam_FilterUI(hm);
        this.paramMapFromMainUI.put("acctTableId", hm.get("acctTableId"));
        this.paramMapFromMainUI.put("isVerified", Boolean.FALSE);
    }

    protected KDDialog initDialog() throws Exception {
        this.companySelectDlg = new KDDialog(FMClientHelper.getFrameAncestor((Component)((Object)this)), true);
        CompanyTreeSelectUI companySelectUI = new CompanyTreeSelectUI(this.getTreeModel(), this.getCompanyIds());
        companySelectUI.setDialog((JDialog)this.companySelectDlg);
        companySelectUI.setPreferredSize(companySelectUI.getBounds().getSize());
        this.companySelectDlg.getContentPane().setLayout(new BorderLayout());
        this.companySelectDlg.getContentPane().add((Component)companySelectUI, "Center");
        this.companySelectDlg.setSize(640, 480);
        CtrlSwingUtilities.centerWindow((Window)this.companySelectDlg);
        this.companySelectDlg.setResizable(false);
        this.companySelectDlg.setTitle(companySelectUI.getUITitle());
        companySelectUI.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("companyChanged")) {
                    try {
                        CapitalSubLegerFilterUI.this.companyValueChange(e.getNewValue());
                    }
                    catch (Exception e1) {
                        logger.error((Object)e1);
                        CapitalSubLegerFilterUI.this.handUIException(e1);
                    }
                }
            }
        });
        return this.companySelectDlg;
    }

    private void setMonthModel(KDSpinner spi, int year) {
        PeriodCollection periodSubCo = (PeriodCollection)this.result.get(new Integer(year));
        int beginMonth = periodSubCo.get(0).getPeriodNumber();
        int endMonth = periodSubCo.get(periodSubCo.size() - 1).getPeriodNumber();
        SpinnerNumberModel monthMo1 = new SpinnerNumberModel(beginMonth, beginMonth, endMonth, 1);
        spi.setModel((SpinnerModel)monthMo1);
    }

    public Set getSetByArray(String[] array) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < array.length; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    public EntityViewInfo getIncludeEntityView(String key, String[] array) {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo(key, (Object)this.getSetByArray(array), CompareType.INCLUDE));
        return view;
    }

    public String[] getCompanyIds() {
        ArrayList<String> companyRec = new ArrayList<String>();
        String[] companyIds = super.getCompanyIds();
        if (companyIds == null) {
            return null;
        }
        try {
            CompanyOrgUnitCollection companys = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(this.getIncludeEntityView("id", companyIds));
            int size = companys.size();
            for (int i = 0; i < size; ++i) {
                CompanyOrgUnitInfo company = companys.get(i);
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
                    companyRec.add(company.getId().toString());
                    continue;
                }
                PeriodInfo period = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
                if (period == null) continue;
                companyRec.add(company.getId().toString());
            }
        }
        catch (BOSException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        return companyRec.toArray(new String[0]);
    }

    private void initCompany() throws EASBizException, BOSException {
        TreeModel tree = this.getTreeModel();
        if (tree != null) {
            DefaultKingdeeTreeNode root = (DefaultKingdeeTreeNode)tree.getRoot();
            ArrayList<Object> list = new ArrayList<Object>();
            if (root.isCheckBoxEnabled()) {
                list.add(((OrgStructureInfo)root.getUserObject()).getUnit());
            }
            this.popNode(list, root);
            String[] ids = AccessHelper.getIds((Object)list.toArray());
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < ids.length; ++i) {
                idSet.add(ids[i]);
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
            view.setFilter(filter);
            CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            list = new ArrayList();
            for (int i = 0; i < coll.size(); ++i) {
                if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)coll.get(i))) continue;
                list.add(coll.get(i).getId().toString());
            }
            this.setCompanyIds(list.toArray(new String[0]));
        }
    }

    private void popNode(List list, DefaultKingdeeTreeNode root) {
        Enumeration c = root.children();
        while (c.hasMoreElements()) {
            DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)c.nextElement();
            if (node.isCheckBoxEnabled()) {
                OrgStructureInfo org = (OrgStructureInfo)node.getUserObject();
                list.add(org.getUnit());
            }
            this.popNode(list, node);
        }
    }

    public TreeModel getTreeModel() throws EASBizException, BOSException {
        if (this.getListUI() == null) {
            return null;
        }
        AccountTableInfo acctTable = (AccountTableInfo)this.comboAcctTable.getSelectedItem();
        PeriodTypeInfo periodType = (PeriodTypeInfo)this.comboPeriodType.getSelectedItem();
        if (acctTable == null || periodType == null) {
            return null;
        }
        TreeModel tree = null;
        try {
            tree = NewOrgUtils.getCompanyTreeModel((String)acctTable.getId().toString(), (String)periodType.getId().toString(), (IMetaDataPK)this.getListUI().getMetaDataPK(), (IMetaDataPK)FMHelper.getActionPK((ItemAction)this.getActionListOnLoad()));
        }
        catch (Exception e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        return tree;
    }

    public Object getParam() {
        CapitalSubLegerFilterParam para = new CapitalSubLegerFilterParam();
        if (this.companyIds2 == null) {
            para.setCompanyIds(this.getCompanyIds());
        } else {
            para.setCompanyIds(this.companyIds2);
        }
        int beginYear = AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear);
        int beginMonth = AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth);
        int endYear = AccessHelper.getSpiValue((KDSpinner)this.spiEndYear);
        int endMonth = AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth);
        para.setBeginMonth(beginMonth);
        para.setBeginYear(beginYear);
        para.setEndMonth(endMonth);
        para.setEndYear(endYear);
        para.setIncludeUnSettBill(this.chkIsIncludeUnSettBill.isSelected());
        para.setShowTotal(this.chkIsShowDayTotal.isSelected());
        if (this.actualAcctTableId == null) {
            this.getAcctTableID();
        }
        para.setAcctTableId(this.actualAcctTableId);
        this.paramMapFromMainUI.put("PeriodRange", PeriodRange.getPeriodRange(beginYear, beginMonth, endYear, endMonth));
        return para;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        CapitalSubLegerFilterParam filterParam = (CapitalSubLegerFilterParam)param;
        this.spiBeginYear.setValue((Object)new Integer(filterParam.getBeginYear()));
        this.spiBeginMonth.setValue((Object)new Integer(filterParam.getBeginMonth()));
        this.spiEndYear.setValue((Object)new Integer(filterParam.getEndYear()));
        this.spiEndMonth.setValue((Object)new Integer(filterParam.getEndMonth()));
        this.chkIsIncludeUnSettBill.setSelected(filterParam.isIncludeUnSettBill());
        this.chkIsShowDayTotal.setSelected(filterParam.isShowTotal());
    }

    public boolean verify() {
        String[] companyIds = super.getCompanyIds();
        int beginYear = 0;
        int beginMonth = 0;
        int endYear = 0;
        int endMonth = 0;
        beginYear = AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear);
        beginMonth = AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth);
        endYear = AccessHelper.getSpiValue((KDSpinner)this.spiEndYear);
        endMonth = AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth);
        Map hm = new HashMap<String, Object>();
        hm.put("beginYear", new Integer(beginYear));
        hm.put("beginMonth", new Integer(beginMonth));
        hm.put("endYear", new Integer(endYear));
        hm.put("endMonth", new Integer(endMonth));
        hm.put("companyIds", companyIds);
        try {
            hm = CapitalSubLegerFecthParamFacadeFactory.getRemoteInstance().fetchParam_Verify(hm);
        }
        catch (Exception e) {
            logger.error((Object)e);
            MsgBox.showInfo((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort((Throwable)e);
        }
        this.companyIds2 = hm.get("companyIdsNew") == null ? this.getCompanyIds() : (String[])hm.get("companyIdsNew");
        if (this.companyIds2 == null || this.companyIds2.length == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"NoCompanyErrer"));
            SysUtil.abort();
        }
        if (AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear) * 100 + AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth) > AccessHelper.getSpiValue((KDSpinner)this.spiEndYear) * 100 + AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth)) {
            this.spiBeginYear.requestFocus(true);
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RESOURCEPATH, (String)"EndPeriodBeforeBeginPeriod"));
            SysUtil.abort();
        }
        try {
            this.actualAcctTableId = CashAccountTool.getDisplayAcctTable(null, null, beginYear, beginMonth, endYear, endMonth);
        }
        catch (EASBizException e) {
            this.handUIException(e);
            e.printStackTrace();
        }
        catch (BOSException e) {
            this.handUIException(e);
            e.printStackTrace();
        }
        this.paramMapFromMainUI.put("isVerified", Boolean.TRUE);
        return true;
    }

    private void getAcctTableID() {
        int beginYear = 0;
        int beginMonth = 0;
        int endYear = 0;
        int endMonth = 0;
        beginYear = AccessHelper.getSpiValue((KDSpinner)this.spiBeginYear);
        beginMonth = AccessHelper.getSpiValue((KDSpinner)this.spiBeginMonth);
        endYear = AccessHelper.getSpiValue((KDSpinner)this.spiEndYear);
        endMonth = AccessHelper.getSpiValue((KDSpinner)this.spiEndMonth);
        try {
            this.actualAcctTableId = CashAccountTool.getDisplayAcctTable(null, null, beginYear, beginMonth, endYear, endMonth);
        }
        catch (EASBizException e) {
            this.handUIException(e);
            e.printStackTrace();
        }
        catch (BOSException e) {
            this.handUIException(e);
            e.printStackTrace();
        }
    }

    protected void companyValueChange(Object object) throws Exception {
        Object[] array = (Object[])object;
        Object[] result = FMClientHelper.removeVirtualCompany((Object[])array);
        super.companyValueChange((Object)result);
    }

    public void clear() {
        super.clear();
        this.chkIsShowDayTotal.setSelected(false);
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.company)) {
            this.comboAcctTable.setEnabled(false);
            this.comboPeriodType.setEnabled(false);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.comboAcctTable, (Object)this.currentCompany.getAccountTable());
            FMClientHelper.setSelectObject((KDComboBox)this.comboPeriodType, (Object)this.currentCompany.getAccountPeriodType());
        }
        try {
            if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.company)) {
                if (this.paramMapFromMainUI.get("currentCompany") == null && this.paramMapFromMainUI.get("currentPeriod") == null && this.paramMapFromMainUI.get("startPeriod") == null) {
                    PeriodHelper.initPeriodSpinner(this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
                } else {
                    PeriodHelper.initPeriodSpinner((CompanyOrgUnitInfo)this.paramMapFromMainUI.get("currentCompany"), (PeriodInfo)this.paramMapFromMainUI.get("currentPeriod"), (PeriodInfo)this.paramMapFromMainUI.get("startPeriod"), this.spiBeginYear, this.spiBeginMonth, this.spiEndYear, this.spiEndMonth);
                }
            } else {
                PeriodInfo periodInfo = null;
                if (this.paramMapFromMainUI.get("period_Now") == null) {
                    GregorianCalendar cal = new GregorianCalendar();
                    periodInfo = PeriodUtils.getPeriodInfo((Date)cal.getTime(), (CompanyOrgUnitInfo)this.currentCompany);
                } else {
                    periodInfo = (PeriodInfo)this.paramMapFromMainUI.get("period_Now");
                }
                this.spiBeginYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
                this.spiBeginMonth.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
                this.spiEndYear.setValue((Object)new Integer(periodInfo.getPeriodYear()));
                this.spiEndMonth.setValue((Object)new Integer(periodInfo.getPeriodNumber()));
            }
            if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.company)) {
                this.initCompany();
            } else {
                this.setCompanyIds(new String[]{this.company.getId().toString()});
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            SysUtil.abort((Throwable)e);
        }
    }

    public String getActualAcctTableId() {
        return this.actualAcctTableId;
    }

    protected Class getParamClass() {
        return CapitalSubLegerFilterParam.class;
    }
}

