/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountRefContrastFactory;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.master.account.IAccountRefContrast;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.DirectionEnum;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fi.cas.client.BankJournalHandler;
import com.kingdee.eas.fi.cas.client.CapitalSubLegerFilterParam;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IRptHandler;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CapitalSubLegerHandler
implements IRptHandler {
    String companyId = null;
    String[] currencyIds = null;
    private BigDecimal exchange = null;
    private int exchangePre = 0;
    private CurrencyInfo baseCurrency = null;
    public String resourcePath = "com.kingdee.eas.fi.cas.client.CapitalSubLedgerResource";

    private void addDayStart(KDTable table, java.util.Date beginDate, Map balance) {
        IRow row = table.addRow();
        row.getStyleAttributes().setBackground(CasConstants.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell("description").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"dayBeginBalance"));
        Date date = new Date(beginDate.getTime());
        row.getCell("createDate").setValue((Object)date);
        row.getCell("createDate").setUserObject((Object)"stateLine");
        for (int i = 0; i < this.currencyIds.length; ++i) {
            BigDecimal balanceValue = (BigDecimal)balance.get(this.currencyIds[i]);
            if (this.currencyIds.length == 1) {
                balanceValue = balanceValue.abs();
            }
            row.getCell("balance_" + this.currencyIds[i]).setValue((Object)balanceValue);
        }
        if (this.currencyIds.length == 1 && this.exchange != null) {
            row.getCell("exchange").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.exchangePre));
            row.getCell("exchange").setValue((Object)this.exchange);
            row.getCell("localBalance_" + this.currencyIds[0]).setValue((Object)((BigDecimal)balance.get(this.currencyIds[0])).multiply(this.exchange).setScale(this.baseCurrency.getPrecision(), 4));
        }
        if (this.currencyIds.length == 1) {
            this.setRowDCByAmount(row, (BigDecimal)balance.get(this.currencyIds[0]));
        } else {
            row.getCell("dc").setValue((Object)DirectionEnum.Debit);
        }
    }

    private void addDaySum(KDTable table, java.util.Date dateSum, Map dayDebit, Map dayCredit, Map balance) {
        IRow row = table.addRow();
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell("description").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"DayTotal"));
        Date date = new Date(dateSum.getTime());
        row.getCell("createDate").setValue((Object)date);
        row.getCell("createDate").setUserObject((Object)"stateLine");
        for (int i = 0; i < this.currencyIds.length; ++i) {
            String currencyId = this.currencyIds[i];
            BigDecimal debitAmount = (BigDecimal)dayDebit.get(currencyId);
            BigDecimal creditAmount = (BigDecimal)dayCredit.get(currencyId);
            BigDecimal balanceAmount = (BigDecimal)balance.get(currencyId);
            if (this.currencyIds.length == 1) {
                balanceAmount = balanceAmount.abs();
            }
            row.getCell("debit_" + currencyId).setValue((Object)debitAmount);
            row.getCell("credit_" + currencyId).setValue((Object)creditAmount);
            row.getCell("balance_" + currencyId).setValue((Object)balanceAmount);
        }
        if (this.currencyIds.length == 1 && this.exchange != null) {
            String currencyId = this.currencyIds[0];
            row.getCell("localDebit_" + currencyId).setValue((Object)((BigDecimal)dayDebit.get(currencyId)).multiply(this.exchange).setScale(this.baseCurrency.getPrecision(), 4));
            row.getCell("localCredit_" + currencyId).setValue((Object)((BigDecimal)dayCredit.get(currencyId)).multiply(this.exchange).setScale(this.baseCurrency.getPrecision(), 4));
            row.getCell("localBalance_" + currencyId).setValue((Object)((BigDecimal)balance.get(currencyId)).multiply(this.exchange).setScale(this.baseCurrency.getPrecision(), 4));
            row.getCell("exchange").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.exchangePre));
            row.getCell("exchange").setValue((Object)this.exchange);
        }
        if (this.currencyIds.length == 1) {
            this.setRowDCByAmount(row, (BigDecimal)balance.get(this.currencyIds[0]));
        } else {
            row.getCell("dc").setValue((Object)DirectionEnum.Debit);
        }
    }

    private void addOneRowDetail(KDTable table, IRowSet rs, Map balance) throws SQLException {
        IRow row = table.addRow();
        String currencyId = rs.getString("currency.id");
        BigDecimal debitAmt = rs.getBigDecimal("debitAmount");
        BigDecimal creditAmt = rs.getBigDecimal("creditAmount");
        row.setUserObject((Object)rs.getString("billId"));
        row.getCell("description").setUserObject(rs.getObject("billType"));
        row.getCell("createDate").setValue((Object)rs.getDate("createDate"));
        row.getCell("voucherType").setValue((Object)rs.getString("voucherType"));
        row.getCell("voucherNumber").setValue((Object)rs.getString("voucherNumber"));
        row.getCell("oppAccountNumber").setValue((Object)rs.getString("oppAccountViewName"));
        row.getCell("billType").setValue((Object)BillTypeEnum.getEnum(rs.getInt("billType")));
        row.getCell("billNumber").setValue((Object)rs.getString("billNumber"));
        row.getCell("description").setValue((Object)rs.getString("description"));
        row.getCell("settType").setValue((Object)rs.getString("settlementType"));
        row.getCell("settNumber").setValue((Object)rs.getString("settlementNumber"));
        row.getCell("ticketNumber").setValue((Object)rs.getString("ticketNumber"));
        if (debitAmt.signum() != 0) {
            row.getCell("debit_" + currencyId).setValue((Object)debitAmt);
        }
        if (creditAmt.signum() != 0) {
            row.getCell("credit_" + currencyId).setValue((Object)creditAmt);
        }
        BigDecimal bal = (BigDecimal)balance.get(currencyId);
        this.setRowDCByAmount(row, bal);
        row.getCell("balance_" + currencyId).setValue((Object)bal.abs());
        if (this.exchange != null) {
            row.getCell("exchange").setValue((Object)this.exchange);
            row.getCell("exchange").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.exchangePre));
            if (debitAmt.signum() != 0) {
                row.getCell("localDebit_" + currencyId).setValue((Object)debitAmt.multiply(this.exchange).setScale(this.baseCurrency.getPrecision(), 4));
            }
            if (creditAmt.signum() != 0) {
                row.getCell("localCredit_" + currencyId).setValue((Object)creditAmt.multiply(this.exchange).setScale(this.baseCurrency.getPrecision(), 4));
            }
            row.getCell("localBalance_" + currencyId).setValue((Object)bal.multiply(this.exchange).setScale(this.baseCurrency.getPrecision(), 4));
        }
    }

    private void addPeriodStart(KDTable table, java.util.Date beginDate, Map balance) {
        IRow row = table.addRow();
        row.getStyleAttributes().setBackground(CasConstants.KDTABLE_SUBTOTAL_BG_COLOR);
        row.getCell("description").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"beginBalance"));
        row.getCell("createDate").setValue((Object)new Date(beginDate.getTime()));
        row.getCell("createDate").setUserObject((Object)"stateLine");
        for (int i = 0; i < this.currencyIds.length; ++i) {
            BigDecimal balanceValue = (BigDecimal)balance.get(this.currencyIds[i]);
            if (this.currencyIds.length == 1) {
                balanceValue = balanceValue.abs();
            }
            row.getCell("balance_" + this.currencyIds[i]).setValue((Object)balanceValue);
        }
        if (this.currencyIds.length == 1 && this.exchange != null) {
            row.getCell("exchange").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.exchangePre));
            row.getCell("exchange").setValue((Object)this.exchange);
            row.getCell("localBalance_" + this.currencyIds[0]).setValue((Object)((BigDecimal)balance.get(this.currencyIds[0])).multiply(this.exchange).setScale(this.baseCurrency.getPrecision(), 4));
        }
        if (this.currencyIds.length == 1) {
            this.setRowDCByAmount(row, (BigDecimal)balance.get(this.currencyIds[0]));
        } else {
            row.getCell("dc").setValue((Object)DirectionEnum.Debit);
        }
    }

    private void addPeriodSum(KDTable table, Timestamp endDate, Map periodDebit, Map periodCredit, Map balance) {
        IRow row = table.addRow();
        row.getCell("description").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"PeriodTotal"));
        Date date = new Date(endDate.getTime());
        row.getCell("createDate").setValue((Object)date);
        row.getCell("createDate").setUserObject((Object)"stateLine");
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_SUBTOTAL_BG_COLOR);
        for (int i = 0; i < this.currencyIds.length; ++i) {
            String currencyId = this.currencyIds[i];
            BigDecimal debitAmount = (BigDecimal)periodDebit.get(currencyId);
            BigDecimal creditAmount = (BigDecimal)periodCredit.get(currencyId);
            BigDecimal balanceAmount = (BigDecimal)balance.get(currencyId);
            if (this.currencyIds.length == 1) {
                balanceAmount = balanceAmount.abs();
            }
            row.getCell("debit_" + currencyId).setValue((Object)debitAmount);
            row.getCell("credit_" + currencyId).setValue((Object)creditAmount);
            row.getCell("balance_" + currencyId).setValue((Object)balanceAmount);
        }
        if (this.currencyIds.length == 1 && this.exchange != null) {
            String currencyId = this.currencyIds[0];
            row.getCell("localDebit_" + currencyId).setValue((Object)((BigDecimal)periodDebit.get(currencyId)).multiply(this.exchange).setScale(this.baseCurrency.getPrecision(), 4));
            row.getCell("localCredit_" + currencyId).setValue((Object)((BigDecimal)periodCredit.get(currencyId)).multiply(this.exchange).setScale(this.baseCurrency.getPrecision(), 4));
            row.getCell("localBalance_" + currencyId).setValue((Object)((BigDecimal)balance.get(currencyId)).multiply(this.exchange).setScale(this.baseCurrency.getPrecision(), 4));
            row.getCell("exchange").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.exchangePre));
            row.getCell("exchange").setValue((Object)this.exchange);
        }
        if (this.currencyIds.length == 1) {
            this.setRowDCByAmount(row, (BigDecimal)balance.get(this.currencyIds[0]));
        } else {
            row.getCell("dc").setValue((Object)DirectionEnum.Debit);
        }
    }

    private void addYearSum(KDTable table, Timestamp endDate, Map yearDebit, Map yearCredit, Map balance) {
        IRow row = table.addRow();
        row.getStyleAttributes().setBackground(FMClientHelper.KDTABLE_TOTAL_BG_COLOR);
        row.getCell("description").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"YearTotal"));
        row.getCell("createDate").setValue((Object)new Date(endDate.getTime()));
        row.getCell("createDate").setUserObject((Object)"stateLine");
        for (int i = 0; i < this.currencyIds.length; ++i) {
            String currencyId = this.currencyIds[i];
            BigDecimal debitAmount = (BigDecimal)yearDebit.get(currencyId);
            BigDecimal creditAmount = (BigDecimal)yearCredit.get(currencyId);
            BigDecimal balanceAmount = (BigDecimal)balance.get(currencyId);
            if (this.currencyIds.length == 1) {
                balanceAmount = balanceAmount.abs();
            }
            row.getCell("debit_" + currencyId).setValue((Object)debitAmount);
            row.getCell("credit_" + currencyId).setValue((Object)creditAmount);
            row.getCell("balance_" + currencyId).setValue((Object)balanceAmount);
        }
        if (this.currencyIds.length == 1 && this.exchange != null) {
            String currencyId = this.currencyIds[0];
            row.getCell("localDebit_" + currencyId).setValue((Object)((BigDecimal)yearDebit.get(currencyId)).multiply(this.exchange).setScale(this.baseCurrency.getPrecision(), 4));
            row.getCell("localCredit_" + currencyId).setValue((Object)((BigDecimal)yearCredit.get(currencyId)).multiply(this.exchange).setScale(this.baseCurrency.getPrecision(), 4));
            row.getCell("localBalance_" + currencyId).setValue((Object)((BigDecimal)balance.get(currencyId)).multiply(this.exchange).setScale(this.baseCurrency.getPrecision(), 4));
            row.getCell("exchange").getStyleAttributes().setNumberFormat(FMClientHelper.getNumberFtm((int)this.exchangePre));
            row.getCell("exchange").setValue((Object)this.exchange);
        }
        if (this.currencyIds.length == 1) {
            this.setRowDCByAmount(row, (BigDecimal)balance.get(this.currencyIds[0]));
        } else {
            row.getCell("dc").setValue((Object)DirectionEnum.Debit);
        }
    }

    private void clearMap(String[] currencyIds, Map value) {
        for (int i = 0; i < currencyIds.length; ++i) {
            value.put(currencyIds[i], SysConstant.BIGZERO);
        }
    }

    public void fillData(CashDataSourceEnum dataType, KDTable table, IRowSet rs, CurrencyInfo currency, CompanyOrgUnitInfo company, AccountBankInfo accountBank, AccountViewInfo accountView, CapitalSubLegerFilterParam param, Map parmaMap) throws SQLException, EASBizException, BOSException, UuidException {
        String currencyId4;
        String accountBankId = null;
        String accountBankNumber = null;
        if (accountBank != null) {
            accountBankId = accountBank.getId().toString();
            accountBankNumber = accountBank.getNumber();
        }
        String accountViewId = accountView.getId().toString();
        String periodId = param.getPeriodId();
        java.util.Date beginDate = param.getBeginQueryDate();
        java.util.Date endDate = param.getEndQueryDate();
        boolean isShowDayTotal = param.isShowTotal();
        boolean isByDay = param.isByDay();
        int beginYear = param.getBeginYear();
        int beginPeriodNumber = param.getBeginMonth();
        int endYear = param.getEndYear();
        int endPeriodNumber = param.getEndMonth();
        table.removeRows();
        HashSet<String> currencySet = new HashSet<String>();
        this.currencyIds = new String[1];
        this.currencyIds[0] = currency.getId().toString();
        this.companyId = company.getId().toString();
        PeriodInfo beginPeriodInfo = PeriodUtils.getPeriodInfo((int)beginYear, (int)beginPeriodNumber, (CompanyOrgUnitInfo)company);
        AccountTableInfo accountTable = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(param.getAcctTableId()));
        PeriodInfo startPeriod = null;
        startPeriod = parmaMap.get("startPeriod") == null ? SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company) : (PeriodInfo)parmaMap.get("startPeriod");
        if (startPeriod == null) {
            return;
        }
        if (beginDate.before(startPeriod.getBeginDate())) {
            beginDate = startPeriod.getBeginDate();
        }
        if (beginDate.after(endDate)) {
            return;
        }
        this.exchange = null;
        if (!company.getBaseCurrency().getId().toString().equals(currency.getId().toString())) {
            String currencyId2 = currency.getId().toString();
            this.exchange = CashHelper.getExchange(company, currencyId2, null);
            this.exchangePre = CashHelper.getExchangePre(company, currencyId2, null);
            this.baseCurrency = parmaMap.get("baseCurrency") == null ? CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(company.getBaseCurrency().getId())) : (CurrencyInfo)parmaMap.get("baseCurrency");
            if (this.exchange.compareTo(FMConstants.ZERO) == 0) {
                this.exchange = null;
            }
        }
        boolean accContrastEnable = false;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.companyId));
        filter.getFilterItems().add(new FilterItemInfo("enabledPeriod.id", (Object)beginPeriodInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("enabledAcctTable.id", (Object)param.getAcctTableId()));
        IAccountRefContrast acctContrast = AccountRefContrastFactory.getRemoteInstance();
        if (beginPeriodInfo.isIsAdjustPeriod() && acctContrast.exists(filter)) {
            accContrastEnable = true;
        }
        HashMap<String, BigDecimal> balance = new HashMap<String, BigDecimal>();
        for (int i = 0; i < this.currencyIds.length; ++i) {
            BigDecimal bal = SysConstant.BIGZERO;
            if (!accContrastEnable) {
                if (accountBankId == null) {
                    bal = CashManagementFactory.getRemoteInstance().cash(company.getNumber(), dataType, accountTable.getNumber(), accountView.getNumber(), accountBankNumber, currency.getNumber(), beginDate, beginDate, CashDataTypeEnum.C, false, false, false);
                } else {
                    BankJournalHandler handler = new BankJournalHandler();
                    bal = handler.getBeginBalance(company, accountTable.getNumber(), currency.getNumber(), accountView.getNumber(), accountBank.getNumber(), beginPeriodInfo, CashDataSourceEnum.B, false);
                }
            }
            balance.put(this.currencyIds[i], bal);
            if (bal.signum() == 0) continue;
            currencySet.add(this.currencyIds[i]);
        }
        Map yearDebit = this.getYearDebitSum(this.currencyIds, company, accountBankId, accountViewId, beginDate, startPeriod, accContrastEnable);
        Map yearCredit = this.getYearCreditSum(this.currencyIds, company, accountBankId, accountViewId, beginDate, startPeriod, accContrastEnable);
        Map<String, BigDecimal> periodDebit = null;
        Map<String, BigDecimal> periodCredit = null;
        if (isByDay) {
            GregorianCalendar dateCal = new GregorianCalendar();
            dateCal.setTime(beginDate);
            GregorianCalendar beginCal = new GregorianCalendar(dateCal.get(1), dateCal.get(2), 1);
            GregorianCalendar endCal = new GregorianCalendar(dateCal.get(1), dateCal.get(2), dateCal.get(5) - 1);
            periodDebit = this.getPeriodDebitOff(this.currencyIds, this.companyId, accountBankId, accountViewId, beginCal.getTime(), endCal.getTime());
            periodCredit = this.getPeriodCreditOff(this.currencyIds, this.companyId, accountBankId, accountViewId, beginCal.getTime(), endCal.getTime());
        } else {
            periodDebit = new HashMap();
            periodCredit = new HashMap();
            this.clearMap(this.currencyIds, periodDebit);
            this.clearMap(this.currencyIds, periodCredit);
        }
        HashMap<String, BigDecimal> dayDebit = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> dayCredit = new HashMap<String, BigDecimal>();
        this.clearMap(this.currencyIds, dayDebit);
        this.clearMap(this.currencyIds, dayCredit);
        PeriodInfo endPeriod = PeriodHelper.getPeriodInfo(param.getEndYear(), param.getEndMonth(), company);
        PeriodInfo curLoopPeriod = PeriodHelper.getPeriodInfo(param.getBeginYear(), param.getBeginMonth(), company);
        if (curLoopPeriod == null) {
            curLoopPeriod = PeriodUtils.getPeriodInfo((java.util.Date)beginDate, (CompanyOrgUnitInfo)company);
        }
        if (curLoopPeriod == null) {
            MsgBox.showError((String)EASResource.getString((String)this.resourcePath, (String)"PeriodNotHas"));
            SysUtil.abort();
        }
        java.util.Date loopDate = beginDate;
        boolean isFirstDay = true;
        if (isByDay) {
            this.addDayStart(table, loopDate, balance);
        } else {
            this.addPeriodStart(table, loopDate, balance);
        }
        int lastPeriodNumber = beginPeriodInfo.getPeriodNumber();
        while (rs.next()) {
            Date createDate = rs.getDate("createDate");
            currencyId4 = rs.getString("currency.id");
            int year = rs.getInt("periodyear");
            int periodNumber = rs.getInt("periodnumber");
            currencySet.add(currencyId4);
            if (loopDate.before(createDate) || periodNumber != lastPeriodNumber || periodNumber == lastPeriodNumber && periodNumber == 13) {
                if (!isFirstDay && isShowDayTotal) {
                    this.addDaySum(table, loopDate, dayDebit, dayCredit, balance);
                }
                this.changePeriodData(this.currencyIds, periodDebit, periodCredit, dayDebit, dayCredit);
            }
            while (curLoopPeriod != null && (curLoopPeriod.getPeriodNumber() < periodNumber && curLoopPeriod.getPeriodYear() == year || curLoopPeriod.getEndDate().before(createDate))) {
                this.addPeriodSum(table, curLoopPeriod.getEndDate(), periodDebit, periodCredit, balance);
                this.changeYearData(this.currencyIds, yearDebit, yearCredit, periodDebit, periodCredit);
                this.addYearSum(table, curLoopPeriod.getEndDate(), yearDebit, yearCredit, balance);
                curLoopPeriod = PeriodHelper.getNextPeriodInfo(company, curLoopPeriod) != null ? PeriodHelper.getNextPeriodInfo(company, curLoopPeriod) : PeriodUtils.getNextPeriodInfo((PeriodInfo)curLoopPeriod);
                if (curLoopPeriod.getPeriodYear() > endPeriod.getPeriodYear() || curLoopPeriod.getPeriodYear() == endPeriod.getPeriodYear() && curLoopPeriod.getPeriodNumber() > endPeriod.getPeriodNumber()) {
                    curLoopPeriod = endPeriod;
                    break;
                }
                this.addPeriodStart(table, curLoopPeriod.getBeginDate(), balance);
                if (curLoopPeriod.getPeriodNumber() != 1) continue;
                this.clearMap(this.currencyIds, yearDebit);
                this.clearMap(this.currencyIds, yearCredit);
            }
            BigDecimal debitAmount = rs.getBigDecimal("debitAmount");
            BigDecimal creditAmount = rs.getBigDecimal("creditAmount");
            dayDebit.put(currencyId4, ((BigDecimal)dayDebit.get(currencyId4)).add(debitAmount));
            dayCredit.put(currencyId4, ((BigDecimal)dayCredit.get(currencyId4)).add(creditAmount));
            BigDecimal bal = (BigDecimal)balance.get(currencyId4);
            bal = bal.add(debitAmount).subtract(creditAmount);
            balance.put(currencyId4, bal);
            this.addOneRowDetail(table, rs, balance);
            isFirstDay = false;
            if (periodNumber != lastPeriodNumber) {
                isFirstDay = true;
            }
            lastPeriodNumber = periodNumber;
            loopDate = createDate;
        }
        if (isShowDayTotal) {
            this.addDaySum(table, loopDate, dayDebit, dayCredit, balance);
        }
        if (isByDay) {
            GregorianCalendar dateCal = new GregorianCalendar();
            dateCal.setTime(endDate);
            GregorianCalendar beginCal = new GregorianCalendar(dateCal.get(1), dateCal.get(2), dateCal.get(5) + 1);
            GregorianCalendar endCal = new GregorianCalendar(dateCal.get(1), dateCal.get(2) + 1, 0);
            Map debitOff = this.getPeriodDebitOff(this.currencyIds, this.companyId, accountBankId, accountViewId, beginCal.getTime(), endCal.getTime());
            Map creditOff = this.getPeriodCreditOff(this.currencyIds, this.companyId, accountBankId, accountViewId, beginCal.getTime(), endCal.getTime());
            for (int i = 0; i < this.currencyIds.length; ++i) {
                String currencyId3 = this.currencyIds[i];
                BigDecimal debit = (BigDecimal)debitOff.get(currencyId3);
                BigDecimal credit = (BigDecimal)creditOff.get(currencyId3);
                periodDebit.put(currencyId3, ((BigDecimal)periodDebit.get(currencyId3)).add(debit));
                periodCredit.put(currencyId3, ((BigDecimal)periodCredit.get(currencyId3)).add(credit));
                yearDebit.put(currencyId3, ((BigDecimal)yearDebit.get(currencyId3)).add(debit));
                yearCredit.put(currencyId3, ((BigDecimal)yearCredit.get(currencyId3)).add(credit));
            }
        }
        this.changePeriodData(this.currencyIds, periodDebit, periodCredit, dayDebit, dayCredit);
        this.addPeriodSum(table, curLoopPeriod.getEndDate(), periodDebit, periodCredit, balance);
        this.changeYearData(this.currencyIds, yearDebit, yearCredit, periodDebit, periodCredit);
        this.addYearSum(table, curLoopPeriod.getEndDate(), yearDebit, yearCredit, balance);
        curLoopPeriod = PeriodHelper.getNextPeriodInfo(company, curLoopPeriod) != null ? PeriodHelper.getNextPeriodInfo(company, curLoopPeriod) : PeriodUtils.getNextPeriodInfo((PeriodInfo)curLoopPeriod);
        if (curLoopPeriod != null && curLoopPeriod.getPeriodNumber() == 1) {
            this.clearMap(this.currencyIds, yearDebit);
            this.clearMap(this.currencyIds, yearCredit);
        }
        while (curLoopPeriod != null && !curLoopPeriod.getBeginDate().after(endDate)) {
            if (curLoopPeriod.getPeriodYear() > endPeriod.getPeriodYear() || curLoopPeriod.getPeriodYear() == endPeriod.getPeriodYear() && curLoopPeriod.getPeriodNumber() > endPeriod.getPeriodNumber()) {
                curLoopPeriod = endPeriod;
                break;
            }
            this.addPeriodStart(table, curLoopPeriod.getBeginDate(), balance);
            this.addPeriodSum(table, curLoopPeriod.getEndDate(), periodDebit, periodCredit, balance);
            this.addYearSum(table, curLoopPeriod.getEndDate(), yearDebit, yearCredit, balance);
            if ((curLoopPeriod = PeriodHelper.getNextPeriodInfo(company, curLoopPeriod) != null ? PeriodHelper.getNextPeriodInfo(company, curLoopPeriod) : PeriodUtils.getNextPeriodInfo((PeriodInfo)curLoopPeriod)) == null || curLoopPeriod.getPeriodNumber() != 1) continue;
            this.clearMap(this.currencyIds, yearDebit);
            this.clearMap(this.currencyIds, yearCredit);
        }
        if (this.currencyIds.length > 1) {
            for (int i = 0; i < this.currencyIds.length; ++i) {
                currencyId4 = this.currencyIds[i];
                table.getColumn("balance_" + currencyId4).getStyleAttributes().setHided(true);
                table.getColumn("debit_" + currencyId4).getStyleAttributes().setHided(true);
                table.getColumn("credit_" + currencyId4).getStyleAttributes().setHided(true);
            }
            if (currencySet.size() == 0) {
                currencySet.add(company.getBaseCurrency().getId().toString());
            }
            for (String currencyId4 : currencySet) {
                table.getColumn("balance_" + currencyId4).getStyleAttributes().setHided(false);
                table.getColumn("debit_" + currencyId4).getStyleAttributes().setHided(false);
                table.getColumn("credit_" + currencyId4).getStyleAttributes().setHided(false);
            }
        }
    }

    private void changeYearData(String[] currencyIds, Map yearDebit, Map yearCredit, Map periodDebit, Map periodCredit) {
        int i;
        for (i = 0; i < currencyIds.length; ++i) {
            yearDebit.put(currencyIds[i], ((BigDecimal)yearDebit.get(currencyIds[i])).add((BigDecimal)periodDebit.get(currencyIds[i])));
        }
        for (i = 0; i < currencyIds.length; ++i) {
            yearCredit.put(currencyIds[i], ((BigDecimal)yearCredit.get(currencyIds[i])).add((BigDecimal)periodCredit.get(currencyIds[i])));
        }
        this.clearMap(currencyIds, periodDebit);
        this.clearMap(currencyIds, periodCredit);
    }

    private void changePeriodData(String[] currencyIds, Map periodDebit, Map periodCredit, Map dayDebit, Map dayCredit) {
        int i;
        for (i = 0; i < currencyIds.length; ++i) {
            periodDebit.put(currencyIds[i], ((BigDecimal)periodDebit.get(currencyIds[i])).add((BigDecimal)dayDebit.get(currencyIds[i])));
        }
        for (i = 0; i < currencyIds.length; ++i) {
            periodCredit.put(currencyIds[i], ((BigDecimal)periodCredit.get(currencyIds[i])).add((BigDecimal)dayCredit.get(currencyIds[i])));
        }
        this.clearMap(currencyIds, dayDebit);
        this.clearMap(currencyIds, dayCredit);
    }

    public IRowSet getRowset(IMetaDataPK mainQueryPK, EntityViewInfo mainQuery) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        EntityViewInfo cloneQurey = (EntityViewInfo)mainQuery.clone();
        SorterItemInfo sorterItemInfo = new SorterItemInfo("createDate");
        sorterItemInfo.setSortType(SortType.ASCEND);
        SorterItemInfo sorterItemInfo1 = new SorterItemInfo("createTime");
        sorterItemInfo.setSortType(SortType.ASCEND);
        cloneQurey.getSorter().add(sorterItemInfo);
        cloneQurey.getSorter().add(sorterItemInfo1);
        exec.setObjectView(cloneQurey);
        IRowSet rs = exec.executeQuery();
        return rs;
    }

    private Map getYearCreditSum(String[] currencyIds, String companyId, String accountBankId, String accountViewId, java.util.Date beginDate) throws EASBizException, BOSException, SQLException {
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.setTime(beginDate);
        int year = endCal.get(1);
        GregorianCalendar begincal = new GregorianCalendar(year, 0, 1);
        HashMap<String, BigDecimal> yearSum = new HashMap<String, BigDecimal>();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)));
        PeriodInfo periodStart = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        boolean isFirstYear = true;
        if (year != periodStart.getPeriodYear()) {
            isFirstYear = false;
        }
        for (int i = 0; i < currencyIds.length; ++i) {
            String currencyId = currencyIds[i];
            BigDecimal value = SysConstant.BIGZERO;
            if (isFirstYear) {
                value = accountBankId == null ? CashHelper.getYearStartAmount(CashDataSourceEnum.C, companyId, accountViewId, null, currencyId, CashDataTypeEnum.DF) : CashHelper.getYearStartAmount(CashDataSourceEnum.B, companyId, null, accountBankId, currencyId, CashDataTypeEnum.DF);
            }
            ICashManagement cashInacct = CashManagementFactory.getRemoteInstance();
            BigDecimal debit = null;
            debit = accountBankId == null ? cashInacct.getCashData(companyId, accountViewId, currencyId, begincal.getTime(), DateHelper.getBeforeDay((java.util.Date)beginDate), CashDataTypeEnum.DF, true) : cashInacct.getBankData(companyId, accountBankId, currencyId, begincal.getTime(), DateHelper.getBeforeDay((java.util.Date)beginDate), CashDataTypeEnum.DF, true);
            yearSum.put(currencyId, value.add(debit));
        }
        return yearSum;
    }

    private Map getYearDebitSum(String[] currencyIds, CompanyOrgUnitInfo company, String accountBankId, String accountViewId, java.util.Date beginDate, PeriodInfo periodStart, boolean accContrastEnable) throws EASBizException, BOSException, SQLException {
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.setTime(beginDate);
        int year = endCal.get(1);
        GregorianCalendar beginCal = new GregorianCalendar(year, 0, 1);
        HashMap<String, BigDecimal> yearSum = new HashMap<String, BigDecimal>();
        boolean isFirstYear = true;
        if (year != periodStart.getPeriodYear()) {
            isFirstYear = false;
        }
        for (int i = 0; i < currencyIds.length; ++i) {
            if (accContrastEnable) {
                yearSum.put(currencyIds[i], SysConstant.BIGZERO);
                continue;
            }
            String currencyId = currencyIds[i];
            BigDecimal value = SysConstant.BIGZERO;
            if (isFirstYear) {
                value = accountBankId == null ? CashHelper.getYearStartAmount(CashDataSourceEnum.C, this.companyId, accountViewId, null, currencyId, CashDataTypeEnum.JF) : CashHelper.getYearStartAmount(CashDataSourceEnum.B, this.companyId, null, accountBankId, currencyId, CashDataTypeEnum.JF);
            }
            ICashManagement cashInacct = CashManagementFactory.getRemoteInstance();
            BigDecimal debit = null;
            debit = accountBankId == null ? cashInacct.getCashData(this.companyId, accountViewId, currencyId, beginCal.getTime(), DateHelper.getBeforeDay((java.util.Date)beginDate), CashDataTypeEnum.JF, true) : cashInacct.getBankData(this.companyId, accountBankId, currencyId, beginCal.getTime(), DateHelper.getBeforeDay((java.util.Date)beginDate), CashDataTypeEnum.JF, true);
            yearSum.put(currencyId, value.add(debit));
        }
        return yearSum;
    }

    private Map getYearCreditSum(String[] currencyIds, CompanyOrgUnitInfo company, String accountBankId, String accountViewId, java.util.Date beginDate, PeriodInfo periodStart, boolean accContrastEnable) throws EASBizException, BOSException, SQLException {
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.setTime(beginDate);
        int year = endCal.get(1);
        GregorianCalendar begincal = new GregorianCalendar(year, 0, 1);
        HashMap<String, BigDecimal> yearSum = new HashMap<String, BigDecimal>();
        boolean isFirstYear = true;
        if (year != periodStart.getPeriodYear()) {
            isFirstYear = false;
        }
        for (int i = 0; i < currencyIds.length; ++i) {
            if (accContrastEnable) {
                yearSum.put(currencyIds[i], SysConstant.BIGZERO);
                continue;
            }
            String currencyId = currencyIds[i];
            BigDecimal value = SysConstant.BIGZERO;
            if (isFirstYear) {
                value = accountBankId == null ? CashHelper.getYearStartAmount(CashDataSourceEnum.C, this.companyId, accountViewId, null, currencyId, CashDataTypeEnum.DF) : CashHelper.getYearStartAmount(CashDataSourceEnum.B, this.companyId, null, accountBankId, currencyId, CashDataTypeEnum.DF);
            }
            ICashManagement cashInacct = CashManagementFactory.getRemoteInstance();
            BigDecimal debit = null;
            debit = accountBankId == null ? cashInacct.getCashData(this.companyId, accountViewId, currencyId, begincal.getTime(), DateHelper.getBeforeDay((java.util.Date)beginDate), CashDataTypeEnum.DF, true) : cashInacct.getBankData(this.companyId, accountBankId, currencyId, begincal.getTime(), DateHelper.getBeforeDay((java.util.Date)beginDate), CashDataTypeEnum.DF, true);
            yearSum.put(currencyId, value.add(debit));
        }
        return yearSum;
    }

    private Map getYearDebitSum(String[] currencyIds, String companyId, String accountBankId, String accountViewId, java.util.Date beginDate) throws EASBizException, BOSException, SQLException {
        GregorianCalendar endCal = new GregorianCalendar();
        endCal.setTime(beginDate);
        int year = endCal.get(1);
        GregorianCalendar beginCal = new GregorianCalendar(year, 0, 1);
        HashMap<String, BigDecimal> yearSum = new HashMap<String, BigDecimal>();
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)));
        PeriodInfo periodStart = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company);
        boolean isFirstYear = true;
        if (year != periodStart.getPeriodYear()) {
            isFirstYear = false;
        }
        for (int i = 0; i < currencyIds.length; ++i) {
            String currencyId = currencyIds[i];
            BigDecimal value = SysConstant.BIGZERO;
            if (isFirstYear) {
                value = accountBankId == null ? CashHelper.getYearStartAmount(CashDataSourceEnum.C, companyId, accountViewId, null, currencyId, CashDataTypeEnum.JF) : CashHelper.getYearStartAmount(CashDataSourceEnum.B, companyId, null, accountBankId, currencyId, CashDataTypeEnum.JF);
            }
            ICashManagement cashInacct = CashManagementFactory.getRemoteInstance();
            BigDecimal debit = null;
            debit = accountBankId == null ? cashInacct.getCashData(companyId, accountViewId, currencyId, beginCal.getTime(), DateHelper.getBeforeDay((java.util.Date)beginDate), CashDataTypeEnum.JF, true) : cashInacct.getBankData(companyId, accountBankId, currencyId, beginCal.getTime(), DateHelper.getBeforeDay((java.util.Date)beginDate), CashDataTypeEnum.JF, true);
            yearSum.put(currencyId, value.add(debit));
        }
        return yearSum;
    }

    private Map getPeriodDebitOff(String[] currencyIds, String companyId, String accountBankId, String accountViewId, java.util.Date beginDate, java.util.Date endDate) throws EASBizException, BOSException {
        HashMap<String, BigDecimal> periodOff = new HashMap<String, BigDecimal>();
        if (beginDate.after(endDate)) {
            this.clearMap(currencyIds, periodOff);
            return periodOff;
        }
        for (int i = 0; i < currencyIds.length; ++i) {
            String currencyId = currencyIds[i];
            ICashManagement cashInacct = CashManagementFactory.getRemoteInstance();
            BigDecimal debit = null;
            debit = accountBankId == null ? cashInacct.getCashData(companyId, accountViewId, currencyId, beginDate, endDate, CashDataTypeEnum.JF, true) : cashInacct.getBankData(companyId, accountBankId, currencyId, beginDate, endDate, CashDataTypeEnum.JF, true);
            periodOff.put(currencyId, debit);
        }
        return periodOff;
    }

    private Map getPeriodCreditOff(String[] currencyIds, String companyId, String accountBankId, String accountViewId, java.util.Date beginDate, java.util.Date endDate) throws EASBizException, BOSException {
        HashMap<String, BigDecimal> periodOff = new HashMap<String, BigDecimal>();
        if (beginDate.after(endDate)) {
            this.clearMap(currencyIds, periodOff);
            return periodOff;
        }
        for (int i = 0; i < currencyIds.length; ++i) {
            String currencyId = currencyIds[i];
            ICashManagement cashInacct = CashManagementFactory.getRemoteInstance();
            BigDecimal credit = null;
            credit = accountBankId == null ? cashInacct.getCashData(companyId, accountViewId, currencyId, beginDate, endDate, CashDataTypeEnum.DF, true) : cashInacct.getBankData(companyId, accountBankId, currencyId, beginDate, endDate, CashDataTypeEnum.DF, true);
            periodOff.put(currencyId, credit);
        }
        return periodOff;
    }

    private void initColumn(KDTable tblMain, String[] currencyIds) {
        IColumn column;
        String currencyId;
        int i;
        tblMain.addColumn().setKey("createDate");
        tblMain.addColumn().setKey("voucherType");
        tblMain.addColumn().setKey("voucherNumber");
        tblMain.addColumn().setKey("oppAccountNumber");
        tblMain.addColumn().setKey("billType");
        tblMain.addColumn().setKey("billNumber");
        tblMain.addColumn().setKey("description");
        tblMain.addColumn().setKey("settType");
        tblMain.addColumn().setKey("settNumber");
        tblMain.addColumn().setKey("ticketType");
        tblMain.addColumn().setKey("ticketNumber");
        tblMain.addColumn().setKey("exchange");
        tblMain.getColumn("ticketType").getStyleAttributes().setHided(true);
        tblMain.getColumn("ticketNumber").getStyleAttributes().setHided(true);
        for (i = 0; i < currencyIds.length; ++i) {
            currencyId = currencyIds[i];
            column = tblMain.addColumn();
            column.setKey("debit_" + currencyId);
            this.setCurrencyColumnFmt(column, currencyId);
            column = tblMain.addColumn();
            column.setKey("localDebit_" + currencyId);
            this.setCurrencyColumnFmt(column, this.baseCurrency.getId().toString());
        }
        for (i = 0; i < currencyIds.length; ++i) {
            currencyId = currencyIds[i];
            column = tblMain.addColumn();
            column.setKey("credit_" + currencyId);
            this.setCurrencyColumnFmt(column, currencyId);
            column = tblMain.addColumn();
            column.setKey("localCredit_" + currencyId);
            this.setCurrencyColumnFmt(column, this.baseCurrency.getId().toString());
        }
        tblMain.addColumn().setKey("dc");
        for (i = 0; i < currencyIds.length; ++i) {
            currencyId = currencyIds[i];
            column = tblMain.addColumn();
            column.setKey("balance_" + currencyId);
            this.setCurrencyColumnFmt(column, currencyId);
            column = tblMain.addColumn();
            column.setKey("localBalance_" + currencyId);
            this.setCurrencyColumnFmt(column, this.baseCurrency.getId().toString());
        }
    }

    private void initHead(KDTable tblMain, String[] currencyIds, Map parmaMap) throws EASBizException, BOSException {
        IRow headRow1 = tblMain.addHeadRow();
        IRow headRow2 = tblMain.addHeadRow();
        this.initRow1(headRow1);
        this.initRow2(headRow2);
        this.mergeRow1AndRow2(tblMain);
        String firstCurrencyId = null;
        if (currencyIds.length == 1) {
            CompanyOrgUnitInfo companyInfo;
            String currencyId = currencyIds[0];
            CompanyOrgUnitInfo currentCompany = companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            if (this.isShowOneHeadRow(parmaMap, currencyId, companyInfo, currentCompany)) {
                tblMain.getColumn("exchange").getStyleAttributes().setHided(true);
                tblMain.getColumn("localBalance_" + currencyId).getStyleAttributes().setHided(true);
                tblMain.getColumn("localDebit_" + currencyId).getStyleAttributes().setHided(true);
                tblMain.getColumn("localCredit_" + currencyId).getStyleAttributes().setHided(true);
                tblMain.removeHeadRow(1);
            }
            headRow1.getCell("balance_" + currencyId).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"balance"));
            headRow2.getCell("balance_" + currencyId).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"sourceCurrency"));
            headRow1.getCell("localBalance_" + currencyId).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"beginBalance"));
            headRow2.getCell("localBalance_" + currencyId).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"baseCurrency"));
            headRow1.getCell("debit_" + currencyId).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"debit"));
            headRow2.getCell("debit_" + currencyId).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"sourceCurrency"));
            headRow1.getCell("localDebit_" + currencyId).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"debit"));
            headRow2.getCell("localDebit_" + currencyId).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"baseCurrency"));
            headRow1.getCell("credit_" + currencyId).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"credit"));
            headRow2.getCell("credit_" + currencyId).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"sourceCurrency"));
            headRow1.getCell("localCredit_" + currencyId).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"credit"));
            headRow2.getCell("localCredit_" + currencyId).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"baseCurrency"));
            firstCurrencyId = currencyId;
        } else {
            CurrencyInfo currency;
            int i;
            CurrencyCollection currencys = null;
            currencys = parmaMap.get("currencyCollection") == null ? CurrencyFactory.getRemoteInstance().getCurrencyCollection(true) : (CurrencyCollection)parmaMap.get("currencyCollection");
            tblMain.getColumn("exchange").getStyleAttributes().setHided(true);
            firstCurrencyId = currencys.get(0).getId().toString();
            String currencyId = null;
            for (i = 0; i < currencys.size(); ++i) {
                currency = currencys.get(i);
                currencyId = currency.getId().toString();
                tblMain.getColumn("localBalance_" + currencyId).getStyleAttributes().setHided(true);
                tblMain.getColumn("localDebit_" + currencyId).getStyleAttributes().setHided(true);
                tblMain.getColumn("localCredit_" + currencyId).getStyleAttributes().setHided(true);
            }
            for (i = 0; i < currencys.size(); ++i) {
                currency = currencys.get(i);
                currencyId = currency.getId().toString();
                headRow1.getCell("balance_" + currencyId).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"balance"));
                headRow1.getCell("debit_" + currencyId).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"debit"));
                headRow1.getCell("credit_" + currencyId).setValue((Object)EASResource.getString((String)this.resourcePath, (String)"credit"));
                headRow2.getCell("balance_" + currencyId).setValue((Object)currency.getName());
                headRow2.getCell("debit_" + currencyId).setValue((Object)currency.getName());
                headRow2.getCell("credit_" + currencyId).setValue((Object)currency.getName());
            }
        }
        headRow1.getCell("dc").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"dc"));
        headRow2.getCell("dc").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"dc"));
        tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex("balance_" + firstCurrencyId), 0, tblMain.getColumnIndex("balance_" + firstCurrencyId) + currencyIds.length * 2 - 1);
        tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex("debit_" + firstCurrencyId), 0, tblMain.getColumnIndex("debit_" + firstCurrencyId) + currencyIds.length * 2 - 1);
        tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex("credit_" + firstCurrencyId), 0, tblMain.getColumnIndex("credit_" + firstCurrencyId) + currencyIds.length * 2 - 1);
        tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex("dc"), 1, tblMain.getColumnIndex("dc"));
    }

    private boolean isShowOneHeadRow(Map parmaMap, String currencyId, CompanyOrgUnitInfo companyInfo, CompanyOrgUnitInfo currentCompany) {
        return this.isLocalCurrency(currencyId, companyInfo) || !this.getParam_CS003(parmaMap, companyInfo) || GlUtils.isCompanyUnion((CompanyOrgUnitInfo)currentCompany);
    }

    private boolean getParam_CS003(Map parmaMap, CompanyOrgUnitInfo companyInfo) {
        boolean isShowLocalCurrency_CS003 = false;
        isShowLocalCurrency_CS003 = parmaMap.get("CS003") == null ? CashHelper.isShowLocalCurrency(companyInfo.getId().toString()) : (Boolean)parmaMap.get("CS003");
        return isShowLocalCurrency_CS003;
    }

    private boolean isLocalCurrency(String currencyId, CompanyOrgUnitInfo companyInfo) {
        return currencyId.equals(companyInfo.getBaseCurrency().getId().toString());
    }

    private void mergeRow1AndRow2(KDTable tblMain) {
        int offset = tblMain.getColumnIndex("exchange");
        for (int i = 0; i <= offset; ++i) {
            tblMain.getHeadMergeManager().mergeBlock(0, i, 1, i);
        }
    }

    private void initRow1(IRow headRow1) {
        headRow1.getCell("createDate").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"date"));
        headRow1.getCell("voucherType").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"voucherType"));
        headRow1.getCell("voucherNumber").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"voucherNumber"));
        headRow1.getCell("oppAccountNumber").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"oppAccount"));
        headRow1.getCell("billType").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"billType"));
        headRow1.getCell("billNumber").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"billNumber"));
        headRow1.getCell("description").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"description"));
        headRow1.getCell("settType").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"settType"));
        headRow1.getCell("settNumber").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"settNumber"));
        headRow1.getCell("ticketType").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"ticketType"));
        headRow1.getCell("billNumber").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"billNumber"));
        headRow1.getCell("ticketNumber").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"ticketNumber"));
        headRow1.getCell("exchange").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"exchange"));
    }

    private void initRow2(IRow headRow2) {
        headRow2.getCell("createDate").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"createDate"));
        headRow2.getCell("voucherType").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"voucherType"));
        headRow2.getCell("voucherNumber").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"voucherNumber"));
        headRow2.getCell("oppAccountNumber").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"oppAccountNumber"));
        headRow2.getCell("billType").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"billType"));
        headRow2.getCell("billNumber").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"billNumber"));
        headRow2.getCell("description").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"description"));
        headRow2.getCell("settType").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"settType"));
        headRow2.getCell("settNumber").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"settNumber"));
        headRow2.getCell("ticketType").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"ticketType"));
        headRow2.getCell("billNumber").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"billNumber"));
        headRow2.getCell("ticketNumber").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"ticketNumber"));
        headRow2.getCell("exchange").setValue((Object)EASResource.getString((String)this.resourcePath, (String)"exchange"));
    }

    public void initTable(KDTable tblMain, String[] currencyIds, Map parmaMap) throws EASBizException, BOSException {
        if (currencyIds == null) {
            return;
        }
        this.baseCurrency = ContextHelperFactory.getRemoteInstance().getCurrentCompany().getBaseCurrency();
        tblMain.removeColumns();
        tblMain.removeHeadRows();
        tblMain.checkParsed();
        tblMain.getStyleAttributes().setLocked(true);
        this.initColumn(tblMain, currencyIds);
        this.initHead(tblMain, currencyIds, parmaMap);
    }

    private void setCurrencyColumnFmt(IColumn column, String currencyId) {
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
        column.getStyleAttributes().setNumberFormat(numberFtm);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void setRowDCByAmount(IRow row, BigDecimal amont) {
        if (amont.signum() > 0) {
            row.getCell("dc").setValue((Object)DirectionEnum.Debit);
        } else if (amont.signum() < 0) {
            row.getCell("dc").setValue((Object)DirectionEnum.Credit);
        } else {
            row.getCell("dc").setValue((Object)DirectionEnum.Balance);
        }
    }

    private void setRowFormat(IRow row, String currencyId) {
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
        row.getCell("debit_" + currencyId).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell("credit_" + currencyId).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell("balance_" + currencyId).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell("debit_" + currencyId).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("credit_" + currencyId).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("balance_" + currencyId).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("localDebit_" + currencyId).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell("localCredit_" + currencyId).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell("localBalance_" + currencyId).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell("localDebit_" + currencyId).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("localCredit_" + currencyId).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("localBalance_" + currencyId).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }
}

