/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CapitalSubLegerFecthParamFacadeFactory;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractCapitalSubLegerUI;
import com.kingdee.eas.fi.cas.client.CapitalSubLegerFilterParam;
import com.kingdee.eas.fi.cas.client.CapitalSubLegerFilterUI;
import com.kingdee.eas.fi.cas.client.CapitalSubLegerHandler;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.utils.PeriodRange;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.CheckUtils;
import com.kingdee.eas.fm.common.ConvertUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.UuidException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Date;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;

public class CapitalSubLegerUI
extends AbstractCapitalSubLegerUI {
    private static final Logger logger = Logger.getLogger(CapitalSubLegerUI.class);
    private static final String ACCOUNT = "account";
    private static final String ACCOUNTBANK = "accountBank";
    public static final String COMPANY = "company";
    public static final String CURRENCY = "currency";
    public static final String resourcePath = "com.kingdee.eas.fi.cas.CasResources";
    public boolean isViewDetail = false;
    private String acctTableId = null;
    private String[] currencyIds;
    CompanyOrgUnitInfo currentCompany;
    int currentCompanyIndex;
    private CapitalSubLegerFilterUI filterUI;
    private CapitalSubLegerHandler handler = new CapitalSubLegerHandler();
    private boolean isLoading = false;
    CapitalSubLegerFilterParam para = null;
    private Map parmaMap;

    public static void showCapitalSubUI(IUIObject ui, CapitalSubLegerFilterParam param, Object currency, AccountBankInfo acctBank, AccountViewInfo acct) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
        uiContext.put((Object)"filterParam", (Object)param);
        if (acctBank != null) {
            uiContext.put((Object)ACCOUNTBANK, (Object)acctBank);
            uiContext.put((Object)"ID", (Object)acctBank.getId().toString());
        } else {
            uiContext.put((Object)ACCOUNT, (Object)acct);
            if (acct != null) {
                uiContext.put((Object)"ID", (Object)acct.getId().toString());
            }
        }
        uiContext.put((Object)CURRENCY, currency);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIUtil.getEditUIMode((CoreUIObject)((CoreUIObject)ui))).create(CapitalSubLegerUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionNextCompany_actionPerformed(ActionEvent e) throws Exception {
        int size = this.para.getCompanyIds().length;
        if (this.currentCompanyIndex < size - 1) {
            ++this.currentCompanyIndex;
            this.changeCompany(this.currentCompanyIndex);
            this.btnPreCompany.setEnabled(true);
        }
        if (this.currentCompanyIndex == size - 1) {
            this.btnNextCompany.setEnabled(false);
        }
        super.actionNextCompany_actionPerformed(e);
    }

    @Override
    public void actionPreCompany_actionPerformed(ActionEvent e) throws Exception {
        if (this.currentCompanyIndex > 0) {
            --this.currentCompanyIndex;
            this.changeCompany(this.currentCompanyIndex);
            this.btnNextCompany.setEnabled(true);
        }
        if (this.currentCompanyIndex == 0) {
            this.btnPreCompany.setEnabled(false);
        }
        super.actionPreCompany_actionPerformed(e);
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        this.fillData();
    }

    @Override
    public void actionViewJournal_actionPerformed(ActionEvent e) throws Exception {
        String billId;
        boolean flag;
        IRow row = this.tblMain.getRow(this.tblMain.getSelectManager().getActiveRowIndex());
        if (row == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.handler.resourcePath, (String)"InValiadLine"));
            return;
        }
        if (row.getCell("createDate").getUserObject() != null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.handler.resourcePath, (String)"InValiadLine"));
            return;
        }
        Object billType = row.getCell("billType").getValue();
        Object billNumber = row.getCell("billNumber").getValue();
        if (billType != null && billNumber != null && (billType.equals((Object)BillTypeEnum.paymentBill) || billType.equals((Object)BillTypeEnum.receiveBill)) && (flag = billNumber.toString().contains(";"))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResource", (String)"canNotViewJournal"));
            SysUtil.abort();
        }
        if ((billId = (String)row.getUserObject()) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"CreateByHand"));
            return;
        }
        FMClientHelper.viewDetailBill((CoreUIObject)this, (String)billId, (CompanyOrgUnitInfo)this.currentCompany);
    }

    public void changeCompany(int index) throws EASBizException, BOSException, SQLException {
        this.currentCompanyIndex = index;
        String[] companyIds = this.para.getCompanyIds();
        if (companyIds == null || companyIds.length == 0) {
            SysUtil.abort();
            return;
        }
        String companyId = companyIds[index];
        this.currentCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId)));
        CurrencyInfo baseCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);
        UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)baseCurrency);
        this.tblMain.removeRows();
        this.initAccountBank();
        this.txtCompany.setText(this.currentCompany.getName());
        if (!this.isLoading) {
            this.fillData();
        }
    }

    @Override
    protected void comboAccountView_actionPerformed(ActionEvent e) throws Exception {
        super.comboAccountView_actionPerformed(e);
        if (((JournalTypeEnum)this.comboCapitalType.getSelectedItem()).equals((Object)JournalTypeEnum.CASH) && !this.isLoading) {
            this.fillData();
        }
    }

    @Override
    protected void comboCapitalType_actionPerformed(ActionEvent e) throws Exception {
        super.comboCapitalType_actionPerformed(e);
        if (this.isViewDetail && !this.comboCapitalType.isEnabled()) {
            return;
        }
        JournalTypeEnum capitalType = (JournalTypeEnum)this.comboCapitalType.getSelectedItem();
        if (capitalType.equals((Object)JournalTypeEnum.BANK)) {
            this.comboAccountView.setEnabled(false);
            this.f7AccountBank.setEnabled(true);
            this.initAccountBank();
        } else {
            this.comboAccountView.setEnabled(true);
            this.f7AccountBank.setEnabled(false);
            this.f7AccountBank.setValue(null);
            this.initAcct();
        }
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.comboCurrency_actionPerformed(e);
        if (!(this.comboCurrency.getSelectedItem() instanceof FMSysDefinedEnum)) {
            CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
            if (currency == null) {
                return;
            }
            this.currencyIds = new String[]{currency.getId().toString()};
        } else {
            CurrencyCollection currencys = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
            this.currencyIds = new String[currencys.size()];
            for (int i = 0; i < this.currencyIds.length; ++i) {
                this.currencyIds[i] = currencys.get(i).getId().toString();
            }
        }
        if (!this.isLoading) {
            this.fillData();
        }
    }

    protected void execQuery() throws BOSException {
        Object[] args;
        this.tblMain.removeRows();
        this.isLoading = true;
        if (this.getUIContext().get("filterParam") != null) {
            this.para = (CapitalSubLegerFilterParam)this.getUIContext().get("filterParam");
            args = new String[]{String.valueOf(this.para.getBeginYear()), String.valueOf(this.para.getBeginMonth()), String.valueOf(this.para.getEndYear()), String.valueOf(this.para.getEndMonth())};
            String result = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"LBL_PeriodRange"), args);
            this.txtPeriod.setText(result);
            String companyId = this.para.getCompanyIds()[0];
            try {
                this.currentCompany = this.parmaMap.get("currentCompany") == null ? CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)companyId))) : (CompanyOrgUnitInfo)this.parmaMap.get("currentCompany");
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (BOSException e) {
                logger.error((Object)e);
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            catch (UuidException e) {
                logger.error((Object)e);
                this.handUIExceptionAndAbort((Exception)((Object)e));
            }
            try {
                ((CapitalSubLegerFilterUI)this.getFilterUI()).enableBtnCompany(false);
            }
            catch (Exception e) {
                logger.error((Object)e);
                SysUtil.abort();
            }
            this.txtCompany.setText(this.currentCompany.getName());
            if (this.getUIContext().get(ACCOUNTBANK) != null) {
                Object accountBank = this.getUIContext().get(ACCOUNTBANK);
                this.comboCapitalType.setSelectedIndex(1);
                this.f7AccountBank.setData(accountBank);
            } else {
                Object account = this.getUIContext().get(ACCOUNT);
                this.comboCapitalType.setSelectedIndex(0);
                this.comboAccountView.setSelectedItem(account);
                UIUtil.setSelectObject((KDComboBox)this.comboAccountView, account);
                if (account == null) {
                    this.comboCapitalType.setEnabled(true);
                    this.comboCapitalType.setSelectedIndex(0);
                }
            }
            Object currency = this.getUIContext().get(CURRENCY);
            this.comboCurrency.setSelectedItem(currency);
            this.getUIContext().put("filterParam", null);
            this.isViewDetail = true;
        } else {
            this.para = (CapitalSubLegerFilterParam)this.getFilterParam();
            if (this.para.isByDay()) {
                this.txtPeriod.setText("" + new Date(this.para.getFromDate().getTime()) + " -- " + new Date(this.para.getToDate().getTime()));
            } else {
                args = new String[]{String.valueOf(this.para.getBeginYear()), String.valueOf(this.para.getBeginMonth()), String.valueOf(this.para.getEndYear()), String.valueOf(this.para.getEndMonth())};
                String result = MessageFormat.format(EASResource.getString((String)resourcePath, (String)"LBL_PeriodRange"), args);
                this.txtPeriod.setText(result);
            }
            if (!this.isViewDetail) {
                try {
                    this.changeCompany(0);
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                    SysUtil.abort();
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                    SysUtil.abort();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                    SysUtil.abort();
                }
                this.comboCapitalType.setSelectedIndex(0);
            }
        }
        if (EmptyUtil.isEmpty((String)this.para.getAcctTableId())) {
            if (!((Boolean)this.parmaMap.get("isVerified")).booleanValue()) {
                this.acctTableId = FMClientHelper.getActualAcctTable((java.util.Date)this.para.getBeginQueryDate(), (java.util.Date)this.para.getEndQueryDate());
                this.para.setAcctTableId(this.acctTableId);
            } else {
                this.acctTableId = (String)this.parmaMap.get("parmaMap");
                this.para.setAcctTableId(this.acctTableId);
            }
        } else {
            this.acctTableId = this.para.getAcctTableId();
        }
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        this.btnPreCompany.setEnabled(false);
        if (this.para.getCompanyIds().length <= 1) {
            this.btnNextCompany.setEnabled(false);
        } else {
            this.btnNextCompany.setEnabled(true);
        }
        this.isLoading = false;
        try {
            this.fillData();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        catch (SQLException e) {
            this.handUIException(e);
        }
    }

    @Override
    protected void f7AccountBank_dataChanged(DataChangeEvent e) throws Exception {
        super.f7AccountBank_dataChanged(e);
        if (((JournalTypeEnum)this.comboCapitalType.getSelectedItem()).equals((Object)JournalTypeEnum.BANK)) {
            AccountBankInfo accountBank = (AccountBankInfo)this.f7AccountBank.getData();
            if (accountBank == null) {
                return;
            }
            CurrencyInfo currency = null;
            if (accountBank.isIsByCurrency()) {
                currency = accountBank.getCurrency();
                this.comboCurrency.setEnabled(false);
            } else {
                currency = this.currentCompany.getBaseCurrency();
                this.comboCurrency.setEnabled(true);
            }
            Map listen = FMClientHelper.removeComponentListeners((JComponent)this.comboCurrency);
            UIUtil.setSelectObject((KDComboBox)this.comboCurrency, (Object)currency);
            FMClientHelper.addComponentListeners((JComponent)this.comboCurrency, (Map)listen);
            AccountBankCollection coll = new AccountBankCollection();
            coll.add(accountBank);
            coll = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankCollection)coll, null, (String)this.acctTableId);
            AccountViewInfo acct = null;
            if (coll != null && coll.size() == 1) {
                acct = coll.get(0).getAccount();
            }
            acct = accountBank.getAccount();
            this.comboAccountView.removeAllItems();
            this.comboAccountView.addItem((Object)acct);
            this.comboAccountView.setSelectedIndex(0);
            if (!this.isLoading) {
                this.fillData();
            }
        }
    }

    public void fillData() throws EASBizException, BOSException, SQLException {
        if (this.mainQuery == null) {
            return;
        }
        EntityViewInfo ev = (EntityViewInfo)this.mainQuery.clone();
        AccountViewInfo acct = (AccountViewInfo)this.comboAccountView.getSelectedItem();
        FilterInfo filter = ev.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        AccountBankInfo accountBank = (AccountBankInfo)this.f7AccountBank.getData();
        Object currencyObject = this.comboCurrency.getSelectedItem();
        if (acct == null || currencyObject == null) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)currencyObject;
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currency.getId().toString()));
        PeriodRange pRGE = (PeriodRange)((Object)this.parmaMap.get("PeriodRange"));
        if (CheckUtils.exist((Object)((Object)pRGE))) {
            if (pRGE == PeriodRange.NO13) {
                filter.getFilterItems().add(ConvertUtils.FITEM((Object[])new Object[]{"PERIODNUMBER", 13, CompareType.NOTEQUALS}));
            } else if (pRGE == PeriodRange.EQUAL13) {
                filter.getFilterItems().add(ConvertUtils.FITEM((Object[])new Object[]{"PERIODNUMBER", 13, CompareType.EQUALS}));
            }
        }
        CashDataSourceEnum dataType = CashDataSourceEnum.C;
        JournalTypeEnum capitalType = (JournalTypeEnum)this.comboCapitalType.getSelectedItem();
        if (capitalType.equals((Object)JournalTypeEnum.BANK)) {
            dataType = CashDataSourceEnum.B;
            if (accountBank == null) {
                return;
            }
            if (!accountBank.getCompany().getId().toString().equals(this.currentCompany.getId().toString())) {
                return;
            }
            filter.getFilterItems().add(new FilterItemInfo("accountBank.id", (Object)accountBank.getId().toString()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("accountView.id", (Object)acct.getId().toString()));
        }
        this.currencyIds[0] = currency.getId().toString();
        this.handler.initTable(this.tblMain, this.currencyIds, this.parmaMap);
        this.initUserConfig();
        IRowSet rowset = this.handler.getRowset(this.mainQueryPK, ev);
        this.handler.fillData(dataType, this.tblMain, rowset, currency, this.currentCompany, accountBank, acct, this.para, this.parmaMap);
        this.tblMain.getColumn("createDate").getStyleAttributes().setNumberFormat(ClientUtils.getDateFormatString());
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CapitalSubLegerFilterUI(this.parmaMap);
        }
        return this.filterUI;
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    public CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog commonQueryDialog = super.getQueryDlg();
        commonQueryDialog.setWidth(450);
        commonQueryDialog.setHeight(380);
        return commonQueryDialog;
    }

    public void initAccountBank() {
        EventListener[] allLi = this.f7AccountBank.getListeners(DataChangeListener.class);
        DataChangeListener act = null;
        if (allLi.length > 0) {
            act = (DataChangeListener)allLi[0];
            this.f7AccountBank.removeDataChangeListener(act);
        }
        AccountBankInfo firstAccountBank = null;
        EntityViewInfo view = new EntityViewInfo();
        if (this.currentCompany == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.currentCompany.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isBank", (Object)Constants.TRUE));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("bankaccountnumber"));
        this.f7AccountBank.setEntityViewInfo(view);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("account.*"));
        this.f7AccountBank.setSelectorCollection(selector);
        try {
            IContextHelper ctxHelper = ContextHelperFactory.getRemoteInstance();
            ObjectUuidPK userPK = new ObjectUuidPK(ctxHelper.getCurrentUser().getId());
            ObjectUuidPK orgPK = new ObjectUuidPK(ctxHelper.getCurrentCompany().getId());
            IPermissionServiceProvider provider = PermissionServiceProviderFactory.getRemoteInstance();
            String rule = provider.getPermissionRule((IObjectPK)userPK, (IObjectPK)orgPK, "bd_assistant_accountBank_view");
            EntityViewInfo evi = new EntityViewInfo();
            try {
                if (rule != null) {
                    evi = new EntityViewInfo(rule);
                }
            }
            catch (ParserException e) {
                logger.error((Object)e);
                evi = new EntityViewInfo();
            }
            if (evi.getFilter() != null) {
                evi.getFilter().mergeFilter(view.getFilter(), "and");
            } else {
                evi.setFilter(view.getFilter());
            }
            evi.getSelector().add(new SelectorItemInfo("*"));
            evi.getSelector().add(new SelectorItemInfo("account.*"));
            AccountBankCollection accountBanks = null;
            accountBanks = this.parmaMap.get("accountBanks") == null ? AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi) : (AccountBankCollection)this.parmaMap.get("accountBanks");
            if (accountBanks.size() != 0) {
                firstAccountBank = accountBanks.get(0);
                this.f7AccountBank.setEditable(true);
            } else {
                this.tblMain.removeRows();
                this.comboAccountView.removeAllItems();
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            this.abort();
        }
        if (act != null) {
            this.f7AccountBank.addDataChangeListener(act);
        }
        if (firstAccountBank != null) {
            this.f7AccountBank.setData(firstAccountBank);
        }
    }

    public void initAcct() throws EASBizException, BOSException {
        this.comboAccountView.removeAllItems();
        String acctTableId = this.para.getAcctTableId();
        AccountViewCollection acct = FMHelper.getAcctViewCollection(null, (String)this.currentCompany.getId().toString(), (String)acctTableId, null, (AccountTypeEnum)AccountTypeEnum.CASHACCOUNT);
        if (acct == null) {
            return;
        }
        this.comboAccountView.addItems(acct.toArray());
        this.comboCurrency.setEnabled(true);
    }

    protected void initWorkButton() {
        this.actionViewJournal.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        this.actionNextCompany.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_next"));
        this.actionPreCompany.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_previous"));
        super.initWorkButton();
    }

    public void onLoad() throws Exception {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        this.parmaMap = new HashMap();
        this.parmaMap.put("currentCompany", null);
        this.parmaMap.put("currentPeriod", null);
        this.parmaMap.put("currencyCollection", null);
        this.parmaMap.put("isStart", null);
        if ((CapitalSubLegerFilterParam)this.getUIContext().get("filterParam") != null) {
            this.parmaMap.put("companyID", ((CapitalSubLegerFilterParam)this.getUIContext().get("filterParam")).getCompanyIds()[0]);
        } else {
            this.parmaMap.put("companyID", null);
        }
        this.parmaMap = CapitalSubLegerFecthParamFacadeFactory.getRemoteInstance().fetchParam_MainUI(this.parmaMap);
        if (this.parmaMap.get("currentCompany") != null) {
            company = (CompanyOrgUnitInfo)this.parmaMap.get("currentCompany");
        }
        if (!"VIEW".equalsIgnoreCase(this.getOprtState())) {
            ClientUtils.checkCompany((Component)((Object)this), company);
        } else {
            this.actionQuery.setEnabled(false);
            this.actionQuery.setVisible(false);
        }
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
            boolean flag = false;
            flag = this.parmaMap.get("isStart") == null ? SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)company) : (Boolean)this.parmaMap.get("isStart");
            if (!flag) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CasNoInit"));
                SysUtil.abort();
            }
        }
        this.tblMain.getSelectManager().setSelectMode(2);
        this.txtCompany.setEnabled(false);
        if (this.parmaMap.get("currencyCollection") == null) {
            FMClientHelper.initCurrency((KDComboBox)this.comboCurrency);
        } else {
            FMClientHelper.initCurrency((KDComboBox)this.comboCurrency, (CurrencyCollection)((CurrencyCollection)this.parmaMap.get("currencyCollection")));
        }
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
            this.contCompany.setVisible(false);
            this.btnNextCompany.setVisible(false);
            this.btnPreCompany.setVisible(false);
        } else {
            this.contCompany.setVisible(true);
        }
        this.tblMain.getViewManager().setFreezeView(0, 4);
        this.setTitle();
        super.onLoad();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    private void setTitle() {
        CompanyOrgUnitInfo curC = (CompanyOrgUnitInfo)this.parmaMap.get("currentCompany");
        if (curC == null || GlUtils.isCompanyUnion((CompanyOrgUnitInfo)curC)) {
            return;
        }
        PeriodInfo curP = (PeriodInfo)this.parmaMap.get("currentPeriod");
        if (curP == null) {
            return;
        }
        this.sysStatusBarTitle = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"128_BankJournalListUI"), curP.getPeriodYear(), curP.getPeriodNumber());
    }

    public FilterParam getDefalutQueryParam() {
        return super.getDefalutQueryParam();
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPre_actionPerformed(e);
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        JournalTypeEnum type = (JournalTypeEnum)this.comboCapitalType.getSelectedItem();
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        AccountBankInfo accountBank = (AccountBankInfo)this.f7AccountBank.getValue();
        AccountViewInfo accountView = (AccountViewInfo)this.comboAccountView.getSelectedItem();
        if (type == null || currency == null || accountView == null) {
            return;
        }
        String headString = null;
        String typeString = this.contCapitalType.getBoundLabelText() + "\uff1a &[type]";
        String accountBankString = "";
        if (accountBank != null) {
            accountBankString = this.contAccountBank.getBoundLabelText() + "\uff1a&[BankAccountNumber]";
        }
        headString = typeString + "&|" + accountBankString;
        headerModel.addRow(headString, Styles.getDefaultSA());
        String currencyString = this.contCurrency.getBoundLabelText() + "\uff1a&[currency]";
        String accountString = this.contAccountView.getBoundLabelText() + "\uff1a&[accountViewNumber]&[accountViewName] ";
        headString = currencyString + "&|" + accountString;
        headerModel.addRow(headString, Styles.getDefaultSA());
        String periodString = this.contPeriod.getBoundLabelText() + "\uff1a&[periodStr]";
        String companyString = this.contCompany.getBoundLabelText() + "\uff1a&[companyStr]";
        headString = periodString + "&|" + companyString;
        headerModel.addRow(headString, Styles.getDefaultSA());
        super.preparePrintPageHeader(headerModel);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        JournalTypeEnum type = (JournalTypeEnum)this.comboCapitalType.getSelectedItem();
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        AccountBankInfo accountBank = (AccountBankInfo)this.f7AccountBank.getValue();
        AccountViewInfo accountView = (AccountViewInfo)this.comboAccountView.getSelectedItem();
        String periodStr = this.txtPeriod.getText();
        String companyStr = this.txtCompany.getText();
        if (type == null || currency == null || accountView == null) {
            return map;
        }
        map.put("type", type.getAlias());
        if (accountBank != null) {
            map.put("BankAccountNumber", accountBank.getNumber() + " " + accountBank.getName());
        }
        map.put(CURRENCY, currency.getName());
        map.put("accountViewNumber", accountView.getNumber());
        map.put("accountViewName", accountView.getName());
        map.put("periodStr", periodStr);
        map.put("companyStr", companyStr);
        return map;
    }
}

