/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.XTable;
import com.kingdee.eas.fi.cas.client.CapitalSummaryLegerFilterParam;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;

public class CapitalSummaryLegerHandler {
    public static final String resourcePath = "com.kingdee.eas.fi.cas.client.CapitalSubLedgerResource";

    public XTable createBalanceTable(CapitalSummaryLegerFilterParam para) throws BOSException {
        String balanceSql = this.getBalanceSQL(para.isByBank(), para.getCompanyIds(), para.getBankIds(), para.getCurrencyIds(), para.getBeginDate(), para.getEndDate());
        String sessionSql = this.getSessionSql(para.isByBank(), para.getCompanyIds(), para.getBankIds(), para.getCurrencyIds(), para.getBeginDate());
        IRowSet balanceRS = SQLExecutorFactory.getRemoteInstance((String)balanceSql).executeSQL();
        IRowSet sessionRS = SQLExecutorFactory.getRemoteInstance((String)sessionSql).executeSQL();
        String field = "";
        field = para.isByBank() ? "bank" : "company";
        XTable xBalanceTable = new XTable(balanceRS, new String[]{"year", "month", field, "acct", "acctBank", "company", "currency"});
        XTable xSessionTable = new XTable(sessionRS, new String[]{"year", "month", field, "acct", "acctBank", "company", "currency"});
        this.unionBalanceWithSession(xBalanceTable, xSessionTable, para.getBeginYear(), para.getBeginPeriod(), false, para.isByBank());
        return xBalanceTable;
    }

    public XTable createSumTable(CapitalSummaryLegerFilterParam para) throws BOSException {
        String sumSql = this.getSumSQL(para.isByBank(), para.getCompanyIds(), para.getBankIds(), para.getCurrencyIds(), para.getBeginDate(), para.getEndDate());
        IRowSet sumRS = SQLExecutorFactory.getRemoteInstance((String)sumSql).executeSQL();
        String field = "";
        field = para.isByBank() ? "bank" : "company";
        XTable xSumTable = new XTable(sumRS, new String[]{"year", "month", field, "acct", "acctBank", "company", "currency"});
        return xSumTable;
    }

    public String getBalanceSQL(boolean isByBank, String[] companyIds, String[] bankIds, String[] currencyIds, Date beginDate, Date endDate) {
        int i;
        String field = "";
        field = isByBank ? "fbank as bank" : "t1.fcompanyId company";
        String select = "select  fperiodyear as \"year\",fperiodnumber as \"month\",";
        select = isByBank ? select + field + ",fAccountviewid acct,faccountBankid as acctBank,t1.fcompanyId company," : select + field + ",fAccountviewid acct,faccountBankid as acctBank,";
        select = select + "fcurrencyid as currency,";
        select = select + " isNULL(fmonthStartAmt,0) as beginBalance,fbegindate beginDate";
        String from = " from t_cas_journalbalance t1 inner join t_bd_period t2 on t1.fperiodid=t2.fid left join t_bd_accountBanks t3 on t1.faccountbankid=t3.fid";
        StringBuffer where = new StringBuffer();
        where.append(" where t1.FcompanyId in ('").append(companyIds[0]).append("'");
        for (i = 1; i < companyIds.length; ++i) {
            where.append(",'").append(companyIds[i]).append("'");
        }
        where.append(")");
        where.append("and Fcurrencyid in ('").append(currencyIds[0]).append("'");
        for (i = 1; i < currencyIds.length; ++i) {
            where.append(",'").append(currencyIds[i]).append("'");
        }
        where.append(")");
        where.append("and ( FBank in ('").append(bankIds[0]).append("'");
        for (i = 1; i < bankIds.length; ++i) {
            where.append(",'").append(bankIds[i]).append("'");
        }
        where.append(") or FBank is null )");
        where.append(" and fbegindate <= {").append(TypeConversionUtils.objToDate((Object)endDate)).append("}");
        where.append(" and FIsInit = 0 ");
        where.append(" and FType != 3 ");
        String sql = select + from + where;
        return sql;
    }

    public String[] getLeafCompanys(CompanyOrgUnitInfo company) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from  t_org_company where ");
        sql.append(" (FNumber = '").append(company.getLongNumber().trim()).append("'").append(" or FLongNumber like '").append(company.getLongNumber()).append("!%' ").append(" or FLongNumber like '%!").append(company.getLongNumber()).append("!%')").append(" and FisLeaf =1 and fisonlyunion =0");
        IRowSet rs = SQLExecutorFactory.getRemoteInstance((String)sql.toString()).executeSQL();
        String[] companyIds = new String[rs.size()];
        int i = 0;
        while (rs.next()) {
            companyIds[i++] = rs.getString("fid");
        }
        return companyIds;
    }

    public String getSessionSql(boolean isByBank, String[] companyIds, String[] bankIds, String[] currencyIds, Date beginDate) {
        int i;
        String field = "";
        String groupEntry = "";
        if (isByBank) {
            field = "fbank as bank";
            groupEntry = "fBank";
        } else {
            field = "t1.fcompanyId company";
            groupEntry = "t1.fcompanyid";
        }
        String select = "select fperiodyear as \"year\",fperiodnumber as \"month\" ,";
        select = isByBank ? select + field + ",FAccountViewId as acct,fAccountBankId as acctBank,t1.fcompanyId company ," : select + field + ",FAccountViewId as acct,fAccountBankId as acctBank,";
        select = select + "fcurrencyid as currency,sum(fdebitAmount-fcreditAmount) as amount";
        StringBuffer periodWhere = new StringBuffer();
        periodWhere.append(" where FcompanyId in ('").append(companyIds[0]).append("'");
        for (int i2 = 1; i2 < companyIds.length; ++i2) {
            periodWhere.append(",'").append(companyIds[i2]).append("'");
        }
        periodWhere.append(")");
        periodWhere.append(" and fSystemStatusId = (select fid from t_bd_systemstatus where fname = ").append(7).append(")");
        String from = " from t_cas_journalSummary t1 inner join (select t_bd_systemstatusctrol.fcompanyid,fcurrentPeriodID,t_bd_period.Fbegindate ,t_bd_period.fperiodyear,t_bd_period.fperiodnumber from t_bd_systemstatusctrol  inner join t_bd_period on fcurrentperiodId=t_bd_period.fid " + periodWhere + ") t2 on t1.fcompanyid=t2.fcompanyid and t1.fcreateDate>=t2.fbegindate left join t_bd_accountBanks t3 on t1.faccountbankid=t3.fid";
        String groupBy = " group by ";
        groupBy = groupBy + "fperiodyear ,fperiodnumber,fcurrencyid";
        groupBy = isByBank ? groupBy + "," + groupEntry + ",faccountviewid,faccountBankid, t1.fcompanyId " : groupBy + "," + groupEntry + ",faccountviewid,faccountBankid";
        StringBuffer where = new StringBuffer();
        where.append(" where t1.FcompanyId in ('").append(companyIds[0]).append("'");
        for (i = 1; i < companyIds.length; ++i) {
            where.append(",'").append(companyIds[i]).append("'");
        }
        where.append(")");
        where.append("and Fcurrencyid in ('").append(currencyIds[0]).append("'");
        for (i = 1; i < currencyIds.length; ++i) {
            where.append(",'").append(currencyIds[i]).append("'");
        }
        where.append(")");
        where.append("and( FBank in ('").append(bankIds[0]).append("'");
        for (i = 1; i < bankIds.length; ++i) {
            where.append(",'").append(bankIds[i]).append("'");
        }
        where.append(") or FBank is null)");
        where.append(" and fcreatedate < {").append(TypeConversionUtils.objToDate((Object)beginDate)).append("}");
        String sql = select + from + where + groupBy;
        return sql;
    }

    public String getSumSQL(boolean isByBank, String[] companyIds, String[] bankIds, String[] currencyIds, Date beginDate, Date endDate) {
        int i;
        String field = "";
        String groupEntry = "";
        if (isByBank) {
            field = ",fbank as bank";
            groupEntry = "fBank";
        } else {
            field = ",t1.fcompanyId company";
            groupEntry = "t1.fcompanyid";
        }
        String select = "select fperiodyear as \"year\",fperiodnumber as \"month\"";
        select = isByBank ? select + field + ",FAccountViewId as acct,fAccountBankId as acctBank,t1.fcompanyId company" : select + field + ",FAccountViewId as acct,fAccountBankId as acctBank";
        select = select + ",fcurrencyid as currency,sum(fdebitAmount) as debitAmount,sum(fcreditAmount) as creditAmount,sum(fdebitCount) debitCount,sum(fcreditCount) as creditCount";
        String from = " from t_cas_journalsummary t1 inner join t_bd_period t2 on t1.fperiodid=t2.fid left join t_bd_accountBanks t3 on t1.faccountbankid=t3.fid";
        String groupBy = " group by fperiodyear,fperiodnumber,";
        groupBy = isByBank ? groupBy + groupEntry + ",FAccountViewId,fAccountBankId,t1.fcompanyId ," : groupBy + groupEntry + ",FAccountViewId,fAccountBankId, ";
        groupBy = groupBy + "fcurrencyid";
        StringBuffer where = new StringBuffer();
        where.append(" where t1.FcompanyId in ('").append(companyIds[0]).append("'");
        for (i = 1; i < companyIds.length; ++i) {
            where.append(",'").append(companyIds[i]).append("'");
        }
        where.append(")");
        where.append("and Fcurrencyid in ('").append(currencyIds[0]).append("'");
        for (i = 1; i < currencyIds.length; ++i) {
            where.append(",'").append(currencyIds[i]).append("'");
        }
        where.append(")");
        where.append("and ( FBank in ('").append(bankIds[0]).append("'");
        for (i = 1; i < bankIds.length; ++i) {
            where.append(",'").append(bankIds[i]).append("'");
        }
        where.append(") or FBank is null ) ");
        where.append(" and FCreateDate >= {").append(TypeConversionUtils.objToDate((Object)beginDate)).append("}");
        where.append(" and FCreateDate <= {").append(TypeConversionUtils.objToDate((Object)endDate)).append("}");
        String sql = select + from + where + groupBy;
        return sql;
    }

    private void initColumn(KDTable tblMain, String[] currencyIds, boolean isByBank) {
        int i;
        tblMain.addColumn().setKey("period");
        if (isByBank) {
            tblMain.addColumn().setKey("bank");
            tblMain.addColumn().setKey("bankAccount");
            tblMain.addColumn().setKey("accountView");
            tblMain.addColumn().setKey("company");
        } else {
            tblMain.addColumn().setKey("company");
            tblMain.addColumn().setKey("bank");
            tblMain.addColumn().setKey("bankAccount");
            tblMain.addColumn().setKey("accountView");
        }
        tblMain.addColumn().setKey("currency");
        tblMain.addColumn().setKey("exchange");
        IColumn column = null;
        for (i = 0; i < currencyIds.length; ++i) {
            column = tblMain.addColumn();
            column.setKey("beginBalance_" + currencyIds[i]);
            this.setColumnFormat(column, currencyIds[i]);
            column = tblMain.addColumn();
            column.setKey("localBeginBalance_" + currencyIds[i]);
            this.setColumnFormat(column, currencyIds[i]);
        }
        for (i = 0; i < currencyIds.length; ++i) {
            column = tblMain.addColumn();
            column.setKey("debit_" + currencyIds[i]);
            this.setColumnFormat(column, currencyIds[i]);
            column = tblMain.addColumn();
            column.setKey("localDebit_" + currencyIds[i]);
            this.setColumnFormat(column, currencyIds[i]);
        }
        for (i = 0; i < currencyIds.length; ++i) {
            column = tblMain.addColumn();
            column.setKey("credit_" + currencyIds[i]);
            this.setColumnFormat(column, currencyIds[i]);
            column = tblMain.addColumn();
            column.setKey("localCredit_" + currencyIds[i]);
            this.setColumnFormat(column, currencyIds[i]);
        }
        tblMain.addColumn().setKey("dc");
        for (i = 0; i < currencyIds.length; ++i) {
            column = tblMain.addColumn();
            column.setKey("endBalance_" + currencyIds[i]);
            this.setColumnFormat(column, currencyIds[i]);
            column = tblMain.addColumn();
            column.setKey("localEndBalance_" + currencyIds[i]);
            this.setColumnFormat(column, currencyIds[i]);
        }
        tblMain.addColumn().setKey("debitCount");
        tblMain.addColumn().setKey("creditCount");
    }

    private void initHead(KDTable tblMain, String[] currencyIds) throws EASBizException, BOSException {
        IRow headRow = tblMain.addHeadRow();
        IRow headRow1 = tblMain.addHeadRow();
        headRow.getCell("company").setValue((Object)EASResource.getString((String)resourcePath, (String)"company"));
        headRow.getCell("bank").setValue((Object)EASResource.getString((String)resourcePath, (String)"bank"));
        headRow.getCell("bankAccount").setValue((Object)EASResource.getString((String)resourcePath, (String)"bankAccount"));
        headRow.getCell("accountView").setValue((Object)EASResource.getString((String)resourcePath, (String)"accountView"));
        headRow.getCell("period").setValue((Object)EASResource.getString((String)resourcePath, (String)"period"));
        headRow.getCell("currency").setValue((Object)EASResource.getString((String)resourcePath, (String)"currency"));
        headRow.getCell("exchange").setValue((Object)EASResource.getString((String)resourcePath, (String)"exchange"));
        headRow.getCell("dc").setValue((Object)EASResource.getString((String)resourcePath, (String)"dc"));
        headRow.getCell("debitCount").setValue((Object)EASResource.getString((String)resourcePath, (String)"debitCount"));
        headRow.getCell("creditCount").setValue((Object)EASResource.getString((String)resourcePath, (String)"creditCount"));
        headRow1.getCell("company").setValue((Object)EASResource.getString((String)resourcePath, (String)"company"));
        headRow1.getCell("bank").setValue((Object)EASResource.getString((String)resourcePath, (String)"bank"));
        headRow1.getCell("bankAccount").setValue((Object)EASResource.getString((String)resourcePath, (String)"bankAccount"));
        headRow1.getCell("accountView").setValue((Object)EASResource.getString((String)resourcePath, (String)"accountView"));
        headRow1.getCell("period").setValue((Object)EASResource.getString((String)resourcePath, (String)"period"));
        headRow1.getCell("currency").setValue((Object)EASResource.getString((String)resourcePath, (String)"currency"));
        headRow1.getCell("dc").setValue((Object)EASResource.getString((String)resourcePath, (String)"dc"));
        headRow1.getCell("debitCount").setValue((Object)EASResource.getString((String)resourcePath, (String)"debitCount"));
        headRow1.getCell("creditCount").setValue((Object)EASResource.getString((String)resourcePath, (String)"creditCount"));
        if (currencyIds.length == 1) {
            headRow.getCell("beginBalance_" + currencyIds[0]).setValue((Object)EASResource.getString((String)resourcePath, (String)"beginBalance"));
            headRow1.getCell("beginBalance_" + currencyIds[0]).setValue((Object)EASResource.getString((String)resourcePath, (String)"sourceCurrency"));
            headRow.getCell("localBeginBalance_" + currencyIds[0]).setValue((Object)EASResource.getString((String)resourcePath, (String)"beginBalance"));
            headRow1.getCell("localBeginBalance_" + currencyIds[0]).setValue((Object)EASResource.getString((String)resourcePath, (String)"baseCurrency"));
            headRow.getCell("debit_" + currencyIds[0]).setValue((Object)EASResource.getString((String)resourcePath, (String)"debit"));
            headRow1.getCell("debit_" + currencyIds[0]).setValue((Object)EASResource.getString((String)resourcePath, (String)"sourceCurrency"));
            headRow.getCell("localDebit_" + currencyIds[0]).setValue((Object)EASResource.getString((String)resourcePath, (String)"debit"));
            headRow1.getCell("localDebit_" + currencyIds[0]).setValue((Object)EASResource.getString((String)resourcePath, (String)"baseCurrency"));
            headRow.getCell("credit_" + currencyIds[0]).setValue((Object)EASResource.getString((String)resourcePath, (String)"credit"));
            headRow1.getCell("credit_" + currencyIds[0]).setValue((Object)EASResource.getString((String)resourcePath, (String)"sourceCurrency"));
            headRow.getCell("localCredit_" + currencyIds[0]).setValue((Object)EASResource.getString((String)resourcePath, (String)"credit"));
            headRow1.getCell("localCredit_" + currencyIds[0]).setValue((Object)EASResource.getString((String)resourcePath, (String)"baseCurrency"));
            headRow.getCell("endBalance_" + currencyIds[0]).setValue((Object)EASResource.getString((String)resourcePath, (String)"endBalance"));
            headRow1.getCell("endBalance_" + currencyIds[0]).setValue((Object)EASResource.getString((String)resourcePath, (String)"sourceCurrency"));
            headRow.getCell("localEndBalance_" + currencyIds[0]).setValue((Object)EASResource.getString((String)resourcePath, (String)"endBalance"));
            headRow1.getCell("localEndBalance_" + currencyIds[0]).setValue((Object)EASResource.getString((String)resourcePath, (String)"baseCurrency"));
        } else {
            CurrencyCollection currencys = CurrencyFactory.getRemoteInstance().getCurrencyCollection(true);
            XTable xCurrency = new XTable((IObjectCollection)currencys, new String[]{"id", "name"});
            for (int i = 0; i < currencyIds.length; ++i) {
                String currencyId = currencyIds[i];
                String currencyName = (String)xCurrency.getCell(currencyId, "name");
                headRow.getCell("beginBalance_" + currencyId).setValue((Object)EASResource.getString((String)resourcePath, (String)"beginBalance"));
                headRow.getCell("debit_" + currencyId).setValue((Object)EASResource.getString((String)resourcePath, (String)"debit"));
                headRow.getCell("credit_" + currencyId).setValue((Object)EASResource.getString((String)resourcePath, (String)"credit"));
                headRow.getCell("endBalance_" + currencyId).setValue((Object)EASResource.getString((String)resourcePath, (String)"endBalance"));
                headRow1.getCell("beginBalance_" + currencyIds[i]).setValue((Object)currencyName);
                headRow1.getCell("debit_" + currencyId).setValue((Object)currencyName);
                headRow1.getCell("credit_" + currencyId).setValue((Object)currencyName);
                headRow1.getCell("endBalance_" + currencyId).setValue((Object)currencyName);
            }
        }
    }

    public void initTable(KDTable tblMain, String[] currencyIds, boolean isByBank) throws EASBizException, BOSException {
        this.initColumn(tblMain, currencyIds, isByBank);
        this.initHead(tblMain, currencyIds);
        this.setHeadHide(tblMain, currencyIds);
        this.setHeadMerge(tblMain, currencyIds);
    }

    private void setColumnFormat(IColumn column, String currencyId) {
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
        column.getStyleAttributes().setNumberFormat(numberFtm);
        column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void setHeadHide(KDTable tblMain, String[] currencyIds) {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
            tblMain.getColumn("company").getStyleAttributes().setHided(true);
        }
        if (currencyIds.length == 1) {
            if (currencyIds[0].equals(company.getBaseCurrency().getId().toString())) {
                tblMain.getColumn("exchange").getStyleAttributes().setHided(true);
                tblMain.getColumn("localBeginBalance_" + currencyIds[0]).getStyleAttributes().setHided(true);
                tblMain.getColumn("localDebit_" + currencyIds[0]).getStyleAttributes().setHided(true);
                tblMain.getColumn("localCredit_" + currencyIds[0]).getStyleAttributes().setHided(true);
                tblMain.getColumn("localEndBalance_" + currencyIds[0]).getStyleAttributes().setHided(true);
                tblMain.getHeadRow(1).getStyleAttributes().setHided(true);
            }
        } else {
            tblMain.getColumn("exchange").getStyleAttributes().setHided(true);
            for (int i = 0; i < currencyIds.length; ++i) {
                tblMain.getColumn("localBeginBalance_" + currencyIds[i]).getStyleAttributes().setHided(true);
                tblMain.getColumn("localDebit_" + currencyIds[i]).getStyleAttributes().setHided(true);
                tblMain.getColumn("localCredit_" + currencyIds[i]).getStyleAttributes().setHided(true);
                tblMain.getColumn("localEndBalance_" + currencyIds[i]).getStyleAttributes().setHided(true);
                tblMain.getColumn("currency").getStyleAttributes().setHided(true);
            }
        }
    }

    private void setHeadMerge(KDTable tblMain, String[] currencyIds) {
        int i;
        int offset = tblMain.getColumnIndex("exchange");
        for (i = 0; i <= offset; ++i) {
            tblMain.getHeadMergeManager().mergeBlock(0, i, 1, i);
        }
        for (i = 0; i < currencyIds.length; ++i) {
            String currencyId = currencyIds[i];
            tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex("beginBalance_" + currencyId), 0, tblMain.getColumnIndex("beginBalance_" + currencyId) + currencyIds.length * 2 - 1);
            tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex("debit_" + currencyId), 0, tblMain.getColumnIndex("debit_" + currencyId) + currencyIds.length * 2 - 1);
            tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex("credit_" + currencyId), 0, tblMain.getColumnIndex("credit_" + currencyId) + currencyIds.length * 2 - 1);
            tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex("endBalance_" + currencyId), 0, tblMain.getColumnIndex("endBalance_" + currencyId) + currencyIds.length * 2 - 1);
        }
        tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex("dc"), 1, tblMain.getColumnIndex("dc"));
        tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex("debitCount"), 1, tblMain.getColumnIndex("debitCount"));
        tblMain.getHeadMergeManager().mergeBlock(0, tblMain.getColumnIndex("creditCount"), 1, tblMain.getColumnIndex("creditCount"));
    }

    public void setRowFormat(IRow row, String currencyId) {
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
        row.getCell("debit_" + currencyId).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell("credit_" + currencyId).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell("beginBalance_" + currencyId).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell("endBalance_" + currencyId).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell("debit_" + currencyId).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("credit_" + currencyId).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("beginBalance_" + currencyId).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("endBalance_" + currencyId).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("localDebit_" + currencyId).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell("localCredit_" + currencyId).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell("localBeginBalance_" + currencyId).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell("localEndBalance_" + currencyId).getStyleAttributes().setNumberFormat(numberFtm);
        row.getCell("localDebit_" + currencyId).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("localCredit_" + currencyId).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("localBeginBalance_" + currencyId).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        row.getCell("localEndBalance_" + currencyId).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }

    private void unionBalanceWithSession(XTable balanceTable, XTable sessionTable, int year, int month, boolean isUnion, boolean isBank) {
        int i;
        String[] rowKeys = sessionTable.getRowKeys();
        for (i = 0; i < sessionTable.getRowCount(); ++i) {
            Map sessionRow = sessionTable.getRow(i);
            if (sessionRow == null) {
                return;
            }
            String rowKey = rowKeys[i];
            String newKey = year + "" + month;
            if (!isUnion) {
                newKey = isBank ? newKey + sessionRow.get("bank") + sessionRow.get("acct") + sessionRow.get("acctbank") + sessionRow.get("company") : newKey + sessionRow.get("company") + sessionRow.get("acct") + sessionRow.get("acctbank") + sessionRow.get("company");
            }
            newKey = newKey + sessionRow.get("currency");
            Map rowOld = balanceTable.getRow(rowKey);
            BigDecimal amount = (BigDecimal)sessionRow.get("amount");
            Map rowNew = balanceTable.addRow(newKey);
            rowNew.put("currency", sessionRow.get("currency"));
            rowNew.put("year", new Integer(year));
            rowNew.put("month", new Integer(month));
            if (rowOld == null) {
                rowNew.put("beginbalance", amount);
                continue;
            }
            BigDecimal beginBalance = (BigDecimal)rowOld.get("beginbalance");
            rowNew.put("beginbalance", beginBalance.add(amount));
            rowOld.put("beginbalance", beginBalance.add(amount));
        }
        for (i = 0; i < balanceTable.getRowCount(); ++i) {
            Map row;
            Map balanceRow = balanceTable.getRow(i);
            String newKey = year + "" + month;
            if (!isUnion) {
                newKey = isBank ? newKey + balanceRow.get("bank") + balanceRow.get("acct") + balanceRow.get("acctbank") + balanceRow.get("company") : newKey + balanceRow.get("company") + balanceRow.get("acct") + balanceRow.get("acctbank") + balanceRow.get("company");
            }
            if (balanceTable.getRow(newKey = newKey + balanceRow.get("currency")) == null) {
                row = balanceTable.addRow(newKey);
                int yearNew = TypeConversionUtils.objToInt(balanceRow.get("year"));
                int monthNew = TypeConversionUtils.objToInt(balanceRow.get("month"));
                if (yearNew > year || yearNew == year && monthNew >= month) continue;
                row.put("beginbalance", balanceRow.get("beginbalance"));
                row.put("currency", balanceRow.get("currency"));
                row.put("year", balanceRow.get("year"));
                row.put("month", balanceRow.get("month"));
                if (isUnion) continue;
                if (isBank) {
                    row.put("bank", balanceRow.get("bank"));
                } else {
                    row.put("company", balanceRow.get("company"));
                }
                row.put("acct", balanceRow.get("acct"));
                row.put("acctbank", balanceRow.get("acctbank"));
                continue;
            }
            row = balanceTable.getRow(newKey);
            Object oYear = row.get("year");
            if (oYear == null) continue;
            int yearOld = TypeConversionUtils.objToInt(oYear);
            int monthOld = TypeConversionUtils.objToInt(row.get("month"));
            int yearNew = TypeConversionUtils.objToInt(balanceRow.get("year"));
            int monthNew = TypeConversionUtils.objToInt(balanceRow.get("month"));
            if (yearOld > year || yearOld == year && monthOld >= month || yearOld > yearNew || yearOld == yearNew && monthOld >= monthNew) continue;
            row.put("beginbalance", balanceRow.get("beginbalance"));
        }
    }
}

