/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.CellTreeNode;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CapitalVcSummaryFetchParamFacadeFactory;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.XTable;
import com.kingdee.eas.fi.cas.client.AbstractCapitalVcSummaryUI;
import com.kingdee.eas.fi.cas.client.BSReportHelper;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustEditUI;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustFilterParam;
import com.kingdee.eas.fi.cas.client.CapitalVcSummaryFilterParam;
import com.kingdee.eas.fi.cas.client.CapitalVcSummaryFilterUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.JournalReportHelper;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FilterParam;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.log4j.Logger;

public class CapitalVcSummaryUI
extends AbstractCapitalVcSummaryUI {
    private static final Logger logger = Logger.getLogger(CapitalVcSummaryUI.class);
    public static final String resourcePath = "com.kingdee.eas.fi.cas.CapitalVcSummaryResource";
    private CapitalVcSummaryFilterUI filterUI;
    private CapitalVcSummaryFilterParam para;
    private XTable journalTable;
    private XTable bsTable;
    private String[] amountColumns = new String[]{"journalBeginBalance", "journalDebitAmount", "journalCreditAmount", "journalEndBalance", "bsBeginBalance", "bsDebitAmount", "bsCreditAmount", "bsEndBalance", "diffBeginBalance", "diffDebitAmount", "diffCreditAmount", "diffEndBalance"};
    private boolean isCludeUnion = false;
    Map paramMap = new HashMap();

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected KDTable getMainTable() {
        return this.kdtVcDetails;
    }

    private void setColumnFormat(String currencyId) {
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)BOSUuid.read((String)currencyId));
        for (int i = 0; i < this.amountColumns.length; ++i) {
            String columnnKey = this.amountColumns[i];
            IColumn column = this.kdtVcDetails.getColumn(columnnKey);
            column.getStyleAttributes().setNumberFormat(numberFtm);
            column.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
    }

    private void setUnionData() {
        for (int i = 0; i < this.kdtVcDetails.getRowCount(); ++i) {
            IRow rowAfter;
            CellTreeNode nodeAfter;
            IRow row = this.kdtVcDetails.getRow(i);
            CellTreeNode node = (CellTreeNode)row.getCell("company").getValue();
            if (node == null || !node.isHasChildren()) continue;
            int level = node.getTreeLevel();
            ArrayList<IRow> rowList = new ArrayList<IRow>();
            for (int j = i + 1; j < this.kdtVcDetails.getRowCount() && (nodeAfter = (CellTreeNode)(rowAfter = this.kdtVcDetails.getRow(j)).getCell("company").getValue()) != null && nodeAfter.getTreeLevel() > level; ++j) {
                if (nodeAfter.isHasChildren() || !(nodeAfter.getValue() instanceof CompanyOrgUnitInfo)) continue;
                rowList.add(rowAfter);
            }
            for (int k = 0; k < this.amountColumns.length; ++k) {
                this.setRowDataSum(row, this.amountColumns[k], rowList);
            }
        }
    }

    private void setRowDataSum(IRow row, String colName, List rowList) {
        BigDecimal amount = FMConstants.ZERO;
        for (int i = 0; i < rowList.size(); ++i) {
            IRow rowAdd = (IRow)rowList.get(i);
            Object value = rowAdd.getCell(colName).getValue();
            if (value == null || !(value instanceof BigDecimal)) continue;
            amount = amount.add((BigDecimal)value);
        }
        row.getCell(colName).setValue((Object)amount);
    }

    public void setHeadMerge() {
        KDTMergeManager mergeManager = this.kdtVcDetails.getHeadMergeManager();
        mergeManager.mergeBlock(0, 0, 1, 0);
        mergeManager.mergeBlock(0, 1, 1, 1);
        mergeManager.mergeBlock(0, 2, 1, 2);
        mergeManager.mergeBlock(0, 3, 1, 3);
        mergeManager.mergeBlock(0, 4, 1, 4);
        mergeManager.mergeBlock(0, 5, 1, 5);
        mergeManager.mergeBlock(0, 6, 0, 9);
        mergeManager.mergeBlock(0, 10, 0, 13);
        mergeManager.mergeBlock(0, 14, 1, 14);
        mergeManager.mergeBlock(0, 15, 0, 18);
    }

    private void fillDataByUnit(CompanyOrgUnitInfo company, PeriodInfo period, int level) {
        IRow row = this.kdtVcDetails.addRow();
        row.setUserObject((Object)new Integer(level));
        CellTreeNode node = new CellTreeNode();
        node.setTreeLevel(level);
        node.setHasChildren(true);
        node.setValue((Object)company);
        row.getCell("period").setValue((Object)period);
        row.getCell("company").setValue((Object)node);
        row.getStyleAttributes().setBackground(ClientUtils.DAY_TOTAL_COLOR);
    }

    private void fillDataByCompanyTree(DefaultMutableTreeNode companyNode, PeriodInfo period, CurrencyInfo currency, int level) throws EASBizException, BOSException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)companyNode.getUserObject();
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company) || !company.isIsLeaf()) {
            this.isCludeUnion = true;
            this.fillDataByUnit(company, period, level);
            for (int i = 0; i < companyNode.getChildCount(); ++i) {
                DefaultMutableTreeNode childCompany = (DefaultMutableTreeNode)companyNode.getChildAt(i);
                this.fillDataByCompanyTree(childCompany, period, currency, level + 1);
            }
        } else if (this.isCludeUnion) {
            this.fillCompanyData(period, company, currency, level);
        } else {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)FMHelper.asSet((String[])this.para.getCompanyIds()), CompareType.INCLUDE));
            CompanyOrgUnitCollection colls = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            for (int i = 0; i < colls.size(); ++i) {
                this.fillCompanyData(period, colls.get(i), currency, level);
            }
        }
    }

    private void fillCompanyData(PeriodInfo period, CompanyOrgUnitInfo company, CurrencyInfo currency, int level) throws BOSException {
        AccountBankCollection accountBankCollection = this.getAccountBankCollection(new String[]{company.getId().toString()}, this.aBankids(), false);
        accountBankCollection = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankCollection)accountBankCollection, null, (String)this.para.getActualAcctTableId());
        int size = accountBankCollection.size();
        for (int j = 0; j < size; ++j) {
            AccountBankInfo accountBank = accountBankCollection.get(j);
            String rowKey = period.getId().toString() + company.getId().toString() + accountBank.getBank().getId().toString() + currency.getId().toString() + accountBank.getId().toString();
            IRow row = this.kdtVcDetails.addRow();
            row.setUserObject((Object)new Integer(level));
            CellTreeNode node = new CellTreeNode();
            node.setTreeLevel(level);
            node.setValue((Object)company);
            row.getCell("company").setUserObject((Object)company);
            row.getCell("company").setValue((Object)node);
            row.getCell("period").setValue((Object)period);
            row.getCell("bank").setValue((Object)accountBank.getBank());
            row.getCell("accountBank").setValue((Object)accountBank);
            row.getCell("accNumber").setValue((Object)accountBank.getBankAccountNumber());
            row.getCell("accountView").setValue((Object)accountBank.getAccount());
            Map jRow = this.journalTable.getRow(rowKey);
            BigDecimal jBeginBalance = (BigDecimal)jRow.get("balance");
            BigDecimal jDebitAmount = (BigDecimal)jRow.get("debitAmount");
            BigDecimal jCreditAmount = (BigDecimal)jRow.get("creditAmount");
            BigDecimal jEndBalance = jBeginBalance.add(jDebitAmount).subtract(jCreditAmount);
            Map bsRow = this.bsTable.getRow(rowKey);
            BigDecimal bsBeginBalance = (BigDecimal)bsRow.get("balance");
            BigDecimal bsDebitAmount = (BigDecimal)bsRow.get("debitAmount");
            BigDecimal bsCreditAmount = (BigDecimal)bsRow.get("creditAmount");
            BigDecimal bsEndBalance = bsBeginBalance.add(bsCreditAmount).subtract(bsDebitAmount);
            BigDecimal diffBeginBalance = jBeginBalance.subtract(bsBeginBalance);
            BigDecimal diffDebitAmount = jDebitAmount.subtract(bsCreditAmount);
            BigDecimal diffCreditAmount = jCreditAmount.subtract(bsDebitAmount);
            BigDecimal diffEndBalance = jEndBalance.subtract(bsEndBalance);
            row.getCell("journalBeginBalance").setValue((Object)jBeginBalance);
            row.getCell("journalDebitAmount").setValue((Object)jDebitAmount);
            row.getCell("journalCreditAmount").setValue((Object)jCreditAmount);
            row.getCell("journalEndBalance").setValue((Object)jEndBalance);
            row.getCell("bsBeginBalance").setValue((Object)bsBeginBalance);
            row.getCell("bsDebitAmount").setValue((Object)bsDebitAmount);
            row.getCell("bsCreditAmount").setValue((Object)bsCreditAmount);
            row.getCell("bsEndBalance").setValue((Object)bsEndBalance);
            if (diffBeginBalance.compareTo(FMConstants.ZERO) == 0 && diffDebitAmount.compareTo(FMConstants.ZERO) == 0 && diffCreditAmount.compareTo(FMConstants.ZERO) == 0 && diffEndBalance.compareTo(FMConstants.ZERO) == 0) {
                row.getCell("vcResult").setValue((Object)EASResource.getString((String)resourcePath, (String)"ping"));
            } else {
                row.getCell("vcResult").setValue((Object)EASResource.getString((String)resourcePath, (String)"buping"));
            }
            row.getCell("diffBeginBalance").setValue((Object)diffBeginBalance);
            row.getCell("diffDebitAmount").setValue((Object)diffDebitAmount);
            row.getCell("diffCreditAmount").setValue((Object)diffCreditAmount);
            row.getCell("diffEndBalance").setValue((Object)diffEndBalance);
        }
    }

    private AccountBankCollection getAccountBankCollection(String[] companyIds, String[] bankIds, boolean isIncludeClosed) throws BOSException {
        Set bankSet = null;
        bankSet = FMHelper.asSet((String[])bankIds);
        HashSet<String> companySet = new HashSet<String>();
        for (int i = 0; i < companyIds.length; ++i) {
            companySet.add(companyIds[i]);
        }
        EntityViewInfo evi = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("bankAccountNumber");
        selector.add("name");
        selector.add("account.id");
        selector.add("account.number");
        selector.add("account.name");
        selector.add("bank.id");
        selector.add("bank.name");
        selector.add("company.name");
        selector.add("company.number");
        FilterInfo fi = new FilterInfo();
        if (companySet != null && companySet.size() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("company.id", companySet, CompareType.INCLUDE));
        }
        if (bankSet != null && bankSet.size() > 0) {
            fi.getFilterItems().add(new FilterItemInfo("bank.id", (Object)bankSet, CompareType.INCLUDE));
        }
        if (!isIncludeClosed) {
            fi.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Integer(0)));
        }
        evi.setFilter(fi);
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.getSorter().add(new SorterItemInfo("company"));
        evi.getSorter().add(new SorterItemInfo("bank.name"));
        evi.getSorter().add(new SorterItemInfo("name"));
        AccountBankCollection acctBankCol = AccountBankFactory.getRemoteInstance().getAccountBankCollection(evi);
        return acctBankCol;
    }

    private String[] aBankids() {
        return this.para.getActualBankIds();
    }

    private void setSumCell(KDTable table, ICell cell, int sumCount) {
        int x = cell.getRowIndex();
        int y = cell.getColumnIndex();
        BigDecimal sum = FMConstants.ZERO;
        for (int i = x - sumCount; i < x; ++i) {
            ICell acuCell = table.getCell(i, y);
            if (acuCell.getValue() instanceof BigDecimal) {
                sum = sum.add((BigDecimal)acuCell.getValue());
                continue;
            }
            if (!(acuCell.getValue() instanceof Integer)) continue;
            sum = sum.add(new BigDecimal(((Integer)acuCell.getValue()).toString()));
        }
        cell.setValue((Object)sum);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CapitalVcSummaryFilterUI(this.paramMap);
        }
        return this.filterUI;
    }

    private void initTreeCollapse() {
        this.kdtVcDetails.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                if (e.getClickCount() == 1) {
                    if (e.getColIndex() < 0 || !CapitalVcSummaryUI.this.kdtVcDetails.getColumnKey(e.getColIndex()).equals("company")) {
                        return;
                    }
                    IRow row = CapitalVcSummaryUI.this.kdtVcDetails.getRow(e.getRowIndex());
                    CapitalVcSummaryUI.this.changeRowExpandState(row);
                }
            }
        });
    }

    private void changeRowExpandState(IRow row) {
        ICell cell = row.getCell("company");
        Object oTreeNode = cell.getValue();
        if (oTreeNode instanceof CellTreeNode) {
            CellTreeNode treeNode = (CellTreeNode)oTreeNode;
            for (int i = row.getRowIndex() + 1; i < this.kdtVcDetails.getRowCount(); ++i) {
                IRow row2 = this.kdtVcDetails.getRow(i);
                Object oTreeNode2 = row2.getCell("company").getValue();
                if (oTreeNode2 instanceof CellTreeNode) {
                    CellTreeNode treeNode2 = (CellTreeNode)oTreeNode2;
                    if (treeNode2.getTreeLevel() <= treeNode.getTreeLevel()) break;
                    row2.getStyleAttributes().setHided(!treeNode.isCollapse());
                    treeNode2.setCollapse(!treeNode.isCollapse());
                    continue;
                }
                row2.getStyleAttributes().setHided(!treeNode.isCollapse());
            }
            treeNode.setCollapse(!treeNode.isCollapse());
        }
    }

    public void onLoad() throws Exception {
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
            FMClientHelper.checkPeriod((CoreUI)this);
        }
        this.kdtVcDetails.checkParsed();
        this.fecthValueToMap();
        if (!GlUtils.isCompanyUnion((CompanyOrgUnitInfo)companyInfo)) {
            boolean flag = false;
            flag = this.paramMap.get("isStart") == null ? SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo) : (Boolean)this.paramMap.get("isStart");
            if (!flag) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CompanyNoStart"));
                SysUtil.abort();
            }
            this.kdtVcDetails.getColumn("company").getStyleAttributes().setHided(true);
        }
        this.setSysStatusBarTitle();
        super.onLoad();
        this.initTreeCollapse();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    private void setSysStatusBarTitle() {
        PeriodInfo curP = (PeriodInfo)this.paramMap.get("currentPeriod");
        this.sysStatusBarTitle = curP == null ? "DeFault" : MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"128_BankJournalListUI"), curP.getPeriodYear(), curP.getPeriodNumber());
    }

    private void fecthValueToMap() throws BOSException, EASBizException {
        this.paramMap.put("accountTable", null);
        this.paramMap.put("periodType", null);
        this.paramMap.put("accountTableCol", null);
        this.paramMap.put("periondCol", null);
        this.paramMap.put("currencyCollection", null);
        this.paramMap.put("periodCollection", null);
        this.paramMap.put("isStart", null);
        this.paramMap.put("currentPeriod", null);
        this.paramMap = CapitalVcSummaryFetchParamFacadeFactory.getRemoteInstance().fetchDataBatchForFilterUI(this.paramMap);
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        IRow row;
        CompanyOrgUnitInfo company;
        int activeRowIndex = this.kdtVcDetails.getSelectManager().getActiveRowIndex();
        if (activeRowIndex == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if ((company = (CompanyOrgUnitInfo)(row = this.kdtVcDetails.getRow(activeRowIndex)).getCell("company").getUserObject()) == null || GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
            return;
        }
        CurrencyInfo currency = (CurrencyInfo)this.txtCurrency.getUserObject();
        PeriodInfo period = (PeriodInfo)row.getCell("period").getValue();
        AccountBankInfo accountBank = (AccountBankInfo)row.getCell("accountBank").getValue();
        accountBank = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accountBank.getId().toString()));
        if (!CashHelper.isShareBalanceOfAcctCompany(null, accountBank, accountBank.getCompany().getId().toString())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"437_CapitalVcSummaryUI"));
            SysUtil.abort();
        } else {
            accountBank = CashHelper.getShareBalanceOfAcct(null, accountBank, accountBank.getCompany().getId().toString());
        }
        BankBalanceAdjustFilterParam param = new BankBalanceAdjustFilterParam();
        param.setForInit(false);
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(accountBank.getCompany().getId().toString());
        param.setCompanys(idSet);
        param.setCurrencyId(currency.getId().toString());
        param.setPeriodYear(new Integer(period.getPeriodYear()));
        param.setPeriodNum(new Integer(period.getPeriodNumber()));
        HashSet<String> bankIdSet = new HashSet<String>();
        bankIdSet.add(accountBank.getId().toString());
        param.setBankAcctIds(bankIdSet);
        param.setBankAccts(new Object[]{accountBank});
        String acctTableId = FMClientHelper.getActualAcctTable((String)accountBank.getCompany().getId().toString(), (int)period.getPeriodYear(), (int)period.getPeriodNumber(), (int)period.getPeriodYear(), (int)period.getPeriodNumber());
        param.setPeriodId(period.getId().toString());
        BankBalanceAdjustEditUI.showDialogUI((IUIObject)this, param);
        super.actionViewDetail_actionPerformed(e);
    }

    protected void initWorkButton() {
        this.btnViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_sequencecheck"));
        super.initWorkButton();
    }

    public FilterParam getDefalutQueryParam() {
        return super.getDefalutQueryParam();
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        String currencyString = this.contCurrency.getBoundLabelText() + "\uff1a&[Currency]";
        String headString = this.contPeriod.getBoundLabelText() + ":&[PeriodRange]&|" + currencyString;
        StyleAttributes sb = Styles.getDefaultSA();
        headerModel.addRow(headString, sb);
        super.preparePrintPageHeader(headerModel);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        map.put("Currency", this.txtCurrency.getText());
        map.put("PeriodRange", this.txtPeriod.getText());
        return map;
    }

    protected void execQuery() throws BOSException {
        this.kdtVcDetails.removeRows();
        this.kdtVcDetails.checkParsed();
        this.setHeadMerge();
        this.kdtVcDetails.getStyleAttributes().setLocked(true);
        this.kdtVcDetails.getSelectManager().setSelectMode(10);
        this.para = (CapitalVcSummaryFilterParam)this.getFilterParam();
        this.setColumnFormat(this.para.getCurrencyId());
        this.kdtVcDetails.getViewManager().setFreezeView(0, 4);
        PeriodCollection periodCol = this.para.getPeriodColNew();
        Map paramMap = new HashMap<String, Object>();
        paramMap.put("currencyID", this.para.getCurrencyId());
        paramMap.put("companyIdsArray", this.para.getCompanyIds());
        paramMap.put("bankIdsIdsArray", this.para.getBankIds());
        paramMap.put("periodCol", periodCol);
        paramMap.put("beginYear", new Integer(this.para.getBeginYear()));
        paramMap.put("beginPeriod", new Integer(this.para.getBeginPeriod()));
        paramMap.put("endYear", new Integer(this.para.getEndYear()));
        paramMap.put("endPeriod", new Integer(this.para.getEndPeriod()));
        paramMap.put("currency", null);
        paramMap.put("journalTable", null);
        paramMap.put("bsTable", null);
        paramMap.put("actualAcctTableId", null);
        try {
            paramMap = CapitalVcSummaryFetchParamFacadeFactory.getRemoteInstance().fetchDataBatchForMainUI(paramMap);
        }
        catch (EASBizException e1) {
            MsgBox.showWarning((String)e1.getMessage());
            SysUtil.abort((Throwable)e1);
        }
        try {
            CurrencyInfo currency = null;
            currency = paramMap.get("currency") == null ? CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.para.getCurrencyId()))) : (CurrencyInfo)paramMap.get("currency");
            Object[] args = new String[]{String.valueOf(periodCol.get(0).getPeriodYear()), String.valueOf(periodCol.get(0).getPeriodNumber()), String.valueOf(periodCol.get(periodCol.size() - 1).getPeriodYear()), String.valueOf(periodCol.get(periodCol.size() - 1).getPeriodNumber())};
            String result = MessageFormat.format(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_PeriodRange"), args);
            this.txtPeriod.setText(result);
            this.txtCurrency.setText(currency.getName());
            this.txtCurrency.setUserObject((Object)currency);
            this.journalTable = paramMap.get("journalTable") == null ? JournalReportHelper.createJournalDataTable(periodCol, this.para.getCompanyIds(), this.para.getBankIds(), currency) : (XTable)paramMap.get("journalTable");
            this.bsTable = paramMap.get("bsTable") == null ? BSReportHelper.createBSDataTable(periodCol, this.para.getCompanyIds(), this.para.getBankIds(), currency) : (XTable)paramMap.get("bsTable");
            for (int i = 0; i < periodCol.size(); ++i) {
                this.fillDataByCompanyTree((DefaultMutableTreeNode)this.para.getCompanyTree().getRoot(), periodCol.get(i), currency, 0);
            }
            this.isCludeUnion = false;
            this.setUnionData();
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        this.kdtVcDetails.getColumn(0).setWidth(50);
        if (FMHelper.isEmpty((String)this.para.getActualAcctTableId())) {
            String actualAcctTableId = null;
            if (paramMap.get("bsTable") == null) {
                int len = this.para.getCompanyIds().length;
                for (int i = 0; i < len; ++i) {
                    String companyId = this.para.getCompanyIds()[i];
                    actualAcctTableId = FMClientHelper.getActualAcctTable((String)companyId, (int)this.para.getBeginYear(), (int)this.para.getBeginPeriod(), (int)this.para.getEndYear(), (int)this.para.getEndPeriod());
                }
            } else {
                actualAcctTableId = (String)paramMap.get("actualAcctTableId");
            }
            this.para.setAcctTableId(actualAcctTableId);
        }
        this.filterNoDataAct();
    }

    private void filterNoDataAct() {
        this.para = (CapitalVcSummaryFilterParam)this.getFilterParam();
        String vcResult = null;
        IRow row = null;
        if (this.para.isHideNoDataAct()) {
            int sum = this.kdtVcDetails.getRowCount();
            ArrayList<Integer> deleteRowIndexs = new ArrayList<Integer>();
            for (int i = 0; i < this.kdtVcDetails.getRowCount(); ++i) {
                row = this.kdtVcDetails.getRow(i);
                BigDecimal journalBeginBalance = new BigDecimal(row.getCell("journalBeginBalance").getValue().toString());
                BigDecimal journalDebitAmount = new BigDecimal(row.getCell("journalDebitAmount").getValue().toString());
                BigDecimal journalCreditAmount = new BigDecimal(row.getCell("journalCreditAmount").getValue().toString());
                BigDecimal journalEndBalance = new BigDecimal(row.getCell("journalEndBalance").getValue().toString());
                BigDecimal bsBeginBalance = new BigDecimal(row.getCell("bsBeginBalance").getValue().toString());
                BigDecimal bsCreditAmount = new BigDecimal(row.getCell("bsCreditAmount").getValue().toString());
                BigDecimal bsDebitAmount = new BigDecimal(row.getCell("bsDebitAmount").getValue().toString());
                BigDecimal bsEndBalance = new BigDecimal(row.getCell("bsEndBalance").getValue().toString());
                if (row.getCell("vcResult").getValue() == null) continue;
                vcResult = row.getCell("vcResult").getValue().toString();
                BigDecimal diffBeginBalance = new BigDecimal(row.getCell("diffBeginBalance").getValue().toString());
                BigDecimal diffDebitAmount = new BigDecimal(row.getCell("diffDebitAmount").getValue().toString());
                BigDecimal diffCreditAmount = new BigDecimal(row.getCell("diffCreditAmount").getValue().toString());
                BigDecimal diffEndBalance = new BigDecimal(row.getCell("diffEndBalance").getValue().toString());
                if (journalBeginBalance.compareTo(FMConstants.ZERO) != 0 || journalDebitAmount.compareTo(FMConstants.ZERO) != 0 || journalCreditAmount.compareTo(FMConstants.ZERO) != 0 || journalEndBalance.compareTo(FMConstants.ZERO) != 0 || bsBeginBalance.compareTo(FMConstants.ZERO) != 0 || bsCreditAmount.compareTo(FMConstants.ZERO) != 0 || bsDebitAmount.compareTo(FMConstants.ZERO) != 0 || bsEndBalance.compareTo(FMConstants.ZERO) != 0 || !vcResult.equals(EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"275_CapitalVcSummaryUI")) || diffBeginBalance.compareTo(FMConstants.ZERO) != 0 || diffDebitAmount.compareTo(FMConstants.ZERO) != 0 || diffCreditAmount.compareTo(FMConstants.ZERO) != 0 || diffEndBalance.compareTo(FMConstants.ZERO) != 0) continue;
                deleteRowIndexs.add(new Integer(i));
            }
            int num = 0;
            int size = deleteRowIndexs.size();
            for (int j = 0; j < size; ++j) {
                int current = this.kdtVcDetails.getRowCount();
                if (current < sum) {
                    this.kdtVcDetails.removeRow((Integer)deleteRowIndexs.get(j) - ++num);
                    continue;
                }
                this.kdtVcDetails.removeRow(((Integer)deleteRowIndexs.get(j)).intValue());
            }
        }
    }
}

