/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.PermissionUtils;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.BalanceModifyFacadeFactory;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.IBalanceModifyFacade;
import com.kingdee.eas.fi.cas.client.AbstractCasBalanceModifyUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Date;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class CasBalanceModifyUI
extends AbstractCasBalanceModifyUI {
    private static final Logger logger = CoreUIObject.getLogger(CasBalanceModifyUI.class);
    CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    PeriodInfo periodStart = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company);
    PeriodInfo periodCurrent = CashClientHelper.getCurrentPeriod(this.company);
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CasResources";

    private boolean isLogin() throws Exception {
        JPasswordField pwd = new JPasswordField();
        Object[] message = new Object[]{EASResource.getString((String)resourcePath, (String)"CasBalanceModifyUI_1"), pwd};
        int res = JOptionPane.showConfirmDialog((Component)((Object)this), message, " ", 2, 3);
        if (res != 0) {
            return false;
        }
        String logonPd = new String(pwd.getPassword());
        if (!(logonPd = logonPd.trim()).endsWith("_cash")) {
            return false;
        }
        int index = logonPd.lastIndexOf("_cash");
        String fillUserPd = logonPd.substring(0, index);
        UserInfo userInfo = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        return this.matchPassword(userInfo, fillUserPd);
    }

    public boolean matchPassword(UserInfo userInfo, String password) throws EASBizException {
        if (StringUtils.isEmpty((String)password)) {
            return StringUtils.isEmpty((String)userInfo.getPassword());
        }
        return PermissionUtils.matchPassword((UserInfo)userInfo, (String)password);
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (!this.isLogin()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CasBalanceModifyUI_8"));
            SysUtil.abort();
        }
        this.initData();
        this.initMyIcon();
    }

    private void initData() throws Exception {
        this.txtCompany.setText(this.company.getName());
        CashHelper.initCombCurrency(this.comboCurrency, false);
    }

    private void initMyIcon() throws Exception {
        this.modifyBankJournal.setSelected(true);
        this.modifyCashJournal.setSelected(false);
        this.txtCompany.setEnabled(false);
        this.comboCurrency.setEnabled(false);
        this.comboAccount.setEnabled(false);
        this.prmtPeriodFrom.setQueryInfo("com.kingdee.eas.basedata.assistant.app.PeriodQuery");
        this.prmtPeriodTo.setQueryInfo("com.kingdee.eas.basedata.assistant.app.PeriodQuery");
        this.fillComboAccount();
        this.setBankAccountFilter();
        this.setPeriodFilter();
        this.btnOk.setEnabled(true);
    }

    private void fillComboAccount() throws BOSException, EASBizException {
        String accountTabledId = this.company.getAccountTable().getId().toString();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)new Boolean(true)));
        filter.getFilterItems().add(new FilterItemInfo("isCash", (Object)new Boolean(true)));
        view.setFilter(filter);
        AccountViewCollection accountColl = FMHelper.getAccountViewCollection(null, (String)this.company.getId().toString(), (String)accountTabledId, null, (EntityViewInfo)view);
        this.comboAccount.addItems(accountColl.toArray());
        this.comboAccount.setSelectedIndex(-1);
    }

    private void setBankAccountFilter() {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)this.company.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("isClosed", (Object)new Boolean(false)));
        view.setFilter(filter);
        this.prmtBankAccount.setEntityViewInfo(view);
    }

    private void setPeriodFilter() {
        Integer fp = this.convertPeriodToInteger(this.periodStart);
        Integer tp = this.convertPeriodToInteger(this.periodCurrent);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType.id", (Object)this.company.getAccountPeriodType().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)fp, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)tp, CompareType.LESS));
        view.setFilter(filter);
        this.prmtPeriodFrom.setEntityViewInfo(view);
        this.prmtPeriodTo.setEntityViewInfo(view);
    }

    @Override
    protected void modifyBankJournal_stateChanged(ChangeEvent e) throws Exception {
        super.modifyBankJournal_stateChanged(e);
        if (this.modifyBankJournal.isSelected()) {
            this.modifyCashJournal.setSelected(false);
            this.prmtBankAccount.setEnabled(true);
            this.comboCurrency.setEnabled(false);
            this.comboAccount.setEnabled(false);
            this.comboCurrency.setSelectedIndex(-1);
            this.comboAccount.setSelectedIndex(-1);
        }
    }

    @Override
    protected void modifyCashJournal_stateChanged(ChangeEvent e) throws Exception {
        super.modifyCashJournal_stateChanged(e);
        if (this.modifyCashJournal.isSelected()) {
            this.modifyCashJournal.setSelected(true);
            this.comboCurrency.setEnabled(true);
            this.comboAccount.setEnabled(true);
            this.prmtBankAccount.setEnabled(false);
            this.prmtBankAccount.setValue(null);
        }
    }

    @Override
    protected void prmtBankAccount_dataChanged(DataChangeEvent e) throws Exception {
        CurrencyInfo currency = null;
        AccountViewInfo account = null;
        if (e.getNewValue() == null) {
            this.prmtAccount.setValue(null);
            this.comboCurrency.setSelectedIndex(-1);
            this.comboCurrency.setEnabled(false);
        } else {
            AccountBankInfo accountBank = (AccountBankInfo)this.prmtBankAccount.getValue();
            if (accountBank.isIsByCurrency()) {
                this.comboCurrency.setEnabled(false);
                currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(accountBank.getCurrency().getId().toString()));
                this.comboCurrency.setSelectedItem((Object)currency);
            } else {
                currency = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(this.company.getBaseCurrency().getId().toString()));
                this.comboCurrency.setSelectedItem((Object)currency);
                this.comboCurrency.setEnabled(true);
            }
            account = AccountViewFactory.getRemoteInstance().getAccountViewInfo((IObjectPK)new ObjectUuidPK(accountBank.getAccount().getId().toString()));
            this.prmtAccount.setValue((Object)account);
        }
    }

    public void verify() {
        boolean flag;
        PeriodInfo periodFrom = (PeriodInfo)this.prmtPeriodFrom.getValue();
        PeriodInfo periodTo = (PeriodInfo)this.prmtPeriodTo.getValue();
        if (periodFrom == null || periodTo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CasBalanceModifyUI_2"));
            SysUtil.abort();
        }
        boolean isFromToPeriodRight = PeriodUtils.PeriodCompare((PeriodInfo)periodTo, (PeriodInfo)periodFrom);
        boolean isFromPeriodAfterStart = PeriodUtils.PeriodCompare((PeriodInfo)periodFrom, (PeriodInfo)this.periodStart);
        boolean isToPeriodBeforeCurrent = PeriodUtils.PeriodCompare((PeriodInfo)this.periodCurrent, (PeriodInfo)periodTo);
        boolean bl = flag = isFromToPeriodRight && isFromPeriodAfterStart && isToPeriodBeforeCurrent;
        if (this.modifyBankJournal.isSelected() && this.prmtBankAccount.getValue() == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CasBalanceModifyUI_5"));
            SysUtil.abort();
        }
        if (this.modifyCashJournal.isSelected() && (this.comboAccount.getSelectedItem() == null || this.comboCurrency.getSelectedItem() == null)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CasBalanceModifyUI_6"));
            SysUtil.abort();
        }
        if (!flag) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CasBalanceModifyUI_7"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionStart_actionPerformed(ActionEvent e) throws Exception {
        super.actionStart_actionPerformed(e);
        this.verify();
        Date now = new Date();
        Date invalidDate = this.company.getInvalidDate();
        if (invalidDate != null && !invalidDate.after(now)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CasBalanceModifyUI_4"));
            return;
        }
        AccountBankInfo accountBank = (AccountBankInfo)this.prmtBankAccount.getValue();
        AccountViewInfo account = null;
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        PeriodInfo periodFrom = (PeriodInfo)this.prmtPeriodFrom.getValue();
        PeriodInfo periodTo = (PeriodInfo)this.prmtPeriodTo.getValue();
        boolean flag = false;
        if (this.modifyBankJournal.isSelected()) {
            flag = true;
            account = (AccountViewInfo)this.prmtAccount.getValue();
        } else {
            account = (AccountViewInfo)this.comboAccount.getSelectedItem();
        }
        this.reCalculate(currency, account, accountBank, periodFrom, periodTo, flag);
    }

    private void reCalculate(CurrencyInfo currency, AccountViewInfo account, AccountBankInfo accountBank, PeriodInfo periodFrom, PeriodInfo periodTo, boolean flag) throws Exception {
        PeriodInfo periodStart = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company);
        String companyId = this.company.getId().toString();
        IBalanceModifyFacade balanceModify = BalanceModifyFacadeFactory.getRemoteInstance();
        balanceModify.reCalculate(companyId, currency, account, accountBank, periodFrom, periodTo, flag, periodStart);
        this.disposeUIWindow();
        MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CasBalanceModifyUI_9"));
    }

    private Integer convertPeriodToInteger(PeriodInfo period) {
        String str = "";
        if (period.getPeriodNumber() < 10) {
            String strPeriodNum = "0" + period.getPeriodNumber();
            str = String.valueOf(period.getPeriodYear()) + strPeriodNum;
        } else {
            str = String.valueOf(period.getPeriodYear()) + String.valueOf(period.getPeriodNumber());
        }
        Integer i = Integer.valueOf(str);
        return i;
    }
}

