/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CapitalTypeEnum;
import com.kingdee.eas.fi.cas.CasContrastGLHelper;
import com.kingdee.eas.fi.cas.CasContrastGLInfo;
import com.kingdee.eas.fi.cas.CashBankContrastGLFactory;
import com.kingdee.eas.fi.cas.ICashBankContrastGL;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.util.client.EASResource;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

public class CasContrastGLHandler {
    public static final String resourcePath = "com.kingdee.eas.fi.cas.CashContrastGLResource";
    public static final BigDecimal ZERO = FMConstants.ZERO;
    public final String bankStatBal = EASResource.getString((String)"com.kingdee.eas.fi.cas.CashContrastGLResource", (String)"bankStatBal");
    public final String cashCheckBal = EASResource.getString((String)"com.kingdee.eas.fi.cas.CashContrastGLResource", (String)"cashCheckBal");
    private final String[] dateItemsName = new String[]{CasContrastGLHelper.DATEBEGINBAL, CasContrastGLHelper.DATEDEBITAMT, CasContrastGLHelper.DATECREDITAMT, CasContrastGLHelper.DATEENDBAL};
    private final String[] periodItemsName = new String[]{CasContrastGLHelper.PERIODBEGINBAL, CasContrastGLHelper.PERIODDEBITAMT, CasContrastGLHelper.PERIODCREDITAMT, CasContrastGLHelper.PERIODENDBAL};
    private final String[] yearItemsName = new String[]{CasContrastGLHelper.YEARBEGINBAL, CasContrastGLHelper.YEARDEBITAMT, CasContrastGLHelper.YEARCREDITAMT, CasContrastGLHelper.YEARDENDBAL};
    private final String[] rowKeys = new String[]{"beginBalance", "debitAmount", "creditAmount", "endBalance"};
    private final String[] columnKeys = new String[]{"cashMgmt", "glMgmt", "diffAmt", "bankStatBal"};
    private final String[] keys = new String[]{"byCAS", "byGL", "byDiff", "byBal"};

    CasContrastGLHandler() {
    }

    public static CasContrastGLHandler getInstance(CapitalTypeEnum type) {
        return null;
    }

    protected void initTable(KDTable table, CapitalTypeEnum capitalType) {
        IRow headRow = table.getHeadRow(0);
        if (capitalType == null) {
            return;
        }
        if (capitalType.equals((Object)CapitalTypeEnum.BANK)) {
            headRow.getCell("bankStatBal").setValue((Object)this.bankStatBal);
        } else if (capitalType.equals((Object)CapitalTypeEnum.CASH)) {
            headRow.getCell("bankStatBal").setValue((Object)this.cashCheckBal);
        }
    }

    protected void loadField(KDTable table, int itemType, CompanyOrgUnitInfo company, CurrencyInfo currencyInfo, CapitalTypeEnum capitalType, String accountNum, String bankAcctNum, Date beginDate, Date endDate, PeriodInfo period, boolean unTranVoucher) throws EASBizException, BOSException {
        table.checkParsed();
        table.removeRows();
        if (capitalType == null) {
            return;
        }
        String[] items = null;
        if (itemType == 3) {
            items = this.dateItemsName;
        } else if (itemType == 4) {
            items = this.periodItemsName;
        } else if (itemType == 5) {
            items = this.yearItemsName;
        }
        ICashBankContrastGL iCashGL = CashBankContrastGLFactory.getRemoteInstance();
        if (capitalType.equals((Object)CapitalTypeEnum.CASH)) {
            bankAcctNum = null;
        }
        Map hashMap = iCashGL.getAllBankAcctCasContrastGLData(capitalType, accountNum, bankAcctNum, currencyInfo.getNumber(), beginDate, endDate, period, unTranVoucher, company.getId().toString());
        String numberFmt = "00.00";
        numberFmt = FMClientHelper.getNumberFtm((BOSUuid)currencyInfo.getId());
        table.getColumn("cashMgmt").getStyleAttributes().setNumberFormat(numberFmt);
        table.getColumn("glMgmt").getStyleAttributes().setNumberFormat(numberFmt);
        table.getColumn("diffAmt").getStyleAttributes().setNumberFormat(numberFmt);
        table.getColumn("bankStatBal").getStyleAttributes().setNumberFormat(numberFmt);
        table.getColumn("cashMgmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("glMgmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("diffAmt").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        table.getColumn("bankStatBal").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        if (hashMap.size() > 0) {
            for (int i = 0; i < 4; ++i) {
                IRow row = table.addRow();
                row.getCell("item").setValue((Object)items[i]);
                for (int j = 0; j < 4; ++j) {
                    CasContrastGLInfo casContrastGLInfo = (CasContrastGLInfo)((Object)hashMap.get(this.keys[j]));
                    if (casContrastGLInfo == null) continue;
                    BigDecimal amount = casContrastGLInfo.getBigDecimal(this.rowKeys[i]);
                    if (amount != null) {
                        row.getCell(this.columnKeys[j]).setValue((Object)this.getBigDecimal(amount));
                        continue;
                    }
                    row.getCell(this.columnKeys[j]).setValue((Object)FMConstants.ZERO);
                }
            }
        }
    }

    public BigDecimal getBigDecimal(BigDecimal big) {
        return big == null ? ZERO : big;
    }
}

