/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.master.account.client.AccountPromptBox;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CasRecPayUtil;
import com.kingdee.eas.fi.cas.client.CasRecPayHandler;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMDefaultQueryProcessor;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.client.context.IMultiOrgSupport;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;

public class CasJournalQueryProcessor
extends FMDefaultQueryProcessor {
    protected IUIObject owner;
    protected FMFilterBaseUI filter;

    public CasJournalQueryProcessor(IUIObject owner) {
        this.owner = owner;
        try {
            this.process();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private CompanyOrgUnitInfo getMainOrgUnit() throws Exception {
        if (this.filter instanceof IMultiOrgSupport && this.filter.getMainOrg() != null) {
            FMFilterBaseUI multiSupportFilter = this.filter;
            Object values = multiSupportFilter.getMainOrg().getValue();
            if (values == null) {
                MsgBox.showInfo((String)CasRecPayUtil.getMainOrgNullMsg(OrgType.Company));
                this.filter.getMainOrg().requestFocus();
                SysUtil.abort();
            } else {
                if (values != null && values instanceof CompanyOrgUnitInfo) {
                    return (CompanyOrgUnitInfo)values;
                }
                if (values != null && values instanceof Object[]) {
                    return (CompanyOrgUnitInfo)((Object[])values)[0];
                }
            }
        } else {
            return ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        }
        return null;
    }

    public void process() throws Exception {
        super.process();
        String field = this.getField();
        Object editor = this.getEditor();
        if (editor instanceof KDBizPromptBox) {
            CompanyOrgUnitInfo curCompany = this.getMainOrgUnit();
            KDBizPromptBox prmtBox = (KDBizPromptBox)editor;
            String query = prmtBox.getQueryInfo();
            if (FMHelper.isEmpty((String)query)) {
                return;
            }
            String cuId = curCompany.getId().toString();
            if (field.equalsIgnoreCase("oppAccountViewName") || field.equalsIgnoreCase("oppAccountViewNumber")) {
                this.setEntryOppAcctEvi(prmtBox, curCompany, cuId, null);
                return;
            }
        }
    }

    private void setEntryOppAcctEvi(KDBizPromptBox prmtOppAccountEntry, CompanyOrgUnitInfo currentCompany, String cuId, String currencyId) throws EASBizException, BOSException {
        String companyId = currentCompany.getId().toString();
        prmtOppAccountEntry.getQueryAgent().resetRuntimeEntityView();
        EntityViewInfo treeevi = CasRecPayHandler.getAccountViewEvi(cuId, companyId, currencyId, false);
        EntityViewInfo evi = CasRecPayHandler.getAccountViewEvi(cuId, companyId, currencyId, true);
        AccountPromptBox opseelect = new AccountPromptBox(this.owner, currentCompany, treeevi.getFilter(), false, true);
        prmtOppAccountEntry.setSelector((KDPromptSelector)opseelect);
        prmtOppAccountEntry.setEntityViewInfo(evi);
    }
}

