/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.print.IRequestTableData;
import com.kingdee.bos.ctrl.kdf.table.print.MultiPrint;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.EmptyUtil;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.AccountBankPropertyEnum;
import com.kingdee.eas.basedata.assistant.AccountPropertyInfo;
import com.kingdee.eas.basedata.assistant.BankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.client.AbstractCasSubsidiaryLedgerHandler;
import com.kingdee.eas.fi.cas.client.AbstractCasSubsidiaryLedgerUI;
import com.kingdee.eas.fi.cas.client.CasSubsidiaryLedgerFilterParam;
import com.kingdee.eas.fi.cas.client.CasSubsidiaryLedgerFilterUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.fs.FSException;
import com.kingdee.eas.fm.fs.InnerAccountCollection;
import com.kingdee.eas.fm.fs.InnerAccountInfo;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerFactory;
import com.kingdee.eas.fm.fs.SubsidiaryLedgerInfo;
import com.kingdee.eas.fm.fs.client.FSClientHelper;
import com.kingdee.eas.fm.fs.client.SubsidiaryLedgerFilterParam;
import com.kingdee.eas.fm.fs.client.SubsidiaryPrintSettingUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class CasSubsidiaryLedgerUI
extends AbstractCasSubsidiaryLedgerUI {
    private static Logger logger = Logger.getLogger((String)CasSubsidiaryLedgerUI.class.getName());
    private CasSubsidiaryLedgerFilterUI filterUI;
    public static final String DEFAULT_TREE_NODE = "DefaultTreeNode";
    public static final String CURRENCY = "currency";
    private static final String resourcePath1 = "com.kingdee.eas.fm.fs.FSClientResource";
    private String resourcePath = "com.kingdee.eas.fm.fs.client.SubsidiaryLedgerResource";
    private static String printDateMsg = "Print_date";
    private static String printPersonMsg = "Print_person";
    private static String printPageCountMsg = "Print_pageCount";
    private boolean isPrintAll;
    private boolean isPaging;
    private MultiPrint multiPrint;
    private KDTable tablePrint = null;
    private Map balanceMap;
    private BankInfo clearingHouse;
    private boolean refreshTree = false;
    Runnable doPrint = new Runnable(){

        @Override
        public void run() {
            if (CasSubsidiaryLedgerUI.this.multiPrint != null) {
                CasSubsidiaryLedgerUI.this.multiPrint.preview();
            }
        }
    };

    public CasSubsidiaryLedgerUI() throws Exception {
        this.tablePrint = new KDTable();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.treeList.requestFocus();
    }

    protected boolean isDefaultColumnSort() {
        return false;
    }

    protected void execQuery() throws BOSException {
        CasSubsidiaryLedgerFilterParam param = (CasSubsidiaryLedgerFilterParam)this.getFilterParam();
        AbstractCasSubsidiaryLedgerHandler handler = new AbstractCasSubsidiaryLedgerHandler();
        String datePeriod = "";
        if (!param.isByDay()) {
            String[] args = new String[]{String.valueOf(param.getBeginYear()), String.valueOf(param.getBeginMonth()), String.valueOf(param.getEndYear()), String.valueOf(param.getEndMonth())};
            MessageFormat mf = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_PeriodRange"));
            datePeriod = mf.format(args);
        } else {
            datePeriod = FMConstants.FORMAT_DAY.format(param.getFromDate()) + " - " + FMConstants.FORMAT_DAY.format(param.getToDate());
        }
        this.txtPeriodRange.setText(datePeriod);
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getSelectManager().setSelectMode(10);
        try {
            handler.initTree(this.treeList, param);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
            SysUtil.abort();
        }
        DefaultKingdeeTreeNode node = null;
        node = (DefaultKingdeeTreeNode)this.getUIContext().get(DEFAULT_TREE_NODE);
        if (node != null) {
            this.setSelectionNode(node);
            this.getUIContext().put(DEFAULT_TREE_NODE, null);
        } else {
            FSClientHelper.setFirstInnerAcctNodeSelected((KDTree)this.treeList);
        }
    }

    private void setSelectionNode(DefaultKingdeeTreeNode node) {
        InnerAccountInfo sumInner = (InnerAccountInfo)node.getUserObject();
        int height = this.treeList.getRowCount();
        for (int i = 1; i < height; ++i) {
            TreePath tp = this.treeList.getPathForRow(i);
            if (tp == null) continue;
            DefaultKingdeeTreeNode tn = (DefaultKingdeeTreeNode)tp.getLastPathComponent();
            this.setSelectionNode(sumInner.getId().toString(), tn);
        }
    }

    private void setSelectionNode(String srcInnerAcctId, DefaultKingdeeTreeNode node) {
        InnerAccountInfo info;
        Object obj;
        boolean isMatched = false;
        if (node.isLeaf() && (obj = node.getUserObject()) instanceof InnerAccountInfo && srcInnerAcctId.equals((info = (InnerAccountInfo)obj).getId().toString())) {
            this.treeList.setSelectionNode(node);
            isMatched = true;
            return;
        }
        int childCount = node.getChildCount();
        for (int i = 0; i < childCount && !isMatched; ++i) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
            this.setSelectionNode(srcInnerAcctId, childNode);
        }
    }

    public void parseAcctNumber(StringBuffer acctNumber, DefaultKingdeeTreeNode node) {
        int childCount = node.getChildCount();
        if (childCount == 0) {
            return;
        }
        for (int j = 0; j < childCount; ++j) {
            DefaultKingdeeTreeNode childNode = (DefaultKingdeeTreeNode)this.treeList.getModel().getChild(node, j);
            if (childNode.getUserObject() instanceof InnerAccountInfo) {
                InnerAccountInfo innerAcct = (InnerAccountInfo)childNode.getUserObject();
                if (acctNumber.length() == 0) {
                    acctNumber.append(innerAcct.getNumber());
                    continue;
                }
                acctNumber.append(",");
                acctNumber.append(innerAcct.getNumber());
                continue;
            }
            if (childNode.getUserObject() instanceof AccountBankInfo) {
                AccountBankInfo bankAcct = (AccountBankInfo)childNode.getUserObject();
                if (acctNumber.length() == 0) {
                    acctNumber.append(bankAcct.getNumber());
                    continue;
                }
                acctNumber.append(",");
                acctNumber.append(bankAcct.getNumber());
                continue;
            }
            for (int k = 0; k < node.getChildCount(); ++k) {
                this.parseAcctNumber(acctNumber, (DefaultKingdeeTreeNode)node.getChildAt(k));
            }
        }
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CasSubsidiaryLedgerFilterUI();
        }
        return this.filterUI;
    }

    @Override
    protected void treeList_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeList_valueChanged(e);
        this.fillTableData();
        this.balanceMap = null;
    }

    private void fillTableData() throws EASBizException, BOSException, SQLException {
        StringBuffer sb;
        this.tblMain.removeRows();
        TreePath path = this.treeList.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node == null) {
            return;
        }
        Object obj = node.getUserObject();
        if (obj == null) {
            this.tblMain.removeRows();
            return;
        }
        String acctNumbers = "";
        if (obj != null && obj instanceof InnerAccountInfo) {
            InnerAccountInfo innerAcct = (InnerAccountInfo)obj;
            acctNumbers = innerAcct.getNumber();
        }
        if (obj != null && obj instanceof CompanyOrgUnitInfo) {
            sb = new StringBuffer();
            this.parseAcctNumber(sb, node);
            acctNumbers = sb.toString();
        }
        if (obj != null && obj instanceof AccountBankPropertyEnum) {
            sb = new StringBuffer();
            this.parseAcctNumber(sb, node);
            acctNumbers = sb.toString();
        }
        if (obj != null && obj instanceof AccountPropertyInfo) {
            sb = new StringBuffer();
            this.parseAcctNumber(sb, node);
            acctNumbers = sb.toString();
        }
        if (acctNumbers == null || acctNumbers.trim().length() == 0) {
            return;
        }
        this.fillTable(this.tblMain, acctNumbers);
    }

    private void fillTable(KDTable table, String acctNumbers) throws BOSException, EASBizException, SQLException {
        HashSet<String> acctSet = new HashSet<String>();
        if (acctNumbers.indexOf(",") == -1) {
            acctSet.add(acctNumbers);
        } else {
            String[] acctArray = acctNumbers.split(",");
            for (int i = 0; i < acctArray.length; ++i) {
                acctSet.add(acctArray[i]);
            }
        }
        CompanyOrgUnitInfo chCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        BOSUuid currencyId = null;
        EntityViewInfo ev = (EntityViewInfo)this.mainQuery.clone();
        FilterInfo filter = ev.getFilter();
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        currencyId = currency.getId();
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        filter.getFilterItems().add(new FilterItemInfo("innerAccount.number", acctSet, CompareType.INCLUDE));
        SorterItemCollection sorter = ev.getSorter();
        sorter.add(new SorterItemInfo("company.id"));
        sorter.add(new SorterItemInfo("date"));
        sorter.add(new SorterItemInfo("createTime"));
        sorter.add(new SorterItemInfo("seq"));
        sorter.add(new SorterItemInfo("billNumber"));
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)this.mainQueryPK);
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        SubsidiaryLedgerFilterParam param = (SubsidiaryLedgerFilterParam)this.getFilterParam();
        AbstractCasSubsidiaryLedgerHandler handler = new AbstractCasSubsidiaryLedgerHandler();
        handler.fillData3(this.mainQueryPK, table, rs, param, chCompany.getNumber(), currencyId, acctNumbers);
    }

    @Override
    protected void cboCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.cboCurrency_actionPerformed(e);
        this.treeList_valueChanged(null);
    }

    private void checkClearHourse() throws Exception {
        FSClientHelper.checkClearingHouseCompany();
    }

    public void onLoad() throws Exception {
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        if (!"FINDVIEW".equalsIgnoreCase(this.getOprtState())) {
            ClientUtils.checkCompany((Component)((Object)this), company);
        }
        this.treeView.setShowControlPanel(true);
        FMClientHelper.initCurrency((KDComboBox)this.cboCurrency);
        Object currency = this.getUIContext().get(CURRENCY);
        if (currency != null) {
            this.cboCurrency.setSelectedItem(currency);
        } else {
            FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
        }
        super.onLoad();
        Preferences pref = Preferences.userNodeForPackage(((Object)((Object)this)).getClass());
        this.isPrintAll = pref.getBoolean("isPrintAll", false);
        this.isPaging = pref.getBoolean("isPaging", true);
        HeadFootModel model = new HeadFootModel();
        model.addRow(" &| ");
        model.addRow(" &| ");
        model.addRow(" &| ");
        model.addRow(" &| ");
        this.tablePrint.getPrintManager().setHeader(HeadFootParser.parseModel2HeadFootPage((HeadFootModel)model));
        this.refreshTree = true;
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    public static void showSubsidiaryLedgerUI(IUIObject ui, SubsidiaryLedgerFilterParam param, DefaultKingdeeTreeNode node, CurrencyInfo curInfo) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"isDirectShow", (Object)Boolean.TRUE);
        uiContext.put((Object)"filterParam", (Object)param);
        uiContext.put((Object)DEFAULT_TREE_NODE, (Object)node);
        uiContext.put((Object)CURRENCY, (Object)curInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(CasSubsidiaryLedgerUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionViewSettlementBill.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_linkviewbill"));
        this.actionPrintSetting.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_distributelog"));
    }

    @Override
    public void actionViewSettlementBill_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int i = this.tblMain.getSelectManager().getActiveRowIndex();
        String id = (String)this.tblMain.getRow(i).getCell("id").getValue();
        if (FMHelper.isEmpty((String)id)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"SelectValidRecord"));
            return;
        }
        SubsidiaryLedgerInfo info = SubsidiaryLedgerFactory.getRemoteInstance().getSubsidiaryLedgerInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)id)));
        BOSUuid bosUuid = info.getBillId();
        if (bosUuid == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"SelectValidRecord"));
            return;
        }
        String billId = bosUuid.toString();
        if (billId != null) {
            FMClientHelper.viewDetailBill((CoreUIObject)this, (String)billId, (CompanyOrgUnitInfo)info.getCompany());
        }
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        TreePath path = this.treeList.getSelectionPath();
        if (path == null) {
            return;
        }
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        if (node == null) {
            return;
        }
        if (node.isRoot()) {
            return;
        }
        Object obj = node.getUserObject();
        if (obj == null) {
            return;
        }
        String inAcctString = "";
        if (obj != null && obj instanceof CompanyOrgUnitInfo) {
            return;
        }
        if (obj != null && obj instanceof AccountBankPropertyEnum) {
            return;
        }
        if (obj != null && obj instanceof InnerAccountInfo) {
            InnerAccountInfo innerAcct = (InnerAccountInfo)obj;
            inAcctString = innerAcct.getNumber() + "-" + innerAcct.getName();
        }
        if (inAcctString == null) {
            return;
        }
        String headString = inAcctString;
        headerModel.addRow(headString, Styles.getDefaultSA());
        super.preparePrintPageHeader(headerModel);
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.initMultiPrint();
        DoPrintThreadPre doP = new DoPrintThreadPre(this.multiPrint, true);
        doP.start();
    }

    public void actionPrintPre_actionPerformed(ActionEvent e) throws Exception {
        this.initMultiPrint();
        DoPrintThreadPre doP = new DoPrintThreadPre(this.multiPrint, false);
        doP.start();
    }

    @Override
    public void actionPrintSetting_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiCtx = new UIContext((Object)this);
        uiCtx.put((Object)"Owner", (Object)this);
        IUIWindow printSetUI = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(SubsidiaryPrintSettingUI.class.getName(), (Map)uiCtx);
        printSetUI.show();
        SubsidiaryPrintSettingUI printSetUIObj = (SubsidiaryPrintSettingUI)printSetUI.getUIObject();
        if (printSetUIObj.isOK()) {
            this.isPrintAll = printSetUIObj.isPrintAll();
            this.isPaging = printSetUIObj.isPaging();
        }
    }

    protected Page getHeader(boolean isPaging, InnerAccountInfo innerAcctInfo) {
        HeadFootModel header = new HeadFootModel();
        StyleAttributes saMajorTitle = Styles.getDefaultSA();
        saMajorTitle.setFontSize(14);
        saMajorTitle.setBold(true);
        header.addRow(this.getPrintPageTitle(), saMajorTitle);
        header.addRow("");
        StringBuffer headStringOne = new StringBuffer();
        headStringOne.append(this.lblPeriodRange.getBoundLabelText()).append(" ").append(this.txtPeriodRange.getText()).append("&|");
        headStringOne.append(this.lblCurrency.getBoundLabelText()).append(" ").append(this.cboCurrency.getSelectedItem().toString());
        header.addRow(headStringOne.toString());
        StringBuffer headStringTwo = new StringBuffer();
        if (innerAcctInfo != null) {
            innerAcctInfo.setDisplayFormat("$number$-$name$");
            headStringTwo.append(EASResource.getString((String)"com.kingdee.eas.fm.fs.client.SubsidiaryLedgerResource.InnerAccount")).append("   ").append(innerAcctInfo).append("&|");
            headStringTwo.append(" ").append("&|").append(" ");
            header.addRow(headStringTwo.toString());
        }
        Page hPage = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)header);
        return hPage;
    }

    protected Page getFooter() {
        HeadFootModel footer = new HeadFootModel();
        String dateString = EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + printDateMsg)) + "&[Date]";
        String personString = EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + printPersonMsg)) + SysContext.getSysContext().getCurrentUserInfo().getName();
        String pageNumber = EASResource.getString((String)("com.kingdee.eas.framework.FrameWorkResource." + printPageCountMsg)) + "&[Page]/&[PageCount]";
        String footerString = dateString + "&|" + personString + "&|" + pageNumber;
        StyleAttributes sb = Styles.getDefaultSA();
        footer.addRow(footerString, sb);
        Page fPage = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)footer);
        return fPage;
    }

    protected static InnerAccountCollection getLeafInnerAccounts(TreePath path) {
        DefaultKingdeeTreeNode node = (DefaultKingdeeTreeNode)path.getLastPathComponent();
        InnerAccountCollection coll = CasSubsidiaryLedgerUI.getLeafInnerAccounts(null, node);
        return coll;
    }

    private static InnerAccountCollection getLeafInnerAccounts(InnerAccountCollection coll, DefaultKingdeeTreeNode node) {
        if (coll == null) {
            coll = new InnerAccountCollection();
        }
        if (node.isLeaf() && node.getUserObject() instanceof InnerAccountInfo) {
            coll.add((InnerAccountInfo)node.getUserObject());
        } else {
            int n = node.getChildCount();
            for (int i = 0; i < n; ++i) {
                DefaultKingdeeTreeNode leafNode = (DefaultKingdeeTreeNode)node.getChildAt(i);
                CasSubsidiaryLedgerUI.getLeafInnerAccounts(coll, leafNode);
            }
        }
        return coll;
    }

    protected InnerAccountCollection getSelectedInnerAccounts() {
        InnerAccountCollection innerAcctColl = new InnerAccountCollection();
        Object[] paths = this.treeList.getSelectionPaths();
        if (!EmptyUtil.isEmpty((Object[])paths)) {
            int n = paths.length;
            for (int i = 0; i < n; ++i) {
                innerAcctColl.addCollection(CasSubsidiaryLedgerUI.getLeafInnerAccounts((TreePath)paths[i]));
            }
        }
        return innerAcctColl;
    }

    protected InnerAccountCollection getAllInnerAccounts() {
        InnerAccountCollection innerAcctColl = new InnerAccountCollection();
        TreeModel model = this.treeList.getModel();
        int n = model.getChildCount(model.getRoot());
        for (int i = 0; i < n; ++i) {
            Object childNode = model.getChild(model.getRoot(), i);
            innerAcctColl.addCollection(CasSubsidiaryLedgerUI.getLeafInnerAccounts(null, (DefaultKingdeeTreeNode)childNode));
        }
        return innerAcctColl;
    }

    protected void initMultiPrint() throws FSException {
        InnerAccountCollection innerAcctColl;
        this.multiPrint = new MultiPrint((Component)((Object)this));
        this.multiPrint.getMultiPrintModel().getManager().setParent((Component)((Object)this));
        this.multiPrint.setFrugalPrint(!this.isPaging);
        if (this.isPaging) {
            this.tablePrint.getPrintManager().setBodyTopMargin(360.0f);
        }
        this.multiPrint.setTable(this.tablePrint);
        if (this.isPrintAll) {
            innerAcctColl = this.getAllInnerAccounts();
        } else {
            innerAcctColl = this.getSelectedInnerAccounts();
            if (innerAcctColl.size() <= 0) {
                throw new FSException(FSException.NOTPRINTALLSELECTROW);
            }
        }
        int n = innerAcctColl.size();
        for (int i = 0; i < n; ++i) {
            this.multiPrint.addPrintData(new Integer(i).toString());
        }
        this.multiPrint.setRequestData(new IRequestTableData(){
            private boolean flag = true;

            public void requestTableData(String key) {
                CasSubsidiaryLedgerUI.this.tablePrint.removeRows();
                CasSubsidiaryLedgerUI.this.tablePrint.removeColumns();
                CasSubsidiaryLedgerUI.this.tablePrint.removeHeadRows();
                int n = CasSubsidiaryLedgerUI.this.tblMain.getColumnCount();
                for (int i = 0; i < n; ++i) {
                    IColumn oldCol = CasSubsidiaryLedgerUI.this.tblMain.getColumn(i);
                    IColumn newCol = CasSubsidiaryLedgerUI.this.tablePrint.addColumn();
                    newCol.setWidth(oldCol.getWidth());
                    newCol.setKey(oldCol.getKey());
                    newCol.setStyleAttributes(oldCol.getStyleAttributes());
                }
                IRow headRow = CasSubsidiaryLedgerUI.this.tablePrint.addHeadRow();
                int n2 = CasSubsidiaryLedgerUI.this.tablePrint.getColumnCount();
                for (int i = 0; i < n2; ++i) {
                    IColumn headCol = CasSubsidiaryLedgerUI.this.tablePrint.getColumn(i);
                    String colKey = headCol.getKey();
                    headRow.getCell(colKey).setValue(CasSubsidiaryLedgerUI.this.tblMain.getHeadRow(0).getCell(colKey).getValue());
                }
                StringBuffer sb = new StringBuffer();
                int ind = Integer.parseInt(key);
                CasSubsidiaryLedgerUI.this.tablePrint.getPrintManager().setHeader(CasSubsidiaryLedgerUI.this.getHeader(CasSubsidiaryLedgerUI.this.isPaging, innerAcctColl.get(ind)));
                sb.append(innerAcctColl.get(ind).getNumber());
                CasSubsidiaryLedgerUI.this.tablePrint.getPrintManager().setFooter(CasSubsidiaryLedgerUI.this.getFooter());
                try {
                    CasSubsidiaryLedgerUI.this.fillTable(CasSubsidiaryLedgerUI.this.tablePrint, sb.toString());
                }
                catch (EASBizException e) {
                    CasSubsidiaryLedgerUI.this.handUIExceptionAndAbort((Exception)((Object)e));
                }
                catch (BOSException e) {
                    CasSubsidiaryLedgerUI.this.handUIExceptionAndAbort((Exception)((Object)e));
                }
                catch (SQLException e) {
                    CasSubsidiaryLedgerUI.this.handUIExceptionAndAbort(e);
                }
            }
        });
    }

    public void checkSelected() {
        if (this.tblMain.getRowCount() == 0 || this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    class DoPrintThreadPre
    extends Thread {
        private MultiPrint multiPrint;
        private boolean doPrint;

        public DoPrintThreadPre(MultiPrint multiPrint, boolean doPrint) {
            this.multiPrint = multiPrint;
            this.doPrint = doPrint;
        }

        @Override
        public void run() {
            if (this.multiPrint != null) {
                if (!this.doPrint) {
                    this.multiPrint.preview();
                } else {
                    this.multiPrint.print();
                }
            }
        }
    }
}

