/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGCollection;
import com.kingdee.eas.basedata.master.auxacct.AssistantHGFactory;
import com.kingdee.eas.basedata.master.auxacct.IAssistantHG;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CapitalTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CashBankContrastGLFactory;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.client.CasTableHelper;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.CashContrastGLDetailDiffRptUI;
import com.kingdee.eas.fi.cas.client.CashContrastGLDetailResultUI;
import com.kingdee.eas.fi.cas.client.CashContrastGLDetailUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.gl.SourceType;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.UserOptionFactory;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.IRptHandler;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashContrastGLDetailHandler
implements IRptHandler {
    private static Logger logger = Logger.getLogger((String)CashContrastGLDetailHandler.class.getName());
    public static final String resourcePath = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    public static final int UN_CONTRAST_FLAG = 0;
    public static final int AUTO_CONTRAST_FLAG = 1;
    public static final int MANUAL_CONTRAST_FLAG = 2;
    private int sucessContrastTotal = 0;
    public static final String STR_NULL = "null";

    public int getSucessContrastTotal() {
        return this.sucessContrastTotal;
    }

    public void setSucessContrastTotal(int sucessContrastTotal) {
        this.sucessContrastTotal = sucessContrastTotal;
    }

    public void refreshUIContentLayout(CashContrastGLDetailUI ui) {
        Map map = this.getUIOptionMap();
        if (map == null || map.size() == 0) {
            return;
        }
        boolean isUpAndDown = Boolean.valueOf((String)map.get("btnUpAndDown"));
        if (isUpAndDown) {
            ui.contSpider.setOrientation(0);
            ui.contSpider.setDividerLocation((ui.getHeight() - 140) / 2);
        } else {
            ui.contSpider.setOrientation(1);
            ui.contSpider.setDividerLocation(ui.getWidth() / 2);
        }
    }

    public Map getUIOptionMap() {
        Map map = null;
        try {
            map = UserOptionFactory.getRemoteInstance().getUserOptionMap("com.kingdee.eas.fi.cas.client.CashContrastGLDetailOptionUI");
        }
        catch (Exception e1) {
            logger.error((Object)e1);
            SysUtil.abort();
        }
        return map;
    }

    public void initCombAccountBank(KDComboBox comboBankAcct, String companyId) throws BOSException {
        comboBankAcct.removeAllItems();
        ActionListener[] actionListener = comboBankAcct.getActionListeners();
        for (int i = 0; i < actionListener.length; ++i) {
            comboBankAcct.removeActionListener(actionListener[i]);
        }
        AccountBankCollection acctBankCol = CashClientHelper.getAccountBankCollection(companyId, false);
        comboBankAcct.addItems(acctBankCol.toArray());
        for (int i = 0; i < actionListener.length; ++i) {
            comboBankAcct.addActionListener(actionListener[i]);
        }
    }

    public void initCombAccountView(KDComboBox comboAcctView, CapitalTypeEnum capitalType, String companyId, AccountBankInfo bankAcct) throws EASBizException, BOSException {
        comboAcctView.removeAllItems();
        ActionListener[] actionListener = comboAcctView.getActionListeners();
        for (int i = 0; i < actionListener.length; ++i) {
            comboAcctView.removeActionListener(actionListener[i]);
        }
        if (capitalType.equals((Object)CapitalTypeEnum.CASH)) {
            AccountViewCollection accountCol = FMHelper.getAcctViewCollection((String)companyId, null, (AccountTypeEnum)AccountTypeEnum.CASHACCOUNT);
            comboAcctView.addItems(accountCol.toArray());
            comboAcctView.setEnabled(true);
        } else {
            comboAcctView.addItem((Object)bankAcct.getAccount());
            comboAcctView.setEnabled(false);
        }
        for (int i = 0; i < actionListener.length; ++i) {
            comboAcctView.addActionListener(actionListener[i]);
        }
    }

    public IRowSet getCashRowset(IMetaDataPK mainQueryPK, EntityViewInfo mainQuery, BOSUuid currencyId, Set acctBankIdSet, Set acctViewIdSet, CapitalTypeEnum capitalType, PeriodInfo period) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        EntityViewInfo ev = (EntityViewInfo)mainQuery.clone();
        FilterInfo filter = ev.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        if (capitalType.equals((Object)CapitalTypeEnum.BANK)) {
            filter.getFilterItems().add(new FilterItemInfo("bankAccountId", (Object)acctBankIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(2), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("accountViewId", (Object)acctViewIdSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)new Integer(1), CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("period.id", (Object)period.getId().toString(), CompareType.EQUALS));
        ev.getSorter().add(new SorterItemInfo("voucherNumber"));
        exec.setObjectView(ev);
        IRowSet rs = exec.executeQuery();
        return rs;
    }

    public IRowSet getGLRowset(IMetaDataPK mainQueryPK, EntityViewInfo mainQuery, BOSUuid currencyId, Set acctBankIdSet, Set acctViewIdSet, CapitalTypeEnum capitalType, PeriodInfo period) throws BOSException, EASBizException {
        IRowSet rs = CashBankContrastGLFactory.getRemoteInstance().getGLRowset((IObjectPK)mainQueryPK, (IObjectValue)mainQuery, currencyId, acctBankIdSet, acctViewIdSet, capitalType, period);
        return rs;
    }

    public void fillCashData(KDTable tblMain, IRowSet rs) throws SQLException {
        if (rs == null || rs.size() == 0) {
            return;
        }
        while (rs.next()) {
            IRow row = tblMain.addRow();
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("system").setValue((Object)EASResource.getString((String)resourcePath, (String)"CashSystem"));
            row.getCell("id").setValue((Object)rs.getString("id"));
            row.getCell("date").setValue((Object)rs.getDate("createDate"));
            row.getCell("settNumber").setValue((Object)rs.getString("settlementNumber"));
            row.getCell("settType").setValue((Object)rs.getString("settlementType.name"));
            row.getCell("oppAccount").setValue((Object)rs.getString("oppAccountView.number"));
            row.getCell("description").setValue((Object)rs.getString("description"));
            row.getCell("voucherNumber").setValue((Object)rs.getString("voucherNumber"));
            row.getCell("voucherType").setValue((Object)rs.getString("voucherType.name"));
            row.getCell("debit").setValue((Object)rs.getBigDecimal("debitAmount"));
            row.getCell("credit").setValue((Object)rs.getBigDecimal("creditAmount"));
            row.getCell("cash").setValue((Object)rs.getString("cashier.name"));
            row.getCell("flag").setValue((Object)new Integer(0));
            row.getCell("source").setValue((Object)JournalSourceEnum.getEnum((int)rs.getInt("source")));
            row.getCell("billType").setValue((Object)BillTypeEnum.getEnum(rs.getInt("billType")));
            row.getCell("billNumber").setValue((Object)rs.getString("billNumber"));
        }
    }

    public void fillCashDataTest(KDTable tblMain) throws SQLException {
        int i;
        IRow row = null;
        for (i = 0; i < 10; ++i) {
            row = tblMain.addRow();
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("date").setValue((Object)"2005-08-01");
            row.getCell("description").setValue((Object)"test");
            row.getCell("voucherNumber").setValue((Object)("no" + i));
            row.getCell("voucherType").setValue((Object)("type" + i));
            row.getCell("debit").setValue((Object)new BigDecimal("2000" + i));
            row.getCell("credit").setValue((Object)CasConstants.ZERO);
            row.getCell("flag").setValue((Object)new Integer(0));
            row = tblMain.addRow();
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("date").setValue((Object)"2005-08-01");
            row.getCell("description").setValue((Object)"test");
            row.getCell("voucherNumber").setValue((Object)("no" + i));
            row.getCell("voucherType").setValue((Object)("type" + i));
            row.getCell("debit").setValue((Object)new BigDecimal("1000" + i));
            row.getCell("credit").setValue((Object)CasConstants.ZERO);
            row.getCell("flag").setValue((Object)new Integer(0));
        }
        for (i = 0; i < 10; ++i) {
            row = tblMain.addRow();
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("date").setValue((Object)"2005-08-01");
            row.getCell("description").setValue((Object)"test");
            row.getCell("debit").setValue((Object)new BigDecimal("2000" + i));
            row.getCell("credit").setValue((Object)CasConstants.ZERO);
            row.getCell("flag").setValue((Object)new Integer(0));
        }
    }

    public void fillGLDataTest(KDTable tblMain) throws SQLException {
        int i;
        IRow row = null;
        for (i = 0; i < 10; ++i) {
            row = tblMain.addRow();
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("date").setValue((Object)"2005-08-01");
            row.getCell("description").setValue((Object)"test");
            row.getCell("voucherNumber").setValue((Object)("no" + i));
            row.getCell("voucherType").setValue((Object)("type" + i));
            row.getCell("debit").setValue((Object)new BigDecimal("1800" + i));
            row.getCell("credit").setValue((Object)CasConstants.ZERO);
            row.getCell("flag").setValue((Object)new Integer(0));
            row = tblMain.addRow();
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("date").setValue((Object)"2005-08-01");
            row.getCell("description").setValue((Object)"test");
            row.getCell("voucherNumber").setValue((Object)("no" + i));
            row.getCell("voucherType").setValue((Object)("type" + i));
            row.getCell("debit").setValue((Object)new BigDecimal("1200" + i));
            row.getCell("credit").setValue((Object)CasConstants.ZERO);
            row.getCell("flag").setValue((Object)new Integer(0));
        }
        for (i = 0; i < 10; ++i) {
            row = tblMain.addRow();
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("date").setValue((Object)"2005-08-01");
            row.getCell("description").setValue((Object)"test");
            row.getCell("voucherNumber").setValue((Object)("no2" + i));
            row.getCell("voucherType").setValue((Object)("type2" + i));
            row.getCell("debit").setValue((Object)new BigDecimal("2000" + i));
            row.getCell("credit").setValue((Object)CasConstants.ZERO);
            row.getCell("flag").setValue((Object)new Integer(0));
        }
    }

    public void fillGLData(KDTable tblMain, IRowSet rs, CapitalTypeEnum capitalType, String accountViewId, String accountBankId, FmRpcCacheInfo rpcCacheInfo) throws SQLException, BOSException {
        if (rs == null || rs.size() == 0) {
            return;
        }
        boolean isMultiBankAcct = false;
        boolean isHasAssistant = false;
        boolean isBank = capitalType.equals((Object)CapitalTypeEnum.BANK);
        String bankAccountId = null;
        String desc = null;
        if (isBank) {
            if (rpcCacheInfo == null) {
                isMultiBankAcct = this.isMultiBankAccount(accountViewId);
                isHasAssistant = this.isHasAssistant(accountBankId);
            } else {
                Map acctViewCntMap = (Map)rpcCacheInfo.get("acctViewCntMap");
                Object object = acctViewCntMap.get(accountViewId);
                int count = 1;
                if (object != null) {
                    count = (Integer)acctViewCntMap.get(accountViewId);
                }
                isMultiBankAcct = count > 1;
                Map hasAssistantHGMap = (Map)rpcCacheInfo.get("hasAssistantHGMap");
                if (hasAssistantHGMap.containsKey(accountBankId)) {
                    isHasAssistant = true;
                }
            }
            if (isMultiBankAcct && !isHasAssistant) {
                return;
            }
        }
        while (rs.next()) {
            IRow row;
            BigDecimal emtriesAmt = rs.getBigDecimal("entries.originalAmount");
            BigDecimal amt = rs.getBigDecimal("assistRecords.originalAmount");
            if (amt == null) {
                row = tblMain.addRow();
                row.getCell("select").setValue((Object)Boolean.FALSE);
                row.getCell("system").setValue((Object)EASResource.getString((String)resourcePath, (String)"GLSystem"));
                row.getCell("date").setValue((Object)rs.getDate("createDate"));
                row.getCell("voucherNumber").setValue((Object)rs.getString("voucherNumber"));
                row.getCell("voucherType").setValue((Object)rs.getString("voucherType.name"));
                row.getCell("flag").setValue((Object)new Integer(0));
                row.getCell("description").setValue((Object)rs.getString("entries.description"));
                row.getCell("source").setValue((Object)SourceType.getEnum((int)rs.getInt("sourceType")));
                if (rs.getInt("entries.entryDC") > 0) {
                    row.getCell("debit").setValue((Object)emtriesAmt);
                    row.getCell("credit").setValue((Object)CasConstants.ZERO);
                } else {
                    row.getCell("debit").setValue((Object)CasConstants.ZERO);
                    row.getCell("credit").setValue((Object)emtriesAmt);
                }
                row.getCell("check").setValue((Object)rs.getString("cashier.name"));
                continue;
            }
            bankAccountId = rs.getString("bankAccount.id");
            row = tblMain.addRow();
            row.getCell("select").setValue((Object)Boolean.FALSE);
            row.getCell("system").setValue((Object)EASResource.getString((String)resourcePath, (String)"GLSystem"));
            row.getCell("date").setValue((Object)rs.getDate("createDate"));
            row.getCell("voucherNumber").setValue((Object)rs.getString("voucherNumber"));
            row.getCell("voucherType").setValue((Object)rs.getString("voucherType.name"));
            row.getCell("flag").setValue((Object)new Integer(0));
            desc = rs.getString("assistRecords.description");
            if (desc == null) {
                desc = rs.getString("entries.description");
            }
            row.getCell("description").setValue((Object)desc);
            row.getCell("settNumber").setValue((Object)rs.getString("assistRecords.settlementCode"));
            row.getCell("settType").setValue((Object)rs.getString("settlementType.name"));
            if (rs.getInt("entries.entryDC") > 0) {
                row.getCell("debit").setValue((Object)amt);
                row.getCell("credit").setValue((Object)CasConstants.ZERO);
            } else {
                row.getCell("debit").setValue((Object)CasConstants.ZERO);
                row.getCell("credit").setValue((Object)amt);
            }
            row.getCell("source").setValue((Object)SourceType.getEnum((int)Integer.parseInt(rs.getString("sourceType"))));
            row.getCell("check").setValue((Object)rs.getString("cashier.name"));
        }
    }

    private boolean isMultiBankAccount(String accountViewId) throws BOSException {
        CompanyOrgUnitInfo companyInfo = ClientUtils.getCurrLoginCompany();
        return FMHelper.isExistMultiBankAcct((String)companyInfo.getId().toString(), (String)accountViewId);
    }

    private boolean isHasAssistant(String bankAccountId) throws BOSException {
        IAssistantHG assistantHG = AssistantHGFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("bankAccount.id", (Object)bankAccountId));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        evi.getSelector().addObjectCollection((IObjectCollection)selector);
        evi.setFilter(fi);
        AssistantHGCollection assistantHGColl = assistantHG.getAssistantHGCollection(evi);
        return assistantHGColl != null && assistantHGColl.size() != 0;
    }

    public void autoContrast(KDTable tblCash, KDTable tblGL) {
        int tblCashSize = tblCash.getRowCount();
        int tblGLSize = tblGL.getRowCount();
        if (tblCashSize == 0 || tblGLSize == 0) {
            return;
        }
        int total = 0;
        boolean isEqual = false;
        block0: for (int i = 0; i < tblCashSize; ++i) {
            IRow cashRow = tblCash.getRow(i);
            String cashVoucherType = (String)cashRow.getCell("voucherType").getValue();
            String cashVoucherNumber = (String)cashRow.getCell("voucherNumber").getValue();
            if (cashVoucherType == null) continue;
            BigDecimal cashDebitAmount = (BigDecimal)cashRow.getCell("debit").getValue();
            BigDecimal cashCreditAmount = (BigDecimal)cashRow.getCell("credit").getValue();
            if (cashDebitAmount == null) {
                cashDebitAmount = CasConstants.ZERO;
            }
            if (cashCreditAmount == null) {
                cashCreditAmount = CasConstants.ZERO;
            }
            for (int j = 0; j < tblGLSize; ++j) {
                IRow glRow = tblGL.getRow(j);
                String glVoucherType = (String)glRow.getCell("voucherType").getValue();
                String glVoucherNumber = (String)glRow.getCell("voucherNumber").getValue();
                BigDecimal glDebitAmount = (BigDecimal)glRow.getCell("debit").getValue();
                BigDecimal glCreditAmount = (BigDecimal)glRow.getCell("credit").getValue();
                if (glDebitAmount == null) {
                    glDebitAmount = CasConstants.ZERO;
                }
                if (glCreditAmount == null) {
                    glCreditAmount = CasConstants.ZERO;
                }
                if (!cashVoucherType.equals(glVoucherType) || !cashVoucherNumber.equals(glVoucherNumber) || cashDebitAmount.compareTo(glDebitAmount) != 0 || cashCreditAmount.compareTo(glCreditAmount) != 0) continue;
                cashRow.getStyleAttributes().setBackground(CasConstants.KDTABLE_GRAY_COLOR);
                glRow.getStyleAttributes().setBackground(CasConstants.KDTABLE_GRAY_COLOR);
                cashRow.getCell("flag").setValue((Object)new Integer(1));
                glRow.getCell("flag").setValue((Object)new Integer(1));
                ++total;
                continue block0;
            }
        }
        this.sucessContrastTotal += total;
    }

    public void autoContrast_Multi_New(KDTable tblCash, KDTable tblGL, CashContrastGLDetailUI ui) {
        String key2;
        String voucherNumber;
        String voucherType;
        int flag;
        IRow row;
        int i;
        int tblCashSize = tblCash.getRowCount();
        int tblGLSize = tblGL.getRowCount();
        if (tblCashSize == 0 || tblGLSize == 0) {
            return;
        }
        BigDecimal tmpGlDebitAmount = CasConstants.ZERO;
        BigDecimal tmpGlCreditAmount = CasConstants.ZERO;
        BigDecimal tmpCashDebitAmount = CasConstants.ZERO;
        BigDecimal tmpCashCreditAmount = CasConstants.ZERO;
        BigDecimal tmpAmount = CasConstants.ZERO;
        BigDecimal tmpDebitAmount = CasConstants.ZERO;
        BigDecimal tmpCreditAmount = CasConstants.ZERO;
        int total = 0;
        HashMap<String, BigDecimal> cashDebitMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> glDebitMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> cashCreditMap = new HashMap<String, BigDecimal>();
        HashMap<String, BigDecimal> glCreditMap = new HashMap<String, BigDecimal>();
        HashMap rowIndexMap = new HashMap();
        List<Object> itemList = null;
        for (i = 0; i < tblCashSize; ++i) {
            row = tblCash.getRow(i);
            flag = (Integer)row.getCell("flag").getValue();
            if (flag != 0) continue;
            voucherType = "";
            voucherNumber = "";
            tmpDebitAmount = (BigDecimal)row.getCell("debit").getValue();
            tmpCreditAmount = (BigDecimal)row.getCell("credit").getValue();
            key2 = "" + tmpDebitAmount.setScale(10) + tmpCreditAmount.setScale(10);
            if (cashDebitMap.containsKey(key2)) continue;
            cashDebitMap.put(key2, tmpDebitAmount);
            cashCreditMap.put(key2, tmpCreditAmount);
            itemList = new ArrayList<IRow>();
            itemList.add(row);
            rowIndexMap.put(key2, itemList);
        }
        for (i = 0; i < tblGLSize; ++i) {
            row = tblGL.getRow(i);
            flag = (Integer)row.getCell("flag").getValue();
            if (flag != 0) continue;
            voucherType = "";
            voucherNumber = "";
            tmpDebitAmount = (BigDecimal)row.getCell("debit").getValue();
            tmpCreditAmount = (BigDecimal)row.getCell("credit").getValue();
            key2 = "" + tmpDebitAmount.setScale(10) + tmpCreditAmount.setScale(10);
            if (glDebitMap.containsKey(key2)) continue;
            glCreditMap.put(key2, tmpCreditAmount);
            glDebitMap.put(key2, tmpDebitAmount);
            itemList = rowIndexMap.containsKey(key2) ? (List)rowIndexMap.get(key2) : new ArrayList();
            itemList.add(row);
            rowIndexMap.put(key2, itemList);
        }
        Set keySet = cashDebitMap.keySet();
        for (String key2 : keySet) {
            if (!glDebitMap.containsKey(key2)) continue;
            tmpCashDebitAmount = (BigDecimal)cashDebitMap.get(key2);
            tmpCashCreditAmount = (BigDecimal)cashCreditMap.get(key2);
            tmpGlDebitAmount = (BigDecimal)glDebitMap.get(key2);
            tmpGlCreditAmount = (BigDecimal)glCreditMap.get(key2);
            if (tmpCashDebitAmount.compareTo(tmpGlDebitAmount) != 0 || tmpCashCreditAmount.compareTo(tmpGlCreditAmount) != 0) continue;
            itemList = (ArrayList<IRow>)rowIndexMap.get(key2);
            for (int k = 0; k < itemList.size(); ++k) {
                row = (IRow)itemList.get(k);
                row.getStyleAttributes().setBackground(CasConstants.KDTABLE_GRAY_COLOR);
                row.getCell("flag").setValue((Object)new Integer(1));
                row.setUserObject(itemList);
            }
            ++total;
        }
        this.sucessContrastTotal += total;
        StringBuffer msgStr = new StringBuffer(128);
        msgStr.append(EASResource.getString((String)resourcePath, (String)"SucessContrastTotal"));
        msgStr.append(total);
        msgStr.append(EASResource.getString((String)resourcePath, (String)"Group"));
        MsgBox.showInfo((Component)((Object)ui), (String)msgStr.toString());
        SysUtil.abort();
    }

    private boolean isVoucherNumEquals(Map map) {
        if (map != null && map.size() != 0) {
            boolean isDateEquals = TypeConversionUtils.objToBoolean(map.get("chkDateEqual"));
            boolean isDescriptionEquals = TypeConversionUtils.objToBoolean(map.get("chkDescriptionEqual"));
            boolean isSettTypeEquals = TypeConversionUtils.objToBoolean(map.get("chkSettTypeEqual"));
            boolean isSettNumberEquals = TypeConversionUtils.objToBoolean(map.get("chkSettNumberEqual"));
            boolean isVoucherNumEquals = TypeConversionUtils.objToBoolean(map.get("chkVoucherNumEqual"));
            return !isDateEquals && !isDescriptionEquals && !isSettTypeEquals && !isSettNumberEquals && isVoucherNumEquals;
        }
        return false;
    }

    public void autoContrast_Multi_New2(KDTable tblCash, KDTable tblGL, CashContrastGLDetailUI ui) {
        int tblCashSize = tblCash.getRowCount();
        int tblGLSize = tblGL.getRowCount();
        if (tblCashSize == 0 || tblGLSize == 0) {
            return;
        }
        BigDecimal tmpCashDebitAmount = CasConstants.ZERO;
        BigDecimal tmpCashCreditAmount = CasConstants.ZERO;
        BigDecimal tmpGlDebitAmount = CasConstants.ZERO;
        BigDecimal tmpGlCreditAmount = CasConstants.ZERO;
        int total = 0;
        Object cashRow = null;
        Object glRow = null;
        Map map = this.getUIOptionMap();
        total = !this.isVoucherNumEquals(map) ? this.contrast(tblCash, tblGL, tblCashSize, tblGLSize, tmpCashDebitAmount, tmpCashCreditAmount, tmpGlDebitAmount, tmpGlCreditAmount, total, map) : this.contrastByVoucherNum(tblCash, tblGL, tblCashSize, tblGLSize, tmpCashDebitAmount, tmpCashCreditAmount, tmpGlDebitAmount, tmpGlCreditAmount, total);
        this.sucessContrastTotal += total;
        StringBuffer msgStr = new StringBuffer(128);
        msgStr.append(EASResource.getString((String)resourcePath, (String)"SucessContrastTotal"));
        msgStr.append(total);
        msgStr.append(EASResource.getString((String)resourcePath, (String)"Group"));
        MsgBox.showInfo((Component)((Object)ui), (String)msgStr.toString());
        SysUtil.abort();
    }

    private int contrast(KDTable tblCash, KDTable tblGL, int tblCashSize, int tblGLSize, BigDecimal tmpCashDebitAmount, BigDecimal tmpCashCreditAmount, BigDecimal tmpGlDebitAmount, BigDecimal tmpGlCreditAmount, int total, Map map) {
        ArrayList<IRow> itemList = new ArrayList<IRow>();
        block0: for (int i = 0; i < tblCashSize; ++i) {
            IRow cashRow = tblCash.getRow(i);
            int flag = (Integer)cashRow.getCell("flag").getValue();
            if (flag != 0) continue;
            tmpCashDebitAmount = (BigDecimal)cashRow.getCell("debit").getValue();
            tmpCashCreditAmount = (BigDecimal)cashRow.getCell("credit").getValue();
            for (int j = 0; j < tblGLSize; ++j) {
                IRow glRow = tblGL.getRow(j);
                flag = (Integer)glRow.getCell("flag").getValue();
                if (flag != 0) continue;
                tmpGlDebitAmount = (BigDecimal)glRow.getCell("debit").getValue();
                tmpGlCreditAmount = (BigDecimal)glRow.getCell("credit").getValue();
                if (tmpCashDebitAmount.compareTo(tmpGlDebitAmount) != 0 || tmpCashCreditAmount.compareTo(tmpGlCreditAmount) != 0 || !this.isMeetOtherConditions(cashRow, glRow, map)) continue;
                cashRow.getStyleAttributes().setBackground(CasConstants.KDTABLE_GRAY_COLOR);
                cashRow.getCell("flag").setValue((Object)new Integer(1));
                glRow.getStyleAttributes().setBackground(CasConstants.KDTABLE_GRAY_COLOR);
                glRow.getCell("flag").setValue((Object)new Integer(1));
                itemList = new ArrayList();
                itemList.add(cashRow);
                itemList.add(glRow);
                cashRow.setUserObject(itemList);
                glRow.setUserObject(itemList);
                ++total;
                continue block0;
            }
        }
        return total;
    }

    private int contrastByVoucherNum(KDTable tblCash, KDTable tblGL, int tblCashSize, int tblGLSize, BigDecimal tmpCashDebitAmount, BigDecimal tmpCashCreditAmount, BigDecimal tmpGlDebitAmount, BigDecimal tmpGlCreditAmount, int total) {
        IRow glRow;
        BigDecimal[] sumAmount;
        int flag;
        IRow cashRow;
        HashMap<String, BigDecimal[]> cashGroupMap = new HashMap<String, BigDecimal[]>();
        HashMap<String, BigDecimal[]> glGroupMap = new HashMap<String, BigDecimal[]>();
        ArrayList<String> voucherNumbers = new ArrayList<String>();
        ArrayList<IRow> itemList = new ArrayList<IRow>();
        for (int i = 0; i < tblCashSize; ++i) {
            cashRow = tblCash.getRow(i);
            flag = (Integer)cashRow.getCell("flag").getValue();
            if (flag != 0) continue;
            tmpCashDebitAmount = (BigDecimal)cashRow.getCell("debit").getValue();
            tmpCashCreditAmount = (BigDecimal)cashRow.getCell("credit").getValue();
            String cashVoucherNumber = (String)cashRow.getCell("voucherNumber").getValue();
            if (cashGroupMap.containsKey(cashVoucherNumber)) {
                sumAmount = (BigDecimal[])cashGroupMap.get(cashVoucherNumber);
                sumAmount[0] = sumAmount[0].add(tmpCashDebitAmount);
                sumAmount[1] = sumAmount[1].add(tmpCashCreditAmount);
                cashGroupMap.put(cashVoucherNumber, sumAmount);
                continue;
            }
            sumAmount = new BigDecimal[]{tmpCashDebitAmount, tmpCashCreditAmount};
            cashGroupMap.put(cashVoucherNumber, sumAmount);
        }
        for (int j = 0; j < tblGLSize; ++j) {
            glRow = tblGL.getRow(j);
            flag = (Integer)glRow.getCell("flag").getValue();
            if (flag != 0) continue;
            tmpGlDebitAmount = (BigDecimal)glRow.getCell("debit").getValue();
            tmpGlCreditAmount = (BigDecimal)glRow.getCell("credit").getValue();
            String glVoucherNumber = (String)glRow.getCell("voucherNumber").getValue();
            if (glGroupMap.containsKey(glVoucherNumber)) {
                sumAmount = (BigDecimal[])glGroupMap.get(glVoucherNumber);
                sumAmount[0] = sumAmount[0].add(tmpGlDebitAmount);
                sumAmount[1] = sumAmount[1].add(tmpGlCreditAmount);
                glGroupMap.put(glVoucherNumber, sumAmount);
                continue;
            }
            sumAmount = new BigDecimal[]{tmpGlDebitAmount, tmpGlCreditAmount};
            glGroupMap.put(glVoucherNumber, sumAmount);
        }
        for (String cashVoucher : cashGroupMap.keySet()) {
            BigDecimal[] glBigDecimals;
            BigDecimal[] casBigDecimals;
            if (!glGroupMap.containsKey(cashVoucher) || (casBigDecimals = (BigDecimal[])cashGroupMap.get(cashVoucher))[0].compareTo((glBigDecimals = (BigDecimal[])glGroupMap.get(cashVoucher))[0]) != 0 || casBigDecimals[1].compareTo(glBigDecimals[1]) != 0) continue;
            voucherNumbers.add(cashVoucher);
        }
        total = voucherNumbers.size();
        for (String voucherNumber : voucherNumbers) {
            itemList = new ArrayList();
            for (int i = 0; i < tblCashSize; ++i) {
                cashRow = tblCash.getRow(i);
                String cashVoucherNumber = (String)cashRow.getCell("voucherNumber").getValue();
                if (!voucherNumber.equals(cashVoucherNumber)) continue;
                cashRow.getStyleAttributes().setBackground(CasConstants.KDTABLE_GRAY_COLOR);
                cashRow.getCell("flag").setValue((Object)new Integer(1));
                itemList.add(cashRow);
                cashRow.setUserObject(itemList);
            }
            for (int j = 0; j < tblGLSize; ++j) {
                glRow = tblGL.getRow(j);
                String glVoucherNumber = (String)glRow.getCell("voucherNumber").getValue();
                if (!voucherNumber.equals(glVoucherNumber)) continue;
                glRow.getStyleAttributes().setBackground(CasConstants.KDTABLE_GRAY_COLOR);
                glRow.getCell("flag").setValue((Object)new Integer(1));
                itemList.add(glRow);
                glRow.setUserObject(itemList);
            }
        }
        return total;
    }

    private boolean isMeetOtherConditions(IRow cashRow, IRow glRow, Map map) {
        boolean isDateEquals = false;
        boolean isDescriptionEquals = false;
        boolean isSettTypeEquals = false;
        boolean isSettNumberEquals = false;
        boolean isVoucherNumEquals = false;
        if (map != null && map.size() != 0) {
            isDateEquals = TypeConversionUtils.objToBoolean(map.get("chkDateEqual"));
            isDescriptionEquals = TypeConversionUtils.objToBoolean(map.get("chkDescriptionEqual"));
            isSettTypeEquals = TypeConversionUtils.objToBoolean(map.get("chkSettTypeEqual"));
            isSettNumberEquals = TypeConversionUtils.objToBoolean(map.get("chkSettNumberEqual"));
            isVoucherNumEquals = TypeConversionUtils.objToBoolean(map.get("chkVoucherNumEqual"));
        }
        boolean isEquals = false;
        Date cashCreateDate = CasTableHelper.getSqlDate(cashRow, "date");
        String cashVoucherNumber = CasTableHelper.getString(cashRow, "voucherNumber");
        String cashDescription = CasTableHelper.getString(cashRow, "description");
        String cashSettType = CasTableHelper.getString(cashRow, "settType");
        String cashSettNumber = CasTableHelper.getString(cashRow, "settNumber");
        Date glCreateDate = CasTableHelper.getSqlDate(glRow, "date");
        String glVoucherNumber = CasTableHelper.getString(glRow, "voucherNumber");
        String glDescription = CasTableHelper.getString(glRow, "description");
        String glSettType = CasTableHelper.getString(glRow, "settType");
        String glSettNumber = CasTableHelper.getString(glRow, "settNumber");
        isDateEquals = isDateEquals ? CashHelper.isEquals(cashCreateDate, glCreateDate) : true;
        isDescriptionEquals = isDescriptionEquals ? CashHelper.isEquals(cashDescription, glDescription) : true;
        isSettTypeEquals = isSettTypeEquals ? CashHelper.isEquals(cashSettType, glSettType) : true;
        isSettNumberEquals = isSettNumberEquals ? CashHelper.isEquals(cashSettNumber, glSettNumber) : true;
        isVoucherNumEquals = isVoucherNumEquals ? CashHelper.isEquals(cashVoucherNumber, glVoucherNumber) : true;
        isEquals = isDateEquals && isDescriptionEquals && isSettTypeEquals && isSettNumberEquals && isVoucherNumEquals;
        return isEquals;
    }

    public void manualContrast(KDTable tblCash, KDTable tblGL) {
        int tblCashSize = tblCash.getRowCount();
        int tblGLSize = tblGL.getRowCount();
        if (tblCashSize == 0 || tblGLSize == 0) {
            return;
        }
        int total = 0;
        boolean noSelect = false;
        block0: for (int i = 0; i < tblCashSize; ++i) {
            IRow cashRow = tblCash.getRow(i);
            noSelect = ((Boolean)cashRow.getCell("select").getValue()).equals(Boolean.FALSE);
            int flag = (Integer)cashRow.getCell("flag").getValue();
            if (flag != 0 || noSelect) continue;
            String cashVoucherType = (String)cashRow.getCell("voucherType").getValue();
            String cashVoucherNumber = (String)cashRow.getCell("voucherNumber").getValue();
            if (cashVoucherType != null || cashVoucherNumber != null) continue;
            BigDecimal cashDebitAmount = (BigDecimal)cashRow.getCell("debit").getValue();
            BigDecimal cashCreditAmount = (BigDecimal)cashRow.getCell("credit").getValue();
            if (cashDebitAmount == null) {
                cashDebitAmount = CasConstants.ZERO;
            }
            if (cashCreditAmount == null) {
                cashCreditAmount = CasConstants.ZERO;
            }
            for (int j = 0; j < tblGLSize; ++j) {
                IRow glRow = tblGL.getRow(j);
                noSelect = ((Boolean)glRow.getCell("select").getValue()).equals(Boolean.FALSE);
                if (noSelect) continue;
                String glVoucherType = (String)glRow.getCell("voucherType").getValue();
                String glVoucherNumber = (String)glRow.getCell("voucherNumber").getValue();
                BigDecimal glDebitAmount = (BigDecimal)glRow.getCell("debit").getValue();
                BigDecimal glCreditAmount = (BigDecimal)glRow.getCell("credit").getValue();
                if (glDebitAmount == null) {
                    glDebitAmount = CasConstants.ZERO;
                }
                if (glCreditAmount == null) {
                    glCreditAmount = CasConstants.ZERO;
                }
                if (cashDebitAmount.compareTo(glDebitAmount) != 0 || cashCreditAmount.compareTo(glCreditAmount) != 0) continue;
                cashRow.getStyleAttributes().setBackground(CasConstants.KDTABLE_GRAY_COLOR);
                glRow.getStyleAttributes().setBackground(CasConstants.KDTABLE_GRAY_COLOR);
                cashRow.getCell("flag").setValue((Object)new Integer(2));
                glRow.getCell("flag").setValue((Object)new Integer(2));
                cashRow.getCell("voucherType").setValue((Object)glVoucherType);
                cashRow.getCell("voucherNumber").setValue((Object)glVoucherNumber);
                ++total;
                continue block0;
            }
        }
        this.sucessContrastTotal += total;
    }

    public void manualContrast_New(KDTable tblCash, KDTable tblGL) {
        IRow glRow;
        int flag;
        IRow cashRow;
        int tblCashSize = tblCash.getRowCount();
        int tblGLSize = tblGL.getRowCount();
        if (tblCashSize == 0 || tblGLSize == 0) {
            return;
        }
        String cashVoucherType = null;
        String glVoucherType = null;
        String cashVoucherNumber = null;
        String glVoucherNumber = null;
        String tmpVoucherType = null;
        String tmpVoucherNumber = null;
        BigDecimal cashDebitAmount = CasConstants.ZERO;
        BigDecimal glDebitAmount = CasConstants.ZERO;
        BigDecimal cashCreditAmount = CasConstants.ZERO;
        BigDecimal glCreditAmount = CasConstants.ZERO;
        BigDecimal tmpDebitAmount = CasConstants.ZERO;
        BigDecimal tmpCreditAmount = CasConstants.ZERO;
        ArrayList<IRow> cashRowList = new ArrayList<IRow>();
        ArrayList<IRow> glRowList = new ArrayList<IRow>();
        boolean total = false;
        boolean noSelect = false;
        for (int i = 0; i < tblCashSize; ++i) {
            cashRow = tblCash.getRow(i);
            noSelect = ((Boolean)cashRow.getCell("select").getValue()).equals(Boolean.FALSE);
            flag = (Integer)cashRow.getCell("flag").getValue();
            if (flag != 0 || noSelect) continue;
            cashRowList.add(cashRow);
            cashVoucherType = "";
            cashVoucherNumber = "";
            tmpDebitAmount = (BigDecimal)cashRow.getCell("debit").getValue();
            tmpCreditAmount = (BigDecimal)cashRow.getCell("credit").getValue();
            if (tmpDebitAmount == null) {
                tmpDebitAmount = CasConstants.ZERO;
            }
            if (tmpCreditAmount == null) {
                tmpCreditAmount = CasConstants.ZERO;
            }
            cashDebitAmount = cashDebitAmount.add(tmpDebitAmount);
            cashCreditAmount = cashCreditAmount.add(tmpCreditAmount);
        }
        for (int j = 0; j < tblGLSize; ++j) {
            glRow = tblGL.getRow(j);
            noSelect = ((Boolean)glRow.getCell("select").getValue()).equals(Boolean.FALSE);
            flag = (Integer)glRow.getCell("flag").getValue();
            if (flag != 0 || noSelect) continue;
            glRowList.add(glRow);
            glVoucherType = "";
            glVoucherNumber = "";
            tmpDebitAmount = (BigDecimal)glRow.getCell("debit").getValue();
            tmpCreditAmount = (BigDecimal)glRow.getCell("credit").getValue();
            if (tmpDebitAmount == null) {
                tmpDebitAmount = CasConstants.ZERO;
            }
            if (tmpCreditAmount == null) {
                tmpCreditAmount = CasConstants.ZERO;
            }
            glDebitAmount = glDebitAmount.add(tmpDebitAmount);
            glCreditAmount = glCreditAmount.add(tmpCreditAmount);
            tmpVoucherType = glVoucherType;
            tmpVoucherNumber = glVoucherNumber;
        }
        if (cashDebitAmount.compareTo(glDebitAmount) == 0 && cashCreditAmount.compareTo(glCreditAmount) == 0 || cashDebitAmount.add(glCreditAmount).compareTo(cashCreditAmount.add(glDebitAmount)) == 0 || cashDebitAmount.compareTo(cashCreditAmount) == 0 && cashCreditAmount.compareTo(CasConstants.ZERO) != 0 || glDebitAmount.compareTo(glCreditAmount) == 0 && glDebitAmount.compareTo(CasConstants.ZERO) != 0) {
            int k;
            int i;
            ArrayList list = new ArrayList();
            for (i = 0; i < cashRowList.size(); ++i) {
                list.add(cashRowList.get(i));
            }
            for (i = 0; i < glRowList.size(); ++i) {
                list.add(glRowList.get(i));
            }
            for (k = 0; k < cashRowList.size(); ++k) {
                cashRow = (IRow)cashRowList.get(k);
                cashRow.getStyleAttributes().setBackground(CasConstants.KDTABLE_GRAY_COLOR);
                cashRow.getCell("flag").setValue((Object)new Integer(2));
                cashRow.setUserObject(list);
                cashRow.getCell("select").setValue((Object)new Boolean(false));
            }
            for (k = 0; k < glRowList.size(); ++k) {
                glRow = (IRow)glRowList.get(k);
                glRow.getStyleAttributes().setBackground(CasConstants.KDTABLE_GRAY_COLOR);
                glRow.getCell("flag").setValue((Object)new Integer(2));
                glRow.setUserObject(list);
                glRow.getCell("select").setValue((Object)new Boolean(false));
            }
            if (cashRowList.size() > 0 || glRowList.size() > 0) {
                ++this.sucessContrastTotal;
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"NoContrastCon"));
        }
    }

    public void autoSearch(KDTable tblCash, KDTable tblGL, CashContrastGLDetailUI ui, String capitalType, String bankAccount, String accountView, String period, String currencyName, BOSUuid currencyId) throws UIException {
        IRow glRow;
        boolean isDateEquals = false;
        boolean isDescriptionEquals = false;
        boolean isSettTypeEquals = false;
        boolean isSettNumberEquals = false;
        boolean isOppAccountEquals = false;
        boolean isVoucherNumEquals = false;
        Map map = this.getUIOptionMap();
        if (map != null && map.size() != 0) {
            isDateEquals = TypeConversionUtils.objToBoolean(map.get("chkDateEqual"));
            isDescriptionEquals = TypeConversionUtils.objToBoolean(map.get("chkDescriptionEqual"));
            isSettTypeEquals = TypeConversionUtils.objToBoolean(map.get("chkSettTypeEqual"));
            isSettNumberEquals = TypeConversionUtils.objToBoolean(map.get("chkSettNumberEqual"));
            isVoucherNumEquals = TypeConversionUtils.objToBoolean(map.get("chkVoucherNumEqual"));
            isOppAccountEquals = TypeConversionUtils.objToBoolean(map.get("chkOppAccountEqual"));
        }
        boolean isEquals = false;
        int tblCashSize = tblCash.getRowCount();
        int tblGLSize = tblGL.getRowCount();
        if (tblCashSize == 0 || tblGLSize == 0) {
            return;
        }
        ArrayList<IRow> resultColl = new ArrayList<IRow>();
        ArrayList<Integer> hasContrastCashList = new ArrayList<Integer>();
        ArrayList<Integer> hasContrastGLList = new ArrayList<Integer>();
        int total = 0;
        block0: for (int i = 0; i < tblCashSize; ++i) {
            String cashOppAccount;
            String cashSettNumber;
            String cashSettType;
            IRow cashRow;
            int flag;
            if (hasContrastCashList.contains(new Integer(i)) || (flag = ((Integer)(cashRow = tblCash.getRow(i)).getCell("flag").getValue()).intValue()) != 0) continue;
            String cashVoucherType = (String)cashRow.getCell("voucherType").getValue();
            String cashVoucherNumber = (String)cashRow.getCell("voucherNumber").getValue();
            if (cashVoucherNumber == null) {
                cashVoucherNumber = STR_NULL;
            }
            Date cashCreateDate = (Date)cashRow.getCell("date").getValue();
            String cashDescription = (String)cashRow.getCell("description").getValue();
            if (cashDescription == null) {
                cashDescription = STR_NULL;
            }
            if ((cashSettType = (String)cashRow.getCell("settType").getValue()) == null) {
                cashSettType = STR_NULL;
            }
            if ((cashSettNumber = (String)cashRow.getCell("settNumber").getValue()) == null) {
                cashSettNumber = STR_NULL;
            }
            if ((cashOppAccount = (String)cashRow.getCell("oppAccount").getValue()) == null) {
                cashOppAccount = STR_NULL;
            }
            BigDecimal cashDebitAmount = (BigDecimal)cashRow.getCell("debit").getValue();
            BigDecimal cashCreditAmount = (BigDecimal)cashRow.getCell("credit").getValue();
            if (cashDebitAmount == null) {
                cashDebitAmount = CasConstants.ZERO;
            }
            if (cashCreditAmount == null) {
                cashCreditAmount = CasConstants.ZERO;
            }
            for (int j = 0; j < tblGLSize; ++j) {
                if (hasContrastGLList.contains(new Integer(j)) || (flag = ((Integer)(glRow = tblGL.getRow(j)).getCell("flag").getValue()).intValue()) != 0) continue;
                BigDecimal glDebitAmount = (BigDecimal)glRow.getCell("debit").getValue();
                BigDecimal glCreditAmount = (BigDecimal)glRow.getCell("credit").getValue();
                if (glDebitAmount == null) {
                    glDebitAmount = CasConstants.ZERO;
                }
                if (glCreditAmount == null) {
                    glCreditAmount = CasConstants.ZERO;
                }
                boolean bl = isEquals = cashDebitAmount.compareTo(glDebitAmount) == 0 && cashCreditAmount.compareTo(glCreditAmount) == 0 && this.isMeetOtherConditions(cashRow, glRow, map);
                if (!isEquals) continue;
                resultColl.add(cashRow);
                resultColl.add(glRow);
                hasContrastCashList.add(new Integer(i));
                hasContrastGLList.add(new Integer(j));
                continue block0;
            }
        }
        List resultList = this.showContrastResult(ui, capitalType, bankAccount, accountView, period, currencyName, currencyId, resultColl);
        int listSize = resultList.size();
        for (int i = 0; i < listSize; ++i) {
            IRow row = (IRow)resultList.get(i);
            row.getStyleAttributes().setBackground(CasConstants.KDTABLE_GRAY_COLOR);
            row.getCell("flag").setValue((Object)new Integer(2));
            if (i % 2 != 0) continue;
            glRow = (IRow)resultList.get(i + 1);
            row.getCell("voucherType").setValue(glRow.getCell("voucherType").getValue());
            row.getCell("voucherNumber").setValue(glRow.getCell("voucherNumber").getValue());
            ++total;
        }
        this.sucessContrastTotal += total;
    }

    private List showContrastResult(CashContrastGLDetailUI ui, String capitalType, String bankAccount, String accountView, String period, String currencyName, BOSUuid currencyId, List resultColl) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"resultColl", (Object)resultColl);
        uiContext.put((Object)"capitalType", (Object)capitalType);
        uiContext.put((Object)"bankAccount", (Object)bankAccount);
        uiContext.put((Object)"accountView", (Object)accountView);
        uiContext.put((Object)"period", (Object)period);
        uiContext.put((Object)"currencyName", (Object)currencyName);
        uiContext.put((Object)"currencyId", (Object)currencyId);
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(CashContrastGLDetailResultUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        wnd.show();
        CashContrastGLDetailResultUI cashContrastGLDetailResultUI = (CashContrastGLDetailResultUI)wnd.getUIObject();
        return cashContrastGLDetailResultUI.getResultList();
    }

    public void showHasContrast(KDTable tblCash, KDTable tblGL) {
        int i;
        int tblCashSize = tblCash.getRowCount();
        int tblGLSize = tblGL.getRowCount();
        if (tblCashSize == 0 || tblGLSize == 0) {
            return;
        }
        int flag = 0;
        for (i = 0; i < tblCashSize; ++i) {
            IRow cashRow = tblCash.getRow(i);
            flag = (Integer)cashRow.getCell("flag").getValue();
            if (flag == 0) {
                cashRow.getStyleAttributes().setHided(true);
                continue;
            }
            cashRow.getStyleAttributes().setHided(false);
        }
        for (i = 0; i < tblGLSize; ++i) {
            IRow glRow = tblGL.getRow(i);
            flag = (Integer)glRow.getCell("flag").getValue();
            if (flag == 0) {
                glRow.getStyleAttributes().setHided(true);
                continue;
            }
            glRow.getStyleAttributes().setHided(false);
        }
    }

    public void showUnContrast(KDTable tblCash, KDTable tblGL) {
        int i;
        int tblCashSize = tblCash.getRowCount();
        int tblGLSize = tblGL.getRowCount();
        if (tblCashSize == 0 || tblGLSize == 0) {
            return;
        }
        int flag = 0;
        for (i = 0; i < tblCashSize; ++i) {
            IRow cashRow = tblCash.getRow(i);
            flag = (Integer)cashRow.getCell("flag").getValue();
            if (flag == 0) {
                cashRow.getStyleAttributes().setHided(false);
                continue;
            }
            cashRow.getStyleAttributes().setHided(true);
        }
        for (i = 0; i < tblGLSize; ++i) {
            IRow glRow = tblGL.getRow(i);
            flag = (Integer)glRow.getCell("flag").getValue();
            if (flag == 0) {
                glRow.getStyleAttributes().setHided(false);
                continue;
            }
            glRow.getStyleAttributes().setHided(true);
        }
    }

    public void showAll(KDTable tblCash, KDTable tblGL) {
        int i;
        int tblCashSize = tblCash.getRowCount();
        int tblGLSize = tblGL.getRowCount();
        if (tblCashSize == 0 || tblGLSize == 0) {
            return;
        }
        for (i = 0; i < tblCashSize; ++i) {
            tblCash.getRow(i).getStyleAttributes().setHided(false);
        }
        for (i = 0; i < tblGLSize; ++i) {
            tblGL.getRow(i).getStyleAttributes().setHided(false);
        }
    }

    public void cancleContrast(KDTable tblCash, KDTable tblGL) {
        String system;
        int k;
        List list;
        Integer flag;
        int i;
        int tblCashSize = tblCash.getRowCount();
        int tblGLSize = tblGL.getRowCount();
        if (tblCashSize == 0 || tblGLSize == 0) {
            return;
        }
        boolean noSelect = false;
        for (i = 0; i < tblCashSize; ++i) {
            IRow cashRow = tblCash.getRow(i);
            noSelect = ((Boolean)cashRow.getCell("select").getValue()).equals(Boolean.FALSE);
            flag = (Integer)cashRow.getCell("flag").getValue();
            if (noSelect || flag == 0 || !(cashRow.getUserObject() instanceof List)) continue;
            list = (List)cashRow.getUserObject();
            for (k = 0; k < list.size(); ++k) {
                cashRow = (IRow)list.get(k);
                system = (String)cashRow.getCell("system").getValue();
                if (flag == 2 && system.equals(EASResource.getString((String)resourcePath, (String)"CashSystem"))) {
                    cashRow.getCell("voucherType").setValue(null);
                    cashRow.getCell("voucherNumber").setValue(null);
                }
                cashRow.getStyleAttributes().setBackground(CasConstants.KDTABLE_WHITE_COLOR);
                cashRow.getCell("flag").setValue((Object)new Integer(0));
                cashRow.getCell("select").setValue((Object)new Boolean(false));
            }
            --this.sucessContrastTotal;
        }
        for (i = 0; i < tblGLSize; ++i) {
            IRow glRow = tblGL.getRow(i);
            noSelect = ((Boolean)glRow.getCell("select").getValue()).equals(Boolean.FALSE);
            flag = (Integer)glRow.getCell("flag").getValue();
            if (noSelect || flag == 0 || !(glRow.getUserObject() instanceof List)) continue;
            list = (List)glRow.getUserObject();
            --this.sucessContrastTotal;
            for (k = 0; k < list.size(); ++k) {
                glRow = (IRow)list.get(k);
                system = (String)glRow.getCell("system").getValue();
                if (flag == 2 && system.equals(EASResource.getString((String)resourcePath, (String)"CashSystem"))) {
                    glRow.getCell("voucherType").setValue(null);
                    glRow.getCell("voucherNumber").setValue(null);
                }
                glRow.getStyleAttributes().setBackground(CasConstants.KDTABLE_WHITE_COLOR);
                glRow.getCell("flag").setValue((Object)new Integer(0));
                glRow.getCell("select").setValue((Object)new Boolean(false));
            }
        }
        tblCash.reLayoutAndPaint();
        tblGL.reLayoutAndPaint();
    }

    public void contrastDiffRpt(CashContrastGLDetailUI ui, KDTable tblCash, KDTable tblGL, BOSUuid currencyId) throws UIException {
        int i;
        int tblCashSize = tblCash.getRowCount();
        int tblGLSize = tblGL.getRowCount();
        if (tblCashSize == 0 && tblGLSize == 0) {
            return;
        }
        ArrayList<IRow> resultColl = new ArrayList<IRow>();
        int flag = 1;
        for (i = 0; i < tblCashSize; ++i) {
            IRow cashRow = tblCash.getRow(i);
            flag = (Integer)cashRow.getCell("flag").getValue();
            if (flag != 0) continue;
            resultColl.add(cashRow);
        }
        for (i = 0; i < tblGLSize; ++i) {
            IRow glRow = tblGL.getRow(i);
            flag = (Integer)glRow.getCell("flag").getValue();
            if (flag != 0) continue;
            resultColl.add(glRow);
        }
        this.showDiffRptUI(ui, resultColl, currencyId);
    }

    private void showDiffRptUI(CashContrastGLDetailUI ui, List resultColl, BOSUuid currencyId) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"resultColl", (Object)resultColl);
        uiContext.put((Object)"currencyId", (Object)currencyId);
        uiContext.put((Object)"sucessContrastTotal", (Object)new Integer(this.getSucessContrastTotal()));
        IUIFactory fy = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow wnd = fy.create(CashContrastGLDetailDiffRptUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        wnd.show();
    }

    public void setCurrencyFormat(KDTable tblCash, KDTable tblGL, BOSUuid currencyId) {
        String numberFtm = FMClientHelper.getNumberFtm((BOSUuid)currencyId);
        tblCash.getColumn("debit").getStyleAttributes().setNumberFormat(numberFtm);
        tblCash.getColumn("credit").getStyleAttributes().setNumberFormat(numberFtm);
        tblCash.getColumn("debit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblCash.getColumn("credit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblGL.getColumn("debit").getStyleAttributes().setNumberFormat(numberFtm);
        tblGL.getColumn("credit").getStyleAttributes().setNumberFormat(numberFtm);
        tblGL.getColumn("debit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        tblGL.getColumn("credit").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
    }
}

