/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.NewCompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CasContrastGLFilterParam;
import com.kingdee.eas.fi.cas.CashContrastGLUIFetchDataFacadeFactory;
import com.kingdee.eas.fi.cas.client.AbstractCashContrastGLFilterUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SpinnerModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class CashContrastGLFilterUI
extends AbstractCashContrastGLFilterUI {
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CasResources";
    private static Logger logger = Logger.getLogger((String)CashContrastGLFilterUI.class.getName());
    private CompanyOrgUnitInfo company = null;
    private Integer year;
    private Calendar calendar;
    private boolean isLoaded;
    private String acctTableId = null;
    Map paramMap = new HashMap();

    public CashContrastGLFilterUI(Map paramMap1) throws Exception {
        this.paramMap = paramMap1;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (!this.isLoaded) {
            this.init();
        }
        this.isLoaded = true;
        this.chkIA.setVisible(false);
        this.btnCompanySelect.setVisible(false);
        this.spPeriodNum.setVisible(true);
        this.lblPeriodNum.setEnabled(true);
        this.lblPeriodYear.setEnabled(true);
    }

    protected void init() throws Exception {
        NewCompanyF7 f7Selector = new NewCompanyF7();
        f7Selector.setUIActionPK((IMetaDataPK)new MetaDataPK("com.kingdee.eas.fi.cas.client", "CashContrastGLUI"), (IMetaDataPK)new MetaDataPK("ActionOnLoad"));
        this.prmtCompany.setSelector((KDPromptSelector)f7Selector);
        CompanyOrgUnitInfo curCompany = SysContext.getSysContext().getCurrentFIUnit();
        if (curCompany.isIsBizUnit()) {
            IPermission iPermisson = PermissionFactory.getRemoteInstance();
            boolean flag = iPermisson.hasFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId().toString()), (IObjectPK)new ObjectUuidPK(curCompany.getId().toString()), "cas_cashcontrastGL_01view");
            if (flag) {
                this.company = curCompany;
                this.prmtCompany.setValue((Object)this.company);
            } else {
                this.company = this.getCompanyOrgUnitInfoByUserPermisson();
                this.prmtCompany.setValue((Object)this.company);
            }
        } else {
            this.company = this.getCompanyOrgUnitInfoByUserPermisson();
            this.prmtCompany.setValue((Object)this.company);
        }
        ClientUtils.checkCompany((Component)((Object)this), this.company);
        if (this.company != null && this.company.isIsBizUnit()) {
            PeriodInfo startPeriodInfo = null;
            startPeriodInfo = ClientUtils.getStartPeriodInfo((Component)((Object)this), this.company);
            if (startPeriodInfo == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"StartPeriod_NullMsg"));
                SysUtil.abort();
            }
            this.setStateByDate(false);
            this.setStateByPeriod(true);
            this.radioPeriod.setSelected(true);
        }
        this.ckbCancleAccountBank.setSelected(false);
    }

    public void clear() {
        super.clear();
        try {
            this.init();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    protected void spPeriodYear_stateChanged(ChangeEvent e) throws Exception {
        super.spPeriodYear_stateChanged(e);
        this.spPeriodNum.setModel((SpinnerModel)PeriodHelper.getMonthSnm(this.company, (Integer)this.spPeriodYear.getValue()));
    }

    private void setStateByDate(boolean bln) {
        this.lblDate.setVisible(bln);
        this.dateEndDate.setVisible(bln);
    }

    private void setStateByPeriod(boolean bln) {
        this.lblPeriodYear.setVisible(bln);
        this.spPeriodYear.setVisible(bln);
        this.lblPeriodNum.setVisible(bln);
        this.spPeriodNum.setVisible(bln);
    }

    @Override
    protected void radioDate_stateChanged(ChangeEvent e) throws Exception {
        super.radioDate_stateChanged(e);
        if (this.radioDate.isSelected()) {
            this.setStateByDate(true);
            this.setStateByPeriod(false);
        }
    }

    @Override
    protected void radioPeriod_stateChanged(ChangeEvent e) throws Exception {
        super.radioPeriod_stateChanged(e);
        if (this.radioPeriod.isSelected()) {
            this.setStateByDate(false);
            this.setStateByPeriod(true);
        }
    }

    public Object getParam() {
        CasContrastGLFilterParam param = new CasContrastGLFilterParam();
        param.setCompanyInfo((CompanyOrgUnitInfo)this.prmtCompany.getData());
        if (this.spPeriodYear.getValue() != null) {
            param.setPeriodYear((Integer)this.spPeriodYear.getValue());
        }
        if (this.spPeriodNum.getValue() != null) {
            param.setPeriodNum((Integer)this.spPeriodNum.getValue());
        }
        if (this.dateEndDate.getSqlDate() != null) {
            Date createDate = DateHelper.getSQLBegin((java.util.Date)this.dateEndDate.getSqlDate());
            param.setContrastDate(createDate);
            if (this.radioDate.isSelected()) {
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(createDate);
                param.setPeriodYear(cal.get(1));
                param.setPeriodNum(cal.get(2) + 1);
            }
        }
        param.setUnTranVoucher(this.ckbUnTranVoucher.isSelected());
        param.setCancleAccountBank(this.ckbCancleAccountBank.isSelected());
        if (this.radioDate.isSelected()) {
            param.setContrastType(3);
        } else if (this.radioPeriod.isSelected()) {
            param.setContrastType(4);
        }
        param.setAcctTableId(this.acctTableId);
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof CasContrastGLFilterParam)) {
            return;
        }
        CasContrastGLFilterParam casParam = (CasContrastGLFilterParam)param;
        switch (casParam.getContrastType()) {
            case 3: {
                this.radioDate.setSelected(true);
                try {
                    this.radioDate_stateChanged(null);
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
                break;
            }
            case 4: {
                this.radioPeriod.setSelected(true);
                try {
                    this.radioPeriod_stateChanged(null);
                    break;
                }
                catch (Exception e) {
                    ExceptionHandler.handle((Throwable)e);
                }
            }
        }
        this.dateEndDate.setValue((Object)casParam.getContrastDate());
        this.spPeriodYear.setValue((Object)new Integer(casParam.getPeriodYear()));
        this.spPeriodNum.setValue((Object)new Integer(casParam.getPeriodNum()));
        this.ckbUnTranVoucher.setSelected(casParam.isUnTranVoucher());
        this.prmtCompany.setValue((Object)casParam.getCompanyInfo());
        this.ckbCancleAccountBank.setSelected(casParam.isCancleAccountBank());
    }

    public boolean verify() {
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtCompany);
        if (!this.hasDate()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"WARNING_QUERY_DateRange"));
            return false;
        }
        String strCheck = this.getCheckMessage();
        if (strCheck != null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)strCheck));
            return false;
        }
        PeriodInfo glPeriod = null;
        try {
            boolean fGLStart = false;
            fGLStart = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.company);
            if (!fGLStart) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckGLStart"));
                return false;
            }
            glPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.company);
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        PeriodCollection commonPeriodColl = null;
        try {
            ClientUtils.checkCashGLPeriod((Component)((Object)this), this.company);
            commonPeriodColl = ClientUtils.getCashGlPeriod(this.company);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        int size = commonPeriodColl.size();
        PeriodInfo beginPeriod = commonPeriodColl.get(0);
        PeriodInfo endPeriod = commonPeriodColl.get(size - 1);
        int glYear = glPeriod.getPeriodYear();
        int glNum = glPeriod.getPeriodNumber();
        if (this.radioPeriod.isSelected()) {
            int spYear = (Integer)this.spPeriodYear.getValue();
            int spNum = (Integer)this.spPeriodNum.getValue();
            if (spYear > glYear || spYear == glYear && spNum > glNum) {
                MsgBox.showInfo((Component)((Object)this), (String)FMClientHelper.formatMessage((String)resourcePath, (String)"CheckGLPeriod", (Object[])new String[]{new Integer(glYear).toString(), new Integer(glNum).toString()}));
                return false;
            }
            int beginYear = beginPeriod.getPeriodYear();
            int beginNum = beginPeriod.getPeriodNumber();
            int endYear = endPeriod.getPeriodYear();
            int endNum = endPeriod.getPeriodNumber();
            if (spYear < beginYear || spYear == beginYear && spNum < beginNum || spYear > endYear || spYear == endYear && spNum > endNum) {
                MsgBox.showInfo((Component)((Object)this), (String)FMClientHelper.formatMessage((String)resourcePath, (String)"checkCashGLPeriod", (Object[])new String[]{beginPeriod.toString(), endPeriod.toString()}));
                return false;
            }
        }
        if (this.radioDate.isSelected()) {
            if (this.dateEndDate.getSqlDate().compareTo(glPeriod.getEndDate()) > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)FMClientHelper.formatMessage((String)resourcePath, (String)"CheckGLPeriod", (Object[])new String[]{new Integer(glYear).toString(), new Integer(glNum).toString()}));
                return false;
            }
            if (this.dateEndDate.getSqlDate().compareTo(beginPeriod.getBeginDate()) < 0 || this.dateEndDate.getSqlDate().compareTo(endPeriod.getEndDate()) > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)FMClientHelper.formatMessage((String)resourcePath, (String)"checkCashGLPeriod", (Object[])new String[]{beginPeriod.toString(), endPeriod.toString()}));
                return false;
            }
        }
        Map hmVer = new HashMap<String, Comparable<java.util.Date>>();
        if (this.radioDate.isSelected()) {
            hmVer.put("date", this.dateEndDate.getSqlDate());
        } else if (this.radioPeriod.isSelected()) {
            hmVer.put("periodYear", (Integer)this.spPeriodYear.getValue());
            hmVer.put("periodNumber", (Integer)this.spPeriodNum.getValue());
        }
        hmVer.put("filterPeriod", null);
        try {
            hmVer = CashContrastGLUIFetchDataFacadeFactory.getRemoteInstance().fetchDataForVerify(hmVer);
        }
        catch (Exception e) {
            MsgBox.showWarning((Component)((Object)this), (String)e.getMessage());
            SysUtil.abort((Throwable)e);
        }
        this.paramMap.put("filterPeriod", hmVer.get("filterPeriod"));
        if (this.radioDate.isSelected()) {
            Date date = this.dateEndDate.getSqlDate();
            if (hmVer.get("acctTableId") == null) {
                try {
                    PeriodInfo period = PeriodUtils.getPeriodInfo((java.util.Date)date, (CompanyOrgUnitInfo)this.currentCompany);
                    this.acctTableId = AccountTools.getCurrentAcctTable((String)this.currentCompany.getId().toString(), (String)this.currentCompany.getAccountTable().getId().toString(), (int)period.getPeriodYear(), (int)period.getPeriodNumber());
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            } else {
                this.acctTableId = (String)hmVer.get("acctTableId");
            }
        } else if (this.radioPeriod.isSelected()) {
            if (hmVer.get("acctTableId") == null) {
                int periodYear = (Integer)this.spPeriodYear.getValue();
                int periodNumber = (Integer)this.spPeriodNum.getValue();
                try {
                    this.acctTableId = AccountTools.getCurrentAcctTable((String)this.currentCompany.getId().toString(), (String)this.currentCompany.getAccountTable().getId().toString(), (int)periodYear, (int)periodNumber);
                }
                catch (EASBizException e) {
                    e.printStackTrace();
                }
                catch (BOSException e) {
                    e.printStackTrace();
                }
            } else {
                this.acctTableId = (String)hmVer.get("acctTableId");
            }
        }
        return true;
    }

    private boolean hasDate() {
        if (this.radioPeriod.isSelected()) {
            if (this.spPeriodYear.getValue() != null && this.spPeriodNum.getValue() != null) {
                return true;
            }
            this.spPeriodYear.grabFocus();
            this.spPeriodNum.grabFocus();
            return false;
        }
        if (this.radioDate.isSelected()) {
            if (this.dateEndDate.getSqlDate() != null) {
                return true;
            }
            this.dateEndDate.grabFocus();
            return false;
        }
        return true;
    }

    private String getCheckMessage() {
        PeriodInfo currentPeriod = null;
        try {
            currentPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company);
        }
        catch (EASBizException e) {
            logger.error((Object)e);
        }
        catch (BOSException e) {
            logger.error((Object)e);
        }
        if (this.radioPeriod.isSelected()) {
            int currentYear = currentPeriod.getPeriodYear();
            int spYear = (Integer)this.spPeriodYear.getValue();
            int currentNum = currentPeriod.getPeriodNumber();
            int spNum = (Integer)this.spPeriodNum.getValue();
            if (spYear > currentYear || spYear == currentYear && spNum > currentNum) {
                return "CheckPeriod";
            }
            this.spPeriodYear.grabFocus();
            this.spPeriodNum.grabFocus();
            return null;
        }
        if (this.radioDate.isSelected()) {
            if (DateHelper.getSQLBegin((java.util.Date)this.dateEndDate.getSqlDate()).compareTo(DateHelper.getSQLBegin((java.util.Date)currentPeriod.getEndDate())) > 0) {
                return "CheckDate";
            }
            this.dateEndDate.grabFocus();
            return null;
        }
        return null;
    }

    protected Class getParamClass() {
        return CasContrastGLFilterParam.class;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson() throws Exception {
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        CompanyOrgUnitCollection coll = FMHelper.getUserOrgRangesWithRange(null, (String)"cas_cashcontrastGL_01view");
        for (int i = 0; i < coll.size(); ++i) {
            PeriodInfo startPeriod;
            CompanyOrgUnitInfo info = coll.get(i);
            if (!info.isIsBizUnit() || info.isIsOUSealUp() || info.isIsAssistantOrg() || null == (startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info))) continue;
            companyColl.add(info);
        }
        if (companyColl.size() > 0) {
            return companyColl.get(0);
        }
        return null;
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtCompany.getValue() == null || e.getNewValue() == e.getOldValue()) {
            return;
        }
        this.company = (CompanyOrgUnitInfo)this.prmtCompany.getData();
        if (!this.company.isIsBizUnit()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"432_BankBalanceAdjustmentBFilterUI"));
            this.prmtCompany.setData(e.getOldValue());
            SysUtil.abort();
        }
        PeriodHelper.initPeriodSpinner(this.company, this.spPeriodYear, this.spPeriodNum);
    }
}

