/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.ext.IFilterInfoProducer;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.core.fm.ClientVerifyHelper;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.NewOrgViewF7PromptDialog;
import com.kingdee.eas.basedata.org.client.f7.NewHROF7;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.client.AbstractCashContrastGLSumFilterUI;
import com.kingdee.eas.fi.cas.client.CashContrastGLSumFilterParam;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.ISharedOrgSupport;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.ContextTypeEnum;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class CashContrastGLSumFilterUI
extends AbstractCashContrastGLSumFilterUI
implements ISharedOrgSupport {
    private static final Logger logger = CoreUIObject.getLogger(CashContrastGLSumFilterUI.class);
    private CompanyOrgUnitInfo company = null;
    private boolean isSharedOrg = false;
    private static final String resource = "com.kingdee.eas.fi.cas.CasResources";

    public Object getParam() {
        int i;
        CompanyOrgUnitInfo[] tmp;
        CashContrastGLSumFilterParam param = new CashContrastGLSumFilterParam();
        CompanyOrgUnitInfo[] companys = null;
        if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo) {
            this.company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
            companys = new CompanyOrgUnitInfo[]{this.company};
        } else if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo[]) {
            tmp = (CompanyOrgUnitInfo[])this.prmtCompany.getValue();
            companys = new CompanyOrgUnitInfo[tmp.length];
            for (i = 0; i < companys.length; ++i) {
                companys[i] = tmp[i];
            }
        } else if (this.prmtCompany.getValue() instanceof OrgUnitInfo[]) {
            tmp = (OrgUnitInfo[])this.prmtCompany.getValue();
            companys = new CompanyOrgUnitInfo[tmp.length];
            for (i = 0; i < companys.length; ++i) {
                companys[i] = tmp[i];
            }
        }
        HashSet<String> companySet = new HashSet<String>();
        if (companys != null) {
            for (i = 0; i < companys.length; ++i) {
                companySet.add(companys[i].getId().toString());
            }
        }
        param.setCompanySet(companySet);
        int spYear = (Integer)this.spPeriodYear.getValue();
        int spNum = (Integer)this.spPeriodNum.getValue();
        param.setYear(spYear);
        param.setSpNum(spNum);
        param.setCurrency((CurrencyInfo)this.cboCurrency.getSelectedItem());
        param.setCancleAccountBank(this.ckbCancleAccountBank.isSelected());
        param.setUnBalance(this.ckbUnBalance.isSelected());
        param.setUnTranVoucher(this.ckbUnTranVoucher.isSelected());
        return param;
    }

    public void setParam(Object param) {
        try {
            if (param == null) {
                return;
            }
            CashContrastGLSumFilterParam casParam = (CashContrastGLSumFilterParam)param;
            Set<String> companySet = casParam.getCompanySet();
            CompanyOrgUnitInfo[] companys = new CompanyOrgUnitInfo[companySet.size()];
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("*"));
            view.setSelector(selector);
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", companySet, CompareType.INCLUDE));
            view.setFilter(filter);
            CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
            for (int i = 0; i < coll.size(); ++i) {
                companys[i] = coll.get(i);
            }
            this.prmtCompany.setValue((Object)companys);
            this.spPeriodYear.setValue((Object)casParam.getYear());
            this.spPeriodNum.setValue((Object)casParam.getSpNum());
            this.cboCurrency.setSelectedItem((Object)casParam.getCurrency());
            this.ckbCancleAccountBank.setSelected(casParam.isCancleAccountBank());
            this.ckbUnBalance.setSelected(casParam.isUnBalance());
            this.ckbUnTranVoucher.setSelected(casParam.isUnTranVoucher());
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
    }

    protected void setDefaultValue() {
        try {
            this.prmtCompany.setValue((Object)this.getCompanyOrgUnitInfoByUserPermisson());
            this.initPeriod();
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        this.ckbUnTranVoucher.setSelected(false);
        this.ckbCancleAccountBank.setSelected(false);
        this.ckbUnBalance.setSelected(false);
    }

    protected void init() throws EASBizException, BOSException {
        this.initMainOrgF7();
        this.prmtCompany.setValue((Object)this.getCompanyOrgUnitInfoByUserPermisson());
        this.initPeriod();
        FMClientHelper.initCurrency((KDComboBox)this.cboCurrency);
        CompanyOrgUnitInfo company = SysContext.getSysContext().getCurrentFIUnit();
        UIUtil.setSelectObject((KDComboBox)this.cboCurrency, (Object)ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(company));
    }

    @Override
    protected void prmtCompany_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo) {
            this.company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        } else if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo[]) {
            CompanyOrgUnitInfo[] companys = (CompanyOrgUnitInfo[])this.prmtCompany.getValue();
            this.company = companys[0];
        } else if (this.prmtCompany.getValue() instanceof OrgUnitInfo[]) {
            OrgUnitInfo[] companys = (OrgUnitInfo[])this.prmtCompany.getValue();
            this.company = (CompanyOrgUnitInfo)companys[0];
        } else {
            return;
        }
        if (!this.company.isIsBizUnit()) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"432_BankBalanceAdjustmentBFilterUI"));
            this.prmtCompany.setData(e.getOldValue());
            SysUtil.abort();
        }
        this.initPeriod();
    }

    protected void initPeriod() throws EASBizException, BOSException {
        CompanyOrgUnitInfo[] companys;
        if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo) {
            this.company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        } else if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo[]) {
            companys = (CompanyOrgUnitInfo[])this.prmtCompany.getValue();
            this.company = companys[0];
        } else if (this.prmtCompany.getValue() instanceof OrgUnitInfo[]) {
            companys = (OrgUnitInfo[])this.prmtCompany.getValue();
            this.company = companys[0];
        } else {
            return;
        }
        ClientUtils.checkCompany((Component)((Object)this), this.company);
        if (this.company != null && this.company.isIsBizUnit()) {
            PeriodInfo startPeriodInfo = null;
            startPeriodInfo = ClientUtils.getStartPeriodInfo((Component)((Object)this), this.company);
            if (startPeriodInfo == null) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resource, (String)"StartPeriod_NullMsg"));
                SysUtil.abort();
            }
            if (this.company != null && this.company.isIsBizUnit()) {
                PeriodHelper.initPeriodSpinner(this.company, this.spPeriodYear, this.spPeriodNum);
            }
        }
    }

    @Override
    protected void spPeriodYear_stateChanged(ChangeEvent e) throws Exception {
        PeriodHelper.setPeriodNum(this.company, this.spPeriodNum, (Integer)this.spPeriodYear.getValue());
    }

    protected void initMainOrgF7() {
        if (this.getMainOrg() == null) {
            return;
        }
        KDBizPromptBox bizOrgUnitBox = this.getMainOrg();
        this.getMainOrg().setQueryInfo("com.kingdee.eas.basedata.org.app.CompanyOrgUnitQuery");
        if (bizOrgUnitBox != null) {
            NewOrgUnitFilterInfoProducer iProducer = null;
            String permissionItem = this.getPermissionItem();
            if (ContextTypeEnum.INQUERYING.equals((Object)this.getUIContext())) {
                NewHROF7 model = null;
                if (this.getMainOrgType().equals((Object)OrgType.HRO)) {
                    model = new NewHROF7();
                }
                iProducer = this.isSupportVirturalOrgs() ? new NewOrgUnitFilterInfoProducer(this.getMainOrgType()) : (model != null ? new NewOrgUnitFilterInfoProducer((NewOrgViewF7PromptDialog)model) : new NewOrgUnitFilterInfoProducer(this.getMainOrgType()));
            } else {
                iProducer = new NewOrgUnitFilterInfoProducer(this.getMainOrgType());
            }
            if (iProducer != null) {
                if (permissionItem != null) {
                    iProducer.getModel().setPermissionItem(permissionItem);
                }
                bizOrgUnitBox.setFilterInfoProducer((IFilterInfoProducer)iProducer);
                if (iProducer.getModel() != null) {
                    bizOrgUnitBox.setSelector((KDPromptSelector)iProducer.getModel());
                    iProducer.getModel().setMultiSelect(this.isSupportMultiOrgs());
                }
            }
            bizOrgUnitBox.setCommitFormat("$number$;$code$");
            bizOrgUnitBox.setEditFormat("$number$");
            bizOrgUnitBox.setDisplayFormat("$name$");
            bizOrgUnitBox.setEnabledMultiSelection(this.isSupportMultiOrgs());
            if (this.getMainOrgType().equals((Object)OrgType.HRO)) {
                bizOrgUnitBox.setQueryInfo("com.kingdee.eas.basedata.org.app.HROrgUnitQuery");
            }
        }
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfoByUserPermisson() throws EASBizException, BOSException {
        CompanyOrgUnitCollection companyColl = new CompanyOrgUnitCollection();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        CompanyOrgUnitCollection coll = FMHelper.getUserOrgRangesWithRange(null, (String)"cas_cashcontrastGL_01view");
        for (int i = 0; i < coll.size(); ++i) {
            CompanyOrgUnitInfo info = coll.get(i);
            if (!info.isIsBizUnit() || info.isIsOUSealUp() || info.isIsAssistantOrg()) continue;
            PeriodInfo startPeriod = SystemStatusCtrolUtils.getStartPeriod(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)info);
            if (null != startPeriod) {
                companyColl.add(info);
            }
            if (companyInfo == null || !companyInfo.getId().toString().equals(info.getId().toString())) continue;
            return info;
        }
        if (companyColl.size() > 0) {
            return companyColl.get(0);
        }
        return null;
    }

    public KDBizPromptBox getMainOrg() {
        return this.prmtCompany;
    }

    public boolean isSupportMultiOrgs() {
        return this.isSharedOrg();
    }

    public boolean verify() {
        int i;
        CompanyOrgUnitInfo[] tmp;
        ClientVerifyHelper.verifyEmpty((CoreUIObject)this, (String)"com.kingdee.eas.fm.common.FMResource", (KDBizPromptBox)this.prmtCompany, (String)"noCompany");
        if (!this.hasDate()) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resource, (String)"WARNING_QUERY_DateRange"));
            return false;
        }
        CompanyOrgUnitInfo[] companys = null;
        if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo) {
            this.company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
            companys = new CompanyOrgUnitInfo[]{this.company};
        } else if (this.prmtCompany.getValue() instanceof CompanyOrgUnitInfo[]) {
            tmp = (CompanyOrgUnitInfo[])this.prmtCompany.getValue();
            companys = new CompanyOrgUnitInfo[tmp.length];
            for (i = 0; i < companys.length; ++i) {
                companys[i] = tmp[i];
            }
        } else if (this.prmtCompany.getValue() instanceof OrgUnitInfo[]) {
            tmp = (OrgUnitInfo[])this.prmtCompany.getValue();
            companys = new CompanyOrgUnitInfo[tmp.length];
            for (i = 0; i < companys.length; ++i) {
                companys[i] = tmp[i];
            }
        }
        if (companys != null) {
            for (int i2 = 0; i2 < companys.length; ++i2) {
                this.company = companys[i2];
                PeriodInfo glPeriod = null;
                try {
                    boolean fGLStart = false;
                    fGLStart = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.company);
                    if (!fGLStart) {
                        String CheckGLStart = EASResource.getString((String)resource, (String)"CheckGLStart");
                        MsgBox.showWarning((Component)((Object)this), (String)(this.company.getName() + ": " + CheckGLStart));
                        return false;
                    }
                    glPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.company);
                }
                catch (EASBizException e) {
                    this.handUIException(e);
                }
                catch (BOSException e) {
                    this.handUIException(e);
                }
                PeriodCollection commonPeriodColl = null;
                try {
                    ClientUtils.checkCashGLPeriod((Component)((Object)this), this.company);
                    commonPeriodColl = ClientUtils.getCashGlPeriod(this.company);
                }
                catch (EASBizException e) {
                    logger.error((Object)e);
                }
                catch (BOSException e) {
                    logger.error((Object)e);
                }
                int size = commonPeriodColl.size();
                PeriodInfo beginPeriod = commonPeriodColl.get(0);
                PeriodInfo endPeriod = commonPeriodColl.get(size - 1);
                int glYear = glPeriod.getPeriodYear();
                int glNum = glPeriod.getPeriodNumber();
                int spYear = (Integer)this.spPeriodYear.getValue();
                int spNum = (Integer)this.spPeriodNum.getValue();
                if (spYear > glYear || spYear == glYear && spNum > glNum) {
                    MsgBox.showInfo((Component)((Object)this), (String)(this.company.getName() + ": " + FMClientHelper.formatMessage((String)resource, (String)"CheckGLPeriod", (Object[])new String[]{new Integer(glYear).toString(), new Integer(glNum).toString()})));
                    return false;
                }
                int beginYear = beginPeriod.getPeriodYear();
                int beginNum = beginPeriod.getPeriodNumber();
                int endYear = endPeriod.getPeriodYear();
                int endNum = endPeriod.getPeriodNumber();
                if (spYear >= beginYear && (spYear != beginYear || spNum >= beginNum) && spYear <= endYear && (spYear != endYear || spNum <= endNum)) continue;
                MsgBox.showInfo((Component)((Object)this), (String)(this.company.getName() + ": " + FMClientHelper.formatMessage((String)resource, (String)"checkCashGLPeriod", (Object[])new String[]{beginPeriod.toString(), endPeriod.toString()})));
                return false;
            }
        }
        return true;
    }

    public String getPermissionItem() {
        return "cas_cashcontrastGL_01view";
    }

    private boolean hasDate() {
        if (this.spPeriodYear.getValue() != null && this.spPeriodNum.getValue() != null) {
            return true;
        }
        this.spPeriodYear.grabFocus();
        this.spPeriodNum.grabFocus();
        return false;
    }

    protected Class getParamClass() {
        return CashContrastGLSumFilterParam.class;
    }

    @Override
    public void setIsSharedOrg(boolean value) {
        this.isSharedOrg = value;
    }

    @Override
    public boolean isSharedOrg() {
        return this.isSharedOrg;
    }
}

