/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.CapitalTypeEnum;
import com.kingdee.eas.fi.cas.CasContrastGLHelper;
import com.kingdee.eas.fi.cas.client.AbstractCashContrastGLSumUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.CashContrastGLDetailFilterParam;
import com.kingdee.eas.fi.cas.client.CashContrastGLDetailUI;
import com.kingdee.eas.fi.cas.client.CashContrastGLSumFilterParam;
import com.kingdee.eas.fi.cas.client.CashContrastGLSumFilterUI;
import com.kingdee.eas.fi.cas.client.CashContrastGLSumUIHandler;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class CashContrastGLSumUI
extends AbstractCashContrastGLSumUI {
    private static final Logger logger = CoreUIObject.getLogger(CashContrastGLSumUI.class);
    private CashContrastGLSumFilterUI filterUI = null;
    private boolean isSharedOrg = false;

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_balance"));
        this.actionViewDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_listaccount"));
    }

    protected void execQuery() throws BOSException {
        CashContrastGLSumFilterParam param = (CashContrastGLSumFilterParam)this.getFilterParam();
        this.initDispUI(this.txtPeriod, param);
        this.initCurrency(this.cboCurrency, param);
        CashContrastGLSumUIHandler hanlder = new CashContrastGLSumUIHandler();
        String companyId = param.getCompanySet().iterator().next();
        try {
            CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
            PeriodInfo period = CasContrastGLHelper.getPeriodInfo(param.getYear(), param.getSpNum(), company);
            hanlder.loadField(this.tblMain, param.getCompanySet(), param.getCurrency(), period, param.isCancleAccountBank(), param.isUnBalance(), param.isUnTranVoucher());
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
    }

    private void initCurrency(KDComboBox cboCurrency, CashContrastGLSumFilterParam param) {
        try {
            CasContrastGLHelper.initComboCurrency(cboCurrency, false, ContextHelperFactory.getRemoteInstance().getCurrentCompany());
        }
        catch (EASBizException e) {
            e.printStackTrace();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        cboCurrency.setSelectedItem((Object)param.getCurrency());
    }

    private void initDispUI(KDTextField txtPeriod, CashContrastGLSumFilterParam param) throws BOSException {
        String[] args = new String[]{String.valueOf(param.getYear()), String.valueOf(param.getSpNum())};
        MessageFormat mf = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"));
        String result = mf.format(args);
        txtPeriod.setText(result);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CashContrastGLSumFilterUI();
        }
        return this.filterUI;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        IPermission ipermission = PermissionFactory.getRemoteInstance();
        HashMap<String, String> company = new HashMap<String, String>();
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            if (company.containsKey(row.getCell("companyID").getValue().toString())) continue;
            ipermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(row.getCell("companyID").getValue().toString()), "cas_capitalVcSummaryLeger_print");
            company.put(row.getCell("companyID").getValue().toString(), row.getCell("companyID").getValue().toString());
        }
        super.actionPrint_actionPerformed(e);
    }

    public void actionPrintPre_actionPerformed(ActionEvent e) throws Exception {
        IPermission ipermission = PermissionFactory.getRemoteInstance();
        HashMap<String, String> company = new HashMap<String, String>();
        IRow row = null;
        for (int i = 0; i < this.tblMain.getRowCount(); ++i) {
            row = this.tblMain.getRow(i);
            if (company.containsKey(row.getCell("companyID").getValue().toString())) continue;
            ipermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(row.getCell("companyID").getValue().toString()), "cas_capitalVcSummaryLeger_print");
            company.put(row.getCell("companyID").getValue().toString(), row.getCell("companyID").getValue().toString());
        }
        super.actionPrintPre_actionPerformed(e);
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        FMClientHelper.checkSelected((Component)((Object)this), (KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(FMClientHelper.getSelectedRow((KDTable)this.tblMain));
        CashContrastGLSumFilterParam sumPara = (CashContrastGLSumFilterParam)this.getFilterParam();
        IPermission ipermission = PermissionFactory.getRemoteInstance();
        ipermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(row.getCell("companyID").getValue().toString()), "cas_cashcontrastGLSum_03query");
        CashContrastGLDetailFilterParam para = new CashContrastGLDetailFilterParam();
        para.setBeginYear(sumPara.getYear());
        para.setEndYear(sumPara.getYear());
        para.setBeginPeriod(sumPara.getSpNum());
        para.setEndPeriod(sumPara.getSpNum());
        para.setUnTranVoucher(sumPara.isUnTranVoucher());
        CapitalTypeEnum capitalType = (CapitalTypeEnum)((Object)row.getCell("capitalTypeEnum").getValue());
        if (capitalType == null) {
            return;
        }
        if (capitalType.equals((Object)CapitalTypeEnum.BANK)) {
            para.setCapitalType(1);
            para.setAccountBankId(row.getCell("ID").getValue().toString());
        } else {
            para.setCapitalType(2);
            para.setAcctId(row.getCell("ID").getValue().toString());
        }
        para.setCurrencyId(((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString());
        CompanyOrgUnitInfo company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(row.getCell("companyID").getValue().toString()));
        String acctTableId = AccountTools.getCurrentAcctTable(null, (String)company.getId().toString(), (String)company.getAccountTable().getId().toString(), (int)sumPara.getYear(), (int)sumPara.getSpNum());
        para.setCompany(company);
        para.setAcctTableId(acctTableId);
        CashContrastGLDetailUI.showCashDetail((IUIObject)this, para);
    }

    protected void preparePrintPageHeader(HeadFootModel header) {
        StyleAttributes sa = Styles.getDefaultSA();
        StringBuffer sb = new StringBuffer();
        sb.append(this.lblPeriod.getBoundLabelText()).append("&[PeriodRange]&|").append(this.lblCurrency.getBoundLabelText()).append("&[Currency]&| ");
        header.addRow(sb.toString(), sa);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Company", SysContext.getSysContext().getCurrentFIUnit().getName());
        map.put("Currency", this.cboCurrency.getSelectedItem());
        map.put("PeriodRange", this.txtPeriod.getText());
        return map;
    }

    public boolean destroyWindow() {
        if (this.isSharedOrg) {
            CashClientHelper.releaseSharedOrgLicense();
        }
        return super.destroyWindow();
    }

    public void onLoad() throws Exception {
        this.isSharedOrg = CashClientHelper.hasSharedOrgUIParam((CoreUIObject)this);
        if (this.isSharedOrg) {
            CashClientHelper.processSharedOrgFilterUI(this.getFilterUI());
            CashClientHelper.processSharedOrgLicense((CoreUI)this);
        }
        super.onLoad();
    }

    public boolean isUsePrintDefault() {
        return true;
    }
}

