/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.AccountBankCollection;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTools;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.CapitalTypeEnum;
import com.kingdee.eas.fi.cas.CasContrastGLFilterParam;
import com.kingdee.eas.fi.cas.CasContrastGLHelper;
import com.kingdee.eas.fi.cas.CashContrastGLUIFetchDataFacadeFactory;
import com.kingdee.eas.fi.cas.client.AbstractCashContrastGLUI;
import com.kingdee.eas.fi.cas.client.CasContrastGLHandler;
import com.kingdee.eas.fi.cas.client.CashContrastGLDetailFilterParam;
import com.kingdee.eas.fi.cas.client.CashContrastGLDetailUI;
import com.kingdee.eas.fi.cas.client.CashContrastGLFilterUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.KeyStroke;

public class CashContrastGLUI
extends AbstractCashContrastGLUI {
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CasResources";
    public static final String resourcePath2 = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    private CashContrastGLFilterUI filterUI;
    private String strCompanyId;
    private String acctTableId;
    private String periodId;
    CompanyOrgUnitInfo companyInfo = null;
    boolean isLoaded = false;
    Map paramMap = new HashMap();

    public void onLoad() throws Exception {
        boolean flag;
        boolean fGLStart;
        this.mainQueryPK = new MetaDataPK("com.kingdee.eas.fi.cas", "CapitalSubLegerQuery");
        super.onLoad();
        this.paramMap.put("currentCompany", null);
        this.paramMap.put("currentPeriod", null);
        this.paramMap.put("fGLStart", null);
        this.paramMap.put("isStart", null);
        this.paramMap.put("currencyCollection", null);
        this.paramMap.put("baseCurrency", null);
        this.paramMap.put("startPeriod", null);
        this.paramMap.put("glCurrentPeriod", null);
        this.paramMap.put("commonPeriodColl", null);
        this.paramMap.put("filterPeriod", null);
        GlUtils.updateBalance();
        this.paramMap = CashContrastGLUIFetchDataFacadeFactory.getRemoteInstance().fetchDataForMainUI(this.paramMap);
        ClientUtils.checkCompany((Component)((Object)this), this.companyInfo);
        this.prmtCompany.setValue((Object)this.companyInfo);
        this.getUIContext().put(OrgType.Company, this.companyInfo);
        this.getUIContext().put("ORG.PK", new ObjectUuidPK(this.companyInfo.getId()));
        PeriodInfo periodInfo = ClientUtils.getCurrentPeriod((Component)((Object)this), this.companyInfo);
        if (periodInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"StartPeriod_NullMsg"));
            SysUtil.abort();
        }
        if (!(fGLStart = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)this.companyInfo))) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckGLStart"));
            SysUtil.abort();
        }
        if (!(flag = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.companyInfo))) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"NoFinishInit"));
            SysUtil.abort();
        }
        this.tblMain.checkParsed();
        this.tblMain.getStyleAttributes().setLocked(true);
        this.cboCurrency.removeAllItems();
        if (this.paramMap.get("currencyCollection") == null) {
            CasContrastGLHelper.initComboCurrency(this.cboCurrency, true);
        } else {
            this.cboCurrency.removeActionListener(this.cboCurrency.getActionListeners()[0]);
            CasContrastGLHelper.initComboCurrency(this.cboCurrency, (CurrencyCollection)this.paramMap.get("currencyCollection"), (CurrencyInfo)this.paramMap.get("baseCurrency"), true);
            this.cboCurrency.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CashContrastGLUI.this.beforeActionPerformed(e);
                    try {
                        CashContrastGLUI.this.cboCurrency_actionPerformed(e);
                    }
                    catch (Exception exc) {
                        CashContrastGLUI.this.handUIException(exc);
                    }
                    finally {
                        CashContrastGLUI.this.afterActionPerformed(e);
                    }
                }
            });
        }
        this.setSysStatusTitle();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    private void setSysStatusTitle() {
        PeriodInfo curP = (PeriodInfo)this.paramMap.get("currentPeriod");
        this.sysStatusBarTitle = curP == null ? "DeFault" : MessageFormat.format(EASResource.getString((String)resourcePath2, (String)"128_BankJournalListUI"), curP.getPeriodYear(), curP.getPeriodNumber());
    }

    private void checkGLPeriod() {
        CasContrastGLFilterParam param = (CasContrastGLFilterParam)this.getFilterParam();
        if (param != null) {
            int year;
            PeriodInfo glPeriod = null;
            try {
                boolean fGLStart = false;
                fGLStart = SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)param.getCompanyInfo());
                if (!fGLStart) {
                    MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckGLStart"));
                    SysUtil.abort();
                }
                glPeriod = SystemStatusCtrolUtils.getCurrentPeriod(null, (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)param.getCompanyInfo());
            }
            catch (EASBizException e) {
                this.handUIException(e);
            }
            catch (BOSException e) {
                this.handUIException(e);
            }
            int glYear = glPeriod.getPeriodYear();
            int glNum = glPeriod.getPeriodNumber();
            int constrastType = param.getContrastType();
            if (constrastType == 3) {
                if (param.getContrastDate().compareTo(glPeriod.getEndDate()) > 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)FMClientHelper.formatMessage((String)resourcePath, (String)"CheckGLPeriod", (Object[])new String[]{new Integer(glYear).toString(), new Integer(glNum).toString()}));
                    param.setContrastDate(glPeriod.getEndDate());
                }
            } else if (constrastType == 4) {
                int spYear = param.getPeriodYear();
                int spNum = param.getPeriodNum();
                if (spYear > glYear || spYear == glYear && spNum > glNum) {
                    MsgBox.showInfo((Component)((Object)this), (String)FMClientHelper.formatMessage((String)resourcePath, (String)"CheckGLPeriod", (Object[])new String[]{new Integer(glYear).toString(), new Integer(glNum).toString()}));
                    param.setPeriodYear(glYear);
                    param.setPeriodNum(glNum);
                }
            } else if (constrastType == 5 && ((year = param.getContrastYear()) == glYear && glNum != 12 || year > glYear)) {
                MsgBox.showInfo((Component)((Object)this), (String)FMClientHelper.formatMessage((String)resourcePath, (String)"CheckGLPeriod", (Object[])new String[]{new Integer(glYear).toString(), new Integer(glNum).toString()}));
                param.setPeriodYear(glYear);
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnFilter.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnViewDetail.setIcon(EASResource.getIcon((String)"imgTbtn_balance"));
        this.btnFilter.setVisible(false);
        this.btnExport.setVisible(false);
        this.actionViewDetail.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_listaccount"));
    }

    private void initDispUI(KDTextField txtPeriod, CasContrastGLFilterParam param) throws EASBizException, BOSException {
        int constrastType = param.getContrastType();
        if (constrastType == 3) {
            txtPeriod.setText(ClientUtils.formatDate(param.getContrastDate()));
        } else if (constrastType == 4) {
            String[] args = new String[]{String.valueOf(param.getPeriodYear()), String.valueOf(param.getPeriodNum())};
            MessageFormat mf = new MessageFormat(EASResource.getString((String)resourcePath, (String)"LBL_Period"));
            String result = mf.format(args);
            txtPeriod.setText(result);
        } else if (constrastType == 5) {
            txtPeriod.setText(param.getContrastYear() + CasContrastGLHelper.YEAR);
        }
    }

    private void initType(CapitalTypeEnum capitalType, String currencyId) throws BOSException, EASBizException {
        this.cboBankAccount.removeAllItems();
        this.tblMain.removeRows();
        this.cboAccount.removeAllItems();
        this.cboAccount.setEnabled(false);
        this.cboBankAccount.setEnabled(false);
        CasContrastGLFilterParam param = (CasContrastGLFilterParam)this.getFilterParam();
        if (param != null) {
            this.setAcctTableId(param.getCompanyInfo().getId().toString(), param);
        }
        if (capitalType.equals((Object)CapitalTypeEnum.BANK)) {
            this.cboBankAccount.setEnabled(true);
            AccountBankCollection acctBankColl = CasContrastGLHelper.getAccountBankCollection(param.getCompanyInfo().getId().toString(), param.isCancleAccountBank());
            acctBankColl = FMHelper.getJouranlBalanceAcctBank(null, (AccountBankCollection)acctBankColl, null, (String)this.acctTableId);
            Map listenerMap = this.removeComboListeners((JComboBox)this.cboBankAccount);
            if (acctBankColl != null && acctBankColl.size() > 0) {
                this.cboBankAccount.addItems(acctBankColl.toArray());
                this.cboBankAccount.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
            }
            this.addComboListeners((JComboBox)this.cboBankAccount, listenerMap);
            if (acctBankColl.size() != 0) {
                this.cboBankAccount.setSelectedIndex(0);
            }
            if (this.cboBankAccount.getSelectedItem() != null) {
                AccountBankInfo acctBankInfo = (AccountBankInfo)this.cboBankAccount.getSelectedItem();
                acctBankInfo.setDisplayFormat("$number$ - $name$");
            }
        } else if (capitalType.equals((Object)CapitalTypeEnum.CASH)) {
            this.cboAccount.setEnabled(true);
            AccountViewCollection acctViewColl = null;
            acctViewColl = FMHelper.getAcctViewCollection(null, (String)param.getCompanyInfo().getId().toString(), (String)param.getAcctTableId(), (String)currencyId, (AccountTypeEnum)AccountTypeEnum.CASHACCOUNT);
            this.cboAccount.removeAllItems();
            if (acctViewColl != null && acctViewColl.size() > 0) {
                this.cboAccount.addItems(acctViewColl.toArray());
            }
        }
    }

    private void initUI(CapitalTypeEnum capitalType, String accountNum, String bankAcctNum, CurrencyInfo currencyInfo) throws Exception {
        CasContrastGLHandler handler = new CasContrastGLHandler();
        this.tblMain.removeRows();
        CasContrastGLFilterParam param = (CasContrastGLFilterParam)this.getFilterParam();
        if (param == null) {
            return;
        }
        int constrastType = param.getContrastType();
        Date beginDate = null;
        Date endDate = null;
        if (constrastType == 3) {
            beginDate = param.getContrastDate();
            endDate = param.getContrastDate();
            this.lblPeriod.setBoundLabelText(EASResource.getString((String)resourcePath, (String)"Lbl_Date"));
        } else if (constrastType == 4) {
            PeriodInfo periodInfo = null;
            periodInfo = this.paramMap.get("filterPeriod") == null ? CasContrastGLHelper.getPeriodInfo(param.getPeriodYear(), param.getPeriodNum(), param.getCompanyInfo()) : (PeriodInfo)this.paramMap.get("filterPeriod");
            beginDate = periodInfo.getBeginDate();
            endDate = periodInfo.getEndDate();
            this.lblPeriod.setBoundLabelText(EASResource.getString((String)resourcePath, (String)"Lbl_PeriodDesc"));
        } else if (constrastType == 5) {
            int year = param.getContrastYear();
            beginDate = DateHelper.getFirstYearDate((int)year);
            endDate = DateHelper.getLastYearDate((int)year);
            this.lblPeriod.setBoundLabelText(EASResource.getString((String)resourcePath, (String)"CashContrGL_Year"));
        }
        boolean unTranVoucher = param.isUnTranVoucher();
        handler.initTable(this.tblMain, capitalType);
        this.filldata(capitalType, accountNum, bankAcctNum, currencyInfo, handler, constrastType, beginDate, endDate, unTranVoucher, param.getCompanyInfo());
    }

    private void filldata(CapitalTypeEnum capitalType, String accountNum, String bankAcctNum, CurrencyInfo currencyInfo, CasContrastGLHandler handler, int constrastType, Date beginDate, Date endDate, boolean unTranVoucher, CompanyOrgUnitInfo company) throws EASBizException, BOSException {
        CasContrastGLFilterParam param = (CasContrastGLFilterParam)this.getFilterParam();
        PeriodInfo period = CasContrastGLHelper.getPeriodInfo(param.getPeriodYear(), param.getPeriodNum(), company);
        handler.loadField(this.tblMain, constrastType, company, currencyInfo, capitalType, accountNum, bankAcctNum, beginDate, endDate, period, unTranVoucher);
        this.prmtCompany.setValue((Object)company);
    }

    public CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog queryDialog = super.getQueryDlg();
        queryDialog.setShowFilter(false);
        queryDialog.setShowSorter(false);
        return queryDialog;
    }

    @Override
    protected void cboBankAccount_actionPerformed(ActionEvent e) throws Exception {
        super.cboBankAccount_actionPerformed(e);
        if (this.cboBankAccount.getSelectedItem() == null) {
            return;
        }
        Map listenerMap = this.removeComboListeners((JComboBox)this.cboAccount);
        this.cboAccount.removeAllItems();
        if (this.cboBankAccount.getSelectedItem() != FMSysDefinedEnum.SELECT_ALL) {
            AccountBankInfo acctBankInfo = (AccountBankInfo)this.cboBankAccount.getSelectedItem();
            AccountViewInfo acctViewInfo = acctBankInfo.getAccount();
            if (acctViewInfo == null) {
                this.tblMain.removeRows();
                this.addComboListeners((JComboBox)this.cboAccount, listenerMap);
                return;
            }
            this.cboAccount.addItem((Object)acctViewInfo);
        } else {
            ComboBoxModel model = this.cboBankAccount.getModel();
            for (int i = 0; i < model.getSize() - 1; ++i) {
                AccountBankInfo acctBankInfo = (AccountBankInfo)model.getElementAt(i);
                if (acctBankInfo.getAccount() == null) continue;
                this.cboAccount.addItem((Object)acctBankInfo.getAccount());
            }
            if (this.cboAccount.getModel().getSize() > 1) {
                this.cboAccount.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
        this.addComboListeners((JComboBox)this.cboAccount, listenerMap);
        this.cboAccount.setSelectedIndex(this.cboAccount.getModel().getSize() - 1);
    }

    private Map removeComboListeners(JComboBox comboBox) {
        HashMap<String, EventListener[]> listenerMap = new HashMap<String, EventListener[]>();
        ActionListener[] actionLisetener = comboBox.getActionListeners();
        int n = actionLisetener.length;
        for (int i = 0; i < n; ++i) {
            comboBox.removeActionListener(actionLisetener[i]);
        }
        ItemListener[] itemListener = this.cboAccount.getItemListeners();
        int n2 = itemListener.length;
        for (int i = 0; i < n2; ++i) {
            this.cboAccount.removeItemListener(itemListener[i]);
        }
        listenerMap.put("ActionListener", actionLisetener);
        listenerMap.put("ItemListener", itemListener);
        return listenerMap;
    }

    private void addComboListeners(JComboBox comboBox, Map listenerMap) {
        int i;
        ActionListener[] actionLisetener = (ActionListener[])listenerMap.get("ActionListener");
        ItemListener[] itemListener = (ItemListener[])listenerMap.get("ItemListener");
        int n = actionLisetener.length;
        for (i = 0; i < n; ++i) {
            comboBox.addActionListener(actionLisetener[i]);
        }
        n = itemListener.length;
        for (i = 0; i < n; ++i) {
            comboBox.addItemListener(itemListener[i]);
        }
    }

    @Override
    protected void cboCapitalType_actionPerformed(ActionEvent e) throws Exception {
        super.cboCapitalType_actionPerformed(e);
        this.tblMain.removeRows();
        this.cboAccount.removeAllItems();
        CurrencyInfo currencyInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        if (currencyInfo == null) {
            return;
        }
        CapitalTypeEnum capitalType = (CapitalTypeEnum)((Object)this.cboCapitalType.getSelectedItem());
        if (capitalType == null) {
            return;
        }
        this.initType(capitalType, currencyInfo.getId().toString());
    }

    @Override
    protected void cboCurrency_actionPerformed(ActionEvent e) throws Exception {
        super.cboCurrency_actionPerformed(e);
        CurrencyInfo currencyInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        if (currencyInfo == null) {
            return;
        }
        CapitalTypeEnum capitalType = (CapitalTypeEnum)((Object)this.cboCapitalType.getSelectedItem());
        if (capitalType == null) {
            return;
        }
        this.cboAccount_actionPerformed(null);
    }

    @Override
    protected void cboAccount_actionPerformed(ActionEvent e) throws Exception {
        super.cboAccount_actionPerformed(e);
        CurrencyInfo currencyInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        if (currencyInfo == null) {
            return;
        }
        if (this.cboAccount.getSelectedItem() == null) {
            return;
        }
        String acctViewNum = null;
        acctViewNum = this.getSelectedAcctViewNumValues();
        if (FMHelper.isEmpty((String)acctViewNum)) {
            return;
        }
        String acctBankNums = this.getSelectedBankAcctNumValues();
        CapitalTypeEnum capitalType = (CapitalTypeEnum)((Object)this.cboCapitalType.getSelectedItem());
        if (capitalType == null) {
            return;
        }
        if (acctBankNums == null || FMHelper.isEmpty((String)acctBankNums)) {
            this.initUI(capitalType, acctViewNum, null, currencyInfo);
        } else {
            this.initUI(capitalType, acctViewNum, acctBankNums, currencyInfo);
        }
    }

    private String getSelectedAcctViewNumValues() {
        String acctViewNum = "";
        if (this.cboAccount.getSelectedItem() != FMSysDefinedEnum.SELECT_ALL) {
            AccountViewInfo acctInfo = (AccountViewInfo)this.cboAccount.getSelectedItem();
            acctViewNum = acctInfo.getNumber();
        } else if (this.cboAccount.getSelectedItem() == FMSysDefinedEnum.SELECT_ALL) {
            acctViewNum = this.getAllAcctViewNum();
        }
        return acctViewNum;
    }

    private String getSelectedBankAcctNumValues() {
        String acctNum = "";
        if (this.cboBankAccount.getSelectedItem() == null) {
            return acctNum;
        }
        if (this.cboBankAccount.getSelectedItem() != FMSysDefinedEnum.SELECT_ALL) {
            AccountBankInfo acctInfo = (AccountBankInfo)this.cboBankAccount.getSelectedItem();
            acctNum = acctInfo.getNumber();
        } else if (this.cboBankAccount.getSelectedItem() == FMSysDefinedEnum.SELECT_ALL) {
            acctNum = this.getAllBankAcctNum();
        }
        return acctNum;
    }

    private String getAllAcctViewNum() {
        return this.getAllComboBoxNums((JComboBox)this.cboAccount, "number");
    }

    private String getAllBankAcctNum() {
        return this.getAllComboBoxNums((JComboBox)this.cboBankAccount, "number");
    }

    private String getAllComboBoxNums(JComboBox comboBox, String propName) {
        StringBuffer allBankAcctNum = new StringBuffer();
        ComboBoxModel model = comboBox.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            ObjectBaseInfo acctInfo;
            if (!(model.getElementAt(i) instanceof ObjectBaseInfo) || FMHelper.isEmpty((String)(acctInfo = (ObjectBaseInfo)model.getElementAt(i)).get(propName).toString())) continue;
            allBankAcctNum.append(acctInfo.get(propName).toString() + ",");
        }
        String allBankAcctNums = allBankAcctNum.substring(0, allBankAcctNum.length() - 1);
        return allBankAcctNums;
    }

    private String getSelectedAcctViewIDValues() {
        String acctViewIDs = "";
        if (this.cboAccount.getSelectedItem() != FMSysDefinedEnum.SELECT_ALL) {
            AccountViewInfo acctInfo = (AccountViewInfo)this.cboAccount.getSelectedItem();
            acctViewIDs = acctInfo.getId().toString();
        } else if (this.cboAccount.getSelectedItem() == FMSysDefinedEnum.SELECT_ALL) {
            acctViewIDs = this.getAllAcctViewId();
        }
        return acctViewIDs;
    }

    private String getSelectedBankAcctIDValues() {
        String acctViewIDs = "";
        if (this.cboBankAccount.getSelectedItem() != FMSysDefinedEnum.SELECT_ALL) {
            AccountBankInfo acctInfo = (AccountBankInfo)this.cboBankAccount.getSelectedItem();
            acctViewIDs = acctInfo.getId().toString();
        } else if (this.cboBankAccount.getSelectedItem() == FMSysDefinedEnum.SELECT_ALL) {
            acctViewIDs = this.getAllBankAcctId();
        }
        return acctViewIDs;
    }

    private String getAllAcctViewId() {
        return this.getAllComboBoxNums((JComboBox)this.cboAccount, "id");
    }

    private String getAllBankAcctId() {
        return this.getAllComboBoxNums((JComboBox)this.cboBankAccount, "id");
    }

    protected KDTable getMainTable() {
        return this.tblMain;
    }

    protected void execQuery() throws BOSException {
        CasContrastGLFilterParam param = (CasContrastGLFilterParam)this.getFilterParam();
        this.companyInfo = param.getCompanyInfo();
        if (param.getContrastType() != 4) {
            this.getUIContext().put("selectCondition", EASResource.getString((String)resourcePath2, (String)"cm26"));
            this.actionViewDetail.setEnabled(false);
        } else {
            this.getUIContext().put("selectCondition", EASResource.getString((String)resourcePath2, (String)"cm25"));
            this.actionViewDetail.setEnabled(true);
        }
        try {
            this.initDispUI(this.txtPeriod, param);
            this.tblMain.checkParsed();
            this.setAcctTableId(param.getCompanyInfo().getId().toString(), param);
            CapitalTypeEnum capitalType = (CapitalTypeEnum)((Object)this.cboCapitalType.getSelectedItem());
            if (this.cboCurrency.getItemCount() == 0) {
                CasContrastGLHelper.initComboCurrency(this.cboCurrency, true, param.getCompanyInfo());
            }
            CurrencyInfo currencyInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
            this.initType(capitalType, currencyInfo.getId().toString());
        }
        catch (EASBizException e) {
            this.handUIException(e);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    private void setAcctTableId(String companyId, CasContrastGLFilterParam param) throws EASBizException, BOSException {
        int constrastType = param.getContrastType();
        CompanyOrgUnitInfo currentCompany = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(companyId));
        switch (constrastType) {
            case 3: {
                Date date = param.getContrastDate();
                PeriodInfo period = PeriodUtils.getPeriodInfo((Date)date, (CompanyOrgUnitInfo)currentCompany);
                this.acctTableId = AccountTools.getCurrentAcctTable((String)currentCompany.getId().toString(), (String)currentCompany.getAccountTable().getId().toString(), (int)period.getPeriodYear(), (int)period.getPeriodNumber());
                break;
            }
            case 4: {
                int periodYear = param.getPeriodYear();
                int periodNumber = param.getPeriodNum();
                this.acctTableId = AccountTools.getCurrentAcctTable((String)currentCompany.getId().toString(), (String)currentCompany.getAccountTable().getId().toString(), (int)periodYear, (int)periodNumber);
                break;
            }
            case 5: {
                int year = param.getContrastYear();
                Calendar calendar = Calendar.getInstance();
                calendar.set(1, year);
                calendar.set(2, 0);
                calendar.set(5, 1);
                Date beginDate = calendar.getTime();
                calendar.set(1, year);
                calendar.set(2, 11);
                calendar.set(5, 31);
                Date endDate = calendar.getTime();
                this.acctTableId = FMClientHelper.getActualAcctTable((String)companyId, (Date)DateTimeUtils.truncateDate((Date)beginDate), (Date)DateTimeUtils.truncateDate((Date)endDate));
            }
        }
        param.setAcctTableId(this.acctTableId);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CashContrastGLFilterUI(this.paramMap);
        }
        return this.filterUI;
    }

    @Override
    public void actionViewDetail_actionPerformed(ActionEvent e) throws Exception {
        CasContrastGLFilterParam sumPara = (CasContrastGLFilterParam)this.getFilterParam();
        IPermission ipermission = PermissionFactory.getRemoteInstance();
        ipermission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(SysContext.getSysContext().getCurrentUserInfo().getId()), (IObjectPK)new ObjectUuidPK(sumPara.getCompanyInfo().getId().toString()), "cas_cashcontrastGL_03query");
        CashContrastGLDetailFilterParam para = new CashContrastGLDetailFilterParam();
        para.setBeginYear(sumPara.getPeriodYear());
        para.setEndYear(sumPara.getPeriodYear());
        para.setBeginPeriod(sumPara.getPeriodNum());
        para.setEndPeriod(sumPara.getPeriodNum());
        para.setUnTranVoucher(sumPara.isUnTranVoucher());
        CapitalTypeEnum capitalType = (CapitalTypeEnum)((Object)this.cboCapitalType.getSelectedItem());
        if (capitalType == null) {
            return;
        }
        if (capitalType.equals((Object)CapitalTypeEnum.BANK)) {
            if (this.cboBankAccount.getSelectedItem() == null) {
                return;
            }
            para.setCapitalType(1);
            para.setAccountBankId(this.getSelectedBankAcctIDValues());
        } else {
            if (this.cboAccount.getSelectedItem() == null) {
                return;
            }
            para.setCapitalType(2);
            para.setAcctId(this.getSelectedAcctViewIDValues());
        }
        para.setCurrencyId(((CurrencyInfo)this.cboCurrency.getSelectedItem()).getId().toString());
        para.setAcctTableId(sumPara.getAcctTableId());
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.prmtCompany.getValue();
        String acctTableId = AccountTools.getCurrentAcctTable(null, (String)company.getId().toString(), (String)company.getAccountTable().getId().toString(), (int)sumPara.getPeriodYear(), (int)sumPara.getPeriodNum());
        para.setCompany(company);
        para.setAcctTableId(acctTableId);
        CashContrastGLDetailUI.showCashDetail((IUIObject)this, para);
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        CapitalTypeEnum type = (CapitalTypeEnum)((Object)this.cboCapitalType.getSelectedItem());
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        if (type == null || currency == null) {
            return;
        }
        String headString = null;
        String typeString = this.lblCapitalType.getBoundLabelText() + "\uff1a&[type]";
        String accountBankString = this.lblBankAccount.getBoundLabelText() + "\uff1a&[BankAccountNumber]";
        headString = typeString + "&|" + accountBankString;
        headerModel.addRow(headString, Styles.getDefaultSA());
        String currencyString = this.lblCurrency.getBoundLabelText() + "\uff1a&[currency]";
        String accountString = this.lblAccount.getBoundLabelText() + "\uff1a&[accountViewNumber]&[accountViewName]";
        headString = currencyString + "&|" + accountString;
        headerModel.addRow(headString, Styles.getDefaultSA());
        String periodString = this.lblPeriod.getBoundLabelText() + "\uff1a&[periodStr]";
        headString = periodString + "&|  ";
        headerModel.addRow(headString, Styles.getDefaultSA());
        super.preparePrintPageHeader(headerModel);
    }

    protected Map preparePrintVariantMap() {
        HashMap map = new HashMap();
        map.put("selectCondition", this.getUIContext().get("selectCondition"));
        map.put("Company", this.companyInfo.getName());
        CapitalTypeEnum type = (CapitalTypeEnum)((Object)this.cboCapitalType.getSelectedItem());
        String bankAccountName = "";
        String accountViewNumber = "";
        String accountViewName = "";
        if (this.cboBankAccount.getSelectedItem() != null && this.cboBankAccount.getSelectedItem() != FMSysDefinedEnum.SELECT_ALL) {
            bankAccountName = ((AccountBankInfo)this.cboBankAccount.getSelectedItem()).getName();
        } else if (this.cboBankAccount.getSelectedItem() != null && this.cboBankAccount.getSelectedItem() == FMSysDefinedEnum.SELECT_ALL) {
            bankAccountName = FMSysDefinedEnum.SELECT_ALL.toString();
        }
        if (this.cboAccount.getSelectedItem() != null && this.cboAccount.getSelectedItem() != FMSysDefinedEnum.SELECT_ALL) {
            accountViewNumber = ((AccountViewInfo)this.cboAccount.getSelectedItem()).getNumber();
            accountViewName = ((AccountViewInfo)this.cboAccount.getSelectedItem()).getName();
        } else if (this.cboAccount.getSelectedItem() != null && this.cboAccount.getSelectedItem() == FMSysDefinedEnum.SELECT_ALL) {
            accountViewName = FMSysDefinedEnum.SELECT_ALL.toString();
            accountViewNumber = "";
        }
        CurrencyInfo currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        String periodStr = this.txtPeriod.getText();
        if (type == null || currency == null || FMHelper.isEmpty((String)accountViewName)) {
            return map;
        }
        map.put("type", type.getAlias());
        if (!FMHelper.isEmpty((String)bankAccountName)) {
            map.put("BankAccountNumber", bankAccountName);
        } else {
            map.put("BankAccountNumber", "");
        }
        map.put("currency", currency.getName());
        map.put("accountViewNumber", accountViewNumber);
        map.put("accountViewName", accountViewName);
        map.put("periodStr", periodStr);
        return map;
    }
}

