/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.client.AbstractCashCountFilterUI;
import com.kingdee.eas.fi.cas.client.CashCountFilterParam;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMSysDefinedEnum;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMClientVerifyHelper;
import com.kingdee.eas.util.SysUtil;
import java.util.Date;

public class CashCountFilterUI
extends AbstractCashCountFilterUI {
    private CompanyOrgUnitInfo currentCompany = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private CurrencyInfo companyBaseCurrency = ContextHelperFactory.getRemoteInstance().getCompanyBaseCurrency(this.currentCompany);

    @Override
    public void loadFields() {
        super.loadFields();
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    protected void init() throws Exception {
        super.init();
        CashHelper.initCombCurrency(this.comboCurrency, false);
        this.comboCurrency.addItem((Object)FMSysDefinedEnum.SELECT_ALL);
    }

    public Object getParam() {
        CashCountFilterParam param = new CashCountFilterParam();
        if (this.comboCurrency.getSelectedItem().equals(FMSysDefinedEnum.SELECT_ALL)) {
            param.setCurrencyId(null);
        } else {
            param.setCurrencyId(AccessHelper.getCboId((KDComboBox)this.comboCurrency));
        }
        param.setBeginDate((Date)this.datePickerBegin.getValue());
        param.setEndDate((Date)this.datePickerEnd.getValue());
        param.setByDate(this.radioDate.isSelected());
        param.setFrozenAccount(this.chkFrozenAccount.isSelected());
        return param;
    }

    public void setParam(Object param) {
        if (param == null) {
            return;
        }
        if (!(param instanceof CashCountFilterParam)) {
            return;
        }
        CashCountFilterParam cashCountFilterParam = (CashCountFilterParam)param;
        this.datePickerBegin.setValue((Object)cashCountFilterParam.getBeginDate());
        this.datePickerEnd.setValue((Object)cashCountFilterParam.getEndDate());
        String currencyId = cashCountFilterParam.getCurrencyId();
        CurrencyInfo currencyInfo = null;
        try {
            if (currencyId != null) {
                ICurrency iCurrency = CurrencyFactory.getRemoteInstance();
                currencyInfo = iCurrency.getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyId));
                FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)currencyInfo);
            } else {
                this.comboCurrency.setSelectedItem((Object)FMSysDefinedEnum.SELECT_ALL);
            }
        }
        catch (Exception e1) {
            SysUtil.abort((Throwable)e1);
        }
        if (cashCountFilterParam.isByDate()) {
            this.radioDate.setSelected(true);
        } else {
            this.radioAccount.setSelected(true);
        }
        this.chkFrozenAccount.setSelected(cashCountFilterParam.isFrozenAccount());
    }

    public void clear() {
        super.clear();
        try {
            FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, (Object)this.companyBaseCurrency);
            this.datePickerBegin.setValue((Object)DateHelper.getDayBegin());
            this.datePickerEnd.setValue((Object)DateHelper.getDayBegin());
            this.radioDate.setSelected(true);
            this.chkFrozenAccount.setSelected(false);
            this.radioAccount.setSelected(false);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public boolean verify() {
        Date dateFrom = (Date)this.datePickerBegin.getValue();
        Date dateTo = (Date)this.datePickerEnd.getValue();
        String resourcePath = "com.kingdee.eas.fm.fs.FSClientResource";
        if (dateFrom != null && dateTo != null) {
            FMClientVerifyHelper.verifyDateFromTo((CoreUIObject)this, (String)resourcePath, (Date)dateFrom, (Date)dateTo, (String)"CheckDateFromTo");
        }
        return true;
    }

    protected Class getParamClass() {
        return CashCountFilterParam.class;
    }
}

