/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.form.Page;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootParser;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataFillListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.util.UIUtil;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CashCountCollection;
import com.kingdee.eas.fi.cas.CashCountFactory;
import com.kingdee.eas.fi.cas.CashCountInfo;
import com.kingdee.eas.fi.cas.ICashCount;
import com.kingdee.eas.fi.cas.client.AbstractCashCountListUI;
import com.kingdee.eas.fi.cas.client.CashCountDataProvider;
import com.kingdee.eas.fi.cas.client.CashCountFilterUI;
import com.kingdee.eas.fi.cas.client.CashCountUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.FMFilterBaseUI;
import com.kingdee.eas.fm.common.util.UserDefineColumnCollection;
import com.kingdee.eas.fm.common.util.UserDefineColumnInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.framework.client.IIDList;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CashCountListUI
extends AbstractCashCountListUI {
    private static final String resourcePath = "com.kingdee.eas.fi.cas.CasResources";
    private CashCountFilterUI filterUI;
    private CashCountInfo _cashCountInfo = null;
    private TreePath preSelectedNodePath = null;
    private final BigDecimal ZERO = Constants.ZERO;
    private int _scale = 0;
    private boolean _fByAccount = true;

    public ICoreBase getBizInterface() throws BOSException {
        ICashCount iCount = CashCountFactory.getRemoteInstance();
        return iCount;
    }

    public String getEditUIName() {
        return CashCountUI.class.getName();
    }

    protected String getEditUIModal() {
        return UIUtil.getEditUIMode((CoreUIObject)this);
    }

    public void checkSelected() {
        if (this._cashCountInfo == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"PLS_SelectRow"));
            SysUtil.abort();
        }
    }

    public String getSelectedKeyValue() {
        if (this._cashCountInfo != null && this._cashCountInfo.getId() != null) {
            return this._cashCountInfo.getId().toString();
        }
        return null;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.mainQuery != null && this.getSelectedKeyValue() != null) {
            int start = (Integer)e.getParam1();
            int length = (Integer)e.getParam2() - start + 1;
            try {
                IQueryExecutor exec = this.getQueryExecutor(this.mainQueryPK, this.mainQuery);
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("CashCount.id", (Object)this.getSelectedKeyValue()));
                view.setFilter(filter);
                SorterItemInfo sorterItemInfo = new SorterItemInfo("denominator.coefficient");
                sorterItemInfo.setSortType(SortType.DESCEND);
                view.getSorter().add(sorterItemInfo);
                exec.setObjectView(view);
                IRowSet rowSet = exec.executeQuery(start, length);
                e.setRowSet(rowSet);
                this.onGetRowSet(rowSet);
            }
            catch (Exception ee) {
                this.handUIException(ee);
            }
        }
    }

    private void setTree() {
        Rectangle treeLocation = this.treeMain.getBounds();
        DefaultKingdeeTreeNode top = this.getCountTree();
        this.treeMain.setModel((TreeModel)new KingdeeTreeModel((TreeNode)top));
        this.treeMain.setShowCheckBox(false);
        this.treeMain.setBounds(treeLocation);
    }

    private void loadData(CashCountInfo countInfo) throws BOSException, EASBizException {
        if (countInfo != null) {
            String currencyId = null;
            if (countInfo.getAccount() != null) {
                this.txtAccount.setText(countInfo.getAccount().toString());
            }
            if (countInfo.getCurrency() != null) {
                this.txtCurrency.setText(countInfo.getCurrency().getName());
                currencyId = countInfo.getCurrency().getId().toString();
            }
            if (countInfo.getCounter() != null) {
                this.txtCounter.setText(countInfo.getCounter().getName());
            }
            String sDate = "";
            if (countInfo.getCountedDate() != null) {
                sDate = CtrlFormatUtilities.getDateFormat().format(countInfo.getCountedDate());
            }
            this.txtDate.setText(sDate);
            this.txtRemark.setText(countInfo.getComment());
            this.tblMain.removeRows();
            NumberFormat fm = NumberFormat.getInstance();
            fm.setMinimumFractionDigits(this._scale);
            BigDecimal bd_Amount = this.ZERO;
            bd_Amount = countInfo.getSubTotal();
            bd_Amount = bd_Amount == null ? this.ZERO : bd_Amount;
            this.txtRealAmount.setText(ClientUtils.formatDecimal(bd_Amount, this._scale));
            BigDecimal bd_AcctAmount = this.getAcctAmount();
            bd_AcctAmount = bd_AcctAmount == null ? this.ZERO : bd_AcctAmount;
            this.txtAccountAmount.setText(ClientUtils.formatDecimal(bd_AcctAmount, this._scale));
            BigDecimal bd_lose = bd_Amount.subtract(bd_AcctAmount);
            this.txtLose.setText(ClientUtils.formatDecimal(bd_lose, this._scale));
            if (currencyId != null) {
                FMClientHelper.setNumberFormat((KDTable)this.tblMain, (String)"CashCountEntry.subTotal", (String)currencyId);
            }
        }
    }

    private void appendAmountRow(BigDecimal oAmount) {
        IRow lastRow = this.tblMain.addRow();
        String amount = EASResource.getString((String)resourcePath, (String)"CashCountAmountLabel");
        lastRow.getCell(0).setValue((Object)amount);
        int colAmt = 4;
        if (oAmount != null && oAmount.compareTo(this.ZERO) != 0) {
            lastRow.getCell(colAmt).setValue((Object)oAmount.setScale(this._scale, 4));
        }
    }

    private void formatAmtCells() {
        int colAmt = 4;
        Object amt = null;
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            amt = this.tblMain.getRow(i).getCell(colAmt).getValue();
            if (amt == null) continue;
            this.tblMain.getRow(i).getCell(colAmt).setValue((Object)((BigDecimal)amt).setScale(this._scale, 4));
        }
    }

    private DefaultKingdeeTreeNode getCountTree() {
        DefaultKingdeeTreeNode nodeTop = new DefaultKingdeeTreeNode((Object)this.getUITitle());
        SorterItemInfo sortDate = new SorterItemInfo("counteddate");
        try {
            int i;
            CashCountInfo countInfo = null;
            DefaultKingdeeTreeNode subNode = null;
            String curAccountId = "";
            Date preDate = null;
            CashCountCollection countCollection = this.getFilteredCollection();
            if (countCollection == null || countCollection.isEmpty()) {
                return nodeTop;
            }
            if (!this.mainQuery.getSorter().isEmpty()) {
                this._fByAccount = !this.mainQuery.getSorter().get(0).equals((Object)sortDate);
            }
            if (this._fByAccount) {
                Object[] toArray = countCollection.toArray();
                class MyComparator
                implements Comparator {
                    MyComparator() {
                    }

                    public int compare(Object o1, Object o2) {
                        CashCountInfo info1 = (CashCountInfo)o1;
                        CashCountInfo info2 = (CashCountInfo)o2;
                        String acctNumber1 = info1.getAccount().getNumber();
                        String acctNumber2 = info2.getAccount().getNumber();
                        return acctNumber1.compareTo(acctNumber2);
                    }
                }
                Arrays.sort(toArray, new MyComparator());
                countCollection.clear();
                for (i = 0; i < toArray.length; ++i) {
                    countCollection.add((CashCountInfo)toArray[i]);
                }
            }
            Hashtable<String, DefaultKingdeeTreeNode> subNodes = new Hashtable<String, DefaultKingdeeTreeNode>();
            int n = countCollection.size();
            for (i = 0; i < n; ++i) {
                countInfo = countCollection.get(i);
                DefaultKingdeeTreeNode nodeCount = new DefaultKingdeeTreeNode((Object)this.getCountDesc(countInfo));
                nodeCount.setUserObject((Object)countInfo);
                if (this._fByAccount) {
                    curAccountId = countInfo.getAccount().getId().toString();
                    if (!subNodes.containsKey(curAccountId)) {
                        subNode = new DefaultKingdeeTreeNode((Object)this.getSubNodeDesc(countInfo));
                        nodeTop.add((MutableTreeNode)subNode);
                        subNodes.put(countInfo.getAccount().getId().toString(), subNode);
                    } else {
                        subNode = (DefaultKingdeeTreeNode)subNodes.get(curAccountId);
                    }
                } else {
                    if (preDate == null) {
                        subNode = new DefaultKingdeeTreeNode((Object)this.getSubNodeDesc(countInfo));
                        nodeTop.add((MutableTreeNode)subNode);
                    } else if (!ClientUtils.isSameDay(preDate, countInfo.getCountedDate())) {
                        subNode = new DefaultKingdeeTreeNode((Object)this.getSubNodeDesc(countInfo));
                        nodeTop.add((MutableTreeNode)subNode);
                    }
                    preDate = countInfo.getCountedDate();
                }
                if (subNode != null) {
                    subNode.add((MutableTreeNode)nodeCount);
                    continue;
                }
                nodeTop.add((MutableTreeNode)nodeCount);
            }
        }
        catch (BOSException e) {
            this.handUIException(e);
        }
        return nodeTop;
    }

    private String getCountDesc(CashCountInfo countInfo) {
        String sDesc = " ";
        if (this._fByAccount) {
            if (countInfo.getCountedDate() != null) {
                sDesc = ClientUtils.getDateFormat().format(countInfo.getCountedDate());
            }
        } else if (countInfo.getAccount() != null && countInfo.getCurrency() != null) {
            return countInfo.getAccount().toString() + "-" + countInfo.getCurrency().getName();
        }
        return sDesc;
    }

    private String getSubNodeDesc(CashCountInfo countInfo) {
        String sSubNodeDesc = " ";
        if (this._fByAccount) {
            if (countInfo.getAccount() != null) {
                sSubNodeDesc = countInfo.getAccount().toString();
            }
        } else if (countInfo.getCountedDate() != null) {
            sSubNodeDesc = ClientUtils.getDateFormat().format(countInfo.getCountedDate());
        }
        return sSubNodeDesc;
    }

    private CashCountCollection getFilteredCollection() throws BOSException {
        ICashCount iCount = CashCountFactory.getRemoteInstance();
        CashCountCollection countCollection = null;
        if (this.mainQuery.getFilter() != null) {
            if (this.mainQuery.getSelector().isEmpty()) {
                SelectorItemCollection selectors = this.mainQuery.getSelector();
                selectors.add(new SelectorItemInfo("id"));
                selectors.add(new SelectorItemInfo("comment"));
                selectors.add(new SelectorItemInfo("countedDate"));
                selectors.add(new SelectorItemInfo("subtotal"));
                selectors.add(new SelectorItemInfo("company.id"));
                selectors.add(new SelectorItemInfo("company.name"));
                selectors.add(new SelectorItemInfo("company.invalidDate"));
                selectors.add(new SelectorItemInfo("account.id"));
                selectors.add(new SelectorItemInfo("account.number"));
                selectors.add(new SelectorItemInfo("account.name"));
                selectors.add(new SelectorItemInfo("account.isCFreeze"));
                selectors.add(new SelectorItemInfo("account.isGFreeze"));
                selectors.add(new SelectorItemInfo("currency.id"));
                selectors.add(new SelectorItemInfo("currency.name"));
                selectors.add(new SelectorItemInfo("currency.precision"));
                selectors.add(new SelectorItemInfo("counter.name"));
            }
            countCollection = iCount.getCashCountCollection(this.mainQuery);
        }
        return countCollection;
    }

    public void onLoad() throws Exception {
        CompanyOrgUnitInfo companyInfo = ClientUtils.getCurrLoginCompany();
        ClientUtils.checkCompany((Component)((Object)this), companyInfo);
        ClientUtils.getStartPeriodInfo((Component)((Object)this), companyInfo);
        this.dataPane.putClientProperty((Object)"OriginalBounds", (Object)new Rectangle(0, 0, 783, 580));
        super.onLoad();
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.addKDTDataFillListener(new KDTDataFillListener(){

            public void afterDataFill(KDTDataRequestEvent e) {
                int r1 = e.getFirstRow();
                int r2 = e.getLastRow();
                IRow row = null;
                BigDecimal total = CasConstants.ZERO;
                BigDecimal temp = CasConstants.ZERO;
                for (int i = r1; i <= r2; ++i) {
                    row = CashCountListUI.this.tblMain.getRow(i);
                    temp = (BigDecimal)row.getCell("CashCountEntry.subTotal").getValue();
                    total = total.add(temp);
                }
                if (CashCountListUI.this._cashCountInfo != null) {
                    CashCountListUI.this._cashCountInfo.setSubTotal(total);
                    CashCountListUI.this.appendAmountRow(CashCountListUI.this._cashCountInfo.getSubTotal());
                }
                CashCountListUI.this.formatAmtCells();
            }
        });
        this.initBtnIcon();
        this.setTree();
        this.setPreSelectedNode();
        this.tblMain.removeRows();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.kDMenuItemCopy.setAccelerator(KeyStroke.getKeyStroke("ctrl shift C"));
        this.actionTDPrint.setEnabled(true);
        this.actionTDPreView.setEnabled(true);
    }

    private void initBtnIcon() {
        this.btnQuery.setIcon(EASResource.getIcon((String)"imgTbtn_filter"));
        this.btnCopy.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
        this.actionCopy.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_copy"));
        this.actionTDPrint.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_print"));
        this.actionTDPreView.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_preview"));
    }

    @Override
    protected void treeMain_mousePressed(MouseEvent e) throws Exception {
        TreePath path = this.treeMain.getPathForLocation(e.getX(), e.getY());
        if (path != null) {
            Object comp = path.getLastPathComponent();
            if (this.treeMain.getModel().isLeaf(comp)) {
                Object userObj = ((DefaultKingdeeTreeNode)comp).getUserObject();
                if (!(userObj instanceof CashCountInfo)) {
                    SysUtil.abort();
                }
                this.clearUI();
                this._cashCountInfo = (CashCountInfo)userObj;
                this._scale = this._cashCountInfo.getCurrency().getPrecision();
                this.loadData(this._cashCountInfo);
                this.rememberSelectedPath(path);
                if (e.getClickCount() == 2) {
                    if (this.btnView.isVisible() && this.btnView.isEnabled()) {
                        this.actionView_actionPerformed(new ActionEvent(this.btnView, 0, "Double Clicked"));
                    } else if (this.btnEdit.isVisible() && this.btnEdit.isEnabled()) {
                        this.actionEdit_actionPerformed(new ActionEvent(this.btnEdit, 0, "Double Clicked"));
                    }
                }
            }
        }
    }

    private void rememberSelectedPath(TreePath path) {
        if (path != null) {
            this.preSelectedNodePath = path;
        }
    }

    private void setPreSelectedNode() {
        if (this.preSelectedNodePath != null) {
            this.treeMain.setSelectionPath(this.preSelectedNodePath);
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.clearUI();
        this.setTree();
        this.setPreSelectedNode();
        this.tblMain.removeRows();
    }

    protected IIDList getSelectedKeyValues() {
        return null;
    }

    protected ArrayList getSelectedIdValues() {
        if (this._cashCountInfo != null && this._cashCountInfo.getId() != null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(this._cashCountInfo.getId().toString());
            return list;
        }
        return null;
    }

    @Override
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, "COPY");
        uiWindow.show();
        if (this.getEditUIModal().equals("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory") && uiWindow.getUIObject() instanceof EditUI && ((EditUI)uiWindow.getUIObject()).isSave()) {
            this.refresh(e);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        try {
            this.setOprtState("REMOVE");
            this.pubFireVOChangeListener(this.getSelectedKeyValue());
        }
        catch (Throwable ex) {
            this.handUIException(ex);
            this.abort();
        }
        super.actionRemove_actionPerformed(e);
        this.clearUI();
        this.refresh(e);
    }

    private void clearUI() {
        this._cashCountInfo = null;
        this._scale = 0;
        this.preSelectedNodePath = null;
        this.txtAccount.setText("");
        this.txtCurrency.setText("");
        this.txtCounter.setText("");
        this.txtDate.setText("");
        this.txtRemark.setText("");
        this.txtRealAmount.setText("");
        this.txtAccountAmount.setText("");
        this.txtLose.setText("");
    }

    private BigDecimal getAcctAmount() throws BOSException, EASBizException {
        ICashCount iCount = CashCountFactory.getRemoteInstance();
        ObjectUuidPK companyPK = new ObjectUuidPK(this._cashCountInfo.getCompany().getId());
        ObjectUuidPK accountPK = new ObjectUuidPK(this._cashCountInfo.getAccount().getId());
        ObjectUuidPK currencyPK = new ObjectUuidPK(this._cashCountInfo.getCurrency().getId());
        Date bizDate = this._cashCountInfo.getCountedDate();
        BigDecimal amount = iCount.getCashBookAmount((IObjectPK)companyPK, (IObjectPK)accountPK, (IObjectPK)currencyPK, bizDate);
        return amount;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    @Override
    public void actionTDPrint_actionPerformed(ActionEvent e) throws Exception {
        UserDefineColumnCollection udcc = this.getUserDefineColumnCollection();
        CashCountDataProvider data = null;
        data = new CashCountDataProvider(this.tblMain, udcc);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.print("/FI/CAS/CASHCOUNT", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    @Override
    public void actionTDPreView_actionPerformed(ActionEvent e) throws Exception {
        UserDefineColumnCollection udcc = this.getUserDefineColumnCollection();
        CashCountDataProvider data = null;
        data = new CashCountDataProvider(this.tblMain, udcc);
        KDNoteHelper appHlp = new KDNoteHelper();
        appHlp.printPreview("/FI/CAS/CASHCOUNT", (Object)data, (Component)SwingUtilities.getWindowAncestor((Component)((Object)this)));
    }

    private UserDefineColumnCollection getUserDefineColumnCollection() throws Exception {
        UserDefineColumnCollection udcc = new UserDefineColumnCollection();
        UserDefineColumnInfo info = null;
        info = new UserDefineColumnInfo();
        info.setName("acount");
        info.setDescription(this.lblAccount.getBoundLabelText());
        info.setAlias(this.lblAccount.getBoundLabelText());
        info.setColumnValue(this.txtAccount.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("currency");
        info.setDescription(this.lblCurrency.getBoundLabelText());
        info.setAlias(this.lblCurrency.getBoundLabelText());
        info.setColumnValue(this.txtCurrency.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("date");
        info.setDescription(this.lblDate.getBoundLabelText());
        info.setAlias(this.lblDate.getBoundLabelText());
        info.setColumnValue(this.txtDate.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("counter");
        info.setDescription(this.lblCounter.getBoundLabelText());
        info.setAlias(this.lblCounter.getBoundLabelText());
        info.setColumnValue(this.txtCounter.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("amount");
        info.setDescription(this.lblAccountAmount.getBoundLabelText());
        info.setAlias(this.lblAccountAmount.getBoundLabelText());
        info.setColumnValue(this.txtAccountAmount.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("realamount");
        info.setDescription(this.lblRealAmount.getBoundLabelText());
        info.setAlias(this.lblRealAmount.getBoundLabelText());
        info.setColumnValue(this.txtRealAmount.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("lose");
        info.setDescription(this.lblLose.getBoundLabelText());
        info.setAlias(this.lblLose.getBoundLabelText());
        info.setColumnValue(this.txtLose.getText());
        udcc.add((Object)info);
        info = new UserDefineColumnInfo();
        info.setName("remark");
        info.setDescription(this.lblRemark.getBoundLabelText());
        info.setAlias(this.lblRemark.getBoundLabelText());
        info.setColumnValue(this.txtRemark.getText());
        udcc.add((Object)info);
        return udcc;
    }

    private void setPrintPage() {
        String sAcct = this.lblAccount.getBoundLabelText() + "  " + this.txtAccount.getText();
        String sCurr = this.lblCurrency.getBoundLabelText() + "  " + this.txtCurrency.getText();
        String sDate = this.lblDate.getBoundLabelText() + "  " + this.txtDate.getText();
        String sCounter = this.lblCounter.getBoundLabelText() + "  " + this.txtCounter.getText();
        String sAmt = this.lblAccountAmount.getBoundLabelText() + "  " + this.txtAccountAmount.getText();
        String sRlAmt = this.lblRealAmount.getBoundLabelText() + "  " + this.txtRealAmount.getText();
        String sLose = this.lblLose.getBoundLabelText() + "  " + this.txtLose.getText();
        String sRemark = this.lblRemark.getBoundLabelText() + "  " + this.txtRemark.getText();
        HeadFootModel header = new HeadFootModel();
        StyleAttributes sa = Styles.getDefaultSA();
        sa.setFontSize(14);
        sa.setBold(true);
        header.addRow(this.getPrintPageTitle(), sa);
        header.addRow("");
        header.addRow(sAcct + "&| &|" + sCurr);
        header.addRow(sDate + "&| &|");
        HeadFootModel foot = new HeadFootModel();
        foot.addRow(sRemark + "&| &|");
        foot.addRow(sRlAmt + "&|" + sAmt + "&| ");
        foot.addRow(sLose + "&|" + sCounter + "&| ");
        Page headP = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)header);
        Page footP = HeadFootParser.parseModel2HeadFootPage((HeadFootModel)foot);
        this.tblMain.getPrintManager().setHeaderHeight(350);
        this.tblMain.getPrintManager().setHeaderFooter(headP, footP);
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        String sAcct = this.lblAccount.getBoundLabelText() + "\uff1a&[bankAccount]";
        String sCurr = this.lblCurrency.getBoundLabelText() + "\uff1a&[currency] ";
        String sDate = this.lblDate.getBoundLabelText() + "\uff1a&[txtdate]";
        String sCompany = EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoResource", (String)"339_CashCountListUI") + "\uff1a&[company]";
        StyleAttributes sb = Styles.getDefaultSA();
        headerModel.addRow(sAcct + "&|" + sCurr, sb);
        headerModel.addRow(sDate + "&|" + sCompany, sb);
        super.preparePrintPageHeader(headerModel);
    }

    public void preparePrintFooter(HeadFootModel footerModel) {
        String sCounter = this.lblCounter.getBoundLabelText() + "\uff1a&[counter]";
        String sAmt = this.lblAccountAmount.getBoundLabelText() + "\uff1a&[accountAmount] ";
        String sRlAmt = this.lblRealAmount.getBoundLabelText() + "\uff1a&[realAmount]";
        String sLose = this.lblLose.getBoundLabelText() + "\uff1a&[lose]";
        String sRemark = this.lblRemark.getBoundLabelText() + "\uff1a&[remark]";
        StyleAttributes sb = Styles.getDefaultSA();
        footerModel.addRow(sRemark + "&| &|");
        footerModel.addRow(sRlAmt + "&|" + sAmt + "&| ");
        footerModel.addRow(sLose + "&|" + sCounter + "&| ");
        super.preparePrintFooter(footerModel);
    }

    protected Map preparePrintVariantMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("bankAccount", this.txtAccount.getText());
        map.put("currency", this.txtCurrency.getText());
        map.put("txtdate", this.txtDate.getText());
        map.put("company", this._cashCountInfo.getCompany().getName());
        map.put("counter", this.txtCounter.getText());
        map.put("accountAmount", this.txtAccountAmount.getText());
        map.put("realAmount", this.txtRealAmount.getText());
        map.put("lose", this.txtLose.getText());
        map.put("remark", this.txtRemark.getText());
        return map;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.refresh(null);
    }

    public FMFilterBaseUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new CashCountFilterUI();
        }
        return this.filterUI;
    }

    protected CommonQueryDialog getQueryDlg() throws Exception {
        CommonQueryDialog commonQueryDialog = super.getQueryDlg();
        commonQueryDialog.setShowFilter(false);
        commonQueryDialog.setShowSorter(false);
        return commonQueryDialog;
    }
}

