/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.event.CommitEvent;
import com.kingdee.bos.ctrl.swing.event.CommitListener;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.ctrl.swing.event.SelectorEvent;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fm.common.AccessHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.SysUtil;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class CashExtFormulaWizardUI
extends FormulaWizardUI {
    private static Logger logger = Logger.getLogger((String)CashExtFormulaWizardUI.class.getName());
    private KDBizPromptBox bankF7 = null;
    private KDBizPromptBox accountBanksF7 = null;
    private KDBizPromptBox companyF7 = null;
    private KDComboBox dataType = null;

    public void onLoad() throws Exception {
        super.onLoad();
    }

    protected void onOpen() {
        super.onOpen();
        this.dataType = (KDComboBox)this.getParamComponent("cashDataType");
    }

    public void onShow() {
        super.onShow();
        this.bankF7 = (KDBizPromptBox)this.getParamComponent("bank");
        this.accountBanksF7 = (KDBizPromptBox)this.getParamComponent("bankAcctNum");
        this.companyF7 = (KDBizPromptBox)this.getParamComponent("fiOrgUnit");
        this.dataType = (KDComboBox)this.getParamComponent("cashDataType");
        this.bankF7.setEnabledMultiSelection(true);
        ((KDComboBox)this.getParamComponent("cashDataType")).removeItemAt(2);
        ((KDComboBox)this.getParamComponent("cashDataType")).removeItemAt(4);
        ((KDComboBox)this.getParamComponent("cashDataType")).removeItemAt(4);
        this.initAllListener();
    }

    private void initAllListener() {
        this.companyF7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                CashExtFormulaWizardUI.this.bankF7.setData(null);
                CashExtFormulaWizardUI.this.dataType.removeItem((Object)CashDataTypeEnum.AY);
                CashExtFormulaWizardUI.this.dataType.removeItem((Object)CashDataTypeEnum.QDF);
                CashExtFormulaWizardUI.this.dataType.removeItem((Object)CashDataTypeEnum.QJF);
            }
        });
        this.bankF7.addDataChangeListener(new DataChangeListener(){

            public void dataChanged(DataChangeEvent arg0) {
                CashExtFormulaWizardUI.this.accountBanksF7.setData(null);
                FilterInfo filterBank = this.getBankFilter();
                EntityViewInfo eviAccountBank = new EntityViewInfo();
                eviAccountBank.setFilter(filterBank);
                CashExtFormulaWizardUI.this.accountBanksF7.setEntityViewInfo(eviAccountBank);
            }

            private FilterInfo getBankFilter() {
                String[] bankIds = AccessHelper.getF7Ids((KDBizPromptBox)CashExtFormulaWizardUI.this.bankF7);
                FilterInfo filterBank = new FilterInfo();
                if (bankIds != null && bankIds.length > 0) {
                    HashSet<String> bankSet = new HashSet<String>(Arrays.asList(bankIds));
                    filterBank.getFilterItems().add(new FilterItemInfo("bank.id", bankSet, CompareType.INCLUDE));
                }
                filterBank.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
                return filterBank;
            }
        });
        this.accountBanksF7.addSelectorListener(new SelectorListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void willShow(SelectorEvent e) {
                try {
                    FilterInfo filterBank = CashExtFormulaWizardUI.this.getBankFilter();
                    EntityViewInfo eviAccountBank = new EntityViewInfo();
                    eviAccountBank.setFilter(filterBank);
                    CashExtFormulaWizardUI.this.accountBanksF7.setEntityViewInfo(eviAccountBank);
                    CashExtFormulaWizardUI.this.accountBanksF7.getQueryAgent().resetRuntimeEntityView();
                }
                catch (Exception exc) {
                    CashExtFormulaWizardUI.this.handUIException(exc);
                }
            }
        });
        this.accountBanksF7.addCommitListener(new CommitListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void willCommit(CommitEvent e) {
                try {
                    FilterInfo filterBank = CashExtFormulaWizardUI.this.getBankFilter();
                    EntityViewInfo eviAccountBank = new EntityViewInfo();
                    eviAccountBank.setFilter(filterBank);
                    CashExtFormulaWizardUI.this.accountBanksF7.setEntityViewInfo(eviAccountBank);
                    CashExtFormulaWizardUI.this.accountBanksF7.getQueryAgent().resetRuntimeEntityView();
                }
                catch (Exception exc) {
                    CashExtFormulaWizardUI.this.handUIException(exc);
                }
            }
        });
    }

    private FilterInfo getBankFilter() {
        FilterInfo filterBank = new FilterInfo();
        String[] bankIds = null;
        Object value = this.bankF7.getData();
        filterBank.getFilterItems().add(new FilterItemInfo("isClosed", (Object)Boolean.FALSE));
        if (value != null && value.toString().trim().length() > 0) {
            Object[] values = (Object[])value;
            if (values[0] instanceof CoreBaseInfo) {
                bankIds = AccessHelper.getF7Ids((KDBizPromptBox)this.bankF7);
                if (bankIds != null && bankIds.length > 0) {
                    HashSet<String> bankSet = new HashSet<String>(Arrays.asList(bankIds));
                    filterBank.getFilterItems().add(new FilterItemInfo("bank.id", bankSet, CompareType.INCLUDE));
                }
            } else if (values[0].toString().length() > 0) {
                bankIds = values[0].toString().split(";");
                for (int i = 0; i < bankIds.length; ++i) {
                    bankIds[i] = bankIds[i].trim();
                }
                if (bankIds != null && bankIds.length > 0) {
                    HashSet<String> bankSet = new HashSet<String>(Arrays.asList(bankIds));
                    filterBank.getFilterItems().add(new FilterItemInfo("bank.number", bankSet, CompareType.INCLUDE));
                }
            }
        }
        Object valueCom = this.companyF7.getData();
        String[] companyIds = null;
        if (valueCom != null && valueCom.toString().trim().length() > 0) {
            if (valueCom instanceof CoreBaseInfo) {
                companyIds = AccessHelper.getF7Ids((KDBizPromptBox)this.companyF7);
                if (companyIds != null && companyIds.length > 0) {
                    String sql;
                    CompanyOrgUnitInfo company = null;
                    try {
                        company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(AccessHelper.getId((Object)valueCom)));
                    }
                    catch (EASBizException ex) {
                        logger.error((Object)ex);
                        SysUtil.abort();
                    }
                    catch (BOSException ex) {
                        logger.error((Object)ex);
                        SysUtil.abort();
                    }
                    if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)company)) {
                        sql = "select fid from T_org_company where CHARINDEX((select flongnumber||'!' from T_org_company where fid = '" + AccessHelper.getId((Object)valueCom) + "'),flongnumber) = 1";
                        filterBank.getFilterItems().add(new FilterItemInfo("company.id", (Object)sql, CompareType.INNER));
                    } else {
                        sql = "select fid from T_org_company where CHARINDEX((select flongnumber from T_org_company where fid = '" + AccessHelper.getId((Object)valueCom) + "'),flongnumber) = 1";
                        filterBank.getFilterItems().add(new FilterItemInfo("company.id", (Object)sql, CompareType.INNER));
                    }
                }
            } else if (valueCom.toString().length() > 0) {
                String sql;
                companyIds = valueCom.toString().split(";");
                for (int i = 0; i < companyIds.length; ++i) {
                    companyIds[i] = companyIds[i].trim();
                }
                CompanyOrgUnitInfo company = null;
                try {
                    EntityViewInfo evi = new EntityViewInfo();
                    FilterInfo f = new FilterInfo();
                    f.getFilterItems().add(new FilterItemInfo("number", (Object)companyIds[0]));
                    evi.setFilter(f);
                    company = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(evi).get(0);
                }
                catch (BOSException ex) {
                    logger.error((Object)ex);
                    SysUtil.abort();
                }
                if (GlUtils.isCompanyUnion(company)) {
                    sql = "select fid from T_org_company where CHARINDEX((select flongnumber||'!' from T_org_company where fid = '" + AccessHelper.getId(company) + "'),flongnumber) = 1";
                    filterBank.getFilterItems().add(new FilterItemInfo("company.id", (Object)sql, CompareType.INNER));
                } else {
                    sql = "select fid from T_org_company where CHARINDEX((select flongnumber from T_org_company where fid = '" + AccessHelper.getId(company) + "'),flongnumber) = 1";
                    filterBank.getFilterItems().add(new FilterItemInfo("company.id", (Object)sql, CompareType.INNER));
                }
            }
        }
        return filterBank;
    }
}

