/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.ExtendParser;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.base.vc.VerifyScopeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.calc.CalculatorDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.JournalCollection;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.JournalRpcCacheInfo;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.JournalTypeEnum;
import com.kingdee.eas.fi.cas.client.AbstractCashJournalAddBatchUI;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.CashJournalHandler;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fm.common.ContextHelperFactory;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.fm.common.FmRpcCacheInfo;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.fm.common.client.TableBindHandler;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class CashJournalAddBatchUI
extends AbstractCashJournalAddBatchUI {
    private static final String BILLNUMBER = "billNumber";
    private static final String BILLTYPE = "billType";
    private static final String BIZDATE = "bizDate";
    private static final String CREATEDATE = "createDate";
    private static final String CREDITAMOUNT = "creditAmount";
    private static final String DEBITAMOUNT = "debitAmount";
    private static final String DESCRIPTION = "description";
    private static final String OPPACCOUNTVIEW = "oppAccountView";
    private static final String VOUCHERNUMBER = "voucherNumber";
    private static final String VOUCHERTYPE = "voucherType";
    private CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    private CashJournalHandler handler = new CashJournalHandler();
    private JournalCollection journals = new JournalCollection();
    private JournalCollection journalsOld = new JournalCollection();
    TableBindHandler tableHandler = new TableBindHandler();
    private JournalRpcCacheInfo rpcCacheInfo;
    PeriodInfo casPeriod;
    int flag = 0;
    private static final String casResourcePath = "com.kingdee.eas.fi.cas.CasResource";

    public boolean isModify() {
        this.storeFields();
        return !this.journals.equals((Object)this.journalsOld);
    }

    protected boolean isRpcCacheProcess() {
        return true;
    }

    protected FmRpcCacheInfo getRpcCacheParam() {
        JournalRpcCacheInfo paramInfo = new JournalRpcCacheInfo();
        paramInfo.setBatchImplClassName(this.getRpcBatchImplClassName());
        return paramInfo;
    }

    protected String getRpcBatchImplClassName() {
        return "com.kingdee.eas.fi.cas.app.JournalBatchFetcher";
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddLine_actionPerformed(e);
        this.flag = 1;
        this.addLine();
    }

    @Override
    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        BigDecimal result;
        CalculatorDialog calc = new CalculatorDialog((Container)this.getUIContext().get("Owner"));
        calc.setInitValue(null);
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        int pre = 2;
        if (currency != null) {
            pre = currency.getPrecision();
        }
        if ((result = calc.showDialog(pre, true)) == null) {
            return;
        }
        if (result.compareTo(FMConstants.MAX_VALUE) == 1) {
            this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
            this.showMessage();
            return;
        }
        IRow row = this.kdtJournals.getRow(this.kdtJournals.getSelectManager().getActiveRowIndex());
        int activeColumnIndex = this.kdtJournals.getSelectManager().getActiveColumnIndex();
        if (row == null || activeColumnIndex == -1) {
            return;
        }
        if (this.kdtJournals.getColumnKey(activeColumnIndex).equals(DEBITAMOUNT)) {
            if (result != null && result.compareTo(FMConstants.ZERO) != 0) {
                row.getCell(DEBITAMOUNT).setValue((Object)result);
                row.getCell(CREDITAMOUNT).setValue(null);
            }
        } else if (this.kdtJournals.getColumnKey(activeColumnIndex).equals(CREDITAMOUNT) && result != null && result.compareTo(FMConstants.ZERO) != 0) {
            row.getCell(CREDITAMOUNT).setValue((Object)result);
            row.getCell(DEBITAMOUNT).setValue(null);
        }
    }

    @Override
    public void actionCopyLine_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtJournals.getRowCount() == 0 || this.kdtJournals.getSelectManager().size() == 0 || this.isTableColumnSelected(this.kdtJournals)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            return;
        }
        int top = this.kdtJournals.getSelectManager().get().getTop();
        IRow row = this.kdtJournals.getRow(top);
        this.flag = 0;
        IObjectValue data = this.createNewData();
        this.storeLinFileds(row, data);
        row = this.kdtJournals.addRow(top);
        this.loadLineFileds(data, row);
    }

    @Override
    public void actionDeleteLine_actionPerformed(ActionEvent e) throws Exception {
        super.actionDeleteLine_actionPerformed(e);
        this.removeLine();
    }

    @Override
    public void actionInsertLine_actionPerformed(ActionEvent e) throws Exception {
        this.flag = 0;
        this.insertLine();
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.kdtJournals.getRowCount() <= 0) {
            return;
        }
        this.verify(e);
        IObjectPK pkOut = LogUtil.beginLog(null, (String)EASResource.getString((String)"com.kingdee.eas.fi.cas.CASAutoGenerateResource", (String)"277_CashJournalAddBatchUI"), (BOSObjectType)new JournalInfo().getBOSType(), null, (String)"", (String)"cas_cashBook_addBatch");
        this.handler.submitJournals(this.journals);
        LogUtil.afterLog(null, (IObjectPK)pkOut);
        this.showSubmitSuccess();
        this.journals.clear();
        this.kdtJournals.removeRows();
        this.addLine();
        this.storeFields();
        this.journalsOld = (JournalCollection)this.journals.clone();
    }

    private String getNumbers(JournalCollection coll) {
        String retStr = "";
        for (int i = 0; i < coll.size(); ++i) {
            retStr = retStr + coll.get(i).getNumber();
            if (i == coll.size() - 1) continue;
            retStr = retStr + ",";
        }
        return retStr;
    }

    public void addLine() throws EASBizException, BOSException {
        IObjectValue detailData = this.createNewData();
        IRow row = this.kdtJournals.addRow();
        this.loadLineFileds(detailData, row);
    }

    @Override
    protected void comboCurrency_actionPerformed(ActionEvent e) throws Exception {
        this.setF7OpAcct();
        this.setCurrencyPre();
        super.comboCurrency_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        JournalInfo journal = new JournalInfo();
        journal.setId(BOSUuid.create((BOSObjectType)journal.getBOSType()));
        journal.setHasEffected(true);
        Date date = new Date();
        if (date.before(this.casPeriod.getBeginDate())) {
            date = this.casPeriod.getBeginDate();
        }
        if (date.after(this.casPeriod.getEndDate())) {
            date = this.casPeriod.getEndDate();
        }
        journal.setBizDate(date);
        journal.setCreateDate(date);
        journal.setPeriod(this.casPeriod);
        UserInfo user = ContextHelperFactory.getRemoteInstance().getCurrentUser();
        journal.setCashier(user);
        journal.setVerifyStatus(VerifyScopeEnum.NOVA);
        journal.setSource(JournalSourceEnum.BYHAND);
        journal.setCurrency(this.company.getBaseCurrency());
        journal.setType(JournalTypeEnum.CASH);
        journal.setCurrency((CurrencyInfo)this.getUIContext().get("currency"));
        journal.setAccountView((AccountViewInfo)this.getUIContext().get("account"));
        journal.setCompany(this.company);
        KDTSelectBlock selectBlock = this.kdtJournals.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            int rowIndexBottom = this.kdtJournals.getRowCount() - 1;
            if (this.flag == 1) {
                journal.setCreateDate((Date)this.kdtJournals.getRow(rowIndexBottom).getCell(CREATEDATE).getValue());
                journal.setBizDate((Date)this.kdtJournals.getRow(rowIndexBottom).getCell(BIZDATE).getValue());
            }
            if (this.flag == 0) {
                journal.setCreateDate((Date)this.kdtJournals.getRow(rowIndex).getCell(CREATEDATE).getValue());
                journal.setBizDate((Date)this.kdtJournals.getRow(rowIndex).getCell(BIZDATE).getValue());
            }
            journal.setDescription(TypeConversionUtils.objToString((Object)this.kdtJournals.getRow(rowIndex).getCell(DESCRIPTION).getValue()));
        }
        return journal;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return JournalFactory.getRemoteInstance();
    }

    private void initTable() {
        this.kdtJournals.putBindContents("editData", new String[]{CREATEDATE, BIZDATE, "", DESCRIPTION, VOUCHERTYPE, VOUCHERNUMBER, BILLTYPE, BILLNUMBER, OPPACCOUNTVIEW, DEBITAMOUNT, CREDITAMOUNT});
        this.kdtJournals.checkParsed();
        this.kdtJournals.getSelectManager().setSelectMode(1);
        String formatString = "yyyy-MM-dd";
        KDDatePicker createDatePicker = new KDDatePicker();
        KDTDefaultCellEditor createDateEditor = new KDTDefaultCellEditor(createDatePicker);
        this.kdtJournals.getColumn(CREATEDATE).setEditor((ICellEditor)createDateEditor);
        this.kdtJournals.getColumn(CREATEDATE).getStyleAttributes().setNumberFormat(formatString);
        KDDatePicker bizDatePicker = new KDDatePicker();
        KDTDefaultCellEditor bizEditor = new KDTDefaultCellEditor(bizDatePicker);
        this.kdtJournals.getColumn(BIZDATE).setEditor((ICellEditor)bizEditor);
        this.kdtJournals.getColumn(BIZDATE).getStyleAttributes().setNumberFormat(formatString);
        KDTextField textField = new KDTextField();
        KDFormattedTextField formattedTextField = new KDFormattedTextField(1);
        KDBizPromptBox f7Description = new KDBizPromptBox();
        ExtendParser descEP = new ExtendParser(f7Description);
        f7Description.setCommitParser((IParser)descEP);
        f7Description.setQueryInfo("com.kingdee.eas.basedata.assistant.app.F7VoucherAbstract");
        f7Description.setEditable(true);
        f7Description.setMaxLength(255);
        KDTDefaultCellEditor descEditor = new KDTDefaultCellEditor((IKDEditor)f7Description);
        this.kdtJournals.getColumn(DESCRIPTION).setEditor((ICellEditor)descEditor);
        KDComboBox cboVoucherType = new KDComboBox();
        this.handler.initComboVoucherType(cboVoucherType);
        KDTDefaultCellEditor voucherEditor = new KDTDefaultCellEditor((JComboBox)cboVoucherType);
        this.kdtJournals.getColumn(VOUCHERTYPE).setEditor((ICellEditor)voucherEditor);
        textField.setMaxLength(80);
        KDTDefaultCellEditor voucherNumberEditor = new KDTDefaultCellEditor((JTextField)textField);
        this.kdtJournals.getColumn(VOUCHERNUMBER).setEditor((ICellEditor)voucherNumberEditor);
        KDComboBox cboBillType = new KDComboBox();
        this.handler.initComboBillType(cboBillType, true);
        KDTDefaultCellEditor billTypeEditor = new KDTDefaultCellEditor((JComboBox)cboBillType);
        this.kdtJournals.getColumn(BILLTYPE).setEditor((ICellEditor)billTypeEditor);
        KDTDefaultCellEditor billNumberEditor = new KDTDefaultCellEditor((JTextField)textField);
        this.kdtJournals.getColumn(BILLNUMBER).setEditor((ICellEditor)billNumberEditor);
        int pre = 3;
        formattedTextField.setPrecision(pre);
        formattedTextField.setSupportedEmpty(true);
        KDTDefaultCellEditor numberEditor = new KDTDefaultCellEditor((JTextField)formattedTextField);
        this.kdtJournals.getColumn(DEBITAMOUNT).setEditor((ICellEditor)numberEditor);
        this.kdtJournals.getColumn(CREDITAMOUNT).setEditor((ICellEditor)numberEditor);
        this.kdtJournals.getColumn(DEBITAMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        this.kdtJournals.getColumn(CREDITAMOUNT).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        String numberFmt = FMClientHelper.getNumberFtm((int)pre);
        this.kdtJournals.getColumn(DEBITAMOUNT).getStyleAttributes().setNumberFormat(numberFmt);
        this.kdtJournals.getColumn(CREDITAMOUNT).getStyleAttributes().setNumberFormat(numberFmt);
        this.kdtJournals.getColumn("period").getStyleAttributes().setLocked(true);
        KDTableHelper.updateEnterWithTab((KDTable)this.kdtJournals, (boolean)true, (Action)new ItemAction(){

            public void actionPerformed(ActionEvent e) {
                IObjectValue detailData = CashJournalAddBatchUI.this.createNewData();
                IRow row = CashJournalAddBatchUI.this.kdtJournals.getRow(CashJournalAddBatchUI.this.kdtJournals.getRowCount() - 1);
                try {
                    CashJournalAddBatchUI.this.loadLineFileds(detailData, row);
                }
                catch (EASBizException e1) {
                    e1.printStackTrace();
                }
                catch (BOSException e1) {
                    e1.printStackTrace();
                }
            }
        });
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddRow.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnCopyRow.setIcon(EASResource.getIcon((String)"imgTbtn_copyline"));
        this.btnDeleteRow.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnInsertRow.setIcon(EASResource.getIcon((String)"imgTbtn_insert"));
        this.btnCalculator.setIcon(EASResource.getIcon((String)"imgTbtn_counter"));
    }

    protected void insertLine() throws EASBizException, BOSException {
        IObjectValue detailData = this.createNewData();
        IRow row = null;
        if (this.kdtJournals.getRowCount() != 0 && this.kdtJournals.getSelectManager().size() > 0) {
            int top = this.kdtJournals.getSelectManager().get().getTop();
            row = this.isTableColumnSelected(this.kdtJournals) ? this.kdtJournals.addRow() : this.kdtJournals.addRow(top);
        } else {
            row = this.kdtJournals.addRow();
        }
        this.loadLineFileds(detailData, row);
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    @Override
    protected void kdtJournals_editStopped(KDTEditEvent e) throws Exception {
        super.kdtJournals_editStopped(e);
        IRow row = this.kdtJournals.getRow(e.getRowIndex());
        Date beginDate = CashClientHelper.getCurrentPeriod(this.company).getBeginDate();
        if (e.getValue() == null) {
            if (e.getColIndex() == this.kdtJournals.getColumnIndex(CREATEDATE)) {
                row.getCell(CREATEDATE).setValue(e.getOldValue());
            } else if (e.getColIndex() == this.kdtJournals.getColumnIndex(BIZDATE)) {
                row.getCell(BIZDATE).setValue(e.getOldValue());
            }
            return;
        }
        if (e.getColIndex() == 0) {
            Date date = (Date)row.getCell(CREATEDATE).getValue();
            if (PeriodUtils.getPeriodInfo((Date)date, (CompanyOrgUnitInfo)this.company) == null) {
                row.getCell(CREATEDATE).setValue(e.getOldValue());
                return;
            }
            if (date.before(beginDate)) {
                date = beginDate;
                row.getCell(CREATEDATE).setValue((Object)date);
            }
            this.setPeriodCell(row.getCell("period"), PeriodUtils.getPeriodInfo((Date)date, (CompanyOrgUnitInfo)this.company));
        } else if (this.kdtJournals.getColumnKey(e.getColIndex()).equals(DEBITAMOUNT)) {
            BigDecimal amount = (BigDecimal)row.getCell(DEBITAMOUNT).getValue();
            if (amount == null) {
                return;
            }
            if (amount.compareTo(FMConstants.MAX_VALUE) == 1) {
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
                this.showMessage();
                row.getCell(DEBITAMOUNT).setValue(null);
            }
            if (amount.compareTo(FMConstants.ZERO) != 0) {
                row.getCell(CREDITAMOUNT).setValue(null);
            } else {
                row.getCell(DEBITAMOUNT).setValue(null);
            }
        } else if (this.kdtJournals.getColumnKey(e.getColIndex()).equals(CREDITAMOUNT)) {
            BigDecimal amount = (BigDecimal)row.getCell(CREDITAMOUNT).getValue();
            if (amount == null) {
                return;
            }
            if (amount.compareTo(FMConstants.MAX_VALUE) == 1) {
                this.setMessageText(EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"MaxValue"));
                this.showMessage();
                row.getCell(CREDITAMOUNT).setValue(null);
            }
            if (amount.compareTo(FMConstants.ZERO) != 0) {
                row.getCell(DEBITAMOUNT).setValue(null);
            } else {
                row.getCell(CREDITAMOUNT).setValue(null);
            }
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
    }

    private void loadLineFileds(IObjectValue detailData, IRow row) throws EASBizException, BOSException {
        this.tableHandler.loadLineFields(this.kdtJournals, row, detailData);
        Date temp = new Date();
        temp = (Date)row.getCell(CREATEDATE).getValue();
        this.setPeriodCell(row.getCell("period"), PeriodUtils.getPeriodInfo((Date)temp, (CompanyOrgUnitInfo)this.company));
    }

    private void initControl() {
        this.actionAttachment.setVisible(false);
        this.btnAddNew.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPageSetup.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnCalculator.setMnemonic('n');
        this.kdtJournals.setActiveCellStatus(1);
        this.menuItemCopy.setVisible(false);
    }

    public void onLoad() throws Exception {
        this.rpcCacheInfo = (JournalRpcCacheInfo)((AbstractCashJournalAddBatchUI)this).rpcCacheInfo;
        this.casPeriod = this.rpcCacheInfo.getCurPeriod();
        this.setOprtState("ADDNEW");
        if (!"FINDVIEW".equalsIgnoreCase(this.getOprtState()) && !OprtState.VIEW.equalsIgnoreCase(this.getOprtState())) {
            CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
            FMClientHelper.checkIsAdjustPeriod((Component)((Object)this), (CompanyOrgUnitInfo)companyInfo);
        }
        this.initControl();
        this.initTable();
        CashHelper.initCombCurrency(this.comboCurrency, false);
        this.handler.initComboCashAcct(this.comboAcct, this.company, null);
        FMClientHelper.setSelectObject((KDComboBox)this.comboCurrency, this.getUIContext().get("currency"));
        FMClientHelper.setSelectObject((KDComboBox)this.comboAcct, this.getUIContext().get("account"));
        super.onLoad();
        this.addLine();
        this.storeFields();
        this.journalsOld = (JournalCollection)this.journals.clone();
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
        this.menuItemCancel.setAccelerator(KeyStroke.getKeyStroke("shift F8"));
        this.menuItemCancelCancel.setAccelerator(KeyStroke.getKeyStroke("shift F9"));
        this.kdtJournals.getColumn(CREATEDATE).getStyleAttributes().setNumberFormat(ClientUtils.getDateFormatString());
        this.kdtJournals.getColumn(BIZDATE).getStyleAttributes().setNumberFormat(ClientUtils.getDateFormatString());
    }

    public void removeLine() {
        if (this.kdtJournals.getSelectManager().size() == 0 || this.isTableColumnSelected(this.kdtJournals)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int top = this.kdtJournals.getSelectManager().get().getTop();
        if (this.kdtJournals.getRow(top) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        this.kdtJournals.removeRow(top);
    }

    private void setCurrencyPre() {
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        int pre = FMClientHelper.getPrecOfCurrency((BOSUuid)currency.getId());
        KDFormattedTextField editor = (KDFormattedTextField)this.kdtJournals.getColumn(DEBITAMOUNT).getEditor().getComponent();
        editor.setPrecision(pre);
        editor.setDataVerifierType(12);
        editor = (KDFormattedTextField)this.kdtJournals.getColumn(DEBITAMOUNT).getEditor().getComponent();
        editor.setPrecision(pre);
        String numberFmt = FMClientHelper.getNumberFtm((int)pre);
        this.kdtJournals.getColumn(DEBITAMOUNT).getStyleAttributes().setNumberFormat(numberFmt);
        this.kdtJournals.getColumn(CREDITAMOUNT).getStyleAttributes().setNumberFormat(numberFmt);
    }

    private void setF7OpAcct() {
        CurrencyInfo currency = (CurrencyInfo)this.comboCurrency.getSelectedItem();
        KDBizPromptBox bizPromptAccount = new KDBizPromptBox();
        bizPromptAccount.setDisplayFormat("$name$");
        bizPromptAccount.setEditFormat("$id$");
        this.handler.initF7Acct((IUIObject)this, bizPromptAccount, this.company, currency);
        KDTDefaultCellEditor accountEditor = new KDTDefaultCellEditor((IKDEditor)bizPromptAccount);
        this.kdtJournals.getColumn("opAccountView").setEditor((ICellEditor)accountEditor);
    }

    private void setPeriodCell(ICell cell, PeriodInfo period) {
        if (period != null) {
            String[] args = new String[]{String.valueOf(period.getPeriodYear()), String.valueOf(period.getPeriodNumber())};
            MessageFormat mf = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"));
            String result = mf.format(args);
            cell.setValue((Object)result);
            cell.setUserObject((Object)period);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        this.tableHandler.bindTableToData(this.kdtJournals, (IObjectCollection)this.journals, JournalInfo.class.getName());
        for (int i = 0; i < this.journals.size(); ++i) {
            JournalInfo journal = this.journals.get(i);
            if (journal.getDebitAmount() != null && journal.getDebitAmount().compareTo(FMConstants.ZERO) > 0) {
                journal.setIsDebit(true);
            } else {
                journal.setIsDebit(false);
            }
            journal.setAccountView((AccountViewInfo)this.comboAcct.getSelectedItem());
            journal.setCurrency((CurrencyInfo)this.comboCurrency.getSelectedItem());
        }
    }

    private void storeLinFileds(IRow row, IObjectValue obj) {
        this.tableHandler.storeLineFields(this.kdtJournals, row, obj);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        int result;
        CompanyOrgUnitInfo company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        PeriodInfo curPeriod = CashClientHelper.getCurrentPeriod(company);
        String currentYear = String.valueOf(curPeriod.getPeriodYear());
        String currentMonth = String.valueOf(curPeriod.getNumber()).substring(4);
        String msg = EASResource.getString((String)casResourcePath, (String)"moreBizDateNotPeriod");
        String row = EASResource.getString((String)casResourcePath, (String)"moreBizDateNotPeriodDetail");
        StringBuffer detail = new StringBuffer();
        int size = this.journals.size();
        for (int i = 0; i < size; ++i) {
            JournalInfo journal = this.journals.get(i);
            if (!CashHelper.isDatePeriod(journal.getBizDate(), curPeriod, company)) {
                Object[] objects = new Object[]{String.valueOf(i + 1), DateFormat.getDateInstance().format(journal.getBizDate()), currentYear, currentMonth};
                detail.append(MessageFormat.format(row, objects)).append("\n");
            }
            this.handler.verifyJournal((CoreUIObject)this, journal, this.casPeriod);
        }
        if (!CashHelper.isEmpty(detail.toString()) && (result = MsgBox.showConfirm3((Component)((Object)this), (String)msg, (String)detail.toString())) == 1) {
            SysUtil.abort();
        }
        super.verifyInput(e);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }
}

