/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.base.core.fm.IContextHelper;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.IPermissionServiceProvider;
import com.kingdee.eas.base.permission.PermissionServiceProviderFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountTableFactory;
import com.kingdee.eas.basedata.master.account.AccountTableInfo;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.BalanceDirectionEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.BillTypeEnum;
import com.kingdee.eas.fi.cas.CasConstants;
import com.kingdee.eas.fi.cas.CashDataSourceEnum;
import com.kingdee.eas.fi.cas.CashDataTypeEnum;
import com.kingdee.eas.fi.cas.CashHelper;
import com.kingdee.eas.fi.cas.CashManagementFactory;
import com.kingdee.eas.fi.cas.ICashManagement;
import com.kingdee.eas.fi.cas.JournalSourceEnum;
import com.kingdee.eas.fi.cas.client.CashClientHelper;
import com.kingdee.eas.fi.cas.client.CashJournalFilterParam;
import com.kingdee.eas.fi.cas.client.JournalHandler;
import com.kingdee.eas.fi.cas.client.PeriodHelper;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CashJournalHandler
extends JournalHandler {
    private Logger logger = Logger.getLogger(this.getClass());
    private static final String STRING_ZERO = "0";
    private static final String STRING_ONE = "1";
    private boolean isHide = true;

    public void initCombAccountBank(KDComboBox cboAccount, CompanyOrgUnitInfo company, String acctTableId, boolean isFreeze) throws EASBizException, BOSException {
        ActionListener[] actionListener = cboAccount.getActionListeners();
        for (int i = 0; i < actionListener.length; ++i) {
            cboAccount.removeActionListener(actionListener[i]);
        }
        cboAccount.removeAllItems();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("isLeaf", (Object)STRING_ONE));
        items.add(new FilterItemInfo("isCash", (Object)STRING_ONE));
        if (!isFreeze) {
            items.add(new FilterItemInfo("isGFreeze", (Object)STRING_ZERO));
        }
        FilterInfo filterAccount = this.getAcctDataPermission();
        view.getFilter().mergeFilter(filterAccount, "and");
        AccountViewCollection accountCol = FMHelper.getAccountViewCollection(null, (String)company.getId().toString(), (String)acctTableId, null, (EntityViewInfo)view);
        if (accountCol == null || accountCol.size() == 0) {
            SysUtil.abort();
        }
        cboAccount.addItems(accountCol.toArray());
        for (int i = 0; i < actionListener.length; ++i) {
            cboAccount.addActionListener(actionListener[i]);
        }
    }

    public void initCombAccountBank(KDComboBox cboAccount, CompanyOrgUnitInfo company, String acctTableId, boolean isIncludeClosed, AccountViewCollection col) throws BOSException, EASBizException {
        int i;
        ActionListener[] actionListener = cboAccount.getActionListeners();
        for (int i2 = 0; i2 < actionListener.length; ++i2) {
            cboAccount.removeActionListener(actionListener[i2]);
        }
        cboAccount.removeAllItems();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        FilterItemCollection items = filter.getFilterItems();
        items.add(new FilterItemInfo("isLeaf", (Object)STRING_ONE));
        items.add(new FilterItemInfo("isCash", (Object)STRING_ONE));
        FilterInfo filterAccount = this.getAcctDataPermission();
        view.getFilter().mergeFilter(filterAccount, "and");
        AccountViewCollection accountCol = null;
        accountCol = FMHelper.getAccountViewCollection(null, (String)company.getId().toString(), (String)acctTableId, null, (EntityViewInfo)view);
        for (i = 0; i < accountCol.size(); ++i) {
            accountCol.get(i).setDisplayFormat("$number$ - $name$");
        }
        if (accountCol == null || accountCol.size() == 0) {
            SysUtil.abort();
        }
        cboAccount.addItems(accountCol.toArray());
        for (i = 0; i < actionListener.length; ++i) {
            cboAccount.addActionListener(actionListener[i]);
        }
    }

    private FilterInfo getAcctDataPermission() throws BOSException, EASBizException {
        IContextHelper ctxHelper = ContextHelperFactory.getRemoteInstance();
        ObjectUuidPK userPK = new ObjectUuidPK(ctxHelper.getCurrentUser().getId());
        ObjectUuidPK orgPK = new ObjectUuidPK(ctxHelper.getCurrentCompany().getId());
        IPermissionServiceProvider provider = PermissionServiceProviderFactory.getRemoteInstance();
        String rule = provider.getPermissionRule((IObjectPK)userPK, (IObjectPK)orgPK, "cas_cashbook_01view");
        EntityViewInfo evi = null;
        try {
            evi = rule == null ? new EntityViewInfo() : new EntityViewInfo(rule);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        FilterInfo filterAccount = new FilterInfo();
        boolean hasOtherAccountFilter = false;
        if (evi.getFilter() != null && evi.getFilter().getFilterItems() != null) {
            FilterItemCollection filterItems = evi.getFilter().getFilterItems();
            for (int i = 0; i < filterItems.size(); ++i) {
                FilterItemInfo item = filterItems.get(i);
                String propertyName = item.getPropertyName();
                if (propertyName.indexOf("accountView") >= 0) {
                    String property = propertyName.substring(12, propertyName.length());
                    FilterItemInfo item2 = new FilterItemInfo(property, item.getCompareValue(), item.getCompareType());
                    filterAccount.getFilterItems().add(item2);
                    continue;
                }
                hasOtherAccountFilter = true;
            }
        }
        if (!hasOtherAccountFilter && filterAccount.getFilterItems().size() > 0) {
            filterAccount.setMaskString(evi.getFilter().getMaskString());
        }
        return filterAccount;
    }

    public void initComboCashAcct(KDComboBox cboCashAcct, CompanyOrgUnitInfo company, String acctTableId) throws EASBizException, BOSException {
        cboCashAcct.removeAllItems();
        AccountViewCollection accountCol = FMHelper.getAcctViewCollection(null, (String)company.getId().toString(), (String)acctTableId, null, (AccountTypeEnum)AccountTypeEnum.CASHACCOUNT);
        if (accountCol == null || accountCol.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.fi.cas.client.CashMgtResource", (String)"NoAccountView"));
            SysUtil.abort();
        }
        cboCashAcct.addItems(accountCol.toArray());
    }

    public IRowSet getRowset(IMetaDataPK mainQueryPK, EntityViewInfo mainQuery, BOSUuid currencyId, BOSUuid accountBankId, Set cashierIDSet, CashJournalFilterParam p) throws BOSException {
        EntityViewInfo mainQueryTemp = new EntityViewInfo();
        mainQueryTemp = (EntityViewInfo)mainQuery.clone();
        FilterInfo filterHead = new FilterInfo();
        filterHead.getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyId));
        filterHead.getFilterItems().add(new FilterItemInfo("accountView.id", (Object)accountBankId));
        if (cashierIDSet != null && cashierIDSet.size() != 0) {
            filterHead.getFilterItems().add(new FilterItemInfo("cashier.id", (Object)cashierIDSet, CompareType.INCLUDE));
        }
        mainQueryTemp.getFilter().mergeFilter(filterHead, "AND");
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)mainQueryPK);
        EntityViewInfo ev = (EntityViewInfo)mainQueryTemp.clone();
        ev.getSorter().add(new SorterItemInfo("createTime"));
        ev.getSorter().add(new SorterItemInfo("lineNo"));
        exec.setObjectView(ev);
        String sql = exec.getSQL();
        this.logger.info((Object)sql);
        IRowSet rs = exec.executeQuery();
        return rs;
    }

    protected void fillOneJournalRow(KDTable tblMain, IRowSet rs, BigDecimal exchange, boolean isCurEqualsBasecur, BigDecimal debitAmt, BigDecimal creditAmt, BigDecimal balance, ConvertModeEnum convertMode, BalanceDirectionEnum dc) throws SQLException {
        IRow row = tblMain.addRow();
        row.getCell("id").setValue((Object)rs.getString("ID"));
        row.getCell("bizDate").setValue((Object)Constants.FORMAT_DAY.format(rs.getDate("bizDate")));
        row.getCell("createDate").setValue((Object)Constants.FORMAT_DAY.format(rs.getDate("createDate")));
        row.getCell("voucherType").setValue((Object)rs.getString("voucherType"));
        row.getCell("voucherNumber").setValue((Object)rs.getString("voucherNumber"));
        String oppAccount = rs.getString("oppAccountViewNumber");
        if (oppAccount != null) {
            oppAccount = oppAccount + " " + rs.getString("oppAccountViewName");
        }
        row.getCell("oppAccountNumber").setValue((Object)oppAccount);
        row.getCell("billType").setValue((Object)BillTypeEnum.getEnum(rs.getInt("billType")));
        row.getCell("billNumber").setValue((Object)rs.getString("billNumber"));
        row.getCell("description").setValue((Object)rs.getString("description"));
        if (debitAmt.compareTo(CasConstants.ZERO) != 0) {
            row.getCell("debit").setValue((Object)debitAmt);
        }
        if (creditAmt.compareTo(CasConstants.ZERO) != 0) {
            row.getCell("credit").setValue((Object)creditAmt);
        }
        row.getCell("balance").setValue((Object)balance.abs());
        row.getCell("exchange").setValue((Object)exchange);
        row.getCell("source").setValue((Object)JournalSourceEnum.getEnum((int)rs.getInt("source")));
        row.getCell("year").setValue(rs.getObject("periodYear"));
        row.getCell("period").setValue(rs.getObject("periodNumber"));
        row.getCell("cash").setValue((Object)rs.getString("cashier"));
        this.fillLocalCurrencyData(row, exchange, debitAmt, creditAmt, balance, isCurEqualsBasecur, convertMode, dc);
    }

    public void fillData_New(KDTable tblMain, IRowSet rs, CurrencyInfo sourceCurrency, String accountNumber, String accountId, CashJournalFilterParam para, CashDataSourceEnum type, Map paramMap, Set cashierIDSet, BalanceDirectionEnum dc) throws SQLException, EASBizException, BOSException {
        PeriodInfo cperiod;
        PeriodInfo temNextPeriodInfo;
        BigDecimal exchange;
        Timestamp tempDate;
        PeriodInfo period;
        BigDecimal exchange2;
        PeriodInfo Period;
        int endPeriod;
        int endYear;
        int beginPeriod;
        int beginYear;
        java.util.Date beginDate;
        boolean isShowBeginBalance = para.isShowBeginBalance();
        boolean isShowDayTotal = para.isShowDayTotal();
        boolean isShowPeriodTotal = para.isShowMonthTotal();
        boolean isShowYearTotal = para.isShowYearTotal();
        PeriodInfo beginPeriodInfo = null;
        PeriodInfo endPeriodInfo = null;
        java.util.Date bdate = para.getFromDate();
        java.util.Date edate = para.getToDate();
        String currencyNumber = sourceCurrency.getNumber();
        CompanyOrgUnitInfo companyInfo = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
        boolean isStart = false;
        isStart = paramMap.get("isStart") != null ? (Boolean)paramMap.get("isStart") : SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
        PeriodInfo startPeriod = null;
        startPeriod = paramMap.get("startPeriod") == null ? PeriodHelper.getCashStartPeriod(companyInfo) : (PeriodInfo)paramMap.get("startPeriod");
        if (startPeriod == null) {
            return;
        }
        int startPeriodYear = startPeriod.getPeriodYear();
        boolean isByDay = para.isByDay();
        if (isByDay) {
            if (para.getFromDate().before(startPeriod.getBeginDate())) {
                beginPeriodInfo = startPeriod;
                beginDate = beginPeriodInfo.getBeginDate();
            } else {
                beginPeriodInfo = PeriodHelper.getPeriodInfo(para.getFromDate(), companyInfo);
                beginDate = para.getFromDate();
            }
            if (para.getToDate().before(startPeriod.getBeginDate())) {
                return;
            }
            endPeriodInfo = PeriodHelper.getPeriodInfo(para.getToDate(), companyInfo);
            if (endPeriodInfo == null) {
                endPeriodInfo = PeriodHelper.getLastPeriodInfo(companyInfo);
            }
            beginYear = beginPeriodInfo.getPeriodYear();
            beginPeriod = beginPeriodInfo.getPeriodNumber();
            endYear = endPeriodInfo.getPeriodYear();
            endPeriod = endPeriodInfo.getPeriodNumber();
        } else {
            beginYear = para.getBeginYear();
            beginPeriod = para.getBeginMonth();
            endYear = para.getEndYear();
            endPeriod = para.getEndMonth();
            beginPeriodInfo = PeriodHelper.getPeriodInfo(beginYear, beginPeriod, companyInfo);
            endPeriodInfo = PeriodHelper.getPeriodInfo(endYear, endPeriod, companyInfo);
            if (beginPeriodInfo == null) {
                beginPeriodInfo = CashClientHelper.getStartPeriod(companyInfo);
            }
            beginDate = beginPeriodInfo.getBeginDate();
        }
        AccountTableInfo accountTable = null;
        if (paramMap.get("acctTable") != null) {
            accountTable = (AccountTableInfo)paramMap.get("acctTable");
            if (!accountTable.getId().toString().equals(para.getAcctTableId())) {
                accountTable = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(para.getAcctTableId()));
            }
        } else {
            accountTable = AccountTableFactory.getRemoteInstance().getAccountTableInfo((IObjectPK)new ObjectUuidPK(para.getAcctTableId()));
        }
        String acctTableNumber = accountTable.getNumber();
        ConvertModeEnum convertMode = this.getExchangeConvertMode(companyInfo, sourceCurrency, null);
        boolean isCurEqualsBasecur = sourceCurrency.getId().equals((Object)companyInfo.getBaseCurrency().getId());
        boolean isShowLocalCurrency = false;
        isShowLocalCurrency = paramMap.get("isShowLocalCurrency") == null ? CashHelper.isShowLocalCurrency(companyInfo.getId().toString()) : (Boolean)paramMap.get("isShowLocalCurrency");
        boolean isHide = true;
        BigDecimal exchange1 = CashJournalHandler.getExchange(companyInfo, sourceCurrency, null, beginDate);
        isHide = isCurEqualsBasecur || !isShowLocalCurrency || !isCurEqualsBasecur && exchange1.compareTo(Constants.ONE) == 0;
        this.setLocalColumnHided(tblMain, isHide);
        IRow row = null;
        BigDecimal debitAmt = null;
        BigDecimal creditAmt = null;
        BigDecimal balance = null;
        BigDecimal tmpDayDebitTotal = CasConstants.ZERO;
        BigDecimal tmpDayCreditTotal = CasConstants.ZERO;
        BigDecimal tmpMonthDebitTotal = CasConstants.ZERO;
        BigDecimal tmpMonthCreditTotal = CasConstants.ZERO;
        BigDecimal tmpYearDebitTotal = CasConstants.ZERO;
        BigDecimal tmpYearCreditTotal = CasConstants.ZERO;
        BigDecimal yearDebitAmt = CasConstants.ZERO;
        BigDecimal yearCreditAmt = CasConstants.ZERO;
        BigDecimal tempd = CasConstants.ZERO;
        BigDecimal tempc = CasConstants.ZERO;
        if (isStart && beginYear == startPeriodYear) {
            yearDebitAmt = CashHelper.getYearStartAmount(type, companyInfo.getId().toString(), accountId, null, sourceCurrency.getId().toString(), CashDataTypeEnum.JF);
            yearCreditAmt = CashHelper.getYearStartAmount(type, companyInfo.getId().toString(), accountId, null, sourceCurrency.getId().toString(), CashDataTypeEnum.DF);
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(beginDate);
        balance = isByDay ? this.getBeginBalance(companyInfo, acctTableNumber, currencyNumber, accountNumber, null, beginDate, type, false, false) : this.getBeginBalance(companyInfo, acctTableNumber, currencyNumber, accountNumber, null, beginPeriodInfo, type, false);
        BigDecimal beginYearDebitTotal = this.getYearTotal(companyInfo, acctTableNumber, currencyNumber, accountNumber, null, beginYear, beginPeriod, type, CashDataTypeEnum.JF, false);
        BigDecimal beginYearCreditTotal = this.getYearTotal(companyInfo, acctTableNumber, currencyNumber, accountNumber, null, beginYear, beginPeriod, type, CashDataTypeEnum.DF, false);
        ICashManagement cashInacct = CashManagementFactory.getRemoteInstance();
        BigDecimal adebitTotal = Constants.ZERO;
        BigDecimal acreditTotal = Constants.ZERO;
        if (isByDay && para.getFromDate().compareTo(beginPeriodInfo.getBeginDate()) > 0) {
            adebitTotal = cashInacct.cash(companyInfo.getNumber(), CashDataSourceEnum.C, acctTableNumber, accountNumber, null, currencyNumber, beginPeriodInfo.getBeginDate(), DateHelper.getBeforeDay((java.util.Date)para.getFromDate()), CashDataTypeEnum.JF, false);
            acreditTotal = cashInacct.cash(companyInfo.getNumber(), CashDataSourceEnum.C, acctTableNumber, accountNumber, null, currencyNumber, beginPeriodInfo.getBeginDate(), DateHelper.getBeforeDay((java.util.Date)para.getFromDate()), CashDataTypeEnum.DF, false);
            tmpMonthDebitTotal = adebitTotal;
            tmpMonthCreditTotal = acreditTotal;
        }
        if (beginYear == startPeriod.getPeriodYear() && beginPeriod == startPeriod.getPeriodNumber()) {
            row = tblMain.addRow();
            BigDecimal yearBeginBalance = null;
            if (!isStart) {
                yearBeginBalance = CasConstants.ZERO;
            } else if (isByDay) {
                BigDecimal b = this.getBeginBalance(companyInfo, acctTableNumber, currencyNumber, accountNumber, null, startPeriod.getBeginDate(), type, false, false);
                if (b == null) {
                    b = CasConstants.ZERO;
                }
                yearBeginBalance = b.add(yearCreditAmt).subtract(yearDebitAmt);
            } else {
                yearBeginBalance = balance.add(yearCreditAmt).subtract(yearDebitAmt);
            }
            PeriodInfo period2 = PeriodHelper.getPeriodInfo(beginYear, beginPeriod, companyInfo);
            Timestamp tempDate2 = period2.getEndDate();
            BigDecimal exchange3 = CashJournalHandler.getExchange(companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((java.util.Date)tempDate2));
            this.fillBalance(companyInfo, beginYear, beginPeriod, row, exchange3, yearBeginBalance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc);
        }
        if (rs == null || rs.size() == 0) {
            if (beginYear == startPeriodYear) {
                tmpYearDebitTotal = beginYearDebitTotal.add(yearDebitAmt);
                tmpYearCreditTotal = beginYearCreditTotal.add(yearCreditAmt);
            } else {
                tmpYearDebitTotal = beginYearDebitTotal;
                tmpYearCreditTotal = beginYearCreditTotal;
            }
            tmpMonthDebitTotal = CasConstants.ZERO;
            tmpMonthCreditTotal = CasConstants.ZERO;
            tmpYearDebitTotal = tmpYearDebitTotal.add(adebitTotal);
            tmpYearCreditTotal = tmpYearCreditTotal.add(acreditTotal);
            if (isByDay) {
                this.fillAdjustRow_NewDay(tmpMonthDebitTotal, tmpMonthCreditTotal, tmpYearDebitTotal, tmpYearCreditTotal, tblMain, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, para.getFromDate(), para.getToDate(), sourceCurrency, dc);
            } else {
                this.fillAdjustRow_New(adebitTotal, acreditTotal, tmpYearDebitTotal, tmpYearCreditTotal, tblMain, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, sourceCurrency, dc);
            }
            return;
        }
        Date date = null;
        int year = beginYear;
        int periodNumber = beginPeriod;
        int tmpYear = beginYear;
        int tmpPeriodNumber = beginPeriod;
        java.util.Date tmpdate = null;
        if (rs.next()) {
            date = rs.getDate("createDate");
            year = rs.getInt("periodyear");
            periodNumber = rs.getInt("periodnumber");
            tmpYear = rs.getInt("periodyear");
            tmpPeriodNumber = rs.getInt("periodnumber");
            tmpdate = rs.getDate("createDate");
            rs.beforeFirst();
        }
        if (beginYear < year || beginYear == year && beginPeriod < periodNumber) {
            endPeriodInfo = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
            endPeriodInfo = PeriodHelper.getPrePeriodInfo(companyInfo, endPeriodInfo);
            if (beginYear == startPeriodYear) {
                tmpYearDebitTotal = beginYearDebitTotal.add(yearDebitAmt);
                tmpYearCreditTotal = beginYearCreditTotal.add(yearCreditAmt);
            } else {
                tmpYearDebitTotal = beginYearDebitTotal;
                tmpYearCreditTotal = beginYearCreditTotal;
            }
            this.fillAdjustRow_New(CasConstants.ZERO, CasConstants.ZERO, tmpYearDebitTotal, tmpYearCreditTotal, tblMain, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, sourceCurrency, dc);
        }
        if (isShowBeginBalance) {
            row = tblMain.addRow();
            PeriodInfo period3 = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
            Timestamp tempDate3 = period3.getEndDate();
            BigDecimal exchange4 = CashJournalHandler.getExchange(companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((java.util.Date)tempDate3));
            this.fillBalance(companyInfo, year, periodNumber, row, exchange4, balance, isCurEqualsBasecur, BEGIN_BALANCE, convertMode, dc);
        }
        BigDecimal dayBalance = balance;
        if (isByDay && rs != null && rs.size() != 0) {
            dayBalance = balance = this.getBeginBalance(companyInfo, acctTableNumber, currencyNumber, accountNumber, null, beginDate, type, false, false);
        }
        if (year == startPeriodYear) {
            tmpYearDebitTotal = beginYearDebitTotal.add(yearDebitAmt);
            tmpYearCreditTotal = beginYearCreditTotal.add(yearCreditAmt);
        } else {
            tmpYearDebitTotal = beginYearDebitTotal;
            tmpYearCreditTotal = beginYearCreditTotal;
        }
        tmpYear = beginYear;
        while (rs.next()) {
            year = rs.getInt("periodyear");
            periodNumber = rs.getInt("periodnumber");
            date = rs.getDate("createDate");
            debitAmt = rs.getBigDecimal("debitAmount");
            creditAmt = rs.getBigDecimal("creditAmount");
            if (debitAmt == null) {
                debitAmt = CasConstants.ZERO;
            }
            if (creditAmt == null) {
                creditAmt = CasConstants.ZERO;
            }
            if (date.compareTo(tmpdate) == 0) {
                tmpDayDebitTotal = tmpDayDebitTotal.add(debitAmt);
                tmpDayCreditTotal = tmpDayCreditTotal.add(creditAmt);
            }
            if (date.compareTo(tmpdate) != 0) {
                if (isShowDayTotal) {
                    row = tblMain.addRow();
                    if (tmpdate == null) {
                        Period = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                        tmpdate = Period.getEndDate();
                    }
                    exchange2 = CashJournalHandler.getExchange(companyInfo, sourceCurrency, null, tmpdate);
                    this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, tmpdate, row, exchange2, tmpDayDebitTotal, tmpDayCreditTotal, balance, isCurEqualsBasecur, DAY_TOTAL, convertMode, dc);
                }
                tmpMonthDebitTotal = tmpMonthDebitTotal.add(tmpDayDebitTotal);
                tmpMonthCreditTotal = tmpMonthCreditTotal.add(tmpDayCreditTotal);
                tmpDayDebitTotal = debitAmt;
                tmpDayCreditTotal = creditAmt;
            }
            tempd = tempd.add(debitAmt);
            tempc = tempc.add(creditAmt);
            if (tmpPeriodNumber != periodNumber) {
                PeriodInfo cPeriod;
                if (isShowPeriodTotal) {
                    row = tblMain.addRow();
                    period = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                    tempDate = period.getEndDate();
                    exchange = CashJournalHandler.getExchange(companyInfo, sourceCurrency, null, tempDate);
                    if (isByDay) {
                        cPeriod = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                        if (cPeriod.getEndDate().compareTo(new Timestamp(para.getToDate().getTime())) > 0) {
                            this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, para.getToDate(), row, exchange, tmpMonthDebitTotal.subtract(adebitTotal), tmpMonthCreditTotal.subtract(acreditTotal), balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc);
                        } else {
                            this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpMonthDebitTotal.subtract(adebitTotal), tmpMonthCreditTotal.subtract(acreditTotal), balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc);
                        }
                        adebitTotal = CasConstants.ZERO;
                        acreditTotal = CasConstants.ZERO;
                    } else {
                        this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc);
                    }
                    tempd = debitAmt;
                    tempc = creditAmt;
                }
                tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
                tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
                if (isShowYearTotal) {
                    row = tblMain.addRow();
                    period = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                    tempDate = period.getEndDate();
                    exchange = CashJournalHandler.getExchange(companyInfo, sourceCurrency, null, tempDate);
                    if (isByDay) {
                        cPeriod = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                        if (cPeriod.getEndDate().compareTo(new Timestamp(para.getToDate().getTime())) > 0) {
                            this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, para.getToDate(), row, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc);
                        } else {
                            this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc);
                        }
                    } else {
                        this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc);
                        if (tmpYear < endYear || tmpYear == endYear && tmpPeriodNumber < endPeriod) {
                            beginPeriodInfo = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                            temNextPeriodInfo = PeriodHelper.getNextPeriodInfo(companyInfo, beginPeriodInfo);
                            if (temNextPeriodInfo == null) {
                                return;
                            }
                            if ((temNextPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temNextPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temNextPeriodInfo.getPeriodNumber()) && beginPeriodInfo.getPeriodYear() < temNextPeriodInfo.getPeriodYear()) {
                                row = tblMain.addRow();
                                PeriodInfo period2 = PeriodHelper.getPeriodInfo(temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), companyInfo);
                                Timestamp tempDate2 = period2.getEndDate();
                                BigDecimal exchange22 = CashJournalHandler.getExchange(companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((java.util.Date)tempDate2));
                                this.fillBalance(companyInfo, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), row, exchange22, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc);
                                tmpYearDebitTotal = CasConstants.ZERO;
                                tmpYearCreditTotal = CasConstants.ZERO;
                            }
                        }
                    }
                }
                beginPeriodInfo = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                beginPeriodInfo = PeriodHelper.getNextPeriodInfo(companyInfo, beginPeriodInfo);
                endPeriodInfo = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
                endPeriodInfo = PeriodUtils.getPrePeriodInfo((PeriodInfo)endPeriodInfo);
                this.fillAdjustRow_New(CasConstants.ZERO, CasConstants.ZERO, tmpYearDebitTotal, tmpYearCreditTotal, tblMain, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, sourceCurrency, dc);
                tmpMonthDebitTotal = CasConstants.ZERO;
                tmpMonthCreditTotal = CasConstants.ZERO;
            }
            if (tmpYear != year) {
                tmpYearDebitTotal = CasConstants.ZERO;
                tmpYearCreditTotal = CasConstants.ZERO;
            }
            period = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
            tempDate = period.getEndDate();
            exchange = CashJournalHandler.getExchange(companyInfo, sourceCurrency, null, DateUtil.getBeforeDay((java.util.Date)tempDate));
            if (tmpYear != year) {
                row = tblMain.addRow();
                this.fillBalance(companyInfo, year, periodNumber, row, exchange, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc);
            }
            if (tmpPeriodNumber != periodNumber && isShowBeginBalance) {
                row = tblMain.addRow();
                this.fillBalance(companyInfo, year, periodNumber, row, exchange, balance, isCurEqualsBasecur, BEGIN_BALANCE, convertMode, dc);
            }
            balance = balance.add(debitAmt).subtract(creditAmt);
            BigDecimal exchange23 = CashJournalHandler.getExchange(companyInfo, sourceCurrency, null, new java.util.Date(rs.getDate("bizDate").getTime()));
            this.fillOneJournalRow(tblMain, rs, exchange23, isCurEqualsBasecur, debitAmt, creditAmt, balance, convertMode, dc);
            tmpdate = date;
            tmpYear = year;
            tmpPeriodNumber = periodNumber;
        }
        if (isShowDayTotal) {
            row = tblMain.addRow();
            if (tmpdate == null) {
                Period = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
                tmpdate = Period.getEndDate();
            }
            exchange2 = CashJournalHandler.getExchange(companyInfo, sourceCurrency, null, tmpdate);
            this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, date, row, exchange2, tmpDayDebitTotal, tmpDayCreditTotal, balance, isCurEqualsBasecur, DAY_TOTAL, convertMode, dc);
        }
        if (isByDay) {
            period = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
            java.util.Date endDate = period.getEndDate();
            if ((endDate = new java.util.Date(endDate.getTime())).after(para.getToDate())) {
                endDate = para.getToDate();
            }
            if (cashierIDSet != null) {
                balance = cashInacct.cash(companyInfo.getNumber(), type, acctTableNumber, accountNumber, null, currencyNumber, period.getBeginDate(), endDate, CashDataTypeEnum.Y, false);
                tmpMonthDebitTotal = tempd;
                tmpMonthCreditTotal = tempc;
                tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
                tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
            } else if (CashHelper.isTheSameMonth(bdate, edate)) {
                adebitTotal = cashInacct.cash(companyInfo.getNumber(), CashDataSourceEnum.C, acctTableNumber, accountNumber, null, currencyNumber, beginPeriodInfo.getBeginDate(), DateHelper.getBeforeDay((java.util.Date)para.getFromDate()), CashDataTypeEnum.JF, false);
                acreditTotal = cashInacct.cash(companyInfo.getNumber(), CashDataSourceEnum.C, acctTableNumber, accountNumber, null, currencyNumber, beginPeriodInfo.getBeginDate(), DateHelper.getBeforeDay((java.util.Date)para.getFromDate()), CashDataTypeEnum.DF, false);
                tmpMonthDebitTotal = tmpMonthDebitTotal.subtract(adebitTotal).add(tmpDayDebitTotal);
                tmpMonthCreditTotal = tmpMonthCreditTotal.subtract(acreditTotal).add(tmpDayCreditTotal);
                tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
                tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
            } else {
                balance = cashInacct.cash(companyInfo.getNumber(), type, acctTableNumber, accountNumber, null, currencyNumber, period.getBeginDate(), endDate, CashDataTypeEnum.Y, false);
                tmpMonthDebitTotal = cashInacct.cash(companyInfo.getNumber(), type, acctTableNumber, accountNumber, null, currencyNumber, period.getBeginDate(), endDate, CashDataTypeEnum.JF, false);
                tmpMonthCreditTotal = cashInacct.cash(companyInfo.getNumber(), type, acctTableNumber, accountNumber, null, currencyNumber, period.getBeginDate(), endDate, CashDataTypeEnum.DF, false);
                tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
                tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
            }
        } else {
            tmpMonthDebitTotal = tmpMonthDebitTotal.add(tmpDayDebitTotal);
            tmpMonthCreditTotal = tmpMonthCreditTotal.add(tmpDayCreditTotal);
            tmpYearDebitTotal = tmpYearDebitTotal.add(tmpMonthDebitTotal);
            tmpYearCreditTotal = tmpYearCreditTotal.add(tmpMonthCreditTotal);
        }
        if (CashHelper.isTheSameMonth(bdate, edate)) {
            tmpYearDebitTotal = tmpYearDebitTotal.add(adebitTotal);
            tmpYearCreditTotal = tmpYearCreditTotal.add(acreditTotal);
        }
        if (isShowPeriodTotal) {
            row = tblMain.addRow();
            cperiod = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
            tempDate = cperiod.getEndDate();
            exchange = CashJournalHandler.getExchange(companyInfo, sourceCurrency, null, tempDate);
            if (isByDay) {
                if (cperiod.getEndDate().compareTo(new Timestamp(para.getToDate().getTime())) > 0) {
                    this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, para.getToDate(), row, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc);
                } else {
                    this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc);
                }
            } else {
                this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpMonthDebitTotal, tmpMonthCreditTotal, balance, isCurEqualsBasecur, PERIOD_TOTAL, convertMode, dc);
            }
        }
        if (isShowYearTotal) {
            row = tblMain.addRow();
            cperiod = PeriodHelper.getPeriodInfo(tmpYear, tmpPeriodNumber, companyInfo);
            tempDate = cperiod.getEndDate();
            exchange = CashJournalHandler.getExchange(companyInfo, sourceCurrency, null, tempDate);
            if (isByDay) {
                if (cperiod.getEndDate().compareTo(new Timestamp(para.getToDate().getTime())) > 0) {
                    this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, para.getToDate(), row, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc);
                } else {
                    this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc);
                }
            } else {
                this.fillTotal(companyInfo, tmpYear, tmpPeriodNumber, null, row, exchange, tmpYearDebitTotal, tmpYearCreditTotal, balance, isCurEqualsBasecur, YEAR_TOTAL, convertMode, dc);
                if (year < endYear || year == endYear && periodNumber < endPeriod) {
                    beginPeriodInfo = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
                    temNextPeriodInfo = PeriodHelper.getNextPeriodInfo(companyInfo, beginPeriodInfo);
                    if (temNextPeriodInfo == null) {
                        return;
                    }
                    if ((temNextPeriodInfo.getPeriodYear() < endPeriodInfo.getPeriodYear() || temNextPeriodInfo.getPeriodYear() == endPeriodInfo.getPeriodYear() && endPeriodInfo.getPeriodNumber() >= temNextPeriodInfo.getPeriodNumber()) && beginPeriodInfo.getPeriodYear() < temNextPeriodInfo.getPeriodYear()) {
                        row = tblMain.addRow();
                        this.fillBalance(companyInfo, temNextPeriodInfo.getPeriodYear(), temNextPeriodInfo.getPeriodNumber(), row, exchange, balance, isCurEqualsBasecur, YEAR_BALANCE, convertMode, dc);
                        tmpYearDebitTotal = CasConstants.ZERO;
                        tmpYearCreditTotal = CasConstants.ZERO;
                    }
                }
            }
        }
        if (year < endYear || year == endYear && periodNumber < endPeriod) {
            beginPeriodInfo = PeriodHelper.getPeriodInfo(year, periodNumber, companyInfo);
            beginPeriodInfo = PeriodHelper.getNextPeriodInfo(companyInfo, beginPeriodInfo);
            endPeriodInfo = PeriodHelper.getPeriodInfo(endYear, endPeriod, companyInfo);
            if (isByDay && !para.getToDate().equals(endPeriodInfo.getEndDate())) {
                endPeriodInfo = PeriodHelper.getPrePeriodInfo(companyInfo, endPeriodInfo);
            }
            this.fillAdjustRow_New(CasConstants.ZERO, CasConstants.ZERO, tmpYearDebitTotal, tmpYearCreditTotal, tblMain, isShowBeginBalance, isShowPeriodTotal, isShowYearTotal, companyInfo, isCurEqualsBasecur, balance, beginPeriodInfo, endPeriodInfo, convertMode, sourceCurrency, dc);
        }
        exchange2 = CashJournalHandler.getExchange(companyInfo, sourceCurrency, null, beginDate);
        this.setBeginBalanceRowDisc(tblMain, beginDate, isByDay, exchange2, isCurEqualsBasecur, dayBalance, convertMode, dc);
    }

    protected void setLocalColumnHide(KDTable tblMain) {
        this.setLocalColumnHided(tblMain, this.isHide);
    }
}

