/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.cas.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.expr.Variant;
import com.kingdee.bos.ctrl.kdf.headfootdesigner.HeadFootModel;
import com.kingdee.bos.ctrl.kdf.printprovider.headerfooter.ExtVarProvider;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.Constants;
import com.kingdee.eas.base.core.fm.ContextHelperFactory;
import com.kingdee.eas.basedata.assistant.AccountBankFactory;
import com.kingdee.eas.basedata.assistant.AccountBankInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.calc.CalculatorDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fi.cas.AccountTypeEnum;
import com.kingdee.eas.fi.cas.BatchFetchParamFacadeFactory;
import com.kingdee.eas.fi.cas.CashMgtInitFacadeFactory;
import com.kingdee.eas.fi.cas.ICashMgtInitFacade;
import com.kingdee.eas.fi.cas.JournalBalanceInfo;
import com.kingdee.eas.fi.cas.JournalFactory;
import com.kingdee.eas.fi.cas.JournalInfo;
import com.kingdee.eas.fi.cas.client.AbstractCashMgtInitHandler;
import com.kingdee.eas.fi.cas.client.AbstractCashMgtInitUI;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustEditUI;
import com.kingdee.eas.fi.cas.client.BankBalanceAdjustFilterParam;
import com.kingdee.eas.fi.cas.client.CashMgtInitJournalUI;
import com.kingdee.eas.fi.cas.client.ClientUtils;
import com.kingdee.eas.fi.cas.client.PeriodSelectUI;
import com.kingdee.eas.fi.gl.GlUtils;
import com.kingdee.eas.fm.common.FMHelper;
import com.kingdee.eas.fm.common.client.FMClientHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class CashMgtInitUI
extends AbstractCashMgtInitUI {
    private static final String resourcePath = "com.kingdee.eas.fi.cas.client.CashMgtResource";
    private AbstractCashMgtInitHandler handler;
    private PeriodInfo startPeriodInfo;
    private CompanyOrgUnitInfo company;
    private CurrencyInfo currency;
    private KDFormattedTextField txtField;
    private CalculatorDialog calc;
    private boolean isEdit = false;
    private boolean isSave = false;
    BigDecimal oldVal = null;
    private boolean isAcctTypeFirst = false;
    private boolean isCurrencyFirst = false;
    private ICell selectedCell = null;
    private boolean isLoaded = false;
    private boolean isFirstPeriod;
    Map paramValue = new HashMap();
    private boolean shouldReloadPrintVar = true;

    protected KDTDefaultCellEditor getNumberEditor() {
        this.setTxtField();
        KDTDefaultCellEditor tmpNumberEditor = new KDTDefaultCellEditor((JTextField)this.txtField);
        tmpNumberEditor.setClickCountToStart(1);
        return tmpNumberEditor;
    }

    @Override
    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception {
        this.setTxtField();
        int column = this.tblMain.getSelectManager().getActiveColumnIndex();
        int row = this.tblMain.getSelectManager().getActiveRowIndex();
        if (this.calc == null) {
            this.calc = new CalculatorDialog((Container)this.getUIContext().get("Owner"));
        }
        this.calc.setInitValue(null);
        BigDecimal number = this.calc.showDialog(2, true);
        ICell selectedCell = this.tblMain.getCell(row, column);
        if (selectedCell != null && !selectedCell.getStyleAttributes().isLocked() && number != null) {
            FMClientHelper.setNumberValueForCell((Component)((Object)this), (ICell)selectedCell, (BigDecimal)number);
            this.tblMain_editStopped(null);
        }
    }

    protected void btnCalculator_actionPerformed(ActionEvent e) throws Exception {
        this.setTxtField();
        int column = this.tblMain.getSelectManager().getActiveColumnIndex();
        int row = this.tblMain.getSelectManager().getActiveRowIndex();
        if (this.calc == null) {
            this.calc = new CalculatorDialog((Container)this.getUIContext().get("Owner"));
        }
        this.calc.setInitValue(null);
        BigDecimal number = this.calc.showDialog(2, true);
        ICell selectedCell = this.tblMain.getCell(row, column);
        if (selectedCell != null && !selectedCell.getStyleAttributes().isLocked() && number != null) {
            selectedCell.setValue((Object)number);
            this.tblMain_editStopped(null);
        }
    }

    private void setTxtField() {
        if (this.txtField == null) {
            this.txtField = new KDFormattedTextField(1);
        }
        this.txtField.setPrecision(FMClientHelper.getPrecOfCurrency((BOSUuid)this.currency.getId()));
        this.txtField.setHorizontalAlignment(4);
        this.txtField.setDataVerifierType(-1);
        this.txtField.setSupportedEmpty(true);
        this.txtField.setMaximumValue((Comparable)GlUtils.maxBigDecimal);
        this.txtField.setMinimumValue((Comparable)GlUtils.minBigDecimal);
    }

    @Override
    public void actionAdjustedBalanceTable_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getSelectManager().size() == 0 || this.tblMain.getSelectManager().get().getTop() < 0) {
            String strMessage = EASResource.getString((String)resourcePath, (String)"cm35");
            MsgBox.showInfo((Component)((Object)this), (String)strMessage);
            return;
        }
        CurrencyInfo currencyInfo = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        int top = this.tblMain.getSelectManager().get().getTop();
        JournalBalanceInfo journalBalanceInfo = (JournalBalanceInfo)this.tblMain.getRow(top).getUserObject();
        AccountBankInfo bankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(journalBalanceInfo.getAccountBank().getId().toString()));
        if (bankInfo.getShareType().getValue() != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"sharedAcctAdjustedBalance"));
            SysUtil.abort();
        }
        BankBalanceAdjustFilterParam param = new BankBalanceAdjustFilterParam();
        param.setForInit(true);
        HashSet<String> idSet = new HashSet<String>();
        idSet.add(bankInfo.getCompany().getId().toString());
        param.setCompanys(idSet);
        param.setCurrencyId(this.currency.getId().toString());
        param.setPeriodYear(new Integer(this.startPeriodInfo.getPeriodYear()));
        param.setPeriodNum(new Integer(this.startPeriodInfo.getPeriodNumber()));
        HashSet<String> bankIdSet = new HashSet<String>();
        bankIdSet.add(bankInfo.getId().toString());
        param.setBankAcctIds(bankIdSet);
        param.setBankAccts(new Object[]{bankInfo});
        param.setPeriodId(this.startPeriodInfo.getId().toString());
        BankBalanceAdjustEditUI.showDialogUI((IUIObject)this, param);
    }

    @Override
    protected void btnRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.btnRefresh_actionPerformed(e);
        this.initUI();
        this.loadFields();
    }

    @Override
    public void actionCheckBalance_actionPerformed(ActionEvent e) throws Exception {
        super.actionCheckBalance_actionPerformed(e);
        this.checkBalance();
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getIsInit(this.company)) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"CheckSubmit"));
            SysUtil.abort();
        }
        this.handler.storeField(this.tblMain);
        this.isSave = true;
        this.isEdit = false;
        this.showStatusMessage(AbstractCashMgtInitHandler.SAVESUCCESS);
        this.btnRefresh_actionPerformed(null);
    }

    private boolean getIsInit(CompanyOrgUnitInfo companyInfo) throws EASBizException, BOSException {
        return SystemStatusCtrolUtils.isStart(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)companyInfo);
    }

    public void checkBalance() throws Exception {
        ICashMgtInitFacade init = CashMgtInitFacadeFactory.getRemoteInstance();
        Vector vec = init.getContrastWithGL(this.company.getId().toString(), this.startPeriodInfo.getId().toString());
        if (vec != null && vec.size() > 0) {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"vec", (Object)vec);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create("com.kingdee.eas.fi.cas.client.CashMgtInitFailureReportUI", (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
        } else {
            this.showStatusMessage(EASResource.getString((String)resourcePath, (String)"cm37"));
        }
    }

    private void showStatusMessage(String msg) {
        this.setMessageText(msg);
        this.showMessage();
    }

    @Override
    public void actionFinishInit_actionPerformed(ActionEvent e) throws Exception {
        super.actionFinishInit_actionPerformed(e);
        this.finishInit();
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        PeriodInfo periodInfo;
        if (this.getIsInit(this.company)) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"CheckSubmit"));
            this.setWorkButtonForInit(true);
            SysUtil.abort();
        }
        super.actionImport_actionPerformed(e);
        boolean isGLStart = (Boolean)this.paramValue.get("isGLStart");
        if (!isGLStart) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckGLIsStart"));
            SysUtil.abort();
        }
        if ((periodInfo = PeriodSelectUI.showDialogWindow((IUIObject)this, this.company)) == null || periodInfo.getId() == null) {
            return;
        }
        this.handler.importFromGLToInit(this.tblMain, periodInfo.getId().toString());
        this.showStatusMessage(EASResource.getString((String)resourcePath, (String)"cm76"));
        if (this.handler.isImportChanged()) {
            this.isEdit = true;
            this.isSave = false;
        }
    }

    @Override
    public void actionInitAgain_actionPerformed(ActionEvent e) throws Exception {
        super.actionInitAgain_actionPerformed(e);
        this.antiInit();
        this.changeButtonStatus();
    }

    private void antiInit() throws EASBizException, BOSException {
        String companyID;
        SystemStatusCtrolUtils sscUtils;
        if (!this.getIsInit(this.company)) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"CheckAntiInit"));
            this.setWorkButtonForInit(false);
            SysUtil.abort();
        }
        if ((sscUtils = new SystemStatusCtrolUtils()).isRelatedAccount4Client(companyID = this.company.getId().toString(), SystemEnum.CASHMANAGEMENT) && sscUtils.isEqualsCurPeriodAndRelPeriod4Client(companyID, SystemEnum.CASHMANAGEMENT)) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"CancelCASAndGL"));
            SysUtil.abort();
        }
        ICashMgtInitFacade iCashMgtInitFacade = CashMgtInitFacadeFactory.getRemoteInstance();
        String strCompanyId = this.company.getId().toString();
        String strPeriodId = this.startPeriodInfo.getId().toString();
        iCashMgtInitFacade.antiInit(strCompanyId, strPeriodId);
        this.setWorkButtonForInit(false);
        this.handler.initKDTableFormatter(this.tblMain);
        this.showStatusMessage(EASResource.getString((String)resourcePath, (String)"cm41"));
    }

    @Override
    public void actionSave_actionPerformed(ActionEvent e) throws Exception {
        super.actionSave_actionPerformed(e);
    }

    @Override
    public void actionUnreachedBankBook_actionPerformed(ActionEvent e) throws Exception {
        if (this.getIsInit(this.company)) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"CheckSubmit"));
            this.setWorkButtonForInit(true);
            SysUtil.abort();
        }
        int flag = -1;
        if (this.isEdit && !this.isSave) {
            flag = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckSaveAndUnreached"));
        }
        switch (flag) {
            case 0: {
                this.actionSubmit_actionPerformed(null);
                super.actionUnreachedBankBook_actionPerformed(e);
                this.bankUnreached();
            }
            case 1: {
                super.actionUnreachedBankBook_actionPerformed(e);
                this.bankUnreached();
            }
            case 2: {
                return;
            }
        }
        super.actionUnreachedBankBook_actionPerformed(e);
        this.bankUnreached();
    }

    private void bankUnreached() throws Exception {
        IRow row = this.getSelectedRow(this.tblMain);
        AccountBankInfo accBankInfo = (AccountBankInfo)row.getCell("bankAcct").getUserObject();
        AccountViewInfo accViewInfo = (AccountViewInfo)row.getCell("bankDepositAcct").getUserObject();
        accBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accBankInfo.getId().toString()));
        if (accBankInfo.getShareType().getValue() != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"sharedAcctUnreachedBankBook"));
            SysUtil.abort();
        }
        CashMgtInitJournalUI.initBankUnreached((IUIObject)this, this.currency, this.startPeriodInfo, accBankInfo, accViewInfo);
        this.btnRefresh_actionPerformed(null);
    }

    @Override
    public void actionUnreachedBankStatement_actionPerformed(ActionEvent e) throws Exception {
        if (this.getIsInit(this.company)) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"CheckSubmit"));
            this.setWorkButtonForInit(true);
            SysUtil.abort();
        }
        int flag = -1;
        if (this.isEdit && !this.isSave) {
            flag = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckSaveAndUnreached"));
        }
        switch (flag) {
            case 0: {
                this.actionSubmit_actionPerformed(null);
                super.actionUnreachedBankStatement_actionPerformed(e);
                this.enterpriseUnreached();
            }
            case 1: {
                super.actionUnreachedBankStatement_actionPerformed(e);
                this.enterpriseUnreached();
            }
            case 2: {
                return;
            }
        }
        super.actionUnreachedBankBook_actionPerformed(e);
        this.enterpriseUnreached();
    }

    private void enterpriseUnreached() throws Exception {
        IRow row = this.getSelectedRow(this.tblMain);
        AccountBankInfo accBankInfo = (AccountBankInfo)row.getCell("bankAcct").getUserObject();
        AccountViewInfo accViewInfo = (AccountViewInfo)row.getCell("bankDepositAcct").getUserObject();
        accBankInfo = AccountBankFactory.getRemoteInstance().getAccountBankInfo((IObjectPK)new ObjectUuidPK(accBankInfo.getId().toString()));
        if (accBankInfo.getShareType().getValue() != 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"sharedAcctUnreached"));
            SysUtil.abort();
        }
        CashMgtInitJournalUI.initEnterpriseUnreached((IUIObject)this, this.currency, this.startPeriodInfo, accBankInfo, accViewInfo);
        this.btnRefresh_actionPerformed(null);
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        if (!this.getIsInit(this.company)) {
            this.changeButtonStatus();
        }
    }

    private void changeButtonStatus() {
        Object type = this.cboAccountType.getSelectedItem();
        if (AccountTypeEnum.BANKACCOUNT.equals(type)) {
            this.actionUnreachedBankBook.setEnabled(true);
            this.actionUnreachedBankStatement.setEnabled(false);
        } else if (AccountTypeEnum.ACCTSTATEMENT.equals(type)) {
            this.actionUnreachedBankBook.setEnabled(false);
            this.actionUnreachedBankStatement.setEnabled(true);
        } else {
            this.actionUnreachedBankBook.setEnabled(false);
            this.actionUnreachedBankStatement.setEnabled(false);
        }
    }

    public static boolean isZERO(BigDecimal o) {
        return o == null || o.compareTo(Constants.ZERO) == 0;
    }

    public boolean isRowNotValid(IRow row) {
        Object debitObj = row.getCell("yearDebitAmt").getValue();
        Object creditObj = row.getCell("yearCreditAmt").getValue();
        Object balanceObj = row.getCell("beginBalance").getValue();
        boolean isDebitNotValid = AbstractCashMgtInitHandler.isNull(debitObj);
        boolean isCreditNotValid = AbstractCashMgtInitHandler.isNull(creditObj);
        boolean isBalanceNotValid = AbstractCashMgtInitHandler.isNull(balanceObj);
        boolean isRowNotValid = isDebitNotValid || isCreditNotValid || isBalanceNotValid;
        return isRowNotValid;
    }

    @Override
    protected void cboAccountType_actionPerformed(ActionEvent e) throws Exception {
        if (this.isLoaded) {
            return;
        }
        if (!this.isAcctTypeFirst && this.handler.getAccountType().equals(this.cboAccountType.getSelectedItem())) {
            return;
        }
        this.isAcctTypeFirst = false;
        super.cboAccountType_actionPerformed(e);
        int flag = -1;
        if (this.isEdit && !this.isSave) {
            flag = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckSaveAndSwitch"));
        } else {
            this.initUI();
            this.loadFields();
        }
        switch (flag) {
            case 0: {
                this.actionSubmit_actionPerformed(null);
            }
            case 1: {
                this.initUI();
                this.cboAccountType.setSelectedItem((Object)this.handler.getAccountType());
                this.loadFields();
            }
            case 2: {
                this.cboAccountType.setSelectedItem((Object)this.handler.getAccountType());
                return;
            }
        }
    }

    @Override
    protected void cboCurrency_actionPerformed(ActionEvent e) throws Exception {
        if (this.isLoaded) {
            return;
        }
        if (!this.isCurrencyFirst && this.handler.getCurrency().equals(this.cboCurrency.getSelectedItem())) {
            return;
        }
        this.isCurrencyFirst = false;
        super.cboCurrency_actionPerformed(e);
        int flag = -1;
        if (this.isEdit && !this.isSave) {
            flag = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckSaveAndSwitch"));
        } else {
            this.initUI();
            this.loadFields();
        }
        switch (flag) {
            case 0: {
                this.actionSubmit_actionPerformed(null);
            }
            case 1: {
                this.initUI();
                this.cboCurrency.setSelectedItem((Object)this.handler.getCurrency());
                this.loadFields();
            }
            case 2: {
                this.cboCurrency.setSelectedItem((Object)this.handler.getCurrency());
                return;
            }
        }
    }

    @Override
    public void loadFields() {
        try {
            this.handler.loadField(this.tblMain);
            if (!this.handler.isDisplayImport()) {
                this.ActionImport.setEnabled(false);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void initUI() throws Exception {
        this.isEdit = false;
        this.isSave = false;
        FMClientHelper.clearTable((KDTable)this.tblMain);
        AccountTypeEnum acctType = (AccountTypeEnum)((Object)this.cboAccountType.getSelectedItem());
        if (acctType.equals((Object)AccountTypeEnum.CASHACCOUNT)) {
            this.btnUnreachedBankStatement.setVisible(false);
            this.btnUnreachedBankBook.setVisible(false);
            this.btnAdjustedBalanceTable.setVisible(false);
            this.actionUnreachedBankBook.setVisible(false);
            this.actionUnreachedBankStatement.setVisible(false);
            this.actionAdjustedBalanceTable.setVisible(false);
        } else {
            this.btnUnreachedBankStatement.setVisible(true);
            this.btnUnreachedBankBook.setVisible(true);
            this.btnAdjustedBalanceTable.setVisible(true);
            this.actionUnreachedBankBook.setVisible(true);
            this.actionUnreachedBankStatement.setVisible(true);
            this.actionAdjustedBalanceTable.setVisible(true);
            if (acctType.equals((Object)AccountTypeEnum.ACCTSTATEMENT)) {
                this.ActionImport.setVisible(false);
            } else {
                this.ActionImport.setVisible(true);
            }
        }
        if (!this.getIsInit(this.company)) {
            if (acctType.equals((Object)AccountTypeEnum.ACCTSTATEMENT)) {
                this.ActionImport.setEnabled(false);
                this.ActionImport.setVisible(false);
            } else {
                this.ActionImport.setVisible(true);
                this.ActionImport.setEnabled(true);
            }
            this.changeButtonStatus();
        }
        this.handler = AbstractCashMgtInitHandler.getInstance(acctType);
        this.handler.setAccountType(acctType);
        this.currency = (CurrencyInfo)this.cboCurrency.getSelectedItem();
        this.handler.setCurrency(this.currency);
        this.handler.setCompanyInfo(this.company);
        this.startPeriodInfo = (PeriodInfo)this.paramValue.get("startPeriod");
        this.handler.setPeriodInfo(this.startPeriodInfo);
        this.handler.setNumberEditor((ICellEditor)this.getNumberEditor());
        this.handler.initTable(this.tblMain, this.isFirstPeriod);
        this.initUserConfig();
    }

    @Override
    protected void tblMain_editValueChanged(KDTEditEvent e) throws Exception {
        super.tblMain_editValueChanged(e);
    }

    @Override
    protected void tblMain_editStarted(KDTEditEvent e) throws Exception {
        super.tblMain_editStarted(e);
    }

    @Override
    protected void tblMain_editStarting(KDTEditEvent e) throws Exception {
        int selectedCol = this.tblMain.getSelectManager().getActiveColumnIndex();
        int row = this.tblMain.getSelectManager().getActiveRowIndex();
        this.selectedCell = this.tblMain.getCell(row, selectedCol);
        if (this.selectedCell != null && this.selectedCell.getValue() != null) {
            this.oldVal = (BigDecimal)this.selectedCell.getValue();
        }
        super.tblMain_editStarting(e);
    }

    protected void tblMain_editStopped_bak(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        int column = this.tblMain.getColumnIndex("beginBalance");
        Object selectedObject = null;
        if (this.selectedCell != null) {
            selectedObject = this.selectedCell.getValue();
        }
        if (!this.handler.getAccountType().equals((Object)AccountTypeEnum.CASHACCOUNT) && this.tblMain.getSelectManager().getActiveColumnIndex() == column && selectedObject != null) {
            this.changeValue();
        }
        if (selectedObject != null) {
            BigDecimal newVal = (BigDecimal)selectedObject;
            if (this.handler.getBigDecimal(this.oldVal).compareTo(newVal) != 0) {
                this.isEdit = true;
            }
            this.isSave = false;
        }
    }

    @Override
    protected void tblMain_editStopped(KDTEditEvent e) throws Exception {
        super.tblMain_editStopped(e);
        int column = this.tblMain.getColumnIndex("beginBalance");
        Object selectedObject = null;
        if (this.selectedCell != null) {
            selectedObject = this.selectedCell.getValue();
        }
        boolean isNull = false;
        if (selectedObject == null) {
            isNull = true;
        }
        if (!this.handler.getAccountType().equals((Object)AccountTypeEnum.CASHACCOUNT) && this.tblMain.getSelectManager().getActiveColumnIndex() == column) {
            this.changeValue();
            if (isNull) {
                this.selectedCell.setValue(null);
            }
        }
        if (this.oldVal == null && !isNull || this.oldVal != null && isNull) {
            this.isEdit = true;
            this.isSave = false;
        }
        if (this.oldVal != null && !isNull) {
            BigDecimal newVal = this.handler.getBigDecimal(selectedObject);
            if (this.handler.getBigDecimal(this.oldVal).compareTo(newVal) != 0) {
                this.isEdit = true;
            }
            this.isSave = false;
        }
    }

    private void changeValue() {
        int column = this.tblMain.getColumnIndex("adjustJournalBalance");
        int row = this.tblMain.getSelectManager().getActiveRowIndex();
        ICell changedCell = null;
        JournalBalanceInfo initInfo = (JournalBalanceInfo)this.tblMain.getRow(row).getUserObject();
        int scale = this.handler.getCurrency().getPrecision();
        BigDecimal adjustJournalStartAmt = initInfo.getAdjustedJournalMonthStartAmt();
        BigDecimal adjustAcctStatStartAmt = initInfo.getAdjustedASMonthStartAmt();
        BigDecimal oldBeginVal = this.handler.getBigDecimal(initInfo.getMonthStartAmt());
        BigDecimal oldAdjustVal = this.handler.getBigDecimal(adjustJournalStartAmt);
        BigDecimal contrastVal = this.handler.getBigDecimal(adjustAcctStatStartAmt);
        if (this.handler.getAccountType().equals((Object)AccountTypeEnum.ACCTSTATEMENT)) {
            column = this.tblMain.getColumnIndex("adjustASBalance");
            oldAdjustVal = this.handler.getBigDecimal(initInfo.getAdjustedASMonthStartAmt());
            contrastVal = this.handler.getBigDecimalByScale(adjustJournalStartAmt, scale);
        }
        BigDecimal selectedVal = this.handler.getBigDecimal(this.selectedCell.getValue());
        selectedVal = selectedVal.setScale(scale, 6);
        this.selectedCell.setValue((Object)selectedVal);
        changedCell = this.tblMain.getCell(row, column);
        BigDecimal newAdjustVal = oldAdjustVal.setScale(scale, 4).subtract(oldBeginVal.setScale(scale, 4)).add(selectedVal);
        changedCell.setValue((Object)newAdjustVal);
        int isBalColumn = this.tblMain.getColumnIndex("isBalanced");
        ICell isBalCell = this.tblMain.getCell(row, isBalColumn);
        if (newAdjustVal.compareTo(contrastVal) == 0) {
            isBalCell.setValue((Object)Boolean.TRUE);
        } else {
            isBalCell.setValue((Object)Boolean.FALSE);
        }
    }

    public CashMgtInitUI() throws Exception {
        this.company = ContextHelperFactory.getRemoteInstance().getCurrentCompany();
    }

    protected IObjectValue createNewData() {
        return new JournalInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return JournalFactory.getRemoteInstance();
    }

    private void fetchParams(Map param) throws BOSException, EASBizException {
        param.put("ui_name", "CashMgtInitUI");
        param.put("company", null);
        param.put("isStart", null);
        param.put("isGLStart", null);
        param.put("startPeriod", null);
        param.put("currentPeriod", null);
        param.put("baseCurrency", null);
        param.put("currencyCollection", null);
        this.paramValue = BatchFetchParamFacadeFactory.getRemoteInstance().fetchParam(param);
    }

    public void onLoad() throws Exception {
        this.fetchParams(this.paramValue);
        this.company = (CompanyOrgUnitInfo)this.paramValue.get("company");
        this.getMainStatusBar().setPerTitle(this.getSysStatusBarTitle((CoreUI)this));
        this.isAcctTypeFirst = true;
        this.isCurrencyFirst = true;
        this.isLoaded = true;
        this.tblMain.checkParsed();
        this.init();
        this.initUI();
        super.onLoad();
        ItemAction restoreAction = this.tHelper.getActionRestoreDefault(this.tblMain);
        restoreAction.setVisible(false);
        ItemAction showRefAction = this.tHelper.getActionShowPreference(this.tblMain);
        showRefAction.setVisible(false);
        ItemAction saveAction = this.tHelper.getActionSave(this.tblMain);
        saveAction.setVisible(false);
        this.actionSave.setEnabled(false);
        this.isLoaded = false;
        this.btnPrint.setEnabled(true);
        this.btnPrintPreview.setEnabled(true);
        this.menuItemCalculator.setAccelerator(KeyStroke.getKeyStroke("ctrl shift F12"));
    }

    private String getSysStatusBarTitle(CoreUI ui) {
        if (ui == null) {
            return null;
        }
        if (GlUtils.isCompanyUnion((CompanyOrgUnitInfo)this.company)) {
            return null;
        }
        PeriodInfo currentPeriod = (PeriodInfo)this.paramValue.get("currentPeriod");
        if (currentPeriod == null) {
            return null;
        }
        return FMClientHelper.getPeriodString((PeriodInfo)currentPeriod);
    }

    public void onShow() throws Exception {
        super.onShow();
        this.handler.initKDTableFormatter(this.tblMain);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.btnSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_importfromzz"));
        this.btnCalculator.setIcon(EASResource.getIcon((String)"imgTbtn_counter"));
        this.btnUnreachedBankStatement.setIcon(EASResource.getIcon((String)"imgTbtn_qynoarrive"));
        this.btnUnreachedBankBook.setIcon(EASResource.getIcon((String)"imgTbtn_yhnoarrive"));
        this.btnCheckBalance.setIcon(EASResource.getIcon((String)"imgTbtn_balancecheck"));
        this.btnAdjustedBalanceTable.setIcon(EASResource.getIcon((String)"imgTbtn_checkagainst"));
        this.btnFinishInit.setIcon(EASResource.getIcon((String)"imgTbtn_closeinitialize"));
        this.btnInitAgain.setIcon(EASResource.getIcon((String)"imgTbtn_finitialize"));
        this.btnRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.btnRefresh.setText(null);
        this.menuItemRefresh.setIcon(EASResource.getIcon((String)"imgTbtn_refresh"));
        this.ActionImport.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_input"));
        this.actionFinishInit.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_finitialize"));
        this.actionInitAgain.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_finitialize"));
        this.actionCheckBalance.putValue("SmallIcon", EASResource.getIcon((String)"imgTbtn_balancecheck"));
        this.actionCalculator.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_counter"));
        this.actionSubmitOption.putValue("SmallIcon", (Object)EASResource.getIcon((String)"imgTbtn_new"));
        this.kDMenuView.setVisible(false);
    }

    public void finishInit() throws Exception {
        String strPeriodId;
        Vector vecCashMgtFailureReport;
        int flag = -1;
        if (this.isEdit && !this.isSave) {
            flag = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckSaveMsg"));
        }
        switch (flag) {
            case 2: {
                this.btnRefresh_actionPerformed(null);
                return;
            }
            case 1: {
                this.btnRefresh_actionPerformed(null);
            }
            case 0: {
                this.actionSubmit_actionPerformed(null);
            }
        }
        if (this.getIsInit(this.company)) {
            MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"CheckSubmit"));
            this.setWorkButtonForInit(true);
            SysUtil.abort();
        }
        ICashMgtInitFacade iCashMgtInitFacade = CashMgtInitFacadeFactory.getRemoteInstance();
        boolean isRelated = SystemStatusCtrolUtils.isRelAccount(null, (SystemEnum)SystemEnum.CASHMANAGEMENT, (CompanyOrgUnitInfo)this.company);
        if (isRelated && (vecCashMgtFailureReport = iCashMgtInitFacade.getContrastWithGL(this.company.getId().toString(), this.startPeriodInfo.getId().toString())) != null && vecCashMgtFailureReport.size() > 0) {
            String strFail = EASResource.getString((String)resourcePath, (String)"cm22");
            MsgBox.showInfo((Component)((Object)this), (String)strFail);
            return;
        }
        String strCompanyId = this.company.getId().toString();
        boolean isBalanced = iCashMgtInitFacade.checkBankBalance(strCompanyId, strPeriodId = this.startPeriodInfo.getId().toString());
        if (!isBalanced) {
            String strFail = EASResource.getString((String)resourcePath, (String)"cm70");
            MsgBox.showInfo((Component)((Object)this), (String)strFail);
            return;
        }
        iCashMgtInitFacade.finishInit(strCompanyId, strPeriodId);
        this.setWorkButtonForInit(true);
        this.handler.initKDTableFormatter(this.tblMain);
        this.showStatusMessage(EASResource.getString((String)resourcePath, (String)"cm21"));
    }

    private void setWorkButtonForInit(boolean isUsed) {
        this.actionFinishInit.setEnabled(!isUsed);
        this.ActionImport.setEnabled(!isUsed);
        this.actionSave.setEnabled(!isUsed);
        this.actionSubmit.setEnabled(!isUsed);
        this.actionUnreachedBankBook.setEnabled(!isUsed);
        this.actionUnreachedBankStatement.setEnabled(!isUsed);
        this.actionAdjustedBalanceTable.setEnabled(true);
        this.actionInitAgain.setEnabled(isUsed);
        this.tblMain.getStyleAttributes().setLocked(isUsed);
    }

    public void init() throws Exception {
        ClientUtils.checkCompany((Component)((Object)this), this.company);
        this.startPeriodInfo = (PeriodInfo)this.paramValue.get("startPeriod");
        if (this.startPeriodInfo.isIsAdjustPeriod()) {
            MsgBox.showWarning((String)EASResource.getString((String)resourcePath, (String)"startPeriodIsAdjust"));
            SysUtil.abort();
        }
        String[] args = new String[]{String.valueOf(this.startPeriodInfo.getPeriodYear()), String.valueOf(this.startPeriodInfo.getPeriodNumber())};
        MessageFormat mf = new MessageFormat(EASResource.getString((String)"com.kingdee.eas.fi.cas.CasResources", (String)"LBL_Period"));
        String result = mf.format(args);
        this.txtStartPeriod.setText(result);
        this.isFirstPeriod = this.startPeriodInfo.getPeriodNumber() == 1;
        this.cboAccountType.removeItem((Object)AccountTypeEnum.ALL);
        CurrencyCollection currencyCollection = (CurrencyCollection)this.paramValue.get("currencyCollection");
        FMHelper.sortCollection((AbstractObjectCollection)currencyCollection, (String[])new String[]{"number"});
        this.cboCurrency.removeAllItems();
        this.cboCurrency.addItems(currencyCollection.toArray());
        CurrencyInfo currency = (CurrencyInfo)this.paramValue.get("baseCurrency");
        FMClientHelper.setSelectObject((KDComboBox)this.cboCurrency, (Object)currency);
        if (this.getIsInit(this.company)) {
            this.setWorkButtonForInit(true);
        } else {
            this.setWorkButtonForInit(false);
        }
    }

    public IRow getSelectedRow(KDTable tblMain) {
        this.checkSelected();
        KDTSelectBlock selectBlock = tblMain.getSelectManager().get();
        if (selectBlock == null || selectBlock.getTop() == -1) {
            SysUtil.abort();
        }
        IRow row = tblMain.getRow(selectBlock.getTop());
        return row;
    }

    public void checkSelected() {
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public static int CompareTwoPeriod(PeriodInfo periodInfoA, PeriodInfo periodInfoB) {
        int intCompareResult = 0;
        int yearA = periodInfoA.getPeriodYear();
        int yearB = periodInfoB.getPeriodYear();
        int monthA = periodInfoA.getPeriodNumber();
        int monthB = periodInfoB.getPeriodNumber();
        if (yearA < yearB || yearA == yearB && monthA < monthB) {
            intCompareResult = -1;
        } else if (yearA == yearB && monthA == monthB) {
            intCompareResult = 0;
        } else if (yearA > yearB || yearA == yearB && monthA > monthB) {
            intCompareResult = 1;
        }
        return intCompareResult;
    }

    public boolean checkBeforeWindowClosing() {
        int flag = -1;
        if (this.isEdit && !this.isSave) {
            flag = MsgBox.showConfirm3((Component)((Object)this), (String)EASResource.getString((String)resourcePath, (String)"CheckSaveAndExit"));
        }
        this.savePrintSetting(this.getTableForPrintSetting());
        switch (flag) {
            case 0: {
                this.saveData();
                return super.checkBeforeWindowClosing();
            }
            case 1: {
                return super.checkBeforeWindowClosing();
            }
            case 2: {
                return false;
            }
        }
        return true;
    }

    private void saveData() {
        try {
            if (this.getIsInit(this.company)) {
                MsgBox.showInfo((String)EASResource.getString((String)resourcePath, (String)"CheckSubmit"));
                SysUtil.abort();
            }
            this.handler.storeField(this.tblMain);
        }
        catch (Exception e) {
            this.handUIExceptionAndAbort(e);
        }
    }

    protected void preparePrintPageHeader(HeadFootModel headerModel) {
        String sBank = this.lblAccountType.getBoundLabelText() + ": &[type] ";
        String sCurrency = this.lblCurrency.getBoundLabelText() + ": &[currency]";
        String sAccount = this.lblStartPeriod.getBoundLabelText() + " &[startPeriod]";
        headerModel.addRow(sBank + "&|" + sCurrency + "&|" + sAccount);
    }

    protected ExtVarProvider getPrintExtVarProvider() {
        class MyExtVarProvider
        implements ExtVarProvider {
            Map varMap = null;

            MyExtVarProvider() {
                this.initVarMap();
            }

            private void initVarMap() {
                this.varMap = CashMgtInitUI.this.preparePrintVariantMap();
            }

            public Variant requestVarData(String varName) {
                if (CashMgtInitUI.this.shouldReloadPrintVar) {
                    this.initVarMap();
                }
                if (this.varMap == null) {
                    return null;
                }
                Object obj = this.varMap.get(varName);
                if (!(obj instanceof Variant)) {
                    Variant v = new Variant();
                    v.setObject(obj);
                    return v;
                }
                return (Variant)obj;
            }
        }
        return new MyExtVarProvider();
    }

    private Map preparePrintVariantMap() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("type", this.cboAccountType.getSelectedItem());
        hm.put("currency", this.cboCurrency.getSelectedItem());
        hm.put("startPeriod", this.txtStartPeriod.getText());
        return hm;
    }

    protected KDTable getTableForPrintSetting() {
        return this.tblMain;
    }

    public void actionPrint_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrint_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().print();
    }

    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception {
        super.actionPrintPreview_actionPerformed(e);
        this.preparePrintPage(this.tblMain);
        this.tblMain.getPrintManager().printPreview();
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Company;
    }
}

